# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EciScalingConfigurationArgs', 'EciScalingConfiguration']

@pulumi.input_type
class EciScalingConfigurationArgs:
    def __init__(__self__, *,
                 scaling_group_id: pulumi.Input[_builtins.str],
                 acr_registry_infos: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationAcrRegistryInfoArgs']]]] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 active_deadline_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_create_eip: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_match_image_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 container_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerArgs']]]] = None,
                 cost_optimization: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu: Optional[pulumi.Input[_builtins.float]] = None,
                 cpu_options_core: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_options_threads_per_core: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_config_options: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationDnsConfigOptionArgs']]]] = None,
                 dns_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 egress_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 eip_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_sls: Optional[pulumi.Input[_builtins.bool]] = None,
                 ephemeral_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_aliases: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationHostAliasArgs']]]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_registry_credentials: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationImageRegistryCredentialArgs']]]] = None,
                 image_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerArgs']]]] = None,
                 instance_family_level: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv6_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 load_balancer_weight: Optional[pulumi.Input[_builtins.int]] = None,
                 memory: Optional[pulumi.Input[_builtins.float]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restart_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_context_sysctls: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationSecurityContextSysctlArgs']]]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_price_limit: Optional[pulumi.Input[_builtins.float]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationVolumeArgs']]]] = None):
        """
        The set of arguments for constructing a EciScalingConfiguration resource.
        :param pulumi.Input[_builtins.str] scaling_group_id: ID of the scaling group of a eci scaling configuration.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationAcrRegistryInfoArgs']]] acr_registry_infos: Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
        :param pulumi.Input[_builtins.bool] active: Whether active current eci scaling configuration in the specified scaling group. Note that only
               one configuration can be active. Default to `false`.
        :param pulumi.Input[_builtins.int] active_deadline_seconds: The duration in seconds relative to the startTime that the job may be active before the system tries to terminate it.
        :param pulumi.Input[_builtins.bool] auto_create_eip: Whether create eip automatically.
        :param pulumi.Input[_builtins.bool] auto_match_image_cache: Whether to automatically match the image cache.
        :param pulumi.Input[_builtins.str] container_group_name: The name series of the elastic container instances created from the scaling configuration. If you want to use an ordered instance name, specify the value for this parameter in the following format: name_prefix(AUTO_INCREMENT)[begin_number,bits]name_suffix.
               name_prefix: the prefix of the hostname.
               (AUTO_INCREMENT): the sort method. This is a static field.
               begin_number: the start value of the sequential values. Valid values: 0 to 999999.
               bits: the number of digits in sequential values. Valid values: 1 to 6. If the number of digits in the specified begin_number value is greater than the value of the bits field, the bits field is automatically set to 6.
               name_suffix: the suffix of the hostname. This field is optional.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerArgs']]] containers: The list of containers. See `containers` below for details.
        :param pulumi.Input[_builtins.bool] cost_optimization: Indicates whether the Cost Optimization feature is enabled. Valid values: true,false.
        :param pulumi.Input[_builtins.float] cpu: The amount of CPU resources allocated to the container group.
        :param pulumi.Input[_builtins.int] cpu_options_core: The number of physical CPU cores. You can specify this parameter for only specific instance types.
        :param pulumi.Input[_builtins.int] cpu_options_threads_per_core: The number of threads per core. You can specify this parameter for only specific instance types. If you set this parameter to 1, Hyper-Threading is disabled.
        :param pulumi.Input[_builtins.str] description: The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to
               256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationDnsConfigOptionArgs']]] dns_config_options: The options. Each option is a name-value pair. The value in the name-value pair is optional.   See `dns_config_options` below for
               details.
        :param pulumi.Input[_builtins.str] dns_policy: dns policy of contain group.
        :param pulumi.Input[_builtins.int] egress_bandwidth: egress bandwidth.
        :param pulumi.Input[_builtins.int] eip_bandwidth: Eip bandwidth.
        :param pulumi.Input[_builtins.bool] enable_sls: Enable sls log service.
        :param pulumi.Input[_builtins.int] ephemeral_storage: The size of ephemeral storage.
        :param pulumi.Input[_builtins.bool] force_delete: The eci scaling configuration will be deleted forcibly with deleting its scaling group.
               Default to false.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationHostAliasArgs']]] host_aliases: HostAliases. See `host_aliases` below.
        :param pulumi.Input[_builtins.str] host_name: Hostname of an ECI instance.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationImageRegistryCredentialArgs']]] image_registry_credentials: The image registry credential.   See `image_registry_credentials` below for
               details.
        :param pulumi.Input[_builtins.str] image_snapshot_id: The ID of image cache.
        :param pulumi.Input[_builtins.int] ingress_bandwidth: Ingress bandwidth.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerArgs']]] init_containers: The list of initContainers. See `init_containers` below for details.
        :param pulumi.Input[_builtins.str] instance_family_level: The level of the instance family, which is used to filter instance types that meet the specified criteria. This parameter takes effect only if you set CostOptimization to true. Valid values: EntryLevel, EnterpriseLevel, CreditEntryLevel.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: The specified ECS instance types. You can specify up to five ECS instance types.
        :param pulumi.Input[_builtins.int] ipv6_address_count: Number of IPv6 addresses.
        :param pulumi.Input[_builtins.int] load_balancer_weight: The weight of an ECI instance attached to the Server Group.
        :param pulumi.Input[_builtins.float] memory: The amount of memory resources allocated to the container group.
        :param pulumi.Input[_builtins.str] ram_role_name: The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        :param pulumi.Input[_builtins.str] resource_group_id: ID of resource group.
        :param pulumi.Input[_builtins.str] restart_policy: The restart policy of the container group. Default to `Always`.
        :param pulumi.Input[_builtins.str] scaling_configuration_name: Name shown for the scheduled task. which must contain 2-64 characters (
               English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number,
               underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is
               EciScalingConfigurationId.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationSecurityContextSysctlArgs']]] security_context_sysctls: The system information about the security context in which the elastic container instance is run.   See `security_context_sysctls` below for
               details.
        :param pulumi.Input[_builtins.str] security_group_id: ID of the security group used to create new instance. It is conflict
               with `security_group_ids`.
        :param pulumi.Input[_builtins.float] spot_price_limit: The maximum price hourly for spot instance.
        :param pulumi.Input[_builtins.str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`
               , `SpotWithPriceLimit`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. It will be applied for ECI instances finally.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot
               be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be
               a null string.
        :param pulumi.Input[_builtins.int] termination_grace_period_seconds: The program's buffering time before closing.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationVolumeArgs']]] volumes: The list of volumes. See `volumes` below for details.
        """
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if acr_registry_infos is not None:
            pulumi.set(__self__, "acr_registry_infos", acr_registry_infos)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if active_deadline_seconds is not None:
            pulumi.set(__self__, "active_deadline_seconds", active_deadline_seconds)
        if auto_create_eip is not None:
            pulumi.set(__self__, "auto_create_eip", auto_create_eip)
        if auto_match_image_cache is not None:
            pulumi.set(__self__, "auto_match_image_cache", auto_match_image_cache)
        if container_group_name is not None:
            pulumi.set(__self__, "container_group_name", container_group_name)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if cost_optimization is not None:
            pulumi.set(__self__, "cost_optimization", cost_optimization)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if cpu_options_core is not None:
            pulumi.set(__self__, "cpu_options_core", cpu_options_core)
        if cpu_options_threads_per_core is not None:
            pulumi.set(__self__, "cpu_options_threads_per_core", cpu_options_threads_per_core)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_config_options is not None:
            pulumi.set(__self__, "dns_config_options", dns_config_options)
        if dns_policy is not None:
            pulumi.set(__self__, "dns_policy", dns_policy)
        if egress_bandwidth is not None:
            pulumi.set(__self__, "egress_bandwidth", egress_bandwidth)
        if eip_bandwidth is not None:
            pulumi.set(__self__, "eip_bandwidth", eip_bandwidth)
        if enable_sls is not None:
            pulumi.set(__self__, "enable_sls", enable_sls)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if host_aliases is not None:
            pulumi.set(__self__, "host_aliases", host_aliases)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if image_registry_credentials is not None:
            pulumi.set(__self__, "image_registry_credentials", image_registry_credentials)
        if image_snapshot_id is not None:
            pulumi.set(__self__, "image_snapshot_id", image_snapshot_id)
        if ingress_bandwidth is not None:
            pulumi.set(__self__, "ingress_bandwidth", ingress_bandwidth)
        if init_containers is not None:
            pulumi.set(__self__, "init_containers", init_containers)
        if instance_family_level is not None:
            pulumi.set(__self__, "instance_family_level", instance_family_level)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if load_balancer_weight is not None:
            pulumi.set(__self__, "load_balancer_weight", load_balancer_weight)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if ram_role_name is not None:
            pulumi.set(__self__, "ram_role_name", ram_role_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)
        if scaling_configuration_name is not None:
            pulumi.set(__self__, "scaling_configuration_name", scaling_configuration_name)
        if security_context_sysctls is not None:
            pulumi.set(__self__, "security_context_sysctls", security_context_sysctls)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if spot_price_limit is not None:
            pulumi.set(__self__, "spot_price_limit", spot_price_limit)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the scaling group of a eci scaling configuration.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scaling_group_id", value)

    @_builtins.property
    @pulumi.getter(name="acrRegistryInfos")
    def acr_registry_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationAcrRegistryInfoArgs']]]]:
        """
        Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
        """
        return pulumi.get(self, "acr_registry_infos")

    @acr_registry_infos.setter
    def acr_registry_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationAcrRegistryInfoArgs']]]]):
        pulumi.set(self, "acr_registry_infos", value)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether active current eci scaling configuration in the specified scaling group. Note that only
        one configuration can be active. Default to `false`.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active", value)

    @_builtins.property
    @pulumi.getter(name="activeDeadlineSeconds")
    def active_deadline_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration in seconds relative to the startTime that the job may be active before the system tries to terminate it.
        """
        return pulumi.get(self, "active_deadline_seconds")

    @active_deadline_seconds.setter
    def active_deadline_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "active_deadline_seconds", value)

    @_builtins.property
    @pulumi.getter(name="autoCreateEip")
    def auto_create_eip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether create eip automatically.
        """
        return pulumi.get(self, "auto_create_eip")

    @auto_create_eip.setter
    def auto_create_eip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_create_eip", value)

    @_builtins.property
    @pulumi.getter(name="autoMatchImageCache")
    def auto_match_image_cache(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to automatically match the image cache.
        """
        return pulumi.get(self, "auto_match_image_cache")

    @auto_match_image_cache.setter
    def auto_match_image_cache(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_match_image_cache", value)

    @_builtins.property
    @pulumi.getter(name="containerGroupName")
    def container_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name series of the elastic container instances created from the scaling configuration. If you want to use an ordered instance name, specify the value for this parameter in the following format: name_prefix(AUTO_INCREMENT)[begin_number,bits]name_suffix.
        name_prefix: the prefix of the hostname.
        (AUTO_INCREMENT): the sort method. This is a static field.
        begin_number: the start value of the sequential values. Valid values: 0 to 999999.
        bits: the number of digits in sequential values. Valid values: 1 to 6. If the number of digits in the specified begin_number value is greater than the value of the bits field, the bits field is automatically set to 6.
        name_suffix: the suffix of the hostname. This field is optional.
        """
        return pulumi.get(self, "container_group_name")

    @container_group_name.setter
    def container_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_group_name", value)

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerArgs']]]]:
        """
        The list of containers. See `containers` below for details.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @_builtins.property
    @pulumi.getter(name="costOptimization")
    def cost_optimization(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the Cost Optimization feature is enabled. Valid values: true,false.
        """
        return pulumi.get(self, "cost_optimization")

    @cost_optimization.setter
    def cost_optimization(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cost_optimization", value)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The amount of CPU resources allocated to the container group.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter(name="cpuOptionsCore")
    def cpu_options_core(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of physical CPU cores. You can specify this parameter for only specific instance types.
        """
        return pulumi.get(self, "cpu_options_core")

    @cpu_options_core.setter
    def cpu_options_core(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_options_core", value)

    @_builtins.property
    @pulumi.getter(name="cpuOptionsThreadsPerCore")
    def cpu_options_threads_per_core(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of threads per core. You can specify this parameter for only specific instance types. If you set this parameter to 1, Hyper-Threading is disabled.
        """
        return pulumi.get(self, "cpu_options_threads_per_core")

    @cpu_options_threads_per_core.setter
    def cpu_options_threads_per_core(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_options_threads_per_core", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to
        256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dnsConfigOptions")
    def dns_config_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationDnsConfigOptionArgs']]]]:
        """
        The options. Each option is a name-value pair. The value in the name-value pair is optional.   See `dns_config_options` below for
        details.
        """
        return pulumi.get(self, "dns_config_options")

    @dns_config_options.setter
    def dns_config_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationDnsConfigOptionArgs']]]]):
        pulumi.set(self, "dns_config_options", value)

    @_builtins.property
    @pulumi.getter(name="dnsPolicy")
    def dns_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        dns policy of contain group.
        """
        return pulumi.get(self, "dns_policy")

    @dns_policy.setter
    def dns_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_policy", value)

    @_builtins.property
    @pulumi.getter(name="egressBandwidth")
    def egress_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        egress bandwidth.
        """
        return pulumi.get(self, "egress_bandwidth")

    @egress_bandwidth.setter
    def egress_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "egress_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Eip bandwidth.
        """
        return pulumi.get(self, "eip_bandwidth")

    @eip_bandwidth.setter
    def eip_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "eip_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="enableSls")
    def enable_sls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable sls log service.
        """
        return pulumi.get(self, "enable_sls")

    @enable_sls.setter
    def enable_sls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_sls", value)

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of ephemeral storage.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ephemeral_storage", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The eci scaling configuration will be deleted forcibly with deleting its scaling group.
        Default to false.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="hostAliases")
    def host_aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationHostAliasArgs']]]]:
        """
        HostAliases. See `host_aliases` below.
        """
        return pulumi.get(self, "host_aliases")

    @host_aliases.setter
    def host_aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationHostAliasArgs']]]]):
        pulumi.set(self, "host_aliases", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Hostname of an ECI instance.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter(name="imageRegistryCredentials")
    def image_registry_credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationImageRegistryCredentialArgs']]]]:
        """
        The image registry credential.   See `image_registry_credentials` below for
        details.
        """
        return pulumi.get(self, "image_registry_credentials")

    @image_registry_credentials.setter
    def image_registry_credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationImageRegistryCredentialArgs']]]]):
        pulumi.set(self, "image_registry_credentials", value)

    @_builtins.property
    @pulumi.getter(name="imageSnapshotId")
    def image_snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of image cache.
        """
        return pulumi.get(self, "image_snapshot_id")

    @image_snapshot_id.setter
    def image_snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="ingressBandwidth")
    def ingress_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Ingress bandwidth.
        """
        return pulumi.get(self, "ingress_bandwidth")

    @ingress_bandwidth.setter
    def ingress_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ingress_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerArgs']]]]:
        """
        The list of initContainers. See `init_containers` below for details.
        """
        return pulumi.get(self, "init_containers")

    @init_containers.setter
    def init_containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerArgs']]]]):
        pulumi.set(self, "init_containers", value)

    @_builtins.property
    @pulumi.getter(name="instanceFamilyLevel")
    def instance_family_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The level of the instance family, which is used to filter instance types that meet the specified criteria. This parameter takes effect only if you set CostOptimization to true. Valid values: EntryLevel, EnterpriseLevel, CreditEntryLevel.
        """
        return pulumi.get(self, "instance_family_level")

    @instance_family_level.setter
    def instance_family_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_family_level", value)

    @_builtins.property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The specified ECS instance types. You can specify up to five ECS instance types.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instance_types", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of IPv6 addresses.
        """
        return pulumi.get(self, "ipv6_address_count")

    @ipv6_address_count.setter
    def ipv6_address_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv6_address_count", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerWeight")
    def load_balancer_weight(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The weight of an ECI instance attached to the Server Group.
        """
        return pulumi.get(self, "load_balancer_weight")

    @load_balancer_weight.setter
    def load_balancer_weight(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "load_balancer_weight", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The amount of memory resources allocated to the container group.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        """
        return pulumi.get(self, "ram_role_name")

    @ram_role_name.setter
    def ram_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ram_role_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The restart policy of the container group. Default to `Always`.
        """
        return pulumi.get(self, "restart_policy")

    @restart_policy.setter
    def restart_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restart_policy", value)

    @_builtins.property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name shown for the scheduled task. which must contain 2-64 characters (
        English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number,
        underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is
        EciScalingConfigurationId.
        """
        return pulumi.get(self, "scaling_configuration_name")

    @scaling_configuration_name.setter
    def scaling_configuration_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_configuration_name", value)

    @_builtins.property
    @pulumi.getter(name="securityContextSysctls")
    def security_context_sysctls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationSecurityContextSysctlArgs']]]]:
        """
        The system information about the security context in which the elastic container instance is run.   See `security_context_sysctls` below for
        details.
        """
        return pulumi.get(self, "security_context_sysctls")

    @security_context_sysctls.setter
    def security_context_sysctls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationSecurityContextSysctlArgs']]]]):
        pulumi.set(self, "security_context_sysctls", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the security group used to create new instance. It is conflict
        with `security_group_ids`.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The maximum price hourly for spot instance.
        """
        return pulumi.get(self, "spot_price_limit")

    @spot_price_limit.setter
    def spot_price_limit(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "spot_price_limit", value)

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`
        , `SpotWithPriceLimit`.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_strategy", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource. It will be applied for ECI instances finally.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot
        be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be
        a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The program's buffering time before closing.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @termination_grace_period_seconds.setter
    def termination_grace_period_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "termination_grace_period_seconds", value)

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationVolumeArgs']]]]:
        """
        The list of volumes. See `volumes` below for details.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.input_type
class _EciScalingConfigurationState:
    def __init__(__self__, *,
                 acr_registry_infos: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationAcrRegistryInfoArgs']]]] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 active_deadline_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_create_eip: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_match_image_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 container_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerArgs']]]] = None,
                 cost_optimization: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu: Optional[pulumi.Input[_builtins.float]] = None,
                 cpu_options_core: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_options_threads_per_core: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_config_options: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationDnsConfigOptionArgs']]]] = None,
                 dns_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 egress_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 eip_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_sls: Optional[pulumi.Input[_builtins.bool]] = None,
                 ephemeral_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_aliases: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationHostAliasArgs']]]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_registry_credentials: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationImageRegistryCredentialArgs']]]] = None,
                 image_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerArgs']]]] = None,
                 instance_family_level: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv6_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 load_balancer_weight: Optional[pulumi.Input[_builtins.int]] = None,
                 memory: Optional[pulumi.Input[_builtins.float]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restart_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_context_sysctls: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationSecurityContextSysctlArgs']]]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_price_limit: Optional[pulumi.Input[_builtins.float]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationVolumeArgs']]]] = None):
        """
        Input properties used for looking up and filtering EciScalingConfiguration resources.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationAcrRegistryInfoArgs']]] acr_registry_infos: Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
        :param pulumi.Input[_builtins.bool] active: Whether active current eci scaling configuration in the specified scaling group. Note that only
               one configuration can be active. Default to `false`.
        :param pulumi.Input[_builtins.int] active_deadline_seconds: The duration in seconds relative to the startTime that the job may be active before the system tries to terminate it.
        :param pulumi.Input[_builtins.bool] auto_create_eip: Whether create eip automatically.
        :param pulumi.Input[_builtins.bool] auto_match_image_cache: Whether to automatically match the image cache.
        :param pulumi.Input[_builtins.str] container_group_name: The name series of the elastic container instances created from the scaling configuration. If you want to use an ordered instance name, specify the value for this parameter in the following format: name_prefix(AUTO_INCREMENT)[begin_number,bits]name_suffix.
               name_prefix: the prefix of the hostname.
               (AUTO_INCREMENT): the sort method. This is a static field.
               begin_number: the start value of the sequential values. Valid values: 0 to 999999.
               bits: the number of digits in sequential values. Valid values: 1 to 6. If the number of digits in the specified begin_number value is greater than the value of the bits field, the bits field is automatically set to 6.
               name_suffix: the suffix of the hostname. This field is optional.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerArgs']]] containers: The list of containers. See `containers` below for details.
        :param pulumi.Input[_builtins.bool] cost_optimization: Indicates whether the Cost Optimization feature is enabled. Valid values: true,false.
        :param pulumi.Input[_builtins.float] cpu: The amount of CPU resources allocated to the container group.
        :param pulumi.Input[_builtins.int] cpu_options_core: The number of physical CPU cores. You can specify this parameter for only specific instance types.
        :param pulumi.Input[_builtins.int] cpu_options_threads_per_core: The number of threads per core. You can specify this parameter for only specific instance types. If you set this parameter to 1, Hyper-Threading is disabled.
        :param pulumi.Input[_builtins.str] description: The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to
               256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationDnsConfigOptionArgs']]] dns_config_options: The options. Each option is a name-value pair. The value in the name-value pair is optional.   See `dns_config_options` below for
               details.
        :param pulumi.Input[_builtins.str] dns_policy: dns policy of contain group.
        :param pulumi.Input[_builtins.int] egress_bandwidth: egress bandwidth.
        :param pulumi.Input[_builtins.int] eip_bandwidth: Eip bandwidth.
        :param pulumi.Input[_builtins.bool] enable_sls: Enable sls log service.
        :param pulumi.Input[_builtins.int] ephemeral_storage: The size of ephemeral storage.
        :param pulumi.Input[_builtins.bool] force_delete: The eci scaling configuration will be deleted forcibly with deleting its scaling group.
               Default to false.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationHostAliasArgs']]] host_aliases: HostAliases. See `host_aliases` below.
        :param pulumi.Input[_builtins.str] host_name: Hostname of an ECI instance.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationImageRegistryCredentialArgs']]] image_registry_credentials: The image registry credential.   See `image_registry_credentials` below for
               details.
        :param pulumi.Input[_builtins.str] image_snapshot_id: The ID of image cache.
        :param pulumi.Input[_builtins.int] ingress_bandwidth: Ingress bandwidth.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerArgs']]] init_containers: The list of initContainers. See `init_containers` below for details.
        :param pulumi.Input[_builtins.str] instance_family_level: The level of the instance family, which is used to filter instance types that meet the specified criteria. This parameter takes effect only if you set CostOptimization to true. Valid values: EntryLevel, EnterpriseLevel, CreditEntryLevel.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: The specified ECS instance types. You can specify up to five ECS instance types.
        :param pulumi.Input[_builtins.int] ipv6_address_count: Number of IPv6 addresses.
        :param pulumi.Input[_builtins.int] load_balancer_weight: The weight of an ECI instance attached to the Server Group.
        :param pulumi.Input[_builtins.float] memory: The amount of memory resources allocated to the container group.
        :param pulumi.Input[_builtins.str] ram_role_name: The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        :param pulumi.Input[_builtins.str] resource_group_id: ID of resource group.
        :param pulumi.Input[_builtins.str] restart_policy: The restart policy of the container group. Default to `Always`.
        :param pulumi.Input[_builtins.str] scaling_configuration_name: Name shown for the scheduled task. which must contain 2-64 characters (
               English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number,
               underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is
               EciScalingConfigurationId.
        :param pulumi.Input[_builtins.str] scaling_group_id: ID of the scaling group of a eci scaling configuration.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationSecurityContextSysctlArgs']]] security_context_sysctls: The system information about the security context in which the elastic container instance is run.   See `security_context_sysctls` below for
               details.
        :param pulumi.Input[_builtins.str] security_group_id: ID of the security group used to create new instance. It is conflict
               with `security_group_ids`.
        :param pulumi.Input[_builtins.float] spot_price_limit: The maximum price hourly for spot instance.
        :param pulumi.Input[_builtins.str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`
               , `SpotWithPriceLimit`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. It will be applied for ECI instances finally.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot
               be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be
               a null string.
        :param pulumi.Input[_builtins.int] termination_grace_period_seconds: The program's buffering time before closing.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationVolumeArgs']]] volumes: The list of volumes. See `volumes` below for details.
        """
        if acr_registry_infos is not None:
            pulumi.set(__self__, "acr_registry_infos", acr_registry_infos)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if active_deadline_seconds is not None:
            pulumi.set(__self__, "active_deadline_seconds", active_deadline_seconds)
        if auto_create_eip is not None:
            pulumi.set(__self__, "auto_create_eip", auto_create_eip)
        if auto_match_image_cache is not None:
            pulumi.set(__self__, "auto_match_image_cache", auto_match_image_cache)
        if container_group_name is not None:
            pulumi.set(__self__, "container_group_name", container_group_name)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if cost_optimization is not None:
            pulumi.set(__self__, "cost_optimization", cost_optimization)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if cpu_options_core is not None:
            pulumi.set(__self__, "cpu_options_core", cpu_options_core)
        if cpu_options_threads_per_core is not None:
            pulumi.set(__self__, "cpu_options_threads_per_core", cpu_options_threads_per_core)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_config_options is not None:
            pulumi.set(__self__, "dns_config_options", dns_config_options)
        if dns_policy is not None:
            pulumi.set(__self__, "dns_policy", dns_policy)
        if egress_bandwidth is not None:
            pulumi.set(__self__, "egress_bandwidth", egress_bandwidth)
        if eip_bandwidth is not None:
            pulumi.set(__self__, "eip_bandwidth", eip_bandwidth)
        if enable_sls is not None:
            pulumi.set(__self__, "enable_sls", enable_sls)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if host_aliases is not None:
            pulumi.set(__self__, "host_aliases", host_aliases)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if image_registry_credentials is not None:
            pulumi.set(__self__, "image_registry_credentials", image_registry_credentials)
        if image_snapshot_id is not None:
            pulumi.set(__self__, "image_snapshot_id", image_snapshot_id)
        if ingress_bandwidth is not None:
            pulumi.set(__self__, "ingress_bandwidth", ingress_bandwidth)
        if init_containers is not None:
            pulumi.set(__self__, "init_containers", init_containers)
        if instance_family_level is not None:
            pulumi.set(__self__, "instance_family_level", instance_family_level)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if load_balancer_weight is not None:
            pulumi.set(__self__, "load_balancer_weight", load_balancer_weight)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if ram_role_name is not None:
            pulumi.set(__self__, "ram_role_name", ram_role_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)
        if scaling_configuration_name is not None:
            pulumi.set(__self__, "scaling_configuration_name", scaling_configuration_name)
        if scaling_group_id is not None:
            pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if security_context_sysctls is not None:
            pulumi.set(__self__, "security_context_sysctls", security_context_sysctls)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if spot_price_limit is not None:
            pulumi.set(__self__, "spot_price_limit", spot_price_limit)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter(name="acrRegistryInfos")
    def acr_registry_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationAcrRegistryInfoArgs']]]]:
        """
        Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
        """
        return pulumi.get(self, "acr_registry_infos")

    @acr_registry_infos.setter
    def acr_registry_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationAcrRegistryInfoArgs']]]]):
        pulumi.set(self, "acr_registry_infos", value)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether active current eci scaling configuration in the specified scaling group. Note that only
        one configuration can be active. Default to `false`.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active", value)

    @_builtins.property
    @pulumi.getter(name="activeDeadlineSeconds")
    def active_deadline_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration in seconds relative to the startTime that the job may be active before the system tries to terminate it.
        """
        return pulumi.get(self, "active_deadline_seconds")

    @active_deadline_seconds.setter
    def active_deadline_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "active_deadline_seconds", value)

    @_builtins.property
    @pulumi.getter(name="autoCreateEip")
    def auto_create_eip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether create eip automatically.
        """
        return pulumi.get(self, "auto_create_eip")

    @auto_create_eip.setter
    def auto_create_eip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_create_eip", value)

    @_builtins.property
    @pulumi.getter(name="autoMatchImageCache")
    def auto_match_image_cache(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to automatically match the image cache.
        """
        return pulumi.get(self, "auto_match_image_cache")

    @auto_match_image_cache.setter
    def auto_match_image_cache(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_match_image_cache", value)

    @_builtins.property
    @pulumi.getter(name="containerGroupName")
    def container_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name series of the elastic container instances created from the scaling configuration. If you want to use an ordered instance name, specify the value for this parameter in the following format: name_prefix(AUTO_INCREMENT)[begin_number,bits]name_suffix.
        name_prefix: the prefix of the hostname.
        (AUTO_INCREMENT): the sort method. This is a static field.
        begin_number: the start value of the sequential values. Valid values: 0 to 999999.
        bits: the number of digits in sequential values. Valid values: 1 to 6. If the number of digits in the specified begin_number value is greater than the value of the bits field, the bits field is automatically set to 6.
        name_suffix: the suffix of the hostname. This field is optional.
        """
        return pulumi.get(self, "container_group_name")

    @container_group_name.setter
    def container_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_group_name", value)

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerArgs']]]]:
        """
        The list of containers. See `containers` below for details.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @_builtins.property
    @pulumi.getter(name="costOptimization")
    def cost_optimization(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the Cost Optimization feature is enabled. Valid values: true,false.
        """
        return pulumi.get(self, "cost_optimization")

    @cost_optimization.setter
    def cost_optimization(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cost_optimization", value)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The amount of CPU resources allocated to the container group.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter(name="cpuOptionsCore")
    def cpu_options_core(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of physical CPU cores. You can specify this parameter for only specific instance types.
        """
        return pulumi.get(self, "cpu_options_core")

    @cpu_options_core.setter
    def cpu_options_core(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_options_core", value)

    @_builtins.property
    @pulumi.getter(name="cpuOptionsThreadsPerCore")
    def cpu_options_threads_per_core(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of threads per core. You can specify this parameter for only specific instance types. If you set this parameter to 1, Hyper-Threading is disabled.
        """
        return pulumi.get(self, "cpu_options_threads_per_core")

    @cpu_options_threads_per_core.setter
    def cpu_options_threads_per_core(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_options_threads_per_core", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to
        256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dnsConfigOptions")
    def dns_config_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationDnsConfigOptionArgs']]]]:
        """
        The options. Each option is a name-value pair. The value in the name-value pair is optional.   See `dns_config_options` below for
        details.
        """
        return pulumi.get(self, "dns_config_options")

    @dns_config_options.setter
    def dns_config_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationDnsConfigOptionArgs']]]]):
        pulumi.set(self, "dns_config_options", value)

    @_builtins.property
    @pulumi.getter(name="dnsPolicy")
    def dns_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        dns policy of contain group.
        """
        return pulumi.get(self, "dns_policy")

    @dns_policy.setter
    def dns_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_policy", value)

    @_builtins.property
    @pulumi.getter(name="egressBandwidth")
    def egress_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        egress bandwidth.
        """
        return pulumi.get(self, "egress_bandwidth")

    @egress_bandwidth.setter
    def egress_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "egress_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Eip bandwidth.
        """
        return pulumi.get(self, "eip_bandwidth")

    @eip_bandwidth.setter
    def eip_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "eip_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="enableSls")
    def enable_sls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable sls log service.
        """
        return pulumi.get(self, "enable_sls")

    @enable_sls.setter
    def enable_sls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_sls", value)

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of ephemeral storage.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ephemeral_storage", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The eci scaling configuration will be deleted forcibly with deleting its scaling group.
        Default to false.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="hostAliases")
    def host_aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationHostAliasArgs']]]]:
        """
        HostAliases. See `host_aliases` below.
        """
        return pulumi.get(self, "host_aliases")

    @host_aliases.setter
    def host_aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationHostAliasArgs']]]]):
        pulumi.set(self, "host_aliases", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Hostname of an ECI instance.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter(name="imageRegistryCredentials")
    def image_registry_credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationImageRegistryCredentialArgs']]]]:
        """
        The image registry credential.   See `image_registry_credentials` below for
        details.
        """
        return pulumi.get(self, "image_registry_credentials")

    @image_registry_credentials.setter
    def image_registry_credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationImageRegistryCredentialArgs']]]]):
        pulumi.set(self, "image_registry_credentials", value)

    @_builtins.property
    @pulumi.getter(name="imageSnapshotId")
    def image_snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of image cache.
        """
        return pulumi.get(self, "image_snapshot_id")

    @image_snapshot_id.setter
    def image_snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="ingressBandwidth")
    def ingress_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Ingress bandwidth.
        """
        return pulumi.get(self, "ingress_bandwidth")

    @ingress_bandwidth.setter
    def ingress_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ingress_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerArgs']]]]:
        """
        The list of initContainers. See `init_containers` below for details.
        """
        return pulumi.get(self, "init_containers")

    @init_containers.setter
    def init_containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerArgs']]]]):
        pulumi.set(self, "init_containers", value)

    @_builtins.property
    @pulumi.getter(name="instanceFamilyLevel")
    def instance_family_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The level of the instance family, which is used to filter instance types that meet the specified criteria. This parameter takes effect only if you set CostOptimization to true. Valid values: EntryLevel, EnterpriseLevel, CreditEntryLevel.
        """
        return pulumi.get(self, "instance_family_level")

    @instance_family_level.setter
    def instance_family_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_family_level", value)

    @_builtins.property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The specified ECS instance types. You can specify up to five ECS instance types.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instance_types", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of IPv6 addresses.
        """
        return pulumi.get(self, "ipv6_address_count")

    @ipv6_address_count.setter
    def ipv6_address_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv6_address_count", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerWeight")
    def load_balancer_weight(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The weight of an ECI instance attached to the Server Group.
        """
        return pulumi.get(self, "load_balancer_weight")

    @load_balancer_weight.setter
    def load_balancer_weight(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "load_balancer_weight", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The amount of memory resources allocated to the container group.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        """
        return pulumi.get(self, "ram_role_name")

    @ram_role_name.setter
    def ram_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ram_role_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The restart policy of the container group. Default to `Always`.
        """
        return pulumi.get(self, "restart_policy")

    @restart_policy.setter
    def restart_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restart_policy", value)

    @_builtins.property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name shown for the scheduled task. which must contain 2-64 characters (
        English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number,
        underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is
        EciScalingConfigurationId.
        """
        return pulumi.get(self, "scaling_configuration_name")

    @scaling_configuration_name.setter
    def scaling_configuration_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_configuration_name", value)

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the scaling group of a eci scaling configuration.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityContextSysctls")
    def security_context_sysctls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationSecurityContextSysctlArgs']]]]:
        """
        The system information about the security context in which the elastic container instance is run.   See `security_context_sysctls` below for
        details.
        """
        return pulumi.get(self, "security_context_sysctls")

    @security_context_sysctls.setter
    def security_context_sysctls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationSecurityContextSysctlArgs']]]]):
        pulumi.set(self, "security_context_sysctls", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the security group used to create new instance. It is conflict
        with `security_group_ids`.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The maximum price hourly for spot instance.
        """
        return pulumi.get(self, "spot_price_limit")

    @spot_price_limit.setter
    def spot_price_limit(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "spot_price_limit", value)

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`
        , `SpotWithPriceLimit`.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_strategy", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource. It will be applied for ECI instances finally.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot
        be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be
        a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The program's buffering time before closing.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @termination_grace_period_seconds.setter
    def termination_grace_period_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "termination_grace_period_seconds", value)

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationVolumeArgs']]]]:
        """
        The list of volumes. See `volumes` below for details.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.type_token("alicloud:ess/eciScalingConfiguration:EciScalingConfiguration")
class EciScalingConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acr_registry_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationAcrRegistryInfoArgs', 'EciScalingConfigurationAcrRegistryInfoArgsDict']]]]] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 active_deadline_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_create_eip: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_match_image_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 container_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationContainerArgs', 'EciScalingConfigurationContainerArgsDict']]]]] = None,
                 cost_optimization: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu: Optional[pulumi.Input[_builtins.float]] = None,
                 cpu_options_core: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_options_threads_per_core: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_config_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationDnsConfigOptionArgs', 'EciScalingConfigurationDnsConfigOptionArgsDict']]]]] = None,
                 dns_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 egress_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 eip_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_sls: Optional[pulumi.Input[_builtins.bool]] = None,
                 ephemeral_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationHostAliasArgs', 'EciScalingConfigurationHostAliasArgsDict']]]]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_registry_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationImageRegistryCredentialArgs', 'EciScalingConfigurationImageRegistryCredentialArgsDict']]]]] = None,
                 image_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationInitContainerArgs', 'EciScalingConfigurationInitContainerArgsDict']]]]] = None,
                 instance_family_level: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv6_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 load_balancer_weight: Optional[pulumi.Input[_builtins.int]] = None,
                 memory: Optional[pulumi.Input[_builtins.float]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restart_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_context_sysctls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationSecurityContextSysctlArgs', 'EciScalingConfigurationSecurityContextSysctlArgsDict']]]]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_price_limit: Optional[pulumi.Input[_builtins.float]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationVolumeArgs', 'EciScalingConfigurationVolumeArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a ESS eci scaling configuration resource.

        For information about ess eci scaling configuration, see [CreateEciScalingConfiguration](https://www.alibabacloud.com/help/en/auto-scaling/latest/create-eci-scaling-configuration).

        > **NOTE:** Available since v1.164.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        my_name = f"{name}-{default_integer['result']}"
        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("default",
            vpc_name=my_name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=my_name)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=my_name,
            vpc_id=default_network.id)
        default_scaling_group = alicloud.ess.ScalingGroup("default",
            min_size=0,
            max_size=1,
            scaling_group_name=my_name,
            removal_policies=[
                "OldestInstance",
                "NewestInstance",
            ],
            vswitch_ids=[default_switch.id],
            group_type="ECI")
        default_eci_scaling_configuration = alicloud.ess.EciScalingConfiguration("default",
            scaling_group_id=default_scaling_group.id,
            cpu=2,
            memory=4,
            security_group_id=default_security_group.id,
            force_delete=True,
            active=True,
            container_group_name="container-group-1649839595174",
            containers=[{
                "name": "container-1",
                "image": "registry-vpc.cn-hangzhou.aliyuncs.com/eci_open/alpine:3.5",
            }])
        ```

        ## Import

        ESS eci scaling configuration can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ess/eciScalingConfiguration:EciScalingConfiguration example asc-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationAcrRegistryInfoArgs', 'EciScalingConfigurationAcrRegistryInfoArgsDict']]]] acr_registry_infos: Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
        :param pulumi.Input[_builtins.bool] active: Whether active current eci scaling configuration in the specified scaling group. Note that only
               one configuration can be active. Default to `false`.
        :param pulumi.Input[_builtins.int] active_deadline_seconds: The duration in seconds relative to the startTime that the job may be active before the system tries to terminate it.
        :param pulumi.Input[_builtins.bool] auto_create_eip: Whether create eip automatically.
        :param pulumi.Input[_builtins.bool] auto_match_image_cache: Whether to automatically match the image cache.
        :param pulumi.Input[_builtins.str] container_group_name: The name series of the elastic container instances created from the scaling configuration. If you want to use an ordered instance name, specify the value for this parameter in the following format: name_prefix(AUTO_INCREMENT)[begin_number,bits]name_suffix.
               name_prefix: the prefix of the hostname.
               (AUTO_INCREMENT): the sort method. This is a static field.
               begin_number: the start value of the sequential values. Valid values: 0 to 999999.
               bits: the number of digits in sequential values. Valid values: 1 to 6. If the number of digits in the specified begin_number value is greater than the value of the bits field, the bits field is automatically set to 6.
               name_suffix: the suffix of the hostname. This field is optional.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationContainerArgs', 'EciScalingConfigurationContainerArgsDict']]]] containers: The list of containers. See `containers` below for details.
        :param pulumi.Input[_builtins.bool] cost_optimization: Indicates whether the Cost Optimization feature is enabled. Valid values: true,false.
        :param pulumi.Input[_builtins.float] cpu: The amount of CPU resources allocated to the container group.
        :param pulumi.Input[_builtins.int] cpu_options_core: The number of physical CPU cores. You can specify this parameter for only specific instance types.
        :param pulumi.Input[_builtins.int] cpu_options_threads_per_core: The number of threads per core. You can specify this parameter for only specific instance types. If you set this parameter to 1, Hyper-Threading is disabled.
        :param pulumi.Input[_builtins.str] description: The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to
               256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationDnsConfigOptionArgs', 'EciScalingConfigurationDnsConfigOptionArgsDict']]]] dns_config_options: The options. Each option is a name-value pair. The value in the name-value pair is optional.   See `dns_config_options` below for
               details.
        :param pulumi.Input[_builtins.str] dns_policy: dns policy of contain group.
        :param pulumi.Input[_builtins.int] egress_bandwidth: egress bandwidth.
        :param pulumi.Input[_builtins.int] eip_bandwidth: Eip bandwidth.
        :param pulumi.Input[_builtins.bool] enable_sls: Enable sls log service.
        :param pulumi.Input[_builtins.int] ephemeral_storage: The size of ephemeral storage.
        :param pulumi.Input[_builtins.bool] force_delete: The eci scaling configuration will be deleted forcibly with deleting its scaling group.
               Default to false.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationHostAliasArgs', 'EciScalingConfigurationHostAliasArgsDict']]]] host_aliases: HostAliases. See `host_aliases` below.
        :param pulumi.Input[_builtins.str] host_name: Hostname of an ECI instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationImageRegistryCredentialArgs', 'EciScalingConfigurationImageRegistryCredentialArgsDict']]]] image_registry_credentials: The image registry credential.   See `image_registry_credentials` below for
               details.
        :param pulumi.Input[_builtins.str] image_snapshot_id: The ID of image cache.
        :param pulumi.Input[_builtins.int] ingress_bandwidth: Ingress bandwidth.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationInitContainerArgs', 'EciScalingConfigurationInitContainerArgsDict']]]] init_containers: The list of initContainers. See `init_containers` below for details.
        :param pulumi.Input[_builtins.str] instance_family_level: The level of the instance family, which is used to filter instance types that meet the specified criteria. This parameter takes effect only if you set CostOptimization to true. Valid values: EntryLevel, EnterpriseLevel, CreditEntryLevel.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: The specified ECS instance types. You can specify up to five ECS instance types.
        :param pulumi.Input[_builtins.int] ipv6_address_count: Number of IPv6 addresses.
        :param pulumi.Input[_builtins.int] load_balancer_weight: The weight of an ECI instance attached to the Server Group.
        :param pulumi.Input[_builtins.float] memory: The amount of memory resources allocated to the container group.
        :param pulumi.Input[_builtins.str] ram_role_name: The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        :param pulumi.Input[_builtins.str] resource_group_id: ID of resource group.
        :param pulumi.Input[_builtins.str] restart_policy: The restart policy of the container group. Default to `Always`.
        :param pulumi.Input[_builtins.str] scaling_configuration_name: Name shown for the scheduled task. which must contain 2-64 characters (
               English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number,
               underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is
               EciScalingConfigurationId.
        :param pulumi.Input[_builtins.str] scaling_group_id: ID of the scaling group of a eci scaling configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationSecurityContextSysctlArgs', 'EciScalingConfigurationSecurityContextSysctlArgsDict']]]] security_context_sysctls: The system information about the security context in which the elastic container instance is run.   See `security_context_sysctls` below for
               details.
        :param pulumi.Input[_builtins.str] security_group_id: ID of the security group used to create new instance. It is conflict
               with `security_group_ids`.
        :param pulumi.Input[_builtins.float] spot_price_limit: The maximum price hourly for spot instance.
        :param pulumi.Input[_builtins.str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`
               , `SpotWithPriceLimit`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. It will be applied for ECI instances finally.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot
               be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be
               a null string.
        :param pulumi.Input[_builtins.int] termination_grace_period_seconds: The program's buffering time before closing.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationVolumeArgs', 'EciScalingConfigurationVolumeArgsDict']]]] volumes: The list of volumes. See `volumes` below for details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EciScalingConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESS eci scaling configuration resource.

        For information about ess eci scaling configuration, see [CreateEciScalingConfiguration](https://www.alibabacloud.com/help/en/auto-scaling/latest/create-eci-scaling-configuration).

        > **NOTE:** Available since v1.164.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        my_name = f"{name}-{default_integer['result']}"
        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("default",
            vpc_name=my_name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=my_name)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=my_name,
            vpc_id=default_network.id)
        default_scaling_group = alicloud.ess.ScalingGroup("default",
            min_size=0,
            max_size=1,
            scaling_group_name=my_name,
            removal_policies=[
                "OldestInstance",
                "NewestInstance",
            ],
            vswitch_ids=[default_switch.id],
            group_type="ECI")
        default_eci_scaling_configuration = alicloud.ess.EciScalingConfiguration("default",
            scaling_group_id=default_scaling_group.id,
            cpu=2,
            memory=4,
            security_group_id=default_security_group.id,
            force_delete=True,
            active=True,
            container_group_name="container-group-1649839595174",
            containers=[{
                "name": "container-1",
                "image": "registry-vpc.cn-hangzhou.aliyuncs.com/eci_open/alpine:3.5",
            }])
        ```

        ## Import

        ESS eci scaling configuration can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ess/eciScalingConfiguration:EciScalingConfiguration example asc-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param EciScalingConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EciScalingConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acr_registry_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationAcrRegistryInfoArgs', 'EciScalingConfigurationAcrRegistryInfoArgsDict']]]]] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 active_deadline_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_create_eip: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_match_image_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 container_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationContainerArgs', 'EciScalingConfigurationContainerArgsDict']]]]] = None,
                 cost_optimization: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu: Optional[pulumi.Input[_builtins.float]] = None,
                 cpu_options_core: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_options_threads_per_core: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_config_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationDnsConfigOptionArgs', 'EciScalingConfigurationDnsConfigOptionArgsDict']]]]] = None,
                 dns_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 egress_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 eip_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_sls: Optional[pulumi.Input[_builtins.bool]] = None,
                 ephemeral_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationHostAliasArgs', 'EciScalingConfigurationHostAliasArgsDict']]]]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_registry_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationImageRegistryCredentialArgs', 'EciScalingConfigurationImageRegistryCredentialArgsDict']]]]] = None,
                 image_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationInitContainerArgs', 'EciScalingConfigurationInitContainerArgsDict']]]]] = None,
                 instance_family_level: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv6_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 load_balancer_weight: Optional[pulumi.Input[_builtins.int]] = None,
                 memory: Optional[pulumi.Input[_builtins.float]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restart_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_context_sysctls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationSecurityContextSysctlArgs', 'EciScalingConfigurationSecurityContextSysctlArgsDict']]]]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_price_limit: Optional[pulumi.Input[_builtins.float]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationVolumeArgs', 'EciScalingConfigurationVolumeArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EciScalingConfigurationArgs.__new__(EciScalingConfigurationArgs)

            __props__.__dict__["acr_registry_infos"] = acr_registry_infos
            __props__.__dict__["active"] = active
            __props__.__dict__["active_deadline_seconds"] = active_deadline_seconds
            __props__.__dict__["auto_create_eip"] = auto_create_eip
            __props__.__dict__["auto_match_image_cache"] = auto_match_image_cache
            __props__.__dict__["container_group_name"] = container_group_name
            __props__.__dict__["containers"] = containers
            __props__.__dict__["cost_optimization"] = cost_optimization
            __props__.__dict__["cpu"] = cpu
            __props__.__dict__["cpu_options_core"] = cpu_options_core
            __props__.__dict__["cpu_options_threads_per_core"] = cpu_options_threads_per_core
            __props__.__dict__["description"] = description
            __props__.__dict__["dns_config_options"] = dns_config_options
            __props__.__dict__["dns_policy"] = dns_policy
            __props__.__dict__["egress_bandwidth"] = egress_bandwidth
            __props__.__dict__["eip_bandwidth"] = eip_bandwidth
            __props__.__dict__["enable_sls"] = enable_sls
            __props__.__dict__["ephemeral_storage"] = ephemeral_storage
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["host_aliases"] = host_aliases
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["image_registry_credentials"] = image_registry_credentials
            __props__.__dict__["image_snapshot_id"] = image_snapshot_id
            __props__.__dict__["ingress_bandwidth"] = ingress_bandwidth
            __props__.__dict__["init_containers"] = init_containers
            __props__.__dict__["instance_family_level"] = instance_family_level
            __props__.__dict__["instance_types"] = instance_types
            __props__.__dict__["ipv6_address_count"] = ipv6_address_count
            __props__.__dict__["load_balancer_weight"] = load_balancer_weight
            __props__.__dict__["memory"] = memory
            __props__.__dict__["ram_role_name"] = ram_role_name
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["restart_policy"] = restart_policy
            __props__.__dict__["scaling_configuration_name"] = scaling_configuration_name
            if scaling_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_group_id'")
            __props__.__dict__["scaling_group_id"] = scaling_group_id
            __props__.__dict__["security_context_sysctls"] = security_context_sysctls
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["spot_price_limit"] = spot_price_limit
            __props__.__dict__["spot_strategy"] = spot_strategy
            __props__.__dict__["tags"] = tags
            __props__.__dict__["termination_grace_period_seconds"] = termination_grace_period_seconds
            __props__.__dict__["volumes"] = volumes
        super(EciScalingConfiguration, __self__).__init__(
            'alicloud:ess/eciScalingConfiguration:EciScalingConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acr_registry_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationAcrRegistryInfoArgs', 'EciScalingConfigurationAcrRegistryInfoArgsDict']]]]] = None,
            active: Optional[pulumi.Input[_builtins.bool]] = None,
            active_deadline_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            auto_create_eip: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_match_image_cache: Optional[pulumi.Input[_builtins.bool]] = None,
            container_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationContainerArgs', 'EciScalingConfigurationContainerArgsDict']]]]] = None,
            cost_optimization: Optional[pulumi.Input[_builtins.bool]] = None,
            cpu: Optional[pulumi.Input[_builtins.float]] = None,
            cpu_options_core: Optional[pulumi.Input[_builtins.int]] = None,
            cpu_options_threads_per_core: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dns_config_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationDnsConfigOptionArgs', 'EciScalingConfigurationDnsConfigOptionArgsDict']]]]] = None,
            dns_policy: Optional[pulumi.Input[_builtins.str]] = None,
            egress_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            eip_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            enable_sls: Optional[pulumi.Input[_builtins.bool]] = None,
            ephemeral_storage: Optional[pulumi.Input[_builtins.int]] = None,
            force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            host_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationHostAliasArgs', 'EciScalingConfigurationHostAliasArgsDict']]]]] = None,
            host_name: Optional[pulumi.Input[_builtins.str]] = None,
            image_registry_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationImageRegistryCredentialArgs', 'EciScalingConfigurationImageRegistryCredentialArgsDict']]]]] = None,
            image_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            ingress_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            init_containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationInitContainerArgs', 'EciScalingConfigurationInitContainerArgsDict']]]]] = None,
            instance_family_level: Optional[pulumi.Input[_builtins.str]] = None,
            instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ipv6_address_count: Optional[pulumi.Input[_builtins.int]] = None,
            load_balancer_weight: Optional[pulumi.Input[_builtins.int]] = None,
            memory: Optional[pulumi.Input[_builtins.float]] = None,
            ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            restart_policy: Optional[pulumi.Input[_builtins.str]] = None,
            scaling_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
            scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_context_sysctls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationSecurityContextSysctlArgs', 'EciScalingConfigurationSecurityContextSysctlArgsDict']]]]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            spot_price_limit: Optional[pulumi.Input[_builtins.float]] = None,
            spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            termination_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationVolumeArgs', 'EciScalingConfigurationVolumeArgsDict']]]]] = None) -> 'EciScalingConfiguration':
        """
        Get an existing EciScalingConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationAcrRegistryInfoArgs', 'EciScalingConfigurationAcrRegistryInfoArgsDict']]]] acr_registry_infos: Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
        :param pulumi.Input[_builtins.bool] active: Whether active current eci scaling configuration in the specified scaling group. Note that only
               one configuration can be active. Default to `false`.
        :param pulumi.Input[_builtins.int] active_deadline_seconds: The duration in seconds relative to the startTime that the job may be active before the system tries to terminate it.
        :param pulumi.Input[_builtins.bool] auto_create_eip: Whether create eip automatically.
        :param pulumi.Input[_builtins.bool] auto_match_image_cache: Whether to automatically match the image cache.
        :param pulumi.Input[_builtins.str] container_group_name: The name series of the elastic container instances created from the scaling configuration. If you want to use an ordered instance name, specify the value for this parameter in the following format: name_prefix(AUTO_INCREMENT)[begin_number,bits]name_suffix.
               name_prefix: the prefix of the hostname.
               (AUTO_INCREMENT): the sort method. This is a static field.
               begin_number: the start value of the sequential values. Valid values: 0 to 999999.
               bits: the number of digits in sequential values. Valid values: 1 to 6. If the number of digits in the specified begin_number value is greater than the value of the bits field, the bits field is automatically set to 6.
               name_suffix: the suffix of the hostname. This field is optional.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationContainerArgs', 'EciScalingConfigurationContainerArgsDict']]]] containers: The list of containers. See `containers` below for details.
        :param pulumi.Input[_builtins.bool] cost_optimization: Indicates whether the Cost Optimization feature is enabled. Valid values: true,false.
        :param pulumi.Input[_builtins.float] cpu: The amount of CPU resources allocated to the container group.
        :param pulumi.Input[_builtins.int] cpu_options_core: The number of physical CPU cores. You can specify this parameter for only specific instance types.
        :param pulumi.Input[_builtins.int] cpu_options_threads_per_core: The number of threads per core. You can specify this parameter for only specific instance types. If you set this parameter to 1, Hyper-Threading is disabled.
        :param pulumi.Input[_builtins.str] description: The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to
               256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationDnsConfigOptionArgs', 'EciScalingConfigurationDnsConfigOptionArgsDict']]]] dns_config_options: The options. Each option is a name-value pair. The value in the name-value pair is optional.   See `dns_config_options` below for
               details.
        :param pulumi.Input[_builtins.str] dns_policy: dns policy of contain group.
        :param pulumi.Input[_builtins.int] egress_bandwidth: egress bandwidth.
        :param pulumi.Input[_builtins.int] eip_bandwidth: Eip bandwidth.
        :param pulumi.Input[_builtins.bool] enable_sls: Enable sls log service.
        :param pulumi.Input[_builtins.int] ephemeral_storage: The size of ephemeral storage.
        :param pulumi.Input[_builtins.bool] force_delete: The eci scaling configuration will be deleted forcibly with deleting its scaling group.
               Default to false.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationHostAliasArgs', 'EciScalingConfigurationHostAliasArgsDict']]]] host_aliases: HostAliases. See `host_aliases` below.
        :param pulumi.Input[_builtins.str] host_name: Hostname of an ECI instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationImageRegistryCredentialArgs', 'EciScalingConfigurationImageRegistryCredentialArgsDict']]]] image_registry_credentials: The image registry credential.   See `image_registry_credentials` below for
               details.
        :param pulumi.Input[_builtins.str] image_snapshot_id: The ID of image cache.
        :param pulumi.Input[_builtins.int] ingress_bandwidth: Ingress bandwidth.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationInitContainerArgs', 'EciScalingConfigurationInitContainerArgsDict']]]] init_containers: The list of initContainers. See `init_containers` below for details.
        :param pulumi.Input[_builtins.str] instance_family_level: The level of the instance family, which is used to filter instance types that meet the specified criteria. This parameter takes effect only if you set CostOptimization to true. Valid values: EntryLevel, EnterpriseLevel, CreditEntryLevel.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: The specified ECS instance types. You can specify up to five ECS instance types.
        :param pulumi.Input[_builtins.int] ipv6_address_count: Number of IPv6 addresses.
        :param pulumi.Input[_builtins.int] load_balancer_weight: The weight of an ECI instance attached to the Server Group.
        :param pulumi.Input[_builtins.float] memory: The amount of memory resources allocated to the container group.
        :param pulumi.Input[_builtins.str] ram_role_name: The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        :param pulumi.Input[_builtins.str] resource_group_id: ID of resource group.
        :param pulumi.Input[_builtins.str] restart_policy: The restart policy of the container group. Default to `Always`.
        :param pulumi.Input[_builtins.str] scaling_configuration_name: Name shown for the scheduled task. which must contain 2-64 characters (
               English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number,
               underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is
               EciScalingConfigurationId.
        :param pulumi.Input[_builtins.str] scaling_group_id: ID of the scaling group of a eci scaling configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationSecurityContextSysctlArgs', 'EciScalingConfigurationSecurityContextSysctlArgsDict']]]] security_context_sysctls: The system information about the security context in which the elastic container instance is run.   See `security_context_sysctls` below for
               details.
        :param pulumi.Input[_builtins.str] security_group_id: ID of the security group used to create new instance. It is conflict
               with `security_group_ids`.
        :param pulumi.Input[_builtins.float] spot_price_limit: The maximum price hourly for spot instance.
        :param pulumi.Input[_builtins.str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`
               , `SpotWithPriceLimit`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. It will be applied for ECI instances finally.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot
               be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be
               a null string.
        :param pulumi.Input[_builtins.int] termination_grace_period_seconds: The program's buffering time before closing.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EciScalingConfigurationVolumeArgs', 'EciScalingConfigurationVolumeArgsDict']]]] volumes: The list of volumes. See `volumes` below for details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EciScalingConfigurationState.__new__(_EciScalingConfigurationState)

        __props__.__dict__["acr_registry_infos"] = acr_registry_infos
        __props__.__dict__["active"] = active
        __props__.__dict__["active_deadline_seconds"] = active_deadline_seconds
        __props__.__dict__["auto_create_eip"] = auto_create_eip
        __props__.__dict__["auto_match_image_cache"] = auto_match_image_cache
        __props__.__dict__["container_group_name"] = container_group_name
        __props__.__dict__["containers"] = containers
        __props__.__dict__["cost_optimization"] = cost_optimization
        __props__.__dict__["cpu"] = cpu
        __props__.__dict__["cpu_options_core"] = cpu_options_core
        __props__.__dict__["cpu_options_threads_per_core"] = cpu_options_threads_per_core
        __props__.__dict__["description"] = description
        __props__.__dict__["dns_config_options"] = dns_config_options
        __props__.__dict__["dns_policy"] = dns_policy
        __props__.__dict__["egress_bandwidth"] = egress_bandwidth
        __props__.__dict__["eip_bandwidth"] = eip_bandwidth
        __props__.__dict__["enable_sls"] = enable_sls
        __props__.__dict__["ephemeral_storage"] = ephemeral_storage
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["host_aliases"] = host_aliases
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["image_registry_credentials"] = image_registry_credentials
        __props__.__dict__["image_snapshot_id"] = image_snapshot_id
        __props__.__dict__["ingress_bandwidth"] = ingress_bandwidth
        __props__.__dict__["init_containers"] = init_containers
        __props__.__dict__["instance_family_level"] = instance_family_level
        __props__.__dict__["instance_types"] = instance_types
        __props__.__dict__["ipv6_address_count"] = ipv6_address_count
        __props__.__dict__["load_balancer_weight"] = load_balancer_weight
        __props__.__dict__["memory"] = memory
        __props__.__dict__["ram_role_name"] = ram_role_name
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["restart_policy"] = restart_policy
        __props__.__dict__["scaling_configuration_name"] = scaling_configuration_name
        __props__.__dict__["scaling_group_id"] = scaling_group_id
        __props__.__dict__["security_context_sysctls"] = security_context_sysctls
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["spot_price_limit"] = spot_price_limit
        __props__.__dict__["spot_strategy"] = spot_strategy
        __props__.__dict__["tags"] = tags
        __props__.__dict__["termination_grace_period_seconds"] = termination_grace_period_seconds
        __props__.__dict__["volumes"] = volumes
        return EciScalingConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acrRegistryInfos")
    def acr_registry_infos(self) -> pulumi.Output[Optional[Sequence['outputs.EciScalingConfigurationAcrRegistryInfo']]]:
        """
        Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
        """
        return pulumi.get(self, "acr_registry_infos")

    @_builtins.property
    @pulumi.getter
    def active(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether active current eci scaling configuration in the specified scaling group. Note that only
        one configuration can be active. Default to `false`.
        """
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter(name="activeDeadlineSeconds")
    def active_deadline_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The duration in seconds relative to the startTime that the job may be active before the system tries to terminate it.
        """
        return pulumi.get(self, "active_deadline_seconds")

    @_builtins.property
    @pulumi.getter(name="autoCreateEip")
    def auto_create_eip(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether create eip automatically.
        """
        return pulumi.get(self, "auto_create_eip")

    @_builtins.property
    @pulumi.getter(name="autoMatchImageCache")
    def auto_match_image_cache(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to automatically match the image cache.
        """
        return pulumi.get(self, "auto_match_image_cache")

    @_builtins.property
    @pulumi.getter(name="containerGroupName")
    def container_group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name series of the elastic container instances created from the scaling configuration. If you want to use an ordered instance name, specify the value for this parameter in the following format: name_prefix(AUTO_INCREMENT)[begin_number,bits]name_suffix.
        name_prefix: the prefix of the hostname.
        (AUTO_INCREMENT): the sort method. This is a static field.
        begin_number: the start value of the sequential values. Valid values: 0 to 999999.
        bits: the number of digits in sequential values. Valid values: 1 to 6. If the number of digits in the specified begin_number value is greater than the value of the bits field, the bits field is automatically set to 6.
        name_suffix: the suffix of the hostname. This field is optional.
        """
        return pulumi.get(self, "container_group_name")

    @_builtins.property
    @pulumi.getter
    def containers(self) -> pulumi.Output[Optional[Sequence['outputs.EciScalingConfigurationContainer']]]:
        """
        The list of containers. See `containers` below for details.
        """
        return pulumi.get(self, "containers")

    @_builtins.property
    @pulumi.getter(name="costOptimization")
    def cost_optimization(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether the Cost Optimization feature is enabled. Valid values: true,false.
        """
        return pulumi.get(self, "cost_optimization")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        The amount of CPU resources allocated to the container group.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="cpuOptionsCore")
    def cpu_options_core(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of physical CPU cores. You can specify this parameter for only specific instance types.
        """
        return pulumi.get(self, "cpu_options_core")

    @_builtins.property
    @pulumi.getter(name="cpuOptionsThreadsPerCore")
    def cpu_options_threads_per_core(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of threads per core. You can specify this parameter for only specific instance types. If you set this parameter to 1, Hyper-Threading is disabled.
        """
        return pulumi.get(self, "cpu_options_threads_per_core")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to
        256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dnsConfigOptions")
    def dns_config_options(self) -> pulumi.Output[Optional[Sequence['outputs.EciScalingConfigurationDnsConfigOption']]]:
        """
        The options. Each option is a name-value pair. The value in the name-value pair is optional.   See `dns_config_options` below for
        details.
        """
        return pulumi.get(self, "dns_config_options")

    @_builtins.property
    @pulumi.getter(name="dnsPolicy")
    def dns_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        dns policy of contain group.
        """
        return pulumi.get(self, "dns_policy")

    @_builtins.property
    @pulumi.getter(name="egressBandwidth")
    def egress_bandwidth(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        egress bandwidth.
        """
        return pulumi.get(self, "egress_bandwidth")

    @_builtins.property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Eip bandwidth.
        """
        return pulumi.get(self, "eip_bandwidth")

    @_builtins.property
    @pulumi.getter(name="enableSls")
    def enable_sls(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable sls log service.
        """
        return pulumi.get(self, "enable_sls")

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The size of ephemeral storage.
        """
        return pulumi.get(self, "ephemeral_storage")

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The eci scaling configuration will be deleted forcibly with deleting its scaling group.
        Default to false.
        """
        return pulumi.get(self, "force_delete")

    @_builtins.property
    @pulumi.getter(name="hostAliases")
    def host_aliases(self) -> pulumi.Output[Optional[Sequence['outputs.EciScalingConfigurationHostAlias']]]:
        """
        HostAliases. See `host_aliases` below.
        """
        return pulumi.get(self, "host_aliases")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Hostname of an ECI instance.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="imageRegistryCredentials")
    def image_registry_credentials(self) -> pulumi.Output[Optional[Sequence['outputs.EciScalingConfigurationImageRegistryCredential']]]:
        """
        The image registry credential.   See `image_registry_credentials` below for
        details.
        """
        return pulumi.get(self, "image_registry_credentials")

    @_builtins.property
    @pulumi.getter(name="imageSnapshotId")
    def image_snapshot_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of image cache.
        """
        return pulumi.get(self, "image_snapshot_id")

    @_builtins.property
    @pulumi.getter(name="ingressBandwidth")
    def ingress_bandwidth(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Ingress bandwidth.
        """
        return pulumi.get(self, "ingress_bandwidth")

    @_builtins.property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> pulumi.Output[Optional[Sequence['outputs.EciScalingConfigurationInitContainer']]]:
        """
        The list of initContainers. See `init_containers` below for details.
        """
        return pulumi.get(self, "init_containers")

    @_builtins.property
    @pulumi.getter(name="instanceFamilyLevel")
    def instance_family_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The level of the instance family, which is used to filter instance types that meet the specified criteria. This parameter takes effect only if you set CostOptimization to true. Valid values: EntryLevel, EnterpriseLevel, CreditEntryLevel.
        """
        return pulumi.get(self, "instance_family_level")

    @_builtins.property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The specified ECS instance types. You can specify up to five ECS instance types.
        """
        return pulumi.get(self, "instance_types")

    @_builtins.property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of IPv6 addresses.
        """
        return pulumi.get(self, "ipv6_address_count")

    @_builtins.property
    @pulumi.getter(name="loadBalancerWeight")
    def load_balancer_weight(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The weight of an ECI instance attached to the Server Group.
        """
        return pulumi.get(self, "load_balancer_weight")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        The amount of memory resources allocated to the container group.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        """
        return pulumi.get(self, "ram_role_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The restart policy of the container group. Default to `Always`.
        """
        return pulumi.get(self, "restart_policy")

    @_builtins.property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name shown for the scheduled task. which must contain 2-64 characters (
        English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number,
        underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is
        EciScalingConfigurationId.
        """
        return pulumi.get(self, "scaling_configuration_name")

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the scaling group of a eci scaling configuration.
        """
        return pulumi.get(self, "scaling_group_id")

    @_builtins.property
    @pulumi.getter(name="securityContextSysctls")
    def security_context_sysctls(self) -> pulumi.Output[Optional[Sequence['outputs.EciScalingConfigurationSecurityContextSysctl']]]:
        """
        The system information about the security context in which the elastic container instance is run.   See `security_context_sysctls` below for
        details.
        """
        return pulumi.get(self, "security_context_sysctls")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the security group used to create new instance. It is conflict
        with `security_group_ids`.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        The maximum price hourly for spot instance.
        """
        return pulumi.get(self, "spot_price_limit")

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`
        , `SpotWithPriceLimit`.
        """
        return pulumi.get(self, "spot_strategy")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource. It will be applied for ECI instances finally.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot
        be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be
        a null string.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The program's buffering time before closing.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Optional[Sequence['outputs.EciScalingConfigurationVolume']]]:
        """
        The list of volumes. See `volumes` below for details.
        """
        return pulumi.get(self, "volumes")

