# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['V3ProvisionConfigArgs', 'V3ProvisionConfig']

@pulumi.input_type
class V3ProvisionConfigArgs:
    def __init__(__self__, *,
                 function_name: pulumi.Input[_builtins.str],
                 always_allocate_cpu: Optional[pulumi.Input[_builtins.bool]] = None,
                 always_allocate_gpu: Optional[pulumi.Input[_builtins.bool]] = None,
                 qualifier: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_actions: Optional[pulumi.Input[Sequence[pulumi.Input['V3ProvisionConfigScheduledActionArgs']]]] = None,
                 target: Optional[pulumi.Input[_builtins.int]] = None,
                 target_tracking_policies: Optional[pulumi.Input[Sequence[pulumi.Input['V3ProvisionConfigTargetTrackingPolicyArgs']]]] = None):
        """
        The set of arguments for constructing a V3ProvisionConfig resource.
        :param pulumi.Input[_builtins.str] function_name: The name of the function. If this parameter is not specified, the provisioned configurations of all functions are listed.
        :param pulumi.Input[_builtins.bool] always_allocate_cpu: Whether the CPU is always allocated. The default value is true.
        :param pulumi.Input[_builtins.bool] always_allocate_gpu: Whether to always assign GPU to function instance
        :param pulumi.Input[_builtins.str] qualifier: The function alias or LATEST.
        :param pulumi.Input[Sequence[pulumi.Input['V3ProvisionConfigScheduledActionArgs']]] scheduled_actions: Timing policy configuration See `scheduled_actions` below.
        :param pulumi.Input[_builtins.int] target: Number of reserved target resources. The value range is [0,10000].
        :param pulumi.Input[Sequence[pulumi.Input['V3ProvisionConfigTargetTrackingPolicyArgs']]] target_tracking_policies: Metric tracking scaling policy configuration See `target_tracking_policies` below.
        """
        pulumi.set(__self__, "function_name", function_name)
        if always_allocate_cpu is not None:
            pulumi.set(__self__, "always_allocate_cpu", always_allocate_cpu)
        if always_allocate_gpu is not None:
            pulumi.set(__self__, "always_allocate_gpu", always_allocate_gpu)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)
        if scheduled_actions is not None:
            pulumi.set(__self__, "scheduled_actions", scheduled_actions)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if target_tracking_policies is not None:
            pulumi.set(__self__, "target_tracking_policies", target_tracking_policies)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the function. If this parameter is not specified, the provisioned configurations of all functions are listed.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "function_name", value)

    @_builtins.property
    @pulumi.getter(name="alwaysAllocateCpu")
    def always_allocate_cpu(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the CPU is always allocated. The default value is true.
        """
        return pulumi.get(self, "always_allocate_cpu")

    @always_allocate_cpu.setter
    def always_allocate_cpu(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "always_allocate_cpu", value)

    @_builtins.property
    @pulumi.getter(name="alwaysAllocateGpu")
    def always_allocate_gpu(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to always assign GPU to function instance
        """
        return pulumi.get(self, "always_allocate_gpu")

    @always_allocate_gpu.setter
    def always_allocate_gpu(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "always_allocate_gpu", value)

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The function alias or LATEST.
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualifier", value)

    @_builtins.property
    @pulumi.getter(name="scheduledActions")
    def scheduled_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V3ProvisionConfigScheduledActionArgs']]]]:
        """
        Timing policy configuration See `scheduled_actions` below.
        """
        return pulumi.get(self, "scheduled_actions")

    @scheduled_actions.setter
    def scheduled_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V3ProvisionConfigScheduledActionArgs']]]]):
        pulumi.set(self, "scheduled_actions", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of reserved target resources. The value range is [0,10000].
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter(name="targetTrackingPolicies")
    def target_tracking_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V3ProvisionConfigTargetTrackingPolicyArgs']]]]:
        """
        Metric tracking scaling policy configuration See `target_tracking_policies` below.
        """
        return pulumi.get(self, "target_tracking_policies")

    @target_tracking_policies.setter
    def target_tracking_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V3ProvisionConfigTargetTrackingPolicyArgs']]]]):
        pulumi.set(self, "target_tracking_policies", value)


@pulumi.input_type
class _V3ProvisionConfigState:
    def __init__(__self__, *,
                 always_allocate_cpu: Optional[pulumi.Input[_builtins.bool]] = None,
                 always_allocate_gpu: Optional[pulumi.Input[_builtins.bool]] = None,
                 current: Optional[pulumi.Input[_builtins.int]] = None,
                 current_error: Optional[pulumi.Input[_builtins.str]] = None,
                 function_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 qualifier: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_actions: Optional[pulumi.Input[Sequence[pulumi.Input['V3ProvisionConfigScheduledActionArgs']]]] = None,
                 target: Optional[pulumi.Input[_builtins.int]] = None,
                 target_tracking_policies: Optional[pulumi.Input[Sequence[pulumi.Input['V3ProvisionConfigTargetTrackingPolicyArgs']]]] = None):
        """
        Input properties used for looking up and filtering V3ProvisionConfig resources.
        :param pulumi.Input[_builtins.bool] always_allocate_cpu: Whether the CPU is always allocated. The default value is true.
        :param pulumi.Input[_builtins.bool] always_allocate_gpu: Whether to always assign GPU to function instance
        :param pulumi.Input[_builtins.int] current: (Available since v1.234.0) Number of actual resources
        :param pulumi.Input[_builtins.str] current_error: (Available since v1.234.0) Error message when a Reserved Instance creation fails
        :param pulumi.Input[_builtins.str] function_arn: (Available since v1.234.0) Resource Description of the function
        :param pulumi.Input[_builtins.str] function_name: The name of the function. If this parameter is not specified, the provisioned configurations of all functions are listed.
        :param pulumi.Input[_builtins.str] qualifier: The function alias or LATEST.
        :param pulumi.Input[Sequence[pulumi.Input['V3ProvisionConfigScheduledActionArgs']]] scheduled_actions: Timing policy configuration See `scheduled_actions` below.
        :param pulumi.Input[_builtins.int] target: Number of reserved target resources. The value range is [0,10000].
        :param pulumi.Input[Sequence[pulumi.Input['V3ProvisionConfigTargetTrackingPolicyArgs']]] target_tracking_policies: Metric tracking scaling policy configuration See `target_tracking_policies` below.
        """
        if always_allocate_cpu is not None:
            pulumi.set(__self__, "always_allocate_cpu", always_allocate_cpu)
        if always_allocate_gpu is not None:
            pulumi.set(__self__, "always_allocate_gpu", always_allocate_gpu)
        if current is not None:
            pulumi.set(__self__, "current", current)
        if current_error is not None:
            pulumi.set(__self__, "current_error", current_error)
        if function_arn is not None:
            pulumi.set(__self__, "function_arn", function_arn)
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)
        if scheduled_actions is not None:
            pulumi.set(__self__, "scheduled_actions", scheduled_actions)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if target_tracking_policies is not None:
            pulumi.set(__self__, "target_tracking_policies", target_tracking_policies)

    @_builtins.property
    @pulumi.getter(name="alwaysAllocateCpu")
    def always_allocate_cpu(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the CPU is always allocated. The default value is true.
        """
        return pulumi.get(self, "always_allocate_cpu")

    @always_allocate_cpu.setter
    def always_allocate_cpu(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "always_allocate_cpu", value)

    @_builtins.property
    @pulumi.getter(name="alwaysAllocateGpu")
    def always_allocate_gpu(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to always assign GPU to function instance
        """
        return pulumi.get(self, "always_allocate_gpu")

    @always_allocate_gpu.setter
    def always_allocate_gpu(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "always_allocate_gpu", value)

    @_builtins.property
    @pulumi.getter
    def current(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Available since v1.234.0) Number of actual resources
        """
        return pulumi.get(self, "current")

    @current.setter
    def current(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "current", value)

    @_builtins.property
    @pulumi.getter(name="currentError")
    def current_error(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.234.0) Error message when a Reserved Instance creation fails
        """
        return pulumi.get(self, "current_error")

    @current_error.setter
    def current_error(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "current_error", value)

    @_builtins.property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.234.0) Resource Description of the function
        """
        return pulumi.get(self, "function_arn")

    @function_arn.setter
    def function_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_arn", value)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the function. If this parameter is not specified, the provisioned configurations of all functions are listed.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_name", value)

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The function alias or LATEST.
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualifier", value)

    @_builtins.property
    @pulumi.getter(name="scheduledActions")
    def scheduled_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V3ProvisionConfigScheduledActionArgs']]]]:
        """
        Timing policy configuration See `scheduled_actions` below.
        """
        return pulumi.get(self, "scheduled_actions")

    @scheduled_actions.setter
    def scheduled_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V3ProvisionConfigScheduledActionArgs']]]]):
        pulumi.set(self, "scheduled_actions", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of reserved target resources. The value range is [0,10000].
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter(name="targetTrackingPolicies")
    def target_tracking_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V3ProvisionConfigTargetTrackingPolicyArgs']]]]:
        """
        Metric tracking scaling policy configuration See `target_tracking_policies` below.
        """
        return pulumi.get(self, "target_tracking_policies")

    @target_tracking_policies.setter
    def target_tracking_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V3ProvisionConfigTargetTrackingPolicyArgs']]]]):
        pulumi.set(self, "target_tracking_policies", value)


@pulumi.type_token("alicloud:fc/v3ProvisionConfig:V3ProvisionConfig")
class V3ProvisionConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 always_allocate_cpu: Optional[pulumi.Input[_builtins.bool]] = None,
                 always_allocate_gpu: Optional[pulumi.Input[_builtins.bool]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 qualifier: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V3ProvisionConfigScheduledActionArgs', 'V3ProvisionConfigScheduledActionArgsDict']]]]] = None,
                 target: Optional[pulumi.Input[_builtins.int]] = None,
                 target_tracking_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V3ProvisionConfigTargetTrackingPolicyArgs', 'V3ProvisionConfigTargetTrackingPolicyArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a FCV3 Provision Config resource.

        Function Reservation Configuration.

        For information about FCV3 Provision Config and how to use it, see [What is Provision Config](https://www.alibabacloud.com/help/en/functioncompute/fc-3-0/developer-reference/api-fc-2023-03-30-putprovisionconfig).

        > **NOTE:** Available since v1.230.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_time as time

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_project = alicloud.log.Project("default",
            project_name=f"{name}-{default['result']}",
            description=name)
        default_store = alicloud.log.Store("default",
            project_name=default_project.name,
            logstore_name=f"{name}-{default['result']}",
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        wait10_minutes = time.index.Sleep("wait_10_minutes", create_duration=10m,
        opts = pulumi.ResourceOptions(depends_on=[default_store]))
        function = alicloud.fc.V3Function("function",
            memory_size=512,
            cpu=0.5,
            handler="index.handler",
            function_name=f"{name}-{default['result']}",
            runtime="python3.10",
            disk_size=512,
            code={
                "zip_file": "UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=",
            },
            log_config={
                "enable_instance_metrics": True,
                "enable_request_metrics": True,
                "project": default_project.project_name,
                "logstore": default_store.logstore_name,
                "log_begin_rule": "None",
            },
            opts = pulumi.ResourceOptions(depends_on=[wait10_minutes]))
        default_v3_provision_config = alicloud.fc.V3ProvisionConfig("default",
            target=1,
            target_tracking_policies=[
                {
                    "name": "t1",
                    "start_time": "2030-10-10T10:10:10Z",
                    "end_time": "2035-10-10T10:10:10Z",
                    "min_capacity": 0,
                    "max_capacity": 1,
                    "metric_target": 1,
                    "metric_type": "ProvisionedConcurrencyUtilization",
                },
                {
                    "metric_target": 1,
                    "metric_type": "ProvisionedConcurrencyUtilization",
                    "name": "t2",
                    "start_time": "2030-10-10T10:10:10Z",
                    "end_time": "2035-10-10T10:10:10Z",
                    "min_capacity": 0,
                    "max_capacity": 1,
                },
                {
                    "metric_type": "ProvisionedConcurrencyUtilization",
                    "time_zone": "Asia/Shanghai",
                    "name": "t3",
                    "start_time": "2030-10-10T10:10:10",
                    "end_time": "2035-10-10T10:10:10",
                    "min_capacity": 0,
                    "max_capacity": 1,
                    "metric_target": 1,
                },
            ],
            scheduled_actions=[
                {
                    "target": 0,
                    "name": "s1",
                    "start_time": "2030-10-10T10:10:10Z",
                    "end_time": "2035-10-10T10:10:10Z",
                    "schedule_expression": "cron(0 0 4 * * *)",
                },
                {
                    "name": "s2",
                    "start_time": "2030-10-10T10:10:10Z",
                    "end_time": "2035-10-10T10:10:10Z",
                    "schedule_expression": "cron(0 0 6 * * *)",
                    "target": 1,
                },
                {
                    "start_time": "2030-10-10T10:10:10",
                    "end_time": "2035-10-10T10:10:10",
                    "schedule_expression": "cron(0 0 7 * * *)",
                    "target": 0,
                    "time_zone": "Asia/Shanghai",
                    "name": "s3",
                },
            ],
            qualifier="LATEST",
            always_allocate_gpu=True,
            function_name=function.function_name,
            always_allocate_cpu=True)
        ```

        ## Import

        FCV3 Provision Config can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:fc/v3ProvisionConfig:V3ProvisionConfig example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] always_allocate_cpu: Whether the CPU is always allocated. The default value is true.
        :param pulumi.Input[_builtins.bool] always_allocate_gpu: Whether to always assign GPU to function instance
        :param pulumi.Input[_builtins.str] function_name: The name of the function. If this parameter is not specified, the provisioned configurations of all functions are listed.
        :param pulumi.Input[_builtins.str] qualifier: The function alias or LATEST.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V3ProvisionConfigScheduledActionArgs', 'V3ProvisionConfigScheduledActionArgsDict']]]] scheduled_actions: Timing policy configuration See `scheduled_actions` below.
        :param pulumi.Input[_builtins.int] target: Number of reserved target resources. The value range is [0,10000].
        :param pulumi.Input[Sequence[pulumi.Input[Union['V3ProvisionConfigTargetTrackingPolicyArgs', 'V3ProvisionConfigTargetTrackingPolicyArgsDict']]]] target_tracking_policies: Metric tracking scaling policy configuration See `target_tracking_policies` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: V3ProvisionConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a FCV3 Provision Config resource.

        Function Reservation Configuration.

        For information about FCV3 Provision Config and how to use it, see [What is Provision Config](https://www.alibabacloud.com/help/en/functioncompute/fc-3-0/developer-reference/api-fc-2023-03-30-putprovisionconfig).

        > **NOTE:** Available since v1.230.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_time as time

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_project = alicloud.log.Project("default",
            project_name=f"{name}-{default['result']}",
            description=name)
        default_store = alicloud.log.Store("default",
            project_name=default_project.name,
            logstore_name=f"{name}-{default['result']}",
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        wait10_minutes = time.index.Sleep("wait_10_minutes", create_duration=10m,
        opts = pulumi.ResourceOptions(depends_on=[default_store]))
        function = alicloud.fc.V3Function("function",
            memory_size=512,
            cpu=0.5,
            handler="index.handler",
            function_name=f"{name}-{default['result']}",
            runtime="python3.10",
            disk_size=512,
            code={
                "zip_file": "UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=",
            },
            log_config={
                "enable_instance_metrics": True,
                "enable_request_metrics": True,
                "project": default_project.project_name,
                "logstore": default_store.logstore_name,
                "log_begin_rule": "None",
            },
            opts = pulumi.ResourceOptions(depends_on=[wait10_minutes]))
        default_v3_provision_config = alicloud.fc.V3ProvisionConfig("default",
            target=1,
            target_tracking_policies=[
                {
                    "name": "t1",
                    "start_time": "2030-10-10T10:10:10Z",
                    "end_time": "2035-10-10T10:10:10Z",
                    "min_capacity": 0,
                    "max_capacity": 1,
                    "metric_target": 1,
                    "metric_type": "ProvisionedConcurrencyUtilization",
                },
                {
                    "metric_target": 1,
                    "metric_type": "ProvisionedConcurrencyUtilization",
                    "name": "t2",
                    "start_time": "2030-10-10T10:10:10Z",
                    "end_time": "2035-10-10T10:10:10Z",
                    "min_capacity": 0,
                    "max_capacity": 1,
                },
                {
                    "metric_type": "ProvisionedConcurrencyUtilization",
                    "time_zone": "Asia/Shanghai",
                    "name": "t3",
                    "start_time": "2030-10-10T10:10:10",
                    "end_time": "2035-10-10T10:10:10",
                    "min_capacity": 0,
                    "max_capacity": 1,
                    "metric_target": 1,
                },
            ],
            scheduled_actions=[
                {
                    "target": 0,
                    "name": "s1",
                    "start_time": "2030-10-10T10:10:10Z",
                    "end_time": "2035-10-10T10:10:10Z",
                    "schedule_expression": "cron(0 0 4 * * *)",
                },
                {
                    "name": "s2",
                    "start_time": "2030-10-10T10:10:10Z",
                    "end_time": "2035-10-10T10:10:10Z",
                    "schedule_expression": "cron(0 0 6 * * *)",
                    "target": 1,
                },
                {
                    "start_time": "2030-10-10T10:10:10",
                    "end_time": "2035-10-10T10:10:10",
                    "schedule_expression": "cron(0 0 7 * * *)",
                    "target": 0,
                    "time_zone": "Asia/Shanghai",
                    "name": "s3",
                },
            ],
            qualifier="LATEST",
            always_allocate_gpu=True,
            function_name=function.function_name,
            always_allocate_cpu=True)
        ```

        ## Import

        FCV3 Provision Config can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:fc/v3ProvisionConfig:V3ProvisionConfig example <id>
        ```

        :param str resource_name: The name of the resource.
        :param V3ProvisionConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(V3ProvisionConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 always_allocate_cpu: Optional[pulumi.Input[_builtins.bool]] = None,
                 always_allocate_gpu: Optional[pulumi.Input[_builtins.bool]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 qualifier: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V3ProvisionConfigScheduledActionArgs', 'V3ProvisionConfigScheduledActionArgsDict']]]]] = None,
                 target: Optional[pulumi.Input[_builtins.int]] = None,
                 target_tracking_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V3ProvisionConfigTargetTrackingPolicyArgs', 'V3ProvisionConfigTargetTrackingPolicyArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = V3ProvisionConfigArgs.__new__(V3ProvisionConfigArgs)

            __props__.__dict__["always_allocate_cpu"] = always_allocate_cpu
            __props__.__dict__["always_allocate_gpu"] = always_allocate_gpu
            if function_name is None and not opts.urn:
                raise TypeError("Missing required property 'function_name'")
            __props__.__dict__["function_name"] = function_name
            __props__.__dict__["qualifier"] = qualifier
            __props__.__dict__["scheduled_actions"] = scheduled_actions
            __props__.__dict__["target"] = target
            __props__.__dict__["target_tracking_policies"] = target_tracking_policies
            __props__.__dict__["current"] = None
            __props__.__dict__["current_error"] = None
            __props__.__dict__["function_arn"] = None
        super(V3ProvisionConfig, __self__).__init__(
            'alicloud:fc/v3ProvisionConfig:V3ProvisionConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            always_allocate_cpu: Optional[pulumi.Input[_builtins.bool]] = None,
            always_allocate_gpu: Optional[pulumi.Input[_builtins.bool]] = None,
            current: Optional[pulumi.Input[_builtins.int]] = None,
            current_error: Optional[pulumi.Input[_builtins.str]] = None,
            function_arn: Optional[pulumi.Input[_builtins.str]] = None,
            function_name: Optional[pulumi.Input[_builtins.str]] = None,
            qualifier: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V3ProvisionConfigScheduledActionArgs', 'V3ProvisionConfigScheduledActionArgsDict']]]]] = None,
            target: Optional[pulumi.Input[_builtins.int]] = None,
            target_tracking_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V3ProvisionConfigTargetTrackingPolicyArgs', 'V3ProvisionConfigTargetTrackingPolicyArgsDict']]]]] = None) -> 'V3ProvisionConfig':
        """
        Get an existing V3ProvisionConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] always_allocate_cpu: Whether the CPU is always allocated. The default value is true.
        :param pulumi.Input[_builtins.bool] always_allocate_gpu: Whether to always assign GPU to function instance
        :param pulumi.Input[_builtins.int] current: (Available since v1.234.0) Number of actual resources
        :param pulumi.Input[_builtins.str] current_error: (Available since v1.234.0) Error message when a Reserved Instance creation fails
        :param pulumi.Input[_builtins.str] function_arn: (Available since v1.234.0) Resource Description of the function
        :param pulumi.Input[_builtins.str] function_name: The name of the function. If this parameter is not specified, the provisioned configurations of all functions are listed.
        :param pulumi.Input[_builtins.str] qualifier: The function alias or LATEST.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V3ProvisionConfigScheduledActionArgs', 'V3ProvisionConfigScheduledActionArgsDict']]]] scheduled_actions: Timing policy configuration See `scheduled_actions` below.
        :param pulumi.Input[_builtins.int] target: Number of reserved target resources. The value range is [0,10000].
        :param pulumi.Input[Sequence[pulumi.Input[Union['V3ProvisionConfigTargetTrackingPolicyArgs', 'V3ProvisionConfigTargetTrackingPolicyArgsDict']]]] target_tracking_policies: Metric tracking scaling policy configuration See `target_tracking_policies` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _V3ProvisionConfigState.__new__(_V3ProvisionConfigState)

        __props__.__dict__["always_allocate_cpu"] = always_allocate_cpu
        __props__.__dict__["always_allocate_gpu"] = always_allocate_gpu
        __props__.__dict__["current"] = current
        __props__.__dict__["current_error"] = current_error
        __props__.__dict__["function_arn"] = function_arn
        __props__.__dict__["function_name"] = function_name
        __props__.__dict__["qualifier"] = qualifier
        __props__.__dict__["scheduled_actions"] = scheduled_actions
        __props__.__dict__["target"] = target
        __props__.__dict__["target_tracking_policies"] = target_tracking_policies
        return V3ProvisionConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alwaysAllocateCpu")
    def always_allocate_cpu(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the CPU is always allocated. The default value is true.
        """
        return pulumi.get(self, "always_allocate_cpu")

    @_builtins.property
    @pulumi.getter(name="alwaysAllocateGpu")
    def always_allocate_gpu(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to always assign GPU to function instance
        """
        return pulumi.get(self, "always_allocate_gpu")

    @_builtins.property
    @pulumi.getter
    def current(self) -> pulumi.Output[_builtins.int]:
        """
        (Available since v1.234.0) Number of actual resources
        """
        return pulumi.get(self, "current")

    @_builtins.property
    @pulumi.getter(name="currentError")
    def current_error(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.234.0) Error message when a Reserved Instance creation fails
        """
        return pulumi.get(self, "current_error")

    @_builtins.property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.234.0) Resource Description of the function
        """
        return pulumi.get(self, "function_arn")

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the function. If this parameter is not specified, the provisioned configurations of all functions are listed.
        """
        return pulumi.get(self, "function_name")

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The function alias or LATEST.
        """
        return pulumi.get(self, "qualifier")

    @_builtins.property
    @pulumi.getter(name="scheduledActions")
    def scheduled_actions(self) -> pulumi.Output[Optional[Sequence['outputs.V3ProvisionConfigScheduledAction']]]:
        """
        Timing policy configuration See `scheduled_actions` below.
        """
        return pulumi.get(self, "scheduled_actions")

    @_builtins.property
    @pulumi.getter
    def target(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of reserved target resources. The value range is [0,10000].
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter(name="targetTrackingPolicies")
    def target_tracking_policies(self) -> pulumi.Output[Optional[Sequence['outputs.V3ProvisionConfigTargetTrackingPolicy']]]:
        """
        Metric tracking scaling policy configuration See `target_tracking_policies` below.
        """
        return pulumi.get(self, "target_tracking_policies")

