# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['V3TriggerArgs', 'V3Trigger']

@pulumi.input_type
class V3TriggerArgs:
    def __init__(__self__, *,
                 function_name: pulumi.Input[_builtins.str],
                 qualifier: pulumi.Input[_builtins.str],
                 trigger_type: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 invocation_role: Optional[pulumi.Input[_builtins.str]] = None,
                 source_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_config: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a V3Trigger resource.
        :param pulumi.Input[_builtins.str] function_name: Function Name
        :param pulumi.Input[_builtins.str] qualifier: The version or alias of the function
        :param pulumi.Input[_builtins.str] trigger_type: The type of the trigger. Currently, the supported types include oss, log, http, timer, tablestore, cdn_events, mns_topic and eventbridge.
        :param pulumi.Input[_builtins.str] description: Description of the trigger
        :param pulumi.Input[_builtins.str] invocation_role: The role required by the event source (such as OSS) to call the function.
        :param pulumi.Input[_builtins.str] source_arn: Trigger Event source ARN
        :param pulumi.Input[_builtins.str] trigger_config: Trigger configuration. The configuration varies for different types of triggers.
        :param pulumi.Input[_builtins.str] trigger_name: Trigger Name
        """
        pulumi.set(__self__, "function_name", function_name)
        pulumi.set(__self__, "qualifier", qualifier)
        pulumi.set(__self__, "trigger_type", trigger_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if invocation_role is not None:
            pulumi.set(__self__, "invocation_role", invocation_role)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)
        if trigger_config is not None:
            pulumi.set(__self__, "trigger_config", trigger_config)
        if trigger_name is not None:
            pulumi.set(__self__, "trigger_name", trigger_name)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[_builtins.str]:
        """
        Function Name
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "function_name", value)

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> pulumi.Input[_builtins.str]:
        """
        The version or alias of the function
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "qualifier", value)

    @_builtins.property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the trigger. Currently, the supported types include oss, log, http, timer, tablestore, cdn_events, mns_topic and eventbridge.
        """
        return pulumi.get(self, "trigger_type")

    @trigger_type.setter
    def trigger_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "trigger_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the trigger
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="invocationRole")
    def invocation_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role required by the event source (such as OSS) to call the function.
        """
        return pulumi.get(self, "invocation_role")

    @invocation_role.setter
    def invocation_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "invocation_role", value)

    @_builtins.property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trigger Event source ARN
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_arn", value)

    @_builtins.property
    @pulumi.getter(name="triggerConfig")
    def trigger_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trigger configuration. The configuration varies for different types of triggers.
        """
        return pulumi.get(self, "trigger_config")

    @trigger_config.setter
    def trigger_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trigger_config", value)

    @_builtins.property
    @pulumi.getter(name="triggerName")
    def trigger_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trigger Name
        """
        return pulumi.get(self, "trigger_name")

    @trigger_name.setter
    def trigger_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trigger_name", value)


@pulumi.input_type
class _V3TriggerState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 http_trigger: Optional[pulumi.Input['V3TriggerHttpTriggerArgs']] = None,
                 invocation_role: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modified_time: Optional[pulumi.Input[_builtins.str]] = None,
                 qualifier: Optional[pulumi.Input[_builtins.str]] = None,
                 source_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 target_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_config: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_id: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_name: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering V3Trigger resources.
        :param pulumi.Input[_builtins.str] create_time: Creation time
        :param pulumi.Input[_builtins.str] description: Description of the trigger
        :param pulumi.Input[_builtins.str] function_name: Function Name
        :param pulumi.Input['V3TriggerHttpTriggerArgs'] http_trigger: (Available since v1.234.0) HTTP trigger information
        :param pulumi.Input[_builtins.str] invocation_role: The role required by the event source (such as OSS) to call the function.
        :param pulumi.Input[_builtins.str] last_modified_time: (Available since v1.234.0) The last modified time of the trigger
        :param pulumi.Input[_builtins.str] qualifier: The version or alias of the function
        :param pulumi.Input[_builtins.str] source_arn: Trigger Event source ARN
        :param pulumi.Input[_builtins.str] status: The state of the trigger
        :param pulumi.Input[_builtins.str] target_arn: (Available since v1.234.0) Resource identity of the function
        :param pulumi.Input[_builtins.str] trigger_config: Trigger configuration. The configuration varies for different types of triggers.
        :param pulumi.Input[_builtins.str] trigger_id: (Available since v1.234.0) Trigger ID
        :param pulumi.Input[_builtins.str] trigger_name: Trigger Name
        :param pulumi.Input[_builtins.str] trigger_type: The type of the trigger. Currently, the supported types include oss, log, http, timer, tablestore, cdn_events, mns_topic and eventbridge.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if http_trigger is not None:
            pulumi.set(__self__, "http_trigger", http_trigger)
        if invocation_role is not None:
            pulumi.set(__self__, "invocation_role", invocation_role)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target_arn is not None:
            pulumi.set(__self__, "target_arn", target_arn)
        if trigger_config is not None:
            pulumi.set(__self__, "trigger_config", trigger_config)
        if trigger_id is not None:
            pulumi.set(__self__, "trigger_id", trigger_id)
        if trigger_name is not None:
            pulumi.set(__self__, "trigger_name", trigger_name)
        if trigger_type is not None:
            pulumi.set(__self__, "trigger_type", trigger_type)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation time
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the trigger
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Function Name
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_name", value)

    @_builtins.property
    @pulumi.getter(name="httpTrigger")
    def http_trigger(self) -> Optional[pulumi.Input['V3TriggerHttpTriggerArgs']]:
        """
        (Available since v1.234.0) HTTP trigger information
        """
        return pulumi.get(self, "http_trigger")

    @http_trigger.setter
    def http_trigger(self, value: Optional[pulumi.Input['V3TriggerHttpTriggerArgs']]):
        pulumi.set(self, "http_trigger", value)

    @_builtins.property
    @pulumi.getter(name="invocationRole")
    def invocation_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role required by the event source (such as OSS) to call the function.
        """
        return pulumi.get(self, "invocation_role")

    @invocation_role.setter
    def invocation_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "invocation_role", value)

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.234.0) The last modified time of the trigger
        """
        return pulumi.get(self, "last_modified_time")

    @last_modified_time.setter
    def last_modified_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modified_time", value)

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version or alias of the function
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualifier", value)

    @_builtins.property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trigger Event source ARN
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_arn", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the trigger
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.234.0) Resource identity of the function
        """
        return pulumi.get(self, "target_arn")

    @target_arn.setter
    def target_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_arn", value)

    @_builtins.property
    @pulumi.getter(name="triggerConfig")
    def trigger_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trigger configuration. The configuration varies for different types of triggers.
        """
        return pulumi.get(self, "trigger_config")

    @trigger_config.setter
    def trigger_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trigger_config", value)

    @_builtins.property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.234.0) Trigger ID
        """
        return pulumi.get(self, "trigger_id")

    @trigger_id.setter
    def trigger_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trigger_id", value)

    @_builtins.property
    @pulumi.getter(name="triggerName")
    def trigger_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trigger Name
        """
        return pulumi.get(self, "trigger_name")

    @trigger_name.setter
    def trigger_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trigger_name", value)

    @_builtins.property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the trigger. Currently, the supported types include oss, log, http, timer, tablestore, cdn_events, mns_topic and eventbridge.
        """
        return pulumi.get(self, "trigger_type")

    @trigger_type.setter
    def trigger_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trigger_type", value)


@pulumi.type_token("alicloud:fc/v3Trigger:V3Trigger")
class V3Trigger(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 invocation_role: Optional[pulumi.Input[_builtins.str]] = None,
                 qualifier: Optional[pulumi.Input[_builtins.str]] = None,
                 source_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_config: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_name: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a FCV3 Trigger resource.

        A trigger is a way of triggering the execution of a function. In the event-driven computing model, the event source is the producer of the event, the function is the handler of the event, and the trigger provides a centralized and unified way to manage different event sources. In the event source, when the event occurs, if the rules defined by the trigger are met,.

        For information about FCV3 Trigger and how to use it, see [What is Trigger](https://www.alibabacloud.com/help/en/functioncompute/api-fc-2023-03-30-createtrigger).

        > **NOTE:** Available since v1.228.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        function_name = config.get("functionName")
        if function_name is None:
            function_name = "TerraformTriggerResourceAPI"
        trigger_name = config.get("triggerName")
        if trigger_name is None:
            trigger_name = "TerraformTrigger_CDN"
        function = alicloud.fc.V3Function("function",
            memory_size=512,
            cpu=0.5,
            handler="index.Handler",
            code={
                "zip_file": "UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=",
            },
            function_name=name,
            runtime="python3.9",
            disk_size=512,
            log_config={
                "log_begin_rule": "None",
            })
        current = alicloud.get_account()
        default = alicloud.fc.V3Trigger("default",
            trigger_type="cdn_events",
            trigger_name=name,
            description="create",
            qualifier="LATEST",
            trigger_config=json.dumps({
                "eventName": "CachedObjectsPushed",
                "eventVersion": "1.0.0",
                "notes": "example",
                "filter": {
                    "domain": ["example.com"],
                },
            }),
            source_arn=f"acs:cdn:*:{current.id}",
            invocation_role=f"acs:ram::{current.id}:role/aliyuncdneventnotificationrole",
            function_name=function.function_name)
        ```

        HTTP Trigger

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        function_name = config.get("functionName")
        if function_name is None:
            function_name = "TerraformTriggerResourceAPI"
        trigger_name = config.get("triggerName")
        if trigger_name is None:
            trigger_name = "TerraformTrigger_HTTP"
        function = alicloud.fc.V3Function("function",
            memory_size=512,
            cpu=0.5,
            handler="index.Handler",
            code={
                "zip_file": "UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=",
            },
            function_name=name,
            runtime="python3.9",
            disk_size=512,
            log_config={
                "log_begin_rule": "None",
            })
        current = alicloud.get_account()
        default = alicloud.fc.V3Trigger("default",
            trigger_type="http",
            trigger_name=name,
            description="create",
            qualifier="LATEST",
            trigger_config=json.dumps({
                "authType": "anonymous",
                "methods": [
                    "GET",
                    "POST",
                ],
            }),
            function_name=function.function_name)
        pulumi.export("outputCalicloudFcv3TriggerInternet", alicloud_fcv3_trigger["default"]["httpTrigger"][0]["urlInternet"])
        pulumi.export("outputCalicloudFcv3TriggerIntranet", alicloud_fcv3_trigger["default"]["httpTrigger"][0]["urlIntranet"])
        ```

        ## Import

        FCV3 Trigger can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:fc/v3Trigger:V3Trigger example <function_name>:<trigger_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the trigger
        :param pulumi.Input[_builtins.str] function_name: Function Name
        :param pulumi.Input[_builtins.str] invocation_role: The role required by the event source (such as OSS) to call the function.
        :param pulumi.Input[_builtins.str] qualifier: The version or alias of the function
        :param pulumi.Input[_builtins.str] source_arn: Trigger Event source ARN
        :param pulumi.Input[_builtins.str] trigger_config: Trigger configuration. The configuration varies for different types of triggers.
        :param pulumi.Input[_builtins.str] trigger_name: Trigger Name
        :param pulumi.Input[_builtins.str] trigger_type: The type of the trigger. Currently, the supported types include oss, log, http, timer, tablestore, cdn_events, mns_topic and eventbridge.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: V3TriggerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a FCV3 Trigger resource.

        A trigger is a way of triggering the execution of a function. In the event-driven computing model, the event source is the producer of the event, the function is the handler of the event, and the trigger provides a centralized and unified way to manage different event sources. In the event source, when the event occurs, if the rules defined by the trigger are met,.

        For information about FCV3 Trigger and how to use it, see [What is Trigger](https://www.alibabacloud.com/help/en/functioncompute/api-fc-2023-03-30-createtrigger).

        > **NOTE:** Available since v1.228.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        function_name = config.get("functionName")
        if function_name is None:
            function_name = "TerraformTriggerResourceAPI"
        trigger_name = config.get("triggerName")
        if trigger_name is None:
            trigger_name = "TerraformTrigger_CDN"
        function = alicloud.fc.V3Function("function",
            memory_size=512,
            cpu=0.5,
            handler="index.Handler",
            code={
                "zip_file": "UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=",
            },
            function_name=name,
            runtime="python3.9",
            disk_size=512,
            log_config={
                "log_begin_rule": "None",
            })
        current = alicloud.get_account()
        default = alicloud.fc.V3Trigger("default",
            trigger_type="cdn_events",
            trigger_name=name,
            description="create",
            qualifier="LATEST",
            trigger_config=json.dumps({
                "eventName": "CachedObjectsPushed",
                "eventVersion": "1.0.0",
                "notes": "example",
                "filter": {
                    "domain": ["example.com"],
                },
            }),
            source_arn=f"acs:cdn:*:{current.id}",
            invocation_role=f"acs:ram::{current.id}:role/aliyuncdneventnotificationrole",
            function_name=function.function_name)
        ```

        HTTP Trigger

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        function_name = config.get("functionName")
        if function_name is None:
            function_name = "TerraformTriggerResourceAPI"
        trigger_name = config.get("triggerName")
        if trigger_name is None:
            trigger_name = "TerraformTrigger_HTTP"
        function = alicloud.fc.V3Function("function",
            memory_size=512,
            cpu=0.5,
            handler="index.Handler",
            code={
                "zip_file": "UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=",
            },
            function_name=name,
            runtime="python3.9",
            disk_size=512,
            log_config={
                "log_begin_rule": "None",
            })
        current = alicloud.get_account()
        default = alicloud.fc.V3Trigger("default",
            trigger_type="http",
            trigger_name=name,
            description="create",
            qualifier="LATEST",
            trigger_config=json.dumps({
                "authType": "anonymous",
                "methods": [
                    "GET",
                    "POST",
                ],
            }),
            function_name=function.function_name)
        pulumi.export("outputCalicloudFcv3TriggerInternet", alicloud_fcv3_trigger["default"]["httpTrigger"][0]["urlInternet"])
        pulumi.export("outputCalicloudFcv3TriggerIntranet", alicloud_fcv3_trigger["default"]["httpTrigger"][0]["urlIntranet"])
        ```

        ## Import

        FCV3 Trigger can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:fc/v3Trigger:V3Trigger example <function_name>:<trigger_name>
        ```

        :param str resource_name: The name of the resource.
        :param V3TriggerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(V3TriggerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 invocation_role: Optional[pulumi.Input[_builtins.str]] = None,
                 qualifier: Optional[pulumi.Input[_builtins.str]] = None,
                 source_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_config: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_name: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = V3TriggerArgs.__new__(V3TriggerArgs)

            __props__.__dict__["description"] = description
            if function_name is None and not opts.urn:
                raise TypeError("Missing required property 'function_name'")
            __props__.__dict__["function_name"] = function_name
            __props__.__dict__["invocation_role"] = invocation_role
            if qualifier is None and not opts.urn:
                raise TypeError("Missing required property 'qualifier'")
            __props__.__dict__["qualifier"] = qualifier
            __props__.__dict__["source_arn"] = source_arn
            __props__.__dict__["trigger_config"] = trigger_config
            __props__.__dict__["trigger_name"] = trigger_name
            if trigger_type is None and not opts.urn:
                raise TypeError("Missing required property 'trigger_type'")
            __props__.__dict__["trigger_type"] = trigger_type
            __props__.__dict__["create_time"] = None
            __props__.__dict__["http_trigger"] = None
            __props__.__dict__["last_modified_time"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["target_arn"] = None
            __props__.__dict__["trigger_id"] = None
        super(V3Trigger, __self__).__init__(
            'alicloud:fc/v3Trigger:V3Trigger',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            function_name: Optional[pulumi.Input[_builtins.str]] = None,
            http_trigger: Optional[pulumi.Input[Union['V3TriggerHttpTriggerArgs', 'V3TriggerHttpTriggerArgsDict']]] = None,
            invocation_role: Optional[pulumi.Input[_builtins.str]] = None,
            last_modified_time: Optional[pulumi.Input[_builtins.str]] = None,
            qualifier: Optional[pulumi.Input[_builtins.str]] = None,
            source_arn: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            target_arn: Optional[pulumi.Input[_builtins.str]] = None,
            trigger_config: Optional[pulumi.Input[_builtins.str]] = None,
            trigger_id: Optional[pulumi.Input[_builtins.str]] = None,
            trigger_name: Optional[pulumi.Input[_builtins.str]] = None,
            trigger_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'V3Trigger':
        """
        Get an existing V3Trigger resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Creation time
        :param pulumi.Input[_builtins.str] description: Description of the trigger
        :param pulumi.Input[_builtins.str] function_name: Function Name
        :param pulumi.Input[Union['V3TriggerHttpTriggerArgs', 'V3TriggerHttpTriggerArgsDict']] http_trigger: (Available since v1.234.0) HTTP trigger information
        :param pulumi.Input[_builtins.str] invocation_role: The role required by the event source (such as OSS) to call the function.
        :param pulumi.Input[_builtins.str] last_modified_time: (Available since v1.234.0) The last modified time of the trigger
        :param pulumi.Input[_builtins.str] qualifier: The version or alias of the function
        :param pulumi.Input[_builtins.str] source_arn: Trigger Event source ARN
        :param pulumi.Input[_builtins.str] status: The state of the trigger
        :param pulumi.Input[_builtins.str] target_arn: (Available since v1.234.0) Resource identity of the function
        :param pulumi.Input[_builtins.str] trigger_config: Trigger configuration. The configuration varies for different types of triggers.
        :param pulumi.Input[_builtins.str] trigger_id: (Available since v1.234.0) Trigger ID
        :param pulumi.Input[_builtins.str] trigger_name: Trigger Name
        :param pulumi.Input[_builtins.str] trigger_type: The type of the trigger. Currently, the supported types include oss, log, http, timer, tablestore, cdn_events, mns_topic and eventbridge.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _V3TriggerState.__new__(_V3TriggerState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["function_name"] = function_name
        __props__.__dict__["http_trigger"] = http_trigger
        __props__.__dict__["invocation_role"] = invocation_role
        __props__.__dict__["last_modified_time"] = last_modified_time
        __props__.__dict__["qualifier"] = qualifier
        __props__.__dict__["source_arn"] = source_arn
        __props__.__dict__["status"] = status
        __props__.__dict__["target_arn"] = target_arn
        __props__.__dict__["trigger_config"] = trigger_config
        __props__.__dict__["trigger_id"] = trigger_id
        __props__.__dict__["trigger_name"] = trigger_name
        __props__.__dict__["trigger_type"] = trigger_type
        return V3Trigger(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Creation time
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the trigger
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[_builtins.str]:
        """
        Function Name
        """
        return pulumi.get(self, "function_name")

    @_builtins.property
    @pulumi.getter(name="httpTrigger")
    def http_trigger(self) -> pulumi.Output['outputs.V3TriggerHttpTrigger']:
        """
        (Available since v1.234.0) HTTP trigger information
        """
        return pulumi.get(self, "http_trigger")

    @_builtins.property
    @pulumi.getter(name="invocationRole")
    def invocation_role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The role required by the event source (such as OSS) to call the function.
        """
        return pulumi.get(self, "invocation_role")

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.234.0) The last modified time of the trigger
        """
        return pulumi.get(self, "last_modified_time")

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> pulumi.Output[_builtins.str]:
        """
        The version or alias of the function
        """
        return pulumi.get(self, "qualifier")

    @_builtins.property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> pulumi.Output[_builtins.str]:
        """
        Trigger Event source ARN
        """
        return pulumi.get(self, "source_arn")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the trigger
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.234.0) Resource identity of the function
        """
        return pulumi.get(self, "target_arn")

    @_builtins.property
    @pulumi.getter(name="triggerConfig")
    def trigger_config(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Trigger configuration. The configuration varies for different types of triggers.
        """
        return pulumi.get(self, "trigger_config")

    @_builtins.property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.234.0) Trigger ID
        """
        return pulumi.get(self, "trigger_id")

    @_builtins.property
    @pulumi.getter(name="triggerName")
    def trigger_name(self) -> pulumi.Output[_builtins.str]:
        """
        Trigger Name
        """
        return pulumi.get(self, "trigger_name")

    @_builtins.property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the trigger. Currently, the supported types include oss, log, http, timer, tablestore, cdn_events, mns_topic and eventbridge.
        """
        return pulumi.get(self, "trigger_type")

