# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FlowArgs', 'Flow']

@pulumi.input_type
class FlowArgs:
    def __init__(__self__, *,
                 definition: pulumi.Input[_builtins.str],
                 description: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Flow resource.
        :param pulumi.Input[_builtins.str] definition: The definition of the flow. It must comply with the Flow Definition Language (FDL) syntax.
        :param pulumi.Input[_builtins.str] description: The description of the flow.
        :param pulumi.Input[_builtins.str] type: The type of the flow. Valid values are `FDL` or `DEFAULT`.
        :param pulumi.Input[_builtins.str] name: The name of the flow. The name must be unique in an Alibaba Cloud account.
        :param pulumi.Input[_builtins.str] role_arn: The ARN of the specified RAM role that Serverless Workflow uses to assume the role when Serverless Workflow executes a flow.
        """
        pulumi.set(__self__, "definition", definition)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @_builtins.property
    @pulumi.getter
    def definition(self) -> pulumi.Input[_builtins.str]:
        """
        The definition of the flow. It must comply with the Flow Definition Language (FDL) syntax.
        """
        return pulumi.get(self, "definition")

    @definition.setter
    def definition(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "definition", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        The description of the flow.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the flow. Valid values are `FDL` or `DEFAULT`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the flow. The name must be unique in an Alibaba Cloud account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the specified RAM role that Serverless Workflow uses to assume the role when Serverless Workflow executes a flow.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)


@pulumi.input_type
class _FlowState:
    def __init__(__self__, *,
                 definition: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 flow_id: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modified_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Flow resources.
        :param pulumi.Input[_builtins.str] definition: The definition of the flow. It must comply with the Flow Definition Language (FDL) syntax.
        :param pulumi.Input[_builtins.str] description: The description of the flow.
        :param pulumi.Input[_builtins.str] flow_id: The unique ID of the flow.
        :param pulumi.Input[_builtins.str] last_modified_time: The time when the flow was last modified.
        :param pulumi.Input[_builtins.str] name: The name of the flow. The name must be unique in an Alibaba Cloud account.
        :param pulumi.Input[_builtins.str] role_arn: The ARN of the specified RAM role that Serverless Workflow uses to assume the role when Serverless Workflow executes a flow.
        :param pulumi.Input[_builtins.str] type: The type of the flow. Valid values are `FDL` or `DEFAULT`.
        """
        if definition is not None:
            pulumi.set(__self__, "definition", definition)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if flow_id is not None:
            pulumi.set(__self__, "flow_id", flow_id)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def definition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The definition of the flow. It must comply with the Flow Definition Language (FDL) syntax.
        """
        return pulumi.get(self, "definition")

    @definition.setter
    def definition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "definition", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the flow.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="flowId")
    def flow_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique ID of the flow.
        """
        return pulumi.get(self, "flow_id")

    @flow_id.setter
    def flow_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flow_id", value)

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the flow was last modified.
        """
        return pulumi.get(self, "last_modified_time")

    @last_modified_time.setter
    def last_modified_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modified_time", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the flow. The name must be unique in an Alibaba Cloud account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the specified RAM role that Serverless Workflow uses to assume the role when Serverless Workflow executes a flow.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the flow. Valid values are `FDL` or `DEFAULT`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("alicloud:fnf/flow:Flow")
class Flow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 definition: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Serverless Workflow Flow resource.

        For information about Serverless Workflow Flow and how to use it, see [What is Flow](https://www.alibabacloud.com/help/en/doc-detail/123079.htm).

        > **NOTE:** Available since v1.105.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.ram.Role("default",
            name="tf-example-fnfflow",
            document=\"\"\"  {
            "Statement": [
              {
                "Action": "sts:AssumeRole",
                "Effect": "Allow",
                "Principal": {
                  "Service": [
                    "fnf.aliyuncs.com"
                  ]
                }
              }
            ],
            "Version": "1"
          }
        \"\"\")
        example = alicloud.fnf.Flow("example",
            definition=\"\"\"  version: v1beta1
          type: flow
          steps:
            - type: pass
              name: helloworld
        \"\"\",
            role_arn=default.arn,
            description="Test for terraform fnf_flow.",
            name="tf-example-flow",
            type="FDL")
        ```

        ## Import

        Serverless Workflow Flow can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:fnf/flow:Flow example <name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] definition: The definition of the flow. It must comply with the Flow Definition Language (FDL) syntax.
        :param pulumi.Input[_builtins.str] description: The description of the flow.
        :param pulumi.Input[_builtins.str] name: The name of the flow. The name must be unique in an Alibaba Cloud account.
        :param pulumi.Input[_builtins.str] role_arn: The ARN of the specified RAM role that Serverless Workflow uses to assume the role when Serverless Workflow executes a flow.
        :param pulumi.Input[_builtins.str] type: The type of the flow. Valid values are `FDL` or `DEFAULT`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Serverless Workflow Flow resource.

        For information about Serverless Workflow Flow and how to use it, see [What is Flow](https://www.alibabacloud.com/help/en/doc-detail/123079.htm).

        > **NOTE:** Available since v1.105.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.ram.Role("default",
            name="tf-example-fnfflow",
            document=\"\"\"  {
            "Statement": [
              {
                "Action": "sts:AssumeRole",
                "Effect": "Allow",
                "Principal": {
                  "Service": [
                    "fnf.aliyuncs.com"
                  ]
                }
              }
            ],
            "Version": "1"
          }
        \"\"\")
        example = alicloud.fnf.Flow("example",
            definition=\"\"\"  version: v1beta1
          type: flow
          steps:
            - type: pass
              name: helloworld
        \"\"\",
            role_arn=default.arn,
            description="Test for terraform fnf_flow.",
            name="tf-example-flow",
            type="FDL")
        ```

        ## Import

        Serverless Workflow Flow can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:fnf/flow:Flow example <name>
        ```

        :param str resource_name: The name of the resource.
        :param FlowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 definition: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlowArgs.__new__(FlowArgs)

            if definition is None and not opts.urn:
                raise TypeError("Missing required property 'definition'")
            __props__.__dict__["definition"] = definition
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["role_arn"] = role_arn
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["flow_id"] = None
            __props__.__dict__["last_modified_time"] = None
        super(Flow, __self__).__init__(
            'alicloud:fnf/flow:Flow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            definition: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            flow_id: Optional[pulumi.Input[_builtins.str]] = None,
            last_modified_time: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Flow':
        """
        Get an existing Flow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] definition: The definition of the flow. It must comply with the Flow Definition Language (FDL) syntax.
        :param pulumi.Input[_builtins.str] description: The description of the flow.
        :param pulumi.Input[_builtins.str] flow_id: The unique ID of the flow.
        :param pulumi.Input[_builtins.str] last_modified_time: The time when the flow was last modified.
        :param pulumi.Input[_builtins.str] name: The name of the flow. The name must be unique in an Alibaba Cloud account.
        :param pulumi.Input[_builtins.str] role_arn: The ARN of the specified RAM role that Serverless Workflow uses to assume the role when Serverless Workflow executes a flow.
        :param pulumi.Input[_builtins.str] type: The type of the flow. Valid values are `FDL` or `DEFAULT`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlowState.__new__(_FlowState)

        __props__.__dict__["definition"] = definition
        __props__.__dict__["description"] = description
        __props__.__dict__["flow_id"] = flow_id
        __props__.__dict__["last_modified_time"] = last_modified_time
        __props__.__dict__["name"] = name
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["type"] = type
        return Flow(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def definition(self) -> pulumi.Output[_builtins.str]:
        """
        The definition of the flow. It must comply with the Flow Definition Language (FDL) syntax.
        """
        return pulumi.get(self, "definition")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the flow.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="flowId")
    def flow_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique ID of the flow.
        """
        return pulumi.get(self, "flow_id")

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the flow was last modified.
        """
        return pulumi.get(self, "last_modified_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the flow. The name must be unique in an Alibaba Cloud account.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ARN of the specified RAM role that Serverless Workflow uses to assume the role when Serverless Workflow executes a flow.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the flow. Valid values are `FDL` or `DEFAULT`.
        """
        return pulumi.get(self, "type")

