# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['StreamingJobArgs', 'StreamingJob']

@pulumi.input_type
class StreamingJobArgs:
    def __init__(__self__, *,
                 data_source_id: pulumi.Input[_builtins.str],
                 db_instance_id: pulumi.Input[_builtins.str],
                 job_name: pulumi.Input[_builtins.str],
                 account: Optional[pulumi.Input[_builtins.str]] = None,
                 consistency: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dest_database: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_table: Optional[pulumi.Input[_builtins.str]] = None,
                 error_limit_count: Optional[pulumi.Input[_builtins.int]] = None,
                 fallback_offset: Optional[pulumi.Input[_builtins.str]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 job_config: Optional[pulumi.Input[_builtins.str]] = None,
                 job_description: Optional[pulumi.Input[_builtins.str]] = None,
                 match_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 src_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 try_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 update_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 write_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a StreamingJob resource.
        :param pulumi.Input[_builtins.str] data_source_id: The data source ID.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] job_name: The name of the job.
        :param pulumi.Input[_builtins.str] account: The name of the database account.
        :param pulumi.Input[_builtins.str] consistency: The delivery guarantee setting.
               
               Valid values:
               
               - ATLEAST
               - EXACTLY
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dest_columns: Target Field
        :param pulumi.Input[_builtins.str] dest_database: The name of the destination database.
        :param pulumi.Input[_builtins.str] dest_schema: Target Schema
        :param pulumi.Input[_builtins.str] dest_table: The name of the destination table.
        :param pulumi.Input[_builtins.int] error_limit_count: The number of allowed error rows. Write failures occur when Kafka data does not match the destination table in AnalyticDB for PostgreSQL. If the specified value is exceeded, the job fails.
        :param pulumi.Input[_builtins.str] fallback_offset: Automatic offset reset
        :param pulumi.Input[_builtins.str] group_name: Group Name
        :param pulumi.Input[_builtins.str] job_config: The YAML configuration file of the job. This parameter must be specified when Mode is set to professional.
        :param pulumi.Input[_builtins.str] job_description: The description of the job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] match_columns: Match Field
        :param pulumi.Input[_builtins.str] mode: The configuration mode. Valid values:
               
               1.  basic: In basic mode, you must configure the configuration parameters.
               
               2.  professional: In professional mode, you can submit a YAML configuration file.
        :param pulumi.Input[_builtins.str] password: The password of the database account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] src_columns: Source Field
        :param pulumi.Input[_builtins.bool] try_run: Specifies whether to test the real-time job. Valid values:
               
               - true
               - false
               
               Default value: false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] update_columns: Update Field
        :param pulumi.Input[_builtins.str] write_mode: The write mode.
               
               Valid values:
               
               - insert
               - update
               - merge
        """
        pulumi.set(__self__, "data_source_id", data_source_id)
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "job_name", job_name)
        if account is not None:
            pulumi.set(__self__, "account", account)
        if consistency is not None:
            pulumi.set(__self__, "consistency", consistency)
        if dest_columns is not None:
            pulumi.set(__self__, "dest_columns", dest_columns)
        if dest_database is not None:
            pulumi.set(__self__, "dest_database", dest_database)
        if dest_schema is not None:
            pulumi.set(__self__, "dest_schema", dest_schema)
        if dest_table is not None:
            pulumi.set(__self__, "dest_table", dest_table)
        if error_limit_count is not None:
            pulumi.set(__self__, "error_limit_count", error_limit_count)
        if fallback_offset is not None:
            pulumi.set(__self__, "fallback_offset", fallback_offset)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if job_config is not None:
            pulumi.set(__self__, "job_config", job_config)
        if job_description is not None:
            pulumi.set(__self__, "job_description", job_description)
        if match_columns is not None:
            pulumi.set(__self__, "match_columns", match_columns)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if src_columns is not None:
            pulumi.set(__self__, "src_columns", src_columns)
        if try_run is not None:
            pulumi.set(__self__, "try_run", try_run)
        if update_columns is not None:
            pulumi.set(__self__, "update_columns", update_columns)
        if write_mode is not None:
            pulumi.set(__self__, "write_mode", write_mode)

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> pulumi.Input[_builtins.str]:
        """
        The data source ID.
        """
        return pulumi.get(self, "data_source_id")

    @data_source_id.setter
    def data_source_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_source_id", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="jobName")
    def job_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the job.
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "job_name", value)

    @_builtins.property
    @pulumi.getter
    def account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database account.
        """
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account", value)

    @_builtins.property
    @pulumi.getter
    def consistency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The delivery guarantee setting.

        Valid values:

        - ATLEAST
        - EXACTLY
        """
        return pulumi.get(self, "consistency")

    @consistency.setter
    def consistency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "consistency", value)

    @_builtins.property
    @pulumi.getter(name="destColumns")
    def dest_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Target Field
        """
        return pulumi.get(self, "dest_columns")

    @dest_columns.setter
    def dest_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dest_columns", value)

    @_builtins.property
    @pulumi.getter(name="destDatabase")
    def dest_database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the destination database.
        """
        return pulumi.get(self, "dest_database")

    @dest_database.setter
    def dest_database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_database", value)

    @_builtins.property
    @pulumi.getter(name="destSchema")
    def dest_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Target Schema
        """
        return pulumi.get(self, "dest_schema")

    @dest_schema.setter
    def dest_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_schema", value)

    @_builtins.property
    @pulumi.getter(name="destTable")
    def dest_table(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the destination table.
        """
        return pulumi.get(self, "dest_table")

    @dest_table.setter
    def dest_table(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_table", value)

    @_builtins.property
    @pulumi.getter(name="errorLimitCount")
    def error_limit_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of allowed error rows. Write failures occur when Kafka data does not match the destination table in AnalyticDB for PostgreSQL. If the specified value is exceeded, the job fails.
        """
        return pulumi.get(self, "error_limit_count")

    @error_limit_count.setter
    def error_limit_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "error_limit_count", value)

    @_builtins.property
    @pulumi.getter(name="fallbackOffset")
    def fallback_offset(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic offset reset
        """
        return pulumi.get(self, "fallback_offset")

    @fallback_offset.setter
    def fallback_offset(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fallback_offset", value)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group Name
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_name", value)

    @_builtins.property
    @pulumi.getter(name="jobConfig")
    def job_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The YAML configuration file of the job. This parameter must be specified when Mode is set to professional.
        """
        return pulumi.get(self, "job_config")

    @job_config.setter
    def job_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_config", value)

    @_builtins.property
    @pulumi.getter(name="jobDescription")
    def job_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the job.
        """
        return pulumi.get(self, "job_description")

    @job_description.setter
    def job_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_description", value)

    @_builtins.property
    @pulumi.getter(name="matchColumns")
    def match_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Match Field
        """
        return pulumi.get(self, "match_columns")

    @match_columns.setter
    def match_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "match_columns", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration mode. Valid values:

        1.  basic: In basic mode, you must configure the configuration parameters.

        2.  professional: In professional mode, you can submit a YAML configuration file.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the database account.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="srcColumns")
    def src_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Source Field
        """
        return pulumi.get(self, "src_columns")

    @src_columns.setter
    def src_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "src_columns", value)

    @_builtins.property
    @pulumi.getter(name="tryRun")
    def try_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to test the real-time job. Valid values:

        - true
        - false

        Default value: false.
        """
        return pulumi.get(self, "try_run")

    @try_run.setter
    def try_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "try_run", value)

    @_builtins.property
    @pulumi.getter(name="updateColumns")
    def update_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Update Field
        """
        return pulumi.get(self, "update_columns")

    @update_columns.setter
    def update_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "update_columns", value)

    @_builtins.property
    @pulumi.getter(name="writeMode")
    def write_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The write mode.

        Valid values:

        - insert
        - update
        - merge
        """
        return pulumi.get(self, "write_mode")

    @write_mode.setter
    def write_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "write_mode", value)


@pulumi.input_type
class _StreamingJobState:
    def __init__(__self__, *,
                 account: Optional[pulumi.Input[_builtins.str]] = None,
                 consistency: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dest_database: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_table: Optional[pulumi.Input[_builtins.str]] = None,
                 error_limit_count: Optional[pulumi.Input[_builtins.int]] = None,
                 fallback_offset: Optional[pulumi.Input[_builtins.str]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 job_config: Optional[pulumi.Input[_builtins.str]] = None,
                 job_description: Optional[pulumi.Input[_builtins.str]] = None,
                 job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 match_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 src_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 try_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 update_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 write_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StreamingJob resources.
        :param pulumi.Input[_builtins.str] account: The name of the database account.
        :param pulumi.Input[_builtins.str] consistency: The delivery guarantee setting.
               
               Valid values:
               
               - ATLEAST
               - EXACTLY
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] data_source_id: The data source ID.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dest_columns: Target Field
        :param pulumi.Input[_builtins.str] dest_database: The name of the destination database.
        :param pulumi.Input[_builtins.str] dest_schema: Target Schema
        :param pulumi.Input[_builtins.str] dest_table: The name of the destination table.
        :param pulumi.Input[_builtins.int] error_limit_count: The number of allowed error rows. Write failures occur when Kafka data does not match the destination table in AnalyticDB for PostgreSQL. If the specified value is exceeded, the job fails.
        :param pulumi.Input[_builtins.str] fallback_offset: Automatic offset reset
        :param pulumi.Input[_builtins.str] group_name: Group Name
        :param pulumi.Input[_builtins.str] job_config: The YAML configuration file of the job. This parameter must be specified when Mode is set to professional.
        :param pulumi.Input[_builtins.str] job_description: The description of the job.
        :param pulumi.Input[_builtins.str] job_id: The job ID.
        :param pulumi.Input[_builtins.str] job_name: The name of the job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] match_columns: Match Field
        :param pulumi.Input[_builtins.str] mode: The configuration mode. Valid values:
               
               1.  basic: In basic mode, you must configure the configuration parameters.
               
               2.  professional: In professional mode, you can submit a YAML configuration file.
        :param pulumi.Input[_builtins.str] password: The password of the database account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] src_columns: Source Field
        :param pulumi.Input[_builtins.str] status: Service status, value:
        :param pulumi.Input[_builtins.bool] try_run: Specifies whether to test the real-time job. Valid values:
               
               - true
               - false
               
               Default value: false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] update_columns: Update Field
        :param pulumi.Input[_builtins.str] write_mode: The write mode.
               
               Valid values:
               
               - insert
               - update
               - merge
        """
        if account is not None:
            pulumi.set(__self__, "account", account)
        if consistency is not None:
            pulumi.set(__self__, "consistency", consistency)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_source_id is not None:
            pulumi.set(__self__, "data_source_id", data_source_id)
        if db_instance_id is not None:
            pulumi.set(__self__, "db_instance_id", db_instance_id)
        if dest_columns is not None:
            pulumi.set(__self__, "dest_columns", dest_columns)
        if dest_database is not None:
            pulumi.set(__self__, "dest_database", dest_database)
        if dest_schema is not None:
            pulumi.set(__self__, "dest_schema", dest_schema)
        if dest_table is not None:
            pulumi.set(__self__, "dest_table", dest_table)
        if error_limit_count is not None:
            pulumi.set(__self__, "error_limit_count", error_limit_count)
        if fallback_offset is not None:
            pulumi.set(__self__, "fallback_offset", fallback_offset)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if job_config is not None:
            pulumi.set(__self__, "job_config", job_config)
        if job_description is not None:
            pulumi.set(__self__, "job_description", job_description)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if job_name is not None:
            pulumi.set(__self__, "job_name", job_name)
        if match_columns is not None:
            pulumi.set(__self__, "match_columns", match_columns)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if src_columns is not None:
            pulumi.set(__self__, "src_columns", src_columns)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if try_run is not None:
            pulumi.set(__self__, "try_run", try_run)
        if update_columns is not None:
            pulumi.set(__self__, "update_columns", update_columns)
        if write_mode is not None:
            pulumi.set(__self__, "write_mode", write_mode)

    @_builtins.property
    @pulumi.getter
    def account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database account.
        """
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account", value)

    @_builtins.property
    @pulumi.getter
    def consistency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The delivery guarantee setting.

        Valid values:

        - ATLEAST
        - EXACTLY
        """
        return pulumi.get(self, "consistency")

    @consistency.setter
    def consistency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "consistency", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data source ID.
        """
        return pulumi.get(self, "data_source_id")

    @data_source_id.setter
    def data_source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_id", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="destColumns")
    def dest_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Target Field
        """
        return pulumi.get(self, "dest_columns")

    @dest_columns.setter
    def dest_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dest_columns", value)

    @_builtins.property
    @pulumi.getter(name="destDatabase")
    def dest_database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the destination database.
        """
        return pulumi.get(self, "dest_database")

    @dest_database.setter
    def dest_database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_database", value)

    @_builtins.property
    @pulumi.getter(name="destSchema")
    def dest_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Target Schema
        """
        return pulumi.get(self, "dest_schema")

    @dest_schema.setter
    def dest_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_schema", value)

    @_builtins.property
    @pulumi.getter(name="destTable")
    def dest_table(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the destination table.
        """
        return pulumi.get(self, "dest_table")

    @dest_table.setter
    def dest_table(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_table", value)

    @_builtins.property
    @pulumi.getter(name="errorLimitCount")
    def error_limit_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of allowed error rows. Write failures occur when Kafka data does not match the destination table in AnalyticDB for PostgreSQL. If the specified value is exceeded, the job fails.
        """
        return pulumi.get(self, "error_limit_count")

    @error_limit_count.setter
    def error_limit_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "error_limit_count", value)

    @_builtins.property
    @pulumi.getter(name="fallbackOffset")
    def fallback_offset(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic offset reset
        """
        return pulumi.get(self, "fallback_offset")

    @fallback_offset.setter
    def fallback_offset(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fallback_offset", value)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group Name
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_name", value)

    @_builtins.property
    @pulumi.getter(name="jobConfig")
    def job_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The YAML configuration file of the job. This parameter must be specified when Mode is set to professional.
        """
        return pulumi.get(self, "job_config")

    @job_config.setter
    def job_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_config", value)

    @_builtins.property
    @pulumi.getter(name="jobDescription")
    def job_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the job.
        """
        return pulumi.get(self, "job_description")

    @job_description.setter
    def job_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_description", value)

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The job ID.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_id", value)

    @_builtins.property
    @pulumi.getter(name="jobName")
    def job_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the job.
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_name", value)

    @_builtins.property
    @pulumi.getter(name="matchColumns")
    def match_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Match Field
        """
        return pulumi.get(self, "match_columns")

    @match_columns.setter
    def match_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "match_columns", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration mode. Valid values:

        1.  basic: In basic mode, you must configure the configuration parameters.

        2.  professional: In professional mode, you can submit a YAML configuration file.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the database account.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="srcColumns")
    def src_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Source Field
        """
        return pulumi.get(self, "src_columns")

    @src_columns.setter
    def src_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "src_columns", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service status, value:
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="tryRun")
    def try_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to test the real-time job. Valid values:

        - true
        - false

        Default value: false.
        """
        return pulumi.get(self, "try_run")

    @try_run.setter
    def try_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "try_run", value)

    @_builtins.property
    @pulumi.getter(name="updateColumns")
    def update_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Update Field
        """
        return pulumi.get(self, "update_columns")

    @update_columns.setter
    def update_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "update_columns", value)

    @_builtins.property
    @pulumi.getter(name="writeMode")
    def write_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The write mode.

        Valid values:

        - insert
        - update
        - merge
        """
        return pulumi.get(self, "write_mode")

    @write_mode.setter
    def write_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "write_mode", value)


@pulumi.type_token("alicloud:gpdb/streamingJob:StreamingJob")
class StreamingJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account: Optional[pulumi.Input[_builtins.str]] = None,
                 consistency: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dest_database: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_table: Optional[pulumi.Input[_builtins.str]] = None,
                 error_limit_count: Optional[pulumi.Input[_builtins.int]] = None,
                 fallback_offset: Optional[pulumi.Input[_builtins.str]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 job_config: Optional[pulumi.Input[_builtins.str]] = None,
                 job_description: Optional[pulumi.Input[_builtins.str]] = None,
                 job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 match_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 src_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 try_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 update_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 write_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a GPDB Streaming Job resource.

        Real-time data tasks.

        For information about GPDB Streaming Job and how to use it, see [What is Streaming Job](https://www.alibabacloud.com/help/en/analyticdb/analyticdb-for-postgresql/developer-reference/api-gpdb-2016-05-03-createstreamingjob).

        > **NOTE:** Available since v1.231.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_t_xqb15 = alicloud.vpc.Network("defaultTXqb15", cidr_block="192.168.0.0/16")
        defaulta_s_whb_t = alicloud.vpc.Switch("defaultaSWhbT",
            vpc_id=default_t_xqb15.id,
            zone_id="cn-beijing-h",
            cidr_block="192.168.1.0/24")
        defaulth2ghc1 = alicloud.gpdb.Instance("defaulth2ghc1",
            instance_spec="2C8G",
            description=name,
            seg_node_num=2,
            seg_storage_type="cloud_essd",
            instance_network_type="VPC",
            db_instance_category="Basic",
            payment_type="PayAsYouGo",
            ssl_enabled=0,
            engine_version="6.0",
            zone_id="cn-beijing-h",
            vswitch_id=defaulta_s_whb_t.id,
            storage_size=50,
            master_cu=4,
            vpc_id=default_t_xqb15.id,
            db_instance_mode="StorageElastic",
            engine="gpdb")
        default2d_usz_y = alicloud.gpdb.StreamingDataService("default2dUszY",
            service_name="example",
            db_instance_id=defaulth2ghc1.id,
            service_description="example",
            service_spec="8")
        defaultc_dq_itu = alicloud.gpdb.StreamingDataSource("defaultcDQItu",
            db_instance_id=defaulth2ghc1.id,
            data_source_name="example",
            data_source_config=json.dumps({
                "brokers": "alikafka-post-cn-g4t3t4eod004-1-vpc.alikafka.aliyuncs.com:9092,alikafka-post-cn-g4t3t4eod004-2-vpc.alikafka.aliyuncs.com:9092,alikafka-post-cn-g4t3t4eod004-3-vpc.alikafka.aliyuncs.com:9092",
                "delimiter": "|",
                "format": "delimited",
                "topic": "ziyuan_example",
            }),
            data_source_type="kafka",
            data_source_description="example",
            service_id=default2d_usz_y.service_id)
        default = alicloud.gpdb.StreamingJob("default",
            account="example_001",
            dest_schema="public",
            mode="professional",
            job_name="example-kafka",
            job_description="example-kafka",
            dest_database="adb_sampledata_tpch",
            db_instance_id=defaulth2ghc1.id,
            dest_table="customer",
            data_source_id=defaultc_dq_itu.data_source_id,
            password="example_001",
            job_config=\"\"\"ATABASE: adb_sampledata_tpch
        USER: example_001
        PASSWORD: example_001
        HOST: gp-2zean69451zsjj139-master.gpdb.rds.aliyuncs.com
        PORT: 5432
        KAFKA:
          INPUT:
            SOURCE:
              BROKERS: alikafka-post-cn-3mp3t4ekq004-1-vpc.alikafka.aliyuncs.com:9092
              TOPIC: ziyuan_example
              FALLBACK_OFFSET: LATEST
            KEY:
              COLUMNS:
              - NAME: c_custkey
                TYPE: int
              FORMAT: delimited
              DELIMITED_OPTION:
                DELIMITER: \\'|\\'
            VALUE:
              COLUMNS:
              - NAME: c_comment
                TYPE: varchar
              FORMAT: delimited
              DELIMITED_OPTION:
                DELIMITER: \\'|\\'
            ERROR_LIMIT: 10
          OUTPUT:
            SCHEMA: public
            TABLE: customer
            MODE: MERGE
            MATCH_COLUMNS:
            - c_custkey
            ORDER_COLUMNS:
            - c_custkey
            UPDATE_COLUMNS:
            - c_custkey
            MAPPING:
            - NAME: c_custkey
              EXPRESSION: c_custkey
          COMMIT:
            MAX_ROW: 1000
            MINIMAL_INTERVAL: 1000
            CONSISTENCY: ATLEAST
          POLL:
            BATCHSIZE: 1000
            TIMEOUT: 1000
          PROPERTIES:
            group.id: ziyuan_example_01
        \"\"\")
        ```

        ## Import

        GPDB Streaming Job can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gpdb/streamingJob:StreamingJob example <db_instance_id>:<job_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account: The name of the database account.
        :param pulumi.Input[_builtins.str] consistency: The delivery guarantee setting.
               
               Valid values:
               
               - ATLEAST
               - EXACTLY
        :param pulumi.Input[_builtins.str] data_source_id: The data source ID.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dest_columns: Target Field
        :param pulumi.Input[_builtins.str] dest_database: The name of the destination database.
        :param pulumi.Input[_builtins.str] dest_schema: Target Schema
        :param pulumi.Input[_builtins.str] dest_table: The name of the destination table.
        :param pulumi.Input[_builtins.int] error_limit_count: The number of allowed error rows. Write failures occur when Kafka data does not match the destination table in AnalyticDB for PostgreSQL. If the specified value is exceeded, the job fails.
        :param pulumi.Input[_builtins.str] fallback_offset: Automatic offset reset
        :param pulumi.Input[_builtins.str] group_name: Group Name
        :param pulumi.Input[_builtins.str] job_config: The YAML configuration file of the job. This parameter must be specified when Mode is set to professional.
        :param pulumi.Input[_builtins.str] job_description: The description of the job.
        :param pulumi.Input[_builtins.str] job_name: The name of the job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] match_columns: Match Field
        :param pulumi.Input[_builtins.str] mode: The configuration mode. Valid values:
               
               1.  basic: In basic mode, you must configure the configuration parameters.
               
               2.  professional: In professional mode, you can submit a YAML configuration file.
        :param pulumi.Input[_builtins.str] password: The password of the database account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] src_columns: Source Field
        :param pulumi.Input[_builtins.bool] try_run: Specifies whether to test the real-time job. Valid values:
               
               - true
               - false
               
               Default value: false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] update_columns: Update Field
        :param pulumi.Input[_builtins.str] write_mode: The write mode.
               
               Valid values:
               
               - insert
               - update
               - merge
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamingJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a GPDB Streaming Job resource.

        Real-time data tasks.

        For information about GPDB Streaming Job and how to use it, see [What is Streaming Job](https://www.alibabacloud.com/help/en/analyticdb/analyticdb-for-postgresql/developer-reference/api-gpdb-2016-05-03-createstreamingjob).

        > **NOTE:** Available since v1.231.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_t_xqb15 = alicloud.vpc.Network("defaultTXqb15", cidr_block="192.168.0.0/16")
        defaulta_s_whb_t = alicloud.vpc.Switch("defaultaSWhbT",
            vpc_id=default_t_xqb15.id,
            zone_id="cn-beijing-h",
            cidr_block="192.168.1.0/24")
        defaulth2ghc1 = alicloud.gpdb.Instance("defaulth2ghc1",
            instance_spec="2C8G",
            description=name,
            seg_node_num=2,
            seg_storage_type="cloud_essd",
            instance_network_type="VPC",
            db_instance_category="Basic",
            payment_type="PayAsYouGo",
            ssl_enabled=0,
            engine_version="6.0",
            zone_id="cn-beijing-h",
            vswitch_id=defaulta_s_whb_t.id,
            storage_size=50,
            master_cu=4,
            vpc_id=default_t_xqb15.id,
            db_instance_mode="StorageElastic",
            engine="gpdb")
        default2d_usz_y = alicloud.gpdb.StreamingDataService("default2dUszY",
            service_name="example",
            db_instance_id=defaulth2ghc1.id,
            service_description="example",
            service_spec="8")
        defaultc_dq_itu = alicloud.gpdb.StreamingDataSource("defaultcDQItu",
            db_instance_id=defaulth2ghc1.id,
            data_source_name="example",
            data_source_config=json.dumps({
                "brokers": "alikafka-post-cn-g4t3t4eod004-1-vpc.alikafka.aliyuncs.com:9092,alikafka-post-cn-g4t3t4eod004-2-vpc.alikafka.aliyuncs.com:9092,alikafka-post-cn-g4t3t4eod004-3-vpc.alikafka.aliyuncs.com:9092",
                "delimiter": "|",
                "format": "delimited",
                "topic": "ziyuan_example",
            }),
            data_source_type="kafka",
            data_source_description="example",
            service_id=default2d_usz_y.service_id)
        default = alicloud.gpdb.StreamingJob("default",
            account="example_001",
            dest_schema="public",
            mode="professional",
            job_name="example-kafka",
            job_description="example-kafka",
            dest_database="adb_sampledata_tpch",
            db_instance_id=defaulth2ghc1.id,
            dest_table="customer",
            data_source_id=defaultc_dq_itu.data_source_id,
            password="example_001",
            job_config=\"\"\"ATABASE: adb_sampledata_tpch
        USER: example_001
        PASSWORD: example_001
        HOST: gp-2zean69451zsjj139-master.gpdb.rds.aliyuncs.com
        PORT: 5432
        KAFKA:
          INPUT:
            SOURCE:
              BROKERS: alikafka-post-cn-3mp3t4ekq004-1-vpc.alikafka.aliyuncs.com:9092
              TOPIC: ziyuan_example
              FALLBACK_OFFSET: LATEST
            KEY:
              COLUMNS:
              - NAME: c_custkey
                TYPE: int
              FORMAT: delimited
              DELIMITED_OPTION:
                DELIMITER: \\'|\\'
            VALUE:
              COLUMNS:
              - NAME: c_comment
                TYPE: varchar
              FORMAT: delimited
              DELIMITED_OPTION:
                DELIMITER: \\'|\\'
            ERROR_LIMIT: 10
          OUTPUT:
            SCHEMA: public
            TABLE: customer
            MODE: MERGE
            MATCH_COLUMNS:
            - c_custkey
            ORDER_COLUMNS:
            - c_custkey
            UPDATE_COLUMNS:
            - c_custkey
            MAPPING:
            - NAME: c_custkey
              EXPRESSION: c_custkey
          COMMIT:
            MAX_ROW: 1000
            MINIMAL_INTERVAL: 1000
            CONSISTENCY: ATLEAST
          POLL:
            BATCHSIZE: 1000
            TIMEOUT: 1000
          PROPERTIES:
            group.id: ziyuan_example_01
        \"\"\")
        ```

        ## Import

        GPDB Streaming Job can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gpdb/streamingJob:StreamingJob example <db_instance_id>:<job_id>
        ```

        :param str resource_name: The name of the resource.
        :param StreamingJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamingJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account: Optional[pulumi.Input[_builtins.str]] = None,
                 consistency: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dest_database: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_table: Optional[pulumi.Input[_builtins.str]] = None,
                 error_limit_count: Optional[pulumi.Input[_builtins.int]] = None,
                 fallback_offset: Optional[pulumi.Input[_builtins.str]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 job_config: Optional[pulumi.Input[_builtins.str]] = None,
                 job_description: Optional[pulumi.Input[_builtins.str]] = None,
                 job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 match_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 src_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 try_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 update_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 write_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamingJobArgs.__new__(StreamingJobArgs)

            __props__.__dict__["account"] = account
            __props__.__dict__["consistency"] = consistency
            if data_source_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_source_id'")
            __props__.__dict__["data_source_id"] = data_source_id
            if db_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_id'")
            __props__.__dict__["db_instance_id"] = db_instance_id
            __props__.__dict__["dest_columns"] = dest_columns
            __props__.__dict__["dest_database"] = dest_database
            __props__.__dict__["dest_schema"] = dest_schema
            __props__.__dict__["dest_table"] = dest_table
            __props__.__dict__["error_limit_count"] = error_limit_count
            __props__.__dict__["fallback_offset"] = fallback_offset
            __props__.__dict__["group_name"] = group_name
            __props__.__dict__["job_config"] = job_config
            __props__.__dict__["job_description"] = job_description
            if job_name is None and not opts.urn:
                raise TypeError("Missing required property 'job_name'")
            __props__.__dict__["job_name"] = job_name
            __props__.__dict__["match_columns"] = match_columns
            __props__.__dict__["mode"] = mode
            __props__.__dict__["password"] = password
            __props__.__dict__["src_columns"] = src_columns
            __props__.__dict__["try_run"] = try_run
            __props__.__dict__["update_columns"] = update_columns
            __props__.__dict__["write_mode"] = write_mode
            __props__.__dict__["create_time"] = None
            __props__.__dict__["job_id"] = None
            __props__.__dict__["status"] = None
        super(StreamingJob, __self__).__init__(
            'alicloud:gpdb/streamingJob:StreamingJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account: Optional[pulumi.Input[_builtins.str]] = None,
            consistency: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            dest_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            dest_database: Optional[pulumi.Input[_builtins.str]] = None,
            dest_schema: Optional[pulumi.Input[_builtins.str]] = None,
            dest_table: Optional[pulumi.Input[_builtins.str]] = None,
            error_limit_count: Optional[pulumi.Input[_builtins.int]] = None,
            fallback_offset: Optional[pulumi.Input[_builtins.str]] = None,
            group_name: Optional[pulumi.Input[_builtins.str]] = None,
            job_config: Optional[pulumi.Input[_builtins.str]] = None,
            job_description: Optional[pulumi.Input[_builtins.str]] = None,
            job_id: Optional[pulumi.Input[_builtins.str]] = None,
            job_name: Optional[pulumi.Input[_builtins.str]] = None,
            match_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            src_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            try_run: Optional[pulumi.Input[_builtins.bool]] = None,
            update_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            write_mode: Optional[pulumi.Input[_builtins.str]] = None) -> 'StreamingJob':
        """
        Get an existing StreamingJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account: The name of the database account.
        :param pulumi.Input[_builtins.str] consistency: The delivery guarantee setting.
               
               Valid values:
               
               - ATLEAST
               - EXACTLY
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] data_source_id: The data source ID.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dest_columns: Target Field
        :param pulumi.Input[_builtins.str] dest_database: The name of the destination database.
        :param pulumi.Input[_builtins.str] dest_schema: Target Schema
        :param pulumi.Input[_builtins.str] dest_table: The name of the destination table.
        :param pulumi.Input[_builtins.int] error_limit_count: The number of allowed error rows. Write failures occur when Kafka data does not match the destination table in AnalyticDB for PostgreSQL. If the specified value is exceeded, the job fails.
        :param pulumi.Input[_builtins.str] fallback_offset: Automatic offset reset
        :param pulumi.Input[_builtins.str] group_name: Group Name
        :param pulumi.Input[_builtins.str] job_config: The YAML configuration file of the job. This parameter must be specified when Mode is set to professional.
        :param pulumi.Input[_builtins.str] job_description: The description of the job.
        :param pulumi.Input[_builtins.str] job_id: The job ID.
        :param pulumi.Input[_builtins.str] job_name: The name of the job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] match_columns: Match Field
        :param pulumi.Input[_builtins.str] mode: The configuration mode. Valid values:
               
               1.  basic: In basic mode, you must configure the configuration parameters.
               
               2.  professional: In professional mode, you can submit a YAML configuration file.
        :param pulumi.Input[_builtins.str] password: The password of the database account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] src_columns: Source Field
        :param pulumi.Input[_builtins.str] status: Service status, value:
        :param pulumi.Input[_builtins.bool] try_run: Specifies whether to test the real-time job. Valid values:
               
               - true
               - false
               
               Default value: false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] update_columns: Update Field
        :param pulumi.Input[_builtins.str] write_mode: The write mode.
               
               Valid values:
               
               - insert
               - update
               - merge
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamingJobState.__new__(_StreamingJobState)

        __props__.__dict__["account"] = account
        __props__.__dict__["consistency"] = consistency
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_source_id"] = data_source_id
        __props__.__dict__["db_instance_id"] = db_instance_id
        __props__.__dict__["dest_columns"] = dest_columns
        __props__.__dict__["dest_database"] = dest_database
        __props__.__dict__["dest_schema"] = dest_schema
        __props__.__dict__["dest_table"] = dest_table
        __props__.__dict__["error_limit_count"] = error_limit_count
        __props__.__dict__["fallback_offset"] = fallback_offset
        __props__.__dict__["group_name"] = group_name
        __props__.__dict__["job_config"] = job_config
        __props__.__dict__["job_description"] = job_description
        __props__.__dict__["job_id"] = job_id
        __props__.__dict__["job_name"] = job_name
        __props__.__dict__["match_columns"] = match_columns
        __props__.__dict__["mode"] = mode
        __props__.__dict__["password"] = password
        __props__.__dict__["src_columns"] = src_columns
        __props__.__dict__["status"] = status
        __props__.__dict__["try_run"] = try_run
        __props__.__dict__["update_columns"] = update_columns
        __props__.__dict__["write_mode"] = write_mode
        return StreamingJob(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def account(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the database account.
        """
        return pulumi.get(self, "account")

    @_builtins.property
    @pulumi.getter
    def consistency(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The delivery guarantee setting.

        Valid values:

        - ATLEAST
        - EXACTLY
        """
        return pulumi.get(self, "consistency")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> pulumi.Output[_builtins.str]:
        """
        The data source ID.
        """
        return pulumi.get(self, "data_source_id")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter(name="destColumns")
    def dest_columns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Target Field
        """
        return pulumi.get(self, "dest_columns")

    @_builtins.property
    @pulumi.getter(name="destDatabase")
    def dest_database(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the destination database.
        """
        return pulumi.get(self, "dest_database")

    @_builtins.property
    @pulumi.getter(name="destSchema")
    def dest_schema(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Target Schema
        """
        return pulumi.get(self, "dest_schema")

    @_builtins.property
    @pulumi.getter(name="destTable")
    def dest_table(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the destination table.
        """
        return pulumi.get(self, "dest_table")

    @_builtins.property
    @pulumi.getter(name="errorLimitCount")
    def error_limit_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of allowed error rows. Write failures occur when Kafka data does not match the destination table in AnalyticDB for PostgreSQL. If the specified value is exceeded, the job fails.
        """
        return pulumi.get(self, "error_limit_count")

    @_builtins.property
    @pulumi.getter(name="fallbackOffset")
    def fallback_offset(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Automatic offset reset
        """
        return pulumi.get(self, "fallback_offset")

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Group Name
        """
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter(name="jobConfig")
    def job_config(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The YAML configuration file of the job. This parameter must be specified when Mode is set to professional.
        """
        return pulumi.get(self, "job_config")

    @_builtins.property
    @pulumi.getter(name="jobDescription")
    def job_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the job.
        """
        return pulumi.get(self, "job_description")

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Output[_builtins.str]:
        """
        The job ID.
        """
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="jobName")
    def job_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the job.
        """
        return pulumi.get(self, "job_name")

    @_builtins.property
    @pulumi.getter(name="matchColumns")
    def match_columns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Match Field
        """
        return pulumi.get(self, "match_columns")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The configuration mode. Valid values:

        1.  basic: In basic mode, you must configure the configuration parameters.

        2.  professional: In professional mode, you can submit a YAML configuration file.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password of the database account.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="srcColumns")
    def src_columns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Source Field
        """
        return pulumi.get(self, "src_columns")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Service status, value:
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tryRun")
    def try_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to test the real-time job. Valid values:

        - true
        - false

        Default value: false.
        """
        return pulumi.get(self, "try_run")

    @_builtins.property
    @pulumi.getter(name="updateColumns")
    def update_columns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Update Field
        """
        return pulumi.get(self, "update_columns")

    @_builtins.property
    @pulumi.getter(name="writeMode")
    def write_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The write mode.

        Valid values:

        - insert
        - update
        - merge
        """
        return pulumi.get(self, "write_mode")

