# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetUdmSnapshotsResult',
    'AwaitableGetUdmSnapshotsResult',
    'get_udm_snapshots',
    'get_udm_snapshots_output',
]

@pulumi.output_type
class GetUdmSnapshotsResult:
    """
    A collection of values returned by getUdmSnapshots.
    """
    def __init__(__self__, disk_id=None, end_time=None, id=None, ids=None, instance_id=None, job_id=None, output_file=None, snapshots=None, source_type=None, start_time=None):
        if disk_id and not isinstance(disk_id, str):
            raise TypeError("Expected argument 'disk_id' to be a str")
        pulumi.set(__self__, "disk_id", disk_id)
        if end_time and not isinstance(end_time, int):
            raise TypeError("Expected argument 'end_time' to be a int")
        pulumi.set(__self__, "end_time", end_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if job_id and not isinstance(job_id, str):
            raise TypeError("Expected argument 'job_id' to be a str")
        pulumi.set(__self__, "job_id", job_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if snapshots and not isinstance(snapshots, list):
            raise TypeError("Expected argument 'snapshots' to be a list")
        pulumi.set(__self__, "snapshots", snapshots)
        if source_type and not isinstance(source_type, str):
            raise TypeError("Expected argument 'source_type' to be a str")
        pulumi.set(__self__, "source_type", source_type)
        if start_time and not isinstance(start_time, int):
            raise TypeError("Expected argument 'start_time' to be a int")
        pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> Optional[_builtins.str]:
        """
        Cloud disk ID. This field is valid only when SourceType = UDM_ECS_DISK.
        """
        return pulumi.get(self, "disk_id")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.int:
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Udm Snapshot IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ECS instance ID
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[_builtins.str]:
        """
        The ID of the backup job that creates the snapshot.
        """
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def snapshots(self) -> Sequence['outputs.GetUdmSnapshotsSnapshotResult']:
        """
        A list of Udm Snapshot Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "snapshots")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        Data source type. Only UDM_ECS and UDM_ECS_DISK are supported.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.int:
        """
        Start Time
        """
        return pulumi.get(self, "start_time")


class AwaitableGetUdmSnapshotsResult(GetUdmSnapshotsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUdmSnapshotsResult(
            disk_id=self.disk_id,
            end_time=self.end_time,
            id=self.id,
            ids=self.ids,
            instance_id=self.instance_id,
            job_id=self.job_id,
            output_file=self.output_file,
            snapshots=self.snapshots,
            source_type=self.source_type,
            start_time=self.start_time)


def get_udm_snapshots(disk_id: Optional[_builtins.str] = None,
                      end_time: Optional[_builtins.int] = None,
                      ids: Optional[Sequence[_builtins.str]] = None,
                      instance_id: Optional[_builtins.str] = None,
                      job_id: Optional[_builtins.str] = None,
                      output_file: Optional[_builtins.str] = None,
                      source_type: Optional[_builtins.str] = None,
                      start_time: Optional[_builtins.int] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUdmSnapshotsResult:
    """
    This data source provides Hbr Udm Snapshot available to the user.[What is Udm Snapshot](https://next.api.alibabacloud.com/document/hbr/2017-09-08/DescribeUdmSnapshots)

    > **NOTE:** Available since v1.253.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.hbr.get_udm_snapshots(source_type="UDM_ECS",
        start_time=1642057551,
        end_time=1750927687,
        instance_id="i-08qv5q4c4j****")
    pulumi.export("alicloudHbrUdmSnapshotExampleId", default.snapshots[0].id)
    ```


    :param _builtins.str disk_id: Cloud disk ID. This field is valid only when SourceType = UDM_ECS_DISK.
    :param _builtins.int end_time: End Time
    :param Sequence[_builtins.str] ids: A list of Udm Snapshot IDs.
    :param _builtins.str instance_id: ECS instance ID
    :param _builtins.str job_id: The ID of the backup job that creates the snapshot.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str source_type: Data source type. Only UDM_ECS and UDM_ECS_DISK are supported.
    :param _builtins.int start_time: Start Time
    """
    __args__ = dict()
    __args__['diskId'] = disk_id
    __args__['endTime'] = end_time
    __args__['ids'] = ids
    __args__['instanceId'] = instance_id
    __args__['jobId'] = job_id
    __args__['outputFile'] = output_file
    __args__['sourceType'] = source_type
    __args__['startTime'] = start_time
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:hbr/getUdmSnapshots:getUdmSnapshots', __args__, opts=opts, typ=GetUdmSnapshotsResult).value

    return AwaitableGetUdmSnapshotsResult(
        disk_id=pulumi.get(__ret__, 'disk_id'),
        end_time=pulumi.get(__ret__, 'end_time'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        job_id=pulumi.get(__ret__, 'job_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        snapshots=pulumi.get(__ret__, 'snapshots'),
        source_type=pulumi.get(__ret__, 'source_type'),
        start_time=pulumi.get(__ret__, 'start_time'))
def get_udm_snapshots_output(disk_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             end_time: Optional[pulumi.Input[_builtins.int]] = None,
                             ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                             instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                             job_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             source_type: Optional[pulumi.Input[_builtins.str]] = None,
                             start_time: Optional[pulumi.Input[_builtins.int]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUdmSnapshotsResult]:
    """
    This data source provides Hbr Udm Snapshot available to the user.[What is Udm Snapshot](https://next.api.alibabacloud.com/document/hbr/2017-09-08/DescribeUdmSnapshots)

    > **NOTE:** Available since v1.253.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.hbr.get_udm_snapshots(source_type="UDM_ECS",
        start_time=1642057551,
        end_time=1750927687,
        instance_id="i-08qv5q4c4j****")
    pulumi.export("alicloudHbrUdmSnapshotExampleId", default.snapshots[0].id)
    ```


    :param _builtins.str disk_id: Cloud disk ID. This field is valid only when SourceType = UDM_ECS_DISK.
    :param _builtins.int end_time: End Time
    :param Sequence[_builtins.str] ids: A list of Udm Snapshot IDs.
    :param _builtins.str instance_id: ECS instance ID
    :param _builtins.str job_id: The ID of the backup job that creates the snapshot.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str source_type: Data source type. Only UDM_ECS and UDM_ECS_DISK are supported.
    :param _builtins.int start_time: Start Time
    """
    __args__ = dict()
    __args__['diskId'] = disk_id
    __args__['endTime'] = end_time
    __args__['ids'] = ids
    __args__['instanceId'] = instance_id
    __args__['jobId'] = job_id
    __args__['outputFile'] = output_file
    __args__['sourceType'] = source_type
    __args__['startTime'] = start_time
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:hbr/getUdmSnapshots:getUdmSnapshots', __args__, opts=opts, typ=GetUdmSnapshotsResult)
    return __ret__.apply(lambda __response__: GetUdmSnapshotsResult(
        disk_id=pulumi.get(__response__, 'disk_id'),
        end_time=pulumi.get(__response__, 'end_time'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        job_id=pulumi.get(__response__, 'job_id'),
        output_file=pulumi.get(__response__, 'output_file'),
        snapshots=pulumi.get(__response__, 'snapshots'),
        source_type=pulumi.get(__response__, 'source_type'),
        start_time=pulumi.get(__response__, 'start_time')))
