# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OtsBackupPlanArgs', 'OtsBackupPlan']

@pulumi.input_type
class OtsBackupPlanArgs:
    def __init__(__self__, *,
                 backup_type: pulumi.Input[_builtins.str],
                 ots_backup_plan_name: pulumi.Input[_builtins.str],
                 retention: pulumi.Input[_builtins.str],
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ots_details: Optional[pulumi.Input[Sequence[pulumi.Input['OtsBackupPlanOtsDetailArgs']]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['OtsBackupPlanRuleArgs']]]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OtsBackupPlan resource.
        :param pulumi.Input[_builtins.str] backup_type: Backup type. Valid values: `COMPLETE`.
        :param pulumi.Input[_builtins.str] ots_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param pulumi.Input[_builtins.str] retention: Backup retention days, the minimum is 1.
        :param pulumi.Input[_builtins.str] cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account.
        :param pulumi.Input[_builtins.str] cross_account_type: The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        :param pulumi.Input[_builtins.int] cross_account_user_id: The original account ID of the cross account backup managed by the current account.
        :param pulumi.Input[_builtins.bool] disabled: Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
        :param pulumi.Input[_builtins.str] instance_name: The name of the Table store instance. **Note:** Required while source_type equals `OTS_TABLE`.
        :param pulumi.Input[Sequence[pulumi.Input['OtsBackupPlanOtsDetailArgs']]] ots_details: The details about the Table store instance. See the following `Block ots_detail`. **Note:** Required while source_type equals `OTS_TABLE`.
        :param pulumi.Input[Sequence[pulumi.Input['OtsBackupPlanRuleArgs']]] rules: The backup plan rule. See the following `Block rules`. **Note:** Required while source_type equals `OTS_TABLE`.
        :param pulumi.Input[_builtins.str] schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
               - `startTime` Backup start time, UNIX time seconds.
        :param pulumi.Input[_builtins.str] vault_id: The ID of backup vault.
        """
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "ots_backup_plan_name", ots_backup_plan_name)
        pulumi.set(__self__, "retention", retention)
        if cross_account_role_name is not None:
            pulumi.set(__self__, "cross_account_role_name", cross_account_role_name)
        if cross_account_type is not None:
            pulumi.set(__self__, "cross_account_type", cross_account_type)
        if cross_account_user_id is not None:
            pulumi.set(__self__, "cross_account_user_id", cross_account_user_id)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if ots_details is not None:
            pulumi.set(__self__, "ots_details", ots_details)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if schedule is not None:
            warnings.warn("""Field 'schedule' has been deprecated from version 1.163.0. Use 'rules' instead.""", DeprecationWarning)
            pulumi.log.warn("""schedule is deprecated: Field 'schedule' has been deprecated from version 1.163.0. Use 'rules' instead.""")
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> pulumi.Input[_builtins.str]:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backup_type", value)

    @_builtins.property
    @pulumi.getter(name="otsBackupPlanName")
    def ots_backup_plan_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        """
        return pulumi.get(self, "ots_backup_plan_name")

    @ots_backup_plan_name.setter
    def ots_backup_plan_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ots_backup_plan_name", value)

    @_builtins.property
    @pulumi.getter
    def retention(self) -> pulumi.Input[_builtins.str]:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "retention", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role name created in the original account RAM backup by the cross account managed by the current account.
        """
        return pulumi.get(self, "cross_account_role_name")

    @cross_account_role_name.setter
    def cross_account_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_role_name", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountType")
    def cross_account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        """
        return pulumi.get(self, "cross_account_type")

    @cross_account_type.setter
    def cross_account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_type", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The original account ID of the cross account backup managed by the current account.
        """
        return pulumi.get(self, "cross_account_user_id")

    @cross_account_user_id.setter
    def cross_account_user_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cross_account_user_id", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Table store instance. **Note:** Required while source_type equals `OTS_TABLE`.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="otsDetails")
    def ots_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OtsBackupPlanOtsDetailArgs']]]]:
        """
        The details about the Table store instance. See the following `Block ots_detail`. **Note:** Required while source_type equals `OTS_TABLE`.
        """
        return pulumi.get(self, "ots_details")

    @ots_details.setter
    def ots_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OtsBackupPlanOtsDetailArgs']]]]):
        pulumi.set(self, "ots_details", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OtsBackupPlanRuleArgs']]]]:
        """
        The backup plan rule. See the following `Block rules`. **Note:** Required while source_type equals `OTS_TABLE`.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OtsBackupPlanRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'schedule' has been deprecated from version 1.163.0. Use 'rules' instead.""")
    def schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        - `startTime` Backup start time, UNIX time seconds.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of backup vault.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_id", value)


@pulumi.input_type
class _OtsBackupPlanState:
    def __init__(__self__, *,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ots_backup_plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ots_details: Optional[pulumi.Input[Sequence[pulumi.Input['OtsBackupPlanOtsDetailArgs']]]] = None,
                 retention: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['OtsBackupPlanRuleArgs']]]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OtsBackupPlan resources.
        :param pulumi.Input[_builtins.str] backup_type: Backup type. Valid values: `COMPLETE`.
        :param pulumi.Input[_builtins.str] cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account.
        :param pulumi.Input[_builtins.str] cross_account_type: The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        :param pulumi.Input[_builtins.int] cross_account_user_id: The original account ID of the cross account backup managed by the current account.
        :param pulumi.Input[_builtins.bool] disabled: Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
        :param pulumi.Input[_builtins.str] instance_name: The name of the Table store instance. **Note:** Required while source_type equals `OTS_TABLE`.
        :param pulumi.Input[_builtins.str] ots_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param pulumi.Input[Sequence[pulumi.Input['OtsBackupPlanOtsDetailArgs']]] ots_details: The details about the Table store instance. See the following `Block ots_detail`. **Note:** Required while source_type equals `OTS_TABLE`.
        :param pulumi.Input[_builtins.str] retention: Backup retention days, the minimum is 1.
        :param pulumi.Input[Sequence[pulumi.Input['OtsBackupPlanRuleArgs']]] rules: The backup plan rule. See the following `Block rules`. **Note:** Required while source_type equals `OTS_TABLE`.
        :param pulumi.Input[_builtins.str] schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
               - `startTime` Backup start time, UNIX time seconds.
        :param pulumi.Input[_builtins.str] vault_id: The ID of backup vault.
        """
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if cross_account_role_name is not None:
            pulumi.set(__self__, "cross_account_role_name", cross_account_role_name)
        if cross_account_type is not None:
            pulumi.set(__self__, "cross_account_type", cross_account_type)
        if cross_account_user_id is not None:
            pulumi.set(__self__, "cross_account_user_id", cross_account_user_id)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if ots_backup_plan_name is not None:
            pulumi.set(__self__, "ots_backup_plan_name", ots_backup_plan_name)
        if ots_details is not None:
            pulumi.set(__self__, "ots_details", ots_details)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if schedule is not None:
            warnings.warn("""Field 'schedule' has been deprecated from version 1.163.0. Use 'rules' instead.""", DeprecationWarning)
            pulumi.log.warn("""schedule is deprecated: Field 'schedule' has been deprecated from version 1.163.0. Use 'rules' instead.""")
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_type", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role name created in the original account RAM backup by the cross account managed by the current account.
        """
        return pulumi.get(self, "cross_account_role_name")

    @cross_account_role_name.setter
    def cross_account_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_role_name", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountType")
    def cross_account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        """
        return pulumi.get(self, "cross_account_type")

    @cross_account_type.setter
    def cross_account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_type", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The original account ID of the cross account backup managed by the current account.
        """
        return pulumi.get(self, "cross_account_user_id")

    @cross_account_user_id.setter
    def cross_account_user_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cross_account_user_id", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Table store instance. **Note:** Required while source_type equals `OTS_TABLE`.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="otsBackupPlanName")
    def ots_backup_plan_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        """
        return pulumi.get(self, "ots_backup_plan_name")

    @ots_backup_plan_name.setter
    def ots_backup_plan_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ots_backup_plan_name", value)

    @_builtins.property
    @pulumi.getter(name="otsDetails")
    def ots_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OtsBackupPlanOtsDetailArgs']]]]:
        """
        The details about the Table store instance. See the following `Block ots_detail`. **Note:** Required while source_type equals `OTS_TABLE`.
        """
        return pulumi.get(self, "ots_details")

    @ots_details.setter
    def ots_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OtsBackupPlanOtsDetailArgs']]]]):
        pulumi.set(self, "ots_details", value)

    @_builtins.property
    @pulumi.getter
    def retention(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OtsBackupPlanRuleArgs']]]]:
        """
        The backup plan rule. See the following `Block rules`. **Note:** Required while source_type equals `OTS_TABLE`.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OtsBackupPlanRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'schedule' has been deprecated from version 1.163.0. Use 'rules' instead.""")
    def schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        - `startTime` Backup start time, UNIX time seconds.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of backup vault.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_id", value)


@pulumi.type_token("alicloud:hbr/otsBackupPlan:OtsBackupPlan")
class OtsBackupPlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ots_backup_plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ots_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OtsBackupPlanOtsDetailArgs', 'OtsBackupPlanOtsDetailArgsDict']]]]] = None,
                 retention: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OtsBackupPlanRuleArgs', 'OtsBackupPlanRuleArgsDict']]]]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a HBR Ots Backup Plan resource.

        For information about HBR Ots Backup Plan and how to use it, see [What is Ots Backup Plan](https://www.alibabacloud.com/help/en/hybrid-backup-recovery/latest/overview).

        > **NOTE:** Available since v1.163.0.

        > **NOTE:** Deprecated since v1.249.0.

        > **DEPRECATED:** This resource has been deprecated from version `1.249.0`. Please use new resource hbr.Policy and alicloud_hbr_policy_binding.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        default_vault = alicloud.hbr.Vault("default",
            vault_name=f"terraform-example-{default_integer['result']}",
            vault_type="STANDARD")
        default_instance = alicloud.ots.Instance("default",
            name=f"Example-{default_integer['result']}",
            description="terraform-example",
            accessed_by="Any",
            tags={
                "Created": "TF",
                "For": "example",
            })
        default_table = alicloud.ots.Table("default",
            instance_name=default_instance.name,
            table_name="terraform_example",
            primary_keys=[{
                "name": "pk1",
                "type": "Integer",
            }],
            time_to_live=-1,
            max_version=1,
            deviation_cell_version_in_sec="1")
        default_role = alicloud.ram.Role("default",
            name="hbrexamplerole",
            document=\"\"\"\\x09\\x09{
        \\x09\\x09\\x09"Statement": [
        \\x09\\x09\\x09{
        \\x09\\x09\\x09\\x09"Action": "sts:AssumeRole",
        \\x09\\x09\\x09\\x09"Effect": "Allow",
        \\x09\\x09\\x09\\x09"Principal": {
        \\x09\\x09\\x09\\x09\\x09"Service": [
        \\x09\\x09\\x09\\x09\\x09\\x09"crossbackup.hbr.aliyuncs.com"
        \\x09\\x09\\x09\\x09\\x09]
        \\x09\\x09\\x09\\x09}
        \\x09\\x09\\x09}
        \\x09\\x09\\x09],
          \\x09\\x09\\x09"Version": "1"
        \\x09\\x09}
        \"\"\",
            force=True)
        default = alicloud.get_account()
        example = alicloud.hbr.OtsBackupPlan("example",
            ots_backup_plan_name=f"terraform-example-{default_integer['result']}",
            vault_id=default_vault.id,
            backup_type="COMPLETE",
            retention="1",
            instance_name=default_instance.name,
            cross_account_type="SELF_ACCOUNT",
            cross_account_user_id=default.id,
            cross_account_role_name=default_role.id,
            ots_details=[{
                "table_names": [default_table.table_name],
            }],
            rules=[{
                "schedule": "I|1602673264|PT2H",
                "retention": "1",
                "disabled": False,
                "rule_name": "terraform-example",
                "backup_type": "COMPLETE",
            }])
        ```

        ## Import

        HBR Ots Backup Plan can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:hbr/otsBackupPlan:OtsBackupPlan example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_type: Backup type. Valid values: `COMPLETE`.
        :param pulumi.Input[_builtins.str] cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account.
        :param pulumi.Input[_builtins.str] cross_account_type: The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        :param pulumi.Input[_builtins.int] cross_account_user_id: The original account ID of the cross account backup managed by the current account.
        :param pulumi.Input[_builtins.bool] disabled: Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
        :param pulumi.Input[_builtins.str] instance_name: The name of the Table store instance. **Note:** Required while source_type equals `OTS_TABLE`.
        :param pulumi.Input[_builtins.str] ots_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OtsBackupPlanOtsDetailArgs', 'OtsBackupPlanOtsDetailArgsDict']]]] ots_details: The details about the Table store instance. See the following `Block ots_detail`. **Note:** Required while source_type equals `OTS_TABLE`.
        :param pulumi.Input[_builtins.str] retention: Backup retention days, the minimum is 1.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OtsBackupPlanRuleArgs', 'OtsBackupPlanRuleArgsDict']]]] rules: The backup plan rule. See the following `Block rules`. **Note:** Required while source_type equals `OTS_TABLE`.
        :param pulumi.Input[_builtins.str] schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
               - `startTime` Backup start time, UNIX time seconds.
        :param pulumi.Input[_builtins.str] vault_id: The ID of backup vault.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OtsBackupPlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a HBR Ots Backup Plan resource.

        For information about HBR Ots Backup Plan and how to use it, see [What is Ots Backup Plan](https://www.alibabacloud.com/help/en/hybrid-backup-recovery/latest/overview).

        > **NOTE:** Available since v1.163.0.

        > **NOTE:** Deprecated since v1.249.0.

        > **DEPRECATED:** This resource has been deprecated from version `1.249.0`. Please use new resource hbr.Policy and alicloud_hbr_policy_binding.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        default_vault = alicloud.hbr.Vault("default",
            vault_name=f"terraform-example-{default_integer['result']}",
            vault_type="STANDARD")
        default_instance = alicloud.ots.Instance("default",
            name=f"Example-{default_integer['result']}",
            description="terraform-example",
            accessed_by="Any",
            tags={
                "Created": "TF",
                "For": "example",
            })
        default_table = alicloud.ots.Table("default",
            instance_name=default_instance.name,
            table_name="terraform_example",
            primary_keys=[{
                "name": "pk1",
                "type": "Integer",
            }],
            time_to_live=-1,
            max_version=1,
            deviation_cell_version_in_sec="1")
        default_role = alicloud.ram.Role("default",
            name="hbrexamplerole",
            document=\"\"\"\\x09\\x09{
        \\x09\\x09\\x09"Statement": [
        \\x09\\x09\\x09{
        \\x09\\x09\\x09\\x09"Action": "sts:AssumeRole",
        \\x09\\x09\\x09\\x09"Effect": "Allow",
        \\x09\\x09\\x09\\x09"Principal": {
        \\x09\\x09\\x09\\x09\\x09"Service": [
        \\x09\\x09\\x09\\x09\\x09\\x09"crossbackup.hbr.aliyuncs.com"
        \\x09\\x09\\x09\\x09\\x09]
        \\x09\\x09\\x09\\x09}
        \\x09\\x09\\x09}
        \\x09\\x09\\x09],
          \\x09\\x09\\x09"Version": "1"
        \\x09\\x09}
        \"\"\",
            force=True)
        default = alicloud.get_account()
        example = alicloud.hbr.OtsBackupPlan("example",
            ots_backup_plan_name=f"terraform-example-{default_integer['result']}",
            vault_id=default_vault.id,
            backup_type="COMPLETE",
            retention="1",
            instance_name=default_instance.name,
            cross_account_type="SELF_ACCOUNT",
            cross_account_user_id=default.id,
            cross_account_role_name=default_role.id,
            ots_details=[{
                "table_names": [default_table.table_name],
            }],
            rules=[{
                "schedule": "I|1602673264|PT2H",
                "retention": "1",
                "disabled": False,
                "rule_name": "terraform-example",
                "backup_type": "COMPLETE",
            }])
        ```

        ## Import

        HBR Ots Backup Plan can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:hbr/otsBackupPlan:OtsBackupPlan example <id>
        ```

        :param str resource_name: The name of the resource.
        :param OtsBackupPlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OtsBackupPlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ots_backup_plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ots_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OtsBackupPlanOtsDetailArgs', 'OtsBackupPlanOtsDetailArgsDict']]]]] = None,
                 retention: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OtsBackupPlanRuleArgs', 'OtsBackupPlanRuleArgsDict']]]]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OtsBackupPlanArgs.__new__(OtsBackupPlanArgs)

            if backup_type is None and not opts.urn:
                raise TypeError("Missing required property 'backup_type'")
            __props__.__dict__["backup_type"] = backup_type
            __props__.__dict__["cross_account_role_name"] = cross_account_role_name
            __props__.__dict__["cross_account_type"] = cross_account_type
            __props__.__dict__["cross_account_user_id"] = cross_account_user_id
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["instance_name"] = instance_name
            if ots_backup_plan_name is None and not opts.urn:
                raise TypeError("Missing required property 'ots_backup_plan_name'")
            __props__.__dict__["ots_backup_plan_name"] = ots_backup_plan_name
            __props__.__dict__["ots_details"] = ots_details
            if retention is None and not opts.urn:
                raise TypeError("Missing required property 'retention'")
            __props__.__dict__["retention"] = retention
            __props__.__dict__["rules"] = rules
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["vault_id"] = vault_id
        super(OtsBackupPlan, __self__).__init__(
            'alicloud:hbr/otsBackupPlan:OtsBackupPlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_type: Optional[pulumi.Input[_builtins.str]] = None,
            cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
            cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            ots_backup_plan_name: Optional[pulumi.Input[_builtins.str]] = None,
            ots_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OtsBackupPlanOtsDetailArgs', 'OtsBackupPlanOtsDetailArgsDict']]]]] = None,
            retention: Optional[pulumi.Input[_builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OtsBackupPlanRuleArgs', 'OtsBackupPlanRuleArgsDict']]]]] = None,
            schedule: Optional[pulumi.Input[_builtins.str]] = None,
            vault_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'OtsBackupPlan':
        """
        Get an existing OtsBackupPlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_type: Backup type. Valid values: `COMPLETE`.
        :param pulumi.Input[_builtins.str] cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account.
        :param pulumi.Input[_builtins.str] cross_account_type: The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        :param pulumi.Input[_builtins.int] cross_account_user_id: The original account ID of the cross account backup managed by the current account.
        :param pulumi.Input[_builtins.bool] disabled: Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
        :param pulumi.Input[_builtins.str] instance_name: The name of the Table store instance. **Note:** Required while source_type equals `OTS_TABLE`.
        :param pulumi.Input[_builtins.str] ots_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OtsBackupPlanOtsDetailArgs', 'OtsBackupPlanOtsDetailArgsDict']]]] ots_details: The details about the Table store instance. See the following `Block ots_detail`. **Note:** Required while source_type equals `OTS_TABLE`.
        :param pulumi.Input[_builtins.str] retention: Backup retention days, the minimum is 1.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OtsBackupPlanRuleArgs', 'OtsBackupPlanRuleArgsDict']]]] rules: The backup plan rule. See the following `Block rules`. **Note:** Required while source_type equals `OTS_TABLE`.
        :param pulumi.Input[_builtins.str] schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
               - `startTime` Backup start time, UNIX time seconds.
        :param pulumi.Input[_builtins.str] vault_id: The ID of backup vault.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OtsBackupPlanState.__new__(_OtsBackupPlanState)

        __props__.__dict__["backup_type"] = backup_type
        __props__.__dict__["cross_account_role_name"] = cross_account_role_name
        __props__.__dict__["cross_account_type"] = cross_account_type
        __props__.__dict__["cross_account_user_id"] = cross_account_user_id
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["ots_backup_plan_name"] = ots_backup_plan_name
        __props__.__dict__["ots_details"] = ots_details
        __props__.__dict__["retention"] = retention
        __props__.__dict__["rules"] = rules
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["vault_id"] = vault_id
        return OtsBackupPlan(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> pulumi.Output[_builtins.str]:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The role name created in the original account RAM backup by the cross account managed by the current account.
        """
        return pulumi.get(self, "cross_account_role_name")

    @_builtins.property
    @pulumi.getter(name="crossAccountType")
    def cross_account_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        """
        return pulumi.get(self, "cross_account_type")

    @_builtins.property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The original account ID of the cross account backup managed by the current account.
        """
        return pulumi.get(self, "cross_account_user_id")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the Table store instance. **Note:** Required while source_type equals `OTS_TABLE`.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="otsBackupPlanName")
    def ots_backup_plan_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        """
        return pulumi.get(self, "ots_backup_plan_name")

    @_builtins.property
    @pulumi.getter(name="otsDetails")
    def ots_details(self) -> pulumi.Output[Optional[Sequence['outputs.OtsBackupPlanOtsDetail']]]:
        """
        The details about the Table store instance. See the following `Block ots_detail`. **Note:** Required while source_type equals `OTS_TABLE`.
        """
        return pulumi.get(self, "ots_details")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> pulumi.Output[_builtins.str]:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.OtsBackupPlanRule']]]:
        """
        The backup plan rule. See the following `Block rules`. **Note:** Required while source_type equals `OTS_TABLE`.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'schedule' has been deprecated from version 1.163.0. Use 'rules' instead.""")
    def schedule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        - `startTime` Backup start time, UNIX time seconds.
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of backup vault.
        """
        return pulumi.get(self, "vault_id")

