# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetKeysResult',
    'AwaitableGetKeysResult',
    'get_keys',
    'get_keys_output',
]

@pulumi.output_type
class GetKeysResult:
    """
    A collection of values returned by getKeys.
    """
    def __init__(__self__, description_regex=None, enable_details=None, filters=None, id=None, ids=None, keys=None, output_file=None, status=None):
        if description_regex and not isinstance(description_regex, str):
            raise TypeError("Expected argument 'description_regex' to be a str")
        pulumi.set(__self__, "description_regex", description_regex)
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if filters and not isinstance(filters, str):
            raise TypeError("Expected argument 'filters' to be a str")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if keys and not isinstance(keys, list):
            raise TypeError("Expected argument 'keys' to be a list")
        pulumi.set(__self__, "keys", keys)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="descriptionRegex")
    def description_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description_regex")

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of KMS key IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def keys(self) -> Sequence['outputs.GetKeysKeyResult']:
        """
        A list of KMS keys. Each element contains the following attributes:
        """
        return pulumi.get(self, "keys")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status of the key. Possible values: `Enabled`, `Disabled` and `PendingDeletion`.
        """
        return pulumi.get(self, "status")


class AwaitableGetKeysResult(GetKeysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeysResult(
            description_regex=self.description_regex,
            enable_details=self.enable_details,
            filters=self.filters,
            id=self.id,
            ids=self.ids,
            keys=self.keys,
            output_file=self.output_file,
            status=self.status)


def get_keys(description_regex: Optional[_builtins.str] = None,
             enable_details: Optional[_builtins.bool] = None,
             filters: Optional[_builtins.str] = None,
             ids: Optional[Sequence[_builtins.str]] = None,
             output_file: Optional[_builtins.str] = None,
             status: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeysResult:
    """
    This data source provides a list of KMS keys in an Alibaba Cloud account according to the specified filters.

    For information about KMS Key and how to use it, see [What is Key](https://www.alibabacloud.com/help/en/kms/developer-reference/api-createkey).

    > **NOTE:** Available since v1.85.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Declare the data source
    kms_keys_ds = alicloud.kms.get_keys(description_regex="Hello KMS",
        output_file="kms_keys.json")
    pulumi.export("firstKeyId", kms_keys_ds.keys[0].id)
    ```


    :param _builtins.str description_regex: A regex string to filter the results by the KMS key description.
    :param _builtins.bool enable_details: Default to `true`. Set it to `true` can output more details about resource attributes.
    :param _builtins.str filters: The CMK filter. The filter consists of one or more key-value pairs. 
           You can specify a maximum of 10 key-value pairs. More details see API [ListKeys](https://www.alibabacloud.com/help/en/key-management-service/latest/listkeys).
    :param Sequence[_builtins.str] ids: A list of KMS key IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: Filter the results by status of the KMS keys. Valid values: `Enabled`, `Disabled`, `PendingDeletion`.
    """
    __args__ = dict()
    __args__['descriptionRegex'] = description_regex
    __args__['enableDetails'] = enable_details
    __args__['filters'] = filters
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:kms/getKeys:getKeys', __args__, opts=opts, typ=GetKeysResult).value

    return AwaitableGetKeysResult(
        description_regex=pulumi.get(__ret__, 'description_regex'),
        enable_details=pulumi.get(__ret__, 'enable_details'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        keys=pulumi.get(__ret__, 'keys'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'))
def get_keys_output(description_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                    filters: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                    output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKeysResult]:
    """
    This data source provides a list of KMS keys in an Alibaba Cloud account according to the specified filters.

    For information about KMS Key and how to use it, see [What is Key](https://www.alibabacloud.com/help/en/kms/developer-reference/api-createkey).

    > **NOTE:** Available since v1.85.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Declare the data source
    kms_keys_ds = alicloud.kms.get_keys(description_regex="Hello KMS",
        output_file="kms_keys.json")
    pulumi.export("firstKeyId", kms_keys_ds.keys[0].id)
    ```


    :param _builtins.str description_regex: A regex string to filter the results by the KMS key description.
    :param _builtins.bool enable_details: Default to `true`. Set it to `true` can output more details about resource attributes.
    :param _builtins.str filters: The CMK filter. The filter consists of one or more key-value pairs. 
           You can specify a maximum of 10 key-value pairs. More details see API [ListKeys](https://www.alibabacloud.com/help/en/key-management-service/latest/listkeys).
    :param Sequence[_builtins.str] ids: A list of KMS key IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: Filter the results by status of the KMS keys. Valid values: `Enabled`, `Disabled`, `PendingDeletion`.
    """
    __args__ = dict()
    __args__['descriptionRegex'] = description_regex
    __args__['enableDetails'] = enable_details
    __args__['filters'] = filters
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:kms/getKeys:getKeys', __args__, opts=opts, typ=GetKeysResult)
    return __ret__.apply(lambda __response__: GetKeysResult(
        description_regex=pulumi.get(__response__, 'description_regex'),
        enable_details=pulumi.get(__response__, 'enable_details'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        keys=pulumi.get(__response__, 'keys'),
        output_file=pulumi.get(__response__, 'output_file'),
        status=pulumi.get(__response__, 'status')))
