# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AlertAnnotationArgs',
    'AlertAnnotationArgsDict',
    'AlertGroupConfigurationArgs',
    'AlertGroupConfigurationArgsDict',
    'AlertJoinConfigurationArgs',
    'AlertJoinConfigurationArgsDict',
    'AlertLabelArgs',
    'AlertLabelArgsDict',
    'AlertNotificationListArgs',
    'AlertNotificationListArgsDict',
    'AlertPolicyConfigurationArgs',
    'AlertPolicyConfigurationArgsDict',
    'AlertQueryListArgs',
    'AlertQueryListArgsDict',
    'AlertScheduleArgs',
    'AlertScheduleArgsDict',
    'AlertSeverityConfigurationArgs',
    'AlertSeverityConfigurationArgsDict',
    'AlertTemplateConfigurationArgs',
    'AlertTemplateConfigurationArgsDict',
    'EtlEtlSinkArgs',
    'EtlEtlSinkArgsDict',
    'OssExportConfigColumnArgs',
    'OssExportConfigColumnArgsDict',
    'OssShipperParquetConfigArgs',
    'OssShipperParquetConfigArgsDict',
    'StoreEncryptConfArgs',
    'StoreEncryptConfArgsDict',
    'StoreEncryptConfUserCmkInfoArgs',
    'StoreEncryptConfUserCmkInfoArgsDict',
    'StoreIndexFieldSearchArgs',
    'StoreIndexFieldSearchArgsDict',
    'StoreIndexFieldSearchJsonKeyArgs',
    'StoreIndexFieldSearchJsonKeyArgsDict',
    'StoreIndexFullTextArgs',
    'StoreIndexFullTextArgsDict',
    'StoreShardArgs',
    'StoreShardArgsDict',
]

MYPY = False

if not MYPY:
    class AlertAnnotationArgsDict(TypedDict):
        key: pulumi.Input[_builtins.str]
        """
        Annotations's key for new alert.
        """
        value: pulumi.Input[_builtins.str]
        """
        Annotations's value for new alert.
        """
elif False:
    AlertAnnotationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlertAnnotationArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] key: Annotations's key for new alert.
        :param pulumi.Input[_builtins.str] value: Annotations's value for new alert.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        Annotations's key for new alert.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        Annotations's value for new alert.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class AlertGroupConfigurationArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Group configuration type, including no_group, labels_auto, custom.
        """
        fields: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
elif False:
    AlertGroupConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlertGroupConfigurationArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Group configuration type, including no_group, labels_auto, custom.
        """
        pulumi.set(__self__, "type", type)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Group configuration type, including no_group, labels_auto, custom.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fields", value)


if not MYPY:
    class AlertJoinConfigurationArgsDict(TypedDict):
        condition: pulumi.Input[_builtins.str]
        """
        Join condition.
        """
        type: pulumi.Input[_builtins.str]
        """
        Join type, including cross_join, inner_join, left_join, right_join, full_join, left_exclude, right_exclude, concat, no_join.
        """
elif False:
    AlertJoinConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlertJoinConfigurationArgs:
    def __init__(__self__, *,
                 condition: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] condition: Join condition.
        :param pulumi.Input[_builtins.str] type: Join type, including cross_join, inner_join, left_join, right_join, full_join, left_exclude, right_exclude, concat, no_join.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> pulumi.Input[_builtins.str]:
        """
        Join condition.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Join type, including cross_join, inner_join, left_join, right_join, full_join, left_exclude, right_exclude, concat, no_join.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class AlertLabelArgsDict(TypedDict):
        key: pulumi.Input[_builtins.str]
        """
        Labels's key for new alert.
        """
        value: pulumi.Input[_builtins.str]
        """
        Labels's value for new alert.
        """
elif False:
    AlertLabelArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlertLabelArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] key: Labels's key for new alert.
        :param pulumi.Input[_builtins.str] value: Labels's value for new alert.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        Labels's key for new alert.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        Labels's value for new alert.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class AlertNotificationListArgsDict(TypedDict):
        content: pulumi.Input[_builtins.str]
        """
        Notice content of alarm.
        """
        type: pulumi.Input[_builtins.str]
        """
        Notification type. support Email, SMS, DingTalk, MessageCenter.
        """
        email_lists: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Email address list.
        """
        mobile_lists: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        SMS sending mobile number.
        """
        service_uri: NotRequired[pulumi.Input[_builtins.str]]
        """
        Request address.
        """
elif False:
    AlertNotificationListArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlertNotificationListArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 email_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mobile_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_uri: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] content: Notice content of alarm.
        :param pulumi.Input[_builtins.str] type: Notification type. support Email, SMS, DingTalk, MessageCenter.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] email_lists: Email address list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mobile_lists: SMS sending mobile number.
        :param pulumi.Input[_builtins.str] service_uri: Request address.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "type", type)
        if email_lists is not None:
            pulumi.set(__self__, "email_lists", email_lists)
        if mobile_lists is not None:
            pulumi.set(__self__, "mobile_lists", mobile_lists)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Input[_builtins.str]:
        """
        Notice content of alarm.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Notification type. support Email, SMS, DingTalk, MessageCenter.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="emailLists")
    def email_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Email address list.
        """
        return pulumi.get(self, "email_lists")

    @email_lists.setter
    def email_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "email_lists", value)

    @_builtins.property
    @pulumi.getter(name="mobileLists")
    def mobile_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        SMS sending mobile number.
        """
        return pulumi.get(self, "mobile_lists")

    @mobile_lists.setter
    def mobile_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "mobile_lists", value)

    @_builtins.property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Request address.
        """
        return pulumi.get(self, "service_uri")

    @service_uri.setter
    def service_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_uri", value)


if not MYPY:
    class AlertPolicyConfigurationArgsDict(TypedDict):
        alert_policy_id: pulumi.Input[_builtins.str]
        """
        Alert Policy Id.
        """
        repeat_interval: pulumi.Input[_builtins.str]
        """
        Repeat interval used by alert policy, 1h, 1m.e.g.
        """
        action_policy_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Action Policy Id.
        """
elif False:
    AlertPolicyConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlertPolicyConfigurationArgs:
    def __init__(__self__, *,
                 alert_policy_id: pulumi.Input[_builtins.str],
                 repeat_interval: pulumi.Input[_builtins.str],
                 action_policy_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] alert_policy_id: Alert Policy Id.
        :param pulumi.Input[_builtins.str] repeat_interval: Repeat interval used by alert policy, 1h, 1m.e.g.
        :param pulumi.Input[_builtins.str] action_policy_id: Action Policy Id.
        """
        pulumi.set(__self__, "alert_policy_id", alert_policy_id)
        pulumi.set(__self__, "repeat_interval", repeat_interval)
        if action_policy_id is not None:
            pulumi.set(__self__, "action_policy_id", action_policy_id)

    @_builtins.property
    @pulumi.getter(name="alertPolicyId")
    def alert_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        Alert Policy Id.
        """
        return pulumi.get(self, "alert_policy_id")

    @alert_policy_id.setter
    def alert_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "alert_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> pulumi.Input[_builtins.str]:
        """
        Repeat interval used by alert policy, 1h, 1m.e.g.
        """
        return pulumi.get(self, "repeat_interval")

    @repeat_interval.setter
    def repeat_interval(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repeat_interval", value)

    @_builtins.property
    @pulumi.getter(name="actionPolicyId")
    def action_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action Policy Id.
        """
        return pulumi.get(self, "action_policy_id")

    @action_policy_id.setter
    def action_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action_policy_id", value)


if not MYPY:
    class AlertQueryListArgsDict(TypedDict):
        end: pulumi.Input[_builtins.str]
        """
        End time. example: 20s.
        """
        query: pulumi.Input[_builtins.str]
        """
        Query corresponding to chart. example: * AND aliyun.
        """
        start: pulumi.Input[_builtins.str]
        """
        Begin time. example: -60s.
        """
        chart_title: NotRequired[pulumi.Input[_builtins.str]]
        """
        Chart title, optional from 1.161.0+.
        """
        dashboard_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Query dashboard id.
        """
        logstore: NotRequired[pulumi.Input[_builtins.str]]
        """
        Query logstore, use store for new alert, Deprecated from 1.161.0+.
        """
        power_sql_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        default disable, whether to use power sql. support auto, enable, disable.
        """
        project: NotRequired[pulumi.Input[_builtins.str]]
        """
        Query project.
        """
        region: NotRequired[pulumi.Input[_builtins.str]]
        """
        Query project region.
        """
        role_arn: NotRequired[pulumi.Input[_builtins.str]]
        """
        Query project store's ARN.
        """
        store: NotRequired[pulumi.Input[_builtins.str]]
        """
        Query store for new alert.
        """
        store_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Query store type for new alert, including log,metric,meta.
        """
        time_span_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        default Custom. No need to configure this parameter.
        """
elif False:
    AlertQueryListArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlertQueryListArgs:
    def __init__(__self__, *,
                 end: pulumi.Input[_builtins.str],
                 query: pulumi.Input[_builtins.str],
                 start: pulumi.Input[_builtins.str],
                 chart_title: Optional[pulumi.Input[_builtins.str]] = None,
                 dashboard_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logstore: Optional[pulumi.Input[_builtins.str]] = None,
                 power_sql_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 store: Optional[pulumi.Input[_builtins.str]] = None,
                 store_type: Optional[pulumi.Input[_builtins.str]] = None,
                 time_span_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] end: End time. example: 20s.
        :param pulumi.Input[_builtins.str] query: Query corresponding to chart. example: * AND aliyun.
        :param pulumi.Input[_builtins.str] start: Begin time. example: -60s.
        :param pulumi.Input[_builtins.str] chart_title: Chart title, optional from 1.161.0+.
        :param pulumi.Input[_builtins.str] dashboard_id: Query dashboard id.
        :param pulumi.Input[_builtins.str] logstore: Query logstore, use store for new alert, Deprecated from 1.161.0+.
        :param pulumi.Input[_builtins.str] power_sql_mode: default disable, whether to use power sql. support auto, enable, disable.
        :param pulumi.Input[_builtins.str] project: Query project.
        :param pulumi.Input[_builtins.str] region: Query project region.
        :param pulumi.Input[_builtins.str] role_arn: Query project store's ARN.
        :param pulumi.Input[_builtins.str] store: Query store for new alert.
        :param pulumi.Input[_builtins.str] store_type: Query store type for new alert, including log,metric,meta.
        :param pulumi.Input[_builtins.str] time_span_type: default Custom. No need to configure this parameter.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "start", start)
        if chart_title is not None:
            pulumi.set(__self__, "chart_title", chart_title)
        if dashboard_id is not None:
            pulumi.set(__self__, "dashboard_id", dashboard_id)
        if logstore is not None:
            warnings.warn("""Deprecated from 1.161.0+, use store""", DeprecationWarning)
            pulumi.log.warn("""logstore is deprecated: Deprecated from 1.161.0+, use store""")
        if logstore is not None:
            pulumi.set(__self__, "logstore", logstore)
        if power_sql_mode is not None:
            pulumi.set(__self__, "power_sql_mode", power_sql_mode)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if store is not None:
            pulumi.set(__self__, "store", store)
        if store_type is not None:
            pulumi.set(__self__, "store_type", store_type)
        if time_span_type is not None:
            pulumi.set(__self__, "time_span_type", time_span_type)

    @_builtins.property
    @pulumi.getter
    def end(self) -> pulumi.Input[_builtins.str]:
        """
        End time. example: 20s.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "end", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> pulumi.Input[_builtins.str]:
        """
        Query corresponding to chart. example: * AND aliyun.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "query", value)

    @_builtins.property
    @pulumi.getter
    def start(self) -> pulumi.Input[_builtins.str]:
        """
        Begin time. example: -60s.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "start", value)

    @_builtins.property
    @pulumi.getter(name="chartTitle")
    def chart_title(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Chart title, optional from 1.161.0+.
        """
        return pulumi.get(self, "chart_title")

    @chart_title.setter
    def chart_title(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "chart_title", value)

    @_builtins.property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Query dashboard id.
        """
        return pulumi.get(self, "dashboard_id")

    @dashboard_id.setter
    def dashboard_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dashboard_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Deprecated from 1.161.0+, use store""")
    def logstore(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Query logstore, use store for new alert, Deprecated from 1.161.0+.
        """
        return pulumi.get(self, "logstore")

    @logstore.setter
    def logstore(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logstore", value)

    @_builtins.property
    @pulumi.getter(name="powerSqlMode")
    def power_sql_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        default disable, whether to use power sql. support auto, enable, disable.
        """
        return pulumi.get(self, "power_sql_mode")

    @power_sql_mode.setter
    def power_sql_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "power_sql_mode", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Query project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Query project region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Query project store's ARN.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter
    def store(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Query store for new alert.
        """
        return pulumi.get(self, "store")

    @store.setter
    def store(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "store", value)

    @_builtins.property
    @pulumi.getter(name="storeType")
    def store_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Query store type for new alert, including log,metric,meta.
        """
        return pulumi.get(self, "store_type")

    @store_type.setter
    def store_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "store_type", value)

    @_builtins.property
    @pulumi.getter(name="timeSpanType")
    def time_span_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        default Custom. No need to configure this parameter.
        """
        return pulumi.get(self, "time_span_type")

    @time_span_type.setter
    def time_span_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_span_type", value)


if not MYPY:
    class AlertScheduleArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        including FixedRate,Hourly,Daily,Weekly,Cron.
        """
        cron_expression: NotRequired[pulumi.Input[_builtins.str]]
        """
        Cron expression when type is Cron.
        """
        day_of_week: NotRequired[pulumi.Input[_builtins.int]]
        """
        Day of week when type is Weekly, including 0,1,2,3,4,5,6, 0 for Sunday, 1 for Monday
        """
        delay: NotRequired[pulumi.Input[_builtins.int]]
        hour: NotRequired[pulumi.Input[_builtins.int]]
        """
        Hour of day when type is Weekly/Daily.
        """
        interval: NotRequired[pulumi.Input[_builtins.str]]
        """
        Execution interval. 60 seconds minimum, such as 60s, 1h. used when type is FixedRate.
        """
        run_immediately: NotRequired[pulumi.Input[_builtins.bool]]
        time_zone: NotRequired[pulumi.Input[_builtins.str]]
        """
        Time zone for schedule.
        """
elif False:
    AlertScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlertScheduleArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 cron_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 day_of_week: Optional[pulumi.Input[_builtins.int]] = None,
                 delay: Optional[pulumi.Input[_builtins.int]] = None,
                 hour: Optional[pulumi.Input[_builtins.int]] = None,
                 interval: Optional[pulumi.Input[_builtins.str]] = None,
                 run_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: including FixedRate,Hourly,Daily,Weekly,Cron.
        :param pulumi.Input[_builtins.str] cron_expression: Cron expression when type is Cron.
        :param pulumi.Input[_builtins.int] day_of_week: Day of week when type is Weekly, including 0,1,2,3,4,5,6, 0 for Sunday, 1 for Monday
        :param pulumi.Input[_builtins.int] hour: Hour of day when type is Weekly/Daily.
        :param pulumi.Input[_builtins.str] interval: Execution interval. 60 seconds minimum, such as 60s, 1h. used when type is FixedRate.
        :param pulumi.Input[_builtins.str] time_zone: Time zone for schedule.
        """
        pulumi.set(__self__, "type", type)
        if cron_expression is not None:
            pulumi.set(__self__, "cron_expression", cron_expression)
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if run_immediately is not None:
            pulumi.set(__self__, "run_immediately", run_immediately)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        including FixedRate,Hourly,Daily,Weekly,Cron.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cron expression when type is Cron.
        """
        return pulumi.get(self, "cron_expression")

    @cron_expression.setter
    def cron_expression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cron_expression", value)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Day of week when type is Weekly, including 0,1,2,3,4,5,6, 0 for Sunday, 1 for Monday
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "day_of_week", value)

    @_builtins.property
    @pulumi.getter
    def delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "delay")

    @delay.setter
    def delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "delay", value)

    @_builtins.property
    @pulumi.getter
    def hour(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Hour of day when type is Weekly/Daily.
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hour", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Execution interval. 60 seconds minimum, such as 60s, 1h. used when type is FixedRate.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter(name="runImmediately")
    def run_immediately(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "run_immediately")

    @run_immediately.setter
    def run_immediately(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_immediately", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time zone for schedule.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)


if not MYPY:
    class AlertSeverityConfigurationArgsDict(TypedDict):
        eval_condition: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]
        """
        Severity when this condition is met.
        """
        severity: pulumi.Input[_builtins.int]
        """
        Severity for new alert, including 2,4,6,8,10 for Report,Low,Medium,High,Critical.
        """
elif False:
    AlertSeverityConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlertSeverityConfigurationArgs:
    def __init__(__self__, *,
                 eval_condition: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 severity: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] eval_condition: Severity when this condition is met.
        :param pulumi.Input[_builtins.int] severity: Severity for new alert, including 2,4,6,8,10 for Report,Low,Medium,High,Critical.
        """
        pulumi.set(__self__, "eval_condition", eval_condition)
        pulumi.set(__self__, "severity", severity)

    @_builtins.property
    @pulumi.getter(name="evalCondition")
    def eval_condition(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        Severity when this condition is met.
        """
        return pulumi.get(self, "eval_condition")

    @eval_condition.setter
    def eval_condition(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "eval_condition", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> pulumi.Input[_builtins.int]:
        """
        Severity for new alert, including 2,4,6,8,10 for Report,Low,Medium,High,Critical.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "severity", value)


if not MYPY:
    class AlertTemplateConfigurationArgsDict(TypedDict):
        id: pulumi.Input[_builtins.str]
        """
        Alert template id.
        """
        type: pulumi.Input[_builtins.str]
        """
        Alert template type including `sys`, `user`.
        """
        annotations: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Alert template annotations.
        """
        lang: NotRequired[pulumi.Input[_builtins.str]]
        """
        Alert template language including `cn`, `en`.
        """
        tokens: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Alert template tokens.
        """
elif False:
    AlertTemplateConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlertTemplateConfigurationArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 tokens: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] id: Alert template id.
        :param pulumi.Input[_builtins.str] type: Alert template type including `sys`, `user`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Alert template annotations.
        :param pulumi.Input[_builtins.str] lang: Alert template language including `cn`, `en`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tokens: Alert template tokens.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if tokens is not None:
            pulumi.set(__self__, "tokens", tokens)

    @_builtins.property
    @pulumi.getter
    def id(self) -> pulumi.Input[_builtins.str]:
        """
        Alert template id.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Alert template type including `sys`, `user`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Alert template annotations.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alert template language including `cn`, `en`.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter
    def tokens(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Alert template tokens.
        """
        return pulumi.get(self, "tokens")

    @tokens.setter
    def tokens(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tokens", value)


if not MYPY:
    class EtlEtlSinkArgsDict(TypedDict):
        endpoint: pulumi.Input[_builtins.str]
        """
        Delivery target logstore region.
        """
        logstore: pulumi.Input[_builtins.str]
        """
        Delivery target logstore.
        """
        name: pulumi.Input[_builtins.str]
        """
        Delivery target name.
        """
        project: pulumi.Input[_builtins.str]
        """
        The project where the target logstore is delivered.
        """
        access_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Delivery target logstore access key id.
        """
        access_key_secret: NotRequired[pulumi.Input[_builtins.str]]
        """
        Delivery target logstore access key secret.
        """
        kms_encrypted_access_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
        """
        kms_encrypted_access_key_secret: NotRequired[pulumi.Input[_builtins.str]]
        """
        An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
        """
        role_arn: NotRequired[pulumi.Input[_builtins.str]]
        """
        Sts role info under delivery target logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        ETL sinks type, the default value is AliyunLOG.

        > **Note:** `from_time` and `to_time` no modification allowed after successful creation.
        """
elif False:
    EtlEtlSinkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EtlEtlSinkArgs:
    def __init__(__self__, *,
                 endpoint: pulumi.Input[_builtins.str],
                 logstore: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 project: pulumi.Input[_builtins.str],
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 access_key_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_access_key_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] endpoint: Delivery target logstore region.
        :param pulumi.Input[_builtins.str] logstore: Delivery target logstore.
        :param pulumi.Input[_builtins.str] name: Delivery target name.
        :param pulumi.Input[_builtins.str] project: The project where the target logstore is delivered.
        :param pulumi.Input[_builtins.str] access_key_id: Delivery target logstore access key id.
        :param pulumi.Input[_builtins.str] access_key_secret: Delivery target logstore access key secret.
        :param pulumi.Input[_builtins.str] kms_encrypted_access_key_id: An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
        :param pulumi.Input[_builtins.str] kms_encrypted_access_key_secret: An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
        :param pulumi.Input[_builtins.str] role_arn: Sts role info under delivery target logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
        :param pulumi.Input[_builtins.str] type: ETL sinks type, the default value is AliyunLOG.
               
               > **Note:** `from_time` and `to_time` no modification allowed after successful creation.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "logstore", logstore)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project", project)
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if access_key_secret is not None:
            pulumi.set(__self__, "access_key_secret", access_key_secret)
        if kms_encrypted_access_key_id is not None:
            pulumi.set(__self__, "kms_encrypted_access_key_id", kms_encrypted_access_key_id)
        if kms_encrypted_access_key_secret is not None:
            pulumi.set(__self__, "kms_encrypted_access_key_secret", kms_encrypted_access_key_secret)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        Delivery target logstore region.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def logstore(self) -> pulumi.Input[_builtins.str]:
        """
        Delivery target logstore.
        """
        return pulumi.get(self, "logstore")

    @logstore.setter
    def logstore(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "logstore", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Delivery target name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The project where the target logstore is delivered.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Delivery target logstore access key id.
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key_id", value)

    @_builtins.property
    @pulumi.getter(name="accessKeySecret")
    def access_key_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Delivery target logstore access key secret.
        """
        return pulumi.get(self, "access_key_secret")

    @access_key_secret.setter
    def access_key_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key_secret", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedAccessKeyId")
    def kms_encrypted_access_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_access_key_id")

    @kms_encrypted_access_key_id.setter
    def kms_encrypted_access_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encrypted_access_key_id", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedAccessKeySecret")
    def kms_encrypted_access_key_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_access_key_secret")

    @kms_encrypted_access_key_secret.setter
    def kms_encrypted_access_key_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encrypted_access_key_secret", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sts role info under delivery target logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ETL sinks type, the default value is AliyunLOG.

        > **Note:** `from_time` and `to_time` no modification allowed after successful creation.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class OssExportConfigColumnArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the key.
        """
        type: pulumi.Input[_builtins.str]
        """
        Type of configuration name.
        """
elif False:
    OssExportConfigColumnArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OssExportConfigColumnArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: The name of the key.
        :param pulumi.Input[_builtins.str] type: Type of configuration name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of configuration name.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class OssShipperParquetConfigArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        type: pulumi.Input[_builtins.str]
elif False:
    OssShipperParquetConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OssShipperParquetConfigArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str]):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class StoreEncryptConfArgsDict(TypedDict):
        enable: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enable encryption. Default false.
        """
        encrypt_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Supported encryption type, only supports `default`(AES), `m4`.
        """
        user_cmk_info: NotRequired[pulumi.Input['StoreEncryptConfUserCmkInfoArgsDict']]
        """
        User bring your own key (BYOK) encryption Refer to details, the format is as follows. See user_cmk_info below. `{ "cmk_key_id": "your_cmk_key_id", "arn": "your_role_arn", "region_id": "you_cmk_region_id" }`. See `user_cmk_info` below.
        """
elif False:
    StoreEncryptConfArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StoreEncryptConfArgs:
    def __init__(__self__, *,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypt_type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_cmk_info: Optional[pulumi.Input['StoreEncryptConfUserCmkInfoArgs']] = None):
        """
        :param pulumi.Input[_builtins.bool] enable: Enable encryption. Default false.
        :param pulumi.Input[_builtins.str] encrypt_type: Supported encryption type, only supports `default`(AES), `m4`.
        :param pulumi.Input['StoreEncryptConfUserCmkInfoArgs'] user_cmk_info: User bring your own key (BYOK) encryption Refer to details, the format is as follows. See user_cmk_info below. `{ "cmk_key_id": "your_cmk_key_id", "arn": "your_role_arn", "region_id": "you_cmk_region_id" }`. See `user_cmk_info` below.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if encrypt_type is not None:
            pulumi.set(__self__, "encrypt_type", encrypt_type)
        if user_cmk_info is not None:
            pulumi.set(__self__, "user_cmk_info", user_cmk_info)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable encryption. Default false.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter(name="encryptType")
    def encrypt_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Supported encryption type, only supports `default`(AES), `m4`.
        """
        return pulumi.get(self, "encrypt_type")

    @encrypt_type.setter
    def encrypt_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encrypt_type", value)

    @_builtins.property
    @pulumi.getter(name="userCmkInfo")
    def user_cmk_info(self) -> Optional[pulumi.Input['StoreEncryptConfUserCmkInfoArgs']]:
        """
        User bring your own key (BYOK) encryption Refer to details, the format is as follows. See user_cmk_info below. `{ "cmk_key_id": "your_cmk_key_id", "arn": "your_role_arn", "region_id": "you_cmk_region_id" }`. See `user_cmk_info` below.
        """
        return pulumi.get(self, "user_cmk_info")

    @user_cmk_info.setter
    def user_cmk_info(self, value: Optional[pulumi.Input['StoreEncryptConfUserCmkInfoArgs']]):
        pulumi.set(self, "user_cmk_info", value)


if not MYPY:
    class StoreEncryptConfUserCmkInfoArgsDict(TypedDict):
        arn: NotRequired[pulumi.Input[_builtins.str]]
        """
        Role arn.
        """
        cmk_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        User master key id.
        """
        region_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Region id where the user master key id is located.
        """
elif False:
    StoreEncryptConfUserCmkInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StoreEncryptConfUserCmkInfoArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 cmk_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] arn: Role arn.
        :param pulumi.Input[_builtins.str] cmk_key_id: User master key id.
        :param pulumi.Input[_builtins.str] region_id: Region id where the user master key id is located.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if cmk_key_id is not None:
            pulumi.set(__self__, "cmk_key_id", cmk_key_id)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Role arn.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="cmkKeyId")
    def cmk_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User master key id.
        """
        return pulumi.get(self, "cmk_key_id")

    @cmk_key_id.setter
    def cmk_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cmk_key_id", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region id where the user master key id is located.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)


if not MYPY:
    class StoreIndexFieldSearchArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The field name, which is unique in the same log store.
        """
        alias: NotRequired[pulumi.Input[_builtins.str]]
        """
        The alias of one field
        """
        case_sensitive: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether the case sensitive for the field. Default to false. It is valid when "type" is "text" or "json".
        """
        enable_analytics: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable field analytics. Default to true.
        """
        include_chinese: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether includes the chinese for the field. Default to false. It is valid when "type" is "text" or "json".
        """
        json_keys: NotRequired[pulumi.Input[Sequence[pulumi.Input['StoreIndexFieldSearchJsonKeyArgsDict']]]]
        """
        Use nested index when type is json
        """
        token: NotRequired[pulumi.Input[_builtins.str]]
        """
        The string of several split words, like "\\r", "#". It is valid when "type" is "text" or "json".
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of one field. Valid values: ["long", "text", "double", "json"]. Default to "long".
        """
elif False:
    StoreIndexFieldSearchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StoreIndexFieldSearchArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 case_sensitive: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_analytics: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_chinese: Optional[pulumi.Input[_builtins.bool]] = None,
                 json_keys: Optional[pulumi.Input[Sequence[pulumi.Input['StoreIndexFieldSearchJsonKeyArgs']]]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The field name, which is unique in the same log store.
        :param pulumi.Input[_builtins.str] alias: The alias of one field
        :param pulumi.Input[_builtins.bool] case_sensitive: Whether the case sensitive for the field. Default to false. It is valid when "type" is "text" or "json".
        :param pulumi.Input[_builtins.bool] enable_analytics: Whether to enable field analytics. Default to true.
        :param pulumi.Input[_builtins.bool] include_chinese: Whether includes the chinese for the field. Default to false. It is valid when "type" is "text" or "json".
        :param pulumi.Input[Sequence[pulumi.Input['StoreIndexFieldSearchJsonKeyArgs']]] json_keys: Use nested index when type is json
        :param pulumi.Input[_builtins.str] token: The string of several split words, like "\\r", "#". It is valid when "type" is "text" or "json".
        :param pulumi.Input[_builtins.str] type: The type of one field. Valid values: ["long", "text", "double", "json"]. Default to "long".
        """
        pulumi.set(__self__, "name", name)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)
        if enable_analytics is not None:
            pulumi.set(__self__, "enable_analytics", enable_analytics)
        if include_chinese is not None:
            pulumi.set(__self__, "include_chinese", include_chinese)
        if json_keys is not None:
            pulumi.set(__self__, "json_keys", json_keys)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The field name, which is unique in the same log store.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alias of one field
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alias", value)

    @_builtins.property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the case sensitive for the field. Default to false. It is valid when "type" is "text" or "json".
        """
        return pulumi.get(self, "case_sensitive")

    @case_sensitive.setter
    def case_sensitive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "case_sensitive", value)

    @_builtins.property
    @pulumi.getter(name="enableAnalytics")
    def enable_analytics(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable field analytics. Default to true.
        """
        return pulumi.get(self, "enable_analytics")

    @enable_analytics.setter
    def enable_analytics(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_analytics", value)

    @_builtins.property
    @pulumi.getter(name="includeChinese")
    def include_chinese(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether includes the chinese for the field. Default to false. It is valid when "type" is "text" or "json".
        """
        return pulumi.get(self, "include_chinese")

    @include_chinese.setter
    def include_chinese(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_chinese", value)

    @_builtins.property
    @pulumi.getter(name="jsonKeys")
    def json_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StoreIndexFieldSearchJsonKeyArgs']]]]:
        """
        Use nested index when type is json
        """
        return pulumi.get(self, "json_keys")

    @json_keys.setter
    def json_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StoreIndexFieldSearchJsonKeyArgs']]]]):
        pulumi.set(self, "json_keys", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string of several split words, like "\\r", "#". It is valid when "type" is "text" or "json".
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of one field. Valid values: ["long", "text", "double", "json"]. Default to "long".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class StoreIndexFieldSearchJsonKeyArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        When using the json_keys field, this field is required.
        """
        alias: NotRequired[pulumi.Input[_builtins.str]]
        """
        The alias of one field.
        """
        doc_value: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable statistics. default to true.

        > **Note:** At least one of the "full_text" and "field_search" should be specified.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of one field. Valid values: ["long", "text", "double"]. Default to "long"
        """
elif False:
    StoreIndexFieldSearchJsonKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StoreIndexFieldSearchJsonKeyArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 doc_value: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: When using the json_keys field, this field is required.
        :param pulumi.Input[_builtins.str] alias: The alias of one field.
        :param pulumi.Input[_builtins.bool] doc_value: Whether to enable statistics. default to true.
               
               > **Note:** At least one of the "full_text" and "field_search" should be specified.
        :param pulumi.Input[_builtins.str] type: The type of one field. Valid values: ["long", "text", "double"]. Default to "long"
        """
        pulumi.set(__self__, "name", name)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if doc_value is not None:
            pulumi.set(__self__, "doc_value", doc_value)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        When using the json_keys field, this field is required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alias of one field.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alias", value)

    @_builtins.property
    @pulumi.getter(name="docValue")
    def doc_value(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable statistics. default to true.

        > **Note:** At least one of the "full_text" and "field_search" should be specified.
        """
        return pulumi.get(self, "doc_value")

    @doc_value.setter
    def doc_value(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "doc_value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of one field. Valid values: ["long", "text", "double"]. Default to "long"
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class StoreIndexFullTextArgsDict(TypedDict):
        case_sensitive: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether the case sensitive. Default to false.
        """
        include_chinese: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether includes the chinese. Default to false.
        """
        token: NotRequired[pulumi.Input[_builtins.str]]
        """
        The string of several split words, like "\\r", "#"
        """
elif False:
    StoreIndexFullTextArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StoreIndexFullTextArgs:
    def __init__(__self__, *,
                 case_sensitive: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_chinese: Optional[pulumi.Input[_builtins.bool]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] case_sensitive: Whether the case sensitive. Default to false.
        :param pulumi.Input[_builtins.bool] include_chinese: Whether includes the chinese. Default to false.
        :param pulumi.Input[_builtins.str] token: The string of several split words, like "\\r", "#"
        """
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)
        if include_chinese is not None:
            pulumi.set(__self__, "include_chinese", include_chinese)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @_builtins.property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the case sensitive. Default to false.
        """
        return pulumi.get(self, "case_sensitive")

    @case_sensitive.setter
    def case_sensitive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "case_sensitive", value)

    @_builtins.property
    @pulumi.getter(name="includeChinese")
    def include_chinese(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether includes the chinese. Default to false.
        """
        return pulumi.get(self, "include_chinese")

    @include_chinese.setter
    def include_chinese(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_chinese", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string of several split words, like "\\r", "#"
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)


if not MYPY:
    class StoreShardArgsDict(TypedDict):
        begin_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        The begin value of the shard range(MD5), included in the shard range.
        """
        end_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        The end value of the shard range(MD5), not included in shard range.
        """
        id: NotRequired[pulumi.Input[_builtins.int]]
        """
        The ID of the shard.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        Shard status, only two status of `readwrite` and `readonly`.
        """
elif False:
    StoreShardArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StoreShardArgs:
    def __init__(__self__, *,
                 begin_key: Optional[pulumi.Input[_builtins.str]] = None,
                 end_key: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] begin_key: The begin value of the shard range(MD5), included in the shard range.
        :param pulumi.Input[_builtins.str] end_key: The end value of the shard range(MD5), not included in shard range.
        :param pulumi.Input[_builtins.int] id: The ID of the shard.
        :param pulumi.Input[_builtins.str] status: Shard status, only two status of `readwrite` and `readonly`.
        """
        if begin_key is not None:
            pulumi.set(__self__, "begin_key", begin_key)
        if end_key is not None:
            pulumi.set(__self__, "end_key", end_key)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="beginKey")
    def begin_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The begin value of the shard range(MD5), included in the shard range.
        """
        return pulumi.get(self, "begin_key")

    @begin_key.setter
    def begin_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "begin_key", value)

    @_builtins.property
    @pulumi.getter(name="endKey")
    def end_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end value of the shard range(MD5), not included in shard range.
        """
        return pulumi.get(self, "end_key")

    @end_key.setter
    def end_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_key", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the shard.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Shard status, only two status of `readwrite` and `readonly`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


