# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 default_quota: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_white_list: Optional[pulumi.Input['ProjectIpWhiteListArgs']] = None,
                 is_logical: Optional[pulumi.Input[_builtins.str]] = None,
                 product_type: Optional[pulumi.Input[_builtins.str]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input['ProjectPropertiesArgs']] = None,
                 security_properties: Optional[pulumi.Input['ProjectSecurityPropertiesArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 three_tier_model: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[_builtins.str] comment: Project description information. The length is 1 to 256 English or Chinese characters. The default value is blank.
        :param pulumi.Input[_builtins.str] default_quota: Used to implement computing resource allocation. Valid values: subQuota Nickname
               If the calculation Quota is not specified, the default Quota resource will be consumed by jobs initiated by the project. For more information about computing resource usage, see [Computing Resource Usage](https://www.alibabacloud.com/help/en/maxcompute/user-guide/use-of-computing-resources).
        :param pulumi.Input['ProjectIpWhiteListArgs'] ip_white_list: IP whitelist See `ip_white_list` below.
        :param pulumi.Input[_builtins.str] is_logical: Whether to logically delete. Default value: true. Value: (ture/false),
               
               > **NOTE:** -- ture: In this case, the project status will be changed to' deleting' and completely deleted after 14 days. -- false: delete immediately, that is, completely deleted and permanently irrecoverable.
        :param pulumi.Input[_builtins.str] project_name: The name begins with a letter, containing letters, digits, and underscores (_). It can be 3 to 28 characters in length and is globally unique.
        :param pulumi.Input['ProjectPropertiesArgs'] properties: Project base attributes See `properties` below.
        :param pulumi.Input['ProjectSecurityPropertiesArgs'] security_properties: Security-related attributes See `security_properties` below.
        :param pulumi.Input[_builtins.str] status: The project status. Default value: AVAILABLE. Value: (AVAILABLE/READONLY/FROZEN/DELETING)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.bool] three_tier_model: Indicates whether data storage by schema is supported. Valid values:
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if default_quota is not None:
            pulumi.set(__self__, "default_quota", default_quota)
        if ip_white_list is not None:
            pulumi.set(__self__, "ip_white_list", ip_white_list)
        if is_logical is not None:
            pulumi.set(__self__, "is_logical", is_logical)
        if product_type is not None:
            pulumi.set(__self__, "product_type", product_type)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if security_properties is not None:
            pulumi.set(__self__, "security_properties", security_properties)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if three_tier_model is not None:
            pulumi.set(__self__, "three_tier_model", three_tier_model)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project description information. The length is 1 to 256 English or Chinese characters. The default value is blank.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="defaultQuota")
    def default_quota(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to implement computing resource allocation. Valid values: subQuota Nickname
        If the calculation Quota is not specified, the default Quota resource will be consumed by jobs initiated by the project. For more information about computing resource usage, see [Computing Resource Usage](https://www.alibabacloud.com/help/en/maxcompute/user-guide/use-of-computing-resources).
        """
        return pulumi.get(self, "default_quota")

    @default_quota.setter
    def default_quota(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_quota", value)

    @_builtins.property
    @pulumi.getter(name="ipWhiteList")
    def ip_white_list(self) -> Optional[pulumi.Input['ProjectIpWhiteListArgs']]:
        """
        IP whitelist See `ip_white_list` below.
        """
        return pulumi.get(self, "ip_white_list")

    @ip_white_list.setter
    def ip_white_list(self, value: Optional[pulumi.Input['ProjectIpWhiteListArgs']]):
        pulumi.set(self, "ip_white_list", value)

    @_builtins.property
    @pulumi.getter(name="isLogical")
    def is_logical(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to logically delete. Default value: true. Value: (ture/false),

        > **NOTE:** -- ture: In this case, the project status will be changed to' deleting' and completely deleted after 14 days. -- false: delete immediately, that is, completely deleted and permanently irrecoverable.
        """
        return pulumi.get(self, "is_logical")

    @is_logical.setter
    def is_logical(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "is_logical", value)

    @_builtins.property
    @pulumi.getter(name="productType")
    def product_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "product_type")

    @product_type.setter
    def product_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_type", value)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name begins with a letter, containing letters, digits, and underscores (_). It can be 3 to 28 characters in length and is globally unique.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_name", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['ProjectPropertiesArgs']]:
        """
        Project base attributes See `properties` below.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['ProjectPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="securityProperties")
    def security_properties(self) -> Optional[pulumi.Input['ProjectSecurityPropertiesArgs']]:
        """
        Security-related attributes See `security_properties` below.
        """
        return pulumi.get(self, "security_properties")

    @security_properties.setter
    def security_properties(self, value: Optional[pulumi.Input['ProjectSecurityPropertiesArgs']]):
        pulumi.set(self, "security_properties", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project status. Default value: AVAILABLE. Value: (AVAILABLE/READONLY/FROZEN/DELETING)
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="threeTierModel")
    def three_tier_model(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether data storage by schema is supported. Valid values:
        """
        return pulumi.get(self, "three_tier_model")

    @three_tier_model.setter
    def three_tier_model(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "three_tier_model", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 default_quota: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_white_list: Optional[pulumi.Input['ProjectIpWhiteListArgs']] = None,
                 is_logical: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 product_type: Optional[pulumi.Input[_builtins.str]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input['ProjectPropertiesArgs']] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_properties: Optional[pulumi.Input['ProjectSecurityPropertiesArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 three_tier_model: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[_builtins.str] comment: Project description information. The length is 1 to 256 English or Chinese characters. The default value is blank.
        :param pulumi.Input[_builtins.str] create_time: Represents the creation time of the project
        :param pulumi.Input[_builtins.str] default_quota: Used to implement computing resource allocation. Valid values: subQuota Nickname
               If the calculation Quota is not specified, the default Quota resource will be consumed by jobs initiated by the project. For more information about computing resource usage, see [Computing Resource Usage](https://www.alibabacloud.com/help/en/maxcompute/user-guide/use-of-computing-resources).
        :param pulumi.Input['ProjectIpWhiteListArgs'] ip_white_list: IP whitelist See `ip_white_list` below.
        :param pulumi.Input[_builtins.str] is_logical: Whether to logically delete. Default value: true. Value: (ture/false),
               
               > **NOTE:** -- ture: In this case, the project status will be changed to' deleting' and completely deleted after 14 days. -- false: delete immediately, that is, completely deleted and permanently irrecoverable.
        :param pulumi.Input[_builtins.str] owner: Project owner
        :param pulumi.Input[_builtins.str] project_name: The name begins with a letter, containing letters, digits, and underscores (_). It can be 3 to 28 characters in length and is globally unique.
        :param pulumi.Input['ProjectPropertiesArgs'] properties: Project base attributes See `properties` below.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource
        :param pulumi.Input['ProjectSecurityPropertiesArgs'] security_properties: Security-related attributes See `security_properties` below.
        :param pulumi.Input[_builtins.str] status: The project status. Default value: AVAILABLE. Value: (AVAILABLE/READONLY/FROZEN/DELETING)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.bool] three_tier_model: Indicates whether data storage by schema is supported. Valid values:
        :param pulumi.Input[_builtins.str] type: Project type
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if default_quota is not None:
            pulumi.set(__self__, "default_quota", default_quota)
        if ip_white_list is not None:
            pulumi.set(__self__, "ip_white_list", ip_white_list)
        if is_logical is not None:
            pulumi.set(__self__, "is_logical", is_logical)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if product_type is not None:
            pulumi.set(__self__, "product_type", product_type)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if security_properties is not None:
            pulumi.set(__self__, "security_properties", security_properties)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if three_tier_model is not None:
            pulumi.set(__self__, "three_tier_model", three_tier_model)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project description information. The length is 1 to 256 English or Chinese characters. The default value is blank.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Represents the creation time of the project
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="defaultQuota")
    def default_quota(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to implement computing resource allocation. Valid values: subQuota Nickname
        If the calculation Quota is not specified, the default Quota resource will be consumed by jobs initiated by the project. For more information about computing resource usage, see [Computing Resource Usage](https://www.alibabacloud.com/help/en/maxcompute/user-guide/use-of-computing-resources).
        """
        return pulumi.get(self, "default_quota")

    @default_quota.setter
    def default_quota(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_quota", value)

    @_builtins.property
    @pulumi.getter(name="ipWhiteList")
    def ip_white_list(self) -> Optional[pulumi.Input['ProjectIpWhiteListArgs']]:
        """
        IP whitelist See `ip_white_list` below.
        """
        return pulumi.get(self, "ip_white_list")

    @ip_white_list.setter
    def ip_white_list(self, value: Optional[pulumi.Input['ProjectIpWhiteListArgs']]):
        pulumi.set(self, "ip_white_list", value)

    @_builtins.property
    @pulumi.getter(name="isLogical")
    def is_logical(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to logically delete. Default value: true. Value: (ture/false),

        > **NOTE:** -- ture: In this case, the project status will be changed to' deleting' and completely deleted after 14 days. -- false: delete immediately, that is, completely deleted and permanently irrecoverable.
        """
        return pulumi.get(self, "is_logical")

    @is_logical.setter
    def is_logical(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "is_logical", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project owner
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter(name="productType")
    def product_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "product_type")

    @product_type.setter
    def product_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_type", value)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name begins with a letter, containing letters, digits, and underscores (_). It can be 3 to 28 characters in length and is globally unique.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_name", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['ProjectPropertiesArgs']]:
        """
        Project base attributes See `properties` below.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['ProjectPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the resource
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="securityProperties")
    def security_properties(self) -> Optional[pulumi.Input['ProjectSecurityPropertiesArgs']]:
        """
        Security-related attributes See `security_properties` below.
        """
        return pulumi.get(self, "security_properties")

    @security_properties.setter
    def security_properties(self, value: Optional[pulumi.Input['ProjectSecurityPropertiesArgs']]):
        pulumi.set(self, "security_properties", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project status. Default value: AVAILABLE. Value: (AVAILABLE/READONLY/FROZEN/DELETING)
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="threeTierModel")
    def three_tier_model(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether data storage by schema is supported. Valid values:
        """
        return pulumi.get(self, "three_tier_model")

    @three_tier_model.setter
    def three_tier_model(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "three_tier_model", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("alicloud:maxcompute/project:Project")
class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 default_quota: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_white_list: Optional[pulumi.Input[Union['ProjectIpWhiteListArgs', 'ProjectIpWhiteListArgsDict']]] = None,
                 is_logical: Optional[pulumi.Input[_builtins.str]] = None,
                 product_type: Optional[pulumi.Input[_builtins.str]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Union['ProjectPropertiesArgs', 'ProjectPropertiesArgsDict']]] = None,
                 security_properties: Optional[pulumi.Input[Union['ProjectSecurityPropertiesArgs', 'ProjectSecurityPropertiesArgsDict']]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 three_tier_model: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides a Max Compute Project resource.

        MaxCompute project .

        For information about Max Compute Project and how to use it, see [What is Project](https://www.alibabacloud.com/help/en/maxcompute/user-guide/api-maxcompute-2022-01-04-createproject).

        > **NOTE:** Available since v1.77.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.maxcompute.Project("default",
            default_quota="os_PayAsYouGoQuota",
            project_name=name,
            comment=name)
        ```

        ## Import

        Max Compute Project can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:maxcompute/project:Project example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Project description information. The length is 1 to 256 English or Chinese characters. The default value is blank.
        :param pulumi.Input[_builtins.str] default_quota: Used to implement computing resource allocation. Valid values: subQuota Nickname
               If the calculation Quota is not specified, the default Quota resource will be consumed by jobs initiated by the project. For more information about computing resource usage, see [Computing Resource Usage](https://www.alibabacloud.com/help/en/maxcompute/user-guide/use-of-computing-resources).
        :param pulumi.Input[Union['ProjectIpWhiteListArgs', 'ProjectIpWhiteListArgsDict']] ip_white_list: IP whitelist See `ip_white_list` below.
        :param pulumi.Input[_builtins.str] is_logical: Whether to logically delete. Default value: true. Value: (ture/false),
               
               > **NOTE:** -- ture: In this case, the project status will be changed to' deleting' and completely deleted after 14 days. -- false: delete immediately, that is, completely deleted and permanently irrecoverable.
        :param pulumi.Input[_builtins.str] project_name: The name begins with a letter, containing letters, digits, and underscores (_). It can be 3 to 28 characters in length and is globally unique.
        :param pulumi.Input[Union['ProjectPropertiesArgs', 'ProjectPropertiesArgsDict']] properties: Project base attributes See `properties` below.
        :param pulumi.Input[Union['ProjectSecurityPropertiesArgs', 'ProjectSecurityPropertiesArgsDict']] security_properties: Security-related attributes See `security_properties` below.
        :param pulumi.Input[_builtins.str] status: The project status. Default value: AVAILABLE. Value: (AVAILABLE/READONLY/FROZEN/DELETING)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.bool] three_tier_model: Indicates whether data storage by schema is supported. Valid values:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProjectArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Max Compute Project resource.

        MaxCompute project .

        For information about Max Compute Project and how to use it, see [What is Project](https://www.alibabacloud.com/help/en/maxcompute/user-guide/api-maxcompute-2022-01-04-createproject).

        > **NOTE:** Available since v1.77.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.maxcompute.Project("default",
            default_quota="os_PayAsYouGoQuota",
            project_name=name,
            comment=name)
        ```

        ## Import

        Max Compute Project can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:maxcompute/project:Project example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 default_quota: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_white_list: Optional[pulumi.Input[Union['ProjectIpWhiteListArgs', 'ProjectIpWhiteListArgsDict']]] = None,
                 is_logical: Optional[pulumi.Input[_builtins.str]] = None,
                 product_type: Optional[pulumi.Input[_builtins.str]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Union['ProjectPropertiesArgs', 'ProjectPropertiesArgsDict']]] = None,
                 security_properties: Optional[pulumi.Input[Union['ProjectSecurityPropertiesArgs', 'ProjectSecurityPropertiesArgsDict']]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 three_tier_model: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["comment"] = comment
            __props__.__dict__["default_quota"] = default_quota
            __props__.__dict__["ip_white_list"] = ip_white_list
            __props__.__dict__["is_logical"] = is_logical
            __props__.__dict__["product_type"] = product_type
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["properties"] = properties
            __props__.__dict__["security_properties"] = security_properties
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["three_tier_model"] = three_tier_model
            __props__.__dict__["create_time"] = None
            __props__.__dict__["owner"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["type"] = None
        super(Project, __self__).__init__(
            'alicloud:maxcompute/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            default_quota: Optional[pulumi.Input[_builtins.str]] = None,
            ip_white_list: Optional[pulumi.Input[Union['ProjectIpWhiteListArgs', 'ProjectIpWhiteListArgsDict']]] = None,
            is_logical: Optional[pulumi.Input[_builtins.str]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            product_type: Optional[pulumi.Input[_builtins.str]] = None,
            project_name: Optional[pulumi.Input[_builtins.str]] = None,
            properties: Optional[pulumi.Input[Union['ProjectPropertiesArgs', 'ProjectPropertiesArgsDict']]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_properties: Optional[pulumi.Input[Union['ProjectSecurityPropertiesArgs', 'ProjectSecurityPropertiesArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            three_tier_model: Optional[pulumi.Input[_builtins.bool]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Project description information. The length is 1 to 256 English or Chinese characters. The default value is blank.
        :param pulumi.Input[_builtins.str] create_time: Represents the creation time of the project
        :param pulumi.Input[_builtins.str] default_quota: Used to implement computing resource allocation. Valid values: subQuota Nickname
               If the calculation Quota is not specified, the default Quota resource will be consumed by jobs initiated by the project. For more information about computing resource usage, see [Computing Resource Usage](https://www.alibabacloud.com/help/en/maxcompute/user-guide/use-of-computing-resources).
        :param pulumi.Input[Union['ProjectIpWhiteListArgs', 'ProjectIpWhiteListArgsDict']] ip_white_list: IP whitelist See `ip_white_list` below.
        :param pulumi.Input[_builtins.str] is_logical: Whether to logically delete. Default value: true. Value: (ture/false),
               
               > **NOTE:** -- ture: In this case, the project status will be changed to' deleting' and completely deleted after 14 days. -- false: delete immediately, that is, completely deleted and permanently irrecoverable.
        :param pulumi.Input[_builtins.str] owner: Project owner
        :param pulumi.Input[_builtins.str] project_name: The name begins with a letter, containing letters, digits, and underscores (_). It can be 3 to 28 characters in length and is globally unique.
        :param pulumi.Input[Union['ProjectPropertiesArgs', 'ProjectPropertiesArgsDict']] properties: Project base attributes See `properties` below.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource
        :param pulumi.Input[Union['ProjectSecurityPropertiesArgs', 'ProjectSecurityPropertiesArgsDict']] security_properties: Security-related attributes See `security_properties` below.
        :param pulumi.Input[_builtins.str] status: The project status. Default value: AVAILABLE. Value: (AVAILABLE/READONLY/FROZEN/DELETING)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.bool] three_tier_model: Indicates whether data storage by schema is supported. Valid values:
        :param pulumi.Input[_builtins.str] type: Project type
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["default_quota"] = default_quota
        __props__.__dict__["ip_white_list"] = ip_white_list
        __props__.__dict__["is_logical"] = is_logical
        __props__.__dict__["owner"] = owner
        __props__.__dict__["product_type"] = product_type
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["properties"] = properties
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["security_properties"] = security_properties
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["three_tier_model"] = three_tier_model
        __props__.__dict__["type"] = type
        return Project(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Project description information. The length is 1 to 256 English or Chinese characters. The default value is blank.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Represents the creation time of the project
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="defaultQuota")
    def default_quota(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Used to implement computing resource allocation. Valid values: subQuota Nickname
        If the calculation Quota is not specified, the default Quota resource will be consumed by jobs initiated by the project. For more information about computing resource usage, see [Computing Resource Usage](https://www.alibabacloud.com/help/en/maxcompute/user-guide/use-of-computing-resources).
        """
        return pulumi.get(self, "default_quota")

    @_builtins.property
    @pulumi.getter(name="ipWhiteList")
    def ip_white_list(self) -> pulumi.Output[Optional['outputs.ProjectIpWhiteList']]:
        """
        IP whitelist See `ip_white_list` below.
        """
        return pulumi.get(self, "ip_white_list")

    @_builtins.property
    @pulumi.getter(name="isLogical")
    def is_logical(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to logically delete. Default value: true. Value: (ture/false),

        > **NOTE:** -- ture: In this case, the project status will be changed to' deleting' and completely deleted after 14 days. -- false: delete immediately, that is, completely deleted and permanently irrecoverable.
        """
        return pulumi.get(self, "is_logical")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        Project owner
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="productType")
    def product_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "product_type")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name begins with a letter, containing letters, digits, and underscores (_). It can be 3 to 28 characters in length and is globally unique.
        """
        return pulumi.get(self, "project_name")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output['outputs.ProjectProperties']:
        """
        Project base attributes See `properties` below.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the resource
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="securityProperties")
    def security_properties(self) -> pulumi.Output['outputs.ProjectSecurityProperties']:
        """
        Security-related attributes See `security_properties` below.
        """
        return pulumi.get(self, "security_properties")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The project status. Default value: AVAILABLE. Value: (AVAILABLE/READONLY/FROZEN/DELETING)
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="threeTierModel")
    def three_tier_model(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether data storage by schema is supported. Valid values:
        """
        return pulumi.get(self, "three_tier_model")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Project type
        """
        return pulumi.get(self, "type")

