# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServiceTopicArgs', 'ServiceTopic']

@pulumi.input_type
class ServiceTopicArgs:
    def __init__(__self__, *,
                 topic_name: pulumi.Input[_builtins.str],
                 enable_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_message_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ServiceTopic resource.
        :param pulumi.Input[_builtins.str] topic_name: The name of the topic.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.bool] enable_logging: Specifies whether to enable the logging feature. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.bool] logging_enabled: . Field `logging_enabled` has been deprecated from provider version 1.241.0. New field `enable_logging` instead.
        :param pulumi.Input[_builtins.int] max_message_size: The maximum length of the message that is sent to the topic. Default value: `65536`. Valid values: `1024` to `65536`. Unit: bytes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "topic_name", topic_name)
        if enable_logging is not None:
            pulumi.set(__self__, "enable_logging", enable_logging)
        if logging_enabled is not None:
            warnings.warn("""Field `logging_enabled` has been deprecated from provider version 1.241.0. New field `enable_logging` instead.""", DeprecationWarning)
            pulumi.log.warn("""logging_enabled is deprecated: Field `logging_enabled` has been deprecated from provider version 1.241.0. New field `enable_logging` instead.""")
        if logging_enabled is not None:
            pulumi.set(__self__, "logging_enabled", logging_enabled)
        if max_message_size is not None:
            pulumi.set(__self__, "max_message_size", max_message_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the topic.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "topic_name")

    @topic_name.setter
    def topic_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "topic_name", value)

    @_builtins.property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the logging feature. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_logging")

    @enable_logging.setter
    def enable_logging(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_logging", value)

    @_builtins.property
    @pulumi.getter(name="loggingEnabled")
    @_utilities.deprecated("""Field `logging_enabled` has been deprecated from provider version 1.241.0. New field `enable_logging` instead.""")
    def logging_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        . Field `logging_enabled` has been deprecated from provider version 1.241.0. New field `enable_logging` instead.
        """
        return pulumi.get(self, "logging_enabled")

    @logging_enabled.setter
    def logging_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "logging_enabled", value)

    @_builtins.property
    @pulumi.getter(name="maxMessageSize")
    def max_message_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum length of the message that is sent to the topic. Default value: `65536`. Valid values: `1024` to `65536`. Unit: bytes.
        """
        return pulumi.get(self, "max_message_size")

    @max_message_size.setter
    def max_message_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_message_size", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ServiceTopicState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_message_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 topic_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceTopic resources.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.241.0) The time when the topic was created.
        :param pulumi.Input[_builtins.bool] enable_logging: Specifies whether to enable the logging feature. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.bool] logging_enabled: . Field `logging_enabled` has been deprecated from provider version 1.241.0. New field `enable_logging` instead.
        :param pulumi.Input[_builtins.int] max_message_size: The maximum length of the message that is sent to the topic. Default value: `65536`. Valid values: `1024` to `65536`. Unit: bytes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] topic_name: The name of the topic.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if enable_logging is not None:
            pulumi.set(__self__, "enable_logging", enable_logging)
        if logging_enabled is not None:
            warnings.warn("""Field `logging_enabled` has been deprecated from provider version 1.241.0. New field `enable_logging` instead.""", DeprecationWarning)
            pulumi.log.warn("""logging_enabled is deprecated: Field `logging_enabled` has been deprecated from provider version 1.241.0. New field `enable_logging` instead.""")
        if logging_enabled is not None:
            pulumi.set(__self__, "logging_enabled", logging_enabled)
        if max_message_size is not None:
            pulumi.set(__self__, "max_message_size", max_message_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if topic_name is not None:
            pulumi.set(__self__, "topic_name", topic_name)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.241.0) The time when the topic was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the logging feature. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_logging")

    @enable_logging.setter
    def enable_logging(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_logging", value)

    @_builtins.property
    @pulumi.getter(name="loggingEnabled")
    @_utilities.deprecated("""Field `logging_enabled` has been deprecated from provider version 1.241.0. New field `enable_logging` instead.""")
    def logging_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        . Field `logging_enabled` has been deprecated from provider version 1.241.0. New field `enable_logging` instead.
        """
        return pulumi.get(self, "logging_enabled")

    @logging_enabled.setter
    def logging_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "logging_enabled", value)

    @_builtins.property
    @pulumi.getter(name="maxMessageSize")
    def max_message_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum length of the message that is sent to the topic. Default value: `65536`. Valid values: `1024` to `65536`. Unit: bytes.
        """
        return pulumi.get(self, "max_message_size")

    @max_message_size.setter
    def max_message_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_message_size", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the topic.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "topic_name")

    @topic_name.setter
    def topic_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic_name", value)


@pulumi.type_token("alicloud:message/serviceTopic:ServiceTopic")
class ServiceTopic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_message_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 topic_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Message Service Topic resource.

        For information about Message Service Topic and how to use it, see [What is Topic](https://www.alibabacloud.com/help/en/message-service/latest/createtopic).

        > **NOTE:** Available since v1.188.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.message.ServiceTopic("default",
            topic_name=name,
            max_message_size=16888,
            enable_logging=True)
        ```

        ## Import

        Message Service Topic can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:message/serviceTopic:ServiceTopic example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enable_logging: Specifies whether to enable the logging feature. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.bool] logging_enabled: . Field `logging_enabled` has been deprecated from provider version 1.241.0. New field `enable_logging` instead.
        :param pulumi.Input[_builtins.int] max_message_size: The maximum length of the message that is sent to the topic. Default value: `65536`. Valid values: `1024` to `65536`. Unit: bytes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] topic_name: The name of the topic.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceTopicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Message Service Topic resource.

        For information about Message Service Topic and how to use it, see [What is Topic](https://www.alibabacloud.com/help/en/message-service/latest/createtopic).

        > **NOTE:** Available since v1.188.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.message.ServiceTopic("default",
            topic_name=name,
            max_message_size=16888,
            enable_logging=True)
        ```

        ## Import

        Message Service Topic can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:message/serviceTopic:ServiceTopic example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ServiceTopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceTopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_message_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 topic_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceTopicArgs.__new__(ServiceTopicArgs)

            __props__.__dict__["enable_logging"] = enable_logging
            __props__.__dict__["logging_enabled"] = logging_enabled
            __props__.__dict__["max_message_size"] = max_message_size
            __props__.__dict__["tags"] = tags
            if topic_name is None and not opts.urn:
                raise TypeError("Missing required property 'topic_name'")
            __props__.__dict__["topic_name"] = topic_name
            __props__.__dict__["create_time"] = None
        super(ServiceTopic, __self__).__init__(
            'alicloud:message/serviceTopic:ServiceTopic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            enable_logging: Optional[pulumi.Input[_builtins.bool]] = None,
            logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            max_message_size: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            topic_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServiceTopic':
        """
        Get an existing ServiceTopic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.241.0) The time when the topic was created.
        :param pulumi.Input[_builtins.bool] enable_logging: Specifies whether to enable the logging feature. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.bool] logging_enabled: . Field `logging_enabled` has been deprecated from provider version 1.241.0. New field `enable_logging` instead.
        :param pulumi.Input[_builtins.int] max_message_size: The maximum length of the message that is sent to the topic. Default value: `65536`. Valid values: `1024` to `65536`. Unit: bytes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] topic_name: The name of the topic.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceTopicState.__new__(_ServiceTopicState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["enable_logging"] = enable_logging
        __props__.__dict__["logging_enabled"] = logging_enabled
        __props__.__dict__["max_message_size"] = max_message_size
        __props__.__dict__["tags"] = tags
        __props__.__dict__["topic_name"] = topic_name
        return ServiceTopic(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.241.0) The time when the topic was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable the logging feature. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_logging")

    @_builtins.property
    @pulumi.getter(name="loggingEnabled")
    @_utilities.deprecated("""Field `logging_enabled` has been deprecated from provider version 1.241.0. New field `enable_logging` instead.""")
    def logging_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        . Field `logging_enabled` has been deprecated from provider version 1.241.0. New field `enable_logging` instead.
        """
        return pulumi.get(self, "logging_enabled")

    @_builtins.property
    @pulumi.getter(name="maxMessageSize")
    def max_message_size(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum length of the message that is sent to the topic. Default value: `65536`. Valid values: `1024` to `65536`. Unit: bytes.
        """
        return pulumi.get(self, "max_message_size")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the topic.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "topic_name")

