# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MountTargetArgs', 'MountTarget']

@pulumi.input_type
class MountTargetArgs:
    def __init__(__self__, *,
                 file_system_id: pulumi.Input[_builtins.str],
                 access_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dual_stack: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MountTarget resource.
        :param pulumi.Input[_builtins.str] file_system_id: The ID of the file system.
        :param pulumi.Input[_builtins.str] access_group_name: The name of the permission group.
        :param pulumi.Input[_builtins.bool] dual_stack: Whether to create an IPv6 mount point.
               
               Value:
               - true: create
               - false (default): not created
               
               > **NOTE:**  currently, only extreme NAS supports IPv6 function in various regions in mainland China, and IPv6 function needs to be turned on for this file system.
        :param pulumi.Input[_builtins.str] network_type: Network type.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group.
        :param pulumi.Input[_builtins.str] status: The current status of the Mount point, including Active and Inactive, can be used to mount the file system only when the status is Active.
        :param pulumi.Input[_builtins.str] vpc_id: VPC ID.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the switch.
        """
        pulumi.set(__self__, "file_system_id", file_system_id)
        if access_group_name is not None:
            pulumi.set(__self__, "access_group_name", access_group_name)
        if dual_stack is not None:
            pulumi.set(__self__, "dual_stack", dual_stack)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "file_system_id", value)

    @_builtins.property
    @pulumi.getter(name="accessGroupName")
    def access_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the permission group.
        """
        return pulumi.get(self, "access_group_name")

    @access_group_name.setter
    def access_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_group_name", value)

    @_builtins.property
    @pulumi.getter(name="dualStack")
    def dual_stack(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create an IPv6 mount point.

        Value:
        - true: create
        - false (default): not created

        > **NOTE:**  currently, only extreme NAS supports IPv6 function in various regions in mainland China, and IPv6 function needs to be turned on for this file system.
        """
        return pulumi.get(self, "dual_stack")

    @dual_stack.setter
    def dual_stack(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dual_stack", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network type.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the Mount point, including Active and Inactive, can be used to mount the file system only when the status is Active.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the switch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.input_type
class _MountTargetState:
    def __init__(__self__, *,
                 access_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dual_stack: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_target_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MountTarget resources.
        :param pulumi.Input[_builtins.str] access_group_name: The name of the permission group.
        :param pulumi.Input[_builtins.bool] dual_stack: Whether to create an IPv6 mount point.
               
               Value:
               - true: create
               - false (default): not created
               
               > **NOTE:**  currently, only extreme NAS supports IPv6 function in various regions in mainland China, and IPv6 function needs to be turned on for this file system.
        :param pulumi.Input[_builtins.str] file_system_id: The ID of the file system.
        :param pulumi.Input[_builtins.str] mount_target_domain: The domain name of the Mount point.
        :param pulumi.Input[_builtins.str] network_type: Network type.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group.
        :param pulumi.Input[_builtins.str] status: The current status of the Mount point, including Active and Inactive, can be used to mount the file system only when the status is Active.
        :param pulumi.Input[_builtins.str] vpc_id: VPC ID.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the switch.
        """
        if access_group_name is not None:
            pulumi.set(__self__, "access_group_name", access_group_name)
        if dual_stack is not None:
            pulumi.set(__self__, "dual_stack", dual_stack)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if mount_target_domain is not None:
            pulumi.set(__self__, "mount_target_domain", mount_target_domain)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="accessGroupName")
    def access_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the permission group.
        """
        return pulumi.get(self, "access_group_name")

    @access_group_name.setter
    def access_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_group_name", value)

    @_builtins.property
    @pulumi.getter(name="dualStack")
    def dual_stack(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create an IPv6 mount point.

        Value:
        - true: create
        - false (default): not created

        > **NOTE:**  currently, only extreme NAS supports IPv6 function in various regions in mainland China, and IPv6 function needs to be turned on for this file system.
        """
        return pulumi.get(self, "dual_stack")

    @dual_stack.setter
    def dual_stack(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dual_stack", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_system_id", value)

    @_builtins.property
    @pulumi.getter(name="mountTargetDomain")
    def mount_target_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name of the Mount point.
        """
        return pulumi.get(self, "mount_target_domain")

    @mount_target_domain.setter
    def mount_target_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount_target_domain", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network type.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the Mount point, including Active and Inactive, can be used to mount the file system only when the status is Active.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the switch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:nas/mountTarget:MountTarget")
class MountTarget(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dual_stack: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a File Storage (NAS) Mount Target resource.

        File system mount point.

        For information about File Storage (NAS) Mount Target and how to use it, see [What is Mount Target](https://www.alibabacloud.com/help/en/doc-detail/27531.htm).

        > **NOTE:** Available since v1.34.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.nas.get_zones(file_system_type="extreme")
        count_size = len(default.zones)
        zone_id = count_size.apply(lambda count_size: default.zones[count_size - 1]).apply(lambda obj: obj.zone_id)
        example = alicloud.vpc.Network("example",
            vpc_name="terraform-example",
            cidr_block="172.17.3.0/24")
        example_switch = alicloud.vpc.Switch("example",
            vswitch_name=example.vpc_name,
            cidr_block=example.cidr_block,
            vpc_id=example.id,
            zone_id=zone_id)
        example_file_system = alicloud.nas.FileSystem("example",
            protocol_type="NFS",
            storage_type="advance",
            file_system_type="extreme",
            capacity=100,
            zone_id=zone_id)
        example_access_group = alicloud.nas.AccessGroup("example",
            access_group_name="access_group_xxx",
            access_group_type="Vpc",
            description="test_access_group",
            file_system_type="extreme")
        example_mount_target = alicloud.nas.MountTarget("example",
            file_system_id=example_file_system.id,
            access_group_name=example_access_group.access_group_name,
            vswitch_id=example_switch.id,
            vpc_id=example.id,
            network_type=example_access_group.access_group_type)
        ```

        ## Import

        File Storage (NAS) Mount Target can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nas/mountTarget:MountTarget example <file_system_id>:<mount_target_domain>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_group_name: The name of the permission group.
        :param pulumi.Input[_builtins.bool] dual_stack: Whether to create an IPv6 mount point.
               
               Value:
               - true: create
               - false (default): not created
               
               > **NOTE:**  currently, only extreme NAS supports IPv6 function in various regions in mainland China, and IPv6 function needs to be turned on for this file system.
        :param pulumi.Input[_builtins.str] file_system_id: The ID of the file system.
        :param pulumi.Input[_builtins.str] network_type: Network type.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group.
        :param pulumi.Input[_builtins.str] status: The current status of the Mount point, including Active and Inactive, can be used to mount the file system only when the status is Active.
        :param pulumi.Input[_builtins.str] vpc_id: VPC ID.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the switch.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MountTargetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a File Storage (NAS) Mount Target resource.

        File system mount point.

        For information about File Storage (NAS) Mount Target and how to use it, see [What is Mount Target](https://www.alibabacloud.com/help/en/doc-detail/27531.htm).

        > **NOTE:** Available since v1.34.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.nas.get_zones(file_system_type="extreme")
        count_size = len(default.zones)
        zone_id = count_size.apply(lambda count_size: default.zones[count_size - 1]).apply(lambda obj: obj.zone_id)
        example = alicloud.vpc.Network("example",
            vpc_name="terraform-example",
            cidr_block="172.17.3.0/24")
        example_switch = alicloud.vpc.Switch("example",
            vswitch_name=example.vpc_name,
            cidr_block=example.cidr_block,
            vpc_id=example.id,
            zone_id=zone_id)
        example_file_system = alicloud.nas.FileSystem("example",
            protocol_type="NFS",
            storage_type="advance",
            file_system_type="extreme",
            capacity=100,
            zone_id=zone_id)
        example_access_group = alicloud.nas.AccessGroup("example",
            access_group_name="access_group_xxx",
            access_group_type="Vpc",
            description="test_access_group",
            file_system_type="extreme")
        example_mount_target = alicloud.nas.MountTarget("example",
            file_system_id=example_file_system.id,
            access_group_name=example_access_group.access_group_name,
            vswitch_id=example_switch.id,
            vpc_id=example.id,
            network_type=example_access_group.access_group_type)
        ```

        ## Import

        File Storage (NAS) Mount Target can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nas/mountTarget:MountTarget example <file_system_id>:<mount_target_domain>
        ```

        :param str resource_name: The name of the resource.
        :param MountTargetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MountTargetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dual_stack: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MountTargetArgs.__new__(MountTargetArgs)

            __props__.__dict__["access_group_name"] = access_group_name
            __props__.__dict__["dual_stack"] = dual_stack
            if file_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_id'")
            __props__.__dict__["file_system_id"] = file_system_id
            __props__.__dict__["network_type"] = network_type
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["status"] = status
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["mount_target_domain"] = None
        super(MountTarget, __self__).__init__(
            'alicloud:nas/mountTarget:MountTarget',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            dual_stack: Optional[pulumi.Input[_builtins.bool]] = None,
            file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
            mount_target_domain: Optional[pulumi.Input[_builtins.str]] = None,
            network_type: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'MountTarget':
        """
        Get an existing MountTarget resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_group_name: The name of the permission group.
        :param pulumi.Input[_builtins.bool] dual_stack: Whether to create an IPv6 mount point.
               
               Value:
               - true: create
               - false (default): not created
               
               > **NOTE:**  currently, only extreme NAS supports IPv6 function in various regions in mainland China, and IPv6 function needs to be turned on for this file system.
        :param pulumi.Input[_builtins.str] file_system_id: The ID of the file system.
        :param pulumi.Input[_builtins.str] mount_target_domain: The domain name of the Mount point.
        :param pulumi.Input[_builtins.str] network_type: Network type.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group.
        :param pulumi.Input[_builtins.str] status: The current status of the Mount point, including Active and Inactive, can be used to mount the file system only when the status is Active.
        :param pulumi.Input[_builtins.str] vpc_id: VPC ID.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the switch.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MountTargetState.__new__(_MountTargetState)

        __props__.__dict__["access_group_name"] = access_group_name
        __props__.__dict__["dual_stack"] = dual_stack
        __props__.__dict__["file_system_id"] = file_system_id
        __props__.__dict__["mount_target_domain"] = mount_target_domain
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        return MountTarget(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessGroupName")
    def access_group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the permission group.
        """
        return pulumi.get(self, "access_group_name")

    @_builtins.property
    @pulumi.getter(name="dualStack")
    def dual_stack(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to create an IPv6 mount point.

        Value:
        - true: create
        - false (default): not created

        > **NOTE:**  currently, only extreme NAS supports IPv6 function in various regions in mainland China, and IPv6 function needs to be turned on for this file system.
        """
        return pulumi.get(self, "dual_stack")

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @_builtins.property
    @pulumi.getter(name="mountTargetDomain")
    def mount_target_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name of the Mount point.
        """
        return pulumi.get(self, "mount_target_domain")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[_builtins.str]:
        """
        Network type.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the Mount point, including Active and Inactive, can be used to mount the file system only when the status is Active.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the switch.
        """
        return pulumi.get(self, "vswitch_id")

