# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AccessPointPosixUser',
    'AccessPointRootPathPermission',
    'FileSystemNfsAcl',
    'FileSystemOptions',
    'FileSystemRecycleBin',
    'FileSystemSmbAcl',
    'GetAccessGroupsGroupResult',
    'GetAccessRulesRuleResult',
    'GetAutoSnapshotPoliciesPolicyResult',
    'GetDataFlowsFlowResult',
    'GetFileSystemsSystemResult',
    'GetFilesetsFilesetResult',
    'GetLifecyclePoliciesPolicyResult',
    'GetMountTargetsTargetResult',
    'GetSnapshotsSnapshotResult',
    'GetZonesZoneResult',
    'GetZonesZoneInstanceTypeResult',
]

@pulumi.output_type
class AccessPointPosixUser(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "posixGroupId":
            suggest = "posix_group_id"
        elif key == "posixSecondaryGroupIds":
            suggest = "posix_secondary_group_ids"
        elif key == "posixUserId":
            suggest = "posix_user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPointPosixUser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPointPosixUser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPointPosixUser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 posix_group_id: Optional[_builtins.int] = None,
                 posix_secondary_group_ids: Optional[Sequence[_builtins.int]] = None,
                 posix_user_id: Optional[_builtins.int] = None):
        """
        :param _builtins.int posix_group_id: The ID of the Posix user group.
        :param Sequence[_builtins.int] posix_secondary_group_ids: The ID of the second user group.
        :param _builtins.int posix_user_id: The Posix user ID.
        """
        if posix_group_id is not None:
            pulumi.set(__self__, "posix_group_id", posix_group_id)
        if posix_secondary_group_ids is not None:
            pulumi.set(__self__, "posix_secondary_group_ids", posix_secondary_group_ids)
        if posix_user_id is not None:
            pulumi.set(__self__, "posix_user_id", posix_user_id)

    @_builtins.property
    @pulumi.getter(name="posixGroupId")
    def posix_group_id(self) -> Optional[_builtins.int]:
        """
        The ID of the Posix user group.
        """
        return pulumi.get(self, "posix_group_id")

    @_builtins.property
    @pulumi.getter(name="posixSecondaryGroupIds")
    def posix_secondary_group_ids(self) -> Optional[Sequence[_builtins.int]]:
        """
        The ID of the second user group.
        """
        return pulumi.get(self, "posix_secondary_group_ids")

    @_builtins.property
    @pulumi.getter(name="posixUserId")
    def posix_user_id(self) -> Optional[_builtins.int]:
        """
        The Posix user ID.
        """
        return pulumi.get(self, "posix_user_id")


@pulumi.output_type
class AccessPointRootPathPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ownerGroupId":
            suggest = "owner_group_id"
        elif key == "ownerUserId":
            suggest = "owner_user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPointRootPathPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPointRootPathPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPointRootPathPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 owner_group_id: Optional[_builtins.int] = None,
                 owner_user_id: Optional[_builtins.int] = None,
                 permission: Optional[_builtins.str] = None):
        """
        :param _builtins.int owner_group_id: The ID of the primary user group.
        :param _builtins.int owner_user_id: The owner user ID.
        :param _builtins.str permission: The Portable Operating System Interface for UNIX (POSIX) permission.
        """
        if owner_group_id is not None:
            pulumi.set(__self__, "owner_group_id", owner_group_id)
        if owner_user_id is not None:
            pulumi.set(__self__, "owner_user_id", owner_user_id)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)

    @_builtins.property
    @pulumi.getter(name="ownerGroupId")
    def owner_group_id(self) -> Optional[_builtins.int]:
        """
        The ID of the primary user group.
        """
        return pulumi.get(self, "owner_group_id")

    @_builtins.property
    @pulumi.getter(name="ownerUserId")
    def owner_user_id(self) -> Optional[_builtins.int]:
        """
        The owner user ID.
        """
        return pulumi.get(self, "owner_user_id")

    @_builtins.property
    @pulumi.getter
    def permission(self) -> Optional[_builtins.str]:
        """
        The Portable Operating System Interface for UNIX (POSIX) permission.
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class FileSystemNfsAcl(dict):
    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enabled: Whether the NFS ACL function is enabled.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether the NFS ACL function is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class FileSystemOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableOplock":
            suggest = "enable_oplock"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_oplock: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enable_oplock: Whether to enable the OpLock function. Value:
               - true: On.
               - false: does not turn on.
               
               > **NOTE:**  Description Only file systems of the SMB protocol type are supported.
        """
        if enable_oplock is not None:
            pulumi.set(__self__, "enable_oplock", enable_oplock)

    @_builtins.property
    @pulumi.getter(name="enableOplock")
    def enable_oplock(self) -> Optional[_builtins.bool]:
        """
        Whether to enable the OpLock function. Value:
        - true: On.
        - false: does not turn on.

        > **NOTE:**  Description Only file systems of the SMB protocol type are supported.
        """
        return pulumi.get(self, "enable_oplock")


@pulumi.output_type
class FileSystemRecycleBin(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableTime":
            suggest = "enable_time"
        elif key == "reservedDays":
            suggest = "reserved_days"
        elif key == "secondarySize":
            suggest = "secondary_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemRecycleBin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemRecycleBin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemRecycleBin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_time: Optional[_builtins.str] = None,
                 reserved_days: Optional[_builtins.int] = None,
                 secondary_size: Optional[_builtins.int] = None,
                 size: Optional[_builtins.int] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str enable_time: Recycle Bin open time
        :param _builtins.int reserved_days: Retention time of files in the Recycle Bin. Unit: days.
        :param _builtins.int secondary_size: Amount of low-frequency data stored in the recycle bin. Unit: Byte.
        :param _builtins.int size: The amount of files stored in the Recycle Bin. Unit: Byte.
        :param _builtins.str status: Recycle Bin Status
        """
        if enable_time is not None:
            pulumi.set(__self__, "enable_time", enable_time)
        if reserved_days is not None:
            pulumi.set(__self__, "reserved_days", reserved_days)
        if secondary_size is not None:
            pulumi.set(__self__, "secondary_size", secondary_size)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="enableTime")
    def enable_time(self) -> Optional[_builtins.str]:
        """
        Recycle Bin open time
        """
        return pulumi.get(self, "enable_time")

    @_builtins.property
    @pulumi.getter(name="reservedDays")
    def reserved_days(self) -> Optional[_builtins.int]:
        """
        Retention time of files in the Recycle Bin. Unit: days.
        """
        return pulumi.get(self, "reserved_days")

    @_builtins.property
    @pulumi.getter(name="secondarySize")
    def secondary_size(self) -> Optional[_builtins.int]:
        """
        Amount of low-frequency data stored in the recycle bin. Unit: Byte.
        """
        return pulumi.get(self, "secondary_size")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        The amount of files stored in the Recycle Bin. Unit: Byte.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Recycle Bin Status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class FileSystemSmbAcl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableAnonymousAccess":
            suggest = "enable_anonymous_access"
        elif key == "encryptData":
            suggest = "encrypt_data"
        elif key == "homeDirPath":
            suggest = "home_dir_path"
        elif key == "rejectUnencryptedAccess":
            suggest = "reject_unencrypted_access"
        elif key == "superAdminSid":
            suggest = "super_admin_sid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemSmbAcl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemSmbAcl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemSmbAcl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_anonymous_access: Optional[_builtins.bool] = None,
                 enabled: Optional[_builtins.bool] = None,
                 encrypt_data: Optional[_builtins.bool] = None,
                 home_dir_path: Optional[_builtins.str] = None,
                 reject_unencrypted_access: Optional[_builtins.bool] = None,
                 super_admin_sid: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enable_anonymous_access: Whether to allow anonymous access.
               - true: Allow anonymous access.
               - false (default): Anonymous access is not allowed.
        :param _builtins.bool enabled: Whether SMB ACL is enabled
        :param _builtins.bool encrypt_data: Whether transmission encryption is enabled.
               - true: Enables encryption in transit.
               - false (default): Transport encryption is not enabled.
        :param _builtins.str home_dir_path: The user directory home path for each user. The file path format is as follows:
               - A forward slash (/) or backslash (\\) as a separator.
               - Each paragraph cannot contain ":|? *.
               - The length of each segment ranges from 0 to 255.
               - The total length range is 0~32767.
               
               For example, if the user directory is/home, the file system will automatically create A directory of/home/A when user A logs in. Skip if/home/A already exists.
               
               > **NOTE:**  Explain that user A needs to have the permission to create A directory, otherwise the/home/A directory cannot be created.
        :param _builtins.bool reject_unencrypted_access: Whether to reject non-encrypted clients.
               - true: Deny non-encrypted clients.
               - false (default): Non-encrypted clients are not rejected.
        :param _builtins.str super_admin_sid: The ID of the Super User. The ID rules are as follows:
               - Must start with S and no other letters can appear after the S at the beginning.
               - At least three dashes (-) apart.
               
               Such as S-1-5-22 or S-1-5-22-23.
        """
        if enable_anonymous_access is not None:
            pulumi.set(__self__, "enable_anonymous_access", enable_anonymous_access)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if encrypt_data is not None:
            pulumi.set(__self__, "encrypt_data", encrypt_data)
        if home_dir_path is not None:
            pulumi.set(__self__, "home_dir_path", home_dir_path)
        if reject_unencrypted_access is not None:
            pulumi.set(__self__, "reject_unencrypted_access", reject_unencrypted_access)
        if super_admin_sid is not None:
            pulumi.set(__self__, "super_admin_sid", super_admin_sid)

    @_builtins.property
    @pulumi.getter(name="enableAnonymousAccess")
    def enable_anonymous_access(self) -> Optional[_builtins.bool]:
        """
        Whether to allow anonymous access.
        - true: Allow anonymous access.
        - false (default): Anonymous access is not allowed.
        """
        return pulumi.get(self, "enable_anonymous_access")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether SMB ACL is enabled
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="encryptData")
    def encrypt_data(self) -> Optional[_builtins.bool]:
        """
        Whether transmission encryption is enabled.
        - true: Enables encryption in transit.
        - false (default): Transport encryption is not enabled.
        """
        return pulumi.get(self, "encrypt_data")

    @_builtins.property
    @pulumi.getter(name="homeDirPath")
    def home_dir_path(self) -> Optional[_builtins.str]:
        """
        The user directory home path for each user. The file path format is as follows:
        - A forward slash (/) or backslash (\\) as a separator.
        - Each paragraph cannot contain ":|? *.
        - The length of each segment ranges from 0 to 255.
        - The total length range is 0~32767.

        For example, if the user directory is/home, the file system will automatically create A directory of/home/A when user A logs in. Skip if/home/A already exists.

        > **NOTE:**  Explain that user A needs to have the permission to create A directory, otherwise the/home/A directory cannot be created.
        """
        return pulumi.get(self, "home_dir_path")

    @_builtins.property
    @pulumi.getter(name="rejectUnencryptedAccess")
    def reject_unencrypted_access(self) -> Optional[_builtins.bool]:
        """
        Whether to reject non-encrypted clients.
        - true: Deny non-encrypted clients.
        - false (default): Non-encrypted clients are not rejected.
        """
        return pulumi.get(self, "reject_unencrypted_access")

    @_builtins.property
    @pulumi.getter(name="superAdminSid")
    def super_admin_sid(self) -> Optional[_builtins.str]:
        """
        The ID of the Super User. The ID rules are as follows:
        - Must start with S and no other letters can appear after the S at the beginning.
        - At least three dashes (-) apart.

        Such as S-1-5-22 or S-1-5-22-23.
        """
        return pulumi.get(self, "super_admin_sid")


@pulumi.output_type
class GetAccessGroupsGroupResult(dict):
    def __init__(__self__, *,
                 access_group_name: _builtins.str,
                 access_group_type: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 mount_target_count: _builtins.int,
                 rule_count: _builtins.int,
                 type: _builtins.str):
        """
        :param _builtins.str access_group_name: The name of access group.
        :param _builtins.str access_group_type: Filter results by a specific AccessGroupType.
        :param _builtins.str description: Filter results by a specific Description.
        :param _builtins.str id: This ID of this AccessGroup. It is formatted to ``<access_group_id>:<file_system_type>``. Before version 1.95.0, the value is `access_group_name`.
        :param _builtins.int mount_target_count: MountTargetCount block of the AccessGroup
        :param _builtins.int rule_count: RuleCount of the AccessGroup.
        :param _builtins.str type: Field `type` has been deprecated from version 1.95.0. Use `access_group_type` instead.
        """
        pulumi.set(__self__, "access_group_name", access_group_name)
        pulumi.set(__self__, "access_group_type", access_group_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mount_target_count", mount_target_count)
        pulumi.set(__self__, "rule_count", rule_count)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accessGroupName")
    def access_group_name(self) -> _builtins.str:
        """
        The name of access group.
        """
        return pulumi.get(self, "access_group_name")

    @_builtins.property
    @pulumi.getter(name="accessGroupType")
    def access_group_type(self) -> _builtins.str:
        """
        Filter results by a specific AccessGroupType.
        """
        return pulumi.get(self, "access_group_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Filter results by a specific Description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        This ID of this AccessGroup. It is formatted to ``<access_group_id>:<file_system_type>``. Before version 1.95.0, the value is `access_group_name`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="mountTargetCount")
    def mount_target_count(self) -> _builtins.int:
        """
        MountTargetCount block of the AccessGroup
        """
        return pulumi.get(self, "mount_target_count")

    @_builtins.property
    @pulumi.getter(name="ruleCount")
    def rule_count(self) -> _builtins.int:
        """
        RuleCount of the AccessGroup.
        """
        return pulumi.get(self, "rule_count")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Field `type` has been deprecated from version 1.95.0. Use `access_group_type` instead.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAccessRulesRuleResult(dict):
    def __init__(__self__, *,
                 access_rule_id: _builtins.str,
                 priority: _builtins.int,
                 rw_access: _builtins.str,
                 source_cidr_ip: _builtins.str,
                 user_access: _builtins.str):
        """
        :param _builtins.str access_rule_id: AccessRuleId of the AccessRule.
        :param _builtins.int priority: Priority of the AccessRule.
        :param _builtins.str rw_access: Filter results by a specific RWAccess.
        :param _builtins.str source_cidr_ip: Filter results by a specific SourceCidrIp.
        :param _builtins.str user_access: Filter results by a specific UserAccess.
        """
        pulumi.set(__self__, "access_rule_id", access_rule_id)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rw_access", rw_access)
        pulumi.set(__self__, "source_cidr_ip", source_cidr_ip)
        pulumi.set(__self__, "user_access", user_access)

    @_builtins.property
    @pulumi.getter(name="accessRuleId")
    def access_rule_id(self) -> _builtins.str:
        """
        AccessRuleId of the AccessRule.
        """
        return pulumi.get(self, "access_rule_id")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Priority of the AccessRule.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="rwAccess")
    def rw_access(self) -> _builtins.str:
        """
        Filter results by a specific RWAccess.
        """
        return pulumi.get(self, "rw_access")

    @_builtins.property
    @pulumi.getter(name="sourceCidrIp")
    def source_cidr_ip(self) -> _builtins.str:
        """
        Filter results by a specific SourceCidrIp.
        """
        return pulumi.get(self, "source_cidr_ip")

    @_builtins.property
    @pulumi.getter(name="userAccess")
    def user_access(self) -> _builtins.str:
        """
        Filter results by a specific UserAccess.
        """
        return pulumi.get(self, "user_access")


@pulumi.output_type
class GetAutoSnapshotPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 auto_snapshot_policy_id: _builtins.str,
                 auto_snapshot_policy_name: _builtins.str,
                 create_time: _builtins.str,
                 file_system_nums: _builtins.int,
                 id: _builtins.str,
                 repeat_weekdays: Sequence[_builtins.str],
                 retention_days: _builtins.int,
                 status: _builtins.str,
                 time_points: Sequence[_builtins.str]):
        """
        :param _builtins.str auto_snapshot_policy_id: The ID of the automatic snapshot policy.
        :param _builtins.str auto_snapshot_policy_name: The name of the automatic snapshot policy.
        :param _builtins.str create_time: The time when the automatic snapshot policy was created.
        :param _builtins.int file_system_nums: The number of file systems to which the automatic snapshot policy applies.
        :param _builtins.str id: ID of the Auto Snapshot Policy.
        :param Sequence[_builtins.str] repeat_weekdays: The day on which an auto snapshot was created.
        :param _builtins.int retention_days: The number of days for which you want to retain auto snapshots.
        :param _builtins.str status: The status of the automatic snapshot policy. Valid values: `Creating`, `Available`.
        :param Sequence[_builtins.str] time_points: The point in time at which an auto snapshot was created. Unit: hours.
        """
        pulumi.set(__self__, "auto_snapshot_policy_id", auto_snapshot_policy_id)
        pulumi.set(__self__, "auto_snapshot_policy_name", auto_snapshot_policy_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "file_system_nums", file_system_nums)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "repeat_weekdays", repeat_weekdays)
        pulumi.set(__self__, "retention_days", retention_days)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "time_points", time_points)

    @_builtins.property
    @pulumi.getter(name="autoSnapshotPolicyId")
    def auto_snapshot_policy_id(self) -> _builtins.str:
        """
        The ID of the automatic snapshot policy.
        """
        return pulumi.get(self, "auto_snapshot_policy_id")

    @_builtins.property
    @pulumi.getter(name="autoSnapshotPolicyName")
    def auto_snapshot_policy_name(self) -> _builtins.str:
        """
        The name of the automatic snapshot policy.
        """
        return pulumi.get(self, "auto_snapshot_policy_name")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the automatic snapshot policy was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="fileSystemNums")
    def file_system_nums(self) -> _builtins.int:
        """
        The number of file systems to which the automatic snapshot policy applies.
        """
        return pulumi.get(self, "file_system_nums")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the Auto Snapshot Policy.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="repeatWeekdays")
    def repeat_weekdays(self) -> Sequence[_builtins.str]:
        """
        The day on which an auto snapshot was created.
        """
        return pulumi.get(self, "repeat_weekdays")

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> _builtins.int:
        """
        The number of days for which you want to retain auto snapshots.
        """
        return pulumi.get(self, "retention_days")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the automatic snapshot policy. Valid values: `Creating`, `Available`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="timePoints")
    def time_points(self) -> Sequence[_builtins.str]:
        """
        The point in time at which an auto snapshot was created. Unit: hours.
        """
        return pulumi.get(self, "time_points")


@pulumi.output_type
class GetDataFlowsFlowResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 data_flow_id: _builtins.str,
                 description: _builtins.str,
                 error_message: _builtins.str,
                 file_system_id: _builtins.str,
                 file_system_path: _builtins.str,
                 fset_description: _builtins.str,
                 fset_id: _builtins.str,
                 id: _builtins.str,
                 source_security_type: _builtins.str,
                 source_storage: _builtins.str,
                 status: _builtins.str,
                 throughput: _builtins.int):
        """
        :param _builtins.str create_time: The time when Fileset was created. Executing the ISO8601 standard means that the return format is: 'yyyy-MM-ddTHH:mm:ssZ'.
        :param _builtins.str data_flow_id: The ID of the Data Flow.
        :param _builtins.str description: The Description of data flow.
        :param _builtins.str error_message: Error message.
        :param _builtins.str file_system_id: The ID of the file system.
        :param _builtins.str file_system_path: The path of Fileset in the CPFS file system.
        :param _builtins.str fset_description: Description of automatic update.
        :param _builtins.str fset_id: The ID of the Fileset.
        :param _builtins.str id: The resource ID of the data flow. The value formats as `<file_system_id>:<data_flow_id>`.
        :param _builtins.str source_security_type: The security protection type of the source storage.
        :param _builtins.str source_storage: The access path of the source store. Format: `<storage type>://<path>`.
        :param _builtins.str status: The status of the Data flow.
        :param _builtins.int throughput: The maximum transmission bandwidth of data flow, unit: `MB/s`.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "data_flow_id", data_flow_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "file_system_path", file_system_path)
        pulumi.set(__self__, "fset_description", fset_description)
        pulumi.set(__self__, "fset_id", fset_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "source_security_type", source_security_type)
        pulumi.set(__self__, "source_storage", source_storage)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "throughput", throughput)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when Fileset was created. Executing the ISO8601 standard means that the return format is: 'yyyy-MM-ddTHH:mm:ssZ'.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dataFlowId")
    def data_flow_id(self) -> _builtins.str:
        """
        The ID of the Data Flow.
        """
        return pulumi.get(self, "data_flow_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The Description of data flow.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> _builtins.str:
        """
        Error message.
        """
        return pulumi.get(self, "error_message")

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> _builtins.str:
        """
        The ID of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @_builtins.property
    @pulumi.getter(name="fileSystemPath")
    def file_system_path(self) -> _builtins.str:
        """
        The path of Fileset in the CPFS file system.
        """
        return pulumi.get(self, "file_system_path")

    @_builtins.property
    @pulumi.getter(name="fsetDescription")
    def fset_description(self) -> _builtins.str:
        """
        Description of automatic update.
        """
        return pulumi.get(self, "fset_description")

    @_builtins.property
    @pulumi.getter(name="fsetId")
    def fset_id(self) -> _builtins.str:
        """
        The ID of the Fileset.
        """
        return pulumi.get(self, "fset_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The resource ID of the data flow. The value formats as `<file_system_id>:<data_flow_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="sourceSecurityType")
    def source_security_type(self) -> _builtins.str:
        """
        The security protection type of the source storage.
        """
        return pulumi.get(self, "source_security_type")

    @_builtins.property
    @pulumi.getter(name="sourceStorage")
    def source_storage(self) -> _builtins.str:
        """
        The access path of the source store. Format: `<storage type>://<path>`.
        """
        return pulumi.get(self, "source_storage")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Data flow.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> _builtins.int:
        """
        The maximum transmission bandwidth of data flow, unit: `MB/s`.
        """
        return pulumi.get(self, "throughput")


@pulumi.output_type
class GetFileSystemsSystemResult(dict):
    def __init__(__self__, *,
                 capacity: _builtins.int,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 encrypt_type: _builtins.int,
                 file_system_type: _builtins.str,
                 id: _builtins.str,
                 kms_key_id: _builtins.str,
                 metered_size: _builtins.int,
                 protocol_type: _builtins.str,
                 region_id: _builtins.str,
                 storage_type: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.int capacity: (Optional, Available in v1.140.0+) The capacity of the file system.
        :param _builtins.str create_time: Time of creation.
        :param _builtins.str description: Description of the FileSystem.
        :param _builtins.int encrypt_type: (Optional, Available in v1.121.2+) Whether the file system is encrypted. 
               * Valid values:
        :param _builtins.str file_system_type: The type of the file system.
               Valid values:
               `standard` (Default),
               `extreme`.
        :param _builtins.str id: ID of the FileSystem.
        :param _builtins.str kms_key_id: (Optional, Available in v1.140.0+) The id of the KMS key.
        :param _builtins.int metered_size: MeteredSize of the FileSystem.
        :param _builtins.str protocol_type: The protocol type of the file system.
               Valid values:
               `NFS`,
               `SMB` (Available when the `file_system_type` is `standard`).
        :param _builtins.str region_id: ID of the region where the FileSystem is located.
        :param _builtins.str storage_type: The storage type of the file system.
               * Valid values:
               * `Performance` (Available when the `file_system_type` is `standard`)
               * `Capacity` (Available when the `file_system_type` is `standard`)
        :param _builtins.str zone_id: (Optional, Available in v1.140.0+) The id of the zone. Each region consists of multiple isolated locations known as zones. Each zone has an independent power supply and network.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "encrypt_type", encrypt_type)
        pulumi.set(__self__, "file_system_type", file_system_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "metered_size", metered_size)
        pulumi.set(__self__, "protocol_type", protocol_type)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "storage_type", storage_type)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> _builtins.int:
        """
        (Optional, Available in v1.140.0+) The capacity of the file system.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Time of creation.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the FileSystem.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="encryptType")
    def encrypt_type(self) -> _builtins.int:
        """
        (Optional, Available in v1.121.2+) Whether the file system is encrypted. 
        * Valid values:
        """
        return pulumi.get(self, "encrypt_type")

    @_builtins.property
    @pulumi.getter(name="fileSystemType")
    def file_system_type(self) -> _builtins.str:
        """
        The type of the file system.
        Valid values:
        `standard` (Default),
        `extreme`.
        """
        return pulumi.get(self, "file_system_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the FileSystem.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> _builtins.str:
        """
        (Optional, Available in v1.140.0+) The id of the KMS key.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="meteredSize")
    def metered_size(self) -> _builtins.int:
        """
        MeteredSize of the FileSystem.
        """
        return pulumi.get(self, "metered_size")

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> _builtins.str:
        """
        The protocol type of the file system.
        Valid values:
        `NFS`,
        `SMB` (Available when the `file_system_type` is `standard`).
        """
        return pulumi.get(self, "protocol_type")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        ID of the region where the FileSystem is located.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> _builtins.str:
        """
        The storage type of the file system.
        * Valid values:
        * `Performance` (Available when the `file_system_type` is `standard`)
        * `Capacity` (Available when the `file_system_type` is `standard`)
        """
        return pulumi.get(self, "storage_type")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        (Optional, Available in v1.140.0+) The id of the zone. Each region consists of multiple isolated locations known as zones. Each zone has an independent power supply and network.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetFilesetsFilesetResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 file_system_id: _builtins.str,
                 file_system_path: _builtins.str,
                 fileset_id: _builtins.str,
                 id: _builtins.str,
                 status: _builtins.str,
                 update_time: _builtins.str):
        """
        :param _builtins.str create_time: The time when Fileset was created.
        :param _builtins.str description: Description of Fileset.
        :param _builtins.str file_system_id: The ID of the file system.
        :param _builtins.str file_system_path: The path of Fileset.
        :param _builtins.str fileset_id: The first ID of the resource.
        :param _builtins.str id: The ID of the Fileset.
        :param _builtins.str status: The status of the fileset.
        :param _builtins.str update_time: The latest update time of Fileset.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "file_system_path", file_system_path)
        pulumi.set(__self__, "fileset_id", fileset_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when Fileset was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of Fileset.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> _builtins.str:
        """
        The ID of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @_builtins.property
    @pulumi.getter(name="fileSystemPath")
    def file_system_path(self) -> _builtins.str:
        """
        The path of Fileset.
        """
        return pulumi.get(self, "file_system_path")

    @_builtins.property
    @pulumi.getter(name="filesetId")
    def fileset_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "fileset_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Fileset.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the fileset.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The latest update time of Fileset.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GetLifecyclePoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 file_system_id: _builtins.str,
                 id: _builtins.str,
                 lifecycle_policy_name: _builtins.str,
                 lifecycle_rule_name: _builtins.str,
                 paths: Sequence[_builtins.str],
                 storage_type: _builtins.str):
        """
        :param _builtins.str create_time: The time when the lifecycle management policy was created.
        :param _builtins.str file_system_id: The ID of the file system.
        :param _builtins.str id: The ID of the Lifecycle Policy. Its value is same as Queue Name.
        :param _builtins.str lifecycle_policy_name: The name of the lifecycle management policy.
        :param _builtins.str lifecycle_rule_name: The rules in the lifecycle management policy.
        :param Sequence[_builtins.str] paths: The list of absolute paths for multiple directories. In this case, you can associate a lifecycle management policy with each directory.
        :param _builtins.str storage_type: The storage type of the data that is dumped to the IA storage medium.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_policy_name", lifecycle_policy_name)
        pulumi.set(__self__, "lifecycle_rule_name", lifecycle_rule_name)
        pulumi.set(__self__, "paths", paths)
        pulumi.set(__self__, "storage_type", storage_type)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the lifecycle management policy was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> _builtins.str:
        """
        The ID of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Lifecycle Policy. Its value is same as Queue Name.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecyclePolicyName")
    def lifecycle_policy_name(self) -> _builtins.str:
        """
        The name of the lifecycle management policy.
        """
        return pulumi.get(self, "lifecycle_policy_name")

    @_builtins.property
    @pulumi.getter(name="lifecycleRuleName")
    def lifecycle_rule_name(self) -> _builtins.str:
        """
        The rules in the lifecycle management policy.
        """
        return pulumi.get(self, "lifecycle_rule_name")

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Sequence[_builtins.str]:
        """
        The list of absolute paths for multiple directories. In this case, you can associate a lifecycle management policy with each directory.
        """
        return pulumi.get(self, "paths")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> _builtins.str:
        """
        The storage type of the data that is dumped to the IA storage medium.
        """
        return pulumi.get(self, "storage_type")


@pulumi.output_type
class GetMountTargetsTargetResult(dict):
    def __init__(__self__, *,
                 access_group_name: _builtins.str,
                 id: _builtins.str,
                 mount_target_domain: _builtins.str,
                 network_type: _builtins.str,
                 status: _builtins.str,
                 type: _builtins.str,
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str):
        """
        :param _builtins.str access_group_name: Filter results by a specific AccessGroupName.
        :param _builtins.str id: ID of the MountTargetDomain.
        :param _builtins.str mount_target_domain: Field `mount_target_domain` has been deprecated from provider version 1.53.0. New field `ids` replaces it.
        :param _builtins.str network_type: Filter results by a specific NetworkType.
        :param _builtins.str status: Filter results by the status of mount target. Valid values: `Active`, `Inactive` and `Pending`.
        :param _builtins.str type: Field `type` has been deprecated from provider version 1.95.0. New field `network_type` replaces it.
        :param _builtins.str vpc_id: Filter results by a specific VpcId.
        :param _builtins.str vswitch_id: Filter results by a specific VSwitchId.
        """
        pulumi.set(__self__, "access_group_name", access_group_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mount_target_domain", mount_target_domain)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="accessGroupName")
    def access_group_name(self) -> _builtins.str:
        """
        Filter results by a specific AccessGroupName.
        """
        return pulumi.get(self, "access_group_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the MountTargetDomain.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="mountTargetDomain")
    def mount_target_domain(self) -> _builtins.str:
        """
        Field `mount_target_domain` has been deprecated from provider version 1.53.0. New field `ids` replaces it.
        """
        return pulumi.get(self, "mount_target_domain")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        Filter results by a specific NetworkType.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Filter results by the status of mount target. Valid values: `Active`, `Inactive` and `Pending`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Field `type` has been deprecated from provider version 1.95.0. New field `network_type` replaces it.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        Filter results by a specific VpcId.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        Filter results by a specific VSwitchId.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetSnapshotsSnapshotResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 encrypt_type: _builtins.int,
                 id: _builtins.str,
                 progress: _builtins.str,
                 remain_time: _builtins.int,
                 retention_days: _builtins.int,
                 snapshot_id: _builtins.str,
                 snapshot_name: _builtins.str,
                 source_file_system_id: _builtins.str,
                 source_file_system_size: _builtins.str,
                 source_file_system_version: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str create_time: The creation time of the resource.
        :param _builtins.str description: The description of the snapshot.
        :param _builtins.int encrypt_type: The type of the encryption.
        :param _builtins.str id: The ID of the Snapshot.
        :param _builtins.str progress: The progress of the snapshot creation. The value of this parameter is expressed as a percentage.
        :param _builtins.int remain_time: The remaining time that is required to create the snapshot. Unit: seconds.
        :param _builtins.int retention_days: The retention period of the automatic snapshot. Unit: days.
        :param _builtins.str snapshot_id: The ID of the resource.
        :param _builtins.str snapshot_name: The name of the snapshot.
        :param _builtins.str source_file_system_id: The ID of the source file system.
        :param _builtins.str source_file_system_size: The capacity of the source file system. Unit: GiB.
        :param _builtins.str source_file_system_version: The version of the source file system.
        :param _builtins.str status: The status of the snapshot.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "encrypt_type", encrypt_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "progress", progress)
        pulumi.set(__self__, "remain_time", remain_time)
        pulumi.set(__self__, "retention_days", retention_days)
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        pulumi.set(__self__, "snapshot_name", snapshot_name)
        pulumi.set(__self__, "source_file_system_id", source_file_system_id)
        pulumi.set(__self__, "source_file_system_size", source_file_system_size)
        pulumi.set(__self__, "source_file_system_version", source_file_system_version)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the snapshot.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="encryptType")
    def encrypt_type(self) -> _builtins.int:
        """
        The type of the encryption.
        """
        return pulumi.get(self, "encrypt_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Snapshot.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def progress(self) -> _builtins.str:
        """
        The progress of the snapshot creation. The value of this parameter is expressed as a percentage.
        """
        return pulumi.get(self, "progress")

    @_builtins.property
    @pulumi.getter(name="remainTime")
    def remain_time(self) -> _builtins.int:
        """
        The remaining time that is required to create the snapshot. Unit: seconds.
        """
        return pulumi.get(self, "remain_time")

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> _builtins.int:
        """
        The retention period of the automatic snapshot. Unit: days.
        """
        return pulumi.get(self, "retention_days")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> _builtins.str:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> _builtins.str:
        """
        The name of the snapshot.
        """
        return pulumi.get(self, "snapshot_name")

    @_builtins.property
    @pulumi.getter(name="sourceFileSystemId")
    def source_file_system_id(self) -> _builtins.str:
        """
        The ID of the source file system.
        """
        return pulumi.get(self, "source_file_system_id")

    @_builtins.property
    @pulumi.getter(name="sourceFileSystemSize")
    def source_file_system_size(self) -> _builtins.str:
        """
        The capacity of the source file system. Unit: GiB.
        """
        return pulumi.get(self, "source_file_system_size")

    @_builtins.property
    @pulumi.getter(name="sourceFileSystemVersion")
    def source_file_system_version(self) -> _builtins.str:
        """
        The version of the source file system.
        """
        return pulumi.get(self, "source_file_system_version")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the snapshot.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 instance_types: Sequence['outputs.GetZonesZoneInstanceTypeResult'],
                 zone_id: _builtins.str):
        """
        :param Sequence['GetZonesZoneInstanceTypeArgs'] instance_types: A list of instance type information collection
        :param _builtins.str zone_id: String to filter results by zone id.
        """
        pulumi.set(__self__, "instance_types", instance_types)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Sequence['outputs.GetZonesZoneInstanceTypeResult']:
        """
        A list of instance type information collection
        """
        return pulumi.get(self, "instance_types")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        String to filter results by zone id.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetZonesZoneInstanceTypeResult(dict):
    def __init__(__self__, *,
                 protocol_type: _builtins.str,
                 storage_type: _builtins.str):
        """
        :param _builtins.str protocol_type: File transfer protocol type. Valid values:
        :param _builtins.str storage_type: The storage type of the nas zones. Valid values:
        """
        pulumi.set(__self__, "protocol_type", protocol_type)
        pulumi.set(__self__, "storage_type", storage_type)

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> _builtins.str:
        """
        File transfer protocol type. Valid values:
        """
        return pulumi.get(self, "protocol_type")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> _builtins.str:
        """
        The storage type of the nas zones. Valid values:
        """
        return pulumi.get(self, "storage_type")


