# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServerGroupsResult',
    'AwaitableGetServerGroupsResult',
    'get_server_groups',
    'get_server_groups_output',
]

@pulumi.output_type
class GetServerGroupsResult:
    """
    A collection of values returned by getServerGroups.
    """
    def __init__(__self__, groups=None, id=None, ids=None, name_regex=None, names=None, output_file=None, resource_group_id=None, server_group_names=None, server_group_type=None, status=None, tags=None):
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if server_group_names and not isinstance(server_group_names, list):
            raise TypeError("Expected argument 'server_group_names' to be a list")
        pulumi.set(__self__, "server_group_names", server_group_names)
        if server_group_type and not isinstance(server_group_type, str):
            raise TypeError("Expected argument 'server_group_type' to be a str")
        pulumi.set(__self__, "server_group_type", server_group_type)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetServerGroupsGroupResult']:
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="serverGroupNames")
    def server_group_names(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "server_group_names")

    @_builtins.property
    @pulumi.getter(name="serverGroupType")
    def server_group_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "server_group_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags")


class AwaitableGetServerGroupsResult(GetServerGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerGroupsResult(
            groups=self.groups,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            resource_group_id=self.resource_group_id,
            server_group_names=self.server_group_names,
            server_group_type=self.server_group_type,
            status=self.status,
            tags=self.tags)


def get_server_groups(ids: Optional[Sequence[_builtins.str]] = None,
                      name_regex: Optional[_builtins.str] = None,
                      output_file: Optional[_builtins.str] = None,
                      resource_group_id: Optional[_builtins.str] = None,
                      server_group_names: Optional[Sequence[_builtins.str]] = None,
                      server_group_type: Optional[_builtins.str] = None,
                      status: Optional[_builtins.str] = None,
                      tags: Optional[Mapping[str, _builtins.str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerGroupsResult:
    """
    This data source provides the Nlb Server Groups of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.186.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.nlb.get_server_groups()
    pulumi.export("nlbServerGroupId1", ids.groups[0].id)
    name_regex = alicloud.nlb.get_server_groups(name_regex="^my-ServerGroup")
    pulumi.export("nlbServerGroupId2", name_regex.groups[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Server Group IDs.
    :param _builtins.str name_regex: A regex string to filter results by Server Group name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The ID of the resource group to which the security group belongs.
    :param Sequence[_builtins.str] server_group_names: The names of the server groups to be queried.
    :param _builtins.str server_group_type: The type of the server group. Valid values: `Instance`, `Ip`.
    :param _builtins.str status: The status of the resource. Valid values: `Available`, `Configuring`, `Creating`.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['serverGroupNames'] = server_group_names
    __args__['serverGroupType'] = server_group_type
    __args__['status'] = status
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:nlb/getServerGroups:getServerGroups', __args__, opts=opts, typ=GetServerGroupsResult).value

    return AwaitableGetServerGroupsResult(
        groups=pulumi.get(__ret__, 'groups'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        server_group_names=pulumi.get(__ret__, 'server_group_names'),
        server_group_type=pulumi.get(__ret__, 'server_group_type'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_server_groups_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                             name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             server_group_names: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                             server_group_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServerGroupsResult]:
    """
    This data source provides the Nlb Server Groups of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.186.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.nlb.get_server_groups()
    pulumi.export("nlbServerGroupId1", ids.groups[0].id)
    name_regex = alicloud.nlb.get_server_groups(name_regex="^my-ServerGroup")
    pulumi.export("nlbServerGroupId2", name_regex.groups[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Server Group IDs.
    :param _builtins.str name_regex: A regex string to filter results by Server Group name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The ID of the resource group to which the security group belongs.
    :param Sequence[_builtins.str] server_group_names: The names of the server groups to be queried.
    :param _builtins.str server_group_type: The type of the server group. Valid values: `Instance`, `Ip`.
    :param _builtins.str status: The status of the resource. Valid values: `Available`, `Configuring`, `Creating`.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['serverGroupNames'] = server_group_names
    __args__['serverGroupType'] = server_group_type
    __args__['status'] = status
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:nlb/getServerGroups:getServerGroups', __args__, opts=opts, typ=GetServerGroupsResult)
    return __ret__.apply(lambda __response__: GetServerGroupsResult(
        groups=pulumi.get(__response__, 'groups'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        server_group_names=pulumi.get(__response__, 'server_group_names'),
        server_group_type=pulumi.get(__response__, 'server_group_type'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
