# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AppGroupOrder',
    'AppGroupQuota',
    'GetAppGroupsGroupResult',
    'GetAppGroupsGroupQuotaResult',
]

@pulumi.output_type
class AppGroupOrder(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoRenew":
            suggest = "auto_renew"
        elif key == "pricingCycle":
            suggest = "pricing_cycle"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppGroupOrder. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppGroupOrder.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppGroupOrder.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_renew: Optional[_builtins.bool] = None,
                 duration: Optional[_builtins.int] = None,
                 pricing_cycle: Optional[_builtins.str] = None):
        """
        :param _builtins.bool auto_renew: Whether to renew automatically. It only takes effect when the parameter payment_type takes the value `Subscription`.
        :param _builtins.int duration: Order cycle. The minimum value is not less than 0.
        :param _builtins.str pricing_cycle: Order cycle unit. Valid values: `Year` and `Month`.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[_builtins.bool]:
        """
        Whether to renew automatically. It only takes effect when the parameter payment_type takes the value `Subscription`.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[_builtins.int]:
        """
        Order cycle. The minimum value is not less than 0.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[_builtins.str]:
        """
        Order cycle unit. Valid values: `Year` and `Month`.
        """
        return pulumi.get(self, "pricing_cycle")


@pulumi.output_type
class AppGroupQuota(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeResource":
            suggest = "compute_resource"
        elif key == "docSize":
            suggest = "doc_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppGroupQuota. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppGroupQuota.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppGroupQuota.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_resource: _builtins.int,
                 doc_size: _builtins.int,
                 spec: _builtins.str,
                 qps: Optional[_builtins.int] = None):
        """
        :param _builtins.int compute_resource: Computing resources. Unit: LCU.
        :param _builtins.int doc_size: Storage Size. Unit: GB.
        :param _builtins.str spec: Specification. Valid values: 
               * `opensearch.share.junior`: Entry-level.
               * `opensearch.share.common`: Shared universal.
               * `opensearch.share.compute`: Shared computing.
               * `opensearch.share.storage`: Shared storage type.
               * `opensearch.private.common`: Exclusive universal type.
               * `opensearch.private.compute`: Exclusive computing type.
               * `opensearch.private.storage`: Exclusive storage type
        :param _builtins.int qps: Search request. Unit: times/second.
        """
        pulumi.set(__self__, "compute_resource", compute_resource)
        pulumi.set(__self__, "doc_size", doc_size)
        pulumi.set(__self__, "spec", spec)
        if qps is not None:
            pulumi.set(__self__, "qps", qps)

    @_builtins.property
    @pulumi.getter(name="computeResource")
    def compute_resource(self) -> _builtins.int:
        """
        Computing resources. Unit: LCU.
        """
        return pulumi.get(self, "compute_resource")

    @_builtins.property
    @pulumi.getter(name="docSize")
    def doc_size(self) -> _builtins.int:
        """
        Storage Size. Unit: GB.
        """
        return pulumi.get(self, "doc_size")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> _builtins.str:
        """
        Specification. Valid values: 
        * `opensearch.share.junior`: Entry-level.
        * `opensearch.share.common`: Shared universal.
        * `opensearch.share.compute`: Shared computing.
        * `opensearch.share.storage`: Shared storage type.
        * `opensearch.private.common`: Exclusive universal type.
        * `opensearch.private.compute`: Exclusive computing type.
        * `opensearch.private.storage`: Exclusive storage type
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def qps(self) -> Optional[_builtins.int]:
        """
        Search request. Unit: times/second.
        """
        return pulumi.get(self, "qps")


@pulumi.output_type
class GetAppGroupsGroupResult(dict):
    def __init__(__self__, *,
                 app_group_id: _builtins.str,
                 app_group_name: _builtins.str,
                 charge_way: _builtins.int,
                 commodity_code: _builtins.str,
                 create_time: _builtins.int,
                 current_version: _builtins.str,
                 description: _builtins.str,
                 domain: _builtins.str,
                 expire_on: _builtins.str,
                 first_rank_algo_deployment_id: _builtins.int,
                 has_pending_quota_review_task: _builtins.int,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 lock_mode: _builtins.str,
                 locked_by_expiration: _builtins.int,
                 payment_type: _builtins.str,
                 pending_second_rank_algo_deployment_id: _builtins.int,
                 processing_order_id: _builtins.str,
                 produced: _builtins.int,
                 project_id: _builtins.str,
                 quotas: Sequence['outputs.GetAppGroupsGroupQuotaResult'],
                 resource_group_id: _builtins.str,
                 second_rank_algo_deployment_id: _builtins.int,
                 status: _builtins.str,
                 switched_time: _builtins.int,
                 type: _builtins.str):
        """
        :param _builtins.str app_group_id: The ID of the App Group.
        :param _builtins.str app_group_name: Application Group Name.
        :param _builtins.int charge_way: Billing model. Valid values:`compute_resource` and `qps`.
        :param _builtins.str commodity_code: The commodity code.
        :param _builtins.int create_time: The time of creation.
        :param _builtins.str current_version: The version of Application Group Name.
        :param _builtins.str description: The description of the resource.
        :param _builtins.str domain: Domain name.
        :param _builtins.str expire_on: Expiration Time.
        :param _builtins.int first_rank_algo_deployment_id: Coarse deployment ID.
        :param _builtins.int has_pending_quota_review_task: Whether the quota status is under approval. Valid status:
        :param _builtins.str instance_id: The Instance ID.
        :param _builtins.str lock_mode: Locked state. Valid status: `Unlock`,`LockByExpiration`,`ManualLock`.
        :param _builtins.int locked_by_expiration: Instance is automatically locked after expiration.
        :param _builtins.str payment_type: The billing method of the resource. Valid values: `Subscription` and `PayAsYouGo`.
        :param _builtins.int pending_second_rank_algo_deployment_id: Refine deployment ID in deployment.
        :param _builtins.str processing_order_id: Unfinished order number.
        :param _builtins.int produced: Whether the production is completed. Valid values:
        :param _builtins.str project_id: The Project ID.
        :param Sequence['GetAppGroupsGroupQuotaArgs'] quotas: Quota information.
        :param _builtins.str resource_group_id: The Resource Group ID.
        :param _builtins.int second_rank_algo_deployment_id: Refine deployment ID.
        :param _builtins.str status: The status of the resource. Valid values: `producing`,`review_pending`,`config_pending`,`normal`,`frozen`.
        :param _builtins.int switched_time: The Switched time.
        :param _builtins.str type: Application type. Valid Values: `standard`, `enhanced`.
        """
        pulumi.set(__self__, "app_group_id", app_group_id)
        pulumi.set(__self__, "app_group_name", app_group_name)
        pulumi.set(__self__, "charge_way", charge_way)
        pulumi.set(__self__, "commodity_code", commodity_code)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "current_version", current_version)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "expire_on", expire_on)
        pulumi.set(__self__, "first_rank_algo_deployment_id", first_rank_algo_deployment_id)
        pulumi.set(__self__, "has_pending_quota_review_task", has_pending_quota_review_task)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "lock_mode", lock_mode)
        pulumi.set(__self__, "locked_by_expiration", locked_by_expiration)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "pending_second_rank_algo_deployment_id", pending_second_rank_algo_deployment_id)
        pulumi.set(__self__, "processing_order_id", processing_order_id)
        pulumi.set(__self__, "produced", produced)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "quotas", quotas)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "second_rank_algo_deployment_id", second_rank_algo_deployment_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "switched_time", switched_time)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="appGroupId")
    def app_group_id(self) -> _builtins.str:
        """
        The ID of the App Group.
        """
        return pulumi.get(self, "app_group_id")

    @_builtins.property
    @pulumi.getter(name="appGroupName")
    def app_group_name(self) -> _builtins.str:
        """
        Application Group Name.
        """
        return pulumi.get(self, "app_group_name")

    @_builtins.property
    @pulumi.getter(name="chargeWay")
    def charge_way(self) -> _builtins.int:
        """
        Billing model. Valid values:`compute_resource` and `qps`.
        """
        return pulumi.get(self, "charge_way")

    @_builtins.property
    @pulumi.getter(name="commodityCode")
    def commodity_code(self) -> _builtins.str:
        """
        The commodity code.
        """
        return pulumi.get(self, "commodity_code")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.int:
        """
        The time of creation.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> _builtins.str:
        """
        The version of Application Group Name.
        """
        return pulumi.get(self, "current_version")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        Domain name.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="expireOn")
    def expire_on(self) -> _builtins.str:
        """
        Expiration Time.
        """
        return pulumi.get(self, "expire_on")

    @_builtins.property
    @pulumi.getter(name="firstRankAlgoDeploymentId")
    def first_rank_algo_deployment_id(self) -> _builtins.int:
        """
        Coarse deployment ID.
        """
        return pulumi.get(self, "first_rank_algo_deployment_id")

    @_builtins.property
    @pulumi.getter(name="hasPendingQuotaReviewTask")
    def has_pending_quota_review_task(self) -> _builtins.int:
        """
        Whether the quota status is under approval. Valid status:
        """
        return pulumi.get(self, "has_pending_quota_review_task")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The Instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="lockMode")
    def lock_mode(self) -> _builtins.str:
        """
        Locked state. Valid status: `Unlock`,`LockByExpiration`,`ManualLock`.
        """
        return pulumi.get(self, "lock_mode")

    @_builtins.property
    @pulumi.getter(name="lockedByExpiration")
    def locked_by_expiration(self) -> _builtins.int:
        """
        Instance is automatically locked after expiration.
        """
        return pulumi.get(self, "locked_by_expiration")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> _builtins.str:
        """
        The billing method of the resource. Valid values: `Subscription` and `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="pendingSecondRankAlgoDeploymentId")
    def pending_second_rank_algo_deployment_id(self) -> _builtins.int:
        """
        Refine deployment ID in deployment.
        """
        return pulumi.get(self, "pending_second_rank_algo_deployment_id")

    @_builtins.property
    @pulumi.getter(name="processingOrderId")
    def processing_order_id(self) -> _builtins.str:
        """
        Unfinished order number.
        """
        return pulumi.get(self, "processing_order_id")

    @_builtins.property
    @pulumi.getter
    def produced(self) -> _builtins.int:
        """
        Whether the production is completed. Valid values:
        """
        return pulumi.get(self, "produced")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The Project ID.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def quotas(self) -> Sequence['outputs.GetAppGroupsGroupQuotaResult']:
        """
        Quota information.
        """
        return pulumi.get(self, "quotas")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The Resource Group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="secondRankAlgoDeploymentId")
    def second_rank_algo_deployment_id(self) -> _builtins.int:
        """
        Refine deployment ID.
        """
        return pulumi.get(self, "second_rank_algo_deployment_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource. Valid values: `producing`,`review_pending`,`config_pending`,`normal`,`frozen`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="switchedTime")
    def switched_time(self) -> _builtins.int:
        """
        The Switched time.
        """
        return pulumi.get(self, "switched_time")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Application type. Valid Values: `standard`, `enhanced`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAppGroupsGroupQuotaResult(dict):
    def __init__(__self__, *,
                 compute_resource: _builtins.str,
                 doc_size: _builtins.str,
                 spec: _builtins.str):
        """
        :param _builtins.str compute_resource: Computing resources. Unit: LCU.
        :param _builtins.str doc_size: Storage Size. Unit: GB.
        :param _builtins.str spec: Specification. Valid values:
               * `opensearch.share.junior`: Entry-level.
               * `opensearch.share.common`: Shared universal.
               * `opensearch.share.compute`: Shared computing.
               * `opensearch.share.storage`: Shared storage type.
               * `opensearch.private.common`: Exclusive universal type.
               * `opensearch.private.compute`: Exclusive computing type.
               * `opensearch.private.storage`: Exclusive storage type
        """
        pulumi.set(__self__, "compute_resource", compute_resource)
        pulumi.set(__self__, "doc_size", doc_size)
        pulumi.set(__self__, "spec", spec)

    @_builtins.property
    @pulumi.getter(name="computeResource")
    def compute_resource(self) -> _builtins.str:
        """
        Computing resources. Unit: LCU.
        """
        return pulumi.get(self, "compute_resource")

    @_builtins.property
    @pulumi.getter(name="docSize")
    def doc_size(self) -> _builtins.str:
        """
        Storage Size. Unit: GB.
        """
        return pulumi.get(self, "doc_size")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> _builtins.str:
        """
        Specification. Valid values:
        * `opensearch.share.junior`: Entry-level.
        * `opensearch.share.common`: Shared universal.
        * `opensearch.share.compute`: Shared computing.
        * `opensearch.share.storage`: Shared storage type.
        * `opensearch.private.common`: Exclusive universal type.
        * `opensearch.private.compute`: Exclusive computing type.
        * `opensearch.private.storage`: Exclusive storage type
        """
        return pulumi.get(self, "spec")


