# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BucketHttpsConfigArgs', 'BucketHttpsConfig']

@pulumi.input_type
class BucketHttpsConfigArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 enable: pulumi.Input[_builtins.bool],
                 tls_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a BucketHttpsConfig resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket.
        :param pulumi.Input[_builtins.bool] enable: Specifies whether to enable TLS version management for the bucket. Valid values: true, false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tls_versions: Specifies the TLS versions allowed to access this buckets.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "enable", enable)
        if tls_versions is not None:
            pulumi.set(__self__, "tls_versions", tls_versions)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> pulumi.Input[_builtins.bool]:
        """
        Specifies whether to enable TLS version management for the bucket. Valid values: true, false.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter(name="tlsVersions")
    def tls_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the TLS versions allowed to access this buckets.
        """
        return pulumi.get(self, "tls_versions")

    @tls_versions.setter
    def tls_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tls_versions", value)


@pulumi.input_type
class _BucketHttpsConfigState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 tls_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering BucketHttpsConfig resources.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket.
        :param pulumi.Input[_builtins.bool] enable: Specifies whether to enable TLS version management for the bucket. Valid values: true, false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tls_versions: Specifies the TLS versions allowed to access this buckets.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if tls_versions is not None:
            pulumi.set(__self__, "tls_versions", tls_versions)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable TLS version management for the bucket. Valid values: true, false.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter(name="tlsVersions")
    def tls_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the TLS versions allowed to access this buckets.
        """
        return pulumi.get(self, "tls_versions")

    @tls_versions.setter
    def tls_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tls_versions", value)


@pulumi.type_token("alicloud:oss/bucketHttpsConfig:BucketHttpsConfig")
class BucketHttpsConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 tls_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Import

        OSS Bucket Https Config can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:oss/bucketHttpsConfig:BucketHttpsConfig example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket.
        :param pulumi.Input[_builtins.bool] enable: Specifies whether to enable TLS version management for the bucket. Valid values: true, false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tls_versions: Specifies the TLS versions allowed to access this buckets.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketHttpsConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        OSS Bucket Https Config can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:oss/bucketHttpsConfig:BucketHttpsConfig example <id>
        ```

        :param str resource_name: The name of the resource.
        :param BucketHttpsConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketHttpsConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 tls_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketHttpsConfigArgs.__new__(BucketHttpsConfigArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            if enable is None and not opts.urn:
                raise TypeError("Missing required property 'enable'")
            __props__.__dict__["enable"] = enable
            __props__.__dict__["tls_versions"] = tls_versions
        super(BucketHttpsConfig, __self__).__init__(
            'alicloud:oss/bucketHttpsConfig:BucketHttpsConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            enable: Optional[pulumi.Input[_builtins.bool]] = None,
            tls_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'BucketHttpsConfig':
        """
        Get an existing BucketHttpsConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket.
        :param pulumi.Input[_builtins.bool] enable: Specifies whether to enable TLS version management for the bucket. Valid values: true, false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tls_versions: Specifies the TLS versions allowed to access this buckets.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketHttpsConfigState.__new__(_BucketHttpsConfigState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["enable"] = enable
        __props__.__dict__["tls_versions"] = tls_versions
        return BucketHttpsConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable TLS version management for the bucket. Valid values: true, false.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="tlsVersions")
    def tls_versions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the TLS versions allowed to access this buckets.
        """
        return pulumi.get(self, "tls_versions")

