# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BucketServerSideEncryptionArgs', 'BucketServerSideEncryption']

@pulumi.input_type
class BucketServerSideEncryptionArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 sse_algorithm: pulumi.Input[_builtins.str],
                 kms_data_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_master_key_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BucketServerSideEncryption resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket.
        :param pulumi.Input[_builtins.str] sse_algorithm: The server-side encryption method. Valid Values: KMS, AES256.
        :param pulumi.Input[_builtins.str] kms_data_encryption: The algorithm used to encrypt objects. If this element is not specified, objects are encrypted by using AES256. This element is valid only when the value of SSEAlgorithm is set to KMS.
        :param pulumi.Input[_builtins.str] kms_master_key_id: The CMK ID that must be specified when SSEAlgorithm is set to KMS and a specified CMK is used for encryption. In other cases, this element must be set to null.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "sse_algorithm", sse_algorithm)
        if kms_data_encryption is not None:
            pulumi.set(__self__, "kms_data_encryption", kms_data_encryption)
        if kms_master_key_id is not None:
            pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> pulumi.Input[_builtins.str]:
        """
        The server-side encryption method. Valid Values: KMS, AES256.
        """
        return pulumi.get(self, "sse_algorithm")

    @sse_algorithm.setter
    def sse_algorithm(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sse_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="kmsDataEncryption")
    def kms_data_encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The algorithm used to encrypt objects. If this element is not specified, objects are encrypted by using AES256. This element is valid only when the value of SSEAlgorithm is set to KMS.
        """
        return pulumi.get(self, "kms_data_encryption")

    @kms_data_encryption.setter
    def kms_data_encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_data_encryption", value)

    @_builtins.property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CMK ID that must be specified when SSEAlgorithm is set to KMS and a specified CMK is used for encryption. In other cases, this element must be set to null.
        """
        return pulumi.get(self, "kms_master_key_id")

    @kms_master_key_id.setter
    def kms_master_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_master_key_id", value)


@pulumi.input_type
class _BucketServerSideEncryptionState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_data_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_master_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sse_algorithm: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BucketServerSideEncryption resources.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket.
        :param pulumi.Input[_builtins.str] kms_data_encryption: The algorithm used to encrypt objects. If this element is not specified, objects are encrypted by using AES256. This element is valid only when the value of SSEAlgorithm is set to KMS.
        :param pulumi.Input[_builtins.str] kms_master_key_id: The CMK ID that must be specified when SSEAlgorithm is set to KMS and a specified CMK is used for encryption. In other cases, this element must be set to null.
        :param pulumi.Input[_builtins.str] sse_algorithm: The server-side encryption method. Valid Values: KMS, AES256.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if kms_data_encryption is not None:
            pulumi.set(__self__, "kms_data_encryption", kms_data_encryption)
        if kms_master_key_id is not None:
            pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)
        if sse_algorithm is not None:
            pulumi.set(__self__, "sse_algorithm", sse_algorithm)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="kmsDataEncryption")
    def kms_data_encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The algorithm used to encrypt objects. If this element is not specified, objects are encrypted by using AES256. This element is valid only when the value of SSEAlgorithm is set to KMS.
        """
        return pulumi.get(self, "kms_data_encryption")

    @kms_data_encryption.setter
    def kms_data_encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_data_encryption", value)

    @_builtins.property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CMK ID that must be specified when SSEAlgorithm is set to KMS and a specified CMK is used for encryption. In other cases, this element must be set to null.
        """
        return pulumi.get(self, "kms_master_key_id")

    @kms_master_key_id.setter
    def kms_master_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_master_key_id", value)

    @_builtins.property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The server-side encryption method. Valid Values: KMS, AES256.
        """
        return pulumi.get(self, "sse_algorithm")

    @sse_algorithm.setter
    def sse_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sse_algorithm", value)


@pulumi.type_token("alicloud:oss/bucketServerSideEncryption:BucketServerSideEncryption")
class BucketServerSideEncryption(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_data_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_master_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sse_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a OSS Bucket Server Side Encryption resource. Server-side encryption rules of the bucket.

        For information about OSS Bucket Server Side Encryption and how to use it, see [What is Bucket Server Side Encryption](https://www.alibabacloud.com/help/en/oss/developer-reference/putbucketencryption).

        > **NOTE:** Available since v1.222.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        create_bucket = alicloud.oss.Bucket("CreateBucket",
            storage_class="Standard",
            bucket=f"{name}-{default['result']}")
        get_kms = alicloud.kms.Key("GetKMS",
            origin="Aliyun_KMS",
            protection_level="SOFTWARE",
            description=name,
            key_spec="Aliyun_AES_256",
            key_usage="ENCRYPT/DECRYPT",
            automatic_rotation="Disabled",
            pending_window_in_days=7)
        default_bucket_server_side_encryption = alicloud.oss.BucketServerSideEncryption("default",
            kms_data_encryption="SM4",
            kms_master_key_id=get_kms.id,
            bucket=create_bucket.bucket,
            sse_algorithm="KMS")
        ```

        ## Import

        OSS Bucket Server Side Encryption can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:oss/bucketServerSideEncryption:BucketServerSideEncryption example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket.
        :param pulumi.Input[_builtins.str] kms_data_encryption: The algorithm used to encrypt objects. If this element is not specified, objects are encrypted by using AES256. This element is valid only when the value of SSEAlgorithm is set to KMS.
        :param pulumi.Input[_builtins.str] kms_master_key_id: The CMK ID that must be specified when SSEAlgorithm is set to KMS and a specified CMK is used for encryption. In other cases, this element must be set to null.
        :param pulumi.Input[_builtins.str] sse_algorithm: The server-side encryption method. Valid Values: KMS, AES256.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketServerSideEncryptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a OSS Bucket Server Side Encryption resource. Server-side encryption rules of the bucket.

        For information about OSS Bucket Server Side Encryption and how to use it, see [What is Bucket Server Side Encryption](https://www.alibabacloud.com/help/en/oss/developer-reference/putbucketencryption).

        > **NOTE:** Available since v1.222.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        create_bucket = alicloud.oss.Bucket("CreateBucket",
            storage_class="Standard",
            bucket=f"{name}-{default['result']}")
        get_kms = alicloud.kms.Key("GetKMS",
            origin="Aliyun_KMS",
            protection_level="SOFTWARE",
            description=name,
            key_spec="Aliyun_AES_256",
            key_usage="ENCRYPT/DECRYPT",
            automatic_rotation="Disabled",
            pending_window_in_days=7)
        default_bucket_server_side_encryption = alicloud.oss.BucketServerSideEncryption("default",
            kms_data_encryption="SM4",
            kms_master_key_id=get_kms.id,
            bucket=create_bucket.bucket,
            sse_algorithm="KMS")
        ```

        ## Import

        OSS Bucket Server Side Encryption can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:oss/bucketServerSideEncryption:BucketServerSideEncryption example <id>
        ```

        :param str resource_name: The name of the resource.
        :param BucketServerSideEncryptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketServerSideEncryptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_data_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_master_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sse_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketServerSideEncryptionArgs.__new__(BucketServerSideEncryptionArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["kms_data_encryption"] = kms_data_encryption
            __props__.__dict__["kms_master_key_id"] = kms_master_key_id
            if sse_algorithm is None and not opts.urn:
                raise TypeError("Missing required property 'sse_algorithm'")
            __props__.__dict__["sse_algorithm"] = sse_algorithm
        super(BucketServerSideEncryption, __self__).__init__(
            'alicloud:oss/bucketServerSideEncryption:BucketServerSideEncryption',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            kms_data_encryption: Optional[pulumi.Input[_builtins.str]] = None,
            kms_master_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            sse_algorithm: Optional[pulumi.Input[_builtins.str]] = None) -> 'BucketServerSideEncryption':
        """
        Get an existing BucketServerSideEncryption resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket.
        :param pulumi.Input[_builtins.str] kms_data_encryption: The algorithm used to encrypt objects. If this element is not specified, objects are encrypted by using AES256. This element is valid only when the value of SSEAlgorithm is set to KMS.
        :param pulumi.Input[_builtins.str] kms_master_key_id: The CMK ID that must be specified when SSEAlgorithm is set to KMS and a specified CMK is used for encryption. In other cases, this element must be set to null.
        :param pulumi.Input[_builtins.str] sse_algorithm: The server-side encryption method. Valid Values: KMS, AES256.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketServerSideEncryptionState.__new__(_BucketServerSideEncryptionState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["kms_data_encryption"] = kms_data_encryption
        __props__.__dict__["kms_master_key_id"] = kms_master_key_id
        __props__.__dict__["sse_algorithm"] = sse_algorithm
        return BucketServerSideEncryption(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="kmsDataEncryption")
    def kms_data_encryption(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The algorithm used to encrypt objects. If this element is not specified, objects are encrypted by using AES256. This element is valid only when the value of SSEAlgorithm is set to KMS.
        """
        return pulumi.get(self, "kms_data_encryption")

    @_builtins.property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The CMK ID that must be specified when SSEAlgorithm is set to KMS and a specified CMK is used for encryption. In other cases, this element must be set to null.
        """
        return pulumi.get(self, "kms_master_key_id")

    @_builtins.property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        The server-side encryption method. Valid Values: KMS, AES256.
        """
        return pulumi.get(self, "sse_algorithm")

