# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTunnelsResult',
    'AwaitableGetTunnelsResult',
    'get_tunnels',
    'get_tunnels_output',
]

@pulumi.output_type
class GetTunnelsResult:
    """
    A collection of values returned by getTunnels.
    """
    def __init__(__self__, id=None, ids=None, instance_name=None, name_regex=None, names=None, output_file=None, table_name=None, tunnels=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instance_name and not isinstance(instance_name, str):
            raise TypeError("Expected argument 'instance_name' to be a str")
        pulumi.set(__self__, "instance_name", instance_name)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if table_name and not isinstance(table_name, str):
            raise TypeError("Expected argument 'table_name' to be a str")
        pulumi.set(__self__, "table_name", table_name)
        if tunnels and not isinstance(tunnels, list):
            raise TypeError("Expected argument 'tunnels' to be a list")
        pulumi.set(__self__, "tunnels", tunnels)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of tunnel IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> _builtins.str:
        """
        The OTS instance name.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of tunnel names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> _builtins.str:
        """
        The table name of the OTS which could not be changed.
        """
        return pulumi.get(self, "table_name")

    @_builtins.property
    @pulumi.getter
    def tunnels(self) -> Sequence['outputs.GetTunnelsTunnelResult']:
        """
        A list of tunnels. Each element contains the following attributes:
        """
        return pulumi.get(self, "tunnels")


class AwaitableGetTunnelsResult(GetTunnelsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTunnelsResult(
            id=self.id,
            ids=self.ids,
            instance_name=self.instance_name,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            table_name=self.table_name,
            tunnels=self.tunnels)


def get_tunnels(ids: Optional[Sequence[_builtins.str]] = None,
                instance_name: Optional[_builtins.str] = None,
                name_regex: Optional[_builtins.str] = None,
                output_file: Optional[_builtins.str] = None,
                table_name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTunnelsResult:
    """
    This data source provides the ots tunnels of the current Alibaba Cloud user.

    For information about OTS tunnel and how to use it, see [Tunnel overview](https://www.alibabacloud.com/help/en/tablestore/latest/tunnel-service-overview).

    > **NOTE:** Available in v1.172.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    tunnels_ds = alicloud.ots.get_tunnels(instance_name="sample-instance",
        table_name="sample-table",
        name_regex="sample-tunnel",
        output_file="tunnels.txt")
    pulumi.export("firstTunnelId", tunnels_ds.tunnels[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of tunnel IDs.
    :param _builtins.str instance_name: The name of OTS instance.
    :param _builtins.str name_regex: A regex string to filter results by tunnel name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str table_name: The name of OTS table.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['instanceName'] = instance_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['tableName'] = table_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ots/getTunnels:getTunnels', __args__, opts=opts, typ=GetTunnelsResult).value

    return AwaitableGetTunnelsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instance_name=pulumi.get(__ret__, 'instance_name'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        table_name=pulumi.get(__ret__, 'table_name'),
        tunnels=pulumi.get(__ret__, 'tunnels'))
def get_tunnels_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                       instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                       name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       table_name: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTunnelsResult]:
    """
    This data source provides the ots tunnels of the current Alibaba Cloud user.

    For information about OTS tunnel and how to use it, see [Tunnel overview](https://www.alibabacloud.com/help/en/tablestore/latest/tunnel-service-overview).

    > **NOTE:** Available in v1.172.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    tunnels_ds = alicloud.ots.get_tunnels(instance_name="sample-instance",
        table_name="sample-table",
        name_regex="sample-tunnel",
        output_file="tunnels.txt")
    pulumi.export("firstTunnelId", tunnels_ds.tunnels[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of tunnel IDs.
    :param _builtins.str instance_name: The name of OTS instance.
    :param _builtins.str name_regex: A regex string to filter results by tunnel name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str table_name: The name of OTS table.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['instanceName'] = instance_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['tableName'] = table_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ots/getTunnels:getTunnels', __args__, opts=opts, typ=GetTunnelsResult)
    return __ret__.apply(lambda __response__: GetTunnelsResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        instance_name=pulumi.get(__response__, 'instance_name'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        table_name=pulumi.get(__response__, 'table_name'),
        tunnels=pulumi.get(__response__, 'tunnels')))
