# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetZonesResult',
    'AwaitableGetZonesResult',
    'get_zones',
    'get_zones_output',
]

@pulumi.output_type
class GetZonesResult:
    """
    A collection of values returned by getZones.
    """
    def __init__(__self__, enable_details=None, id=None, ids=None, keyword=None, lang=None, name_regex=None, names=None, output_file=None, query_region_id=None, query_vpc_id=None, resource_group_id=None, search_mode=None, zones=None):
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if keyword and not isinstance(keyword, str):
            raise TypeError("Expected argument 'keyword' to be a str")
        pulumi.set(__self__, "keyword", keyword)
        if lang and not isinstance(lang, str):
            raise TypeError("Expected argument 'lang' to be a str")
        pulumi.set(__self__, "lang", lang)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if query_region_id and not isinstance(query_region_id, str):
            raise TypeError("Expected argument 'query_region_id' to be a str")
        pulumi.set(__self__, "query_region_id", query_region_id)
        if query_vpc_id and not isinstance(query_vpc_id, str):
            raise TypeError("Expected argument 'query_vpc_id' to be a str")
        pulumi.set(__self__, "query_vpc_id", query_vpc_id)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if search_mode and not isinstance(search_mode, str):
            raise TypeError("Expected argument 'search_mode' to be a str")
        pulumi.set(__self__, "search_mode", search_mode)
        if zones and not isinstance(zones, list):
            raise TypeError("Expected argument 'zones' to be a list")
        pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def keyword(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "keyword")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Zone names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="queryRegionId")
    def query_region_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "query_region_id")

    @_builtins.property
    @pulumi.getter(name="queryVpcId")
    def query_vpc_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "query_vpc_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of the resource group to which the zone belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="searchMode")
    def search_mode(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "search_mode")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Sequence['outputs.GetZonesZoneResult']:
        """
        A list of Zone. Each element contains the following attributes:
        """
        return pulumi.get(self, "zones")


class AwaitableGetZonesResult(GetZonesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZonesResult(
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            keyword=self.keyword,
            lang=self.lang,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            query_region_id=self.query_region_id,
            query_vpc_id=self.query_vpc_id,
            resource_group_id=self.resource_group_id,
            search_mode=self.search_mode,
            zones=self.zones)


def get_zones(enable_details: Optional[_builtins.bool] = None,
              ids: Optional[Sequence[_builtins.str]] = None,
              keyword: Optional[_builtins.str] = None,
              lang: Optional[_builtins.str] = None,
              name_regex: Optional[_builtins.str] = None,
              output_file: Optional[_builtins.str] = None,
              query_region_id: Optional[_builtins.str] = None,
              query_vpc_id: Optional[_builtins.str] = None,
              resource_group_id: Optional[_builtins.str] = None,
              search_mode: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZonesResult:
    """
    This data source provides the Private Zones of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.13.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example.com"
    default = alicloud.pvtz.Zone("default", zone_name=name)
    ids = alicloud.pvtz.get_zones_output(ids=[default.id])
    pulumi.export("pvtzZonesId0", ids.zones[0].id)
    ```


    :param _builtins.bool enable_details: Whether to query the detailed list of resource attributes. Default value: `false`.
    :param Sequence[_builtins.str] ids: A list of Zones IDs.
    :param _builtins.str keyword: The keyword of the zone name.
    :param _builtins.str lang: The language of the response. Default value: `en`. Valid values: `en`, `zh`.
    :param _builtins.str name_regex: A regex string to filter results by Zone name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str query_region_id: The region ID of the virtual private cloud (VPC) associated with the zone.
    :param _builtins.str query_vpc_id: The ID of the VPC associated with the zone.
    :param _builtins.str resource_group_id: The ID of the resource group to which the zone belongs.
    :param _builtins.str search_mode: The search mode. The value of Keyword is the search scope. Default value: `LIKE`. Valid values:
           - `LIKE`: Fuzzy search.
           - `EXACT`: Exact search.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['keyword'] = keyword
    __args__['lang'] = lang
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['queryRegionId'] = query_region_id
    __args__['queryVpcId'] = query_vpc_id
    __args__['resourceGroupId'] = resource_group_id
    __args__['searchMode'] = search_mode
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:pvtz/getZones:getZones', __args__, opts=opts, typ=GetZonesResult).value

    return AwaitableGetZonesResult(
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        keyword=pulumi.get(__ret__, 'keyword'),
        lang=pulumi.get(__ret__, 'lang'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        query_region_id=pulumi.get(__ret__, 'query_region_id'),
        query_vpc_id=pulumi.get(__ret__, 'query_vpc_id'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        search_mode=pulumi.get(__ret__, 'search_mode'),
        zones=pulumi.get(__ret__, 'zones'))
def get_zones_output(enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                     ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                     keyword: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     lang: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     query_region_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     query_vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     search_mode: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZonesResult]:
    """
    This data source provides the Private Zones of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.13.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example.com"
    default = alicloud.pvtz.Zone("default", zone_name=name)
    ids = alicloud.pvtz.get_zones_output(ids=[default.id])
    pulumi.export("pvtzZonesId0", ids.zones[0].id)
    ```


    :param _builtins.bool enable_details: Whether to query the detailed list of resource attributes. Default value: `false`.
    :param Sequence[_builtins.str] ids: A list of Zones IDs.
    :param _builtins.str keyword: The keyword of the zone name.
    :param _builtins.str lang: The language of the response. Default value: `en`. Valid values: `en`, `zh`.
    :param _builtins.str name_regex: A regex string to filter results by Zone name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str query_region_id: The region ID of the virtual private cloud (VPC) associated with the zone.
    :param _builtins.str query_vpc_id: The ID of the VPC associated with the zone.
    :param _builtins.str resource_group_id: The ID of the resource group to which the zone belongs.
    :param _builtins.str search_mode: The search mode. The value of Keyword is the search scope. Default value: `LIKE`. Valid values:
           - `LIKE`: Fuzzy search.
           - `EXACT`: Exact search.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['keyword'] = keyword
    __args__['lang'] = lang
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['queryRegionId'] = query_region_id
    __args__['queryVpcId'] = query_vpc_id
    __args__['resourceGroupId'] = resource_group_id
    __args__['searchMode'] = search_mode
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:pvtz/getZones:getZones', __args__, opts=opts, typ=GetZonesResult)
    return __ret__.apply(lambda __response__: GetZonesResult(
        enable_details=pulumi.get(__response__, 'enable_details'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        keyword=pulumi.get(__response__, 'keyword'),
        lang=pulumi.get(__response__, 'lang'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        query_region_id=pulumi.get(__response__, 'query_region_id'),
        query_vpc_id=pulumi.get(__response__, 'query_vpc_id'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        search_mode=pulumi.get(__response__, 'search_mode'),
        zones=pulumi.get(__response__, 'zones')))
