# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RuleAttachmentArgs', 'RuleAttachment']

@pulumi.input_type
class RuleAttachmentArgs:
    def __init__(__self__, *,
                 rule_id: pulumi.Input[_builtins.str],
                 vpcs: pulumi.Input[Sequence[pulumi.Input['RuleAttachmentVpcArgs']]]):
        """
        The set of arguments for constructing a RuleAttachment resource.
        :param pulumi.Input[_builtins.str] rule_id: The ID of the rule.
        :param pulumi.Input[Sequence[pulumi.Input['RuleAttachmentVpcArgs']]] vpcs: The List of the VPC. See `vpcs` below.
        """
        pulumi.set(__self__, "rule_id", rule_id)
        pulumi.set(__self__, "vpcs", vpcs)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the rule.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_id", value)

    @_builtins.property
    @pulumi.getter
    def vpcs(self) -> pulumi.Input[Sequence[pulumi.Input['RuleAttachmentVpcArgs']]]:
        """
        The List of the VPC. See `vpcs` below.
        """
        return pulumi.get(self, "vpcs")

    @vpcs.setter
    def vpcs(self, value: pulumi.Input[Sequence[pulumi.Input['RuleAttachmentVpcArgs']]]):
        pulumi.set(self, "vpcs", value)


@pulumi.input_type
class _RuleAttachmentState:
    def __init__(__self__, *,
                 rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpcs: Optional[pulumi.Input[Sequence[pulumi.Input['RuleAttachmentVpcArgs']]]] = None):
        """
        Input properties used for looking up and filtering RuleAttachment resources.
        :param pulumi.Input[_builtins.str] rule_id: The ID of the rule.
        :param pulumi.Input[Sequence[pulumi.Input['RuleAttachmentVpcArgs']]] vpcs: The List of the VPC. See `vpcs` below.
        """
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if vpcs is not None:
            pulumi.set(__self__, "vpcs", vpcs)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the rule.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_id", value)

    @_builtins.property
    @pulumi.getter
    def vpcs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleAttachmentVpcArgs']]]]:
        """
        The List of the VPC. See `vpcs` below.
        """
        return pulumi.get(self, "vpcs")

    @vpcs.setter
    def vpcs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleAttachmentVpcArgs']]]]):
        pulumi.set(self, "vpcs", value)


@pulumi.type_token("alicloud:pvtz/ruleAttachment:RuleAttachment")
class RuleAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpcs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleAttachmentVpcArgs', 'RuleAttachmentVpcArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Private Zone Rule Attachment resource.

        For information about Private Zone Rule Attachment and how to use it, see [What is Rule Attachment](https://www.alibabacloud.com/help/en/doc-detail/177601.htm).

        > **NOTE:** Available since v1.143.0.

        ## Import

        Private Zone Rule Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pvtz/ruleAttachment:RuleAttachment example <rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] rule_id: The ID of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleAttachmentVpcArgs', 'RuleAttachmentVpcArgsDict']]]] vpcs: The List of the VPC. See `vpcs` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Private Zone Rule Attachment resource.

        For information about Private Zone Rule Attachment and how to use it, see [What is Rule Attachment](https://www.alibabacloud.com/help/en/doc-detail/177601.htm).

        > **NOTE:** Available since v1.143.0.

        ## Import

        Private Zone Rule Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pvtz/ruleAttachment:RuleAttachment example <rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param RuleAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpcs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleAttachmentVpcArgs', 'RuleAttachmentVpcArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleAttachmentArgs.__new__(RuleAttachmentArgs)

            if rule_id is None and not opts.urn:
                raise TypeError("Missing required property 'rule_id'")
            __props__.__dict__["rule_id"] = rule_id
            if vpcs is None and not opts.urn:
                raise TypeError("Missing required property 'vpcs'")
            __props__.__dict__["vpcs"] = vpcs
        super(RuleAttachment, __self__).__init__(
            'alicloud:pvtz/ruleAttachment:RuleAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            rule_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpcs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleAttachmentVpcArgs', 'RuleAttachmentVpcArgsDict']]]]] = None) -> 'RuleAttachment':
        """
        Get an existing RuleAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] rule_id: The ID of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleAttachmentVpcArgs', 'RuleAttachmentVpcArgsDict']]]] vpcs: The List of the VPC. See `vpcs` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleAttachmentState.__new__(_RuleAttachmentState)

        __props__.__dict__["rule_id"] = rule_id
        __props__.__dict__["vpcs"] = vpcs
        return RuleAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the rule.
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter
    def vpcs(self) -> pulumi.Output[Sequence['outputs.RuleAttachmentVpc']]:
        """
        The List of the VPC. See `vpcs` below.
        """
        return pulumi.get(self, "vpcs")

