# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetUsersResult',
    'AwaitableGetUsersResult',
    'get_users',
    'get_users_output',
]

@pulumi.output_type
class GetUsersResult:
    """
    A collection of values returned by getUsers.
    """
    def __init__(__self__, group_name=None, id=None, ids=None, name_regex=None, names=None, output_file=None, policy_name=None, policy_type=None, users=None):
        if group_name and not isinstance(group_name, str):
            raise TypeError("Expected argument 'group_name' to be a str")
        pulumi.set(__self__, "group_name", group_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if policy_name and not isinstance(policy_name, str):
            raise TypeError("Expected argument 'policy_name' to be a str")
        pulumi.set(__self__, "policy_name", policy_name)
        if policy_type and not isinstance(policy_type, str):
            raise TypeError("Expected argument 'policy_type' to be a str")
        pulumi.set(__self__, "policy_type", policy_type)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of ram user IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of ram user's name.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "policy_name")

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "policy_type")

    @_builtins.property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetUsersUserResult']:
        """
        A list of users. Each element contains the following attributes:
        """
        return pulumi.get(self, "users")


class AwaitableGetUsersResult(GetUsersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUsersResult(
            group_name=self.group_name,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            policy_name=self.policy_name,
            policy_type=self.policy_type,
            users=self.users)


def get_users(group_name: Optional[_builtins.str] = None,
              ids: Optional[Sequence[_builtins.str]] = None,
              name_regex: Optional[_builtins.str] = None,
              output_file: Optional[_builtins.str] = None,
              policy_name: Optional[_builtins.str] = None,
              policy_type: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUsersResult:
    """
    This data source provides a list of RAM users in an Alibaba Cloud account according to the specified filters.

    > **NOTE:** Available since v1.0.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.ram.Group("default",
        name="group1",
        comments="group comments",
        force=True)
    default_user = alicloud.ram.User("default",
        name="user-example",
        display_name="displayname",
        mobile="86-18888888888",
        email="hello.uuu@aaa.com",
        comments="yoyoyo")
    default_group_membership = alicloud.ram.GroupMembership("default",
        group_name=default.name,
        user_names=[default_user.name])
    default_policy = alicloud.ram.Policy("default",
        policy_name="ram-policy-example",
        policy_document=\"\"\"\\x09\\x09\\x09{
    \\x09\\x09\\x09\\x09"Statement": [
    \\x09\\x09\\x09\\x09 {
    \\x09\\x09\\x09\\x09\\x09"Action": [
    \\x09\\x09\\x09\\x09\\x09"oss:ListObjects",
    \\x09\\x09\\x09\\x09\\x09"oss:ListObjects"
    \\x09\\x09\\x09  \\x09\\x09],
    \\x09\\x09\\x09  \\x09\\x09"Effect": "Deny",
    \\x09\\x09\\x09  \\x09\\x09"Resource": [
    \\x09\\x09\\x09\\x09\\x09\\x09"acs:oss:*:*:mybucket",
    \\x09\\x09\\x09\\x09\\x09\\x09"acs:oss:*:*:mybucket/*"
    \\x09\\x09\\x09  \\x09\\x09]
    \\x09\\x09\\x09\\x09 }
    \\x09\\x09  \\x09\\x09],
    \\x09\\x09\\x09\\x09"Version": "1"
    \\x09\\x09\\x09}
    \"\"\",
        description="this is a policy example",
        force=True)
    default_user_policy_attachment = alicloud.ram.UserPolicyAttachment("default",
        policy_name=default_policy.policy_name,
        user_name=default_user.name,
        policy_type=default_policy.type)
    users_ds = alicloud.ram.get_users_output(output_file="users.txt",
        group_name=default.name,
        policy_name=default_policy.policy_name,
        policy_type="Custom",
        name_regex=default_user.name)
    pulumi.export("firstUserId", users_ds.users[0].id)
    ```


    :param _builtins.str group_name: Filter results by a specific group name. Returned users are in the specified group.
    :param Sequence[_builtins.str] ids: A list of ram user IDs.
    :param _builtins.str name_regex: A regex string to filter resulting users by their names.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str policy_name: Filter results by a specific policy name. If you set this parameter without setting `policy_type`, the later will be automatically set to `System`. Returned users are attached to the specified policy.
    :param _builtins.str policy_type: Filter results by a specific policy type. Valid values are `Custom` and `System`. If you set this parameter, you must set `policy_name` as well.
    """
    __args__ = dict()
    __args__['groupName'] = group_name
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['policyName'] = policy_name
    __args__['policyType'] = policy_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ram/getUsers:getUsers', __args__, opts=opts, typ=GetUsersResult).value

    return AwaitableGetUsersResult(
        group_name=pulumi.get(__ret__, 'group_name'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        policy_name=pulumi.get(__ret__, 'policy_name'),
        policy_type=pulumi.get(__ret__, 'policy_type'),
        users=pulumi.get(__ret__, 'users'))
def get_users_output(group_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                     name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     policy_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     policy_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUsersResult]:
    """
    This data source provides a list of RAM users in an Alibaba Cloud account according to the specified filters.

    > **NOTE:** Available since v1.0.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.ram.Group("default",
        name="group1",
        comments="group comments",
        force=True)
    default_user = alicloud.ram.User("default",
        name="user-example",
        display_name="displayname",
        mobile="86-18888888888",
        email="hello.uuu@aaa.com",
        comments="yoyoyo")
    default_group_membership = alicloud.ram.GroupMembership("default",
        group_name=default.name,
        user_names=[default_user.name])
    default_policy = alicloud.ram.Policy("default",
        policy_name="ram-policy-example",
        policy_document=\"\"\"\\x09\\x09\\x09{
    \\x09\\x09\\x09\\x09"Statement": [
    \\x09\\x09\\x09\\x09 {
    \\x09\\x09\\x09\\x09\\x09"Action": [
    \\x09\\x09\\x09\\x09\\x09"oss:ListObjects",
    \\x09\\x09\\x09\\x09\\x09"oss:ListObjects"
    \\x09\\x09\\x09  \\x09\\x09],
    \\x09\\x09\\x09  \\x09\\x09"Effect": "Deny",
    \\x09\\x09\\x09  \\x09\\x09"Resource": [
    \\x09\\x09\\x09\\x09\\x09\\x09"acs:oss:*:*:mybucket",
    \\x09\\x09\\x09\\x09\\x09\\x09"acs:oss:*:*:mybucket/*"
    \\x09\\x09\\x09  \\x09\\x09]
    \\x09\\x09\\x09\\x09 }
    \\x09\\x09  \\x09\\x09],
    \\x09\\x09\\x09\\x09"Version": "1"
    \\x09\\x09\\x09}
    \"\"\",
        description="this is a policy example",
        force=True)
    default_user_policy_attachment = alicloud.ram.UserPolicyAttachment("default",
        policy_name=default_policy.policy_name,
        user_name=default_user.name,
        policy_type=default_policy.type)
    users_ds = alicloud.ram.get_users_output(output_file="users.txt",
        group_name=default.name,
        policy_name=default_policy.policy_name,
        policy_type="Custom",
        name_regex=default_user.name)
    pulumi.export("firstUserId", users_ds.users[0].id)
    ```


    :param _builtins.str group_name: Filter results by a specific group name. Returned users are in the specified group.
    :param Sequence[_builtins.str] ids: A list of ram user IDs.
    :param _builtins.str name_regex: A regex string to filter resulting users by their names.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str policy_name: Filter results by a specific policy name. If you set this parameter without setting `policy_type`, the later will be automatically set to `System`. Returned users are attached to the specified policy.
    :param _builtins.str policy_type: Filter results by a specific policy type. Valid values are `Custom` and `System`. If you set this parameter, you must set `policy_name` as well.
    """
    __args__ = dict()
    __args__['groupName'] = group_name
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['policyName'] = policy_name
    __args__['policyType'] = policy_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ram/getUsers:getUsers', __args__, opts=opts, typ=GetUsersResult)
    return __ret__.apply(lambda __response__: GetUsersResult(
        group_name=pulumi.get(__response__, 'group_name'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        policy_name=pulumi.get(__response__, 'policy_name'),
        policy_type=pulumi.get(__response__, 'policy_type'),
        users=pulumi.get(__response__, 'users')))
