# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CustomDataDisk',
    'CustomSystemDisk',
    'DbInstanceEndpointNodeItem',
    'DdrInstanceParameter',
    'DdrInstancePgHbaConf',
    'InstanceBabelfishConfig',
    'InstanceParameter',
    'InstancePgHbaConf',
    'InstanceServerlessConfig',
    'RdsCloneDbInstanceParameter',
    'RdsCloneDbInstancePgHbaConf',
    'RdsCloneDbInstanceServerlessConfig',
    'RdsDbProxyReadOnlyInstanceWeight',
    'RdsParameterGroupParamDetail',
    'RdsUpgradeDbInstanceParameter',
    'RdsUpgradeDbInstancePgHbaConf',
    'ReadOnlyInstanceParameter',
    'GetAccountsAccountResult',
    'GetAccountsAccountDatabasePrivilegeResult',
    'GetCollationTimeZonesCollationTimeZoneResult',
    'GetCrossRegionBackupsBackupResult',
    'GetCrossRegionsRegionResult',
    'GetInstanceClassInfosInfoResult',
    'GetInstanceClassesInstanceClassResult',
    'GetInstanceClassesInstanceClassStorageRangeResult',
    'GetInstanceClassesInstanceClassZoneIdResult',
    'GetInstanceEnginesInstanceEngineResult',
    'GetInstanceEnginesInstanceEngineZoneIdResult',
    'GetInstancesInstanceResult',
    'GetInstancesInstanceHostInstanceInfoResult',
    'GetInstancesInstanceParameterResult',
    'GetModifyParameterLogsLogResult',
    'GetRdsBackupsBackupResult',
    'GetRdsParameterGroupsGroupResult',
    'GetRdsParameterGroupsGroupParamDetailResult',
    'GetSlotsSlotResult',
    'GetZonesZoneResult',
]

@pulumi.output_type
class CustomDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "performanceLevel":
            suggest = "performance_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: Optional[_builtins.str] = None,
                 performance_level: Optional[_builtins.str] = None,
                 size: Optional[_builtins.int] = None):
        """
        :param _builtins.str category: Instance storage type
               local_ssd: local SSD disk
               cloud_essd:ESSD PL1 cloud disk
        :param _builtins.str performance_level: Cloud Disk Performance
               Currently only supports PL1
        :param _builtins.int size: Instance storage space. Unit: GB.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[_builtins.str]:
        """
        Instance storage type
        local_ssd: local SSD disk
        cloud_essd:ESSD PL1 cloud disk
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[_builtins.str]:
        """
        Cloud Disk Performance
        Currently only supports PL1
        """
        return pulumi.get(self, "performance_level")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        Instance storage space. Unit: GB.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class CustomSystemDisk(dict):
    def __init__(__self__, *,
                 category: Optional[_builtins.str] = None,
                 size: Optional[_builtins.str] = None):
        """
        :param _builtins.str category: The cloud disk type of the system disk. Currently, only `cloud_essd`(ESSD cloud disk) is supported.
        :param _builtins.str size: System disk size, unit: GiB. Only ESSD PL1 is supported. Valid values range from 20 to 2048.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[_builtins.str]:
        """
        The cloud disk type of the system disk. Currently, only `cloud_essd`(ESSD cloud disk) is supported.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.str]:
        """
        System disk size, unit: GiB. Only ESSD PL1 is supported. Valid values range from 20 to 2048.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class DbInstanceEndpointNodeItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeId":
            suggest = "node_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbInstanceEndpointNodeItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbInstanceEndpointNodeItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbInstanceEndpointNodeItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_id: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.str node_id: The ID of the node.
        :param _builtins.int weight: The weight of the node. Read requests are distributed based on the weight.Valid values: 0 to 100.
        """
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> _builtins.str:
        """
        The ID of the node.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        The weight of the node. Read requests are distributed based on the weight.Valid values: 0 to 100.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class DdrInstanceParameter(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The parameter name.
        :param _builtins.str value: The parameter value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The parameter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DdrInstancePgHbaConf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "priorityId":
            suggest = "priority_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DdrInstancePgHbaConf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DdrInstancePgHbaConf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DdrInstancePgHbaConf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 database: _builtins.str,
                 method: _builtins.str,
                 priority_id: _builtins.int,
                 type: _builtins.str,
                 user: _builtins.str,
                 mask: Optional[_builtins.str] = None,
                 option: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        :param _builtins.str database: The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        :param _builtins.str method: The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        :param _builtins.int priority_id: The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        :param _builtins.str type: The type of connection to the instance. Valid values:
               * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
               * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
               * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.
               
               > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        :param _builtins.str user: The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        :param _builtins.str mask: The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        :param _builtins.str option: Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "priority_id", priority_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user", user)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)
        if option is not None:
            pulumi.set(__self__, "option", option)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        """
        The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter(name="priorityId")
    def priority_id(self) -> _builtins.int:
        """
        The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        """
        return pulumi.get(self, "priority_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of connection to the instance. Valid values:
        * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
        * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
        * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.

        > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter
    def mask(self) -> Optional[_builtins.str]:
        """
        The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        """
        return pulumi.get(self, "mask")

    @_builtins.property
    @pulumi.getter
    def option(self) -> Optional[_builtins.str]:
        """
        Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        return pulumi.get(self, "option")


@pulumi.output_type
class InstanceBabelfishConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "babelfishEnabled":
            suggest = "babelfish_enabled"
        elif key == "masterUserPassword":
            suggest = "master_user_password"
        elif key == "masterUsername":
            suggest = "master_username"
        elif key == "migrationMode":
            suggest = "migration_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceBabelfishConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceBabelfishConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceBabelfishConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 babelfish_enabled: _builtins.str,
                 master_user_password: _builtins.str,
                 master_username: _builtins.str,
                 migration_mode: _builtins.str):
        """
        :param _builtins.str babelfish_enabled: specifies whether to enable the Babelfish for the instance. If you set this parameter to **true**, you enable Babelfish for the instance. If you leave this parameter empty, you disable Babelfish for the instance.
        :param _builtins.str master_user_password: The password of the administrator account. The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. It must be 8 to 32 characters in length. The password can contain any of the following characters:! @ # $ % ^ & * () _ + - =
        :param _builtins.str master_username: The name of the administrator account. The name can contain lowercase letters, digits, and underscores (_). It must start with a letter and end with a letter or digit. It can be up to 63 characters in length and cannot start with pg.
        :param _builtins.str migration_mode: The migration mode of the instance. Valid values: **single-db** and **multi-db**.
        """
        pulumi.set(__self__, "babelfish_enabled", babelfish_enabled)
        pulumi.set(__self__, "master_user_password", master_user_password)
        pulumi.set(__self__, "master_username", master_username)
        pulumi.set(__self__, "migration_mode", migration_mode)

    @_builtins.property
    @pulumi.getter(name="babelfishEnabled")
    def babelfish_enabled(self) -> _builtins.str:
        """
        specifies whether to enable the Babelfish for the instance. If you set this parameter to **true**, you enable Babelfish for the instance. If you leave this parameter empty, you disable Babelfish for the instance.
        """
        return pulumi.get(self, "babelfish_enabled")

    @_builtins.property
    @pulumi.getter(name="masterUserPassword")
    def master_user_password(self) -> _builtins.str:
        """
        The password of the administrator account. The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. It must be 8 to 32 characters in length. The password can contain any of the following characters:! @ # $ % ^ & * () _ + - =
        """
        return pulumi.get(self, "master_user_password")

    @_builtins.property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> _builtins.str:
        """
        The name of the administrator account. The name can contain lowercase letters, digits, and underscores (_). It must start with a letter and end with a letter or digit. It can be up to 63 characters in length and cannot start with pg.
        """
        return pulumi.get(self, "master_username")

    @_builtins.property
    @pulumi.getter(name="migrationMode")
    def migration_mode(self) -> _builtins.str:
        """
        The migration mode of the instance. Valid values: **single-db** and **multi-db**.
        """
        return pulumi.get(self, "migration_mode")


@pulumi.output_type
class InstanceParameter(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The parameter name.
        :param _builtins.str value: The parameter value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The parameter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InstancePgHbaConf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "priorityId":
            suggest = "priority_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePgHbaConf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePgHbaConf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePgHbaConf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 database: _builtins.str,
                 method: _builtins.str,
                 priority_id: _builtins.int,
                 type: _builtins.str,
                 user: _builtins.str,
                 mask: Optional[_builtins.str] = None,
                 option: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        :param _builtins.str database: The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        :param _builtins.str method: The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        :param _builtins.int priority_id: The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        :param _builtins.str type: The type of connection to the instance. Valid values:
               * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
               * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
               * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.
               
               > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        :param _builtins.str user: The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        :param _builtins.str mask: The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        :param _builtins.str option: Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "priority_id", priority_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user", user)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)
        if option is not None:
            pulumi.set(__self__, "option", option)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        """
        The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter(name="priorityId")
    def priority_id(self) -> _builtins.int:
        """
        The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        """
        return pulumi.get(self, "priority_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of connection to the instance. Valid values:
        * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
        * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
        * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.

        > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter
    def mask(self) -> Optional[_builtins.str]:
        """
        The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        """
        return pulumi.get(self, "mask")

    @_builtins.property
    @pulumi.getter
    def option(self) -> Optional[_builtins.str]:
        """
        Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        return pulumi.get(self, "option")


@pulumi.output_type
class InstanceServerlessConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"
        elif key == "autoPause":
            suggest = "auto_pause"
        elif key == "switchForce":
            suggest = "switch_force"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceServerlessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceServerlessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceServerlessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_capacity: _builtins.float,
                 min_capacity: _builtins.float,
                 auto_pause: Optional[_builtins.bool] = None,
                 switch_force: Optional[_builtins.bool] = None):
        """
        :param _builtins.float max_capacity: The maximum number of RDS Capacity Units (RCUs). The value of this parameter must be greater than or equal to `min_capacity` and only supports passing integers. Valid values:
               - MySQL: 1~8
               - SQLServer: 2~8
               - PostgreSQL: 1~12
        :param _builtins.float min_capacity: The minimum number of RCUs. The value of this parameter must be less than or equal to `max_capacity`. Valid values:
               - MySQL: 0.5~8
               - SQLServer: 2~8 \\(Supports integers only\\).
               - PostgreSQL: 0.5~12
        :param _builtins.bool switch_force: Specifies whether to enable the forced scaling feature for the serverless instance. Valid values:
               - true: enables the feature.
               - false: disables the feature. This is the default value.
               > - Only MySQL Serverless instances need to set this parameter. After enabling this parameter, there will be a flash break within 1 minute when the instance is forced to expand or shrink. Please use it with caution according to the actual situation.
               > - The elastic scaling of an instance RCU usually takes effect immediately, but in some special circumstances (such as during large transaction execution), it is not possible to complete scaling immediately. In this case, this parameter can be enabled to force scaling.
        """
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "min_capacity", min_capacity)
        if auto_pause is not None:
            pulumi.set(__self__, "auto_pause", auto_pause)
        if switch_force is not None:
            pulumi.set(__self__, "switch_force", switch_force)

    @_builtins.property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> _builtins.float:
        """
        The maximum number of RDS Capacity Units (RCUs). The value of this parameter must be greater than or equal to `min_capacity` and only supports passing integers. Valid values:
        - MySQL: 1~8
        - SQLServer: 2~8
        - PostgreSQL: 1~12
        """
        return pulumi.get(self, "max_capacity")

    @_builtins.property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> _builtins.float:
        """
        The minimum number of RCUs. The value of this parameter must be less than or equal to `max_capacity`. Valid values:
        - MySQL: 0.5~8
        - SQLServer: 2~8 \\(Supports integers only\\).
        - PostgreSQL: 0.5~12
        """
        return pulumi.get(self, "min_capacity")

    @_builtins.property
    @pulumi.getter(name="autoPause")
    def auto_pause(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "auto_pause")

    @_builtins.property
    @pulumi.getter(name="switchForce")
    def switch_force(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable the forced scaling feature for the serverless instance. Valid values:
        - true: enables the feature.
        - false: disables the feature. This is the default value.
        > - Only MySQL Serverless instances need to set this parameter. After enabling this parameter, there will be a flash break within 1 minute when the instance is forced to expand or shrink. Please use it with caution according to the actual situation.
        > - The elastic scaling of an instance RCU usually takes effect immediately, but in some special circumstances (such as during large transaction execution), it is not possible to complete scaling immediately. In this case, this parameter can be enabled to force scaling.
        """
        return pulumi.get(self, "switch_force")


@pulumi.output_type
class RdsCloneDbInstanceParameter(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The parameters name.
        :param _builtins.str value: The parameters value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The parameters name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The parameters value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RdsCloneDbInstancePgHbaConf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "priorityId":
            suggest = "priority_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RdsCloneDbInstancePgHbaConf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RdsCloneDbInstancePgHbaConf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RdsCloneDbInstancePgHbaConf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 database: _builtins.str,
                 method: _builtins.str,
                 priority_id: _builtins.int,
                 type: _builtins.str,
                 user: _builtins.str,
                 mask: Optional[_builtins.str] = None,
                 option: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        :param _builtins.str database: The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        :param _builtins.str method: The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        :param _builtins.int priority_id: The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        :param _builtins.str type: The type of connection to the instance. Valid values:
               * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
               * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
               * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.
               
               > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        :param _builtins.str user: The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        :param _builtins.str mask: The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        :param _builtins.str option: Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "priority_id", priority_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user", user)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)
        if option is not None:
            pulumi.set(__self__, "option", option)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        """
        The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter(name="priorityId")
    def priority_id(self) -> _builtins.int:
        """
        The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        """
        return pulumi.get(self, "priority_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of connection to the instance. Valid values:
        * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
        * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
        * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.

        > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter
    def mask(self) -> Optional[_builtins.str]:
        """
        The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        """
        return pulumi.get(self, "mask")

    @_builtins.property
    @pulumi.getter
    def option(self) -> Optional[_builtins.str]:
        """
        Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        return pulumi.get(self, "option")


@pulumi.output_type
class RdsCloneDbInstanceServerlessConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"
        elif key == "autoPause":
            suggest = "auto_pause"
        elif key == "switchForce":
            suggest = "switch_force"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RdsCloneDbInstanceServerlessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RdsCloneDbInstanceServerlessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RdsCloneDbInstanceServerlessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_capacity: _builtins.float,
                 min_capacity: _builtins.float,
                 auto_pause: Optional[_builtins.bool] = None,
                 switch_force: Optional[_builtins.bool] = None):
        """
        :param _builtins.float max_capacity: The maximum number of RDS Capacity Units (RCUs). The value of this parameter must be greater than or equal to `min_capacity` and only supports passing integers. Valid values:
               - MySQL: 1~8
               - SQLServer: 2~8
               - PostgreSQL: 1~12
        :param _builtins.float min_capacity: The minimum number of RCUs. The value of this parameter must be less than or equal to `max_capacity`. Valid values:
               - MySQL: 0.5~8
               - SQLServer: 2~8 \\(Supports integers only\\).
               - PostgreSQL: 0.5~12
        :param _builtins.bool auto_pause: Specifies whether to enable the smart startup and stop feature for the serverless instance. Valid values:
               - true: enables the feature.
               - false: disables the feature. This is the default value.
               > - Only MySQL Serverless instances need to set this parameter. If there is no connection within 10 minutes, it will enter a paused state and automatically wake up when the connection enters.
        :param _builtins.bool switch_force: Specifies whether to enable the forced scaling feature for the serverless instance. Valid values:
               - true: enables the feature.
               - false: disables the feature. This is the default value.
               > - Only MySQL Serverless instances need to set this parameter. After enabling this parameter, there will be a flash break within 1 minute when the instance is forced to expand or shrink. Please use it with caution according to the actual situation.
               > - The elastic scaling of an instance RCU usually takes effect immediately, but in some special circumstances (such as during large transaction execution), it is not possible to complete scaling immediately. In this case, this parameter can be enabled to force scaling.
        """
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "min_capacity", min_capacity)
        if auto_pause is not None:
            pulumi.set(__self__, "auto_pause", auto_pause)
        if switch_force is not None:
            pulumi.set(__self__, "switch_force", switch_force)

    @_builtins.property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> _builtins.float:
        """
        The maximum number of RDS Capacity Units (RCUs). The value of this parameter must be greater than or equal to `min_capacity` and only supports passing integers. Valid values:
        - MySQL: 1~8
        - SQLServer: 2~8
        - PostgreSQL: 1~12
        """
        return pulumi.get(self, "max_capacity")

    @_builtins.property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> _builtins.float:
        """
        The minimum number of RCUs. The value of this parameter must be less than or equal to `max_capacity`. Valid values:
        - MySQL: 0.5~8
        - SQLServer: 2~8 \\(Supports integers only\\).
        - PostgreSQL: 0.5~12
        """
        return pulumi.get(self, "min_capacity")

    @_builtins.property
    @pulumi.getter(name="autoPause")
    def auto_pause(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable the smart startup and stop feature for the serverless instance. Valid values:
        - true: enables the feature.
        - false: disables the feature. This is the default value.
        > - Only MySQL Serverless instances need to set this parameter. If there is no connection within 10 minutes, it will enter a paused state and automatically wake up when the connection enters.
        """
        return pulumi.get(self, "auto_pause")

    @_builtins.property
    @pulumi.getter(name="switchForce")
    def switch_force(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable the forced scaling feature for the serverless instance. Valid values:
        - true: enables the feature.
        - false: disables the feature. This is the default value.
        > - Only MySQL Serverless instances need to set this parameter. After enabling this parameter, there will be a flash break within 1 minute when the instance is forced to expand or shrink. Please use it with caution according to the actual situation.
        > - The elastic scaling of an instance RCU usually takes effect immediately, but in some special circumstances (such as during large transaction execution), it is not possible to complete scaling immediately. In this case, this parameter can be enabled to force scaling.
        """
        return pulumi.get(self, "switch_force")


@pulumi.output_type
class RdsDbProxyReadOnlyInstanceWeight(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RdsDbProxyReadOnlyInstanceWeight. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RdsDbProxyReadOnlyInstanceWeight.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RdsDbProxyReadOnlyInstanceWeight.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_id: _builtins.str,
                 weight: _builtins.str):
        """
        :param _builtins.str instance_id: The Id of the instance and its read-only instances that can run database.
        :param _builtins.str weight: Weight of instances that can run the database and their read-only instances. Read weights increase in increments of 100, and the maximum read weight is 10000.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The Id of the instance and its read-only instances that can run database.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.str:
        """
        Weight of instances that can run the database and their read-only instances. Read weights increase in increments of 100, and the maximum read weight is 10000.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class RdsParameterGroupParamDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "paramName":
            suggest = "param_name"
        elif key == "paramValue":
            suggest = "param_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RdsParameterGroupParamDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RdsParameterGroupParamDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RdsParameterGroupParamDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 param_name: _builtins.str,
                 param_value: _builtins.str):
        """
        :param _builtins.str param_name: The name of a parameter.
        :param _builtins.str param_value: The value of a parameter.
        """
        pulumi.set(__self__, "param_name", param_name)
        pulumi.set(__self__, "param_value", param_value)

    @_builtins.property
    @pulumi.getter(name="paramName")
    def param_name(self) -> _builtins.str:
        """
        The name of a parameter.
        """
        return pulumi.get(self, "param_name")

    @_builtins.property
    @pulumi.getter(name="paramValue")
    def param_value(self) -> _builtins.str:
        """
        The value of a parameter.
        """
        return pulumi.get(self, "param_value")


@pulumi.output_type
class RdsUpgradeDbInstanceParameter(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The parameter name.
        :param _builtins.str value: The parameter value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The parameter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RdsUpgradeDbInstancePgHbaConf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "priorityId":
            suggest = "priority_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RdsUpgradeDbInstancePgHbaConf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RdsUpgradeDbInstancePgHbaConf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RdsUpgradeDbInstancePgHbaConf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 database: _builtins.str,
                 method: _builtins.str,
                 priority_id: _builtins.int,
                 type: _builtins.str,
                 user: _builtins.str,
                 mask: Optional[_builtins.str] = None,
                 option: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        :param _builtins.str database: The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        :param _builtins.str method: The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        :param _builtins.int priority_id: The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        :param _builtins.str type: The type of connection to the instance. Valid values:
               * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
               * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
               * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.
               
               > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        :param _builtins.str user: The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        :param _builtins.str mask: The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        :param _builtins.str option: Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "priority_id", priority_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user", user)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)
        if option is not None:
            pulumi.set(__self__, "option", option)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        """
        The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter(name="priorityId")
    def priority_id(self) -> _builtins.int:
        """
        The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        """
        return pulumi.get(self, "priority_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of connection to the instance. Valid values:
        * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
        * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
        * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.

        > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter
    def mask(self) -> Optional[_builtins.str]:
        """
        The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        """
        return pulumi.get(self, "mask")

    @_builtins.property
    @pulumi.getter
    def option(self) -> Optional[_builtins.str]:
        """
        Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        return pulumi.get(self, "option")


@pulumi.output_type
class ReadOnlyInstanceParameter(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The parameter name.
        :param _builtins.str value: The parameter value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The parameter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAccountsAccountResult(dict):
    def __init__(__self__, *,
                 account_description: _builtins.str,
                 account_name: _builtins.str,
                 account_type: _builtins.str,
                 database_privileges: Sequence['outputs.GetAccountsAccountDatabasePrivilegeResult'],
                 id: _builtins.str,
                 priv_exceeded: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str account_description: Database description.
        :param _builtins.str account_name: Name of database account.
        :param _builtins.str account_type: Privilege type of account.
        :param Sequence['GetAccountsAccountDatabasePrivilegeArgs'] database_privileges: A list of database permissions the account has.
        :param _builtins.str id: The ID of the Account.
        :param _builtins.str priv_exceeded: Whether the maximum number of databases managed by the account is exceeded.
        :param _builtins.str status: The status of the resource.
        """
        pulumi.set(__self__, "account_description", account_description)
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "account_type", account_type)
        pulumi.set(__self__, "database_privileges", database_privileges)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "priv_exceeded", priv_exceeded)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accountDescription")
    def account_description(self) -> _builtins.str:
        """
        Database description.
        """
        return pulumi.get(self, "account_description")

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> _builtins.str:
        """
        Name of database account.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> _builtins.str:
        """
        Privilege type of account.
        """
        return pulumi.get(self, "account_type")

    @_builtins.property
    @pulumi.getter(name="databasePrivileges")
    def database_privileges(self) -> Sequence['outputs.GetAccountsAccountDatabasePrivilegeResult']:
        """
        A list of database permissions the account has.
        """
        return pulumi.get(self, "database_privileges")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Account.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="privExceeded")
    def priv_exceeded(self) -> _builtins.str:
        """
        Whether the maximum number of databases managed by the account is exceeded.
        """
        return pulumi.get(self, "priv_exceeded")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetAccountsAccountDatabasePrivilegeResult(dict):
    def __init__(__self__, *,
                 account_privilege: _builtins.str,
                 account_privilege_detail: _builtins.str,
                 db_name: _builtins.str):
        """
        :param _builtins.str account_privilege: The type of permission for the account.
        :param _builtins.str account_privilege_detail: The specific permissions corresponding to the type of account permissions.
        :param _builtins.str db_name: Database name.
        """
        pulumi.set(__self__, "account_privilege", account_privilege)
        pulumi.set(__self__, "account_privilege_detail", account_privilege_detail)
        pulumi.set(__self__, "db_name", db_name)

    @_builtins.property
    @pulumi.getter(name="accountPrivilege")
    def account_privilege(self) -> _builtins.str:
        """
        The type of permission for the account.
        """
        return pulumi.get(self, "account_privilege")

    @_builtins.property
    @pulumi.getter(name="accountPrivilegeDetail")
    def account_privilege_detail(self) -> _builtins.str:
        """
        The specific permissions corresponding to the type of account permissions.
        """
        return pulumi.get(self, "account_privilege_detail")

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> _builtins.str:
        """
        Database name.
        """
        return pulumi.get(self, "db_name")


@pulumi.output_type
class GetCollationTimeZonesCollationTimeZoneResult(dict):
    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 standard_time_offset: Optional[_builtins.str] = None,
                 time_zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str description: The code of the instance type.
        :param _builtins.str standard_time_offset: The offset of the UTC time. The offset is in the following format: (UTC+<i>HH:mm</i>).
        :param _builtins.str time_zone: The time zone that is available for use in ApsaraDB RDS.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if standard_time_offset is not None:
            pulumi.set(__self__, "standard_time_offset", standard_time_offset)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The code of the instance type.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="standardTimeOffset")
    def standard_time_offset(self) -> Optional[_builtins.str]:
        """
        The offset of the UTC time. The offset is in the following format: (UTC+<i>HH:mm</i>).
        """
        return pulumi.get(self, "standard_time_offset")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[_builtins.str]:
        """
        The time zone that is available for use in ApsaraDB RDS.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class GetCrossRegionBackupsBackupResult(dict):
    def __init__(__self__, *,
                 backup_end_time: _builtins.str,
                 backup_method: _builtins.str,
                 backup_set_scale: _builtins.str,
                 backup_set_status: _builtins.int,
                 backup_start_time: _builtins.str,
                 backup_type: _builtins.str,
                 category: _builtins.str,
                 consistent_time: _builtins.str,
                 cross_backup_download_link: _builtins.str,
                 cross_backup_id: _builtins.str,
                 cross_backup_region: _builtins.str,
                 cross_backup_set_file: _builtins.str,
                 cross_backup_set_location: _builtins.str,
                 cross_backup_set_size: _builtins.int,
                 db_instance_storage_type: _builtins.str,
                 engine: _builtins.str,
                 engine_version: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.int,
                 recovery_begin_time: _builtins.str,
                 recovery_end_time: _builtins.str,
                 restore_regions: Sequence[_builtins.str]):
        """
        :param _builtins.str backup_end_time: The time when the cross-region data backup file was generated.
        :param _builtins.str backup_method: The method that is used to generate the cross-region data backup file. Valid values:
               `L` - logical backup.
               `P` - physical backup.
        :param _builtins.str backup_set_scale: The level at which the cross-region data backup file is generated.
               `0` - instance-level backup.
               `1` - database-level backup.
        :param _builtins.int backup_set_status: TThe status of the cross-region data backup. Valid values:
               `0` - The cross-region data backup is successful.
               `1` - The cross-region data backup failed.
        :param _builtins.str backup_start_time: The time when the cross-region data backup started.
        :param _builtins.str backup_type: The type of the cross-region data backup. Valid values:F: full data backup
               `F` - full data backup.
               `I` - incremental data backup.
        :param _builtins.str category: The RDS edition of the instance. Valid values:
               `Basic` - Basic Edition.
               `HighAvailability` - High-availability Edition.
               `Finance` - Enterprise Edition. This edition is supported only by the China site (aliyun.com).
        :param _builtins.str consistent_time: The point in time that is indicated by the data in the cross-region data backup file.
        :param _builtins.str cross_backup_download_link: The external URL from which you can download the cross-region data backup file.
        :param _builtins.str cross_backup_id: The ID of the cross-region data backup file.
        :param _builtins.str cross_backup_region: The ID of the destination region where the cross-region data backup file of the instance is stored.
        :param _builtins.str cross_backup_set_file: The name of the compressed package that contains the cross-region data backup file.
        :param _builtins.str cross_backup_set_location: The location where the cross-region data backup file is stored.
        :param _builtins.int cross_backup_set_size: The size of the cross-region data backup file. Unit: bytes.
        :param _builtins.str db_instance_storage_type: The storage type.
        :param _builtins.str engine: The engine of the database.
        :param _builtins.str engine_version: The version of the database engine.
        :param _builtins.str id: The ID of the cross-region data backup file.
        :param _builtins.int instance_id: The ID of the instance. This parameter is used to determine whether the instance that generates the cross-region data backup file is a primary or secondary instance.
        :param _builtins.str recovery_begin_time: The start time to which data can be restored. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param _builtins.str recovery_end_time: The end time to which data can be restored. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param Sequence[_builtins.str] restore_regions: An array that consists of the regions to which the cross-region data backup file can be restored.
        """
        pulumi.set(__self__, "backup_end_time", backup_end_time)
        pulumi.set(__self__, "backup_method", backup_method)
        pulumi.set(__self__, "backup_set_scale", backup_set_scale)
        pulumi.set(__self__, "backup_set_status", backup_set_status)
        pulumi.set(__self__, "backup_start_time", backup_start_time)
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "consistent_time", consistent_time)
        pulumi.set(__self__, "cross_backup_download_link", cross_backup_download_link)
        pulumi.set(__self__, "cross_backup_id", cross_backup_id)
        pulumi.set(__self__, "cross_backup_region", cross_backup_region)
        pulumi.set(__self__, "cross_backup_set_file", cross_backup_set_file)
        pulumi.set(__self__, "cross_backup_set_location", cross_backup_set_location)
        pulumi.set(__self__, "cross_backup_set_size", cross_backup_set_size)
        pulumi.set(__self__, "db_instance_storage_type", db_instance_storage_type)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "recovery_begin_time", recovery_begin_time)
        pulumi.set(__self__, "recovery_end_time", recovery_end_time)
        pulumi.set(__self__, "restore_regions", restore_regions)

    @_builtins.property
    @pulumi.getter(name="backupEndTime")
    def backup_end_time(self) -> _builtins.str:
        """
        The time when the cross-region data backup file was generated.
        """
        return pulumi.get(self, "backup_end_time")

    @_builtins.property
    @pulumi.getter(name="backupMethod")
    def backup_method(self) -> _builtins.str:
        """
        The method that is used to generate the cross-region data backup file. Valid values:
        `L` - logical backup.
        `P` - physical backup.
        """
        return pulumi.get(self, "backup_method")

    @_builtins.property
    @pulumi.getter(name="backupSetScale")
    def backup_set_scale(self) -> _builtins.str:
        """
        The level at which the cross-region data backup file is generated.
        `0` - instance-level backup.
        `1` - database-level backup.
        """
        return pulumi.get(self, "backup_set_scale")

    @_builtins.property
    @pulumi.getter(name="backupSetStatus")
    def backup_set_status(self) -> _builtins.int:
        """
        TThe status of the cross-region data backup. Valid values:
        `0` - The cross-region data backup is successful.
        `1` - The cross-region data backup failed.
        """
        return pulumi.get(self, "backup_set_status")

    @_builtins.property
    @pulumi.getter(name="backupStartTime")
    def backup_start_time(self) -> _builtins.str:
        """
        The time when the cross-region data backup started.
        """
        return pulumi.get(self, "backup_start_time")

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> _builtins.str:
        """
        The type of the cross-region data backup. Valid values:F: full data backup
        `F` - full data backup.
        `I` - incremental data backup.
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter
    def category(self) -> _builtins.str:
        """
        The RDS edition of the instance. Valid values:
        `Basic` - Basic Edition.
        `HighAvailability` - High-availability Edition.
        `Finance` - Enterprise Edition. This edition is supported only by the China site (aliyun.com).
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="consistentTime")
    def consistent_time(self) -> _builtins.str:
        """
        The point in time that is indicated by the data in the cross-region data backup file.
        """
        return pulumi.get(self, "consistent_time")

    @_builtins.property
    @pulumi.getter(name="crossBackupDownloadLink")
    def cross_backup_download_link(self) -> _builtins.str:
        """
        The external URL from which you can download the cross-region data backup file.
        """
        return pulumi.get(self, "cross_backup_download_link")

    @_builtins.property
    @pulumi.getter(name="crossBackupId")
    def cross_backup_id(self) -> _builtins.str:
        """
        The ID of the cross-region data backup file.
        """
        return pulumi.get(self, "cross_backup_id")

    @_builtins.property
    @pulumi.getter(name="crossBackupRegion")
    def cross_backup_region(self) -> _builtins.str:
        """
        The ID of the destination region where the cross-region data backup file of the instance is stored.
        """
        return pulumi.get(self, "cross_backup_region")

    @_builtins.property
    @pulumi.getter(name="crossBackupSetFile")
    def cross_backup_set_file(self) -> _builtins.str:
        """
        The name of the compressed package that contains the cross-region data backup file.
        """
        return pulumi.get(self, "cross_backup_set_file")

    @_builtins.property
    @pulumi.getter(name="crossBackupSetLocation")
    def cross_backup_set_location(self) -> _builtins.str:
        """
        The location where the cross-region data backup file is stored.
        """
        return pulumi.get(self, "cross_backup_set_location")

    @_builtins.property
    @pulumi.getter(name="crossBackupSetSize")
    def cross_backup_set_size(self) -> _builtins.int:
        """
        The size of the cross-region data backup file. Unit: bytes.
        """
        return pulumi.get(self, "cross_backup_set_size")

    @_builtins.property
    @pulumi.getter(name="dbInstanceStorageType")
    def db_instance_storage_type(self) -> _builtins.str:
        """
        The storage type.
        """
        return pulumi.get(self, "db_instance_storage_type")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> _builtins.str:
        """
        The engine of the database.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> _builtins.str:
        """
        The version of the database engine.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the cross-region data backup file.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.int:
        """
        The ID of the instance. This parameter is used to determine whether the instance that generates the cross-region data backup file is a primary or secondary instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="recoveryBeginTime")
    def recovery_begin_time(self) -> _builtins.str:
        """
        The start time to which data can be restored. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "recovery_begin_time")

    @_builtins.property
    @pulumi.getter(name="recoveryEndTime")
    def recovery_end_time(self) -> _builtins.str:
        """
        The end time to which data can be restored. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "recovery_end_time")

    @_builtins.property
    @pulumi.getter(name="restoreRegions")
    def restore_regions(self) -> Sequence[_builtins.str]:
        """
        An array that consists of the regions to which the cross-region data backup file can be restored.
        """
        return pulumi.get(self, "restore_regions")


@pulumi.output_type
class GetCrossRegionsRegionResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: ID of the region.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the region.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetInstanceClassInfosInfoResult(dict):
    def __init__(__self__, *,
                 class_code: Optional[_builtins.str] = None,
                 class_group: Optional[_builtins.str] = None,
                 cpu: Optional[_builtins.str] = None,
                 instruction_set_arch: Optional[_builtins.str] = None,
                 max_connections: Optional[_builtins.str] = None,
                 max_iombps: Optional[_builtins.str] = None,
                 max_iops: Optional[_builtins.str] = None,
                 memory_class: Optional[_builtins.str] = None,
                 reference_price: Optional[_builtins.str] = None):
        """
        :param _builtins.str class_code: The code of the instance type.
        :param _builtins.str class_group: The instance family of the instance.
        :param _builtins.str cpu: The number of cores that are supported by the instance type. Unit: cores.
        :param _builtins.str instruction_set_arch: The architecture of the instance type.
        :param _builtins.str max_connections: The maximum number of connections that are supported by the instance type. Unit: connections.
        :param _builtins.str max_iombps: The maximum I/O bandwidth that is supported by the instance type. Unit: Mbit/s.
        :param _builtins.str max_iops: The maximum input/output operations per second (IOPS) that is supported by the instance type. Unit: operations per second.
        :param _builtins.str memory_class: The memory capacity that is supported by the instance type. Unit: GB.
        :param _builtins.str reference_price: The fee that you must pay for the instance type. Unit: cent (USD).
        """
        if class_code is not None:
            pulumi.set(__self__, "class_code", class_code)
        if class_group is not None:
            pulumi.set(__self__, "class_group", class_group)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if instruction_set_arch is not None:
            pulumi.set(__self__, "instruction_set_arch", instruction_set_arch)
        if max_connections is not None:
            pulumi.set(__self__, "max_connections", max_connections)
        if max_iombps is not None:
            pulumi.set(__self__, "max_iombps", max_iombps)
        if max_iops is not None:
            pulumi.set(__self__, "max_iops", max_iops)
        if memory_class is not None:
            pulumi.set(__self__, "memory_class", memory_class)
        if reference_price is not None:
            pulumi.set(__self__, "reference_price", reference_price)

    @_builtins.property
    @pulumi.getter(name="classCode")
    def class_code(self) -> Optional[_builtins.str]:
        """
        The code of the instance type.
        """
        return pulumi.get(self, "class_code")

    @_builtins.property
    @pulumi.getter(name="classGroup")
    def class_group(self) -> Optional[_builtins.str]:
        """
        The instance family of the instance.
        """
        return pulumi.get(self, "class_group")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[_builtins.str]:
        """
        The number of cores that are supported by the instance type. Unit: cores.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="instructionSetArch")
    def instruction_set_arch(self) -> Optional[_builtins.str]:
        """
        The architecture of the instance type.
        """
        return pulumi.get(self, "instruction_set_arch")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> Optional[_builtins.str]:
        """
        The maximum number of connections that are supported by the instance type. Unit: connections.
        """
        return pulumi.get(self, "max_connections")

    @_builtins.property
    @pulumi.getter(name="maxIombps")
    def max_iombps(self) -> Optional[_builtins.str]:
        """
        The maximum I/O bandwidth that is supported by the instance type. Unit: Mbit/s.
        """
        return pulumi.get(self, "max_iombps")

    @_builtins.property
    @pulumi.getter(name="maxIops")
    def max_iops(self) -> Optional[_builtins.str]:
        """
        The maximum input/output operations per second (IOPS) that is supported by the instance type. Unit: operations per second.
        """
        return pulumi.get(self, "max_iops")

    @_builtins.property
    @pulumi.getter(name="memoryClass")
    def memory_class(self) -> Optional[_builtins.str]:
        """
        The memory capacity that is supported by the instance type. Unit: GB.
        """
        return pulumi.get(self, "memory_class")

    @_builtins.property
    @pulumi.getter(name="referencePrice")
    def reference_price(self) -> Optional[_builtins.str]:
        """
        The fee that you must pay for the instance type. Unit: cent (USD).
        """
        return pulumi.get(self, "reference_price")


@pulumi.output_type
class GetInstanceClassesInstanceClassResult(dict):
    def __init__(__self__, *,
                 instance_class: _builtins.str,
                 price: _builtins.str,
                 storage_range: 'outputs.GetInstanceClassesInstanceClassStorageRangeResult',
                 zone_ids: Sequence['outputs.GetInstanceClassesInstanceClassZoneIdResult']):
        """
        :param _builtins.str instance_class: DB Instance available class.
        :param 'GetInstanceClassesInstanceClassStorageRangeArgs' storage_range: DB Instance available storage range.
        :param Sequence['GetInstanceClassesInstanceClassZoneIdArgs'] zone_ids: A list of Zone to launch the DB instance.
        """
        pulumi.set(__self__, "instance_class", instance_class)
        pulumi.set(__self__, "price", price)
        pulumi.set(__self__, "storage_range", storage_range)
        pulumi.set(__self__, "zone_ids", zone_ids)

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> _builtins.str:
        """
        DB Instance available class.
        """
        return pulumi.get(self, "instance_class")

    @_builtins.property
    @pulumi.getter
    def price(self) -> _builtins.str:
        return pulumi.get(self, "price")

    @_builtins.property
    @pulumi.getter(name="storageRange")
    def storage_range(self) -> 'outputs.GetInstanceClassesInstanceClassStorageRangeResult':
        """
        DB Instance available storage range.
        """
        return pulumi.get(self, "storage_range")

    @_builtins.property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> Sequence['outputs.GetInstanceClassesInstanceClassZoneIdResult']:
        """
        A list of Zone to launch the DB instance.
        """
        return pulumi.get(self, "zone_ids")


@pulumi.output_type
class GetInstanceClassesInstanceClassStorageRangeResult(dict):
    def __init__(__self__, *,
                 max: _builtins.str,
                 min: _builtins.str,
                 step: _builtins.str):
        """
        :param _builtins.str max: DB Instance available storage max value.
        :param _builtins.str min: DB Instance available storage min value.
        :param _builtins.str step: DB Instance available storage increase step.
        """
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)
        pulumi.set(__self__, "step", step)

    @_builtins.property
    @pulumi.getter
    def max(self) -> _builtins.str:
        """
        DB Instance available storage max value.
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> _builtins.str:
        """
        DB Instance available storage min value.
        """
        return pulumi.get(self, "min")

    @_builtins.property
    @pulumi.getter
    def step(self) -> _builtins.str:
        """
        DB Instance available storage increase step.
        """
        return pulumi.get(self, "step")


@pulumi.output_type
class GetInstanceClassesInstanceClassZoneIdResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 sub_zone_ids: Sequence[_builtins.str]):
        """
        :param _builtins.str id: The Zone to launch the DB instance
        :param Sequence[_builtins.str] sub_zone_ids: A list of sub zone ids which in the id - e.g If `id` is `cn-beijing-MAZ5(a,b)`, `sub_zone_ids` will be `["cn-beijing-a", "cn-beijing-b"]`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "sub_zone_ids", sub_zone_ids)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The Zone to launch the DB instance
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="subZoneIds")
    def sub_zone_ids(self) -> Sequence[_builtins.str]:
        """
        A list of sub zone ids which in the id - e.g If `id` is `cn-beijing-MAZ5(a,b)`, `sub_zone_ids` will be `["cn-beijing-a", "cn-beijing-b"]`.
        """
        return pulumi.get(self, "sub_zone_ids")


@pulumi.output_type
class GetInstanceEnginesInstanceEngineResult(dict):
    def __init__(__self__, *,
                 category: _builtins.str,
                 engine: _builtins.str,
                 engine_version: _builtins.str,
                 zone_ids: Sequence['outputs.GetInstanceEnginesInstanceEngineZoneIdResult']):
        """
        :param _builtins.str category: DB Instance category. the value like [`Basic`, `HighAvailability`, `Finance`, `AlwaysOn`], [detail info](https://www.alibabacloud.com/help/doc-detail/69795.htm).
        :param _builtins.str engine: Database type. Valid values: "MySQL", "SQLServer", "PostgreSQL", "MariaDB". If not set, it will match all of engines.
        :param _builtins.str engine_version: Database version required by the user. Value options can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
        :param Sequence['GetInstanceEnginesInstanceEngineZoneIdArgs'] zone_ids: A list of Zone to launch the DB instance.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "zone_ids", zone_ids)

    @_builtins.property
    @pulumi.getter
    def category(self) -> _builtins.str:
        """
        DB Instance category. the value like [`Basic`, `HighAvailability`, `Finance`, `AlwaysOn`], [detail info](https://www.alibabacloud.com/help/doc-detail/69795.htm).
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> _builtins.str:
        """
        Database type. Valid values: "MySQL", "SQLServer", "PostgreSQL", "MariaDB". If not set, it will match all of engines.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> _builtins.str:
        """
        Database version required by the user. Value options can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> Sequence['outputs.GetInstanceEnginesInstanceEngineZoneIdResult']:
        """
        A list of Zone to launch the DB instance.
        """
        return pulumi.get(self, "zone_ids")


@pulumi.output_type
class GetInstanceEnginesInstanceEngineZoneIdResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 sub_zone_ids: Sequence[_builtins.str]):
        """
        :param _builtins.str id: The Zone to launch the DB instance
        :param Sequence[_builtins.str] sub_zone_ids: A list of sub zone ids which in the id - e.g If `id` is `cn-beijing-MAZ5(a,b)`, `sub_zone_ids` will be `["cn-beijing-a", "cn-beijing-b"]`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "sub_zone_ids", sub_zone_ids)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The Zone to launch the DB instance
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="subZoneIds")
    def sub_zone_ids(self) -> Sequence[_builtins.str]:
        """
        A list of sub zone ids which in the id - e.g If `id` is `cn-beijing-MAZ5(a,b)`, `sub_zone_ids` will be `["cn-beijing-a", "cn-beijing-b"]`.
        """
        return pulumi.get(self, "sub_zone_ids")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 acl: _builtins.str,
                 availability_zone: _builtins.str,
                 ca_type: _builtins.str,
                 charge_type: _builtins.str,
                 client_ca_cert: _builtins.str,
                 client_ca_cert_expire_time: _builtins.str,
                 client_cert_revocation_list: _builtins.str,
                 connection_mode: _builtins.str,
                 connection_string: _builtins.str,
                 create_time: _builtins.str,
                 creator: _builtins.str,
                 db_instance_storage_type: _builtins.str,
                 db_instance_type: _builtins.str,
                 db_type: _builtins.str,
                 delete_date: _builtins.str,
                 deletion_protection: _builtins.bool,
                 description: _builtins.str,
                 encryption_key: _builtins.str,
                 encryption_key_status: _builtins.str,
                 engine: _builtins.str,
                 engine_version: _builtins.str,
                 expire_time: _builtins.str,
                 guard_instance_id: _builtins.str,
                 ha_mode: _builtins.str,
                 host_instance_infos: Sequence['outputs.GetInstancesInstanceHostInstanceInfoResult'],
                 id: _builtins.str,
                 instance_storage: _builtins.int,
                 instance_type: _builtins.str,
                 key_usage: _builtins.str,
                 last_modify_status: _builtins.str,
                 master_instance_id: _builtins.str,
                 master_zone: _builtins.str,
                 material_expire_time: _builtins.str,
                 modify_status_reason: _builtins.str,
                 name: _builtins.str,
                 net_type: _builtins.str,
                 origin: _builtins.str,
                 parameters: Sequence['outputs.GetInstancesInstanceParameterResult'],
                 port: _builtins.str,
                 readonly_instance_ids: Sequence[_builtins.str],
                 region_id: _builtins.str,
                 replication_acl: _builtins.str,
                 require_update: _builtins.str,
                 require_update_item: _builtins.str,
                 require_update_reason: _builtins.str,
                 server_ca_url: _builtins.str,
                 server_cert: _builtins.str,
                 server_key: _builtins.str,
                 ssl_create_time: _builtins.str,
                 ssl_enabled: _builtins.str,
                 ssl_expire_time: _builtins.str,
                 status: _builtins.str,
                 sync_mode: _builtins.str,
                 temp_instance_id: _builtins.str,
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str,
                 zone_id_slave_a: _builtins.str,
                 zone_id_slave_b: _builtins.str):
        """
        :param _builtins.str acl: (Available in 1.124.1+) The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param _builtins.str availability_zone: Availability zone.
        :param _builtins.str ca_type: (Available in 1.124.1+) The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
               - aliyun: a cloud certificate
               - custom: a custom certificate
        :param _builtins.str charge_type: Billing method. Value options: `Postpaid` for Pay-As-You-Go and `Prepaid` for subscription.
        :param _builtins.str client_ca_cert: (Available in 1.124.1+) The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        :param _builtins.str client_ca_cert_expire_time: (Available in 1.124.1+) The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with cloud disks. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC. This parameter is not supported now.
        :param _builtins.str client_cert_revocation_list: (Available in 1.124.1+) The certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        :param _builtins.str connection_mode: `Standard` for standard access mode and `Safe` for high security access mode.
        :param _builtins.str connection_string: (Available in 1.70.3+) RDS database connection string.
        :param _builtins.str create_time: Creation time of the instance.
        :param _builtins.str creator: (Available in 1.124.3+) The creator of the encryption key.
        :param _builtins.str db_instance_storage_type: (Available in 1.70.3+) The storage type of the instance.
        :param _builtins.str db_instance_type: (Available in 1.197.0+) The type of instance.
        :param _builtins.str db_type: `Primary` for primary instance, `Readonly` for read-only instance, `Guard` for disaster recovery instance, and `Temp` for temporary instance.
        :param _builtins.str delete_date: (Available in 1.124.3+) The estimated time when the encryption key will be deleted. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param _builtins.bool deletion_protection: (Available in 1.167.0+) Indicates whether the release protection feature is enabled for the instance. Valid values:
               * **true**: The release protection feature is enabled.
               * **false**: The release protection feature is disabled.
        :param _builtins.str description: (Available in 1.124.3+) The description of the encryption key.
        :param _builtins.str encryption_key: (Available in 1.124.3+) The ID of the encryption key.
        :param _builtins.str encryption_key_status: (Available in 1.124.3+) The status of the encryption key. Valid values:
               - Enabled
               - Disabled
        :param _builtins.str engine: Database type. Options are `MySQL`, `SQLServer`, `PostgreSQL`, `MariaDB`. If no value is specified, all types are returned.
        :param _builtins.str engine_version: Database version.
        :param _builtins.str expire_time: Expiration time. Pay-As-You-Go instances never expire.
        :param _builtins.str guard_instance_id: If a disaster recovery instance is attached to the current instance, the ID of the disaster recovery instance applies.
        :param _builtins.str ha_mode: (Available since v1.209.1) The high availability mode of the instance.
        :param Sequence['GetInstancesInstanceHostInstanceInfoArgs'] host_instance_infos: (Available since v1.209.1) An array that consists of the information of the primary and secondary instances.
        :param _builtins.str id: The ID of the RDS instance.
        :param _builtins.int instance_storage: (Available in 1.70.3+) User-defined DB instance storage space.
        :param _builtins.str instance_type: Sizing of the RDS instance.
        :param _builtins.str key_usage: (Available in 1.124.3+) The purpose of the encryption key.
        :param _builtins.str last_modify_status: (Available in 1.124.1+) The status of the SSL link. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
               - success
               - setting
               - failed
        :param _builtins.str master_instance_id: ID of the primary instance. If this parameter is not returned, the current instance is a primary instance.
        :param _builtins.str master_zone: (Available in 1.101.0+) The master zone of the instance.
        :param _builtins.str material_expire_time: (Available in 1.124.3+) The time when the encryption key expires. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param _builtins.str modify_status_reason: (Available in 1.124.1+) The reason why the SSL link stays in the current state. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        :param _builtins.str name: The name of the RDS instance.
        :param _builtins.str net_type: `Internet` for public network or `Intranet` for private network.
        :param _builtins.str origin: (Available in 1.124.3+) The source of the encryption key.
        :param Sequence['GetInstancesInstanceParameterArgs'] parameters: (Available in 1.135.0+) Parameter list.
        :param _builtins.str port: (Available in 1.70.3+) RDS database connection port.
        :param Sequence[_builtins.str] readonly_instance_ids: A list of IDs of read-only instances attached to the primary instance.
        :param _builtins.str region_id: The region ID of the instance.
        :param _builtins.str replication_acl: (Available in 1.124.1+) The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param _builtins.str require_update: (Available in 1.124.1+) Indicates whether the server certificate needs to be updated.
               - Valid values for ApsaraDB RDS for MySQL and ApsaraDB RDS for SQL Server:
               - No
               - Yes
               - Valid values for ApsaraDB RDS for PostgreSQL:
               - 0: no
               - 1: yes
        :param _builtins.str require_update_item: (Available in 1.124.1+) The server certificate that needs to be updated. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        :param _builtins.str require_update_reason: (Available in 1.124.1+) The reason why the server certificate needs to be updated. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        :param _builtins.str server_ca_url: (Available in 1.124.1+) The URL of the CA that issues the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        :param _builtins.str server_cert: (Available in 1.124.1+) The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        :param _builtins.str server_key: (Available in 1.124.1+) The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        :param _builtins.str ssl_create_time: (Available in 1.124.1+) The time when the server certificate was created. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is valid only when the CAType parameter is set to aliyun.
        :param _builtins.str ssl_enabled: (Available in 1.124.1+) Indicates whether SSL encryption is enabled. Valid values:
               - on: enabled
               - off: disabled
        :param _builtins.str ssl_expire_time: (Available in 1.124.1+) The time when the server certificate expires. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param _builtins.str status: Status of the instance.
        :param _builtins.str sync_mode: (Available since v1.209.1) The data replication mode of the instance.
        :param _builtins.str temp_instance_id: If a temporary instance is attached to the current instance, the ID of the temporary instance applies.
        :param _builtins.str vpc_id: Used to retrieve instances belong to specified VPC.
        :param _builtins.str vswitch_id: Used to retrieve instances belong to specified `vswitch` resources.
        :param _builtins.str zone_id_slave_a: (Available in 1.101.0+) The region ID of the secondary instance if you create a secondary instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
        :param _builtins.str zone_id_slave_b: (Available in 1.101.0+) The region ID of the log instance if you create a log instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
        """
        pulumi.set(__self__, "acl", acl)
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "ca_type", ca_type)
        pulumi.set(__self__, "charge_type", charge_type)
        pulumi.set(__self__, "client_ca_cert", client_ca_cert)
        pulumi.set(__self__, "client_ca_cert_expire_time", client_ca_cert_expire_time)
        pulumi.set(__self__, "client_cert_revocation_list", client_cert_revocation_list)
        pulumi.set(__self__, "connection_mode", connection_mode)
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "creator", creator)
        pulumi.set(__self__, "db_instance_storage_type", db_instance_storage_type)
        pulumi.set(__self__, "db_instance_type", db_instance_type)
        pulumi.set(__self__, "db_type", db_type)
        pulumi.set(__self__, "delete_date", delete_date)
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "encryption_key", encryption_key)
        pulumi.set(__self__, "encryption_key_status", encryption_key_status)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "guard_instance_id", guard_instance_id)
        pulumi.set(__self__, "ha_mode", ha_mode)
        pulumi.set(__self__, "host_instance_infos", host_instance_infos)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_storage", instance_storage)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "key_usage", key_usage)
        pulumi.set(__self__, "last_modify_status", last_modify_status)
        pulumi.set(__self__, "master_instance_id", master_instance_id)
        pulumi.set(__self__, "master_zone", master_zone)
        pulumi.set(__self__, "material_expire_time", material_expire_time)
        pulumi.set(__self__, "modify_status_reason", modify_status_reason)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "net_type", net_type)
        pulumi.set(__self__, "origin", origin)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "readonly_instance_ids", readonly_instance_ids)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "replication_acl", replication_acl)
        pulumi.set(__self__, "require_update", require_update)
        pulumi.set(__self__, "require_update_item", require_update_item)
        pulumi.set(__self__, "require_update_reason", require_update_reason)
        pulumi.set(__self__, "server_ca_url", server_ca_url)
        pulumi.set(__self__, "server_cert", server_cert)
        pulumi.set(__self__, "server_key", server_key)
        pulumi.set(__self__, "ssl_create_time", ssl_create_time)
        pulumi.set(__self__, "ssl_enabled", ssl_enabled)
        pulumi.set(__self__, "ssl_expire_time", ssl_expire_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "sync_mode", sync_mode)
        pulumi.set(__self__, "temp_instance_id", temp_instance_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id_slave_a", zone_id_slave_a)
        pulumi.set(__self__, "zone_id_slave_b", zone_id_slave_b)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> _builtins.str:
        """
        (Available in 1.124.1+) The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        Availability zone.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="caType")
    def ca_type(self) -> _builtins.str:
        """
        (Available in 1.124.1+) The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
        - aliyun: a cloud certificate
        - custom: a custom certificate
        """
        return pulumi.get(self, "ca_type")

    @_builtins.property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> _builtins.str:
        """
        Billing method. Value options: `Postpaid` for Pay-As-You-Go and `Prepaid` for subscription.
        """
        return pulumi.get(self, "charge_type")

    @_builtins.property
    @pulumi.getter(name="clientCaCert")
    def client_ca_cert(self) -> _builtins.str:
        """
        (Available in 1.124.1+) The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        """
        return pulumi.get(self, "client_ca_cert")

    @_builtins.property
    @pulumi.getter(name="clientCaCertExpireTime")
    def client_ca_cert_expire_time(self) -> _builtins.str:
        """
        (Available in 1.124.1+) The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with cloud disks. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC. This parameter is not supported now.
        """
        return pulumi.get(self, "client_ca_cert_expire_time")

    @_builtins.property
    @pulumi.getter(name="clientCertRevocationList")
    def client_cert_revocation_list(self) -> _builtins.str:
        """
        (Available in 1.124.1+) The certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        """
        return pulumi.get(self, "client_cert_revocation_list")

    @_builtins.property
    @pulumi.getter(name="connectionMode")
    def connection_mode(self) -> _builtins.str:
        """
        `Standard` for standard access mode and `Safe` for high security access mode.
        """
        return pulumi.get(self, "connection_mode")

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> _builtins.str:
        """
        (Available in 1.70.3+) RDS database connection string.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Creation time of the instance.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def creator(self) -> _builtins.str:
        """
        (Available in 1.124.3+) The creator of the encryption key.
        """
        return pulumi.get(self, "creator")

    @_builtins.property
    @pulumi.getter(name="dbInstanceStorageType")
    def db_instance_storage_type(self) -> _builtins.str:
        """
        (Available in 1.70.3+) The storage type of the instance.
        """
        return pulumi.get(self, "db_instance_storage_type")

    @_builtins.property
    @pulumi.getter(name="dbInstanceType")
    def db_instance_type(self) -> _builtins.str:
        """
        (Available in 1.197.0+) The type of instance.
        """
        return pulumi.get(self, "db_instance_type")

    @_builtins.property
    @pulumi.getter(name="dbType")
    def db_type(self) -> _builtins.str:
        """
        `Primary` for primary instance, `Readonly` for read-only instance, `Guard` for disaster recovery instance, and `Temp` for temporary instance.
        """
        return pulumi.get(self, "db_type")

    @_builtins.property
    @pulumi.getter(name="deleteDate")
    def delete_date(self) -> _builtins.str:
        """
        (Available in 1.124.3+) The estimated time when the encryption key will be deleted. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "delete_date")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.bool:
        """
        (Available in 1.167.0+) Indicates whether the release protection feature is enabled for the instance. Valid values:
        * **true**: The release protection feature is enabled.
        * **false**: The release protection feature is disabled.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        (Available in 1.124.3+) The description of the encryption key.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> _builtins.str:
        """
        (Available in 1.124.3+) The ID of the encryption key.
        """
        return pulumi.get(self, "encryption_key")

    @_builtins.property
    @pulumi.getter(name="encryptionKeyStatus")
    def encryption_key_status(self) -> _builtins.str:
        """
        (Available in 1.124.3+) The status of the encryption key. Valid values:
        - Enabled
        - Disabled
        """
        return pulumi.get(self, "encryption_key_status")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> _builtins.str:
        """
        Database type. Options are `MySQL`, `SQLServer`, `PostgreSQL`, `MariaDB`. If no value is specified, all types are returned.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> _builtins.str:
        """
        Database version.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.str:
        """
        Expiration time. Pay-As-You-Go instances never expire.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter(name="guardInstanceId")
    def guard_instance_id(self) -> _builtins.str:
        """
        If a disaster recovery instance is attached to the current instance, the ID of the disaster recovery instance applies.
        """
        return pulumi.get(self, "guard_instance_id")

    @_builtins.property
    @pulumi.getter(name="haMode")
    def ha_mode(self) -> _builtins.str:
        """
        (Available since v1.209.1) The high availability mode of the instance.
        """
        return pulumi.get(self, "ha_mode")

    @_builtins.property
    @pulumi.getter(name="hostInstanceInfos")
    def host_instance_infos(self) -> Sequence['outputs.GetInstancesInstanceHostInstanceInfoResult']:
        """
        (Available since v1.209.1) An array that consists of the information of the primary and secondary instances.
        """
        return pulumi.get(self, "host_instance_infos")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the RDS instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceStorage")
    def instance_storage(self) -> _builtins.int:
        """
        (Available in 1.70.3+) User-defined DB instance storage space.
        """
        return pulumi.get(self, "instance_storage")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        """
        Sizing of the RDS instance.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> _builtins.str:
        """
        (Available in 1.124.3+) The purpose of the encryption key.
        """
        return pulumi.get(self, "key_usage")

    @_builtins.property
    @pulumi.getter(name="lastModifyStatus")
    def last_modify_status(self) -> _builtins.str:
        """
        (Available in 1.124.1+) The status of the SSL link. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
        - success
        - setting
        - failed
        """
        return pulumi.get(self, "last_modify_status")

    @_builtins.property
    @pulumi.getter(name="masterInstanceId")
    def master_instance_id(self) -> _builtins.str:
        """
        ID of the primary instance. If this parameter is not returned, the current instance is a primary instance.
        """
        return pulumi.get(self, "master_instance_id")

    @_builtins.property
    @pulumi.getter(name="masterZone")
    def master_zone(self) -> _builtins.str:
        """
        (Available in 1.101.0+) The master zone of the instance.
        """
        return pulumi.get(self, "master_zone")

    @_builtins.property
    @pulumi.getter(name="materialExpireTime")
    def material_expire_time(self) -> _builtins.str:
        """
        (Available in 1.124.3+) The time when the encryption key expires. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "material_expire_time")

    @_builtins.property
    @pulumi.getter(name="modifyStatusReason")
    def modify_status_reason(self) -> _builtins.str:
        """
        (Available in 1.124.1+) The reason why the SSL link stays in the current state. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        """
        return pulumi.get(self, "modify_status_reason")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the RDS instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> _builtins.str:
        """
        `Internet` for public network or `Intranet` for private network.
        """
        return pulumi.get(self, "net_type")

    @_builtins.property
    @pulumi.getter
    def origin(self) -> _builtins.str:
        """
        (Available in 1.124.3+) The source of the encryption key.
        """
        return pulumi.get(self, "origin")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GetInstancesInstanceParameterResult']:
        """
        (Available in 1.135.0+) Parameter list.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        """
        (Available in 1.70.3+) RDS database connection port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="readonlyInstanceIds")
    def readonly_instance_ids(self) -> Sequence[_builtins.str]:
        """
        A list of IDs of read-only instances attached to the primary instance.
        """
        return pulumi.get(self, "readonly_instance_ids")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The region ID of the instance.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="replicationAcl")
    def replication_acl(self) -> _builtins.str:
        """
        (Available in 1.124.1+) The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        """
        return pulumi.get(self, "replication_acl")

    @_builtins.property
    @pulumi.getter(name="requireUpdate")
    def require_update(self) -> _builtins.str:
        """
        (Available in 1.124.1+) Indicates whether the server certificate needs to be updated.
        - Valid values for ApsaraDB RDS for MySQL and ApsaraDB RDS for SQL Server:
        - No
        - Yes
        - Valid values for ApsaraDB RDS for PostgreSQL:
        - 0: no
        - 1: yes
        """
        return pulumi.get(self, "require_update")

    @_builtins.property
    @pulumi.getter(name="requireUpdateItem")
    def require_update_item(self) -> _builtins.str:
        """
        (Available in 1.124.1+) The server certificate that needs to be updated. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        """
        return pulumi.get(self, "require_update_item")

    @_builtins.property
    @pulumi.getter(name="requireUpdateReason")
    def require_update_reason(self) -> _builtins.str:
        """
        (Available in 1.124.1+) The reason why the server certificate needs to be updated. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        """
        return pulumi.get(self, "require_update_reason")

    @_builtins.property
    @pulumi.getter(name="serverCaUrl")
    def server_ca_url(self) -> _builtins.str:
        """
        (Available in 1.124.1+) The URL of the CA that issues the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        """
        return pulumi.get(self, "server_ca_url")

    @_builtins.property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> _builtins.str:
        """
        (Available in 1.124.1+) The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        """
        return pulumi.get(self, "server_cert")

    @_builtins.property
    @pulumi.getter(name="serverKey")
    def server_key(self) -> _builtins.str:
        """
        (Available in 1.124.1+) The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        """
        return pulumi.get(self, "server_key")

    @_builtins.property
    @pulumi.getter(name="sslCreateTime")
    def ssl_create_time(self) -> _builtins.str:
        """
        (Available in 1.124.1+) The time when the server certificate was created. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is valid only when the CAType parameter is set to aliyun.
        """
        return pulumi.get(self, "ssl_create_time")

    @_builtins.property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> _builtins.str:
        """
        (Available in 1.124.1+) Indicates whether SSL encryption is enabled. Valid values:
        - on: enabled
        - off: disabled
        """
        return pulumi.get(self, "ssl_enabled")

    @_builtins.property
    @pulumi.getter(name="sslExpireTime")
    def ssl_expire_time(self) -> _builtins.str:
        """
        (Available in 1.124.1+) The time when the server certificate expires. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "ssl_expire_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> _builtins.str:
        """
        (Available since v1.209.1) The data replication mode of the instance.
        """
        return pulumi.get(self, "sync_mode")

    @_builtins.property
    @pulumi.getter(name="tempInstanceId")
    def temp_instance_id(self) -> _builtins.str:
        """
        If a temporary instance is attached to the current instance, the ID of the temporary instance applies.
        """
        return pulumi.get(self, "temp_instance_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        Used to retrieve instances belong to specified VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        Used to retrieve instances belong to specified `vswitch` resources.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneIdSlaveA")
    def zone_id_slave_a(self) -> _builtins.str:
        """
        (Available in 1.101.0+) The region ID of the secondary instance if you create a secondary instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
        """
        return pulumi.get(self, "zone_id_slave_a")

    @_builtins.property
    @pulumi.getter(name="zoneIdSlaveB")
    def zone_id_slave_b(self) -> _builtins.str:
        """
        (Available in 1.101.0+) The region ID of the log instance if you create a log instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
        """
        return pulumi.get(self, "zone_id_slave_b")


@pulumi.output_type
class GetInstancesInstanceHostInstanceInfoResult(dict):
    def __init__(__self__, *,
                 data_sync_time: _builtins.str,
                 log_sync_time: _builtins.str,
                 node_id: _builtins.str,
                 node_type: _builtins.str,
                 region_id: _builtins.str,
                 sync_status: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.str data_sync_time: The time when the secondary instance completed the synchronization of data from the primary instance. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param _builtins.str log_sync_time: The time when the secondary instance received logs from the primary instance. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param _builtins.str node_id: The ID of the instance.
        :param _builtins.str node_type: The type of the node.
        :param _builtins.str region_id: The region ID of the instance.
        :param _builtins.str sync_status: The synchronization status.
        :param _builtins.str zone_id: The ID of the zone.
        """
        pulumi.set(__self__, "data_sync_time", data_sync_time)
        pulumi.set(__self__, "log_sync_time", log_sync_time)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "node_type", node_type)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "sync_status", sync_status)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="dataSyncTime")
    def data_sync_time(self) -> _builtins.str:
        """
        The time when the secondary instance completed the synchronization of data from the primary instance. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "data_sync_time")

    @_builtins.property
    @pulumi.getter(name="logSyncTime")
    def log_sync_time(self) -> _builtins.str:
        """
        The time when the secondary instance received logs from the primary instance. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "log_sync_time")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> _builtins.str:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> _builtins.str:
        """
        The type of the node.
        """
        return pulumi.get(self, "node_type")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The region ID of the instance.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="syncStatus")
    def sync_status(self) -> _builtins.str:
        """
        The synchronization status.
        """
        return pulumi.get(self, "sync_status")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The ID of the zone.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetInstancesInstanceParameterResult(dict):
    def __init__(__self__, *,
                 checking_code: _builtins.str,
                 force_modify: _builtins.str,
                 force_restart: _builtins.str,
                 parameter_description: _builtins.str,
                 parameter_name: _builtins.str,
                 parameter_value: _builtins.str):
        """
        :param _builtins.str checking_code: The value range of the parameter.
        :param _builtins.str force_modify: Indicates whether the parameter can be modified. Valid values: true | false
        :param _builtins.str force_restart: Indicates whether the modified parameter takes effect only after a database restart. Valid values: true | false
        :param _builtins.str parameter_description: The description of the parameter.
        :param _builtins.str parameter_name: The name of the parameter.
        :param _builtins.str parameter_value: The default value of the parameter.
        """
        pulumi.set(__self__, "checking_code", checking_code)
        pulumi.set(__self__, "force_modify", force_modify)
        pulumi.set(__self__, "force_restart", force_restart)
        pulumi.set(__self__, "parameter_description", parameter_description)
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @_builtins.property
    @pulumi.getter(name="checkingCode")
    def checking_code(self) -> _builtins.str:
        """
        The value range of the parameter.
        """
        return pulumi.get(self, "checking_code")

    @_builtins.property
    @pulumi.getter(name="forceModify")
    def force_modify(self) -> _builtins.str:
        """
        Indicates whether the parameter can be modified. Valid values: true | false
        """
        return pulumi.get(self, "force_modify")

    @_builtins.property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> _builtins.str:
        """
        Indicates whether the modified parameter takes effect only after a database restart. Valid values: true | false
        """
        return pulumi.get(self, "force_restart")

    @_builtins.property
    @pulumi.getter(name="parameterDescription")
    def parameter_description(self) -> _builtins.str:
        """
        The description of the parameter.
        """
        return pulumi.get(self, "parameter_description")

    @_builtins.property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> _builtins.str:
        """
        The name of the parameter.
        """
        return pulumi.get(self, "parameter_name")

    @_builtins.property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> _builtins.str:
        """
        The default value of the parameter.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class GetModifyParameterLogsLogResult(dict):
    def __init__(__self__, *,
                 modify_time: _builtins.str,
                 new_parameter_value: _builtins.str,
                 old_parameter_value: _builtins.str,
                 parameter_name: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str modify_time: The time when the parameter was reconfigured. This value is a UNIX timestamp. Unit: milliseconds.
        :param _builtins.str new_parameter_value: The new value of the parameter.
        :param _builtins.str old_parameter_value: The original value of the parameter.
        :param _builtins.str parameter_name: The name of the parameter.
        :param _builtins.str status: The status of the new value specified for the parameter. Valid values:
               * **Applied**: The new value has taken effect.
               * **Syncing**: The new value is being applied and has not taken effect.
        """
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "new_parameter_value", new_parameter_value)
        pulumi.set(__self__, "old_parameter_value", old_parameter_value)
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> _builtins.str:
        """
        The time when the parameter was reconfigured. This value is a UNIX timestamp. Unit: milliseconds.
        """
        return pulumi.get(self, "modify_time")

    @_builtins.property
    @pulumi.getter(name="newParameterValue")
    def new_parameter_value(self) -> _builtins.str:
        """
        The new value of the parameter.
        """
        return pulumi.get(self, "new_parameter_value")

    @_builtins.property
    @pulumi.getter(name="oldParameterValue")
    def old_parameter_value(self) -> _builtins.str:
        """
        The original value of the parameter.
        """
        return pulumi.get(self, "old_parameter_value")

    @_builtins.property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> _builtins.str:
        """
        The name of the parameter.
        """
        return pulumi.get(self, "parameter_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the new value specified for the parameter. Valid values:
        * **Applied**: The new value has taken effect.
        * **Syncing**: The new value is being applied and has not taken effect.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetRdsBackupsBackupResult(dict):
    def __init__(__self__, *,
                 backup_download_url: _builtins.str,
                 backup_end_time: _builtins.str,
                 backup_id: _builtins.str,
                 backup_initiator: _builtins.str,
                 backup_intranet_download_url: _builtins.str,
                 backup_method: _builtins.str,
                 backup_mode: _builtins.str,
                 backup_size: _builtins.str,
                 backup_start_time: _builtins.str,
                 backup_status: _builtins.str,
                 backup_type: _builtins.str,
                 consistent_time: _builtins.str,
                 copy_only_backup: _builtins.str,
                 db_instance_id: _builtins.str,
                 encryption: _builtins.str,
                 host_instance_id: _builtins.str,
                 id: _builtins.str,
                 is_avail: _builtins.int,
                 meta_status: _builtins.str,
                 storage_class: _builtins.str,
                 store_status: _builtins.str):
        """
        :param _builtins.str backup_download_url: The backup download url.
        :param _builtins.str backup_end_time: BackupEndTime.
        :param _builtins.str backup_id: BackupId.
        :param _builtins.str backup_initiator: The initiator of the backup task. Value:
               * **System**: automatically initiated by the System
               * **User**: manually initiated by the User.
        :param _builtins.str backup_intranet_download_url: The backup intranet download url.
        :param _builtins.str backup_method: BackupMethod.
        :param _builtins.str backup_mode: BackupMode.
        :param _builtins.str backup_size: BackupSize.
        :param _builtins.str backup_start_time: BackupStartTime.
        :param _builtins.str backup_status: Backup task status. **NOTE:** This parameter will only be returned when a task is executed. Value:
               * **NoStart**: Not started
               * **Checking**: check the backup
               * **Preparing**: Prepare a backup
               * **Waiting**: Waiting for backup
               * **Uploading**: Upload backup
               * **Finished**: Complete backup
               * **Failed**: backup Failed
        :param _builtins.str backup_type: BackupType.
        :param _builtins.str consistent_time: The consistency point of the backup set. The return value is a timestamp. **NOTE:** only MySQL 5.6 returns this parameter, and other versions return 0.
        :param _builtins.str copy_only_backup: The backup mode is divided into the normal backup mode (full and incremental recovery is supported) and the replication-only mode (full recovery is supported only). **NOTE:** Only SQL Server returns this parameter. Valid values:
               * **0**: General Backup Mode
               * **1**: Copy only mode
        :param _builtins.str db_instance_id: The db instance id.
        :param _builtins.str encryption: The encrypted information of the backup set.
        :param _builtins.str host_instance_id: HostInstanceID.
        :param _builtins.str id: The ID of the Backup.
        :param _builtins.int is_avail: Whether the backup set is available, the value is:
               * **0**: Not available
               * **1**: Available.
        :param _builtins.str meta_status: The backup set status of the database table. **NOTE:** an empty string indicates that the backup set for database table recovery is not enabled. Valid values:
               * **OK**: normal.
               * **LARGE**: There are too many tables that cannot be used for database and table recovery.
               * **EMPTY**: The backup set that failed to be backed up.
        :param _builtins.str storage_class: The storage medium for the backup set. Valid values:
               * **0**: Regular storage
               * **1**: Archive storage.
        :param _builtins.str store_status: StoreStatus.
        """
        pulumi.set(__self__, "backup_download_url", backup_download_url)
        pulumi.set(__self__, "backup_end_time", backup_end_time)
        pulumi.set(__self__, "backup_id", backup_id)
        pulumi.set(__self__, "backup_initiator", backup_initiator)
        pulumi.set(__self__, "backup_intranet_download_url", backup_intranet_download_url)
        pulumi.set(__self__, "backup_method", backup_method)
        pulumi.set(__self__, "backup_mode", backup_mode)
        pulumi.set(__self__, "backup_size", backup_size)
        pulumi.set(__self__, "backup_start_time", backup_start_time)
        pulumi.set(__self__, "backup_status", backup_status)
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "consistent_time", consistent_time)
        pulumi.set(__self__, "copy_only_backup", copy_only_backup)
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "encryption", encryption)
        pulumi.set(__self__, "host_instance_id", host_instance_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_avail", is_avail)
        pulumi.set(__self__, "meta_status", meta_status)
        pulumi.set(__self__, "storage_class", storage_class)
        pulumi.set(__self__, "store_status", store_status)

    @_builtins.property
    @pulumi.getter(name="backupDownloadUrl")
    def backup_download_url(self) -> _builtins.str:
        """
        The backup download url.
        """
        return pulumi.get(self, "backup_download_url")

    @_builtins.property
    @pulumi.getter(name="backupEndTime")
    def backup_end_time(self) -> _builtins.str:
        """
        BackupEndTime.
        """
        return pulumi.get(self, "backup_end_time")

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> _builtins.str:
        """
        BackupId.
        """
        return pulumi.get(self, "backup_id")

    @_builtins.property
    @pulumi.getter(name="backupInitiator")
    def backup_initiator(self) -> _builtins.str:
        """
        The initiator of the backup task. Value:
        * **System**: automatically initiated by the System
        * **User**: manually initiated by the User.
        """
        return pulumi.get(self, "backup_initiator")

    @_builtins.property
    @pulumi.getter(name="backupIntranetDownloadUrl")
    def backup_intranet_download_url(self) -> _builtins.str:
        """
        The backup intranet download url.
        """
        return pulumi.get(self, "backup_intranet_download_url")

    @_builtins.property
    @pulumi.getter(name="backupMethod")
    def backup_method(self) -> _builtins.str:
        """
        BackupMethod.
        """
        return pulumi.get(self, "backup_method")

    @_builtins.property
    @pulumi.getter(name="backupMode")
    def backup_mode(self) -> _builtins.str:
        """
        BackupMode.
        """
        return pulumi.get(self, "backup_mode")

    @_builtins.property
    @pulumi.getter(name="backupSize")
    def backup_size(self) -> _builtins.str:
        """
        BackupSize.
        """
        return pulumi.get(self, "backup_size")

    @_builtins.property
    @pulumi.getter(name="backupStartTime")
    def backup_start_time(self) -> _builtins.str:
        """
        BackupStartTime.
        """
        return pulumi.get(self, "backup_start_time")

    @_builtins.property
    @pulumi.getter(name="backupStatus")
    def backup_status(self) -> _builtins.str:
        """
        Backup task status. **NOTE:** This parameter will only be returned when a task is executed. Value:
        * **NoStart**: Not started
        * **Checking**: check the backup
        * **Preparing**: Prepare a backup
        * **Waiting**: Waiting for backup
        * **Uploading**: Upload backup
        * **Finished**: Complete backup
        * **Failed**: backup Failed
        """
        return pulumi.get(self, "backup_status")

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> _builtins.str:
        """
        BackupType.
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter(name="consistentTime")
    def consistent_time(self) -> _builtins.str:
        """
        The consistency point of the backup set. The return value is a timestamp. **NOTE:** only MySQL 5.6 returns this parameter, and other versions return 0.
        """
        return pulumi.get(self, "consistent_time")

    @_builtins.property
    @pulumi.getter(name="copyOnlyBackup")
    def copy_only_backup(self) -> _builtins.str:
        """
        The backup mode is divided into the normal backup mode (full and incremental recovery is supported) and the replication-only mode (full recovery is supported only). **NOTE:** Only SQL Server returns this parameter. Valid values:
        * **0**: General Backup Mode
        * **1**: Copy only mode
        """
        return pulumi.get(self, "copy_only_backup")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> _builtins.str:
        """
        The db instance id.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> _builtins.str:
        """
        The encrypted information of the backup set.
        """
        return pulumi.get(self, "encryption")

    @_builtins.property
    @pulumi.getter(name="hostInstanceId")
    def host_instance_id(self) -> _builtins.str:
        """
        HostInstanceID.
        """
        return pulumi.get(self, "host_instance_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Backup.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isAvail")
    def is_avail(self) -> _builtins.int:
        """
        Whether the backup set is available, the value is:
        * **0**: Not available
        * **1**: Available.
        """
        return pulumi.get(self, "is_avail")

    @_builtins.property
    @pulumi.getter(name="metaStatus")
    def meta_status(self) -> _builtins.str:
        """
        The backup set status of the database table. **NOTE:** an empty string indicates that the backup set for database table recovery is not enabled. Valid values:
        * **OK**: normal.
        * **LARGE**: There are too many tables that cannot be used for database and table recovery.
        * **EMPTY**: The backup set that failed to be backed up.
        """
        return pulumi.get(self, "meta_status")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        The storage medium for the backup set. Valid values:
        * **0**: Regular storage
        * **1**: Archive storage.
        """
        return pulumi.get(self, "storage_class")

    @_builtins.property
    @pulumi.getter(name="storeStatus")
    def store_status(self) -> _builtins.str:
        """
        StoreStatus.
        """
        return pulumi.get(self, "store_status")


@pulumi.output_type
class GetRdsParameterGroupsGroupResult(dict):
    def __init__(__self__, *,
                 engine: _builtins.str,
                 engine_version: _builtins.str,
                 force_restart: _builtins.int,
                 id: _builtins.str,
                 param_counts: _builtins.int,
                 param_details: Sequence['outputs.GetRdsParameterGroupsGroupParamDetailResult'],
                 parameter_group_desc: _builtins.str,
                 parameter_group_id: _builtins.str,
                 parameter_group_name: _builtins.str,
                 parameter_group_type: _builtins.int):
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "force_restart", force_restart)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "param_counts", param_counts)
        pulumi.set(__self__, "param_details", param_details)
        pulumi.set(__self__, "parameter_group_desc", parameter_group_desc)
        pulumi.set(__self__, "parameter_group_id", parameter_group_id)
        pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        pulumi.set(__self__, "parameter_group_type", parameter_group_type)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> _builtins.str:
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> _builtins.str:
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> _builtins.int:
        return pulumi.get(self, "force_restart")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="paramCounts")
    def param_counts(self) -> _builtins.int:
        return pulumi.get(self, "param_counts")

    @_builtins.property
    @pulumi.getter(name="paramDetails")
    def param_details(self) -> Sequence['outputs.GetRdsParameterGroupsGroupParamDetailResult']:
        return pulumi.get(self, "param_details")

    @_builtins.property
    @pulumi.getter(name="parameterGroupDesc")
    def parameter_group_desc(self) -> _builtins.str:
        return pulumi.get(self, "parameter_group_desc")

    @_builtins.property
    @pulumi.getter(name="parameterGroupId")
    def parameter_group_id(self) -> _builtins.str:
        return pulumi.get(self, "parameter_group_id")

    @_builtins.property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> _builtins.str:
        return pulumi.get(self, "parameter_group_name")

    @_builtins.property
    @pulumi.getter(name="parameterGroupType")
    def parameter_group_type(self) -> _builtins.int:
        return pulumi.get(self, "parameter_group_type")


@pulumi.output_type
class GetRdsParameterGroupsGroupParamDetailResult(dict):
    def __init__(__self__, *,
                 param_name: _builtins.str,
                 param_value: _builtins.str):
        pulumi.set(__self__, "param_name", param_name)
        pulumi.set(__self__, "param_value", param_value)

    @_builtins.property
    @pulumi.getter(name="paramName")
    def param_name(self) -> _builtins.str:
        return pulumi.get(self, "param_name")

    @_builtins.property
    @pulumi.getter(name="paramValue")
    def param_value(self) -> _builtins.str:
        return pulumi.get(self, "param_value")


@pulumi.output_type
class GetSlotsSlotResult(dict):
    def __init__(__self__, *,
                 database: _builtins.str,
                 plugin: _builtins.str,
                 slot_name: _builtins.str,
                 slot_status: _builtins.str,
                 slot_type: _builtins.str,
                 temporary: _builtins.str,
                 wal_delay: _builtins.str):
        """
        :param _builtins.str database: The name of the database where Replication Slot is located.
        :param _builtins.str plugin: The plugin used by Replication Slot.
        :param _builtins.str slot_name: The Replication Slot name.
        :param _builtins.str slot_status: The Replication Slot status.
        :param _builtins.str slot_type: The Replication Slot type.
        :param _builtins.str temporary: Is the Replication Slot temporary.
        :param _builtins.str wal_delay: The amount of logs accumulated by Replication Slot.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "plugin", plugin)
        pulumi.set(__self__, "slot_name", slot_name)
        pulumi.set(__self__, "slot_status", slot_status)
        pulumi.set(__self__, "slot_type", slot_type)
        pulumi.set(__self__, "temporary", temporary)
        pulumi.set(__self__, "wal_delay", wal_delay)

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        """
        The name of the database where Replication Slot is located.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def plugin(self) -> _builtins.str:
        """
        The plugin used by Replication Slot.
        """
        return pulumi.get(self, "plugin")

    @_builtins.property
    @pulumi.getter(name="slotName")
    def slot_name(self) -> _builtins.str:
        """
        The Replication Slot name.
        """
        return pulumi.get(self, "slot_name")

    @_builtins.property
    @pulumi.getter(name="slotStatus")
    def slot_status(self) -> _builtins.str:
        """
        The Replication Slot status.
        """
        return pulumi.get(self, "slot_status")

    @_builtins.property
    @pulumi.getter(name="slotType")
    def slot_type(self) -> _builtins.str:
        """
        The Replication Slot type.
        """
        return pulumi.get(self, "slot_type")

    @_builtins.property
    @pulumi.getter
    def temporary(self) -> _builtins.str:
        """
        Is the Replication Slot temporary.
        """
        return pulumi.get(self, "temporary")

    @_builtins.property
    @pulumi.getter(name="walDelay")
    def wal_delay(self) -> _builtins.str:
        """
        The amount of logs accumulated by Replication Slot.
        """
        return pulumi.get(self, "wal_delay")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 multi_zone_ids: Sequence[_builtins.str]):
        """
        :param _builtins.str id: ID of the zone.
        :param Sequence[_builtins.str] multi_zone_ids: A list of zone ids in which the multi zone.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "multi_zone_ids", multi_zone_ids)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the zone.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="multiZoneIds")
    def multi_zone_ids(self) -> Sequence[_builtins.str]:
        """
        A list of zone ids in which the multi zone.
        """
        return pulumi.get(self, "multi_zone_ids")


