# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RdsDbProxyArgs', 'RdsDbProxy']

@pulumi.input_type
class RdsDbProxyArgs:
    def __init__(__self__, *,
                 db_proxy_instance_num: pulumi.Input[_builtins.int],
                 instance_id: pulumi.Input[_builtins.str],
                 instance_network_type: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 vswitch_id: pulumi.Input[_builtins.str],
                 db_proxy_connect_string_port: Optional[pulumi.Input[_builtins.int]] = None,
                 db_proxy_connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_endpoint_read_write_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_features: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_ssl_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_specific_time: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only_instance_distribution_type: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only_instance_max_delay_time: Optional[pulumi.Input[_builtins.int]] = None,
                 read_only_instance_weights: Optional[pulumi.Input[Sequence[pulumi.Input['RdsDbProxyReadOnlyInstanceWeightArgs']]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 switch_time: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RdsDbProxy resource.
        :param pulumi.Input[_builtins.int] db_proxy_instance_num: The number of proxy instances that are enabled. Valid values: 1 to 60.
        :param pulumi.Input[_builtins.str] instance_id: The Id of instance that can run database.
        :param pulumi.Input[_builtins.str] instance_network_type: The network type of the instance. Set the value to VPC.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC) to which the instance belongs.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch that is associated with the specified VPC.
        :param pulumi.Input[_builtins.int] db_proxy_connect_string_port: The port number that is associated with the proxy endpoint.
        :param pulumi.Input[_builtins.str] db_proxy_connection_prefix: The new prefix of the proxy endpoint. Enter a prefix.
        :param pulumi.Input[_builtins.str] db_proxy_endpoint_read_write_mode: The read and write attributes of the proxy terminal. Valid values:
               - ReadWrite: The proxy terminal connects to the primary instance and can receive both read and write requests.
               - ReadOnly: The proxy terminal does not connect to the primary instance and can receive only read requests. This is the default value.
               
               > **NOTE:** Note This setting causes your instance to restart. Proceed with caution.
        :param pulumi.Input[_builtins.str] db_proxy_features: The features that you want to enable for the proxy endpoint. If you specify more than one feature, separate the features with semicolons (;). Format: Feature 1:Status;Feature 2:Status;.... Do not add a semicolon (;) at the end of the last value. Valid feature values:
               - ReadWriteSpliting: read/write splitting.
               - ConnectionPersist: connection pooling.
               - TransactionReadSqlRouteOptimizeStatus: transaction splitting.
               Valid status values:
               - 1: enabled.
               - 0: disabled.
               
               > **NOTE:** Note You must specify this parameter only when the read/write splitting feature is enabled.
        :param pulumi.Input[_builtins.str] db_proxy_instance_type: The database proxy type. Valid values:
               - common: universal proxy.
               - exclusive: Exclusive proxy (default).
        :param pulumi.Input[_builtins.str] db_proxy_ssl_enabled: The SSL configuration setting that you want to apply on the instance. Valid values:
               - Close: disables SSL encryption.
               - Open: enables SSL encryption or modifies the endpoint that requires SSL encryption.
               - Update: updates the validity period of the SSL certificate.
        :param pulumi.Input[_builtins.str] effective_specific_time: The point in time at which you want to apply the new database proxy settings. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        :param pulumi.Input[_builtins.str] effective_time: When modifying the number of proxy instances,The time when you want to apply the new database proxy settings.Valid values:
               - Immediate: ApsaraDB RDS immediately applies the new settings.
               - MaintainTime: ApsaraDB RDS applies the new settings during the maintenance window that you specified. For more information, see Modify the maintenance window.
               - SpecificTime: ApsaraDB RDS applies the new settings at a specified point in time.
               
               > **NOTE:** Note If you set the EffectiveTime parameter to SpecificTime, you must specify the EffectiveSpecificTime parameter.
        :param pulumi.Input[_builtins.str] read_only_instance_distribution_type: The policy that is used to allocate read weights. Valid values:
               - Standard: ApsaraDB RDS automatically allocates read weights to the instance and its read-only instances based on the specifications of the instances.
               - Custom: You must manually allocate read weights to the instance and its read-only instances.
               
               > **NOTE:** Note If you set the ReadOnlyInstanceDistributionType parameter to Custom, you must specify the ReadOnlyInstanceWeight parameter.
        :param pulumi.Input[_builtins.int] read_only_instance_max_delay_time: The maximum latency threshold that is allowed for read/write splitting. If the latency on a read-only instance exceeds the threshold that you specified, ApsaraDB RDS no longer forwards read requests to the read-only instance. If you do not specify this parameter, the default value of this parameter is retained. Unit: seconds. Valid values: 0 to 3600.
               
               > **NOTE:** Note If the instance runs PostgreSQL, you can enable only the read/write splitting feature, which is specified by ReadWriteSpliting.
        :param pulumi.Input[Sequence[pulumi.Input['RdsDbProxyReadOnlyInstanceWeightArgs']]] read_only_instance_weights: A list of the read weights of the instance and its read-only instances.  It contains two sub-fields(instance_id and weight). Read weights increase in increments of 100, and the maximum read weight is 10000. See `read_only_instance_weight` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] switch_time: The point in time at which you want to upgrade the database proxy version of the instance. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        :param pulumi.Input[_builtins.str] upgrade_time: The time when you want to upgrade the database proxy version of the instance. Valid values:
               - MaintainTime: ApsaraDB RDS performs the upgrade during the maintenance window that you specified. This is the default value. For more information, see Modify the maintenance window.
               - Immediate: ApsaraDB RDS immediately performs the upgrade.
               - SpecificTime: ApsaraDB RDS performs the upgrade at a specified point in time.
        """
        pulumi.set(__self__, "db_proxy_instance_num", db_proxy_instance_num)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_network_type", instance_network_type)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if db_proxy_connect_string_port is not None:
            pulumi.set(__self__, "db_proxy_connect_string_port", db_proxy_connect_string_port)
        if db_proxy_connection_prefix is not None:
            pulumi.set(__self__, "db_proxy_connection_prefix", db_proxy_connection_prefix)
        if db_proxy_endpoint_read_write_mode is not None:
            pulumi.set(__self__, "db_proxy_endpoint_read_write_mode", db_proxy_endpoint_read_write_mode)
        if db_proxy_features is not None:
            pulumi.set(__self__, "db_proxy_features", db_proxy_features)
        if db_proxy_instance_type is not None:
            pulumi.set(__self__, "db_proxy_instance_type", db_proxy_instance_type)
        if db_proxy_ssl_enabled is not None:
            pulumi.set(__self__, "db_proxy_ssl_enabled", db_proxy_ssl_enabled)
        if effective_specific_time is not None:
            pulumi.set(__self__, "effective_specific_time", effective_specific_time)
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if read_only_instance_distribution_type is not None:
            pulumi.set(__self__, "read_only_instance_distribution_type", read_only_instance_distribution_type)
        if read_only_instance_max_delay_time is not None:
            pulumi.set(__self__, "read_only_instance_max_delay_time", read_only_instance_max_delay_time)
        if read_only_instance_weights is not None:
            pulumi.set(__self__, "read_only_instance_weights", read_only_instance_weights)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if switch_time is not None:
            pulumi.set(__self__, "switch_time", switch_time)
        if upgrade_time is not None:
            pulumi.set(__self__, "upgrade_time", upgrade_time)

    @_builtins.property
    @pulumi.getter(name="dbProxyInstanceNum")
    def db_proxy_instance_num(self) -> pulumi.Input[_builtins.int]:
        """
        The number of proxy instances that are enabled. Valid values: 1 to 60.
        """
        return pulumi.get(self, "db_proxy_instance_num")

    @db_proxy_instance_num.setter
    def db_proxy_instance_num(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "db_proxy_instance_num", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Id of instance that can run database.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceNetworkType")
    def instance_network_type(self) -> pulumi.Input[_builtins.str]:
        """
        The network type of the instance. Set the value to VPC.
        """
        return pulumi.get(self, "instance_network_type")

    @instance_network_type.setter
    def instance_network_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_network_type", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the virtual private cloud (VPC) to which the instance belongs.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the vSwitch that is associated with the specified VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="dbProxyConnectStringPort")
    def db_proxy_connect_string_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port number that is associated with the proxy endpoint.
        """
        return pulumi.get(self, "db_proxy_connect_string_port")

    @db_proxy_connect_string_port.setter
    def db_proxy_connect_string_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "db_proxy_connect_string_port", value)

    @_builtins.property
    @pulumi.getter(name="dbProxyConnectionPrefix")
    def db_proxy_connection_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new prefix of the proxy endpoint. Enter a prefix.
        """
        return pulumi.get(self, "db_proxy_connection_prefix")

    @db_proxy_connection_prefix.setter
    def db_proxy_connection_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_proxy_connection_prefix", value)

    @_builtins.property
    @pulumi.getter(name="dbProxyEndpointReadWriteMode")
    def db_proxy_endpoint_read_write_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The read and write attributes of the proxy terminal. Valid values:
        - ReadWrite: The proxy terminal connects to the primary instance and can receive both read and write requests.
        - ReadOnly: The proxy terminal does not connect to the primary instance and can receive only read requests. This is the default value.

        > **NOTE:** Note This setting causes your instance to restart. Proceed with caution.
        """
        return pulumi.get(self, "db_proxy_endpoint_read_write_mode")

    @db_proxy_endpoint_read_write_mode.setter
    def db_proxy_endpoint_read_write_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_proxy_endpoint_read_write_mode", value)

    @_builtins.property
    @pulumi.getter(name="dbProxyFeatures")
    def db_proxy_features(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The features that you want to enable for the proxy endpoint. If you specify more than one feature, separate the features with semicolons (;). Format: Feature 1:Status;Feature 2:Status;.... Do not add a semicolon (;) at the end of the last value. Valid feature values:
        - ReadWriteSpliting: read/write splitting.
        - ConnectionPersist: connection pooling.
        - TransactionReadSqlRouteOptimizeStatus: transaction splitting.
        Valid status values:
        - 1: enabled.
        - 0: disabled.

        > **NOTE:** Note You must specify this parameter only when the read/write splitting feature is enabled.
        """
        return pulumi.get(self, "db_proxy_features")

    @db_proxy_features.setter
    def db_proxy_features(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_proxy_features", value)

    @_builtins.property
    @pulumi.getter(name="dbProxyInstanceType")
    def db_proxy_instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database proxy type. Valid values:
        - common: universal proxy.
        - exclusive: Exclusive proxy (default).
        """
        return pulumi.get(self, "db_proxy_instance_type")

    @db_proxy_instance_type.setter
    def db_proxy_instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_proxy_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="dbProxySslEnabled")
    def db_proxy_ssl_enabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SSL configuration setting that you want to apply on the instance. Valid values:
        - Close: disables SSL encryption.
        - Open: enables SSL encryption or modifies the endpoint that requires SSL encryption.
        - Update: updates the validity period of the SSL certificate.
        """
        return pulumi.get(self, "db_proxy_ssl_enabled")

    @db_proxy_ssl_enabled.setter
    def db_proxy_ssl_enabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_proxy_ssl_enabled", value)

    @_builtins.property
    @pulumi.getter(name="effectiveSpecificTime")
    def effective_specific_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The point in time at which you want to apply the new database proxy settings. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        """
        return pulumi.get(self, "effective_specific_time")

    @effective_specific_time.setter
    def effective_specific_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_specific_time", value)

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When modifying the number of proxy instances,The time when you want to apply the new database proxy settings.Valid values:
        - Immediate: ApsaraDB RDS immediately applies the new settings.
        - MaintainTime: ApsaraDB RDS applies the new settings during the maintenance window that you specified. For more information, see Modify the maintenance window.
        - SpecificTime: ApsaraDB RDS applies the new settings at a specified point in time.

        > **NOTE:** Note If you set the EffectiveTime parameter to SpecificTime, you must specify the EffectiveSpecificTime parameter.
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_time", value)

    @_builtins.property
    @pulumi.getter(name="readOnlyInstanceDistributionType")
    def read_only_instance_distribution_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy that is used to allocate read weights. Valid values:
        - Standard: ApsaraDB RDS automatically allocates read weights to the instance and its read-only instances based on the specifications of the instances.
        - Custom: You must manually allocate read weights to the instance and its read-only instances.

        > **NOTE:** Note If you set the ReadOnlyInstanceDistributionType parameter to Custom, you must specify the ReadOnlyInstanceWeight parameter.
        """
        return pulumi.get(self, "read_only_instance_distribution_type")

    @read_only_instance_distribution_type.setter
    def read_only_instance_distribution_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "read_only_instance_distribution_type", value)

    @_builtins.property
    @pulumi.getter(name="readOnlyInstanceMaxDelayTime")
    def read_only_instance_max_delay_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum latency threshold that is allowed for read/write splitting. If the latency on a read-only instance exceeds the threshold that you specified, ApsaraDB RDS no longer forwards read requests to the read-only instance. If you do not specify this parameter, the default value of this parameter is retained. Unit: seconds. Valid values: 0 to 3600.

        > **NOTE:** Note If the instance runs PostgreSQL, you can enable only the read/write splitting feature, which is specified by ReadWriteSpliting.
        """
        return pulumi.get(self, "read_only_instance_max_delay_time")

    @read_only_instance_max_delay_time.setter
    def read_only_instance_max_delay_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_only_instance_max_delay_time", value)

    @_builtins.property
    @pulumi.getter(name="readOnlyInstanceWeights")
    def read_only_instance_weights(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RdsDbProxyReadOnlyInstanceWeightArgs']]]]:
        """
        A list of the read weights of the instance and its read-only instances.  It contains two sub-fields(instance_id and weight). Read weights increase in increments of 100, and the maximum read weight is 10000. See `read_only_instance_weight` below.
        """
        return pulumi.get(self, "read_only_instance_weights")

    @read_only_instance_weights.setter
    def read_only_instance_weights(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RdsDbProxyReadOnlyInstanceWeightArgs']]]]):
        pulumi.set(self, "read_only_instance_weights", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="switchTime")
    def switch_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The point in time at which you want to upgrade the database proxy version of the instance. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        """
        return pulumi.get(self, "switch_time")

    @switch_time.setter
    def switch_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "switch_time", value)

    @_builtins.property
    @pulumi.getter(name="upgradeTime")
    def upgrade_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when you want to upgrade the database proxy version of the instance. Valid values:
        - MaintainTime: ApsaraDB RDS performs the upgrade during the maintenance window that you specified. This is the default value. For more information, see Modify the maintenance window.
        - Immediate: ApsaraDB RDS immediately performs the upgrade.
        - SpecificTime: ApsaraDB RDS performs the upgrade at a specified point in time.
        """
        return pulumi.get(self, "upgrade_time")

    @upgrade_time.setter
    def upgrade_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upgrade_time", value)


@pulumi.input_type
class _RdsDbProxyState:
    def __init__(__self__, *,
                 db_proxy_connect_string_port: Optional[pulumi.Input[_builtins.int]] = None,
                 db_proxy_connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_endpoint_aliases: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_endpoint_read_write_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_features: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_instance_num: Optional[pulumi.Input[_builtins.int]] = None,
                 db_proxy_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_ssl_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_specific_time: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only_instance_distribution_type: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only_instance_max_delay_time: Optional[pulumi.Input[_builtins.int]] = None,
                 read_only_instance_weights: Optional[pulumi.Input[Sequence[pulumi.Input['RdsDbProxyReadOnlyInstanceWeightArgs']]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_expired_time: Optional[pulumi.Input[_builtins.str]] = None,
                 switch_time: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_time: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RdsDbProxy resources.
        :param pulumi.Input[_builtins.int] db_proxy_connect_string_port: The port number that is associated with the proxy endpoint.
        :param pulumi.Input[_builtins.str] db_proxy_connection_prefix: The new prefix of the proxy endpoint. Enter a prefix.
        :param pulumi.Input[_builtins.str] db_proxy_connection_string: Connection instance string.
        :param pulumi.Input[_builtins.str] db_proxy_endpoint_aliases: Remarks of agent terminal.
        :param pulumi.Input[_builtins.str] db_proxy_endpoint_id: Proxy connection address ID.
        :param pulumi.Input[_builtins.str] db_proxy_endpoint_read_write_mode: The read and write attributes of the proxy terminal. Valid values:
               - ReadWrite: The proxy terminal connects to the primary instance and can receive both read and write requests.
               - ReadOnly: The proxy terminal does not connect to the primary instance and can receive only read requests. This is the default value.
               
               > **NOTE:** Note This setting causes your instance to restart. Proceed with caution.
        :param pulumi.Input[_builtins.str] db_proxy_features: The features that you want to enable for the proxy endpoint. If you specify more than one feature, separate the features with semicolons (;). Format: Feature 1:Status;Feature 2:Status;.... Do not add a semicolon (;) at the end of the last value. Valid feature values:
               - ReadWriteSpliting: read/write splitting.
               - ConnectionPersist: connection pooling.
               - TransactionReadSqlRouteOptimizeStatus: transaction splitting.
               Valid status values:
               - 1: enabled.
               - 0: disabled.
               
               > **NOTE:** Note You must specify this parameter only when the read/write splitting feature is enabled.
        :param pulumi.Input[_builtins.int] db_proxy_instance_num: The number of proxy instances that are enabled. Valid values: 1 to 60.
        :param pulumi.Input[_builtins.str] db_proxy_instance_type: The database proxy type. Valid values:
               - common: universal proxy.
               - exclusive: Exclusive proxy (default).
        :param pulumi.Input[_builtins.str] db_proxy_ssl_enabled: The SSL configuration setting that you want to apply on the instance. Valid values:
               - Close: disables SSL encryption.
               - Open: enables SSL encryption or modifies the endpoint that requires SSL encryption.
               - Update: updates the validity period of the SSL certificate.
        :param pulumi.Input[_builtins.str] effective_specific_time: The point in time at which you want to apply the new database proxy settings. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        :param pulumi.Input[_builtins.str] effective_time: When modifying the number of proxy instances,The time when you want to apply the new database proxy settings.Valid values:
               - Immediate: ApsaraDB RDS immediately applies the new settings.
               - MaintainTime: ApsaraDB RDS applies the new settings during the maintenance window that you specified. For more information, see Modify the maintenance window.
               - SpecificTime: ApsaraDB RDS applies the new settings at a specified point in time.
               
               > **NOTE:** Note If you set the EffectiveTime parameter to SpecificTime, you must specify the EffectiveSpecificTime parameter.
        :param pulumi.Input[_builtins.str] instance_id: The Id of instance that can run database.
        :param pulumi.Input[_builtins.str] instance_network_type: The network type of the instance. Set the value to VPC.
        :param pulumi.Input[_builtins.str] net_type: Network type of proxy connection address.
        :param pulumi.Input[_builtins.str] read_only_instance_distribution_type: The policy that is used to allocate read weights. Valid values:
               - Standard: ApsaraDB RDS automatically allocates read weights to the instance and its read-only instances based on the specifications of the instances.
               - Custom: You must manually allocate read weights to the instance and its read-only instances.
               
               > **NOTE:** Note If you set the ReadOnlyInstanceDistributionType parameter to Custom, you must specify the ReadOnlyInstanceWeight parameter.
        :param pulumi.Input[_builtins.int] read_only_instance_max_delay_time: The maximum latency threshold that is allowed for read/write splitting. If the latency on a read-only instance exceeds the threshold that you specified, ApsaraDB RDS no longer forwards read requests to the read-only instance. If you do not specify this parameter, the default value of this parameter is retained. Unit: seconds. Valid values: 0 to 3600.
               
               > **NOTE:** Note If the instance runs PostgreSQL, you can enable only the read/write splitting feature, which is specified by ReadWriteSpliting.
        :param pulumi.Input[Sequence[pulumi.Input['RdsDbProxyReadOnlyInstanceWeightArgs']]] read_only_instance_weights: A list of the read weights of the instance and its read-only instances.  It contains two sub-fields(instance_id and weight). Read weights increase in increments of 100, and the maximum read weight is 10000. See `read_only_instance_weight` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] ssl_expired_time: The time when the certificate expires.
        :param pulumi.Input[_builtins.str] switch_time: The point in time at which you want to upgrade the database proxy version of the instance. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        :param pulumi.Input[_builtins.str] upgrade_time: The time when you want to upgrade the database proxy version of the instance. Valid values:
               - MaintainTime: ApsaraDB RDS performs the upgrade during the maintenance window that you specified. This is the default value. For more information, see Modify the maintenance window.
               - Immediate: ApsaraDB RDS immediately performs the upgrade.
               - SpecificTime: ApsaraDB RDS performs the upgrade at a specified point in time.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC) to which the instance belongs.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch that is associated with the specified VPC.
        """
        if db_proxy_connect_string_port is not None:
            pulumi.set(__self__, "db_proxy_connect_string_port", db_proxy_connect_string_port)
        if db_proxy_connection_prefix is not None:
            pulumi.set(__self__, "db_proxy_connection_prefix", db_proxy_connection_prefix)
        if db_proxy_connection_string is not None:
            pulumi.set(__self__, "db_proxy_connection_string", db_proxy_connection_string)
        if db_proxy_endpoint_aliases is not None:
            pulumi.set(__self__, "db_proxy_endpoint_aliases", db_proxy_endpoint_aliases)
        if db_proxy_endpoint_id is not None:
            pulumi.set(__self__, "db_proxy_endpoint_id", db_proxy_endpoint_id)
        if db_proxy_endpoint_read_write_mode is not None:
            pulumi.set(__self__, "db_proxy_endpoint_read_write_mode", db_proxy_endpoint_read_write_mode)
        if db_proxy_features is not None:
            pulumi.set(__self__, "db_proxy_features", db_proxy_features)
        if db_proxy_instance_num is not None:
            pulumi.set(__self__, "db_proxy_instance_num", db_proxy_instance_num)
        if db_proxy_instance_type is not None:
            pulumi.set(__self__, "db_proxy_instance_type", db_proxy_instance_type)
        if db_proxy_ssl_enabled is not None:
            pulumi.set(__self__, "db_proxy_ssl_enabled", db_proxy_ssl_enabled)
        if effective_specific_time is not None:
            pulumi.set(__self__, "effective_specific_time", effective_specific_time)
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_network_type is not None:
            pulumi.set(__self__, "instance_network_type", instance_network_type)
        if net_type is not None:
            pulumi.set(__self__, "net_type", net_type)
        if read_only_instance_distribution_type is not None:
            pulumi.set(__self__, "read_only_instance_distribution_type", read_only_instance_distribution_type)
        if read_only_instance_max_delay_time is not None:
            pulumi.set(__self__, "read_only_instance_max_delay_time", read_only_instance_max_delay_time)
        if read_only_instance_weights is not None:
            pulumi.set(__self__, "read_only_instance_weights", read_only_instance_weights)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if ssl_expired_time is not None:
            pulumi.set(__self__, "ssl_expired_time", ssl_expired_time)
        if switch_time is not None:
            pulumi.set(__self__, "switch_time", switch_time)
        if upgrade_time is not None:
            pulumi.set(__self__, "upgrade_time", upgrade_time)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="dbProxyConnectStringPort")
    def db_proxy_connect_string_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port number that is associated with the proxy endpoint.
        """
        return pulumi.get(self, "db_proxy_connect_string_port")

    @db_proxy_connect_string_port.setter
    def db_proxy_connect_string_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "db_proxy_connect_string_port", value)

    @_builtins.property
    @pulumi.getter(name="dbProxyConnectionPrefix")
    def db_proxy_connection_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new prefix of the proxy endpoint. Enter a prefix.
        """
        return pulumi.get(self, "db_proxy_connection_prefix")

    @db_proxy_connection_prefix.setter
    def db_proxy_connection_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_proxy_connection_prefix", value)

    @_builtins.property
    @pulumi.getter(name="dbProxyConnectionString")
    def db_proxy_connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Connection instance string.
        """
        return pulumi.get(self, "db_proxy_connection_string")

    @db_proxy_connection_string.setter
    def db_proxy_connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_proxy_connection_string", value)

    @_builtins.property
    @pulumi.getter(name="dbProxyEndpointAliases")
    def db_proxy_endpoint_aliases(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Remarks of agent terminal.
        """
        return pulumi.get(self, "db_proxy_endpoint_aliases")

    @db_proxy_endpoint_aliases.setter
    def db_proxy_endpoint_aliases(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_proxy_endpoint_aliases", value)

    @_builtins.property
    @pulumi.getter(name="dbProxyEndpointId")
    def db_proxy_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Proxy connection address ID.
        """
        return pulumi.get(self, "db_proxy_endpoint_id")

    @db_proxy_endpoint_id.setter
    def db_proxy_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_proxy_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="dbProxyEndpointReadWriteMode")
    def db_proxy_endpoint_read_write_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The read and write attributes of the proxy terminal. Valid values:
        - ReadWrite: The proxy terminal connects to the primary instance and can receive both read and write requests.
        - ReadOnly: The proxy terminal does not connect to the primary instance and can receive only read requests. This is the default value.

        > **NOTE:** Note This setting causes your instance to restart. Proceed with caution.
        """
        return pulumi.get(self, "db_proxy_endpoint_read_write_mode")

    @db_proxy_endpoint_read_write_mode.setter
    def db_proxy_endpoint_read_write_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_proxy_endpoint_read_write_mode", value)

    @_builtins.property
    @pulumi.getter(name="dbProxyFeatures")
    def db_proxy_features(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The features that you want to enable for the proxy endpoint. If you specify more than one feature, separate the features with semicolons (;). Format: Feature 1:Status;Feature 2:Status;.... Do not add a semicolon (;) at the end of the last value. Valid feature values:
        - ReadWriteSpliting: read/write splitting.
        - ConnectionPersist: connection pooling.
        - TransactionReadSqlRouteOptimizeStatus: transaction splitting.
        Valid status values:
        - 1: enabled.
        - 0: disabled.

        > **NOTE:** Note You must specify this parameter only when the read/write splitting feature is enabled.
        """
        return pulumi.get(self, "db_proxy_features")

    @db_proxy_features.setter
    def db_proxy_features(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_proxy_features", value)

    @_builtins.property
    @pulumi.getter(name="dbProxyInstanceNum")
    def db_proxy_instance_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of proxy instances that are enabled. Valid values: 1 to 60.
        """
        return pulumi.get(self, "db_proxy_instance_num")

    @db_proxy_instance_num.setter
    def db_proxy_instance_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "db_proxy_instance_num", value)

    @_builtins.property
    @pulumi.getter(name="dbProxyInstanceType")
    def db_proxy_instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database proxy type. Valid values:
        - common: universal proxy.
        - exclusive: Exclusive proxy (default).
        """
        return pulumi.get(self, "db_proxy_instance_type")

    @db_proxy_instance_type.setter
    def db_proxy_instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_proxy_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="dbProxySslEnabled")
    def db_proxy_ssl_enabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SSL configuration setting that you want to apply on the instance. Valid values:
        - Close: disables SSL encryption.
        - Open: enables SSL encryption or modifies the endpoint that requires SSL encryption.
        - Update: updates the validity period of the SSL certificate.
        """
        return pulumi.get(self, "db_proxy_ssl_enabled")

    @db_proxy_ssl_enabled.setter
    def db_proxy_ssl_enabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_proxy_ssl_enabled", value)

    @_builtins.property
    @pulumi.getter(name="effectiveSpecificTime")
    def effective_specific_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The point in time at which you want to apply the new database proxy settings. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        """
        return pulumi.get(self, "effective_specific_time")

    @effective_specific_time.setter
    def effective_specific_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_specific_time", value)

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When modifying the number of proxy instances,The time when you want to apply the new database proxy settings.Valid values:
        - Immediate: ApsaraDB RDS immediately applies the new settings.
        - MaintainTime: ApsaraDB RDS applies the new settings during the maintenance window that you specified. For more information, see Modify the maintenance window.
        - SpecificTime: ApsaraDB RDS applies the new settings at a specified point in time.

        > **NOTE:** Note If you set the EffectiveTime parameter to SpecificTime, you must specify the EffectiveSpecificTime parameter.
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_time", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of instance that can run database.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceNetworkType")
    def instance_network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the instance. Set the value to VPC.
        """
        return pulumi.get(self, "instance_network_type")

    @instance_network_type.setter
    def instance_network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_network_type", value)

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network type of proxy connection address.
        """
        return pulumi.get(self, "net_type")

    @net_type.setter
    def net_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "net_type", value)

    @_builtins.property
    @pulumi.getter(name="readOnlyInstanceDistributionType")
    def read_only_instance_distribution_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy that is used to allocate read weights. Valid values:
        - Standard: ApsaraDB RDS automatically allocates read weights to the instance and its read-only instances based on the specifications of the instances.
        - Custom: You must manually allocate read weights to the instance and its read-only instances.

        > **NOTE:** Note If you set the ReadOnlyInstanceDistributionType parameter to Custom, you must specify the ReadOnlyInstanceWeight parameter.
        """
        return pulumi.get(self, "read_only_instance_distribution_type")

    @read_only_instance_distribution_type.setter
    def read_only_instance_distribution_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "read_only_instance_distribution_type", value)

    @_builtins.property
    @pulumi.getter(name="readOnlyInstanceMaxDelayTime")
    def read_only_instance_max_delay_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum latency threshold that is allowed for read/write splitting. If the latency on a read-only instance exceeds the threshold that you specified, ApsaraDB RDS no longer forwards read requests to the read-only instance. If you do not specify this parameter, the default value of this parameter is retained. Unit: seconds. Valid values: 0 to 3600.

        > **NOTE:** Note If the instance runs PostgreSQL, you can enable only the read/write splitting feature, which is specified by ReadWriteSpliting.
        """
        return pulumi.get(self, "read_only_instance_max_delay_time")

    @read_only_instance_max_delay_time.setter
    def read_only_instance_max_delay_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_only_instance_max_delay_time", value)

    @_builtins.property
    @pulumi.getter(name="readOnlyInstanceWeights")
    def read_only_instance_weights(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RdsDbProxyReadOnlyInstanceWeightArgs']]]]:
        """
        A list of the read weights of the instance and its read-only instances.  It contains two sub-fields(instance_id and weight). Read weights increase in increments of 100, and the maximum read weight is 10000. See `read_only_instance_weight` below.
        """
        return pulumi.get(self, "read_only_instance_weights")

    @read_only_instance_weights.setter
    def read_only_instance_weights(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RdsDbProxyReadOnlyInstanceWeightArgs']]]]):
        pulumi.set(self, "read_only_instance_weights", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="sslExpiredTime")
    def ssl_expired_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the certificate expires.
        """
        return pulumi.get(self, "ssl_expired_time")

    @ssl_expired_time.setter
    def ssl_expired_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_expired_time", value)

    @_builtins.property
    @pulumi.getter(name="switchTime")
    def switch_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The point in time at which you want to upgrade the database proxy version of the instance. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        """
        return pulumi.get(self, "switch_time")

    @switch_time.setter
    def switch_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "switch_time", value)

    @_builtins.property
    @pulumi.getter(name="upgradeTime")
    def upgrade_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when you want to upgrade the database proxy version of the instance. Valid values:
        - MaintainTime: ApsaraDB RDS performs the upgrade during the maintenance window that you specified. This is the default value. For more information, see Modify the maintenance window.
        - Immediate: ApsaraDB RDS immediately performs the upgrade.
        - SpecificTime: ApsaraDB RDS performs the upgrade at a specified point in time.
        """
        return pulumi.get(self, "upgrade_time")

    @upgrade_time.setter
    def upgrade_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upgrade_time", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the virtual private cloud (VPC) to which the instance belongs.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the vSwitch that is associated with the specified VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:rds/rdsDbProxy:RdsDbProxy")
class RdsDbProxy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_proxy_connect_string_port: Optional[pulumi.Input[_builtins.int]] = None,
                 db_proxy_connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_endpoint_read_write_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_features: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_instance_num: Optional[pulumi.Input[_builtins.int]] = None,
                 db_proxy_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_ssl_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_specific_time: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only_instance_distribution_type: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only_instance_max_delay_time: Optional[pulumi.Input[_builtins.int]] = None,
                 read_only_instance_weights: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RdsDbProxyReadOnlyInstanceWeightArgs', 'RdsDbProxyReadOnlyInstanceWeightArgsDict']]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 switch_time: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_time: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Information about RDS database exclusive agent and its usage, see [What is RDS DB Proxy](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/api-rds-2014-08-15-modifydbproxy).

        > **NOTE:** Available since v1.193.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.rds.get_zones(engine="MySQL",
            engine_version="5.6")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=name)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_instance = alicloud.rds.Instance("default",
            engine="MySQL",
            engine_version="5.7",
            instance_type="rds.mysql.c1.large",
            instance_storage=20,
            instance_charge_type="Postpaid",
            instance_name=name,
            vswitch_id=default_switch.id,
            db_instance_storage_type="local_ssd")
        default_read_only_instance = alicloud.rds.ReadOnlyInstance("default",
            zone_id=default_instance.zone_id,
            master_db_instance_id=default_instance.id,
            engine_version=default_instance.engine_version,
            instance_storage=default_instance.instance_storage,
            instance_type=default_instance.instance_type,
            instance_name=f"{name}readonly",
            vswitch_id=default_switch.id)
        default_rds_db_proxy = alicloud.rds.RdsDbProxy("default",
            instance_id=default_instance.id,
            instance_network_type="VPC",
            vpc_id=default_instance.vpc_id,
            vswitch_id=default_instance.vswitch_id,
            db_proxy_instance_num=2,
            db_proxy_connection_prefix="example",
            db_proxy_connect_string_port=3306,
            db_proxy_endpoint_read_write_mode="ReadWrite",
            read_only_instance_max_delay_time=90,
            db_proxy_features="TransactionReadSqlRouteOptimizeStatus:1;ConnectionPersist:1;ReadWriteSpliting:1",
            read_only_instance_distribution_type="Custom",
            read_only_instance_weights=[
                {
                    "instance_id": default_instance.id,
                    "weight": "100",
                },
                {
                    "instance_id": default_read_only_instance.id,
                    "weight": "500",
                },
            ])
        ```

        > **NOTE:** Resource `rds.RdsDbProxy` should be created after `rds.ReadOnlyInstance`, so the `depends_on` statement is necessary.

        ## Import

        RDS database proxy feature can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rds/rdsDbProxy:RdsDbProxy example abc12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] db_proxy_connect_string_port: The port number that is associated with the proxy endpoint.
        :param pulumi.Input[_builtins.str] db_proxy_connection_prefix: The new prefix of the proxy endpoint. Enter a prefix.
        :param pulumi.Input[_builtins.str] db_proxy_endpoint_read_write_mode: The read and write attributes of the proxy terminal. Valid values:
               - ReadWrite: The proxy terminal connects to the primary instance and can receive both read and write requests.
               - ReadOnly: The proxy terminal does not connect to the primary instance and can receive only read requests. This is the default value.
               
               > **NOTE:** Note This setting causes your instance to restart. Proceed with caution.
        :param pulumi.Input[_builtins.str] db_proxy_features: The features that you want to enable for the proxy endpoint. If you specify more than one feature, separate the features with semicolons (;). Format: Feature 1:Status;Feature 2:Status;.... Do not add a semicolon (;) at the end of the last value. Valid feature values:
               - ReadWriteSpliting: read/write splitting.
               - ConnectionPersist: connection pooling.
               - TransactionReadSqlRouteOptimizeStatus: transaction splitting.
               Valid status values:
               - 1: enabled.
               - 0: disabled.
               
               > **NOTE:** Note You must specify this parameter only when the read/write splitting feature is enabled.
        :param pulumi.Input[_builtins.int] db_proxy_instance_num: The number of proxy instances that are enabled. Valid values: 1 to 60.
        :param pulumi.Input[_builtins.str] db_proxy_instance_type: The database proxy type. Valid values:
               - common: universal proxy.
               - exclusive: Exclusive proxy (default).
        :param pulumi.Input[_builtins.str] db_proxy_ssl_enabled: The SSL configuration setting that you want to apply on the instance. Valid values:
               - Close: disables SSL encryption.
               - Open: enables SSL encryption or modifies the endpoint that requires SSL encryption.
               - Update: updates the validity period of the SSL certificate.
        :param pulumi.Input[_builtins.str] effective_specific_time: The point in time at which you want to apply the new database proxy settings. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        :param pulumi.Input[_builtins.str] effective_time: When modifying the number of proxy instances,The time when you want to apply the new database proxy settings.Valid values:
               - Immediate: ApsaraDB RDS immediately applies the new settings.
               - MaintainTime: ApsaraDB RDS applies the new settings during the maintenance window that you specified. For more information, see Modify the maintenance window.
               - SpecificTime: ApsaraDB RDS applies the new settings at a specified point in time.
               
               > **NOTE:** Note If you set the EffectiveTime parameter to SpecificTime, you must specify the EffectiveSpecificTime parameter.
        :param pulumi.Input[_builtins.str] instance_id: The Id of instance that can run database.
        :param pulumi.Input[_builtins.str] instance_network_type: The network type of the instance. Set the value to VPC.
        :param pulumi.Input[_builtins.str] read_only_instance_distribution_type: The policy that is used to allocate read weights. Valid values:
               - Standard: ApsaraDB RDS automatically allocates read weights to the instance and its read-only instances based on the specifications of the instances.
               - Custom: You must manually allocate read weights to the instance and its read-only instances.
               
               > **NOTE:** Note If you set the ReadOnlyInstanceDistributionType parameter to Custom, you must specify the ReadOnlyInstanceWeight parameter.
        :param pulumi.Input[_builtins.int] read_only_instance_max_delay_time: The maximum latency threshold that is allowed for read/write splitting. If the latency on a read-only instance exceeds the threshold that you specified, ApsaraDB RDS no longer forwards read requests to the read-only instance. If you do not specify this parameter, the default value of this parameter is retained. Unit: seconds. Valid values: 0 to 3600.
               
               > **NOTE:** Note If the instance runs PostgreSQL, you can enable only the read/write splitting feature, which is specified by ReadWriteSpliting.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RdsDbProxyReadOnlyInstanceWeightArgs', 'RdsDbProxyReadOnlyInstanceWeightArgsDict']]]] read_only_instance_weights: A list of the read weights of the instance and its read-only instances.  It contains two sub-fields(instance_id and weight). Read weights increase in increments of 100, and the maximum read weight is 10000. See `read_only_instance_weight` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] switch_time: The point in time at which you want to upgrade the database proxy version of the instance. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        :param pulumi.Input[_builtins.str] upgrade_time: The time when you want to upgrade the database proxy version of the instance. Valid values:
               - MaintainTime: ApsaraDB RDS performs the upgrade during the maintenance window that you specified. This is the default value. For more information, see Modify the maintenance window.
               - Immediate: ApsaraDB RDS immediately performs the upgrade.
               - SpecificTime: ApsaraDB RDS performs the upgrade at a specified point in time.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC) to which the instance belongs.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch that is associated with the specified VPC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RdsDbProxyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Information about RDS database exclusive agent and its usage, see [What is RDS DB Proxy](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/api-rds-2014-08-15-modifydbproxy).

        > **NOTE:** Available since v1.193.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.rds.get_zones(engine="MySQL",
            engine_version="5.6")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=name)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_instance = alicloud.rds.Instance("default",
            engine="MySQL",
            engine_version="5.7",
            instance_type="rds.mysql.c1.large",
            instance_storage=20,
            instance_charge_type="Postpaid",
            instance_name=name,
            vswitch_id=default_switch.id,
            db_instance_storage_type="local_ssd")
        default_read_only_instance = alicloud.rds.ReadOnlyInstance("default",
            zone_id=default_instance.zone_id,
            master_db_instance_id=default_instance.id,
            engine_version=default_instance.engine_version,
            instance_storage=default_instance.instance_storage,
            instance_type=default_instance.instance_type,
            instance_name=f"{name}readonly",
            vswitch_id=default_switch.id)
        default_rds_db_proxy = alicloud.rds.RdsDbProxy("default",
            instance_id=default_instance.id,
            instance_network_type="VPC",
            vpc_id=default_instance.vpc_id,
            vswitch_id=default_instance.vswitch_id,
            db_proxy_instance_num=2,
            db_proxy_connection_prefix="example",
            db_proxy_connect_string_port=3306,
            db_proxy_endpoint_read_write_mode="ReadWrite",
            read_only_instance_max_delay_time=90,
            db_proxy_features="TransactionReadSqlRouteOptimizeStatus:1;ConnectionPersist:1;ReadWriteSpliting:1",
            read_only_instance_distribution_type="Custom",
            read_only_instance_weights=[
                {
                    "instance_id": default_instance.id,
                    "weight": "100",
                },
                {
                    "instance_id": default_read_only_instance.id,
                    "weight": "500",
                },
            ])
        ```

        > **NOTE:** Resource `rds.RdsDbProxy` should be created after `rds.ReadOnlyInstance`, so the `depends_on` statement is necessary.

        ## Import

        RDS database proxy feature can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rds/rdsDbProxy:RdsDbProxy example abc12345678
        ```

        :param str resource_name: The name of the resource.
        :param RdsDbProxyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RdsDbProxyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_proxy_connect_string_port: Optional[pulumi.Input[_builtins.int]] = None,
                 db_proxy_connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_endpoint_read_write_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_features: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_instance_num: Optional[pulumi.Input[_builtins.int]] = None,
                 db_proxy_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_proxy_ssl_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_specific_time: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only_instance_distribution_type: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only_instance_max_delay_time: Optional[pulumi.Input[_builtins.int]] = None,
                 read_only_instance_weights: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RdsDbProxyReadOnlyInstanceWeightArgs', 'RdsDbProxyReadOnlyInstanceWeightArgsDict']]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 switch_time: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_time: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RdsDbProxyArgs.__new__(RdsDbProxyArgs)

            __props__.__dict__["db_proxy_connect_string_port"] = db_proxy_connect_string_port
            __props__.__dict__["db_proxy_connection_prefix"] = db_proxy_connection_prefix
            __props__.__dict__["db_proxy_endpoint_read_write_mode"] = db_proxy_endpoint_read_write_mode
            __props__.__dict__["db_proxy_features"] = db_proxy_features
            if db_proxy_instance_num is None and not opts.urn:
                raise TypeError("Missing required property 'db_proxy_instance_num'")
            __props__.__dict__["db_proxy_instance_num"] = db_proxy_instance_num
            __props__.__dict__["db_proxy_instance_type"] = db_proxy_instance_type
            __props__.__dict__["db_proxy_ssl_enabled"] = db_proxy_ssl_enabled
            __props__.__dict__["effective_specific_time"] = effective_specific_time
            __props__.__dict__["effective_time"] = effective_time
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if instance_network_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_network_type'")
            __props__.__dict__["instance_network_type"] = instance_network_type
            __props__.__dict__["read_only_instance_distribution_type"] = read_only_instance_distribution_type
            __props__.__dict__["read_only_instance_max_delay_time"] = read_only_instance_max_delay_time
            __props__.__dict__["read_only_instance_weights"] = read_only_instance_weights
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["switch_time"] = switch_time
            __props__.__dict__["upgrade_time"] = upgrade_time
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["db_proxy_connection_string"] = None
            __props__.__dict__["db_proxy_endpoint_aliases"] = None
            __props__.__dict__["db_proxy_endpoint_id"] = None
            __props__.__dict__["net_type"] = None
            __props__.__dict__["ssl_expired_time"] = None
        super(RdsDbProxy, __self__).__init__(
            'alicloud:rds/rdsDbProxy:RdsDbProxy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            db_proxy_connect_string_port: Optional[pulumi.Input[_builtins.int]] = None,
            db_proxy_connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            db_proxy_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            db_proxy_endpoint_aliases: Optional[pulumi.Input[_builtins.str]] = None,
            db_proxy_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            db_proxy_endpoint_read_write_mode: Optional[pulumi.Input[_builtins.str]] = None,
            db_proxy_features: Optional[pulumi.Input[_builtins.str]] = None,
            db_proxy_instance_num: Optional[pulumi.Input[_builtins.int]] = None,
            db_proxy_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            db_proxy_ssl_enabled: Optional[pulumi.Input[_builtins.str]] = None,
            effective_specific_time: Optional[pulumi.Input[_builtins.str]] = None,
            effective_time: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
            net_type: Optional[pulumi.Input[_builtins.str]] = None,
            read_only_instance_distribution_type: Optional[pulumi.Input[_builtins.str]] = None,
            read_only_instance_max_delay_time: Optional[pulumi.Input[_builtins.int]] = None,
            read_only_instance_weights: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RdsDbProxyReadOnlyInstanceWeightArgs', 'RdsDbProxyReadOnlyInstanceWeightArgsDict']]]]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_expired_time: Optional[pulumi.Input[_builtins.str]] = None,
            switch_time: Optional[pulumi.Input[_builtins.str]] = None,
            upgrade_time: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RdsDbProxy':
        """
        Get an existing RdsDbProxy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] db_proxy_connect_string_port: The port number that is associated with the proxy endpoint.
        :param pulumi.Input[_builtins.str] db_proxy_connection_prefix: The new prefix of the proxy endpoint. Enter a prefix.
        :param pulumi.Input[_builtins.str] db_proxy_connection_string: Connection instance string.
        :param pulumi.Input[_builtins.str] db_proxy_endpoint_aliases: Remarks of agent terminal.
        :param pulumi.Input[_builtins.str] db_proxy_endpoint_id: Proxy connection address ID.
        :param pulumi.Input[_builtins.str] db_proxy_endpoint_read_write_mode: The read and write attributes of the proxy terminal. Valid values:
               - ReadWrite: The proxy terminal connects to the primary instance and can receive both read and write requests.
               - ReadOnly: The proxy terminal does not connect to the primary instance and can receive only read requests. This is the default value.
               
               > **NOTE:** Note This setting causes your instance to restart. Proceed with caution.
        :param pulumi.Input[_builtins.str] db_proxy_features: The features that you want to enable for the proxy endpoint. If you specify more than one feature, separate the features with semicolons (;). Format: Feature 1:Status;Feature 2:Status;.... Do not add a semicolon (;) at the end of the last value. Valid feature values:
               - ReadWriteSpliting: read/write splitting.
               - ConnectionPersist: connection pooling.
               - TransactionReadSqlRouteOptimizeStatus: transaction splitting.
               Valid status values:
               - 1: enabled.
               - 0: disabled.
               
               > **NOTE:** Note You must specify this parameter only when the read/write splitting feature is enabled.
        :param pulumi.Input[_builtins.int] db_proxy_instance_num: The number of proxy instances that are enabled. Valid values: 1 to 60.
        :param pulumi.Input[_builtins.str] db_proxy_instance_type: The database proxy type. Valid values:
               - common: universal proxy.
               - exclusive: Exclusive proxy (default).
        :param pulumi.Input[_builtins.str] db_proxy_ssl_enabled: The SSL configuration setting that you want to apply on the instance. Valid values:
               - Close: disables SSL encryption.
               - Open: enables SSL encryption or modifies the endpoint that requires SSL encryption.
               - Update: updates the validity period of the SSL certificate.
        :param pulumi.Input[_builtins.str] effective_specific_time: The point in time at which you want to apply the new database proxy settings. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        :param pulumi.Input[_builtins.str] effective_time: When modifying the number of proxy instances,The time when you want to apply the new database proxy settings.Valid values:
               - Immediate: ApsaraDB RDS immediately applies the new settings.
               - MaintainTime: ApsaraDB RDS applies the new settings during the maintenance window that you specified. For more information, see Modify the maintenance window.
               - SpecificTime: ApsaraDB RDS applies the new settings at a specified point in time.
               
               > **NOTE:** Note If you set the EffectiveTime parameter to SpecificTime, you must specify the EffectiveSpecificTime parameter.
        :param pulumi.Input[_builtins.str] instance_id: The Id of instance that can run database.
        :param pulumi.Input[_builtins.str] instance_network_type: The network type of the instance. Set the value to VPC.
        :param pulumi.Input[_builtins.str] net_type: Network type of proxy connection address.
        :param pulumi.Input[_builtins.str] read_only_instance_distribution_type: The policy that is used to allocate read weights. Valid values:
               - Standard: ApsaraDB RDS automatically allocates read weights to the instance and its read-only instances based on the specifications of the instances.
               - Custom: You must manually allocate read weights to the instance and its read-only instances.
               
               > **NOTE:** Note If you set the ReadOnlyInstanceDistributionType parameter to Custom, you must specify the ReadOnlyInstanceWeight parameter.
        :param pulumi.Input[_builtins.int] read_only_instance_max_delay_time: The maximum latency threshold that is allowed for read/write splitting. If the latency on a read-only instance exceeds the threshold that you specified, ApsaraDB RDS no longer forwards read requests to the read-only instance. If you do not specify this parameter, the default value of this parameter is retained. Unit: seconds. Valid values: 0 to 3600.
               
               > **NOTE:** Note If the instance runs PostgreSQL, you can enable only the read/write splitting feature, which is specified by ReadWriteSpliting.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RdsDbProxyReadOnlyInstanceWeightArgs', 'RdsDbProxyReadOnlyInstanceWeightArgsDict']]]] read_only_instance_weights: A list of the read weights of the instance and its read-only instances.  It contains two sub-fields(instance_id and weight). Read weights increase in increments of 100, and the maximum read weight is 10000. See `read_only_instance_weight` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] ssl_expired_time: The time when the certificate expires.
        :param pulumi.Input[_builtins.str] switch_time: The point in time at which you want to upgrade the database proxy version of the instance. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        :param pulumi.Input[_builtins.str] upgrade_time: The time when you want to upgrade the database proxy version of the instance. Valid values:
               - MaintainTime: ApsaraDB RDS performs the upgrade during the maintenance window that you specified. This is the default value. For more information, see Modify the maintenance window.
               - Immediate: ApsaraDB RDS immediately performs the upgrade.
               - SpecificTime: ApsaraDB RDS performs the upgrade at a specified point in time.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC) to which the instance belongs.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch that is associated with the specified VPC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RdsDbProxyState.__new__(_RdsDbProxyState)

        __props__.__dict__["db_proxy_connect_string_port"] = db_proxy_connect_string_port
        __props__.__dict__["db_proxy_connection_prefix"] = db_proxy_connection_prefix
        __props__.__dict__["db_proxy_connection_string"] = db_proxy_connection_string
        __props__.__dict__["db_proxy_endpoint_aliases"] = db_proxy_endpoint_aliases
        __props__.__dict__["db_proxy_endpoint_id"] = db_proxy_endpoint_id
        __props__.__dict__["db_proxy_endpoint_read_write_mode"] = db_proxy_endpoint_read_write_mode
        __props__.__dict__["db_proxy_features"] = db_proxy_features
        __props__.__dict__["db_proxy_instance_num"] = db_proxy_instance_num
        __props__.__dict__["db_proxy_instance_type"] = db_proxy_instance_type
        __props__.__dict__["db_proxy_ssl_enabled"] = db_proxy_ssl_enabled
        __props__.__dict__["effective_specific_time"] = effective_specific_time
        __props__.__dict__["effective_time"] = effective_time
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_network_type"] = instance_network_type
        __props__.__dict__["net_type"] = net_type
        __props__.__dict__["read_only_instance_distribution_type"] = read_only_instance_distribution_type
        __props__.__dict__["read_only_instance_max_delay_time"] = read_only_instance_max_delay_time
        __props__.__dict__["read_only_instance_weights"] = read_only_instance_weights
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["ssl_expired_time"] = ssl_expired_time
        __props__.__dict__["switch_time"] = switch_time
        __props__.__dict__["upgrade_time"] = upgrade_time
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        return RdsDbProxy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dbProxyConnectStringPort")
    def db_proxy_connect_string_port(self) -> pulumi.Output[_builtins.int]:
        """
        The port number that is associated with the proxy endpoint.
        """
        return pulumi.get(self, "db_proxy_connect_string_port")

    @_builtins.property
    @pulumi.getter(name="dbProxyConnectionPrefix")
    def db_proxy_connection_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        The new prefix of the proxy endpoint. Enter a prefix.
        """
        return pulumi.get(self, "db_proxy_connection_prefix")

    @_builtins.property
    @pulumi.getter(name="dbProxyConnectionString")
    def db_proxy_connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        Connection instance string.
        """
        return pulumi.get(self, "db_proxy_connection_string")

    @_builtins.property
    @pulumi.getter(name="dbProxyEndpointAliases")
    def db_proxy_endpoint_aliases(self) -> pulumi.Output[_builtins.str]:
        """
        Remarks of agent terminal.
        """
        return pulumi.get(self, "db_proxy_endpoint_aliases")

    @_builtins.property
    @pulumi.getter(name="dbProxyEndpointId")
    def db_proxy_endpoint_id(self) -> pulumi.Output[_builtins.str]:
        """
        Proxy connection address ID.
        """
        return pulumi.get(self, "db_proxy_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="dbProxyEndpointReadWriteMode")
    def db_proxy_endpoint_read_write_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The read and write attributes of the proxy terminal. Valid values:
        - ReadWrite: The proxy terminal connects to the primary instance and can receive both read and write requests.
        - ReadOnly: The proxy terminal does not connect to the primary instance and can receive only read requests. This is the default value.

        > **NOTE:** Note This setting causes your instance to restart. Proceed with caution.
        """
        return pulumi.get(self, "db_proxy_endpoint_read_write_mode")

    @_builtins.property
    @pulumi.getter(name="dbProxyFeatures")
    def db_proxy_features(self) -> pulumi.Output[_builtins.str]:
        """
        The features that you want to enable for the proxy endpoint. If you specify more than one feature, separate the features with semicolons (;). Format: Feature 1:Status;Feature 2:Status;.... Do not add a semicolon (;) at the end of the last value. Valid feature values:
        - ReadWriteSpliting: read/write splitting.
        - ConnectionPersist: connection pooling.
        - TransactionReadSqlRouteOptimizeStatus: transaction splitting.
        Valid status values:
        - 1: enabled.
        - 0: disabled.

        > **NOTE:** Note You must specify this parameter only when the read/write splitting feature is enabled.
        """
        return pulumi.get(self, "db_proxy_features")

    @_builtins.property
    @pulumi.getter(name="dbProxyInstanceNum")
    def db_proxy_instance_num(self) -> pulumi.Output[_builtins.int]:
        """
        The number of proxy instances that are enabled. Valid values: 1 to 60.
        """
        return pulumi.get(self, "db_proxy_instance_num")

    @_builtins.property
    @pulumi.getter(name="dbProxyInstanceType")
    def db_proxy_instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The database proxy type. Valid values:
        - common: universal proxy.
        - exclusive: Exclusive proxy (default).
        """
        return pulumi.get(self, "db_proxy_instance_type")

    @_builtins.property
    @pulumi.getter(name="dbProxySslEnabled")
    def db_proxy_ssl_enabled(self) -> pulumi.Output[_builtins.str]:
        """
        The SSL configuration setting that you want to apply on the instance. Valid values:
        - Close: disables SSL encryption.
        - Open: enables SSL encryption or modifies the endpoint that requires SSL encryption.
        - Update: updates the validity period of the SSL certificate.
        """
        return pulumi.get(self, "db_proxy_ssl_enabled")

    @_builtins.property
    @pulumi.getter(name="effectiveSpecificTime")
    def effective_specific_time(self) -> pulumi.Output[_builtins.str]:
        """
        The point in time at which you want to apply the new database proxy settings. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        """
        return pulumi.get(self, "effective_specific_time")

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> pulumi.Output[_builtins.str]:
        """
        When modifying the number of proxy instances,The time when you want to apply the new database proxy settings.Valid values:
        - Immediate: ApsaraDB RDS immediately applies the new settings.
        - MaintainTime: ApsaraDB RDS applies the new settings during the maintenance window that you specified. For more information, see Modify the maintenance window.
        - SpecificTime: ApsaraDB RDS applies the new settings at a specified point in time.

        > **NOTE:** Note If you set the EffectiveTime parameter to SpecificTime, you must specify the EffectiveSpecificTime parameter.
        """
        return pulumi.get(self, "effective_time")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Id of instance that can run database.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceNetworkType")
    def instance_network_type(self) -> pulumi.Output[_builtins.str]:
        """
        The network type of the instance. Set the value to VPC.
        """
        return pulumi.get(self, "instance_network_type")

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> pulumi.Output[_builtins.str]:
        """
        Network type of proxy connection address.
        """
        return pulumi.get(self, "net_type")

    @_builtins.property
    @pulumi.getter(name="readOnlyInstanceDistributionType")
    def read_only_instance_distribution_type(self) -> pulumi.Output[_builtins.str]:
        """
        The policy that is used to allocate read weights. Valid values:
        - Standard: ApsaraDB RDS automatically allocates read weights to the instance and its read-only instances based on the specifications of the instances.
        - Custom: You must manually allocate read weights to the instance and its read-only instances.

        > **NOTE:** Note If you set the ReadOnlyInstanceDistributionType parameter to Custom, you must specify the ReadOnlyInstanceWeight parameter.
        """
        return pulumi.get(self, "read_only_instance_distribution_type")

    @_builtins.property
    @pulumi.getter(name="readOnlyInstanceMaxDelayTime")
    def read_only_instance_max_delay_time(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum latency threshold that is allowed for read/write splitting. If the latency on a read-only instance exceeds the threshold that you specified, ApsaraDB RDS no longer forwards read requests to the read-only instance. If you do not specify this parameter, the default value of this parameter is retained. Unit: seconds. Valid values: 0 to 3600.

        > **NOTE:** Note If the instance runs PostgreSQL, you can enable only the read/write splitting feature, which is specified by ReadWriteSpliting.
        """
        return pulumi.get(self, "read_only_instance_max_delay_time")

    @_builtins.property
    @pulumi.getter(name="readOnlyInstanceWeights")
    def read_only_instance_weights(self) -> pulumi.Output[Sequence['outputs.RdsDbProxyReadOnlyInstanceWeight']]:
        """
        A list of the read weights of the instance and its read-only instances.  It contains two sub-fields(instance_id and weight). Read weights increase in increments of 100, and the maximum read weight is 10000. See `read_only_instance_weight` below.
        """
        return pulumi.get(self, "read_only_instance_weights")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="sslExpiredTime")
    def ssl_expired_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the certificate expires.
        """
        return pulumi.get(self, "ssl_expired_time")

    @_builtins.property
    @pulumi.getter(name="switchTime")
    def switch_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The point in time at which you want to upgrade the database proxy version of the instance. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        """
        return pulumi.get(self, "switch_time")

    @_builtins.property
    @pulumi.getter(name="upgradeTime")
    def upgrade_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The time when you want to upgrade the database proxy version of the instance. Valid values:
        - MaintainTime: ApsaraDB RDS performs the upgrade during the maintenance window that you specified. This is the default value. For more information, see Modify the maintenance window.
        - Immediate: ApsaraDB RDS immediately performs the upgrade.
        - SpecificTime: ApsaraDB RDS performs the upgrade at a specified point in time.
        """
        return pulumi.get(self, "upgrade_time")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the virtual private cloud (VPC) to which the instance belongs.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the vSwitch that is associated with the specified VPC.
        """
        return pulumi.get(self, "vswitch_id")

