# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetResourceDirectoriesResult',
    'AwaitableGetResourceDirectoriesResult',
    'get_resource_directories',
    'get_resource_directories_output',
]

@pulumi.output_type
class GetResourceDirectoriesResult:
    """
    A collection of values returned by getResourceDirectories.
    """
    def __init__(__self__, directories=None, id=None, output_file=None):
        if directories and not isinstance(directories, list):
            raise TypeError("Expected argument 'directories' to be a list")
        pulumi.set(__self__, "directories", directories)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter
    def directories(self) -> Sequence['outputs.GetResourceDirectoriesDirectoryResult']:
        """
        A list of resource directories. Each element contains the following attributes:
        """
        return pulumi.get(self, "directories")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetResourceDirectoriesResult(GetResourceDirectoriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceDirectoriesResult(
            directories=self.directories,
            id=self.id,
            output_file=self.output_file)


def get_resource_directories(output_file: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceDirectoriesResult:
    """
    This data source provides the Resource Manager Resource Directories of the current Alibaba Cloud user.

    > **NOTE:**  Available in 1.86.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.resourcemanager.get_resource_directories()
    pulumi.export("resourceDirectoryId", default.directories[0].id)
    ```


    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:resourcemanager/getResourceDirectories:getResourceDirectories', __args__, opts=opts, typ=GetResourceDirectoriesResult).value

    return AwaitableGetResourceDirectoriesResult(
        directories=pulumi.get(__ret__, 'directories'),
        id=pulumi.get(__ret__, 'id'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_resource_directories_output(output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceDirectoriesResult]:
    """
    This data source provides the Resource Manager Resource Directories of the current Alibaba Cloud user.

    > **NOTE:**  Available in 1.86.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.resourcemanager.get_resource_directories()
    pulumi.export("resourceDirectoryId", default.directories[0].id)
    ```


    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:resourcemanager/getResourceDirectories:getResourceDirectories', __args__, opts=opts, typ=GetResourceDirectoriesResult)
    return __ret__.apply(lambda __response__: GetResourceDirectoriesResult(
        directories=pulumi.get(__response__, 'directories'),
        id=pulumi.get(__response__, 'id'),
        output_file=pulumi.get(__response__, 'output_file')))
