# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SharedResourceArgs', 'SharedResource']

@pulumi.input_type
class SharedResourceArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[_builtins.str],
                 resource_share_id: pulumi.Input[_builtins.str],
                 resource_type: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a SharedResource resource.
        :param pulumi.Input[_builtins.str] resource_id: The resource ID need shared.
        :param pulumi.Input[_builtins.str] resource_share_id: The resource share ID of resource manager.
        :param pulumi.Input[_builtins.str] resource_type: The resource type of should shared. Valid values:
               - `VSwitch`.
               - The following types are added after v1.173.0: `ROSTemplate` and `ServiceCatalogPortfolio`.
               - The following types are added after v1.192.0: `PrefixList` and `Image`.
               - The following types are added after v1.194.1: `PublicIpAddressPool`.
               - The following types are added after v1.208.0: `KMSInstance`.
               - The following types are added after v1.240.0: `Snapshot`.
               - For more information about the types of resources that can be shared, see [Services that work with Resource Sharing](https://help.aliyun.com/zh/resource-management/resource-sharing/product-overview/services-that-work-with-resource-sharing?spm=api-workbench.API%20Document.0.0.32fff3cdFveEud)
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_share_id", resource_share_id)
        pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource ID need shared.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceShareId")
    def resource_share_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource share ID of resource manager.
        """
        return pulumi.get(self, "resource_share_id")

    @resource_share_id.setter
    def resource_share_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_share_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[_builtins.str]:
        """
        The resource type of should shared. Valid values:
        - `VSwitch`.
        - The following types are added after v1.173.0: `ROSTemplate` and `ServiceCatalogPortfolio`.
        - The following types are added after v1.192.0: `PrefixList` and `Image`.
        - The following types are added after v1.194.1: `PublicIpAddressPool`.
        - The following types are added after v1.208.0: `KMSInstance`.
        - The following types are added after v1.240.0: `Snapshot`.
        - For more information about the types of resources that can be shared, see [Services that work with Resource Sharing](https://help.aliyun.com/zh/resource-management/resource-sharing/product-overview/services-that-work-with-resource-sharing?spm=api-workbench.API%20Document.0.0.32fff3cdFveEud)
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_type", value)


@pulumi.input_type
class _SharedResourceState:
    def __init__(__self__, *,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_share_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SharedResource resources.
        :param pulumi.Input[_builtins.str] resource_id: The resource ID need shared.
        :param pulumi.Input[_builtins.str] resource_share_id: The resource share ID of resource manager.
        :param pulumi.Input[_builtins.str] resource_type: The resource type of should shared. Valid values:
               - `VSwitch`.
               - The following types are added after v1.173.0: `ROSTemplate` and `ServiceCatalogPortfolio`.
               - The following types are added after v1.192.0: `PrefixList` and `Image`.
               - The following types are added after v1.194.1: `PublicIpAddressPool`.
               - The following types are added after v1.208.0: `KMSInstance`.
               - The following types are added after v1.240.0: `Snapshot`.
               - For more information about the types of resources that can be shared, see [Services that work with Resource Sharing](https://help.aliyun.com/zh/resource-management/resource-sharing/product-overview/services-that-work-with-resource-sharing?spm=api-workbench.API%20Document.0.0.32fff3cdFveEud)
        :param pulumi.Input[_builtins.str] status: The status of the Shared Resource.
        """
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_share_id is not None:
            pulumi.set(__self__, "resource_share_id", resource_share_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID need shared.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceShareId")
    def resource_share_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource share ID of resource manager.
        """
        return pulumi.get(self, "resource_share_id")

    @resource_share_id.setter
    def resource_share_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_share_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource type of should shared. Valid values:
        - `VSwitch`.
        - The following types are added after v1.173.0: `ROSTemplate` and `ServiceCatalogPortfolio`.
        - The following types are added after v1.192.0: `PrefixList` and `Image`.
        - The following types are added after v1.194.1: `PublicIpAddressPool`.
        - The following types are added after v1.208.0: `KMSInstance`.
        - The following types are added after v1.240.0: `Snapshot`.
        - For more information about the types of resources that can be shared, see [Services that work with Resource Sharing](https://help.aliyun.com/zh/resource-management/resource-sharing/product-overview/services-that-work-with-resource-sharing?spm=api-workbench.API%20Document.0.0.32fff3cdFveEud)
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Shared Resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:resourcemanager/sharedResource:SharedResource")
class SharedResource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_share_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Resource Manager Shared Resource resource.

        For information about Resource Manager Shared Resource and how to use it, see [What is Shared Resource](https://www.alibabacloud.com/help/en/resource-management/latest/api-resourcesharing-2020-01-10-associateresourceshare).

        > **NOTE:** Available since v1.111.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tfexample"
        example = alicloud.get_zones(available_resource_creation="VSwitch")
        example_network = alicloud.vpc.Network("example",
            vpc_name=name,
            cidr_block="192.168.0.0/16")
        example_switch = alicloud.vpc.Switch("example",
            zone_id=example.zones[0].id,
            cidr_block="192.168.0.0/16",
            vpc_id=example_network.id,
            vswitch_name=name)
        example_resource_share = alicloud.resourcemanager.ResourceShare("example", resource_share_name=name)
        example_shared_resource = alicloud.resourcemanager.SharedResource("example",
            resource_id=example_switch.id,
            resource_share_id=example_resource_share.id,
            resource_type="VSwitch")
        ```

        ## Import

        Resource Manager Shared Resource can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:resourcemanager/sharedResource:SharedResource example <resource_share_id>:<resource_id>:<resource_type>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] resource_id: The resource ID need shared.
        :param pulumi.Input[_builtins.str] resource_share_id: The resource share ID of resource manager.
        :param pulumi.Input[_builtins.str] resource_type: The resource type of should shared. Valid values:
               - `VSwitch`.
               - The following types are added after v1.173.0: `ROSTemplate` and `ServiceCatalogPortfolio`.
               - The following types are added after v1.192.0: `PrefixList` and `Image`.
               - The following types are added after v1.194.1: `PublicIpAddressPool`.
               - The following types are added after v1.208.0: `KMSInstance`.
               - The following types are added after v1.240.0: `Snapshot`.
               - For more information about the types of resources that can be shared, see [Services that work with Resource Sharing](https://help.aliyun.com/zh/resource-management/resource-sharing/product-overview/services-that-work-with-resource-sharing?spm=api-workbench.API%20Document.0.0.32fff3cdFveEud)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SharedResourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Resource Manager Shared Resource resource.

        For information about Resource Manager Shared Resource and how to use it, see [What is Shared Resource](https://www.alibabacloud.com/help/en/resource-management/latest/api-resourcesharing-2020-01-10-associateresourceshare).

        > **NOTE:** Available since v1.111.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tfexample"
        example = alicloud.get_zones(available_resource_creation="VSwitch")
        example_network = alicloud.vpc.Network("example",
            vpc_name=name,
            cidr_block="192.168.0.0/16")
        example_switch = alicloud.vpc.Switch("example",
            zone_id=example.zones[0].id,
            cidr_block="192.168.0.0/16",
            vpc_id=example_network.id,
            vswitch_name=name)
        example_resource_share = alicloud.resourcemanager.ResourceShare("example", resource_share_name=name)
        example_shared_resource = alicloud.resourcemanager.SharedResource("example",
            resource_id=example_switch.id,
            resource_share_id=example_resource_share.id,
            resource_type="VSwitch")
        ```

        ## Import

        Resource Manager Shared Resource can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:resourcemanager/sharedResource:SharedResource example <resource_share_id>:<resource_id>:<resource_type>
        ```

        :param str resource_name: The name of the resource.
        :param SharedResourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SharedResourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_share_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SharedResourceArgs.__new__(SharedResourceArgs)

            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            if resource_share_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_share_id'")
            __props__.__dict__["resource_share_id"] = resource_share_id
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["status"] = None
        super(SharedResource, __self__).__init__(
            'alicloud:resourcemanager/sharedResource:SharedResource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_share_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'SharedResource':
        """
        Get an existing SharedResource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] resource_id: The resource ID need shared.
        :param pulumi.Input[_builtins.str] resource_share_id: The resource share ID of resource manager.
        :param pulumi.Input[_builtins.str] resource_type: The resource type of should shared. Valid values:
               - `VSwitch`.
               - The following types are added after v1.173.0: `ROSTemplate` and `ServiceCatalogPortfolio`.
               - The following types are added after v1.192.0: `PrefixList` and `Image`.
               - The following types are added after v1.194.1: `PublicIpAddressPool`.
               - The following types are added after v1.208.0: `KMSInstance`.
               - The following types are added after v1.240.0: `Snapshot`.
               - For more information about the types of resources that can be shared, see [Services that work with Resource Sharing](https://help.aliyun.com/zh/resource-management/resource-sharing/product-overview/services-that-work-with-resource-sharing?spm=api-workbench.API%20Document.0.0.32fff3cdFveEud)
        :param pulumi.Input[_builtins.str] status: The status of the Shared Resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SharedResourceState.__new__(_SharedResourceState)

        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["resource_share_id"] = resource_share_id
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["status"] = status
        return SharedResource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource ID need shared.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceShareId")
    def resource_share_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource share ID of resource manager.
        """
        return pulumi.get(self, "resource_share_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        The resource type of should shared. Valid values:
        - `VSwitch`.
        - The following types are added after v1.173.0: `ROSTemplate` and `ServiceCatalogPortfolio`.
        - The following types are added after v1.192.0: `PrefixList` and `Image`.
        - The following types are added after v1.194.1: `PublicIpAddressPool`.
        - The following types are added after v1.208.0: `KMSInstance`.
        - The following types are added after v1.240.0: `Snapshot`.
        - For more information about the types of resources that can be shared, see [Services that work with Resource Sharing](https://help.aliyun.com/zh/resource-management/resource-sharing/product-overview/services-that-work-with-resource-sharing?spm=api-workbench.API%20Document.0.0.32fff3cdFveEud)
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Shared Resource.
        """
        return pulumi.get(self, "status")

