# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDbInstancesResult',
    'AwaitableGetDbInstancesResult',
    'get_db_instances',
    'get_db_instances_output',
]

@pulumi.output_type
class GetDbInstancesResult:
    """
    A collection of values returned by getDbInstances.
    """
    def __init__(__self__, id=None, ids=None, instances=None, output_file=None, tags=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetDbInstancesInstanceResult']:
        """
        A list of SelectDB DBInstance. Each element contains the following attributes:
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags")


class AwaitableGetDbInstancesResult(GetDbInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbInstancesResult(
            id=self.id,
            ids=self.ids,
            instances=self.instances,
            output_file=self.output_file,
            tags=self.tags)


def get_db_instances(ids: Optional[Sequence[_builtins.str]] = None,
                     output_file: Optional[_builtins.str] = None,
                     tags: Optional[Mapping[str, _builtins.str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbInstancesResult:
    """
    This data source provides the SelectDB DBInstance of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.229.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.get_zones(available_resource_creation="VSwitch")
    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform_example"
    default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
    default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
        zone_id=default.zones[0].id)
    default_db_instance = alicloud.selectdb.DbInstance("default",
        db_instance_class="selectdb.xlarge",
        db_instance_description=name,
        cache_size=200,
        payment_type="PayAsYouGo",
        engine_minor_version="3.0.12",
        vpc_id=default_get_switches.vswitches[0].vpc_id,
        zone_id=default_get_switches.vswitches[0].zone_id,
        vswitch_id=default_get_switches.vswitches[0].id)
    default_get_db_instances = alicloud.selectdb.get_db_instances_output(ids=[default_db_instance.id])
    pulumi.export("dbInstance", default_get_db_instances.ids[0])
    ```


    :param Sequence[_builtins.str] ids: A list of DBInstance IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource. Used for instance searching.
           - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
           - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:selectdb/getDbInstances:getDbInstances', __args__, opts=opts, typ=GetDbInstancesResult).value

    return AwaitableGetDbInstancesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instances=pulumi.get(__ret__, 'instances'),
        output_file=pulumi.get(__ret__, 'output_file'),
        tags=pulumi.get(__ret__, 'tags'))
def get_db_instances_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                            output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbInstancesResult]:
    """
    This data source provides the SelectDB DBInstance of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.229.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.get_zones(available_resource_creation="VSwitch")
    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform_example"
    default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
    default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
        zone_id=default.zones[0].id)
    default_db_instance = alicloud.selectdb.DbInstance("default",
        db_instance_class="selectdb.xlarge",
        db_instance_description=name,
        cache_size=200,
        payment_type="PayAsYouGo",
        engine_minor_version="3.0.12",
        vpc_id=default_get_switches.vswitches[0].vpc_id,
        zone_id=default_get_switches.vswitches[0].zone_id,
        vswitch_id=default_get_switches.vswitches[0].id)
    default_get_db_instances = alicloud.selectdb.get_db_instances_output(ids=[default_db_instance.id])
    pulumi.export("dbInstance", default_get_db_instances.ids[0])
    ```


    :param Sequence[_builtins.str] ids: A list of DBInstance IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource. Used for instance searching.
           - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
           - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:selectdb/getDbInstances:getDbInstances', __args__, opts=opts, typ=GetDbInstancesResult)
    return __ret__.apply(lambda __response__: GetDbInstancesResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        instances=pulumi.get(__response__, 'instances'),
        output_file=pulumi.get(__response__, 'output_file'),
        tags=pulumi.get(__response__, 'tags')))
