# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServerPlansResult',
    'AwaitableGetServerPlansResult',
    'get_server_plans',
    'get_server_plans_output',
]

@pulumi.output_type
class GetServerPlansResult:
    """
    A collection of values returned by getServerPlans.
    """
    def __init__(__self__, bandwidth=None, core=None, disk_size=None, flow=None, id=None, ids=None, memory=None, output_file=None, plans=None, platform=None):
        if bandwidth and not isinstance(bandwidth, int):
            raise TypeError("Expected argument 'bandwidth' to be a int")
        pulumi.set(__self__, "bandwidth", bandwidth)
        if core and not isinstance(core, int):
            raise TypeError("Expected argument 'core' to be a int")
        pulumi.set(__self__, "core", core)
        if disk_size and not isinstance(disk_size, int):
            raise TypeError("Expected argument 'disk_size' to be a int")
        pulumi.set(__self__, "disk_size", disk_size)
        if flow and not isinstance(flow, int):
            raise TypeError("Expected argument 'flow' to be a int")
        pulumi.set(__self__, "flow", flow)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if memory and not isinstance(memory, float):
            raise TypeError("Expected argument 'memory' to be a float")
        pulumi.set(__self__, "memory", memory)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if plans and not isinstance(plans, list):
            raise TypeError("Expected argument 'plans' to be a list")
        pulumi.set(__self__, "plans", plans)
        if platform and not isinstance(platform, str):
            raise TypeError("Expected argument 'platform' to be a str")
        pulumi.set(__self__, "platform", platform)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter
    def core(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "core")

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "disk_size")

    @_builtins.property
    @pulumi.getter
    def flow(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "flow")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[_builtins.float]:
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def plans(self) -> Sequence['outputs.GetServerPlansPlanResult']:
        return pulumi.get(self, "plans")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "platform")


class AwaitableGetServerPlansResult(GetServerPlansResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerPlansResult(
            bandwidth=self.bandwidth,
            core=self.core,
            disk_size=self.disk_size,
            flow=self.flow,
            id=self.id,
            ids=self.ids,
            memory=self.memory,
            output_file=self.output_file,
            plans=self.plans,
            platform=self.platform)


def get_server_plans(bandwidth: Optional[_builtins.int] = None,
                     core: Optional[_builtins.int] = None,
                     disk_size: Optional[_builtins.int] = None,
                     flow: Optional[_builtins.int] = None,
                     ids: Optional[Sequence[_builtins.str]] = None,
                     memory: Optional[_builtins.float] = None,
                     output_file: Optional[_builtins.str] = None,
                     platform: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerPlansResult:
    """
    This data source provides the Simple Application Server Plans of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.135.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.simpleapplicationserver.get_server_plans(memory=1,
        bandwidth=3,
        disk_size=40,
        flow=6,
        core=2)
    pulumi.export("simpleApplicationServerPlanId1", ids["plans"][0]["id"])
    ```


    :param _builtins.int bandwidth: The peak bandwidth. Unit: Mbit/s.
    :param _builtins.int core: The number of CPU cores.
    :param _builtins.int disk_size: The size of the enhanced SSD (ESSD). Unit: GB.
    :param _builtins.int flow: The monthly data transfer quota. Unit: GB.
    :param Sequence[_builtins.str] ids: A list of Instance Plan IDs.
    :param _builtins.float memory: The memory size. Unit: GB.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str platform: The platform of Plan supported. Valid values: ["Linux", "Windows"].
    """
    __args__ = dict()
    __args__['bandwidth'] = bandwidth
    __args__['core'] = core
    __args__['diskSize'] = disk_size
    __args__['flow'] = flow
    __args__['ids'] = ids
    __args__['memory'] = memory
    __args__['outputFile'] = output_file
    __args__['platform'] = platform
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:simpleapplicationserver/getServerPlans:getServerPlans', __args__, opts=opts, typ=GetServerPlansResult).value

    return AwaitableGetServerPlansResult(
        bandwidth=pulumi.get(__ret__, 'bandwidth'),
        core=pulumi.get(__ret__, 'core'),
        disk_size=pulumi.get(__ret__, 'disk_size'),
        flow=pulumi.get(__ret__, 'flow'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        memory=pulumi.get(__ret__, 'memory'),
        output_file=pulumi.get(__ret__, 'output_file'),
        plans=pulumi.get(__ret__, 'plans'),
        platform=pulumi.get(__ret__, 'platform'))
def get_server_plans_output(bandwidth: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                            core: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                            disk_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                            flow: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                            ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                            memory: Optional[pulumi.Input[Optional[_builtins.float]]] = None,
                            output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            platform: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServerPlansResult]:
    """
    This data source provides the Simple Application Server Plans of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.135.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.simpleapplicationserver.get_server_plans(memory=1,
        bandwidth=3,
        disk_size=40,
        flow=6,
        core=2)
    pulumi.export("simpleApplicationServerPlanId1", ids["plans"][0]["id"])
    ```


    :param _builtins.int bandwidth: The peak bandwidth. Unit: Mbit/s.
    :param _builtins.int core: The number of CPU cores.
    :param _builtins.int disk_size: The size of the enhanced SSD (ESSD). Unit: GB.
    :param _builtins.int flow: The monthly data transfer quota. Unit: GB.
    :param Sequence[_builtins.str] ids: A list of Instance Plan IDs.
    :param _builtins.float memory: The memory size. Unit: GB.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str platform: The platform of Plan supported. Valid values: ["Linux", "Windows"].
    """
    __args__ = dict()
    __args__['bandwidth'] = bandwidth
    __args__['core'] = core
    __args__['diskSize'] = disk_size
    __args__['flow'] = flow
    __args__['ids'] = ids
    __args__['memory'] = memory
    __args__['outputFile'] = output_file
    __args__['platform'] = platform
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:simpleapplicationserver/getServerPlans:getServerPlans', __args__, opts=opts, typ=GetServerPlansResult)
    return __ret__.apply(lambda __response__: GetServerPlansResult(
        bandwidth=pulumi.get(__response__, 'bandwidth'),
        core=pulumi.get(__response__, 'core'),
        disk_size=pulumi.get(__response__, 'disk_size'),
        flow=pulumi.get(__response__, 'flow'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        memory=pulumi.get(__response__, 'memory'),
        output_file=pulumi.get(__response__, 'output_file'),
        plans=pulumi.get(__response__, 'plans'),
        platform=pulumi.get(__response__, 'platform')))
