# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAttachmentsResult',
    'AwaitableGetAttachmentsResult',
    'get_attachments',
    'get_attachments_output',
]

@pulumi.output_type
class GetAttachmentsResult:
    """
    A collection of values returned by getAttachments.
    """
    def __init__(__self__, id=None, instance_ids=None, load_balancer_id=None, output_file=None, slb_attachments=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_ids and not isinstance(instance_ids, list):
            raise TypeError("Expected argument 'instance_ids' to be a list")
        pulumi.set(__self__, "instance_ids", instance_ids)
        if load_balancer_id and not isinstance(load_balancer_id, str):
            raise TypeError("Expected argument 'load_balancer_id' to be a str")
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if slb_attachments and not isinstance(slb_attachments, list):
            raise TypeError("Expected argument 'slb_attachments' to be a list")
        pulumi.set(__self__, "slb_attachments", slb_attachments)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "instance_ids")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> _builtins.str:
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="slbAttachments")
    def slb_attachments(self) -> Sequence['outputs.GetAttachmentsSlbAttachmentResult']:
        """
        A list of SLB attachments. Each element contains the following attributes:
        """
        return pulumi.get(self, "slb_attachments")


class AwaitableGetAttachmentsResult(GetAttachmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAttachmentsResult(
            id=self.id,
            instance_ids=self.instance_ids,
            load_balancer_id=self.load_balancer_id,
            output_file=self.output_file,
            slb_attachments=self.slb_attachments)


def get_attachments(instance_ids: Optional[Sequence[_builtins.str]] = None,
                    load_balancer_id: Optional[_builtins.str] = None,
                    output_file: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAttachmentsResult:
    """
    This data source provides the server load balancer attachments of the current Alibaba Cloud user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    sample_ds = alicloud.slb.get_attachments(load_balancer_id=sample_slb["id"])
    pulumi.export("firstSlbAttachmentInstanceId", sample_ds.slb_attachments[0].instance_id)
    ```


    :param Sequence[_builtins.str] instance_ids: List of attached ECS instance IDs.
    :param _builtins.str load_balancer_id: ID of the SLB with attachments.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['instanceIds'] = instance_ids
    __args__['loadBalancerId'] = load_balancer_id
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:slb/getAttachments:getAttachments', __args__, opts=opts, typ=GetAttachmentsResult).value

    return AwaitableGetAttachmentsResult(
        id=pulumi.get(__ret__, 'id'),
        instance_ids=pulumi.get(__ret__, 'instance_ids'),
        load_balancer_id=pulumi.get(__ret__, 'load_balancer_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        slb_attachments=pulumi.get(__ret__, 'slb_attachments'))
def get_attachments_output(instance_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                           load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                           output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAttachmentsResult]:
    """
    This data source provides the server load balancer attachments of the current Alibaba Cloud user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    sample_ds = alicloud.slb.get_attachments(load_balancer_id=sample_slb["id"])
    pulumi.export("firstSlbAttachmentInstanceId", sample_ds.slb_attachments[0].instance_id)
    ```


    :param Sequence[_builtins.str] instance_ids: List of attached ECS instance IDs.
    :param _builtins.str load_balancer_id: ID of the SLB with attachments.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['instanceIds'] = instance_ids
    __args__['loadBalancerId'] = load_balancer_id
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:slb/getAttachments:getAttachments', __args__, opts=opts, typ=GetAttachmentsResult)
    return __ret__.apply(lambda __response__: GetAttachmentsResult(
        id=pulumi.get(__response__, 'id'),
        instance_ids=pulumi.get(__response__, 'instance_ids'),
        load_balancer_id=pulumi.get(__response__, 'load_balancer_id'),
        output_file=pulumi.get(__response__, 'output_file'),
        slb_attachments=pulumi.get(__response__, 'slb_attachments')))
