# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'HoneypotPresetMeta',
    'HoneypotProbeHoneypotBindList',
    'HoneypotProbeHoneypotBindListBindPortList',
    'SasTrailServiceTrail',
    'GetAntiBruteForceRulesRuleResult',
    'GetAssetsAssetResult',
    'GetBackupPoliciesPolicyResult',
    'GetBaselineStrategiesStrategyResult',
    'GetHoneyPotsPotResult',
    'GetHoneypotImagesImageResult',
    'GetHoneypotNodesNodeResult',
    'GetHoneypotPresetsPresetResult',
    'GetHoneypotPresetsPresetMetaResult',
    'GetHoneypotProbesProbeResult',
    'GetHoneypotProbesProbeHoneypotBindListResult',
    'GetHoneypotProbesProbeHoneypotBindListBindPortListResult',
    'GetInstancesInstanceResult',
    'GetVulWhitelistsWhitelistResult',
    'GetWebLockConfigsConfigResult',
]

@pulumi.output_type
class HoneypotPresetMeta(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portraitOption":
            suggest = "portrait_option"
        elif key == "trojanGit":
            suggest = "trojan_git"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HoneypotPresetMeta. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HoneypotPresetMeta.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HoneypotPresetMeta.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 burp: _builtins.str,
                 portrait_option: Optional[_builtins.bool] = None,
                 trojan_git: Optional[_builtins.str] = None):
        """
        :param _builtins.str burp: Burp counter.
        :param _builtins.bool portrait_option: Social traceability.
        :param _builtins.str trojan_git: Git countered.
        """
        pulumi.set(__self__, "burp", burp)
        if portrait_option is not None:
            pulumi.set(__self__, "portrait_option", portrait_option)
        if trojan_git is not None:
            pulumi.set(__self__, "trojan_git", trojan_git)

    @_builtins.property
    @pulumi.getter
    def burp(self) -> _builtins.str:
        """
        Burp counter.
        """
        return pulumi.get(self, "burp")

    @_builtins.property
    @pulumi.getter(name="portraitOption")
    def portrait_option(self) -> Optional[_builtins.bool]:
        """
        Social traceability.
        """
        return pulumi.get(self, "portrait_option")

    @_builtins.property
    @pulumi.getter(name="trojanGit")
    def trojan_git(self) -> Optional[_builtins.str]:
        """
        Git countered.
        """
        return pulumi.get(self, "trojan_git")


@pulumi.output_type
class HoneypotProbeHoneypotBindList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bindPortLists":
            suggest = "bind_port_lists"
        elif key == "honeypotId":
            suggest = "honeypot_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HoneypotProbeHoneypotBindList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HoneypotProbeHoneypotBindList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HoneypotProbeHoneypotBindList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bind_port_lists: Optional[Sequence['outputs.HoneypotProbeHoneypotBindListBindPortList']] = None,
                 honeypot_id: Optional[_builtins.str] = None):
        """
        :param Sequence['HoneypotProbeHoneypotBindListBindPortListArgs'] bind_port_lists: List of listening ports.See the following `Block BindPortList`.
        :param _builtins.str honeypot_id: Honeypot ID.
        """
        if bind_port_lists is not None:
            pulumi.set(__self__, "bind_port_lists", bind_port_lists)
        if honeypot_id is not None:
            pulumi.set(__self__, "honeypot_id", honeypot_id)

    @_builtins.property
    @pulumi.getter(name="bindPortLists")
    def bind_port_lists(self) -> Optional[Sequence['outputs.HoneypotProbeHoneypotBindListBindPortList']]:
        """
        List of listening ports.See the following `Block BindPortList`.
        """
        return pulumi.get(self, "bind_port_lists")

    @_builtins.property
    @pulumi.getter(name="honeypotId")
    def honeypot_id(self) -> Optional[_builtins.str]:
        """
        Honeypot ID.
        """
        return pulumi.get(self, "honeypot_id")


@pulumi.output_type
class HoneypotProbeHoneypotBindListBindPortList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bindPort":
            suggest = "bind_port"
        elif key == "endPort":
            suggest = "end_port"
        elif key == "startPort":
            suggest = "start_port"
        elif key == "targetPort":
            suggest = "target_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HoneypotProbeHoneypotBindListBindPortList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HoneypotProbeHoneypotBindListBindPortList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HoneypotProbeHoneypotBindListBindPortList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bind_port: Optional[_builtins.bool] = None,
                 end_port: Optional[_builtins.int] = None,
                 fixed: Optional[_builtins.bool] = None,
                 start_port: Optional[_builtins.int] = None,
                 target_port: Optional[_builtins.int] = None):
        """
        :param _builtins.bool bind_port: Whether to bind the port.
        :param _builtins.int end_port: End port.
        :param _builtins.bool fixed: Whether the port is fixed.
        :param _builtins.int start_port: Start port.
        :param _builtins.int target_port: Destination port.
        """
        if bind_port is not None:
            pulumi.set(__self__, "bind_port", bind_port)
        if end_port is not None:
            pulumi.set(__self__, "end_port", end_port)
        if fixed is not None:
            pulumi.set(__self__, "fixed", fixed)
        if start_port is not None:
            pulumi.set(__self__, "start_port", start_port)
        if target_port is not None:
            pulumi.set(__self__, "target_port", target_port)

    @_builtins.property
    @pulumi.getter(name="bindPort")
    def bind_port(self) -> Optional[_builtins.bool]:
        """
        Whether to bind the port.
        """
        return pulumi.get(self, "bind_port")

    @_builtins.property
    @pulumi.getter(name="endPort")
    def end_port(self) -> Optional[_builtins.int]:
        """
        End port.
        """
        return pulumi.get(self, "end_port")

    @_builtins.property
    @pulumi.getter
    def fixed(self) -> Optional[_builtins.bool]:
        """
        Whether the port is fixed.
        """
        return pulumi.get(self, "fixed")

    @_builtins.property
    @pulumi.getter(name="startPort")
    def start_port(self) -> Optional[_builtins.int]:
        """
        Start port.
        """
        return pulumi.get(self, "start_port")

    @_builtins.property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> Optional[_builtins.int]:
        """
        Destination port.
        """
        return pulumi.get(self, "target_port")


@pulumi.output_type
class SasTrailServiceTrail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SasTrailServiceTrail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SasTrailServiceTrail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SasTrailServiceTrail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config: Optional[_builtins.str] = None,
                 update_time: Optional[_builtins.int] = None):
        """
        :param _builtins.str config: Service tracking on status. The value is:
               - **on:** Open
               - **off:** off.
        :param _builtins.int update_time: The timestamp of the last service update. Unit: milliseconds.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[_builtins.str]:
        """
        Service tracking on status. The value is:
        - **on:** Open
        - **off:** off.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[_builtins.int]:
        """
        The timestamp of the last service update. Unit: milliseconds.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GetAntiBruteForceRulesRuleResult(dict):
    def __init__(__self__, *,
                 anti_brute_force_rule_id: _builtins.str,
                 anti_brute_force_rule_name: _builtins.str,
                 default_rule: _builtins.bool,
                 fail_count: _builtins.int,
                 forbidden_time: _builtins.int,
                 id: _builtins.str,
                 span: _builtins.int,
                 uuid_lists: Sequence[_builtins.str]):
        """
        :param _builtins.str anti_brute_force_rule_id: The ID of the defense rule.
        :param _builtins.str anti_brute_force_rule_name: The name of the defense rule.
        :param _builtins.bool default_rule: Specifies whether to set the defense rule as the default rule.
        :param _builtins.int fail_count: The threshold for the number of failed user logins when the brute-force defense rule takes effect.
        :param _builtins.int forbidden_time: The period of time during which logons from an account are not allowed. Unit: minutes.
        :param _builtins.str id: The ID of the defense rule.
        :param _builtins.int span: The period of time during which logon failures from an account are measured. Unit: minutes. If Span is set to 10, the defense rule takes effect when the logon failures measured within 10 minutes reaches the specified threshold. The IP address of attackers cannot be used to log on to the server in the specified period of time.
        :param Sequence[_builtins.str] uuid_lists: An array consisting of the UUIDs of servers to which the defense rule is applied.
        """
        pulumi.set(__self__, "anti_brute_force_rule_id", anti_brute_force_rule_id)
        pulumi.set(__self__, "anti_brute_force_rule_name", anti_brute_force_rule_name)
        pulumi.set(__self__, "default_rule", default_rule)
        pulumi.set(__self__, "fail_count", fail_count)
        pulumi.set(__self__, "forbidden_time", forbidden_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "span", span)
        pulumi.set(__self__, "uuid_lists", uuid_lists)

    @_builtins.property
    @pulumi.getter(name="antiBruteForceRuleId")
    def anti_brute_force_rule_id(self) -> _builtins.str:
        """
        The ID of the defense rule.
        """
        return pulumi.get(self, "anti_brute_force_rule_id")

    @_builtins.property
    @pulumi.getter(name="antiBruteForceRuleName")
    def anti_brute_force_rule_name(self) -> _builtins.str:
        """
        The name of the defense rule.
        """
        return pulumi.get(self, "anti_brute_force_rule_name")

    @_builtins.property
    @pulumi.getter(name="defaultRule")
    def default_rule(self) -> _builtins.bool:
        """
        Specifies whether to set the defense rule as the default rule.
        """
        return pulumi.get(self, "default_rule")

    @_builtins.property
    @pulumi.getter(name="failCount")
    def fail_count(self) -> _builtins.int:
        """
        The threshold for the number of failed user logins when the brute-force defense rule takes effect.
        """
        return pulumi.get(self, "fail_count")

    @_builtins.property
    @pulumi.getter(name="forbiddenTime")
    def forbidden_time(self) -> _builtins.int:
        """
        The period of time during which logons from an account are not allowed. Unit: minutes.
        """
        return pulumi.get(self, "forbidden_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the defense rule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def span(self) -> _builtins.int:
        """
        The period of time during which logon failures from an account are measured. Unit: minutes. If Span is set to 10, the defense rule takes effect when the logon failures measured within 10 minutes reaches the specified threshold. The IP address of attackers cannot be used to log on to the server in the specified period of time.
        """
        return pulumi.get(self, "span")

    @_builtins.property
    @pulumi.getter(name="uuidLists")
    def uuid_lists(self) -> Sequence[_builtins.str]:
        """
        An array consisting of the UUIDs of servers to which the defense rule is applied.
        """
        return pulumi.get(self, "uuid_lists")


@pulumi.output_type
class GetAssetsAssetResult(dict):
    def __init__(__self__, *,
                 cluster_id: _builtins.str,
                 cluster_name: _builtins.str,
                 create_time: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 instance_name: _builtins.str,
                 internet_ip: _builtins.str,
                 intranet_ip: _builtins.str,
                 status: _builtins.str,
                 uuid: _builtins.str,
                 vpc_instance_id: _builtins.str):
        """
        :param _builtins.str cluster_id: The ID of the cluster.
        :param _builtins.str cluster_name: The name of the cluster.
        :param _builtins.str create_time: The creation time of the resource
        :param _builtins.str id: The UUID of the asset.
        :param _builtins.str instance_id: The ID of the asset.
        :param _builtins.str instance_name: The name of the asset.
        :param _builtins.str internet_ip: The public IP address of the asset.
        :param _builtins.str intranet_ip: The private IP address of the asset.
        :param _builtins.str status: The status of the asset. Valid values:
               - **Running**: running
               - **notRunning**: stopped
        :param _builtins.str uuid: The UUID of the asset. Same as `id`.
        :param _builtins.str vpc_instance_id: The ID of the VPC to which the asset belongs.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "internet_ip", internet_ip)
        pulumi.set(__self__, "intranet_ip", intranet_ip)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "uuid", uuid)
        pulumi.set(__self__, "vpc_instance_id", vpc_instance_id)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> _builtins.str:
        """
        The name of the cluster.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The UUID of the asset.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of the asset.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> _builtins.str:
        """
        The name of the asset.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> _builtins.str:
        """
        The public IP address of the asset.
        """
        return pulumi.get(self, "internet_ip")

    @_builtins.property
    @pulumi.getter(name="intranetIp")
    def intranet_ip(self) -> _builtins.str:
        """
        The private IP address of the asset.
        """
        return pulumi.get(self, "intranet_ip")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the asset. Valid values:
        - **Running**: running
        - **notRunning**: stopped
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        The UUID of the asset. Same as `id`.
        """
        return pulumi.get(self, "uuid")

    @_builtins.property
    @pulumi.getter(name="vpcInstanceId")
    def vpc_instance_id(self) -> _builtins.str:
        """
        The ID of the VPC to which the asset belongs.
        """
        return pulumi.get(self, "vpc_instance_id")


@pulumi.output_type
class GetBackupPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 backup_policy_id: _builtins.int,
                 backup_policy_name: _builtins.str,
                 id: _builtins.int,
                 policy: _builtins.str,
                 policy_region_id: _builtins.str,
                 policy_version: _builtins.str,
                 status: _builtins.str,
                 uuid_lists: Sequence[_builtins.str]):
        """
        :param _builtins.int backup_policy_id: The ID of the anti-ransomware policy.
        :param _builtins.str backup_policy_name: The name of the anti-ransomware policy.
        :param _builtins.int id: The ID of the anti-ransomware policy.
        :param _builtins.str policy: The configurations of the anti-ransomware policy.
        :param _builtins.str policy_region_id: The ID of the region that you specified for data backup when you installed the anti-ransomware agent for the server not deployed on Alibaba Cloud.
        :param _builtins.str policy_version: The version of the anti-ransomware policy.
        :param _builtins.str status: The status of the anti-ransomware policy. Valid Value: `enabled`, `disabled`, `closed`.
        :param Sequence[_builtins.str] uuid_lists: The UUIDs of the servers to which the anti-ransomware policy is applied.
        """
        pulumi.set(__self__, "backup_policy_id", backup_policy_id)
        pulumi.set(__self__, "backup_policy_name", backup_policy_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "policy_region_id", policy_region_id)
        pulumi.set(__self__, "policy_version", policy_version)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "uuid_lists", uuid_lists)

    @_builtins.property
    @pulumi.getter(name="backupPolicyId")
    def backup_policy_id(self) -> _builtins.int:
        """
        The ID of the anti-ransomware policy.
        """
        return pulumi.get(self, "backup_policy_id")

    @_builtins.property
    @pulumi.getter(name="backupPolicyName")
    def backup_policy_name(self) -> _builtins.str:
        """
        The name of the anti-ransomware policy.
        """
        return pulumi.get(self, "backup_policy_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The ID of the anti-ransomware policy.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        The configurations of the anti-ransomware policy.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="policyRegionId")
    def policy_region_id(self) -> _builtins.str:
        """
        The ID of the region that you specified for data backup when you installed the anti-ransomware agent for the server not deployed on Alibaba Cloud.
        """
        return pulumi.get(self, "policy_region_id")

    @_builtins.property
    @pulumi.getter(name="policyVersion")
    def policy_version(self) -> _builtins.str:
        """
        The version of the anti-ransomware policy.
        """
        return pulumi.get(self, "policy_version")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the anti-ransomware policy. Valid Value: `enabled`, `disabled`, `closed`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="uuidLists")
    def uuid_lists(self) -> Sequence[_builtins.str]:
        """
        The UUIDs of the servers to which the anti-ransomware policy is applied.
        """
        return pulumi.get(self, "uuid_lists")


@pulumi.output_type
class GetBaselineStrategiesStrategyResult(dict):
    def __init__(__self__, *,
                 baseline_strategy_id: _builtins.str,
                 baseline_strategy_name: _builtins.str,
                 custom_type: _builtins.str,
                 cycle_days: _builtins.int,
                 cycle_start_time: _builtins.int,
                 end_time: _builtins.str,
                 id: _builtins.str,
                 risk_sub_type_name: _builtins.str,
                 start_time: _builtins.str,
                 target_type: _builtins.str):
        """
        :param _builtins.str baseline_strategy_id: The ID of the baseline check policy.
        :param _builtins.str baseline_strategy_name: Policy name.
        :param _builtins.str custom_type: The type of policy. Value:-**common**: standard policy-**custom**: custom policy
        :param _builtins.int cycle_days: The detection period of the policy.
        :param _builtins.int cycle_start_time: The detection period of the policy. Value:
               * **0**: 0:00~06:00
               * **6**: 6:00~12:00
               * *12**: 12:00~18:00
               * **18**: 18:00~24:00
        :param _builtins.str end_time: The baseline check policy execution end time.
        :param _builtins.str id: The ID of the baseline check policy.
        :param _builtins.str start_time: The baseline check policy start time.
        """
        pulumi.set(__self__, "baseline_strategy_id", baseline_strategy_id)
        pulumi.set(__self__, "baseline_strategy_name", baseline_strategy_name)
        pulumi.set(__self__, "custom_type", custom_type)
        pulumi.set(__self__, "cycle_days", cycle_days)
        pulumi.set(__self__, "cycle_start_time", cycle_start_time)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "risk_sub_type_name", risk_sub_type_name)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "target_type", target_type)

    @_builtins.property
    @pulumi.getter(name="baselineStrategyId")
    def baseline_strategy_id(self) -> _builtins.str:
        """
        The ID of the baseline check policy.
        """
        return pulumi.get(self, "baseline_strategy_id")

    @_builtins.property
    @pulumi.getter(name="baselineStrategyName")
    def baseline_strategy_name(self) -> _builtins.str:
        """
        Policy name.
        """
        return pulumi.get(self, "baseline_strategy_name")

    @_builtins.property
    @pulumi.getter(name="customType")
    def custom_type(self) -> _builtins.str:
        """
        The type of policy. Value:-**common**: standard policy-**custom**: custom policy
        """
        return pulumi.get(self, "custom_type")

    @_builtins.property
    @pulumi.getter(name="cycleDays")
    def cycle_days(self) -> _builtins.int:
        """
        The detection period of the policy.
        """
        return pulumi.get(self, "cycle_days")

    @_builtins.property
    @pulumi.getter(name="cycleStartTime")
    def cycle_start_time(self) -> _builtins.int:
        """
        The detection period of the policy. Value:
        * **0**: 0:00~06:00
        * **6**: 6:00~12:00
        * *12**: 12:00~18:00
        * **18**: 18:00~24:00
        """
        return pulumi.get(self, "cycle_start_time")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.str:
        """
        The baseline check policy execution end time.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the baseline check policy.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="riskSubTypeName")
    def risk_sub_type_name(self) -> _builtins.str:
        return pulumi.get(self, "risk_sub_type_name")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        The baseline check policy start time.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> _builtins.str:
        return pulumi.get(self, "target_type")


@pulumi.output_type
class GetHoneyPotsPotResult(dict):
    def __init__(__self__, *,
                 honeypot_id: _builtins.str,
                 honeypot_image_id: _builtins.str,
                 honeypot_image_name: _builtins.str,
                 honeypot_name: _builtins.str,
                 id: _builtins.str,
                 node_id: _builtins.str,
                 preset_id: _builtins.str,
                 states: Sequence[_builtins.str],
                 status: _builtins.str):
        """
        :param _builtins.str honeypot_id: Honeypot ID.
        :param _builtins.str honeypot_image_id: The image ID of the honeypot.
        :param _builtins.str honeypot_image_name: Honeypot mirror name.
        :param _builtins.str honeypot_name: Honeypot custom name.
        :param _builtins.str id: Honeypot ID. The value is the same as `honeypot_id`.
        :param _builtins.str node_id: The ID of the honeypot management node.
        :param _builtins.str preset_id: The custom parameter ID of honeypot.
        :param Sequence[_builtins.str] states: Honeypot status.
        :param _builtins.str status: The status of the resource
        """
        pulumi.set(__self__, "honeypot_id", honeypot_id)
        pulumi.set(__self__, "honeypot_image_id", honeypot_image_id)
        pulumi.set(__self__, "honeypot_image_name", honeypot_image_name)
        pulumi.set(__self__, "honeypot_name", honeypot_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "preset_id", preset_id)
        pulumi.set(__self__, "states", states)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="honeypotId")
    def honeypot_id(self) -> _builtins.str:
        """
        Honeypot ID.
        """
        return pulumi.get(self, "honeypot_id")

    @_builtins.property
    @pulumi.getter(name="honeypotImageId")
    def honeypot_image_id(self) -> _builtins.str:
        """
        The image ID of the honeypot.
        """
        return pulumi.get(self, "honeypot_image_id")

    @_builtins.property
    @pulumi.getter(name="honeypotImageName")
    def honeypot_image_name(self) -> _builtins.str:
        """
        Honeypot mirror name.
        """
        return pulumi.get(self, "honeypot_image_name")

    @_builtins.property
    @pulumi.getter(name="honeypotName")
    def honeypot_name(self) -> _builtins.str:
        """
        Honeypot custom name.
        """
        return pulumi.get(self, "honeypot_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Honeypot ID. The value is the same as `honeypot_id`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> _builtins.str:
        """
        The ID of the honeypot management node.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter(name="presetId")
    def preset_id(self) -> _builtins.str:
        """
        The custom parameter ID of honeypot.
        """
        return pulumi.get(self, "preset_id")

    @_builtins.property
    @pulumi.getter
    def states(self) -> Sequence[_builtins.str]:
        """
        Honeypot status.
        """
        return pulumi.get(self, "states")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetHoneypotImagesImageResult(dict):
    def __init__(__self__, *,
                 honeypot_image_display_name: _builtins.str,
                 honeypot_image_id: _builtins.str,
                 honeypot_image_name: _builtins.str,
                 honeypot_image_type: _builtins.str,
                 honeypot_image_version: _builtins.str,
                 id: _builtins.str,
                 multiports: _builtins.str,
                 proto: _builtins.str,
                 service_port: _builtins.str,
                 template: _builtins.str):
        """
        :param _builtins.str honeypot_image_display_name: The name of the honeypot image display.
        :param _builtins.str honeypot_image_id: The image ID of the honeypot.
        :param _builtins.str honeypot_image_name: Honeypot mirror name.
        :param _builtins.str honeypot_image_type: Honeypot mirror type.
        :param _builtins.str honeypot_image_version: Honeypot Mirror version.
        :param _builtins.str id: The image ID of the honeypot.The value is the same as `honeypot_image_id`.
        :param _builtins.str multiports: Ports supported by honeypots. In JSON format. Contains the following fields:-**log_type**: log type-**proto**: Support Protocol-**description**: description-**ports**: supports Port collection-**port_str**: supports port strings-**type**: type
        :param _builtins.str proto: Honeypot-supported protocols.
        :param _builtins.str service_port: Honeypot service port.
        :param _builtins.str template: Honeypot configuration parameter template.
        """
        pulumi.set(__self__, "honeypot_image_display_name", honeypot_image_display_name)
        pulumi.set(__self__, "honeypot_image_id", honeypot_image_id)
        pulumi.set(__self__, "honeypot_image_name", honeypot_image_name)
        pulumi.set(__self__, "honeypot_image_type", honeypot_image_type)
        pulumi.set(__self__, "honeypot_image_version", honeypot_image_version)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "multiports", multiports)
        pulumi.set(__self__, "proto", proto)
        pulumi.set(__self__, "service_port", service_port)
        pulumi.set(__self__, "template", template)

    @_builtins.property
    @pulumi.getter(name="honeypotImageDisplayName")
    def honeypot_image_display_name(self) -> _builtins.str:
        """
        The name of the honeypot image display.
        """
        return pulumi.get(self, "honeypot_image_display_name")

    @_builtins.property
    @pulumi.getter(name="honeypotImageId")
    def honeypot_image_id(self) -> _builtins.str:
        """
        The image ID of the honeypot.
        """
        return pulumi.get(self, "honeypot_image_id")

    @_builtins.property
    @pulumi.getter(name="honeypotImageName")
    def honeypot_image_name(self) -> _builtins.str:
        """
        Honeypot mirror name.
        """
        return pulumi.get(self, "honeypot_image_name")

    @_builtins.property
    @pulumi.getter(name="honeypotImageType")
    def honeypot_image_type(self) -> _builtins.str:
        """
        Honeypot mirror type.
        """
        return pulumi.get(self, "honeypot_image_type")

    @_builtins.property
    @pulumi.getter(name="honeypotImageVersion")
    def honeypot_image_version(self) -> _builtins.str:
        """
        Honeypot Mirror version.
        """
        return pulumi.get(self, "honeypot_image_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The image ID of the honeypot.The value is the same as `honeypot_image_id`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def multiports(self) -> _builtins.str:
        """
        Ports supported by honeypots. In JSON format. Contains the following fields:-**log_type**: log type-**proto**: Support Protocol-**description**: description-**ports**: supports Port collection-**port_str**: supports port strings-**type**: type
        """
        return pulumi.get(self, "multiports")

    @_builtins.property
    @pulumi.getter
    def proto(self) -> _builtins.str:
        """
        Honeypot-supported protocols.
        """
        return pulumi.get(self, "proto")

    @_builtins.property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> _builtins.str:
        """
        Honeypot service port.
        """
        return pulumi.get(self, "service_port")

    @_builtins.property
    @pulumi.getter
    def template(self) -> _builtins.str:
        """
        Honeypot configuration parameter template.
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class GetHoneypotNodesNodeResult(dict):
    def __init__(__self__, *,
                 allow_honeypot_access_internet: _builtins.bool,
                 available_probe_num: _builtins.int,
                 create_time: _builtins.str,
                 id: _builtins.str,
                 node_id: _builtins.str,
                 node_name: _builtins.str,
                 security_group_probe_ip_lists: Sequence[_builtins.str],
                 status: _builtins.int):
        """
        :param _builtins.bool allow_honeypot_access_internet: Whether to allow honeypot access to the external network. Value:-**true**: Allow-**false**: Disabled
        :param _builtins.int available_probe_num: Number of probes available.
        :param _builtins.str id: The ID of the Honeypot management node.
        :param _builtins.str node_id: Honeypot management node id.
        :param _builtins.str node_name: The name of the management node.
        :param Sequence[_builtins.str] security_group_probe_ip_lists: Release the collection of network segments.
        """
        pulumi.set(__self__, "allow_honeypot_access_internet", allow_honeypot_access_internet)
        pulumi.set(__self__, "available_probe_num", available_probe_num)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "node_name", node_name)
        pulumi.set(__self__, "security_group_probe_ip_lists", security_group_probe_ip_lists)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="allowHoneypotAccessInternet")
    def allow_honeypot_access_internet(self) -> _builtins.bool:
        """
        Whether to allow honeypot access to the external network. Value:-**true**: Allow-**false**: Disabled
        """
        return pulumi.get(self, "allow_honeypot_access_internet")

    @_builtins.property
    @pulumi.getter(name="availableProbeNum")
    def available_probe_num(self) -> _builtins.int:
        """
        Number of probes available.
        """
        return pulumi.get(self, "available_probe_num")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Honeypot management node.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> _builtins.str:
        """
        Honeypot management node id.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> _builtins.str:
        """
        The name of the management node.
        """
        return pulumi.get(self, "node_name")

    @_builtins.property
    @pulumi.getter(name="securityGroupProbeIpLists")
    def security_group_probe_ip_lists(self) -> Sequence[_builtins.str]:
        """
        Release the collection of network segments.
        """
        return pulumi.get(self, "security_group_probe_ip_lists")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.int:
        return pulumi.get(self, "status")


@pulumi.output_type
class GetHoneypotPresetsPresetResult(dict):
    def __init__(__self__, *,
                 honeypot_image_name: _builtins.str,
                 honeypot_preset_id: _builtins.str,
                 id: _builtins.str,
                 metas: Sequence['outputs.GetHoneypotPresetsPresetMetaResult'],
                 node_id: _builtins.str,
                 preset_name: _builtins.str):
        """
        :param _builtins.str honeypot_image_name: Honeypot mirror name
        :param _builtins.str honeypot_preset_id: Unique ID of honeypot Template.
        :param _builtins.str id: The id of the Honeypot template.
        :param Sequence['GetHoneypotPresetsPresetMetaArgs'] metas: Honeypot template custom parameters.
        :param _builtins.str node_id: Unique id of management node
        :param _builtins.str preset_name: Honeypot template custom name
        """
        pulumi.set(__self__, "honeypot_image_name", honeypot_image_name)
        pulumi.set(__self__, "honeypot_preset_id", honeypot_preset_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "metas", metas)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "preset_name", preset_name)

    @_builtins.property
    @pulumi.getter(name="honeypotImageName")
    def honeypot_image_name(self) -> _builtins.str:
        """
        Honeypot mirror name
        """
        return pulumi.get(self, "honeypot_image_name")

    @_builtins.property
    @pulumi.getter(name="honeypotPresetId")
    def honeypot_preset_id(self) -> _builtins.str:
        """
        Unique ID of honeypot Template.
        """
        return pulumi.get(self, "honeypot_preset_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the Honeypot template.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def metas(self) -> Sequence['outputs.GetHoneypotPresetsPresetMetaResult']:
        """
        Honeypot template custom parameters.
        """
        return pulumi.get(self, "metas")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> _builtins.str:
        """
        Unique id of management node
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter(name="presetName")
    def preset_name(self) -> _builtins.str:
        """
        Honeypot template custom name
        """
        return pulumi.get(self, "preset_name")


@pulumi.output_type
class GetHoneypotPresetsPresetMetaResult(dict):
    def __init__(__self__, *,
                 burp: _builtins.str,
                 portrait_option: _builtins.bool,
                 trojan_git: _builtins.str):
        """
        :param _builtins.str burp: Burp counter.
        :param _builtins.bool portrait_option: Social traceability.
        :param _builtins.str trojan_git: Git countered.
        """
        pulumi.set(__self__, "burp", burp)
        pulumi.set(__self__, "portrait_option", portrait_option)
        pulumi.set(__self__, "trojan_git", trojan_git)

    @_builtins.property
    @pulumi.getter
    def burp(self) -> _builtins.str:
        """
        Burp counter.
        """
        return pulumi.get(self, "burp")

    @_builtins.property
    @pulumi.getter(name="portraitOption")
    def portrait_option(self) -> _builtins.bool:
        """
        Social traceability.
        """
        return pulumi.get(self, "portrait_option")

    @_builtins.property
    @pulumi.getter(name="trojanGit")
    def trojan_git(self) -> _builtins.str:
        """
        Git countered.
        """
        return pulumi.get(self, "trojan_git")


@pulumi.output_type
class GetHoneypotProbesProbeResult(dict):
    def __init__(__self__, *,
                 arp: _builtins.bool,
                 control_node_id: _builtins.str,
                 display_name: _builtins.str,
                 honeypot_bind_lists: Sequence['outputs.GetHoneypotProbesProbeHoneypotBindListResult'],
                 honeypot_probe_id: _builtins.str,
                 id: _builtins.str,
                 ping: _builtins.bool,
                 probe_type: _builtins.str,
                 service_ip_lists: Sequence[_builtins.str],
                 status: _builtins.str,
                 uuid: _builtins.str,
                 vpc_id: _builtins.str):
        """
        :param _builtins.bool arp: ARP spoofing detection.-**true**: Enable-**false**: Disabled. Available when `enable_details` is on.
        :param _builtins.str control_node_id: The ID of the management node.
        :param _builtins.str display_name: Probe name
        :param _builtins.str honeypot_probe_id: The first ID of the resource
        :param _builtins.str id: The ID of the honeypot probe. Its value is the same as `honeypot_probe_id`.
        :param _builtins.bool ping: Ping scan detection. Value:**true**: Enable **false**: Disabled. Available when `enable_details` is on.
        :param _builtins.str probe_type: Probe type
        :param Sequence[_builtins.str] service_ip_lists: Listen to the IP address list. Available when `enable_details` is on.
        :param _builtins.str status: The status of the resource.
        :param _builtins.str uuid: Machine uuid. Has a value when the type is `host_probe`.
        :param _builtins.str vpc_id: The ID of the VPC. Has a value when the type is `vpc_black_hole_probe`.
        """
        pulumi.set(__self__, "arp", arp)
        pulumi.set(__self__, "control_node_id", control_node_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "honeypot_bind_lists", honeypot_bind_lists)
        pulumi.set(__self__, "honeypot_probe_id", honeypot_probe_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ping", ping)
        pulumi.set(__self__, "probe_type", probe_type)
        pulumi.set(__self__, "service_ip_lists", service_ip_lists)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "uuid", uuid)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def arp(self) -> _builtins.bool:
        """
        ARP spoofing detection.-**true**: Enable-**false**: Disabled. Available when `enable_details` is on.
        """
        return pulumi.get(self, "arp")

    @_builtins.property
    @pulumi.getter(name="controlNodeId")
    def control_node_id(self) -> _builtins.str:
        """
        The ID of the management node.
        """
        return pulumi.get(self, "control_node_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Probe name
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="honeypotBindLists")
    def honeypot_bind_lists(self) -> Sequence['outputs.GetHoneypotProbesProbeHoneypotBindListResult']:
        return pulumi.get(self, "honeypot_bind_lists")

    @_builtins.property
    @pulumi.getter(name="honeypotProbeId")
    def honeypot_probe_id(self) -> _builtins.str:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "honeypot_probe_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the honeypot probe. Its value is the same as `honeypot_probe_id`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ping(self) -> _builtins.bool:
        """
        Ping scan detection. Value:**true**: Enable **false**: Disabled. Available when `enable_details` is on.
        """
        return pulumi.get(self, "ping")

    @_builtins.property
    @pulumi.getter(name="probeType")
    def probe_type(self) -> _builtins.str:
        """
        Probe type
        """
        return pulumi.get(self, "probe_type")

    @_builtins.property
    @pulumi.getter(name="serviceIpLists")
    def service_ip_lists(self) -> Sequence[_builtins.str]:
        """
        Listen to the IP address list. Available when `enable_details` is on.
        """
        return pulumi.get(self, "service_ip_lists")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        Machine uuid. Has a value when the type is `host_probe`.
        """
        return pulumi.get(self, "uuid")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC. Has a value when the type is `vpc_black_hole_probe`.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetHoneypotProbesProbeHoneypotBindListResult(dict):
    def __init__(__self__, *,
                 bind_port_lists: Sequence['outputs.GetHoneypotProbesProbeHoneypotBindListBindPortListResult'],
                 honeypot_id: _builtins.str):
        """
        :param Sequence['GetHoneypotProbesProbeHoneypotBindListBindPortListArgs'] bind_port_lists: List of listening ports. Available when `enable_details` is on.
        """
        pulumi.set(__self__, "bind_port_lists", bind_port_lists)
        pulumi.set(__self__, "honeypot_id", honeypot_id)

    @_builtins.property
    @pulumi.getter(name="bindPortLists")
    def bind_port_lists(self) -> Sequence['outputs.GetHoneypotProbesProbeHoneypotBindListBindPortListResult']:
        """
        List of listening ports. Available when `enable_details` is on.
        """
        return pulumi.get(self, "bind_port_lists")

    @_builtins.property
    @pulumi.getter(name="honeypotId")
    def honeypot_id(self) -> _builtins.str:
        return pulumi.get(self, "honeypot_id")


@pulumi.output_type
class GetHoneypotProbesProbeHoneypotBindListBindPortListResult(dict):
    def __init__(__self__, *,
                 bind_port: _builtins.bool,
                 end_port: _builtins.int,
                 fixed: _builtins.bool,
                 start_port: _builtins.int,
                 target_port: _builtins.int):
        """
        :param _builtins.bool bind_port: Whether to bind the port.
        :param _builtins.int end_port: End port.
        :param _builtins.bool fixed: Whether the port is fixed.
        :param _builtins.int start_port: Start port.
        :param _builtins.int target_port: Destination port.
        """
        pulumi.set(__self__, "bind_port", bind_port)
        pulumi.set(__self__, "end_port", end_port)
        pulumi.set(__self__, "fixed", fixed)
        pulumi.set(__self__, "start_port", start_port)
        pulumi.set(__self__, "target_port", target_port)

    @_builtins.property
    @pulumi.getter(name="bindPort")
    def bind_port(self) -> _builtins.bool:
        """
        Whether to bind the port.
        """
        return pulumi.get(self, "bind_port")

    @_builtins.property
    @pulumi.getter(name="endPort")
    def end_port(self) -> _builtins.int:
        """
        End port.
        """
        return pulumi.get(self, "end_port")

    @_builtins.property
    @pulumi.getter
    def fixed(self) -> _builtins.bool:
        """
        Whether the port is fixed.
        """
        return pulumi.get(self, "fixed")

    @_builtins.property
    @pulumi.getter(name="startPort")
    def start_port(self) -> _builtins.int:
        """
        Start port.
        """
        return pulumi.get(self, "start_port")

    @_builtins.property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> _builtins.int:
        """
        Destination port.
        """
        return pulumi.get(self, "target_port")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 payment_type: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str create_time: The creation time of the resource
        :param _builtins.str id: ID of the instance.
        :param _builtins.str instance_id: The first ID of the resource
        :param _builtins.str payment_type: The payment type of the resource.
        :param _builtins.str status: The status of the resource.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> _builtins.str:
        """
        The payment type of the resource.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetVulWhitelistsWhitelistResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 reason: _builtins.str,
                 target_info: _builtins.str,
                 vul_whitelist_id: _builtins.str,
                 whitelist: _builtins.str):
        """
        :param _builtins.str id: The ID of the Vul Whitelist.
        :param _builtins.str reason: Reason for adding whitelist.
        :param _builtins.str target_info: Set the effective range of the whitelist.
        :param _builtins.str vul_whitelist_id: The ID of the Vul Whitelist.
        :param _builtins.str whitelist: Information about the vulnerability to be added to the whitelist.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "target_info", target_info)
        pulumi.set(__self__, "vul_whitelist_id", vul_whitelist_id)
        pulumi.set(__self__, "whitelist", whitelist)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Vul Whitelist.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> _builtins.str:
        """
        Reason for adding whitelist.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter(name="targetInfo")
    def target_info(self) -> _builtins.str:
        """
        Set the effective range of the whitelist.
        """
        return pulumi.get(self, "target_info")

    @_builtins.property
    @pulumi.getter(name="vulWhitelistId")
    def vul_whitelist_id(self) -> _builtins.str:
        """
        The ID of the Vul Whitelist.
        """
        return pulumi.get(self, "vul_whitelist_id")

    @_builtins.property
    @pulumi.getter
    def whitelist(self) -> _builtins.str:
        """
        Information about the vulnerability to be added to the whitelist.
        """
        return pulumi.get(self, "whitelist")


@pulumi.output_type
class GetWebLockConfigsConfigResult(dict):
    def __init__(__self__, *,
                 defence_mode: _builtins.str,
                 dir: _builtins.str,
                 exclusive_dir: _builtins.str,
                 exclusive_file: _builtins.str,
                 exclusive_file_type: _builtins.str,
                 id: _builtins.str,
                 inclusive_file_type: _builtins.str,
                 local_backup_dir: _builtins.str,
                 mode: _builtins.str,
                 uuid: _builtins.str):
        """
        :param _builtins.str defence_mode: The prevention mode.
        :param _builtins.str dir: The directory that has web tamper proofing enabled.
        :param _builtins.str exclusive_dir: The directory that has web tamper proofing disabled.
        :param _builtins.str exclusive_file: The file that has web tamper proofing disabled. **Note:** If the value of `mode` is `blacklist`, this parameter is returned.
        :param _builtins.str exclusive_file_type: The type of the file that has web tamper proofing disabled. **Note:** If the value of `mode` is `blacklist`, this parameter is returned.
        :param _builtins.str id: The ID of the resource.
        :param _builtins.str inclusive_file_type: The type of the file that has web tamper proofing enabled. **Note:** If the value of `mode` is `whitelist`, this parameter is returned.
        :param _builtins.str local_backup_dir: The local path to the backup files of the protected directory.
        :param _builtins.str mode: The protection mode of web tamper proofing.
        :param _builtins.str uuid: The UUID of the server that has web tamper proofing enabled.
        """
        pulumi.set(__self__, "defence_mode", defence_mode)
        pulumi.set(__self__, "dir", dir)
        pulumi.set(__self__, "exclusive_dir", exclusive_dir)
        pulumi.set(__self__, "exclusive_file", exclusive_file)
        pulumi.set(__self__, "exclusive_file_type", exclusive_file_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "inclusive_file_type", inclusive_file_type)
        pulumi.set(__self__, "local_backup_dir", local_backup_dir)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="defenceMode")
    def defence_mode(self) -> _builtins.str:
        """
        The prevention mode.
        """
        return pulumi.get(self, "defence_mode")

    @_builtins.property
    @pulumi.getter
    def dir(self) -> _builtins.str:
        """
        The directory that has web tamper proofing enabled.
        """
        return pulumi.get(self, "dir")

    @_builtins.property
    @pulumi.getter(name="exclusiveDir")
    def exclusive_dir(self) -> _builtins.str:
        """
        The directory that has web tamper proofing disabled.
        """
        return pulumi.get(self, "exclusive_dir")

    @_builtins.property
    @pulumi.getter(name="exclusiveFile")
    def exclusive_file(self) -> _builtins.str:
        """
        The file that has web tamper proofing disabled. **Note:** If the value of `mode` is `blacklist`, this parameter is returned.
        """
        return pulumi.get(self, "exclusive_file")

    @_builtins.property
    @pulumi.getter(name="exclusiveFileType")
    def exclusive_file_type(self) -> _builtins.str:
        """
        The type of the file that has web tamper proofing disabled. **Note:** If the value of `mode` is `blacklist`, this parameter is returned.
        """
        return pulumi.get(self, "exclusive_file_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inclusiveFileType")
    def inclusive_file_type(self) -> _builtins.str:
        """
        The type of the file that has web tamper proofing enabled. **Note:** If the value of `mode` is `whitelist`, this parameter is returned.
        """
        return pulumi.get(self, "inclusive_file_type")

    @_builtins.property
    @pulumi.getter(name="localBackupDir")
    def local_backup_dir(self) -> _builtins.str:
        """
        The local path to the backup files of the protected directory.
        """
        return pulumi.get(self, "local_backup_dir")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        The protection mode of web tamper proofing.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        The UUID of the server that has web tamper proofing enabled.
        """
        return pulumi.get(self, "uuid")


