# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DomainSourceArgs',
    'DomainSourceArgsDict',
]

MYPY = False

if not MYPY:
    class DomainSourceArgsDict(TypedDict):
        source_content: pulumi.Input[_builtins.str]
        """
        The address of the origin server. You can specify an IP address or a domain name.
        """
        source_port: pulumi.Input[_builtins.str]
        """
        The port number. You can specify port 443 or 80. **Default value: 80**. If you specify port 443, Alibaba Cloud CDN communicates with the origin server over HTTPS. You can also customize a port.
        """
        source_type: pulumi.Input[_builtins.str]
        """
        The type of the origin server. Valid values:
        """
        source_priority: NotRequired[pulumi.Input[_builtins.str]]
        """
        The priority of the origin server if multiple origin servers are specified. Valid values: `20` and `30`. **Default value: 20**. A value of 20 indicates that the origin server is the primary origin server. A value of 30 indicates that the origin server is a secondary origin server.
        """
elif False:
    DomainSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainSourceArgs:
    def __init__(__self__, *,
                 source_content: pulumi.Input[_builtins.str],
                 source_port: pulumi.Input[_builtins.str],
                 source_type: pulumi.Input[_builtins.str],
                 source_priority: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] source_content: The address of the origin server. You can specify an IP address or a domain name.
        :param pulumi.Input[_builtins.str] source_port: The port number. You can specify port 443 or 80. **Default value: 80**. If you specify port 443, Alibaba Cloud CDN communicates with the origin server over HTTPS. You can also customize a port.
        :param pulumi.Input[_builtins.str] source_type: The type of the origin server. Valid values:
        :param pulumi.Input[_builtins.str] source_priority: The priority of the origin server if multiple origin servers are specified. Valid values: `20` and `30`. **Default value: 20**. A value of 20 indicates that the origin server is the primary origin server. A value of 30 indicates that the origin server is a secondary origin server.
        """
        pulumi.set(__self__, "source_content", source_content)
        pulumi.set(__self__, "source_port", source_port)
        pulumi.set(__self__, "source_type", source_type)
        if source_priority is not None:
            pulumi.set(__self__, "source_priority", source_priority)

    @_builtins.property
    @pulumi.getter(name="sourceContent")
    def source_content(self) -> pulumi.Input[_builtins.str]:
        """
        The address of the origin server. You can specify an IP address or a domain name.
        """
        return pulumi.get(self, "source_content")

    @source_content.setter
    def source_content(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_content", value)

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> pulumi.Input[_builtins.str]:
        """
        The port number. You can specify port 443 or 80. **Default value: 80**. If you specify port 443, Alibaba Cloud CDN communicates with the origin server over HTTPS. You can also customize a port.
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_port", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the origin server. Valid values:
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter(name="sourcePriority")
    def source_priority(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The priority of the origin server if multiple origin servers are specified. Valid values: `20` and `30`. **Default value: 20**. A value of 20 indicates that the origin server is the primary origin server. A value of 30 indicates that the origin server is a secondary origin server.
        """
        return pulumi.get(self, "source_priority")

    @source_priority.setter
    def source_priority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_priority", value)


