# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DhcpOptionsSetAssociateVpcArgs',
    'DhcpOptionsSetAssociateVpcArgsDict',
    'NatGatewayAccessModeArgs',
    'NatGatewayAccessModeArgsDict',
    'NetworkAclAttachmentResourceArgs',
    'NetworkAclAttachmentResourceArgsDict',
    'NetworkAclEgressAclEntryArgs',
    'NetworkAclEgressAclEntryArgsDict',
    'NetworkAclEntriesEgressArgs',
    'NetworkAclEntriesEgressArgsDict',
    'NetworkAclEntriesIngressArgs',
    'NetworkAclEntriesIngressArgsDict',
    'NetworkAclIngressAclEntryArgs',
    'NetworkAclIngressAclEntryArgsDict',
    'NetworkAclResourceArgs',
    'NetworkAclResourceArgsDict',
    'NetworkIpv6CidrBlockArgs',
    'NetworkIpv6CidrBlockArgsDict',
    'PrefixListEntryArgs',
    'PrefixListEntryArgsDict',
    'PrefixListPrefixListAssociationArgs',
    'PrefixListPrefixListAssociationArgsDict',
    'TrafficMirrorFilterEgressRuleArgs',
    'TrafficMirrorFilterEgressRuleArgsDict',
    'TrafficMirrorFilterIngressRuleArgs',
    'TrafficMirrorFilterIngressRuleArgsDict',
    'VPCRouteEntryNextHopArgs',
    'VPCRouteEntryNextHopArgsDict',
    'VPCRouteEntryNextHopNextHopRelatedInfoArgs',
    'VPCRouteEntryNextHopNextHopRelatedInfoArgsDict',
    'VPCRouteEntryRoutePublishTargetArgs',
    'VPCRouteEntryRoutePublishTargetArgsDict',
]

MYPY = False

if not MYPY:
    class DhcpOptionsSetAssociateVpcArgsDict(TypedDict):
        vpc_id: pulumi.Input[_builtins.str]
        """
        The ID of the VPC network that is associated with the DHCP options set.
        """
        associate_status: NotRequired[pulumi.Input[_builtins.str]]
        """
        The status of the VPC associated with the DHCP option set.
        """
elif False:
    DhcpOptionsSetAssociateVpcArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DhcpOptionsSetAssociateVpcArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[_builtins.str],
                 associate_status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC network that is associated with the DHCP options set.
        :param pulumi.Input[_builtins.str] associate_status: The status of the VPC associated with the DHCP option set.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if associate_status is not None:
            pulumi.set(__self__, "associate_status", associate_status)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VPC network that is associated with the DHCP options set.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="associateStatus")
    def associate_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the VPC associated with the DHCP option set.
        """
        return pulumi.get(self, "associate_status")

    @associate_status.setter
    def associate_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "associate_status", value)


if not MYPY:
    class NatGatewayAccessModeArgsDict(TypedDict):
        mode_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The mode of Access. Valid values:
        """
        tunnel_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of Tunnel. Valid values: `geneve`. **NOTE:** `tunnel_type` takes effect only if `mode_value` is set to `tunnel`.
        """
elif False:
    NatGatewayAccessModeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NatGatewayAccessModeArgs:
    def __init__(__self__, *,
                 mode_value: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] mode_value: The mode of Access. Valid values:
        :param pulumi.Input[_builtins.str] tunnel_type: The type of Tunnel. Valid values: `geneve`. **NOTE:** `tunnel_type` takes effect only if `mode_value` is set to `tunnel`.
        """
        if mode_value is not None:
            pulumi.set(__self__, "mode_value", mode_value)
        if tunnel_type is not None:
            pulumi.set(__self__, "tunnel_type", tunnel_type)

    @_builtins.property
    @pulumi.getter(name="modeValue")
    def mode_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode of Access. Valid values:
        """
        return pulumi.get(self, "mode_value")

    @mode_value.setter
    def mode_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode_value", value)

    @_builtins.property
    @pulumi.getter(name="tunnelType")
    def tunnel_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of Tunnel. Valid values: `geneve`. **NOTE:** `tunnel_type` takes effect only if `mode_value` is set to `tunnel`.
        """
        return pulumi.get(self, "tunnel_type")

    @tunnel_type.setter
    def tunnel_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tunnel_type", value)


if not MYPY:
    class NetworkAclAttachmentResourceArgsDict(TypedDict):
        resource_id: pulumi.Input[_builtins.str]
        """
        The resource id that the network acl will associate with.
        """
        resource_type: pulumi.Input[_builtins.str]
        """
        The resource id that the network acl will associate with. Only support `VSwitch` now.
        """
elif False:
    NetworkAclAttachmentResourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkAclAttachmentResourceArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[_builtins.str],
                 resource_type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] resource_id: The resource id that the network acl will associate with.
        :param pulumi.Input[_builtins.str] resource_type: The resource id that the network acl will associate with. Only support `VSwitch` now.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource id that the network acl will associate with.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[_builtins.str]:
        """
        The resource id that the network acl will associate with. Only support `VSwitch` now.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_type", value)


if not MYPY:
    class NetworkAclEgressAclEntryArgsDict(TypedDict):
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        The description of the outbound rule.  The description must be 1 to 256 characters in length and cannot start with http:// or https.
        """
        destination_cidr_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        The network of the destination address.
        """
        entry_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The route entry type. The value can be `custom`, indicating custom.
        """
        ip_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IP protocol version of the route entry. Valid values: "IPV4" and "IPV4'.
        """
        network_acl_entry_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the outbound rule entry.  The name must be 1 to 128 characters in length and cannot start with http:// or https.
        """
        policy: NotRequired[pulumi.Input[_builtins.str]]
        """
        Authorization policy. Value:
        - accept: Allow.
        - drop: Refused.
        """
        port: NotRequired[pulumi.Input[_builtins.str]]
        """
        The destination port range of the outbound rule.  When the Protocol type of the outbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted. When the Protocol type of the outbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
        """
        protocol: NotRequired[pulumi.Input[_builtins.str]]
        """
        The protocol type. Value:
        - icmp: Network Control Message Protocol.
        - gre: Generic Routing Encapsulation Protocol.
        - tcp: Transmission Control Protocol.
        - udp: User Datagram Protocol.
        - all: Supports all protocols.
        """
elif False:
    NetworkAclEgressAclEntryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkAclEgressAclEntryArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_cidr_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acl_entry_name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] description: The description of the outbound rule.  The description must be 1 to 256 characters in length and cannot start with http:// or https.
        :param pulumi.Input[_builtins.str] destination_cidr_ip: The network of the destination address.
        :param pulumi.Input[_builtins.str] entry_type: The route entry type. The value can be `custom`, indicating custom.
        :param pulumi.Input[_builtins.str] ip_version: The IP protocol version of the route entry. Valid values: "IPV4" and "IPV4'.
        :param pulumi.Input[_builtins.str] network_acl_entry_name: Name of the outbound rule entry.  The name must be 1 to 128 characters in length and cannot start with http:// or https.
        :param pulumi.Input[_builtins.str] policy: Authorization policy. Value:
               - accept: Allow.
               - drop: Refused.
        :param pulumi.Input[_builtins.str] port: The destination port range of the outbound rule.  When the Protocol type of the outbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted. When the Protocol type of the outbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
        :param pulumi.Input[_builtins.str] protocol: The protocol type. Value:
               - icmp: Network Control Message Protocol.
               - gre: Generic Routing Encapsulation Protocol.
               - tcp: Transmission Control Protocol.
               - udp: User Datagram Protocol.
               - all: Supports all protocols.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_cidr_ip is not None:
            pulumi.set(__self__, "destination_cidr_ip", destination_cidr_ip)
        if entry_type is not None:
            pulumi.set(__self__, "entry_type", entry_type)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if network_acl_entry_name is not None:
            pulumi.set(__self__, "network_acl_entry_name", network_acl_entry_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the outbound rule.  The description must be 1 to 256 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationCidrIp")
    def destination_cidr_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network of the destination address.
        """
        return pulumi.get(self, "destination_cidr_ip")

    @destination_cidr_ip.setter
    def destination_cidr_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_cidr_ip", value)

    @_builtins.property
    @pulumi.getter(name="entryType")
    def entry_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The route entry type. The value can be `custom`, indicating custom.
        """
        return pulumi.get(self, "entry_type")

    @entry_type.setter
    def entry_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entry_type", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP protocol version of the route entry. Valid values: "IPV4" and "IPV4'.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="networkAclEntryName")
    def network_acl_entry_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the outbound rule entry.  The name must be 1 to 128 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "network_acl_entry_name")

    @network_acl_entry_name.setter
    def network_acl_entry_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_acl_entry_name", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authorization policy. Value:
        - accept: Allow.
        - drop: Refused.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination port range of the outbound rule.  When the Protocol type of the outbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted. When the Protocol type of the outbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol type. Value:
        - icmp: Network Control Message Protocol.
        - gre: Generic Routing Encapsulation Protocol.
        - tcp: Transmission Control Protocol.
        - udp: User Datagram Protocol.
        - all: Supports all protocols.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)


if not MYPY:
    class NetworkAclEntriesEgressArgsDict(TypedDict):
        description: NotRequired[pulumi.Input[_builtins.str]]
        destination_cidr_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        The destination ip of the egress entry.
        """
        entry_type: NotRequired[pulumi.Input[_builtins.str]]
        name: NotRequired[pulumi.Input[_builtins.str]]
        policy: NotRequired[pulumi.Input[_builtins.str]]
        port: NotRequired[pulumi.Input[_builtins.str]]
        protocol: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    NetworkAclEntriesEgressArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkAclEntriesEgressArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_cidr_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] destination_cidr_ip: The destination ip of the egress entry.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_cidr_ip is not None:
            pulumi.set(__self__, "destination_cidr_ip", destination_cidr_ip)
        if entry_type is not None:
            pulumi.set(__self__, "entry_type", entry_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationCidrIp")
    def destination_cidr_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination ip of the egress entry.
        """
        return pulumi.get(self, "destination_cidr_ip")

    @destination_cidr_ip.setter
    def destination_cidr_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_cidr_ip", value)

    @_builtins.property
    @pulumi.getter(name="entryType")
    def entry_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "entry_type")

    @entry_type.setter
    def entry_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entry_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)


if not MYPY:
    class NetworkAclEntriesIngressArgsDict(TypedDict):
        description: NotRequired[pulumi.Input[_builtins.str]]
        entry_type: NotRequired[pulumi.Input[_builtins.str]]
        name: NotRequired[pulumi.Input[_builtins.str]]
        policy: NotRequired[pulumi.Input[_builtins.str]]
        port: NotRequired[pulumi.Input[_builtins.str]]
        protocol: NotRequired[pulumi.Input[_builtins.str]]
        source_cidr_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        The source ip of the ingress entry.
        """
elif False:
    NetworkAclEntriesIngressArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkAclEntriesIngressArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 source_cidr_ip: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] source_cidr_ip: The source ip of the ingress entry.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entry_type is not None:
            pulumi.set(__self__, "entry_type", entry_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_cidr_ip is not None:
            pulumi.set(__self__, "source_cidr_ip", source_cidr_ip)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="entryType")
    def entry_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "entry_type")

    @entry_type.setter
    def entry_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entry_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="sourceCidrIp")
    def source_cidr_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source ip of the ingress entry.
        """
        return pulumi.get(self, "source_cidr_ip")

    @source_cidr_ip.setter
    def source_cidr_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_cidr_ip", value)


if not MYPY:
    class NetworkAclIngressAclEntryArgsDict(TypedDict):
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        Description of the inbound rule.  The description must be 1 to 256 characters in length and cannot start with http:// or https.
        """
        entry_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The route entry type. The value can be `custom`, indicating custom.
        """
        ip_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IP protocol version of the route entry. Valid values: "IPV4" and "IPV6'.
        """
        network_acl_entry_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the inbound rule entry.  The name must be 1 to 128 characters in length and cannot start with http:// or https.
        """
        policy: NotRequired[pulumi.Input[_builtins.str]]
        """
        Authorization policy. Value:
        - accept: Allow.
        - drop: Refused.
        """
        port: NotRequired[pulumi.Input[_builtins.str]]
        """
        The source port range of the inbound rule.  When the Protocol type of the inbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted. When the Protocol type of the inbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
        """
        protocol: NotRequired[pulumi.Input[_builtins.str]]
        """
        The protocol type. Value:
        - icmp: Network Control Message Protocol.
        - gre: Generic Routing Encapsulation Protocol.
        - tcp: Transmission Control Protocol.
        - udp: User Datagram Protocol.
        - all: Supports all protocols.
        """
        source_cidr_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        Source address network segment.
        """
elif False:
    NetworkAclIngressAclEntryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkAclIngressAclEntryArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acl_entry_name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 source_cidr_ip: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] description: Description of the inbound rule.  The description must be 1 to 256 characters in length and cannot start with http:// or https.
        :param pulumi.Input[_builtins.str] entry_type: The route entry type. The value can be `custom`, indicating custom.
        :param pulumi.Input[_builtins.str] ip_version: The IP protocol version of the route entry. Valid values: "IPV4" and "IPV6'.
        :param pulumi.Input[_builtins.str] network_acl_entry_name: The name of the inbound rule entry.  The name must be 1 to 128 characters in length and cannot start with http:// or https.
        :param pulumi.Input[_builtins.str] policy: Authorization policy. Value:
               - accept: Allow.
               - drop: Refused.
        :param pulumi.Input[_builtins.str] port: The source port range of the inbound rule.  When the Protocol type of the inbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted. When the Protocol type of the inbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
        :param pulumi.Input[_builtins.str] protocol: The protocol type. Value:
               - icmp: Network Control Message Protocol.
               - gre: Generic Routing Encapsulation Protocol.
               - tcp: Transmission Control Protocol.
               - udp: User Datagram Protocol.
               - all: Supports all protocols.
        :param pulumi.Input[_builtins.str] source_cidr_ip: Source address network segment.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entry_type is not None:
            pulumi.set(__self__, "entry_type", entry_type)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if network_acl_entry_name is not None:
            pulumi.set(__self__, "network_acl_entry_name", network_acl_entry_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_cidr_ip is not None:
            pulumi.set(__self__, "source_cidr_ip", source_cidr_ip)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the inbound rule.  The description must be 1 to 256 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="entryType")
    def entry_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The route entry type. The value can be `custom`, indicating custom.
        """
        return pulumi.get(self, "entry_type")

    @entry_type.setter
    def entry_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entry_type", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP protocol version of the route entry. Valid values: "IPV4" and "IPV6'.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="networkAclEntryName")
    def network_acl_entry_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the inbound rule entry.  The name must be 1 to 128 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "network_acl_entry_name")

    @network_acl_entry_name.setter
    def network_acl_entry_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_acl_entry_name", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authorization policy. Value:
        - accept: Allow.
        - drop: Refused.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source port range of the inbound rule.  When the Protocol type of the inbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted. When the Protocol type of the inbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol type. Value:
        - icmp: Network Control Message Protocol.
        - gre: Generic Routing Encapsulation Protocol.
        - tcp: Transmission Control Protocol.
        - udp: User Datagram Protocol.
        - all: Supports all protocols.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="sourceCidrIp")
    def source_cidr_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source address network segment.
        """
        return pulumi.get(self, "source_cidr_ip")

    @source_cidr_ip.setter
    def source_cidr_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_cidr_ip", value)


if not MYPY:
    class NetworkAclResourceArgsDict(TypedDict):
        resource_id: pulumi.Input[_builtins.str]
        """
        The ID of the associated resource.
        """
        resource_type: pulumi.Input[_builtins.str]
        """
        The type of the associated resource.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        The state of the network ACL.
        """
elif False:
    NetworkAclResourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkAclResourceArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[_builtins.str],
                 resource_type: pulumi.Input[_builtins.str],
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] resource_id: The ID of the associated resource.
        :param pulumi.Input[_builtins.str] resource_type: The type of the associated resource.
        :param pulumi.Input[_builtins.str] status: The state of the network ACL.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the associated resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the associated resource.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the network ACL.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


if not MYPY:
    class NetworkIpv6CidrBlockArgsDict(TypedDict):
        ipv6_cidr_block: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IPv6 CIDR block of the default VPC.

        > **NOTE:**  When `EnableIpv6` is set to `true`, this parameter is required.
        """
        ipv6_isp: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IPv6 address segment type of the VPC. Value:
        - `BGP` (default): Alibaba Cloud BGP IPv6.
        - `ChinaMobile`: China Mobile (single line).
        - `ChinaUnicom`: China Unicom (single line).
        - `ChinaTelecom`: China Telecom (single line).

        > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to `ChinaTelecom` (China Telecom), `ChinaUnicom` (China Unicom), or `ChinaMobile` (China Mobile).
        """
elif False:
    NetworkIpv6CidrBlockArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkIpv6CidrBlockArgs:
    def __init__(__self__, *,
                 ipv6_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_isp: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] ipv6_cidr_block: The IPv6 CIDR block of the default VPC.
               
               > **NOTE:**  When `EnableIpv6` is set to `true`, this parameter is required.
        :param pulumi.Input[_builtins.str] ipv6_isp: The IPv6 address segment type of the VPC. Value:
               - `BGP` (default): Alibaba Cloud BGP IPv6.
               - `ChinaMobile`: China Mobile (single line).
               - `ChinaUnicom`: China Unicom (single line).
               - `ChinaTelecom`: China Telecom (single line).
               
               > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to `ChinaTelecom` (China Telecom), `ChinaUnicom` (China Unicom), or `ChinaMobile` (China Mobile).
        """
        if ipv6_cidr_block is not None:
            pulumi.set(__self__, "ipv6_cidr_block", ipv6_cidr_block)
        if ipv6_isp is not None:
            pulumi.set(__self__, "ipv6_isp", ipv6_isp)

    @_builtins.property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 CIDR block of the default VPC.

        > **NOTE:**  When `EnableIpv6` is set to `true`, this parameter is required.
        """
        return pulumi.get(self, "ipv6_cidr_block")

    @ipv6_cidr_block.setter
    def ipv6_cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Isp")
    def ipv6_isp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 address segment type of the VPC. Value:
        - `BGP` (default): Alibaba Cloud BGP IPv6.
        - `ChinaMobile`: China Mobile (single line).
        - `ChinaUnicom`: China Unicom (single line).
        - `ChinaTelecom`: China Telecom (single line).

        > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to `ChinaTelecom` (China Telecom), `ChinaUnicom` (China Unicom), or `ChinaMobile` (China Mobile).
        """
        return pulumi.get(self, "ipv6_isp")

    @ipv6_isp.setter
    def ipv6_isp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_isp", value)


if not MYPY:
    class PrefixListEntryArgsDict(TypedDict):
        cidr: NotRequired[pulumi.Input[_builtins.str]]
        """
        The CIDR address block of the prefix list.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        The description of the cidr entry. It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
        """
elif False:
    PrefixListEntryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PrefixListEntryArgs:
    def __init__(__self__, *,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] cidr: The CIDR address block of the prefix list.
        :param pulumi.Input[_builtins.str] description: The description of the cidr entry. It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR address block of the prefix list.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the cidr entry. It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class PrefixListPrefixListAssociationArgsDict(TypedDict):
        owner_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Alibaba Cloud account (primary account) to which the prefix list belongs.
        """
        prefix_list_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the query Prefix List.
        """
        reason: NotRequired[pulumi.Input[_builtins.str]]
        """
        Reason when the association fails.
        """
        region_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The region ID of the prefix list to be queried.
        """
        resource_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the associated resource.
        """
        resource_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The associated resource type. Value:-**vpcRouteTable**: The VPC route table.-**trRouteTable**: the routing table of the forwarding router.
        """
        resource_uid: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Alibaba Cloud account (primary account) to which the resource bound to the prefix list belongs.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        Resource attribute fields that represent the status of the resource.
        """
elif False:
    PrefixListPrefixListAssociationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PrefixListPrefixListAssociationArgs:
    def __init__(__self__, *,
                 owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 prefix_list_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reason: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] owner_id: The ID of the Alibaba Cloud account (primary account) to which the prefix list belongs.
        :param pulumi.Input[_builtins.str] prefix_list_id: The ID of the query Prefix List.
        :param pulumi.Input[_builtins.str] reason: Reason when the association fails.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the prefix list to be queried.
        :param pulumi.Input[_builtins.str] resource_id: The ID of the associated resource.
        :param pulumi.Input[_builtins.str] resource_type: The associated resource type. Value:-**vpcRouteTable**: The VPC route table.-**trRouteTable**: the routing table of the forwarding router.
        :param pulumi.Input[_builtins.str] resource_uid: The ID of the Alibaba Cloud account (primary account) to which the resource bound to the prefix list belongs.
        :param pulumi.Input[_builtins.str] status: Resource attribute fields that represent the status of the resource.
        """
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if prefix_list_id is not None:
            pulumi.set(__self__, "prefix_list_id", prefix_list_id)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if resource_uid is not None:
            pulumi.set(__self__, "resource_uid", resource_uid)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Alibaba Cloud account (primary account) to which the prefix list belongs.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_id", value)

    @_builtins.property
    @pulumi.getter(name="prefixListId")
    def prefix_list_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the query Prefix List.
        """
        return pulumi.get(self, "prefix_list_id")

    @prefix_list_id.setter
    def prefix_list_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "prefix_list_id", value)

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reason when the association fails.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reason", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the prefix list to be queried.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the associated resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The associated resource type. Value:-**vpcRouteTable**: The VPC route table.-**trRouteTable**: the routing table of the forwarding router.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceUid")
    def resource_uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Alibaba Cloud account (primary account) to which the resource bound to the prefix list belongs.
        """
        return pulumi.get(self, "resource_uid")

    @resource_uid.setter
    def resource_uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_uid", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource attribute fields that represent the status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


if not MYPY:
    class TrafficMirrorFilterEgressRuleArgsDict(TypedDict):
        action: pulumi.Input[_builtins.str]
        protocol: pulumi.Input[_builtins.str]
        destination_cidr_block: NotRequired[pulumi.Input[_builtins.str]]
        destination_port_range: NotRequired[pulumi.Input[_builtins.str]]
        priority: NotRequired[pulumi.Input[_builtins.int]]
        source_cidr_block: NotRequired[pulumi.Input[_builtins.str]]
        source_port_range: NotRequired[pulumi.Input[_builtins.str]]
        traffic_mirror_filter_rule_status: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    TrafficMirrorFilterEgressRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TrafficMirrorFilterEgressRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.str],
                 destination_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 source_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_mirror_filter_rule_status: Optional[pulumi.Input[_builtins.str]] = None):
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "protocol", protocol)
        if destination_cidr_block is not None:
            pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source_cidr_block is not None:
            pulumi.set(__self__, "source_cidr_block", source_cidr_block)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)
        if traffic_mirror_filter_rule_status is not None:
            pulumi.set(__self__, "traffic_mirror_filter_rule_status", traffic_mirror_filter_rule_status)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "destination_cidr_block")

    @destination_cidr_block.setter
    def destination_cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "destination_port_range")

    @destination_port_range.setter
    def destination_port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_port_range", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="sourceCidrBlock")
    def source_cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "source_cidr_block")

    @source_cidr_block.setter
    def source_cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "source_port_range")

    @source_port_range.setter
    def source_port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_port_range", value)

    @_builtins.property
    @pulumi.getter(name="trafficMirrorFilterRuleStatus")
    def traffic_mirror_filter_rule_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "traffic_mirror_filter_rule_status")

    @traffic_mirror_filter_rule_status.setter
    def traffic_mirror_filter_rule_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "traffic_mirror_filter_rule_status", value)


if not MYPY:
    class TrafficMirrorFilterIngressRuleArgsDict(TypedDict):
        action: pulumi.Input[_builtins.str]
        protocol: pulumi.Input[_builtins.str]
        destination_cidr_block: NotRequired[pulumi.Input[_builtins.str]]
        destination_port_range: NotRequired[pulumi.Input[_builtins.str]]
        priority: NotRequired[pulumi.Input[_builtins.int]]
        source_cidr_block: NotRequired[pulumi.Input[_builtins.str]]
        source_port_range: NotRequired[pulumi.Input[_builtins.str]]
        traffic_mirror_filter_rule_status: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    TrafficMirrorFilterIngressRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TrafficMirrorFilterIngressRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.str],
                 destination_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 source_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_mirror_filter_rule_status: Optional[pulumi.Input[_builtins.str]] = None):
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "protocol", protocol)
        if destination_cidr_block is not None:
            pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source_cidr_block is not None:
            pulumi.set(__self__, "source_cidr_block", source_cidr_block)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)
        if traffic_mirror_filter_rule_status is not None:
            pulumi.set(__self__, "traffic_mirror_filter_rule_status", traffic_mirror_filter_rule_status)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "destination_cidr_block")

    @destination_cidr_block.setter
    def destination_cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "destination_port_range")

    @destination_port_range.setter
    def destination_port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_port_range", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="sourceCidrBlock")
    def source_cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "source_cidr_block")

    @source_cidr_block.setter
    def source_cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "source_port_range")

    @source_port_range.setter
    def source_port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_port_range", value)

    @_builtins.property
    @pulumi.getter(name="trafficMirrorFilterRuleStatus")
    def traffic_mirror_filter_rule_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "traffic_mirror_filter_rule_status")

    @traffic_mirror_filter_rule_status.setter
    def traffic_mirror_filter_rule_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "traffic_mirror_filter_rule_status", value)


if not MYPY:
    class VPCRouteEntryNextHopArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[_builtins.int]]
        """
        Whether the route is available.
        """
        next_hop_region_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The region of the next instance.
        """
        next_hop_related_info: NotRequired[pulumi.Input['VPCRouteEntryNextHopNextHopRelatedInfoArgsDict']]
        """
        Next hop information.
        """
        nexthop_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of next hop
        """
        nexthop_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        type of next hop
        """
        weight: NotRequired[pulumi.Input[_builtins.int]]
        """
        The weight of the route entry.
        """
elif False:
    VPCRouteEntryNextHopArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VPCRouteEntryNextHopArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 next_hop_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop_related_info: Optional[pulumi.Input['VPCRouteEntryNextHopNextHopRelatedInfoArgs']] = None,
                 nexthop_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop_type: Optional[pulumi.Input[_builtins.str]] = None,
                 weight: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] enabled: Whether the route is available.
        :param pulumi.Input[_builtins.str] next_hop_region_id: The region of the next instance.
        :param pulumi.Input['VPCRouteEntryNextHopNextHopRelatedInfoArgs'] next_hop_related_info: Next hop information.
        :param pulumi.Input[_builtins.str] nexthop_id: ID of next hop
        :param pulumi.Input[_builtins.str] nexthop_type: type of next hop
        :param pulumi.Input[_builtins.int] weight: The weight of the route entry.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if next_hop_region_id is not None:
            pulumi.set(__self__, "next_hop_region_id", next_hop_region_id)
        if next_hop_related_info is not None:
            pulumi.set(__self__, "next_hop_related_info", next_hop_related_info)
        if nexthop_id is not None:
            pulumi.set(__self__, "nexthop_id", nexthop_id)
        if nexthop_type is not None:
            pulumi.set(__self__, "nexthop_type", nexthop_type)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Whether the route is available.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="nextHopRegionId")
    def next_hop_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the next instance.
        """
        return pulumi.get(self, "next_hop_region_id")

    @next_hop_region_id.setter
    def next_hop_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_hop_region_id", value)

    @_builtins.property
    @pulumi.getter(name="nextHopRelatedInfo")
    def next_hop_related_info(self) -> Optional[pulumi.Input['VPCRouteEntryNextHopNextHopRelatedInfoArgs']]:
        """
        Next hop information.
        """
        return pulumi.get(self, "next_hop_related_info")

    @next_hop_related_info.setter
    def next_hop_related_info(self, value: Optional[pulumi.Input['VPCRouteEntryNextHopNextHopRelatedInfoArgs']]):
        pulumi.set(self, "next_hop_related_info", value)

    @_builtins.property
    @pulumi.getter(name="nexthopId")
    def nexthop_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of next hop
        """
        return pulumi.get(self, "nexthop_id")

    @nexthop_id.setter
    def nexthop_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nexthop_id", value)

    @_builtins.property
    @pulumi.getter(name="nexthopType")
    def nexthop_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        type of next hop
        """
        return pulumi.get(self, "nexthop_type")

    @nexthop_type.setter
    def nexthop_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nexthop_type", value)

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The weight of the route entry.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "weight", value)


if not MYPY:
    class VPCRouteEntryNextHopNextHopRelatedInfoArgsDict(TypedDict):
        instance_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        InstanceId
        """
        instance_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        InstanceType
        """
        region_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The region of the instance associated with the next hop.
        """
elif False:
    VPCRouteEntryNextHopNextHopRelatedInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VPCRouteEntryNextHopNextHopRelatedInfoArgs:
    def __init__(__self__, *,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] instance_id: InstanceId
        :param pulumi.Input[_builtins.str] instance_type: InstanceType
        :param pulumi.Input[_builtins.str] region_id: The region of the instance associated with the next hop.
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        InstanceId
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        InstanceType
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the instance associated with the next hop.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)


if not MYPY:
    class VPCRouteEntryRoutePublishTargetArgsDict(TypedDict):
        target_type: pulumi.Input[_builtins.str]
        """
        Route publish target type
        """
        publish_status: NotRequired[pulumi.Input[_builtins.str]]
        """
        Route Publish Status
        """
        target_instance_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Route publish target instance id.
        """
elif False:
    VPCRouteEntryRoutePublishTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VPCRouteEntryRoutePublishTargetArgs:
    def __init__(__self__, *,
                 target_type: pulumi.Input[_builtins.str],
                 publish_status: Optional[pulumi.Input[_builtins.str]] = None,
                 target_instance_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] target_type: Route publish target type
        :param pulumi.Input[_builtins.str] publish_status: Route Publish Status
        :param pulumi.Input[_builtins.str] target_instance_id: Route publish target instance id.
        """
        pulumi.set(__self__, "target_type", target_type)
        if publish_status is not None:
            pulumi.set(__self__, "publish_status", publish_status)
        if target_instance_id is not None:
            pulumi.set(__self__, "target_instance_id", target_instance_id)

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Input[_builtins.str]:
        """
        Route publish target type
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_type", value)

    @_builtins.property
    @pulumi.getter(name="publishStatus")
    def publish_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Route Publish Status
        """
        return pulumi.get(self, "publish_status")

    @publish_status.setter
    def publish_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "publish_status", value)

    @_builtins.property
    @pulumi.getter(name="targetInstanceId")
    def target_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Route publish target instance id.
        """
        return pulumi.get(self, "target_instance_id")

    @target_instance_id.setter
    def target_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_instance_id", value)


