# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRouteTablesResult',
    'AwaitableGetRouteTablesResult',
    'get_route_tables',
    'get_route_tables_output',
]

@pulumi.output_type
class GetRouteTablesResult:
    """
    A collection of values returned by getRouteTables.
    """
    def __init__(__self__, id=None, ids=None, name_regex=None, names=None, output_file=None, page_number=None, page_size=None, resource_group_id=None, route_table_name=None, route_table_type=None, router_id=None, router_type=None, status=None, tables=None, tags=None, total_count=None, vpc_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if route_table_name and not isinstance(route_table_name, str):
            raise TypeError("Expected argument 'route_table_name' to be a str")
        pulumi.set(__self__, "route_table_name", route_table_name)
        if route_table_type and not isinstance(route_table_type, str):
            raise TypeError("Expected argument 'route_table_type' to be a str")
        pulumi.set(__self__, "route_table_type", route_table_type)
        if router_id and not isinstance(router_id, str):
            raise TypeError("Expected argument 'router_id' to be a str")
        pulumi.set(__self__, "router_id", router_id)
        if router_type and not isinstance(router_type, str):
            raise TypeError("Expected argument 'router_type' to be a str")
        pulumi.set(__self__, "router_type", router_type)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tables and not isinstance(tables, list):
            raise TypeError("Expected argument 'tables' to be a list")
        pulumi.set(__self__, "tables", tables)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        (Optional) A list of Route Tables IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Route Tables names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        """
        The Id of resource group which route tables belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="routeTableName")
    def route_table_name(self) -> Optional[_builtins.str]:
        """
        The route table name.
        """
        return pulumi.get(self, "route_table_name")

    @_builtins.property
    @pulumi.getter(name="routeTableType")
    def route_table_type(self) -> Optional[_builtins.str]:
        """
        The type of route table.
        """
        return pulumi.get(self, "route_table_type")

    @_builtins.property
    @pulumi.getter(name="routerId")
    def router_id(self) -> Optional[_builtins.str]:
        """
        Router Id of the route table.
        """
        return pulumi.get(self, "router_id")

    @_builtins.property
    @pulumi.getter(name="routerType")
    def router_type(self) -> Optional[_builtins.str]:
        """
        The route type.
        """
        return pulumi.get(self, "router_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of route table.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tables(self) -> Sequence['outputs.GetRouteTablesTableResult']:
        """
        A list of Route Tables. Each element contains the following attributes:
        """
        return pulumi.get(self, "tables")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> _builtins.int:
        return pulumi.get(self, "total_count")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetRouteTablesResult(GetRouteTablesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRouteTablesResult(
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            resource_group_id=self.resource_group_id,
            route_table_name=self.route_table_name,
            route_table_type=self.route_table_type,
            router_id=self.router_id,
            router_type=self.router_type,
            status=self.status,
            tables=self.tables,
            tags=self.tags,
            total_count=self.total_count,
            vpc_id=self.vpc_id)


def get_route_tables(ids: Optional[Sequence[_builtins.str]] = None,
                     name_regex: Optional[_builtins.str] = None,
                     output_file: Optional[_builtins.str] = None,
                     page_number: Optional[_builtins.int] = None,
                     page_size: Optional[_builtins.int] = None,
                     resource_group_id: Optional[_builtins.str] = None,
                     route_table_name: Optional[_builtins.str] = None,
                     route_table_type: Optional[_builtins.str] = None,
                     router_id: Optional[_builtins.str] = None,
                     router_type: Optional[_builtins.str] = None,
                     status: Optional[_builtins.str] = None,
                     tags: Optional[Mapping[str, _builtins.str]] = None,
                     vpc_id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRouteTablesResult:
    """
    This data source provides a list of Route Tables owned by an Alibaba Cloud account.

    > **NOTE:** Available since v1.36.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "route-tables-datasource-example-name"
    foo_network = alicloud.vpc.Network("foo",
        cidr_block="172.16.0.0/12",
        vpc_name=name)
    foo_route_table = alicloud.vpc.RouteTable("foo",
        vpc_id=foo_network.id,
        route_table_name=name,
        description=name)
    foo = alicloud.vpc.get_route_tables_output(ids=[foo_route_table.id],
        route_table_type="Custom")
    pulumi.export("routeTableIds", foo.ids)
    ```


    :param Sequence[_builtins.str] ids: A list of Route Tables IDs.
    :param _builtins.str name_regex: A regex string to filter route tables by name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The Id of resource group which route tables belongs.
    :param _builtins.str route_table_name: The route table name.
    :param _builtins.str route_table_type: The route table type.
    :param _builtins.str router_id: The router ID.
    :param _builtins.str router_type: The route type of route table. Valid values: `VRouter` and `VBR`.
    :param _builtins.str status: The status of resource. Valid values: `Available` and `Pending`.
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
    :param _builtins.str vpc_id: Vpc id of the route table.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['resourceGroupId'] = resource_group_id
    __args__['routeTableName'] = route_table_name
    __args__['routeTableType'] = route_table_type
    __args__['routerId'] = router_id
    __args__['routerType'] = router_type
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpc/getRouteTables:getRouteTables', __args__, opts=opts, typ=GetRouteTablesResult).value

    return AwaitableGetRouteTablesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        route_table_name=pulumi.get(__ret__, 'route_table_name'),
        route_table_type=pulumi.get(__ret__, 'route_table_type'),
        router_id=pulumi.get(__ret__, 'router_id'),
        router_type=pulumi.get(__ret__, 'router_type'),
        status=pulumi.get(__ret__, 'status'),
        tables=pulumi.get(__ret__, 'tables'),
        tags=pulumi.get(__ret__, 'tags'),
        total_count=pulumi.get(__ret__, 'total_count'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_route_tables_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                            name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                            page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                            resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            route_table_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            route_table_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            router_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            router_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                            vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRouteTablesResult]:
    """
    This data source provides a list of Route Tables owned by an Alibaba Cloud account.

    > **NOTE:** Available since v1.36.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "route-tables-datasource-example-name"
    foo_network = alicloud.vpc.Network("foo",
        cidr_block="172.16.0.0/12",
        vpc_name=name)
    foo_route_table = alicloud.vpc.RouteTable("foo",
        vpc_id=foo_network.id,
        route_table_name=name,
        description=name)
    foo = alicloud.vpc.get_route_tables_output(ids=[foo_route_table.id],
        route_table_type="Custom")
    pulumi.export("routeTableIds", foo.ids)
    ```


    :param Sequence[_builtins.str] ids: A list of Route Tables IDs.
    :param _builtins.str name_regex: A regex string to filter route tables by name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The Id of resource group which route tables belongs.
    :param _builtins.str route_table_name: The route table name.
    :param _builtins.str route_table_type: The route table type.
    :param _builtins.str router_id: The router ID.
    :param _builtins.str router_type: The route type of route table. Valid values: `VRouter` and `VBR`.
    :param _builtins.str status: The status of resource. Valid values: `Available` and `Pending`.
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
    :param _builtins.str vpc_id: Vpc id of the route table.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['resourceGroupId'] = resource_group_id
    __args__['routeTableName'] = route_table_name
    __args__['routeTableType'] = route_table_type
    __args__['routerId'] = router_id
    __args__['routerType'] = router_type
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:vpc/getRouteTables:getRouteTables', __args__, opts=opts, typ=GetRouteTablesResult)
    return __ret__.apply(lambda __response__: GetRouteTablesResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        route_table_name=pulumi.get(__response__, 'route_table_name'),
        route_table_type=pulumi.get(__response__, 'route_table_type'),
        router_id=pulumi.get(__response__, 'router_id'),
        router_type=pulumi.get(__response__, 'router_type'),
        status=pulumi.get(__response__, 'status'),
        tables=pulumi.get(__response__, 'tables'),
        tags=pulumi.get(__response__, 'tags'),
        total_count=pulumi.get(__response__, 'total_count'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
