# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RouterInterfaceArgs', 'RouterInterface']

@pulumi.input_type
class RouterInterfaceArgs:
    def __init__(__self__, *,
                 opposite_region: pulumi.Input[_builtins.str],
                 role: pulumi.Input[_builtins.str],
                 router_id: pulumi.Input[_builtins.str],
                 router_type: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_source_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_target_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RouterInterface resource.
        :param pulumi.Input[_builtins.str] opposite_region: The Region of peer side.
        :param pulumi.Input[_builtins.str] role: The role the router interface plays. Optional value: `InitiatingSide`, `AcceptingSide`.
        :param pulumi.Input[_builtins.str] router_id: The Router ID.
        :param pulumi.Input[_builtins.str] router_type: Router Type. Optional value: VRouter, VBR. Accepting side router interface type only be VRouter.
        :param pulumi.Input[_builtins.str] description: Description of the router interface. It can be 2-256 characters long or left blank. It cannot start with http:// and https://.
        :param pulumi.Input[_builtins.str] health_check_source_ip: Used as the Packet Source IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_target_ip` must be specified at the same time.
        :param pulumi.Input[_builtins.str] health_check_target_ip: Used as the Packet Target IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_source_ip` must be specified at the same time.
        :param pulumi.Input[_builtins.str] instance_charge_type: The billing method of the router interface. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid". Router Interface doesn't support "PrePaid" when region and opposite_region are the same.
        :param pulumi.Input[_builtins.str] name: Name of the router interface. Length must be 2-80 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
               If it is not specified, the default value is interface ID. The name cannot start with http:// and https://.
        :param pulumi.Input[_builtins.str] opposite_access_point_id: It has been deprecated from version 1.11.0.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] specification: Specification of router interfaces. It is valid when `role` is `InitiatingSide`. Accepting side's role is default to set as 'Negative'. For more about the specification, refer to [Router interface specification](https://www.alibabacloud.com/help/doc-detail/36037.htm).
        """
        pulumi.set(__self__, "opposite_region", opposite_region)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "router_id", router_id)
        pulumi.set(__self__, "router_type", router_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if health_check_source_ip is not None:
            pulumi.set(__self__, "health_check_source_ip", health_check_source_ip)
        if health_check_target_ip is not None:
            pulumi.set(__self__, "health_check_target_ip", health_check_target_ip)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if opposite_access_point_id is not None:
            warnings.warn("""Attribute 'opposite_access_point_id' has been deprecated from version 1.11.0.""", DeprecationWarning)
            pulumi.log.warn("""opposite_access_point_id is deprecated: Attribute 'opposite_access_point_id' has been deprecated from version 1.11.0.""")
        if opposite_access_point_id is not None:
            pulumi.set(__self__, "opposite_access_point_id", opposite_access_point_id)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if specification is not None:
            pulumi.set(__self__, "specification", specification)

    @_builtins.property
    @pulumi.getter(name="oppositeRegion")
    def opposite_region(self) -> pulumi.Input[_builtins.str]:
        """
        The Region of peer side.
        """
        return pulumi.get(self, "opposite_region")

    @opposite_region.setter
    def opposite_region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "opposite_region", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        The role the router interface plays. Optional value: `InitiatingSide`, `AcceptingSide`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="routerId")
    def router_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Router ID.
        """
        return pulumi.get(self, "router_id")

    @router_id.setter
    def router_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "router_id", value)

    @_builtins.property
    @pulumi.getter(name="routerType")
    def router_type(self) -> pulumi.Input[_builtins.str]:
        """
        Router Type. Optional value: VRouter, VBR. Accepting side router interface type only be VRouter.
        """
        return pulumi.get(self, "router_type")

    @router_type.setter
    def router_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "router_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the router interface. It can be 2-256 characters long or left blank. It cannot start with http:// and https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckSourceIp")
    def health_check_source_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used as the Packet Source IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_target_ip` must be specified at the same time.
        """
        return pulumi.get(self, "health_check_source_ip")

    @health_check_source_ip.setter
    def health_check_source_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_source_ip", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckTargetIp")
    def health_check_target_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used as the Packet Target IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_source_ip` must be specified at the same time.
        """
        return pulumi.get(self, "health_check_target_ip")

    @health_check_target_ip.setter
    def health_check_target_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_target_ip", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the router interface. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid". Router Interface doesn't support "PrePaid" when region and opposite_region are the same.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the router interface. Length must be 2-80 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
        If it is not specified, the default value is interface ID. The name cannot start with http:// and https://.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="oppositeAccessPointId")
    @_utilities.deprecated("""Attribute 'opposite_access_point_id' has been deprecated from version 1.11.0.""")
    def opposite_access_point_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from version 1.11.0.
        """
        return pulumi.get(self, "opposite_access_point_id")

    @opposite_access_point_id.setter
    def opposite_access_point_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_access_point_id", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter
    def specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specification of router interfaces. It is valid when `role` is `InitiatingSide`. Accepting side's role is default to set as 'Negative'. For more about the specification, refer to [Router interface specification](https://www.alibabacloud.com/help/doc-detail/36037.htm).
        """
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "specification", value)


@pulumi.input_type
class _RouterInterfaceState:
    def __init__(__self__, *,
                 access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_source_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_target_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_interface_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_region: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_router_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 router_type: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RouterInterface resources.
        :param pulumi.Input[_builtins.str] access_point_id: It has been deprecated from version 1.11.0.
        :param pulumi.Input[_builtins.str] description: Description of the router interface. It can be 2-256 characters long or left blank. It cannot start with http:// and https://.
        :param pulumi.Input[_builtins.str] health_check_source_ip: Used as the Packet Source IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_target_ip` must be specified at the same time.
        :param pulumi.Input[_builtins.str] health_check_target_ip: Used as the Packet Target IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_source_ip` must be specified at the same time.
        :param pulumi.Input[_builtins.str] instance_charge_type: The billing method of the router interface. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid". Router Interface doesn't support "PrePaid" when region and opposite_region are the same.
        :param pulumi.Input[_builtins.str] name: Name of the router interface. Length must be 2-80 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
               If it is not specified, the default value is interface ID. The name cannot start with http:// and https://.
        :param pulumi.Input[_builtins.str] opposite_access_point_id: It has been deprecated from version 1.11.0.
        :param pulumi.Input[_builtins.str] opposite_interface_id: It has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_router_id' instead.
        :param pulumi.Input[_builtins.str] opposite_interface_owner_id: It has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_interface_id' instead.
        :param pulumi.Input[_builtins.str] opposite_region: The Region of peer side.
        :param pulumi.Input[_builtins.str] opposite_router_id: It has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_router_id' instead.
        :param pulumi.Input[_builtins.str] opposite_router_type: It has been deprecated from version 1.11.0. resource alicloud_router_interface_connection's 'opposite_router_type' instead.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] role: The role the router interface plays. Optional value: `InitiatingSide`, `AcceptingSide`.
        :param pulumi.Input[_builtins.str] router_id: The Router ID.
        :param pulumi.Input[_builtins.str] router_type: Router Type. Optional value: VRouter, VBR. Accepting side router interface type only be VRouter.
        :param pulumi.Input[_builtins.str] specification: Specification of router interfaces. It is valid when `role` is `InitiatingSide`. Accepting side's role is default to set as 'Negative'. For more about the specification, refer to [Router interface specification](https://www.alibabacloud.com/help/doc-detail/36037.htm).
        """
        if access_point_id is not None:
            warnings.warn("""Attribute 'opposite_access_point_id' has been deprecated from version 1.11.0.""", DeprecationWarning)
            pulumi.log.warn("""access_point_id is deprecated: Attribute 'opposite_access_point_id' has been deprecated from version 1.11.0.""")
        if access_point_id is not None:
            pulumi.set(__self__, "access_point_id", access_point_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if health_check_source_ip is not None:
            pulumi.set(__self__, "health_check_source_ip", health_check_source_ip)
        if health_check_target_ip is not None:
            pulumi.set(__self__, "health_check_target_ip", health_check_target_ip)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if opposite_access_point_id is not None:
            warnings.warn("""Attribute 'opposite_access_point_id' has been deprecated from version 1.11.0.""", DeprecationWarning)
            pulumi.log.warn("""opposite_access_point_id is deprecated: Attribute 'opposite_access_point_id' has been deprecated from version 1.11.0.""")
        if opposite_access_point_id is not None:
            pulumi.set(__self__, "opposite_access_point_id", opposite_access_point_id)
        if opposite_interface_id is not None:
            warnings.warn("""Attribute 'opposite_interface_id' has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_interface_id' instead.""", DeprecationWarning)
            pulumi.log.warn("""opposite_interface_id is deprecated: Attribute 'opposite_interface_id' has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_interface_id' instead.""")
        if opposite_interface_id is not None:
            pulumi.set(__self__, "opposite_interface_id", opposite_interface_id)
        if opposite_interface_owner_id is not None:
            warnings.warn("""Attribute 'opposite_interface_owner_id' has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_interface_owner_id' instead.""", DeprecationWarning)
            pulumi.log.warn("""opposite_interface_owner_id is deprecated: Attribute 'opposite_interface_owner_id' has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_interface_owner_id' instead.""")
        if opposite_interface_owner_id is not None:
            pulumi.set(__self__, "opposite_interface_owner_id", opposite_interface_owner_id)
        if opposite_region is not None:
            pulumi.set(__self__, "opposite_region", opposite_region)
        if opposite_router_id is not None:
            warnings.warn("""Attribute 'opposite_router_id' has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_router_id' instead.""", DeprecationWarning)
            pulumi.log.warn("""opposite_router_id is deprecated: Attribute 'opposite_router_id' has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_router_id' instead.""")
        if opposite_router_id is not None:
            pulumi.set(__self__, "opposite_router_id", opposite_router_id)
        if opposite_router_type is not None:
            warnings.warn("""Attribute 'opposite_router_type' has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_router_type' instead.""", DeprecationWarning)
            pulumi.log.warn("""opposite_router_type is deprecated: Attribute 'opposite_router_type' has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_router_type' instead.""")
        if opposite_router_type is not None:
            pulumi.set(__self__, "opposite_router_type", opposite_router_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if router_id is not None:
            pulumi.set(__self__, "router_id", router_id)
        if router_type is not None:
            pulumi.set(__self__, "router_type", router_type)
        if specification is not None:
            pulumi.set(__self__, "specification", specification)

    @_builtins.property
    @pulumi.getter(name="accessPointId")
    @_utilities.deprecated("""Attribute 'opposite_access_point_id' has been deprecated from version 1.11.0.""")
    def access_point_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from version 1.11.0.
        """
        return pulumi.get(self, "access_point_id")

    @access_point_id.setter
    def access_point_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_point_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the router interface. It can be 2-256 characters long or left blank. It cannot start with http:// and https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckSourceIp")
    def health_check_source_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used as the Packet Source IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_target_ip` must be specified at the same time.
        """
        return pulumi.get(self, "health_check_source_ip")

    @health_check_source_ip.setter
    def health_check_source_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_source_ip", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckTargetIp")
    def health_check_target_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used as the Packet Target IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_source_ip` must be specified at the same time.
        """
        return pulumi.get(self, "health_check_target_ip")

    @health_check_target_ip.setter
    def health_check_target_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_target_ip", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the router interface. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid". Router Interface doesn't support "PrePaid" when region and opposite_region are the same.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the router interface. Length must be 2-80 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
        If it is not specified, the default value is interface ID. The name cannot start with http:// and https://.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="oppositeAccessPointId")
    @_utilities.deprecated("""Attribute 'opposite_access_point_id' has been deprecated from version 1.11.0.""")
    def opposite_access_point_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from version 1.11.0.
        """
        return pulumi.get(self, "opposite_access_point_id")

    @opposite_access_point_id.setter
    def opposite_access_point_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_access_point_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceId")
    @_utilities.deprecated("""Attribute 'opposite_interface_id' has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_interface_id' instead.""")
    def opposite_interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_router_id' instead.
        """
        return pulumi.get(self, "opposite_interface_id")

    @opposite_interface_id.setter
    def opposite_interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceOwnerId")
    @_utilities.deprecated("""Attribute 'opposite_interface_owner_id' has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_interface_owner_id' instead.""")
    def opposite_interface_owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_interface_id' instead.
        """
        return pulumi.get(self, "opposite_interface_owner_id")

    @opposite_interface_owner_id.setter
    def opposite_interface_owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_interface_owner_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeRegion")
    def opposite_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Region of peer side.
        """
        return pulumi.get(self, "opposite_region")

    @opposite_region.setter
    def opposite_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_region", value)

    @_builtins.property
    @pulumi.getter(name="oppositeRouterId")
    @_utilities.deprecated("""Attribute 'opposite_router_id' has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_router_id' instead.""")
    def opposite_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_router_id' instead.
        """
        return pulumi.get(self, "opposite_router_id")

    @opposite_router_id.setter
    def opposite_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_router_id", value)

    @_builtins.property
    @pulumi.getter(name="oppositeRouterType")
    @_utilities.deprecated("""Attribute 'opposite_router_type' has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_router_type' instead.""")
    def opposite_router_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from version 1.11.0. resource alicloud_router_interface_connection's 'opposite_router_type' instead.
        """
        return pulumi.get(self, "opposite_router_type")

    @opposite_router_type.setter
    def opposite_router_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opposite_router_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role the router interface plays. Optional value: `InitiatingSide`, `AcceptingSide`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="routerId")
    def router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Router ID.
        """
        return pulumi.get(self, "router_id")

    @router_id.setter
    def router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "router_id", value)

    @_builtins.property
    @pulumi.getter(name="routerType")
    def router_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Router Type. Optional value: VRouter, VBR. Accepting side router interface type only be VRouter.
        """
        return pulumi.get(self, "router_type")

    @router_type.setter
    def router_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "router_type", value)

    @_builtins.property
    @pulumi.getter
    def specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specification of router interfaces. It is valid when `role` is `InitiatingSide`. Accepting side's role is default to set as 'Negative'. For more about the specification, refer to [Router interface specification](https://www.alibabacloud.com/help/doc-detail/36037.htm).
        """
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "specification", value)


@pulumi.type_token("alicloud:vpc/routerInterface:RouterInterface")
class RouterInterface(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_source_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_target_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_region: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 router_type: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a VPC router interface resource aim to build a connection between two VPCs.

        > **DEPRECATED:**  This resource  has been deprecated from version `1.199.0`. Please use new resource alicloud_express_connect_router_interface.

        > **NOTE:** Only one pair of connected router interfaces can exist between two routers. Up to 5 router interfaces can be created for each router and each account.

        > **NOTE:** The router interface is not connected when it is created. It can be connected by means of resource alicloud_router_interface_connection.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        foo = alicloud.vpc.Network("foo",
            vpc_name="tf_test_foo12345",
            cidr_block="172.16.0.0/12")
        interface = alicloud.vpc.RouterInterface("interface",
            opposite_region="cn-beijing",
            router_type="VRouter",
            router_id=foo.router_id,
            role="InitiatingSide",
            specification="Large.2",
            name="test1",
            description="test1")
        ```

        ## Import

        The router interface can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/routerInterface:RouterInterface interface ri-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the router interface. It can be 2-256 characters long or left blank. It cannot start with http:// and https://.
        :param pulumi.Input[_builtins.str] health_check_source_ip: Used as the Packet Source IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_target_ip` must be specified at the same time.
        :param pulumi.Input[_builtins.str] health_check_target_ip: Used as the Packet Target IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_source_ip` must be specified at the same time.
        :param pulumi.Input[_builtins.str] instance_charge_type: The billing method of the router interface. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid". Router Interface doesn't support "PrePaid" when region and opposite_region are the same.
        :param pulumi.Input[_builtins.str] name: Name of the router interface. Length must be 2-80 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
               If it is not specified, the default value is interface ID. The name cannot start with http:// and https://.
        :param pulumi.Input[_builtins.str] opposite_access_point_id: It has been deprecated from version 1.11.0.
        :param pulumi.Input[_builtins.str] opposite_region: The Region of peer side.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] role: The role the router interface plays. Optional value: `InitiatingSide`, `AcceptingSide`.
        :param pulumi.Input[_builtins.str] router_id: The Router ID.
        :param pulumi.Input[_builtins.str] router_type: Router Type. Optional value: VRouter, VBR. Accepting side router interface type only be VRouter.
        :param pulumi.Input[_builtins.str] specification: Specification of router interfaces. It is valid when `role` is `InitiatingSide`. Accepting side's role is default to set as 'Negative'. For more about the specification, refer to [Router interface specification](https://www.alibabacloud.com/help/doc-detail/36037.htm).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouterInterfaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a VPC router interface resource aim to build a connection between two VPCs.

        > **DEPRECATED:**  This resource  has been deprecated from version `1.199.0`. Please use new resource alicloud_express_connect_router_interface.

        > **NOTE:** Only one pair of connected router interfaces can exist between two routers. Up to 5 router interfaces can be created for each router and each account.

        > **NOTE:** The router interface is not connected when it is created. It can be connected by means of resource alicloud_router_interface_connection.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        foo = alicloud.vpc.Network("foo",
            vpc_name="tf_test_foo12345",
            cidr_block="172.16.0.0/12")
        interface = alicloud.vpc.RouterInterface("interface",
            opposite_region="cn-beijing",
            router_type="VRouter",
            router_id=foo.router_id,
            role="InitiatingSide",
            specification="Large.2",
            name="test1",
            description="test1")
        ```

        ## Import

        The router interface can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/routerInterface:RouterInterface interface ri-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param RouterInterfaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouterInterfaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_source_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_target_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opposite_region: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 router_type: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouterInterfaceArgs.__new__(RouterInterfaceArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["health_check_source_ip"] = health_check_source_ip
            __props__.__dict__["health_check_target_ip"] = health_check_target_ip
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            __props__.__dict__["name"] = name
            __props__.__dict__["opposite_access_point_id"] = opposite_access_point_id
            if opposite_region is None and not opts.urn:
                raise TypeError("Missing required property 'opposite_region'")
            __props__.__dict__["opposite_region"] = opposite_region
            __props__.__dict__["period"] = period
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            if router_id is None and not opts.urn:
                raise TypeError("Missing required property 'router_id'")
            __props__.__dict__["router_id"] = router_id
            if router_type is None and not opts.urn:
                raise TypeError("Missing required property 'router_type'")
            __props__.__dict__["router_type"] = router_type
            __props__.__dict__["specification"] = specification
            __props__.__dict__["access_point_id"] = None
            __props__.__dict__["opposite_interface_id"] = None
            __props__.__dict__["opposite_interface_owner_id"] = None
            __props__.__dict__["opposite_router_id"] = None
            __props__.__dict__["opposite_router_type"] = None
        super(RouterInterface, __self__).__init__(
            'alicloud:vpc/routerInterface:RouterInterface',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_source_ip: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_target_ip: Optional[pulumi.Input[_builtins.str]] = None,
            instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            opposite_access_point_id: Optional[pulumi.Input[_builtins.str]] = None,
            opposite_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
            opposite_interface_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
            opposite_region: Optional[pulumi.Input[_builtins.str]] = None,
            opposite_router_id: Optional[pulumi.Input[_builtins.str]] = None,
            opposite_router_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            router_id: Optional[pulumi.Input[_builtins.str]] = None,
            router_type: Optional[pulumi.Input[_builtins.str]] = None,
            specification: Optional[pulumi.Input[_builtins.str]] = None) -> 'RouterInterface':
        """
        Get an existing RouterInterface resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_point_id: It has been deprecated from version 1.11.0.
        :param pulumi.Input[_builtins.str] description: Description of the router interface. It can be 2-256 characters long or left blank. It cannot start with http:// and https://.
        :param pulumi.Input[_builtins.str] health_check_source_ip: Used as the Packet Source IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_target_ip` must be specified at the same time.
        :param pulumi.Input[_builtins.str] health_check_target_ip: Used as the Packet Target IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_source_ip` must be specified at the same time.
        :param pulumi.Input[_builtins.str] instance_charge_type: The billing method of the router interface. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid". Router Interface doesn't support "PrePaid" when region and opposite_region are the same.
        :param pulumi.Input[_builtins.str] name: Name of the router interface. Length must be 2-80 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
               If it is not specified, the default value is interface ID. The name cannot start with http:// and https://.
        :param pulumi.Input[_builtins.str] opposite_access_point_id: It has been deprecated from version 1.11.0.
        :param pulumi.Input[_builtins.str] opposite_interface_id: It has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_router_id' instead.
        :param pulumi.Input[_builtins.str] opposite_interface_owner_id: It has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_interface_id' instead.
        :param pulumi.Input[_builtins.str] opposite_region: The Region of peer side.
        :param pulumi.Input[_builtins.str] opposite_router_id: It has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_router_id' instead.
        :param pulumi.Input[_builtins.str] opposite_router_type: It has been deprecated from version 1.11.0. resource alicloud_router_interface_connection's 'opposite_router_type' instead.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] role: The role the router interface plays. Optional value: `InitiatingSide`, `AcceptingSide`.
        :param pulumi.Input[_builtins.str] router_id: The Router ID.
        :param pulumi.Input[_builtins.str] router_type: Router Type. Optional value: VRouter, VBR. Accepting side router interface type only be VRouter.
        :param pulumi.Input[_builtins.str] specification: Specification of router interfaces. It is valid when `role` is `InitiatingSide`. Accepting side's role is default to set as 'Negative'. For more about the specification, refer to [Router interface specification](https://www.alibabacloud.com/help/doc-detail/36037.htm).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouterInterfaceState.__new__(_RouterInterfaceState)

        __props__.__dict__["access_point_id"] = access_point_id
        __props__.__dict__["description"] = description
        __props__.__dict__["health_check_source_ip"] = health_check_source_ip
        __props__.__dict__["health_check_target_ip"] = health_check_target_ip
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["name"] = name
        __props__.__dict__["opposite_access_point_id"] = opposite_access_point_id
        __props__.__dict__["opposite_interface_id"] = opposite_interface_id
        __props__.__dict__["opposite_interface_owner_id"] = opposite_interface_owner_id
        __props__.__dict__["opposite_region"] = opposite_region
        __props__.__dict__["opposite_router_id"] = opposite_router_id
        __props__.__dict__["opposite_router_type"] = opposite_router_type
        __props__.__dict__["period"] = period
        __props__.__dict__["role"] = role
        __props__.__dict__["router_id"] = router_id
        __props__.__dict__["router_type"] = router_type
        __props__.__dict__["specification"] = specification
        return RouterInterface(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessPointId")
    @_utilities.deprecated("""Attribute 'opposite_access_point_id' has been deprecated from version 1.11.0.""")
    def access_point_id(self) -> pulumi.Output[_builtins.str]:
        """
        It has been deprecated from version 1.11.0.
        """
        return pulumi.get(self, "access_point_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the router interface. It can be 2-256 characters long or left blank. It cannot start with http:// and https://.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="healthCheckSourceIp")
    def health_check_source_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Used as the Packet Source IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_target_ip` must be specified at the same time.
        """
        return pulumi.get(self, "health_check_source_ip")

    @_builtins.property
    @pulumi.getter(name="healthCheckTargetIp")
    def health_check_target_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Used as the Packet Target IP of health check for disaster recovery or ECMP. It is only valid when `router_type` is `VBR`. The IP must be an unused IP in the local VPC. It and `health_check_source_ip` must be specified at the same time.
        """
        return pulumi.get(self, "health_check_target_ip")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The billing method of the router interface. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid". Router Interface doesn't support "PrePaid" when region and opposite_region are the same.
        """
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the router interface. Length must be 2-80 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
        If it is not specified, the default value is interface ID. The name cannot start with http:// and https://.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="oppositeAccessPointId")
    @_utilities.deprecated("""Attribute 'opposite_access_point_id' has been deprecated from version 1.11.0.""")
    def opposite_access_point_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        It has been deprecated from version 1.11.0.
        """
        return pulumi.get(self, "opposite_access_point_id")

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceId")
    @_utilities.deprecated("""Attribute 'opposite_interface_id' has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_interface_id' instead.""")
    def opposite_interface_id(self) -> pulumi.Output[_builtins.str]:
        """
        It has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_router_id' instead.
        """
        return pulumi.get(self, "opposite_interface_id")

    @_builtins.property
    @pulumi.getter(name="oppositeInterfaceOwnerId")
    @_utilities.deprecated("""Attribute 'opposite_interface_owner_id' has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_interface_owner_id' instead.""")
    def opposite_interface_owner_id(self) -> pulumi.Output[_builtins.str]:
        """
        It has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_interface_id' instead.
        """
        return pulumi.get(self, "opposite_interface_owner_id")

    @_builtins.property
    @pulumi.getter(name="oppositeRegion")
    def opposite_region(self) -> pulumi.Output[_builtins.str]:
        """
        The Region of peer side.
        """
        return pulumi.get(self, "opposite_region")

    @_builtins.property
    @pulumi.getter(name="oppositeRouterId")
    @_utilities.deprecated("""Attribute 'opposite_router_id' has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_router_id' instead.""")
    def opposite_router_id(self) -> pulumi.Output[_builtins.str]:
        """
        It has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_router_id' instead.
        """
        return pulumi.get(self, "opposite_router_id")

    @_builtins.property
    @pulumi.getter(name="oppositeRouterType")
    @_utilities.deprecated("""Attribute 'opposite_router_type' has been deprecated from version 1.11.0. Use resource alicloud_router_interface_connection's 'opposite_router_type' instead.""")
    def opposite_router_type(self) -> pulumi.Output[_builtins.str]:
        """
        It has been deprecated from version 1.11.0. resource alicloud_router_interface_connection's 'opposite_router_type' instead.
        """
        return pulumi.get(self, "opposite_router_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[_builtins.str]:
        """
        The role the router interface plays. Optional value: `InitiatingSide`, `AcceptingSide`.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="routerId")
    def router_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Router ID.
        """
        return pulumi.get(self, "router_id")

    @_builtins.property
    @pulumi.getter(name="routerType")
    def router_type(self) -> pulumi.Output[_builtins.str]:
        """
        Router Type. Optional value: VRouter, VBR. Accepting side router interface type only be VRouter.
        """
        return pulumi.get(self, "router_type")

    @_builtins.property
    @pulumi.getter
    def specification(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specification of router interfaces. It is valid when `role` is `InitiatingSide`. Accepting side's role is default to set as 'Negative'. For more about the specification, refer to [Router interface specification](https://www.alibabacloud.com/help/doc-detail/36037.htm).
        """
        return pulumi.get(self, "specification")

