# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ConnectionBgpConfigArgs',
    'ConnectionBgpConfigArgsDict',
    'ConnectionHealthCheckConfigArgs',
    'ConnectionHealthCheckConfigArgsDict',
    'ConnectionIkeConfigArgs',
    'ConnectionIkeConfigArgsDict',
    'ConnectionIpsecConfigArgs',
    'ConnectionIpsecConfigArgsDict',
    'ConnectionTunnelOptionsSpecificationArgs',
    'ConnectionTunnelOptionsSpecificationArgsDict',
    'ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs',
    'ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgsDict',
    'ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs',
    'ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgsDict',
    'ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs',
    'ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgsDict',
    'GatewayVpnAttachmentBgpConfigArgs',
    'GatewayVpnAttachmentBgpConfigArgsDict',
    'GatewayVpnAttachmentHealthCheckConfigArgs',
    'GatewayVpnAttachmentHealthCheckConfigArgsDict',
    'GatewayVpnAttachmentIkeConfigArgs',
    'GatewayVpnAttachmentIkeConfigArgsDict',
    'GatewayVpnAttachmentIpsecConfigArgs',
    'GatewayVpnAttachmentIpsecConfigArgsDict',
    'GatewayVpnAttachmentTunnelOptionsSpecificationArgs',
    'GatewayVpnAttachmentTunnelOptionsSpecificationArgsDict',
    'GatewayVpnAttachmentTunnelOptionsSpecificationTunnelBgpConfigArgs',
    'GatewayVpnAttachmentTunnelOptionsSpecificationTunnelBgpConfigArgsDict',
    'GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIkeConfigArgs',
    'GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIkeConfigArgsDict',
    'GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIpsecConfigArgs',
    'GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIpsecConfigArgsDict',
    'IpsecServerIkeConfigArgs',
    'IpsecServerIkeConfigArgsDict',
    'IpsecServerIpsecConfigArgs',
    'IpsecServerIpsecConfigArgsDict',
]

MYPY = False

if not MYPY:
    class ConnectionBgpConfigArgsDict(TypedDict):
        enable: NotRequired[pulumi.Input[_builtins.bool]]
        """
        specifies whether to enable BGP. Valid values: true and false (default).
        """
        local_asn: NotRequired[pulumi.Input[_builtins.str]]
        """
        the autonomous system number (ASN) on the Alibaba Cloud side. 
        Valid values: 1 to 4294967295. Default value: 45104. You can enter a value in two segments separated by a period (.).
        Each segment is 16 bits in length. Enter the number in each segment in decimal format.
        For example, if you enter 123.456, the ASN is 8061384. The ASN is calculated by using the following formula: 123 × 65536 + 456 = 8061384.
        """
        local_bgp_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        the BGP address on the Alibaba Cloud side. It must be an IP address that falls within the CIDR block of the IPsec tunnel.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        The negotiation status of Tunnel.
        """
        tunnel_cidr: NotRequired[pulumi.Input[_builtins.str]]
        """
        The CIDR block of the IPsec tunnel. The CIDR block must belong to 169.254.0.0/16 and the subnet mask is 30 bits in length.
        """
elif False:
    ConnectionBgpConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionBgpConfigArgs:
    def __init__(__self__, *,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_asn: Optional[pulumi.Input[_builtins.str]] = None,
                 local_bgp_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_cidr: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] enable: specifies whether to enable BGP. Valid values: true and false (default).
        :param pulumi.Input[_builtins.str] local_asn: the autonomous system number (ASN) on the Alibaba Cloud side. 
               Valid values: 1 to 4294967295. Default value: 45104. You can enter a value in two segments separated by a period (.).
               Each segment is 16 bits in length. Enter the number in each segment in decimal format.
               For example, if you enter 123.456, the ASN is 8061384. The ASN is calculated by using the following formula: 123 × 65536 + 456 = 8061384.
        :param pulumi.Input[_builtins.str] local_bgp_ip: the BGP address on the Alibaba Cloud side. It must be an IP address that falls within the CIDR block of the IPsec tunnel.
        :param pulumi.Input[_builtins.str] status: The negotiation status of Tunnel.
        :param pulumi.Input[_builtins.str] tunnel_cidr: The CIDR block of the IPsec tunnel. The CIDR block must belong to 169.254.0.0/16 and the subnet mask is 30 bits in length.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if local_asn is not None:
            pulumi.set(__self__, "local_asn", local_asn)
        if local_bgp_ip is not None:
            pulumi.set(__self__, "local_bgp_ip", local_bgp_ip)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tunnel_cidr is not None:
            pulumi.set(__self__, "tunnel_cidr", tunnel_cidr)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        specifies whether to enable BGP. Valid values: true and false (default).
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter(name="localAsn")
    def local_asn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the autonomous system number (ASN) on the Alibaba Cloud side. 
        Valid values: 1 to 4294967295. Default value: 45104. You can enter a value in two segments separated by a period (.).
        Each segment is 16 bits in length. Enter the number in each segment in decimal format.
        For example, if you enter 123.456, the ASN is 8061384. The ASN is calculated by using the following formula: 123 × 65536 + 456 = 8061384.
        """
        return pulumi.get(self, "local_asn")

    @local_asn.setter
    def local_asn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_asn", value)

    @_builtins.property
    @pulumi.getter(name="localBgpIp")
    def local_bgp_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the BGP address on the Alibaba Cloud side. It must be an IP address that falls within the CIDR block of the IPsec tunnel.
        """
        return pulumi.get(self, "local_bgp_ip")

    @local_bgp_ip.setter
    def local_bgp_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_bgp_ip", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The negotiation status of Tunnel.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="tunnelCidr")
    def tunnel_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR block of the IPsec tunnel. The CIDR block must belong to 169.254.0.0/16 and the subnet mask is 30 bits in length.
        """
        return pulumi.get(self, "tunnel_cidr")

    @tunnel_cidr.setter
    def tunnel_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tunnel_cidr", value)


if not MYPY:
    class ConnectionHealthCheckConfigArgsDict(TypedDict):
        dip: NotRequired[pulumi.Input[_builtins.str]]
        """
        the destination IP address configured for health checks.
        """
        enable: NotRequired[pulumi.Input[_builtins.bool]]
        """
        specifies whether to enable health checks. Valid values: true and false. Default value: false.
        """
        interval: NotRequired[pulumi.Input[_builtins.int]]
        """
        the time interval of health check retries. Unit: seconds. Default value: 3.
        """
        retry: NotRequired[pulumi.Input[_builtins.int]]
        """
        the maximum number of health check retries. Default value: 3.
        """
        sip: NotRequired[pulumi.Input[_builtins.str]]
        """
        the source IP address that is used for health checks.
        """
elif False:
    ConnectionHealthCheckConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionHealthCheckConfigArgs:
    def __init__(__self__, *,
                 dip: Optional[pulumi.Input[_builtins.str]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 retry: Optional[pulumi.Input[_builtins.int]] = None,
                 sip: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] dip: the destination IP address configured for health checks.
        :param pulumi.Input[_builtins.bool] enable: specifies whether to enable health checks. Valid values: true and false. Default value: false.
        :param pulumi.Input[_builtins.int] interval: the time interval of health check retries. Unit: seconds. Default value: 3.
        :param pulumi.Input[_builtins.int] retry: the maximum number of health check retries. Default value: 3.
        :param pulumi.Input[_builtins.str] sip: the source IP address that is used for health checks.
        """
        if dip is not None:
            pulumi.set(__self__, "dip", dip)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if retry is not None:
            pulumi.set(__self__, "retry", retry)
        if sip is not None:
            pulumi.set(__self__, "sip", sip)

    @_builtins.property
    @pulumi.getter
    def dip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the destination IP address configured for health checks.
        """
        return pulumi.get(self, "dip")

    @dip.setter
    def dip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dip", value)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        specifies whether to enable health checks. Valid values: true and false. Default value: false.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        the time interval of health check retries. Unit: seconds. Default value: 3.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter
    def retry(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        the maximum number of health check retries. Default value: 3.
        """
        return pulumi.get(self, "retry")

    @retry.setter
    def retry(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retry", value)

    @_builtins.property
    @pulumi.getter
    def sip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the source IP address that is used for health checks.
        """
        return pulumi.get(self, "sip")

    @sip.setter
    def sip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sip", value)


if not MYPY:
    class ConnectionIkeConfigArgsDict(TypedDict):
        ike_auth_alg: NotRequired[pulumi.Input[_builtins.str]]
        """
        the authentication algorithm that is used in Phase 1 negotiations. Valid values: md5, sha1, sha2
        """
        ike_enc_alg: NotRequired[pulumi.Input[_builtins.str]]
        """
        the encryption algorithm that is used in Phase 1 negotiations. Valid values: aes, aes192, aes256, des, and 3des. Default value: aes.
        """
        ike_lifetime: NotRequired[pulumi.Input[_builtins.int]]
        """
        the SA lifetime as a result of Phase 1 negotiations. Unit: seconds. Valid values: 0 to 86400. Default value: 86400.
        """
        ike_local_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        the identifier of the VPN gateway. It can contain at most 100 characters. The default value is the IP address of the VPN gateway.
        """
        ike_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        the negotiation mode of IKE. Valid values: main and aggressive. Default value: main.
        - main: This mode offers higher security during negotiations.
        - aggressive: This mode supports faster negotiations and a higher success rate.
        """
        ike_pfs: NotRequired[pulumi.Input[_builtins.str]]
        """
        the Diffie-Hellman key exchange algorithm that is used in Phase 1 negotiations. Valid values: group1, group2, group5, and group14. Default value: group2.
        """
        ike_remote_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        the identifier of the customer gateway. It can contain at most 100 characters. The default value is the IP address of the customer gateway.
        """
        ike_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        the version of the Internet Key Exchange (IKE) protocol. Valid values: ikev1 and ikev2. Default value: ikev1.
        Compared with IKEv1, IKEv2 simplifies the security association (SA) negotiation process and provides better support for scenarios with multiple CIDR blocks.
        """
        psk: NotRequired[pulumi.Input[_builtins.str]]
        """
        the pre-shared key that is used for identity authentication between the VPN gateway and the on-premises data center. The key must be 1 to 100 characters in length and can contain digits, letters, and the following special characters: ~!\\`@#$%^&*()_-+={}[]|;:',.<>/? If you do not specify a pre-shared key, the system randomly generates a 16-bit string as the pre-shared key. You can call the DescribeVpnConnection operation to query the pre-shared key that is automatically generated by the system.
        """
elif False:
    ConnectionIkeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionIkeConfigArgs:
    def __init__(__self__, *,
                 ike_auth_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_enc_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 ike_local_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_pfs: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_remote_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_version: Optional[pulumi.Input[_builtins.str]] = None,
                 psk: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] ike_auth_alg: the authentication algorithm that is used in Phase 1 negotiations. Valid values: md5, sha1, sha2
        :param pulumi.Input[_builtins.str] ike_enc_alg: the encryption algorithm that is used in Phase 1 negotiations. Valid values: aes, aes192, aes256, des, and 3des. Default value: aes.
        :param pulumi.Input[_builtins.int] ike_lifetime: the SA lifetime as a result of Phase 1 negotiations. Unit: seconds. Valid values: 0 to 86400. Default value: 86400.
        :param pulumi.Input[_builtins.str] ike_local_id: the identifier of the VPN gateway. It can contain at most 100 characters. The default value is the IP address of the VPN gateway.
        :param pulumi.Input[_builtins.str] ike_mode: the negotiation mode of IKE. Valid values: main and aggressive. Default value: main.
               - main: This mode offers higher security during negotiations.
               - aggressive: This mode supports faster negotiations and a higher success rate.
        :param pulumi.Input[_builtins.str] ike_pfs: the Diffie-Hellman key exchange algorithm that is used in Phase 1 negotiations. Valid values: group1, group2, group5, and group14. Default value: group2.
        :param pulumi.Input[_builtins.str] ike_remote_id: the identifier of the customer gateway. It can contain at most 100 characters. The default value is the IP address of the customer gateway.
        :param pulumi.Input[_builtins.str] ike_version: the version of the Internet Key Exchange (IKE) protocol. Valid values: ikev1 and ikev2. Default value: ikev1.
               Compared with IKEv1, IKEv2 simplifies the security association (SA) negotiation process and provides better support for scenarios with multiple CIDR blocks.
        :param pulumi.Input[_builtins.str] psk: the pre-shared key that is used for identity authentication between the VPN gateway and the on-premises data center. The key must be 1 to 100 characters in length and can contain digits, letters, and the following special characters: ~!\\`@#$%^&*()_-+={}[]|;:',.<>/? If you do not specify a pre-shared key, the system randomly generates a 16-bit string as the pre-shared key. You can call the DescribeVpnConnection operation to query the pre-shared key that is automatically generated by the system.
        """
        if ike_auth_alg is not None:
            pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        if ike_enc_alg is not None:
            pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        if ike_lifetime is not None:
            pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        if ike_local_id is not None:
            pulumi.set(__self__, "ike_local_id", ike_local_id)
        if ike_mode is not None:
            pulumi.set(__self__, "ike_mode", ike_mode)
        if ike_pfs is not None:
            pulumi.set(__self__, "ike_pfs", ike_pfs)
        if ike_remote_id is not None:
            pulumi.set(__self__, "ike_remote_id", ike_remote_id)
        if ike_version is not None:
            pulumi.set(__self__, "ike_version", ike_version)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)

    @_builtins.property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the authentication algorithm that is used in Phase 1 negotiations. Valid values: md5, sha1, sha2
        """
        return pulumi.get(self, "ike_auth_alg")

    @ike_auth_alg.setter
    def ike_auth_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_auth_alg", value)

    @_builtins.property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the encryption algorithm that is used in Phase 1 negotiations. Valid values: aes, aes192, aes256, des, and 3des. Default value: aes.
        """
        return pulumi.get(self, "ike_enc_alg")

    @ike_enc_alg.setter
    def ike_enc_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_enc_alg", value)

    @_builtins.property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        the SA lifetime as a result of Phase 1 negotiations. Unit: seconds. Valid values: 0 to 86400. Default value: 86400.
        """
        return pulumi.get(self, "ike_lifetime")

    @ike_lifetime.setter
    def ike_lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ike_lifetime", value)

    @_builtins.property
    @pulumi.getter(name="ikeLocalId")
    def ike_local_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the identifier of the VPN gateway. It can contain at most 100 characters. The default value is the IP address of the VPN gateway.
        """
        return pulumi.get(self, "ike_local_id")

    @ike_local_id.setter
    def ike_local_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_local_id", value)

    @_builtins.property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the negotiation mode of IKE. Valid values: main and aggressive. Default value: main.
        - main: This mode offers higher security during negotiations.
        - aggressive: This mode supports faster negotiations and a higher success rate.
        """
        return pulumi.get(self, "ike_mode")

    @ike_mode.setter
    def ike_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_mode", value)

    @_builtins.property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the Diffie-Hellman key exchange algorithm that is used in Phase 1 negotiations. Valid values: group1, group2, group5, and group14. Default value: group2.
        """
        return pulumi.get(self, "ike_pfs")

    @ike_pfs.setter
    def ike_pfs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_pfs", value)

    @_builtins.property
    @pulumi.getter(name="ikeRemoteId")
    def ike_remote_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the identifier of the customer gateway. It can contain at most 100 characters. The default value is the IP address of the customer gateway.
        """
        return pulumi.get(self, "ike_remote_id")

    @ike_remote_id.setter
    def ike_remote_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_remote_id", value)

    @_builtins.property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the version of the Internet Key Exchange (IKE) protocol. Valid values: ikev1 and ikev2. Default value: ikev1.
        Compared with IKEv1, IKEv2 simplifies the security association (SA) negotiation process and provides better support for scenarios with multiple CIDR blocks.
        """
        return pulumi.get(self, "ike_version")

    @ike_version.setter
    def ike_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_version", value)

    @_builtins.property
    @pulumi.getter
    def psk(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the pre-shared key that is used for identity authentication between the VPN gateway and the on-premises data center. The key must be 1 to 100 characters in length and can contain digits, letters, and the following special characters: ~!\\`@#$%^&*()_-+={}[]|;:',.<>/? If you do not specify a pre-shared key, the system randomly generates a 16-bit string as the pre-shared key. You can call the DescribeVpnConnection operation to query the pre-shared key that is automatically generated by the system.
        """
        return pulumi.get(self, "psk")

    @psk.setter
    def psk(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "psk", value)


if not MYPY:
    class ConnectionIpsecConfigArgsDict(TypedDict):
        ipsec_auth_alg: NotRequired[pulumi.Input[_builtins.str]]
        """
        the authentication algorithm that is used in Phase 2 negotiations. Valid values: md5, sha1, sha256, sha384, and sha512. Default value: md5.
        """
        ipsec_enc_alg: NotRequired[pulumi.Input[_builtins.str]]
        """
        the encryption algorithm that is used in Phase 2 negotiations. Valid values: aes, aes192, aes256, des, and 3des. Default value: aes.
        """
        ipsec_lifetime: NotRequired[pulumi.Input[_builtins.int]]
        """
        the SA lifetime that is determined by Phase 2 negotiations. Unit: seconds. Valid values: 0 to 86400. Default value: 86400.
        """
        ipsec_pfs: NotRequired[pulumi.Input[_builtins.str]]
        """
        the DH key exchange algorithm that is used in Phase 2 negotiations. Valid values: disabled, group1, group2, group5, and group14. Default value: group2.
        """
elif False:
    ConnectionIpsecConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionIpsecConfigArgs:
    def __init__(__self__, *,
                 ipsec_auth_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 ipsec_enc_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 ipsec_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 ipsec_pfs: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] ipsec_auth_alg: the authentication algorithm that is used in Phase 2 negotiations. Valid values: md5, sha1, sha256, sha384, and sha512. Default value: md5.
        :param pulumi.Input[_builtins.str] ipsec_enc_alg: the encryption algorithm that is used in Phase 2 negotiations. Valid values: aes, aes192, aes256, des, and 3des. Default value: aes.
        :param pulumi.Input[_builtins.int] ipsec_lifetime: the SA lifetime that is determined by Phase 2 negotiations. Unit: seconds. Valid values: 0 to 86400. Default value: 86400.
        :param pulumi.Input[_builtins.str] ipsec_pfs: the DH key exchange algorithm that is used in Phase 2 negotiations. Valid values: disabled, group1, group2, group5, and group14. Default value: group2.
        """
        if ipsec_auth_alg is not None:
            pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        if ipsec_enc_alg is not None:
            pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        if ipsec_lifetime is not None:
            pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        if ipsec_pfs is not None:
            pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @_builtins.property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the authentication algorithm that is used in Phase 2 negotiations. Valid values: md5, sha1, sha256, sha384, and sha512. Default value: md5.
        """
        return pulumi.get(self, "ipsec_auth_alg")

    @ipsec_auth_alg.setter
    def ipsec_auth_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipsec_auth_alg", value)

    @_builtins.property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the encryption algorithm that is used in Phase 2 negotiations. Valid values: aes, aes192, aes256, des, and 3des. Default value: aes.
        """
        return pulumi.get(self, "ipsec_enc_alg")

    @ipsec_enc_alg.setter
    def ipsec_enc_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipsec_enc_alg", value)

    @_builtins.property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        the SA lifetime that is determined by Phase 2 negotiations. Unit: seconds. Valid values: 0 to 86400. Default value: 86400.
        """
        return pulumi.get(self, "ipsec_lifetime")

    @ipsec_lifetime.setter
    def ipsec_lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipsec_lifetime", value)

    @_builtins.property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the DH key exchange algorithm that is used in Phase 2 negotiations. Valid values: disabled, group1, group2, group5, and group14. Default value: group2.
        """
        return pulumi.get(self, "ipsec_pfs")

    @ipsec_pfs.setter
    def ipsec_pfs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipsec_pfs", value)


if not MYPY:
    class ConnectionTunnelOptionsSpecificationArgsDict(TypedDict):
        customer_gateway_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the customer gateway in Tunnel.
        """
        enable_dpd: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Wether enable Dpd detection.
        """
        enable_nat_traversal: NotRequired[pulumi.Input[_builtins.bool]]
        """
        enable nat traversal.
        """
        internet_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        The local internet IP in Tunnel.
        """
        role: NotRequired[pulumi.Input[_builtins.str]]
        """
        The role of Tunnel.
        """
        state: NotRequired[pulumi.Input[_builtins.str]]
        """
        The state of Tunnel.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        The negotiation status of Tunnel.
        """
        tunnel_bgp_config: NotRequired[pulumi.Input['ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgsDict']]
        """
        The bgp config of Tunnel. See `tunnel_bgp_config` below.
        """
        tunnel_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The tunnel ID of IPsec-VPN connection.
        """
        tunnel_ike_config: NotRequired[pulumi.Input['ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgsDict']]
        """
        The configuration of Phase 1 negotiations in Tunnel. See `tunnel_ike_config` below.
        """
        tunnel_ipsec_config: NotRequired[pulumi.Input['ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgsDict']]
        """
        IPsec configuration in Tunnel. See `tunnel_ipsec_config` below.
        """
        zone_no: NotRequired[pulumi.Input[_builtins.str]]
        """
        The zoneNo of tunnel.
        """
elif False:
    ConnectionTunnelOptionsSpecificationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionTunnelOptionsSpecificationArgs:
    def __init__(__self__, *,
                 customer_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_dpd: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_nat_traversal: Optional[pulumi.Input[_builtins.bool]] = None,
                 internet_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_bgp_config: Optional[pulumi.Input['ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs']] = None,
                 tunnel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_ike_config: Optional[pulumi.Input['ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs']] = None,
                 tunnel_ipsec_config: Optional[pulumi.Input['ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs']] = None,
                 zone_no: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] customer_gateway_id: The ID of the customer gateway in Tunnel.
        :param pulumi.Input[_builtins.bool] enable_dpd: Wether enable Dpd detection.
        :param pulumi.Input[_builtins.bool] enable_nat_traversal: enable nat traversal.
        :param pulumi.Input[_builtins.str] internet_ip: The local internet IP in Tunnel.
        :param pulumi.Input[_builtins.str] role: The role of Tunnel.
        :param pulumi.Input[_builtins.str] state: The state of Tunnel.
        :param pulumi.Input[_builtins.str] status: The negotiation status of Tunnel.
        :param pulumi.Input['ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs'] tunnel_bgp_config: The bgp config of Tunnel. See `tunnel_bgp_config` below.
        :param pulumi.Input[_builtins.str] tunnel_id: The tunnel ID of IPsec-VPN connection.
        :param pulumi.Input['ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs'] tunnel_ike_config: The configuration of Phase 1 negotiations in Tunnel. See `tunnel_ike_config` below.
        :param pulumi.Input['ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs'] tunnel_ipsec_config: IPsec configuration in Tunnel. See `tunnel_ipsec_config` below.
        :param pulumi.Input[_builtins.str] zone_no: The zoneNo of tunnel.
        """
        if customer_gateway_id is not None:
            pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        if enable_dpd is not None:
            pulumi.set(__self__, "enable_dpd", enable_dpd)
        if enable_nat_traversal is not None:
            pulumi.set(__self__, "enable_nat_traversal", enable_nat_traversal)
        if internet_ip is not None:
            pulumi.set(__self__, "internet_ip", internet_ip)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tunnel_bgp_config is not None:
            pulumi.set(__self__, "tunnel_bgp_config", tunnel_bgp_config)
        if tunnel_id is not None:
            pulumi.set(__self__, "tunnel_id", tunnel_id)
        if tunnel_ike_config is not None:
            pulumi.set(__self__, "tunnel_ike_config", tunnel_ike_config)
        if tunnel_ipsec_config is not None:
            pulumi.set(__self__, "tunnel_ipsec_config", tunnel_ipsec_config)
        if zone_no is not None:
            pulumi.set(__self__, "zone_no", zone_no)

    @_builtins.property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the customer gateway in Tunnel.
        """
        return pulumi.get(self, "customer_gateway_id")

    @customer_gateway_id.setter
    def customer_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="enableDpd")
    def enable_dpd(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Wether enable Dpd detection.
        """
        return pulumi.get(self, "enable_dpd")

    @enable_dpd.setter
    def enable_dpd(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dpd", value)

    @_builtins.property
    @pulumi.getter(name="enableNatTraversal")
    def enable_nat_traversal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        enable nat traversal.
        """
        return pulumi.get(self, "enable_nat_traversal")

    @enable_nat_traversal.setter
    def enable_nat_traversal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_nat_traversal", value)

    @_builtins.property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The local internet IP in Tunnel.
        """
        return pulumi.get(self, "internet_ip")

    @internet_ip.setter
    def internet_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_ip", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role of Tunnel.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of Tunnel.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The negotiation status of Tunnel.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="tunnelBgpConfig")
    def tunnel_bgp_config(self) -> Optional[pulumi.Input['ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs']]:
        """
        The bgp config of Tunnel. See `tunnel_bgp_config` below.
        """
        return pulumi.get(self, "tunnel_bgp_config")

    @tunnel_bgp_config.setter
    def tunnel_bgp_config(self, value: Optional[pulumi.Input['ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs']]):
        pulumi.set(self, "tunnel_bgp_config", value)

    @_builtins.property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tunnel ID of IPsec-VPN connection.
        """
        return pulumi.get(self, "tunnel_id")

    @tunnel_id.setter
    def tunnel_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tunnel_id", value)

    @_builtins.property
    @pulumi.getter(name="tunnelIkeConfig")
    def tunnel_ike_config(self) -> Optional[pulumi.Input['ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs']]:
        """
        The configuration of Phase 1 negotiations in Tunnel. See `tunnel_ike_config` below.
        """
        return pulumi.get(self, "tunnel_ike_config")

    @tunnel_ike_config.setter
    def tunnel_ike_config(self, value: Optional[pulumi.Input['ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs']]):
        pulumi.set(self, "tunnel_ike_config", value)

    @_builtins.property
    @pulumi.getter(name="tunnelIpsecConfig")
    def tunnel_ipsec_config(self) -> Optional[pulumi.Input['ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs']]:
        """
        IPsec configuration in Tunnel. See `tunnel_ipsec_config` below.
        """
        return pulumi.get(self, "tunnel_ipsec_config")

    @tunnel_ipsec_config.setter
    def tunnel_ipsec_config(self, value: Optional[pulumi.Input['ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs']]):
        pulumi.set(self, "tunnel_ipsec_config", value)

    @_builtins.property
    @pulumi.getter(name="zoneNo")
    def zone_no(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zoneNo of tunnel.
        """
        return pulumi.get(self, "zone_no")

    @zone_no.setter
    def zone_no(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_no", value)


if not MYPY:
    class ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgsDict(TypedDict):
        bgp_status: NotRequired[pulumi.Input[_builtins.str]]
        """
        Whether BGP function is turned on.
        """
        local_asn: NotRequired[pulumi.Input[_builtins.str]]
        local_bgp_ip: NotRequired[pulumi.Input[_builtins.str]]
        peer_asn: NotRequired[pulumi.Input[_builtins.str]]
        """
        Peer asn.
        """
        peer_bgp_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        Peer bgp ip.
        """
        tunnel_cidr: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionTunnelOptionsSpecificationTunnelBgpConfigArgs:
    def __init__(__self__, *,
                 bgp_status: Optional[pulumi.Input[_builtins.str]] = None,
                 local_asn: Optional[pulumi.Input[_builtins.str]] = None,
                 local_bgp_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_asn: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_bgp_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_cidr: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] bgp_status: Whether BGP function is turned on.
        :param pulumi.Input[_builtins.str] peer_asn: Peer asn.
        :param pulumi.Input[_builtins.str] peer_bgp_ip: Peer bgp ip.
        """
        if bgp_status is not None:
            pulumi.set(__self__, "bgp_status", bgp_status)
        if local_asn is not None:
            pulumi.set(__self__, "local_asn", local_asn)
        if local_bgp_ip is not None:
            pulumi.set(__self__, "local_bgp_ip", local_bgp_ip)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if peer_bgp_ip is not None:
            pulumi.set(__self__, "peer_bgp_ip", peer_bgp_ip)
        if tunnel_cidr is not None:
            pulumi.set(__self__, "tunnel_cidr", tunnel_cidr)

    @_builtins.property
    @pulumi.getter(name="bgpStatus")
    def bgp_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether BGP function is turned on.
        """
        return pulumi.get(self, "bgp_status")

    @bgp_status.setter
    def bgp_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bgp_status", value)

    @_builtins.property
    @pulumi.getter(name="localAsn")
    def local_asn(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "local_asn")

    @local_asn.setter
    def local_asn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_asn", value)

    @_builtins.property
    @pulumi.getter(name="localBgpIp")
    def local_bgp_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "local_bgp_ip")

    @local_bgp_ip.setter
    def local_bgp_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_bgp_ip", value)

    @_builtins.property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Peer asn.
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_asn", value)

    @_builtins.property
    @pulumi.getter(name="peerBgpIp")
    def peer_bgp_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Peer bgp ip.
        """
        return pulumi.get(self, "peer_bgp_ip")

    @peer_bgp_ip.setter
    def peer_bgp_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_bgp_ip", value)

    @_builtins.property
    @pulumi.getter(name="tunnelCidr")
    def tunnel_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tunnel_cidr")

    @tunnel_cidr.setter
    def tunnel_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tunnel_cidr", value)


if not MYPY:
    class ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgsDict(TypedDict):
        ike_auth_alg: NotRequired[pulumi.Input[_builtins.str]]
        ike_enc_alg: NotRequired[pulumi.Input[_builtins.str]]
        ike_lifetime: NotRequired[pulumi.Input[_builtins.int]]
        ike_mode: NotRequired[pulumi.Input[_builtins.str]]
        ike_pfs: NotRequired[pulumi.Input[_builtins.str]]
        ike_version: NotRequired[pulumi.Input[_builtins.str]]
        local_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The identifier of the tunnel on the Alibaba Cloud side, which is used in Phase 1 negotiations. It can contain at most 100 characters. The default value is the IP address of the tunnel.
        LocalId supports fully qualified domain names (FQDNs). If you use an FQDN, we recommend that you set the negotiation mode to aggressive.
        """
        psk: NotRequired[pulumi.Input[_builtins.str]]
        remote_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The identifier of the tunnel peer, which is used in Phase 1 negotiations. It can contain at most 100 characters. The default value is the IP address of the customer gateway that is associated with the tunnel.
        RemoteId supports FQDNs. If you use an FQDN, we recommend that you set the negotiation mode to aggressive.
        """
elif False:
    ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionTunnelOptionsSpecificationTunnelIkeConfigArgs:
    def __init__(__self__, *,
                 ike_auth_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_enc_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 ike_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_pfs: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_version: Optional[pulumi.Input[_builtins.str]] = None,
                 local_id: Optional[pulumi.Input[_builtins.str]] = None,
                 psk: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] local_id: The identifier of the tunnel on the Alibaba Cloud side, which is used in Phase 1 negotiations. It can contain at most 100 characters. The default value is the IP address of the tunnel.
               LocalId supports fully qualified domain names (FQDNs). If you use an FQDN, we recommend that you set the negotiation mode to aggressive.
        :param pulumi.Input[_builtins.str] remote_id: The identifier of the tunnel peer, which is used in Phase 1 negotiations. It can contain at most 100 characters. The default value is the IP address of the customer gateway that is associated with the tunnel.
               RemoteId supports FQDNs. If you use an FQDN, we recommend that you set the negotiation mode to aggressive.
        """
        if ike_auth_alg is not None:
            pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        if ike_enc_alg is not None:
            pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        if ike_lifetime is not None:
            pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        if ike_mode is not None:
            pulumi.set(__self__, "ike_mode", ike_mode)
        if ike_pfs is not None:
            pulumi.set(__self__, "ike_pfs", ike_pfs)
        if ike_version is not None:
            pulumi.set(__self__, "ike_version", ike_version)
        if local_id is not None:
            pulumi.set(__self__, "local_id", local_id)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)
        if remote_id is not None:
            pulumi.set(__self__, "remote_id", remote_id)

    @_builtins.property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ike_auth_alg")

    @ike_auth_alg.setter
    def ike_auth_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_auth_alg", value)

    @_builtins.property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ike_enc_alg")

    @ike_enc_alg.setter
    def ike_enc_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_enc_alg", value)

    @_builtins.property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "ike_lifetime")

    @ike_lifetime.setter
    def ike_lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ike_lifetime", value)

    @_builtins.property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ike_mode")

    @ike_mode.setter
    def ike_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_mode", value)

    @_builtins.property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ike_pfs")

    @ike_pfs.setter
    def ike_pfs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_pfs", value)

    @_builtins.property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ike_version")

    @ike_version.setter
    def ike_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_version", value)

    @_builtins.property
    @pulumi.getter(name="localId")
    def local_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the tunnel on the Alibaba Cloud side, which is used in Phase 1 negotiations. It can contain at most 100 characters. The default value is the IP address of the tunnel.
        LocalId supports fully qualified domain names (FQDNs). If you use an FQDN, we recommend that you set the negotiation mode to aggressive.
        """
        return pulumi.get(self, "local_id")

    @local_id.setter
    def local_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_id", value)

    @_builtins.property
    @pulumi.getter
    def psk(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "psk")

    @psk.setter
    def psk(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "psk", value)

    @_builtins.property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the tunnel peer, which is used in Phase 1 negotiations. It can contain at most 100 characters. The default value is the IP address of the customer gateway that is associated with the tunnel.
        RemoteId supports FQDNs. If you use an FQDN, we recommend that you set the negotiation mode to aggressive.
        """
        return pulumi.get(self, "remote_id")

    @remote_id.setter
    def remote_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_id", value)


if not MYPY:
    class ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgsDict(TypedDict):
        ipsec_auth_alg: NotRequired[pulumi.Input[_builtins.str]]
        ipsec_enc_alg: NotRequired[pulumi.Input[_builtins.str]]
        ipsec_lifetime: NotRequired[pulumi.Input[_builtins.int]]
        ipsec_pfs: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionTunnelOptionsSpecificationTunnelIpsecConfigArgs:
    def __init__(__self__, *,
                 ipsec_auth_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 ipsec_enc_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 ipsec_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 ipsec_pfs: Optional[pulumi.Input[_builtins.str]] = None):
        if ipsec_auth_alg is not None:
            pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        if ipsec_enc_alg is not None:
            pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        if ipsec_lifetime is not None:
            pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        if ipsec_pfs is not None:
            pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @_builtins.property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ipsec_auth_alg")

    @ipsec_auth_alg.setter
    def ipsec_auth_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipsec_auth_alg", value)

    @_builtins.property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ipsec_enc_alg")

    @ipsec_enc_alg.setter
    def ipsec_enc_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipsec_enc_alg", value)

    @_builtins.property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "ipsec_lifetime")

    @ipsec_lifetime.setter
    def ipsec_lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipsec_lifetime", value)

    @_builtins.property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ipsec_pfs")

    @ipsec_pfs.setter
    def ipsec_pfs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipsec_pfs", value)


if not MYPY:
    class GatewayVpnAttachmentBgpConfigArgsDict(TypedDict):
        enable: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable the BGP function. Valid values: true or false (default).
        """
        local_asn: NotRequired[pulumi.Input[_builtins.int]]
        """
        The autonomous system number on the Alibaba Cloud side. The value range of autonomous system number is 1~4294967295. Default value: 45104
        """
        local_bgp_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        The BGP address on the Alibaba Cloud side. This address is an IP address in the IPsec tunnel network segment.
        - Before adding the BGP configuration, we recommend that you understand the working mechanism and usage restrictions of the BGP dynamic routing function. For more information, see BGP Dynamic Routing Bulletin.
        - We recommend that you use the private number of the autonomous system number to establish a BGP connection with Alibaba Cloud. Please refer to the documentation for the private number range of the autonomous system number.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        The negotiation status of Tunnel.
        """
        tunnel_cidr: NotRequired[pulumi.Input[_builtins.str]]
        """
        IPsec tunnel network segment. This network segment must be a network segment with a mask length of 30 within 169.254.0.0/16
        """
elif False:
    GatewayVpnAttachmentBgpConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GatewayVpnAttachmentBgpConfigArgs:
    def __init__(__self__, *,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_asn: Optional[pulumi.Input[_builtins.int]] = None,
                 local_bgp_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_cidr: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] enable: Whether to enable the BGP function. Valid values: true or false (default).
        :param pulumi.Input[_builtins.int] local_asn: The autonomous system number on the Alibaba Cloud side. The value range of autonomous system number is 1~4294967295. Default value: 45104
        :param pulumi.Input[_builtins.str] local_bgp_ip: The BGP address on the Alibaba Cloud side. This address is an IP address in the IPsec tunnel network segment.
               - Before adding the BGP configuration, we recommend that you understand the working mechanism and usage restrictions of the BGP dynamic routing function. For more information, see BGP Dynamic Routing Bulletin.
               - We recommend that you use the private number of the autonomous system number to establish a BGP connection with Alibaba Cloud. Please refer to the documentation for the private number range of the autonomous system number.
        :param pulumi.Input[_builtins.str] status: The negotiation status of Tunnel.
        :param pulumi.Input[_builtins.str] tunnel_cidr: IPsec tunnel network segment. This network segment must be a network segment with a mask length of 30 within 169.254.0.0/16
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if local_asn is not None:
            pulumi.set(__self__, "local_asn", local_asn)
        if local_bgp_ip is not None:
            pulumi.set(__self__, "local_bgp_ip", local_bgp_ip)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tunnel_cidr is not None:
            pulumi.set(__self__, "tunnel_cidr", tunnel_cidr)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the BGP function. Valid values: true or false (default).
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter(name="localAsn")
    def local_asn(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The autonomous system number on the Alibaba Cloud side. The value range of autonomous system number is 1~4294967295. Default value: 45104
        """
        return pulumi.get(self, "local_asn")

    @local_asn.setter
    def local_asn(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "local_asn", value)

    @_builtins.property
    @pulumi.getter(name="localBgpIp")
    def local_bgp_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The BGP address on the Alibaba Cloud side. This address is an IP address in the IPsec tunnel network segment.
        - Before adding the BGP configuration, we recommend that you understand the working mechanism and usage restrictions of the BGP dynamic routing function. For more information, see BGP Dynamic Routing Bulletin.
        - We recommend that you use the private number of the autonomous system number to establish a BGP connection with Alibaba Cloud. Please refer to the documentation for the private number range of the autonomous system number.
        """
        return pulumi.get(self, "local_bgp_ip")

    @local_bgp_ip.setter
    def local_bgp_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_bgp_ip", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The negotiation status of Tunnel.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="tunnelCidr")
    def tunnel_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IPsec tunnel network segment. This network segment must be a network segment with a mask length of 30 within 169.254.0.0/16
        """
        return pulumi.get(self, "tunnel_cidr")

    @tunnel_cidr.setter
    def tunnel_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tunnel_cidr", value)


if not MYPY:
    class GatewayVpnAttachmentHealthCheckConfigArgsDict(TypedDict):
        dip: NotRequired[pulumi.Input[_builtins.str]]
        """
        Target IP.
        """
        enable: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether health check is enabled:-`false`: not enabled. - `true`: enabled.
        """
        interval: NotRequired[pulumi.Input[_builtins.int]]
        """
        The health check retry interval, in seconds.
        """
        policy: NotRequired[pulumi.Input[_builtins.str]]
        """
        Whether to revoke the published route when the health check fails
        """
        retry: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of retries for health check.
        """
        sip: NotRequired[pulumi.Input[_builtins.str]]
        """
        SOURCE IP.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        The negotiation status of Tunnel.
        """
elif False:
    GatewayVpnAttachmentHealthCheckConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GatewayVpnAttachmentHealthCheckConfigArgs:
    def __init__(__self__, *,
                 dip: Optional[pulumi.Input[_builtins.str]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 retry: Optional[pulumi.Input[_builtins.int]] = None,
                 sip: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] dip: Target IP.
        :param pulumi.Input[_builtins.bool] enable: Whether health check is enabled:-`false`: not enabled. - `true`: enabled.
        :param pulumi.Input[_builtins.int] interval: The health check retry interval, in seconds.
        :param pulumi.Input[_builtins.str] policy: Whether to revoke the published route when the health check fails
        :param pulumi.Input[_builtins.int] retry: Number of retries for health check.
        :param pulumi.Input[_builtins.str] sip: SOURCE IP.
        :param pulumi.Input[_builtins.str] status: The negotiation status of Tunnel.
        """
        if dip is not None:
            pulumi.set(__self__, "dip", dip)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if retry is not None:
            pulumi.set(__self__, "retry", retry)
        if sip is not None:
            pulumi.set(__self__, "sip", sip)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def dip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Target IP.
        """
        return pulumi.get(self, "dip")

    @dip.setter
    def dip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dip", value)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether health check is enabled:-`false`: not enabled. - `true`: enabled.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The health check retry interval, in seconds.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to revoke the published route when the health check fails
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter
    def retry(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of retries for health check.
        """
        return pulumi.get(self, "retry")

    @retry.setter
    def retry(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retry", value)

    @_builtins.property
    @pulumi.getter
    def sip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SOURCE IP.
        """
        return pulumi.get(self, "sip")

    @sip.setter
    def sip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sip", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The negotiation status of Tunnel.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


if not MYPY:
    class GatewayVpnAttachmentIkeConfigArgsDict(TypedDict):
        ike_auth_alg: NotRequired[pulumi.Input[_builtins.str]]
        """
        The authentication algorithm negotiated in the first stage. Valid values: md5, sha1, sha256, sha384, sha512. Default value: md5.
        """
        ike_enc_alg: NotRequired[pulumi.Input[_builtins.str]]
        """
        The encryption algorithm that is used in Phase 1 negotiations. Valid values: aes, aes192, aes256, des, and 3des. Default value: aes.
        """
        ike_lifetime: NotRequired[pulumi.Input[_builtins.int]]
        """
        The SA lifetime as a result of Phase 1 negotiations. Unit: seconds. Valid values: 0 to 86400. Default value: 86400.
        """
        ike_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        IKE mode, the negotiation mode. Valid values: main and aggressive. Default value: main.
        """
        ike_pfs: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Diffie-Hellman key exchange algorithm used in the first stage negotiation. Valid values: group1, group2, group5, or group14. Default value: group2.
        """
        ike_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        The version of the IKE protocol. Value: ikev1 or ikev2. Default value: ikev1.
        """
        local_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The identifier on the Alibaba Cloud side of the IPsec connection. The length is limited to 100 characters. The default value is leftId-not-exist
        """
        psk: NotRequired[pulumi.Input[_builtins.str]]
        """
        A pre-shared key for authentication between the VPN gateway and the local data center. The key length is 1~100 characters.
        - If you do not specify a pre-shared key, the system randomly generates a 16-bit string as the pre-shared key.
        - The pre-shared key of the IPsec-VPN connection must be the same as the authentication key of the on-premises data center. Otherwise, connections between the on-premises data center and the VPN gateway cannot be established.
        """
        remote_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The identifier of the IPsec connection to the local data center. The length is limited to 100 characters. The default value is the IP address of the user gateway.
        """
elif False:
    GatewayVpnAttachmentIkeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GatewayVpnAttachmentIkeConfigArgs:
    def __init__(__self__, *,
                 ike_auth_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_enc_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 ike_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_pfs: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_version: Optional[pulumi.Input[_builtins.str]] = None,
                 local_id: Optional[pulumi.Input[_builtins.str]] = None,
                 psk: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] ike_auth_alg: The authentication algorithm negotiated in the first stage. Valid values: md5, sha1, sha256, sha384, sha512. Default value: md5.
        :param pulumi.Input[_builtins.str] ike_enc_alg: The encryption algorithm that is used in Phase 1 negotiations. Valid values: aes, aes192, aes256, des, and 3des. Default value: aes.
        :param pulumi.Input[_builtins.int] ike_lifetime: The SA lifetime as a result of Phase 1 negotiations. Unit: seconds. Valid values: 0 to 86400. Default value: 86400.
        :param pulumi.Input[_builtins.str] ike_mode: IKE mode, the negotiation mode. Valid values: main and aggressive. Default value: main.
        :param pulumi.Input[_builtins.str] ike_pfs: The Diffie-Hellman key exchange algorithm used in the first stage negotiation. Valid values: group1, group2, group5, or group14. Default value: group2.
        :param pulumi.Input[_builtins.str] ike_version: The version of the IKE protocol. Value: ikev1 or ikev2. Default value: ikev1.
        :param pulumi.Input[_builtins.str] local_id: The identifier on the Alibaba Cloud side of the IPsec connection. The length is limited to 100 characters. The default value is leftId-not-exist
        :param pulumi.Input[_builtins.str] psk: A pre-shared key for authentication between the VPN gateway and the local data center. The key length is 1~100 characters.
               - If you do not specify a pre-shared key, the system randomly generates a 16-bit string as the pre-shared key.
               - The pre-shared key of the IPsec-VPN connection must be the same as the authentication key of the on-premises data center. Otherwise, connections between the on-premises data center and the VPN gateway cannot be established.
        :param pulumi.Input[_builtins.str] remote_id: The identifier of the IPsec connection to the local data center. The length is limited to 100 characters. The default value is the IP address of the user gateway.
        """
        if ike_auth_alg is not None:
            pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        if ike_enc_alg is not None:
            pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        if ike_lifetime is not None:
            pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        if ike_mode is not None:
            pulumi.set(__self__, "ike_mode", ike_mode)
        if ike_pfs is not None:
            pulumi.set(__self__, "ike_pfs", ike_pfs)
        if ike_version is not None:
            pulumi.set(__self__, "ike_version", ike_version)
        if local_id is not None:
            pulumi.set(__self__, "local_id", local_id)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)
        if remote_id is not None:
            pulumi.set(__self__, "remote_id", remote_id)

    @_builtins.property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication algorithm negotiated in the first stage. Valid values: md5, sha1, sha256, sha384, sha512. Default value: md5.
        """
        return pulumi.get(self, "ike_auth_alg")

    @ike_auth_alg.setter
    def ike_auth_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_auth_alg", value)

    @_builtins.property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encryption algorithm that is used in Phase 1 negotiations. Valid values: aes, aes192, aes256, des, and 3des. Default value: aes.
        """
        return pulumi.get(self, "ike_enc_alg")

    @ike_enc_alg.setter
    def ike_enc_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_enc_alg", value)

    @_builtins.property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The SA lifetime as a result of Phase 1 negotiations. Unit: seconds. Valid values: 0 to 86400. Default value: 86400.
        """
        return pulumi.get(self, "ike_lifetime")

    @ike_lifetime.setter
    def ike_lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ike_lifetime", value)

    @_builtins.property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IKE mode, the negotiation mode. Valid values: main and aggressive. Default value: main.
        """
        return pulumi.get(self, "ike_mode")

    @ike_mode.setter
    def ike_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_mode", value)

    @_builtins.property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Diffie-Hellman key exchange algorithm used in the first stage negotiation. Valid values: group1, group2, group5, or group14. Default value: group2.
        """
        return pulumi.get(self, "ike_pfs")

    @ike_pfs.setter
    def ike_pfs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_pfs", value)

    @_builtins.property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the IKE protocol. Value: ikev1 or ikev2. Default value: ikev1.
        """
        return pulumi.get(self, "ike_version")

    @ike_version.setter
    def ike_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_version", value)

    @_builtins.property
    @pulumi.getter(name="localId")
    def local_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier on the Alibaba Cloud side of the IPsec connection. The length is limited to 100 characters. The default value is leftId-not-exist
        """
        return pulumi.get(self, "local_id")

    @local_id.setter
    def local_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_id", value)

    @_builtins.property
    @pulumi.getter
    def psk(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A pre-shared key for authentication between the VPN gateway and the local data center. The key length is 1~100 characters.
        - If you do not specify a pre-shared key, the system randomly generates a 16-bit string as the pre-shared key.
        - The pre-shared key of the IPsec-VPN connection must be the same as the authentication key of the on-premises data center. Otherwise, connections between the on-premises data center and the VPN gateway cannot be established.
        """
        return pulumi.get(self, "psk")

    @psk.setter
    def psk(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "psk", value)

    @_builtins.property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the IPsec connection to the local data center. The length is limited to 100 characters. The default value is the IP address of the user gateway.
        """
        return pulumi.get(self, "remote_id")

    @remote_id.setter
    def remote_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_id", value)


if not MYPY:
    class GatewayVpnAttachmentIpsecConfigArgsDict(TypedDict):
        ipsec_auth_alg: NotRequired[pulumi.Input[_builtins.str]]
        """
        The authentication algorithm negotiated in the second stage. Valid values: md5, sha1, sha256, sha384, sha512. Default value: MD5.
        """
        ipsec_enc_alg: NotRequired[pulumi.Input[_builtins.str]]
        """
        The encryption algorithm negotiated in the second stage. Valid values: aes, aes192, aes256, des, or 3des. Default value: aes.
        """
        ipsec_lifetime: NotRequired[pulumi.Input[_builtins.int]]
        """
        The life cycle of SA negotiated in the second stage. Unit: seconds. Value range: 0~86400. Default value: 86400.
        """
        ipsec_pfs: NotRequired[pulumi.Input[_builtins.str]]
        """
        Diffie-Hellman Key Exchange Algorithm Used in Second Stage Negotiation
        """
elif False:
    GatewayVpnAttachmentIpsecConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GatewayVpnAttachmentIpsecConfigArgs:
    def __init__(__self__, *,
                 ipsec_auth_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 ipsec_enc_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 ipsec_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 ipsec_pfs: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] ipsec_auth_alg: The authentication algorithm negotiated in the second stage. Valid values: md5, sha1, sha256, sha384, sha512. Default value: MD5.
        :param pulumi.Input[_builtins.str] ipsec_enc_alg: The encryption algorithm negotiated in the second stage. Valid values: aes, aes192, aes256, des, or 3des. Default value: aes.
        :param pulumi.Input[_builtins.int] ipsec_lifetime: The life cycle of SA negotiated in the second stage. Unit: seconds. Value range: 0~86400. Default value: 86400.
        :param pulumi.Input[_builtins.str] ipsec_pfs: Diffie-Hellman Key Exchange Algorithm Used in Second Stage Negotiation
        """
        if ipsec_auth_alg is not None:
            pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        if ipsec_enc_alg is not None:
            pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        if ipsec_lifetime is not None:
            pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        if ipsec_pfs is not None:
            pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @_builtins.property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication algorithm negotiated in the second stage. Valid values: md5, sha1, sha256, sha384, sha512. Default value: MD5.
        """
        return pulumi.get(self, "ipsec_auth_alg")

    @ipsec_auth_alg.setter
    def ipsec_auth_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipsec_auth_alg", value)

    @_builtins.property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encryption algorithm negotiated in the second stage. Valid values: aes, aes192, aes256, des, or 3des. Default value: aes.
        """
        return pulumi.get(self, "ipsec_enc_alg")

    @ipsec_enc_alg.setter
    def ipsec_enc_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipsec_enc_alg", value)

    @_builtins.property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The life cycle of SA negotiated in the second stage. Unit: seconds. Value range: 0~86400. Default value: 86400.
        """
        return pulumi.get(self, "ipsec_lifetime")

    @ipsec_lifetime.setter
    def ipsec_lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipsec_lifetime", value)

    @_builtins.property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Diffie-Hellman Key Exchange Algorithm Used in Second Stage Negotiation
        """
        return pulumi.get(self, "ipsec_pfs")

    @ipsec_pfs.setter
    def ipsec_pfs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipsec_pfs", value)


if not MYPY:
    class GatewayVpnAttachmentTunnelOptionsSpecificationArgsDict(TypedDict):
        customer_gateway_id: pulumi.Input[_builtins.str]
        """
        The ID of the user gateway associated with the tunnel.

        > **NOTE:**  This parameter is required when creating a dual-tunnel mode IPsec-VPN connection.
        """
        tunnel_index: pulumi.Input[_builtins.int]
        """
        The order in which the tunnel was created.
        """
        enable_dpd: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether the DPD (peer alive detection) function is enabled for the tunnel. Value:
        """
        enable_nat_traversal: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether the NAT crossing function is enabled for the tunnel. Value:
        """
        internet_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        The local internet IP in Tunnel.
        """
        role: NotRequired[pulumi.Input[_builtins.str]]
        """
        The role of Tunnel.
        """
        state: NotRequired[pulumi.Input[_builtins.str]]
        """
        The state of Tunnel.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        The negotiation status of Tunnel.
        """
        tunnel_bgp_config: NotRequired[pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationTunnelBgpConfigArgsDict']]
        """
        Add the BGP configuration for the tunnel.

        > **NOTE:**  After you enable the BGP function for IPsec connections (that is, specify `EnableTunnelsBgp` as `true`), you must configure this parameter.
        See `tunnel_bgp_config` below.
        """
        tunnel_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The tunnel ID of IPsec-VPN connection.
        """
        tunnel_ike_config: NotRequired[pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIkeConfigArgsDict']]
        """
        Configuration information for the first phase negotiation. See `tunnel_ike_config` below.
        """
        tunnel_ipsec_config: NotRequired[pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIpsecConfigArgsDict']]
        """
        Configuration information for the second-stage negotiation. See `tunnel_ipsec_config` below.
        """
        zone_no: NotRequired[pulumi.Input[_builtins.str]]
        """
        The zoneNo of tunnel.
        """
elif False:
    GatewayVpnAttachmentTunnelOptionsSpecificationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GatewayVpnAttachmentTunnelOptionsSpecificationArgs:
    def __init__(__self__, *,
                 customer_gateway_id: pulumi.Input[_builtins.str],
                 tunnel_index: pulumi.Input[_builtins.int],
                 enable_dpd: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_nat_traversal: Optional[pulumi.Input[_builtins.bool]] = None,
                 internet_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_bgp_config: Optional[pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationTunnelBgpConfigArgs']] = None,
                 tunnel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_ike_config: Optional[pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIkeConfigArgs']] = None,
                 tunnel_ipsec_config: Optional[pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIpsecConfigArgs']] = None,
                 zone_no: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] customer_gateway_id: The ID of the user gateway associated with the tunnel.
               
               > **NOTE:**  This parameter is required when creating a dual-tunnel mode IPsec-VPN connection.
        :param pulumi.Input[_builtins.int] tunnel_index: The order in which the tunnel was created.
        :param pulumi.Input[_builtins.bool] enable_dpd: Whether the DPD (peer alive detection) function is enabled for the tunnel. Value:
        :param pulumi.Input[_builtins.bool] enable_nat_traversal: Whether the NAT crossing function is enabled for the tunnel. Value:
        :param pulumi.Input[_builtins.str] internet_ip: The local internet IP in Tunnel.
        :param pulumi.Input[_builtins.str] role: The role of Tunnel.
        :param pulumi.Input[_builtins.str] state: The state of Tunnel.
        :param pulumi.Input[_builtins.str] status: The negotiation status of Tunnel.
        :param pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationTunnelBgpConfigArgs'] tunnel_bgp_config: Add the BGP configuration for the tunnel.
               
               > **NOTE:**  After you enable the BGP function for IPsec connections (that is, specify `EnableTunnelsBgp` as `true`), you must configure this parameter.
               See `tunnel_bgp_config` below.
        :param pulumi.Input[_builtins.str] tunnel_id: The tunnel ID of IPsec-VPN connection.
        :param pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIkeConfigArgs'] tunnel_ike_config: Configuration information for the first phase negotiation. See `tunnel_ike_config` below.
        :param pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIpsecConfigArgs'] tunnel_ipsec_config: Configuration information for the second-stage negotiation. See `tunnel_ipsec_config` below.
        :param pulumi.Input[_builtins.str] zone_no: The zoneNo of tunnel.
        """
        pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        pulumi.set(__self__, "tunnel_index", tunnel_index)
        if enable_dpd is not None:
            pulumi.set(__self__, "enable_dpd", enable_dpd)
        if enable_nat_traversal is not None:
            pulumi.set(__self__, "enable_nat_traversal", enable_nat_traversal)
        if internet_ip is not None:
            pulumi.set(__self__, "internet_ip", internet_ip)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tunnel_bgp_config is not None:
            pulumi.set(__self__, "tunnel_bgp_config", tunnel_bgp_config)
        if tunnel_id is not None:
            pulumi.set(__self__, "tunnel_id", tunnel_id)
        if tunnel_ike_config is not None:
            pulumi.set(__self__, "tunnel_ike_config", tunnel_ike_config)
        if tunnel_ipsec_config is not None:
            pulumi.set(__self__, "tunnel_ipsec_config", tunnel_ipsec_config)
        if zone_no is not None:
            pulumi.set(__self__, "zone_no", zone_no)

    @_builtins.property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the user gateway associated with the tunnel.

        > **NOTE:**  This parameter is required when creating a dual-tunnel mode IPsec-VPN connection.
        """
        return pulumi.get(self, "customer_gateway_id")

    @customer_gateway_id.setter
    def customer_gateway_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "customer_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="tunnelIndex")
    def tunnel_index(self) -> pulumi.Input[_builtins.int]:
        """
        The order in which the tunnel was created.
        """
        return pulumi.get(self, "tunnel_index")

    @tunnel_index.setter
    def tunnel_index(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "tunnel_index", value)

    @_builtins.property
    @pulumi.getter(name="enableDpd")
    def enable_dpd(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the DPD (peer alive detection) function is enabled for the tunnel. Value:
        """
        return pulumi.get(self, "enable_dpd")

    @enable_dpd.setter
    def enable_dpd(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dpd", value)

    @_builtins.property
    @pulumi.getter(name="enableNatTraversal")
    def enable_nat_traversal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the NAT crossing function is enabled for the tunnel. Value:
        """
        return pulumi.get(self, "enable_nat_traversal")

    @enable_nat_traversal.setter
    def enable_nat_traversal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_nat_traversal", value)

    @_builtins.property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The local internet IP in Tunnel.
        """
        return pulumi.get(self, "internet_ip")

    @internet_ip.setter
    def internet_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_ip", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role of Tunnel.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of Tunnel.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The negotiation status of Tunnel.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="tunnelBgpConfig")
    def tunnel_bgp_config(self) -> Optional[pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationTunnelBgpConfigArgs']]:
        """
        Add the BGP configuration for the tunnel.

        > **NOTE:**  After you enable the BGP function for IPsec connections (that is, specify `EnableTunnelsBgp` as `true`), you must configure this parameter.
        See `tunnel_bgp_config` below.
        """
        return pulumi.get(self, "tunnel_bgp_config")

    @tunnel_bgp_config.setter
    def tunnel_bgp_config(self, value: Optional[pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationTunnelBgpConfigArgs']]):
        pulumi.set(self, "tunnel_bgp_config", value)

    @_builtins.property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tunnel ID of IPsec-VPN connection.
        """
        return pulumi.get(self, "tunnel_id")

    @tunnel_id.setter
    def tunnel_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tunnel_id", value)

    @_builtins.property
    @pulumi.getter(name="tunnelIkeConfig")
    def tunnel_ike_config(self) -> Optional[pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIkeConfigArgs']]:
        """
        Configuration information for the first phase negotiation. See `tunnel_ike_config` below.
        """
        return pulumi.get(self, "tunnel_ike_config")

    @tunnel_ike_config.setter
    def tunnel_ike_config(self, value: Optional[pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIkeConfigArgs']]):
        pulumi.set(self, "tunnel_ike_config", value)

    @_builtins.property
    @pulumi.getter(name="tunnelIpsecConfig")
    def tunnel_ipsec_config(self) -> Optional[pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIpsecConfigArgs']]:
        """
        Configuration information for the second-stage negotiation. See `tunnel_ipsec_config` below.
        """
        return pulumi.get(self, "tunnel_ipsec_config")

    @tunnel_ipsec_config.setter
    def tunnel_ipsec_config(self, value: Optional[pulumi.Input['GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIpsecConfigArgs']]):
        pulumi.set(self, "tunnel_ipsec_config", value)

    @_builtins.property
    @pulumi.getter(name="zoneNo")
    def zone_no(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zoneNo of tunnel.
        """
        return pulumi.get(self, "zone_no")

    @zone_no.setter
    def zone_no(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_no", value)


if not MYPY:
    class GatewayVpnAttachmentTunnelOptionsSpecificationTunnelBgpConfigArgsDict(TypedDict):
        bgp_status: NotRequired[pulumi.Input[_builtins.str]]
        """
        BGP status.
        """
        local_asn: NotRequired[pulumi.Input[_builtins.int]]
        local_bgp_ip: NotRequired[pulumi.Input[_builtins.str]]
        peer_asn: NotRequired[pulumi.Input[_builtins.str]]
        """
        Peer asn.
        """
        peer_bgp_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        Peer bgp ip.
        """
        tunnel_cidr: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    GatewayVpnAttachmentTunnelOptionsSpecificationTunnelBgpConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GatewayVpnAttachmentTunnelOptionsSpecificationTunnelBgpConfigArgs:
    def __init__(__self__, *,
                 bgp_status: Optional[pulumi.Input[_builtins.str]] = None,
                 local_asn: Optional[pulumi.Input[_builtins.int]] = None,
                 local_bgp_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_asn: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_bgp_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_cidr: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] bgp_status: BGP status.
        :param pulumi.Input[_builtins.str] peer_asn: Peer asn.
        :param pulumi.Input[_builtins.str] peer_bgp_ip: Peer bgp ip.
        """
        if bgp_status is not None:
            pulumi.set(__self__, "bgp_status", bgp_status)
        if local_asn is not None:
            pulumi.set(__self__, "local_asn", local_asn)
        if local_bgp_ip is not None:
            pulumi.set(__self__, "local_bgp_ip", local_bgp_ip)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if peer_bgp_ip is not None:
            pulumi.set(__self__, "peer_bgp_ip", peer_bgp_ip)
        if tunnel_cidr is not None:
            pulumi.set(__self__, "tunnel_cidr", tunnel_cidr)

    @_builtins.property
    @pulumi.getter(name="bgpStatus")
    def bgp_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        BGP status.
        """
        return pulumi.get(self, "bgp_status")

    @bgp_status.setter
    def bgp_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bgp_status", value)

    @_builtins.property
    @pulumi.getter(name="localAsn")
    def local_asn(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "local_asn")

    @local_asn.setter
    def local_asn(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "local_asn", value)

    @_builtins.property
    @pulumi.getter(name="localBgpIp")
    def local_bgp_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "local_bgp_ip")

    @local_bgp_ip.setter
    def local_bgp_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_bgp_ip", value)

    @_builtins.property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Peer asn.
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_asn", value)

    @_builtins.property
    @pulumi.getter(name="peerBgpIp")
    def peer_bgp_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Peer bgp ip.
        """
        return pulumi.get(self, "peer_bgp_ip")

    @peer_bgp_ip.setter
    def peer_bgp_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_bgp_ip", value)

    @_builtins.property
    @pulumi.getter(name="tunnelCidr")
    def tunnel_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tunnel_cidr")

    @tunnel_cidr.setter
    def tunnel_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tunnel_cidr", value)


if not MYPY:
    class GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIkeConfigArgsDict(TypedDict):
        ike_auth_alg: NotRequired[pulumi.Input[_builtins.str]]
        ike_enc_alg: NotRequired[pulumi.Input[_builtins.str]]
        ike_lifetime: NotRequired[pulumi.Input[_builtins.int]]
        ike_mode: NotRequired[pulumi.Input[_builtins.str]]
        ike_pfs: NotRequired[pulumi.Input[_builtins.str]]
        ike_version: NotRequired[pulumi.Input[_builtins.str]]
        local_id: NotRequired[pulumi.Input[_builtins.str]]
        psk: NotRequired[pulumi.Input[_builtins.str]]
        remote_id: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIkeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIkeConfigArgs:
    def __init__(__self__, *,
                 ike_auth_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_enc_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 ike_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_pfs: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_version: Optional[pulumi.Input[_builtins.str]] = None,
                 local_id: Optional[pulumi.Input[_builtins.str]] = None,
                 psk: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_id: Optional[pulumi.Input[_builtins.str]] = None):
        if ike_auth_alg is not None:
            pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        if ike_enc_alg is not None:
            pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        if ike_lifetime is not None:
            pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        if ike_mode is not None:
            pulumi.set(__self__, "ike_mode", ike_mode)
        if ike_pfs is not None:
            pulumi.set(__self__, "ike_pfs", ike_pfs)
        if ike_version is not None:
            pulumi.set(__self__, "ike_version", ike_version)
        if local_id is not None:
            pulumi.set(__self__, "local_id", local_id)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)
        if remote_id is not None:
            pulumi.set(__self__, "remote_id", remote_id)

    @_builtins.property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ike_auth_alg")

    @ike_auth_alg.setter
    def ike_auth_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_auth_alg", value)

    @_builtins.property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ike_enc_alg")

    @ike_enc_alg.setter
    def ike_enc_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_enc_alg", value)

    @_builtins.property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "ike_lifetime")

    @ike_lifetime.setter
    def ike_lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ike_lifetime", value)

    @_builtins.property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ike_mode")

    @ike_mode.setter
    def ike_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_mode", value)

    @_builtins.property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ike_pfs")

    @ike_pfs.setter
    def ike_pfs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_pfs", value)

    @_builtins.property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ike_version")

    @ike_version.setter
    def ike_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_version", value)

    @_builtins.property
    @pulumi.getter(name="localId")
    def local_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "local_id")

    @local_id.setter
    def local_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_id", value)

    @_builtins.property
    @pulumi.getter
    def psk(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "psk")

    @psk.setter
    def psk(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "psk", value)

    @_builtins.property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "remote_id")

    @remote_id.setter
    def remote_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_id", value)


if not MYPY:
    class GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIpsecConfigArgsDict(TypedDict):
        ipsec_auth_alg: NotRequired[pulumi.Input[_builtins.str]]
        ipsec_enc_alg: NotRequired[pulumi.Input[_builtins.str]]
        ipsec_lifetime: NotRequired[pulumi.Input[_builtins.int]]
        ipsec_pfs: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIpsecConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GatewayVpnAttachmentTunnelOptionsSpecificationTunnelIpsecConfigArgs:
    def __init__(__self__, *,
                 ipsec_auth_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 ipsec_enc_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 ipsec_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 ipsec_pfs: Optional[pulumi.Input[_builtins.str]] = None):
        if ipsec_auth_alg is not None:
            pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        if ipsec_enc_alg is not None:
            pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        if ipsec_lifetime is not None:
            pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        if ipsec_pfs is not None:
            pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @_builtins.property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ipsec_auth_alg")

    @ipsec_auth_alg.setter
    def ipsec_auth_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipsec_auth_alg", value)

    @_builtins.property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ipsec_enc_alg")

    @ipsec_enc_alg.setter
    def ipsec_enc_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipsec_enc_alg", value)

    @_builtins.property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "ipsec_lifetime")

    @ipsec_lifetime.setter
    def ipsec_lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipsec_lifetime", value)

    @_builtins.property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ipsec_pfs")

    @ipsec_pfs.setter
    def ipsec_pfs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipsec_pfs", value)


if not MYPY:
    class IpsecServerIkeConfigArgsDict(TypedDict):
        ike_auth_alg: NotRequired[pulumi.Input[_builtins.str]]
        """
        The authentication algorithm that is used in Phase 1 negotiations. Default value: `sha1`.
        """
        ike_enc_alg: NotRequired[pulumi.Input[_builtins.str]]
        """
        The encryption algorithm that is used in Phase 1 negotiations. Default value: `aes`.
        """
        ike_lifetime: NotRequired[pulumi.Input[_builtins.int]]
        """
        IkeLifetime: the SA lifetime determined by Phase 1 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
        """
        ike_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IKE negotiation mode. Default value: `main`.
        """
        ike_pfs: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Diffie-Hellman key exchange algorithm that is used in Phase 1 negotiations. Default value: `group2`.
        """
        ike_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IKE version. Valid values: `ikev1` and `ikev2`. Default value: `ikev2`.
        """
        local_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The identifier of the IPsec server. The value can be a fully qualified domain name (FQDN) or an IP address. The default value is the public IP address of the VPN gateway.
        """
        remote_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The identifier of the customer gateway. The value can be an FQDN or an IP address. By default, this parameter is not specified.
        """
elif False:
    IpsecServerIkeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IpsecServerIkeConfigArgs:
    def __init__(__self__, *,
                 ike_auth_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_enc_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 ike_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_pfs: Optional[pulumi.Input[_builtins.str]] = None,
                 ike_version: Optional[pulumi.Input[_builtins.str]] = None,
                 local_id: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] ike_auth_alg: The authentication algorithm that is used in Phase 1 negotiations. Default value: `sha1`.
        :param pulumi.Input[_builtins.str] ike_enc_alg: The encryption algorithm that is used in Phase 1 negotiations. Default value: `aes`.
        :param pulumi.Input[_builtins.int] ike_lifetime: IkeLifetime: the SA lifetime determined by Phase 1 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
        :param pulumi.Input[_builtins.str] ike_mode: The IKE negotiation mode. Default value: `main`.
        :param pulumi.Input[_builtins.str] ike_pfs: The Diffie-Hellman key exchange algorithm that is used in Phase 1 negotiations. Default value: `group2`.
        :param pulumi.Input[_builtins.str] ike_version: The IKE version. Valid values: `ikev1` and `ikev2`. Default value: `ikev2`.
        :param pulumi.Input[_builtins.str] local_id: The identifier of the IPsec server. The value can be a fully qualified domain name (FQDN) or an IP address. The default value is the public IP address of the VPN gateway.
        :param pulumi.Input[_builtins.str] remote_id: The identifier of the customer gateway. The value can be an FQDN or an IP address. By default, this parameter is not specified.
        """
        if ike_auth_alg is not None:
            pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        if ike_enc_alg is not None:
            pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        if ike_lifetime is not None:
            pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        if ike_mode is not None:
            pulumi.set(__self__, "ike_mode", ike_mode)
        if ike_pfs is not None:
            pulumi.set(__self__, "ike_pfs", ike_pfs)
        if ike_version is not None:
            pulumi.set(__self__, "ike_version", ike_version)
        if local_id is not None:
            pulumi.set(__self__, "local_id", local_id)
        if remote_id is not None:
            pulumi.set(__self__, "remote_id", remote_id)

    @_builtins.property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication algorithm that is used in Phase 1 negotiations. Default value: `sha1`.
        """
        return pulumi.get(self, "ike_auth_alg")

    @ike_auth_alg.setter
    def ike_auth_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_auth_alg", value)

    @_builtins.property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encryption algorithm that is used in Phase 1 negotiations. Default value: `aes`.
        """
        return pulumi.get(self, "ike_enc_alg")

    @ike_enc_alg.setter
    def ike_enc_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_enc_alg", value)

    @_builtins.property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        IkeLifetime: the SA lifetime determined by Phase 1 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
        """
        return pulumi.get(self, "ike_lifetime")

    @ike_lifetime.setter
    def ike_lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ike_lifetime", value)

    @_builtins.property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IKE negotiation mode. Default value: `main`.
        """
        return pulumi.get(self, "ike_mode")

    @ike_mode.setter
    def ike_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_mode", value)

    @_builtins.property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Diffie-Hellman key exchange algorithm that is used in Phase 1 negotiations. Default value: `group2`.
        """
        return pulumi.get(self, "ike_pfs")

    @ike_pfs.setter
    def ike_pfs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_pfs", value)

    @_builtins.property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IKE version. Valid values: `ikev1` and `ikev2`. Default value: `ikev2`.
        """
        return pulumi.get(self, "ike_version")

    @ike_version.setter
    def ike_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ike_version", value)

    @_builtins.property
    @pulumi.getter(name="localId")
    def local_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the IPsec server. The value can be a fully qualified domain name (FQDN) or an IP address. The default value is the public IP address of the VPN gateway.
        """
        return pulumi.get(self, "local_id")

    @local_id.setter
    def local_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_id", value)

    @_builtins.property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the customer gateway. The value can be an FQDN or an IP address. By default, this parameter is not specified.
        """
        return pulumi.get(self, "remote_id")

    @remote_id.setter
    def remote_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_id", value)


if not MYPY:
    class IpsecServerIpsecConfigArgsDict(TypedDict):
        ipsec_auth_alg: NotRequired[pulumi.Input[_builtins.str]]
        """
        The authentication algorithm that is used in Phase 2 negotiations. Default value: `sha1`.
        """
        ipsec_enc_alg: NotRequired[pulumi.Input[_builtins.str]]
        """
        The encryption algorithm that is used in Phase 2 negotiations. Default value: `aes`.
        """
        ipsec_lifetime: NotRequired[pulumi.Input[_builtins.int]]
        """
        The SA lifetime determined by Phase 2 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
        """
        ipsec_pfs: NotRequired[pulumi.Input[_builtins.str]]
        """
        Forwards packets of all protocols. The Diffie-Hellman key exchange algorithm used in Phase 2 negotiations. Default value: `group2`.
        """
elif False:
    IpsecServerIpsecConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IpsecServerIpsecConfigArgs:
    def __init__(__self__, *,
                 ipsec_auth_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 ipsec_enc_alg: Optional[pulumi.Input[_builtins.str]] = None,
                 ipsec_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 ipsec_pfs: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] ipsec_auth_alg: The authentication algorithm that is used in Phase 2 negotiations. Default value: `sha1`.
        :param pulumi.Input[_builtins.str] ipsec_enc_alg: The encryption algorithm that is used in Phase 2 negotiations. Default value: `aes`.
        :param pulumi.Input[_builtins.int] ipsec_lifetime: The SA lifetime determined by Phase 2 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
        :param pulumi.Input[_builtins.str] ipsec_pfs: Forwards packets of all protocols. The Diffie-Hellman key exchange algorithm used in Phase 2 negotiations. Default value: `group2`.
        """
        if ipsec_auth_alg is not None:
            pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        if ipsec_enc_alg is not None:
            pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        if ipsec_lifetime is not None:
            pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        if ipsec_pfs is not None:
            pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @_builtins.property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication algorithm that is used in Phase 2 negotiations. Default value: `sha1`.
        """
        return pulumi.get(self, "ipsec_auth_alg")

    @ipsec_auth_alg.setter
    def ipsec_auth_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipsec_auth_alg", value)

    @_builtins.property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encryption algorithm that is used in Phase 2 negotiations. Default value: `aes`.
        """
        return pulumi.get(self, "ipsec_enc_alg")

    @ipsec_enc_alg.setter
    def ipsec_enc_alg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipsec_enc_alg", value)

    @_builtins.property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The SA lifetime determined by Phase 2 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
        """
        return pulumi.get(self, "ipsec_lifetime")

    @ipsec_lifetime.setter
    def ipsec_lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipsec_lifetime", value)

    @_builtins.property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Forwards packets of all protocols. The Diffie-Hellman key exchange algorithm used in Phase 2 negotiations. Default value: `group2`.
        """
        return pulumi.get(self, "ipsec_pfs")

    @ipsec_pfs.setter
    def ipsec_pfs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipsec_pfs", value)


