# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GatewayVcoRouteArgs', 'GatewayVcoRoute']

@pulumi.input_type
class GatewayVcoRouteArgs:
    def __init__(__self__, *,
                 next_hop: pulumi.Input[_builtins.str],
                 route_dest: pulumi.Input[_builtins.str],
                 vpn_connection_id: pulumi.Input[_builtins.str],
                 weight: pulumi.Input[_builtins.int],
                 overlay_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GatewayVcoRoute resource.
        :param pulumi.Input[_builtins.str] next_hop: The next hop of the destination route.
        :param pulumi.Input[_builtins.str] route_dest: The destination network segment of the destination route.
        :param pulumi.Input[_builtins.str] vpn_connection_id: The id of the vpn attachment.
        :param pulumi.Input[_builtins.int] weight: The weight value of the destination route. Valid values: `0`, `100`.
        :param pulumi.Input[_builtins.str] overlay_mode: The tunneling protocol. Set the value to Ipsec, which specifies the IPsec tunneling protocol.
        """
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "route_dest", route_dest)
        pulumi.set(__self__, "vpn_connection_id", vpn_connection_id)
        pulumi.set(__self__, "weight", weight)
        if overlay_mode is not None:
            pulumi.set(__self__, "overlay_mode", overlay_mode)

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> pulumi.Input[_builtins.str]:
        """
        The next hop of the destination route.
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "next_hop", value)

    @_builtins.property
    @pulumi.getter(name="routeDest")
    def route_dest(self) -> pulumi.Input[_builtins.str]:
        """
        The destination network segment of the destination route.
        """
        return pulumi.get(self, "route_dest")

    @route_dest.setter
    def route_dest(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "route_dest", value)

    @_builtins.property
    @pulumi.getter(name="vpnConnectionId")
    def vpn_connection_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the vpn attachment.
        """
        return pulumi.get(self, "vpn_connection_id")

    @vpn_connection_id.setter
    def vpn_connection_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpn_connection_id", value)

    @_builtins.property
    @pulumi.getter
    def weight(self) -> pulumi.Input[_builtins.int]:
        """
        The weight value of the destination route. Valid values: `0`, `100`.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "weight", value)

    @_builtins.property
    @pulumi.getter(name="overlayMode")
    def overlay_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tunneling protocol. Set the value to Ipsec, which specifies the IPsec tunneling protocol.
        """
        return pulumi.get(self, "overlay_mode")

    @overlay_mode.setter
    def overlay_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "overlay_mode", value)


@pulumi.input_type
class _GatewayVcoRouteState:
    def __init__(__self__, *,
                 next_hop: Optional[pulumi.Input[_builtins.str]] = None,
                 overlay_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 route_dest: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 weight: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering GatewayVcoRoute resources.
        :param pulumi.Input[_builtins.str] next_hop: The next hop of the destination route.
        :param pulumi.Input[_builtins.str] overlay_mode: The tunneling protocol. Set the value to Ipsec, which specifies the IPsec tunneling protocol.
        :param pulumi.Input[_builtins.str] route_dest: The destination network segment of the destination route.
        :param pulumi.Input[_builtins.str] status: The status of the vpn route entry.
        :param pulumi.Input[_builtins.str] vpn_connection_id: The id of the vpn attachment.
        :param pulumi.Input[_builtins.int] weight: The weight value of the destination route. Valid values: `0`, `100`.
        """
        if next_hop is not None:
            pulumi.set(__self__, "next_hop", next_hop)
        if overlay_mode is not None:
            pulumi.set(__self__, "overlay_mode", overlay_mode)
        if route_dest is not None:
            pulumi.set(__self__, "route_dest", route_dest)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpn_connection_id is not None:
            pulumi.set(__self__, "vpn_connection_id", vpn_connection_id)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The next hop of the destination route.
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_hop", value)

    @_builtins.property
    @pulumi.getter(name="overlayMode")
    def overlay_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tunneling protocol. Set the value to Ipsec, which specifies the IPsec tunneling protocol.
        """
        return pulumi.get(self, "overlay_mode")

    @overlay_mode.setter
    def overlay_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "overlay_mode", value)

    @_builtins.property
    @pulumi.getter(name="routeDest")
    def route_dest(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination network segment of the destination route.
        """
        return pulumi.get(self, "route_dest")

    @route_dest.setter
    def route_dest(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_dest", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the vpn route entry.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vpnConnectionId")
    def vpn_connection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the vpn attachment.
        """
        return pulumi.get(self, "vpn_connection_id")

    @vpn_connection_id.setter
    def vpn_connection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_connection_id", value)

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The weight value of the destination route. Valid values: `0`, `100`.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "weight", value)


@pulumi.type_token("alicloud:vpn/gatewayVcoRoute:GatewayVcoRoute")
class GatewayVcoRoute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 next_hop: Optional[pulumi.Input[_builtins.str]] = None,
                 overlay_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 route_dest: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 weight: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a VPN Gateway Vco Route resource.

        For information about VPN Gateway Vco Route and how to use it, see [What is Vco Route](https://www.alibabacloud.com/help/zh/virtual-private-cloud/latest/createvcorouteentry).

        > **NOTE:** Available since v1.183.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_instance = alicloud.cen.Instance("default", cen_instance_name=name)
        default_transit_router = alicloud.cen.TransitRouter("default",
            cen_id=default_instance.id,
            transit_router_description=name,
            transit_router_name=name)
        default_transit_router_cidr = alicloud.cen.TransitRouterCidr("default",
            transit_router_id=default_transit_router.transit_router_id,
            cidr="192.168.0.0/16",
            transit_router_cidr_name=name,
            description=name,
            publish_cidr_route=True)
        default = alicloud.cen.get_transit_router_available_resources()
        default_customer_gateway = alicloud.vpn.CustomerGateway("default",
            customer_gateway_name=name,
            ip_address="42.104.22.210",
            asn="45014",
            description=name)
        default_gateway_vpn_attachment = alicloud.vpn.GatewayVpnAttachment("default",
            customer_gateway_id=default_customer_gateway.id,
            network_type="public",
            local_subnet="0.0.0.0/0",
            remote_subnet="0.0.0.0/0",
            effect_immediately=False,
            ike_config={
                "ike_auth_alg": "md5",
                "ike_enc_alg": "des",
                "ike_version": "ikev2",
                "ike_mode": "main",
                "ike_lifetime": 86400,
                "psk": "tf-examplevpn2",
                "ike_pfs": "group1",
                "remote_id": "testbob2",
                "local_id": "testalice2",
            },
            ipsec_config={
                "ipsec_pfs": "group5",
                "ipsec_enc_alg": "des",
                "ipsec_auth_alg": "md5",
                "ipsec_lifetime": 86400,
            },
            bgp_config={
                "enable": True,
                "local_asn": 45014,
                "tunnel_cidr": "169.254.11.0/30",
                "local_bgp_ip": "169.254.11.1",
            },
            health_check_config={
                "enable": True,
                "sip": "192.168.1.1",
                "dip": "10.0.0.1",
                "interval": 10,
                "retry": 10,
                "policy": "revoke_route",
            },
            enable_dpd=True,
            enable_nat_traversal=True,
            vpn_attachment_name=name)
        default_transit_router_vpn_attachment = alicloud.cen.TransitRouterVpnAttachment("default",
            auto_publish_route_enabled=False,
            transit_router_attachment_description=name,
            transit_router_attachment_name=name,
            cen_id=default_transit_router.cen_id,
            transit_router_id=default_transit_router_cidr.transit_router_id,
            vpn_id=default_gateway_vpn_attachment.id,
            zones=[{
                "zone_id": default.resources[0].master_zones[0],
            }])
        default_gateway_vco_route = alicloud.vpn.GatewayVcoRoute("default",
            next_hop=default_transit_router_vpn_attachment.vpn_id,
            vpn_connection_id=default_transit_router_vpn_attachment.vpn_id,
            weight=100,
            route_dest="192.168.10.0/24")
        ```

        ## Import

        VPN Gateway Vco Route can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpn/gatewayVcoRoute:GatewayVcoRoute example <vpn_connection_id>:<route_dest>:<next_hop>:<weight>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] next_hop: The next hop of the destination route.
        :param pulumi.Input[_builtins.str] overlay_mode: The tunneling protocol. Set the value to Ipsec, which specifies the IPsec tunneling protocol.
        :param pulumi.Input[_builtins.str] route_dest: The destination network segment of the destination route.
        :param pulumi.Input[_builtins.str] vpn_connection_id: The id of the vpn attachment.
        :param pulumi.Input[_builtins.int] weight: The weight value of the destination route. Valid values: `0`, `100`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayVcoRouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a VPN Gateway Vco Route resource.

        For information about VPN Gateway Vco Route and how to use it, see [What is Vco Route](https://www.alibabacloud.com/help/zh/virtual-private-cloud/latest/createvcorouteentry).

        > **NOTE:** Available since v1.183.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_instance = alicloud.cen.Instance("default", cen_instance_name=name)
        default_transit_router = alicloud.cen.TransitRouter("default",
            cen_id=default_instance.id,
            transit_router_description=name,
            transit_router_name=name)
        default_transit_router_cidr = alicloud.cen.TransitRouterCidr("default",
            transit_router_id=default_transit_router.transit_router_id,
            cidr="192.168.0.0/16",
            transit_router_cidr_name=name,
            description=name,
            publish_cidr_route=True)
        default = alicloud.cen.get_transit_router_available_resources()
        default_customer_gateway = alicloud.vpn.CustomerGateway("default",
            customer_gateway_name=name,
            ip_address="42.104.22.210",
            asn="45014",
            description=name)
        default_gateway_vpn_attachment = alicloud.vpn.GatewayVpnAttachment("default",
            customer_gateway_id=default_customer_gateway.id,
            network_type="public",
            local_subnet="0.0.0.0/0",
            remote_subnet="0.0.0.0/0",
            effect_immediately=False,
            ike_config={
                "ike_auth_alg": "md5",
                "ike_enc_alg": "des",
                "ike_version": "ikev2",
                "ike_mode": "main",
                "ike_lifetime": 86400,
                "psk": "tf-examplevpn2",
                "ike_pfs": "group1",
                "remote_id": "testbob2",
                "local_id": "testalice2",
            },
            ipsec_config={
                "ipsec_pfs": "group5",
                "ipsec_enc_alg": "des",
                "ipsec_auth_alg": "md5",
                "ipsec_lifetime": 86400,
            },
            bgp_config={
                "enable": True,
                "local_asn": 45014,
                "tunnel_cidr": "169.254.11.0/30",
                "local_bgp_ip": "169.254.11.1",
            },
            health_check_config={
                "enable": True,
                "sip": "192.168.1.1",
                "dip": "10.0.0.1",
                "interval": 10,
                "retry": 10,
                "policy": "revoke_route",
            },
            enable_dpd=True,
            enable_nat_traversal=True,
            vpn_attachment_name=name)
        default_transit_router_vpn_attachment = alicloud.cen.TransitRouterVpnAttachment("default",
            auto_publish_route_enabled=False,
            transit_router_attachment_description=name,
            transit_router_attachment_name=name,
            cen_id=default_transit_router.cen_id,
            transit_router_id=default_transit_router_cidr.transit_router_id,
            vpn_id=default_gateway_vpn_attachment.id,
            zones=[{
                "zone_id": default.resources[0].master_zones[0],
            }])
        default_gateway_vco_route = alicloud.vpn.GatewayVcoRoute("default",
            next_hop=default_transit_router_vpn_attachment.vpn_id,
            vpn_connection_id=default_transit_router_vpn_attachment.vpn_id,
            weight=100,
            route_dest="192.168.10.0/24")
        ```

        ## Import

        VPN Gateway Vco Route can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpn/gatewayVcoRoute:GatewayVcoRoute example <vpn_connection_id>:<route_dest>:<next_hop>:<weight>
        ```

        :param str resource_name: The name of the resource.
        :param GatewayVcoRouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayVcoRouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 next_hop: Optional[pulumi.Input[_builtins.str]] = None,
                 overlay_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 route_dest: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 weight: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayVcoRouteArgs.__new__(GatewayVcoRouteArgs)

            if next_hop is None and not opts.urn:
                raise TypeError("Missing required property 'next_hop'")
            __props__.__dict__["next_hop"] = next_hop
            __props__.__dict__["overlay_mode"] = overlay_mode
            if route_dest is None and not opts.urn:
                raise TypeError("Missing required property 'route_dest'")
            __props__.__dict__["route_dest"] = route_dest
            if vpn_connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpn_connection_id'")
            __props__.__dict__["vpn_connection_id"] = vpn_connection_id
            if weight is None and not opts.urn:
                raise TypeError("Missing required property 'weight'")
            __props__.__dict__["weight"] = weight
            __props__.__dict__["status"] = None
        super(GatewayVcoRoute, __self__).__init__(
            'alicloud:vpn/gatewayVcoRoute:GatewayVcoRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            next_hop: Optional[pulumi.Input[_builtins.str]] = None,
            overlay_mode: Optional[pulumi.Input[_builtins.str]] = None,
            route_dest: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vpn_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
            weight: Optional[pulumi.Input[_builtins.int]] = None) -> 'GatewayVcoRoute':
        """
        Get an existing GatewayVcoRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] next_hop: The next hop of the destination route.
        :param pulumi.Input[_builtins.str] overlay_mode: The tunneling protocol. Set the value to Ipsec, which specifies the IPsec tunneling protocol.
        :param pulumi.Input[_builtins.str] route_dest: The destination network segment of the destination route.
        :param pulumi.Input[_builtins.str] status: The status of the vpn route entry.
        :param pulumi.Input[_builtins.str] vpn_connection_id: The id of the vpn attachment.
        :param pulumi.Input[_builtins.int] weight: The weight value of the destination route. Valid values: `0`, `100`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayVcoRouteState.__new__(_GatewayVcoRouteState)

        __props__.__dict__["next_hop"] = next_hop
        __props__.__dict__["overlay_mode"] = overlay_mode
        __props__.__dict__["route_dest"] = route_dest
        __props__.__dict__["status"] = status
        __props__.__dict__["vpn_connection_id"] = vpn_connection_id
        __props__.__dict__["weight"] = weight
        return GatewayVcoRoute(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> pulumi.Output[_builtins.str]:
        """
        The next hop of the destination route.
        """
        return pulumi.get(self, "next_hop")

    @_builtins.property
    @pulumi.getter(name="overlayMode")
    def overlay_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The tunneling protocol. Set the value to Ipsec, which specifies the IPsec tunneling protocol.
        """
        return pulumi.get(self, "overlay_mode")

    @_builtins.property
    @pulumi.getter(name="routeDest")
    def route_dest(self) -> pulumi.Output[_builtins.str]:
        """
        The destination network segment of the destination route.
        """
        return pulumi.get(self, "route_dest")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the vpn route entry.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpnConnectionId")
    def vpn_connection_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the vpn attachment.
        """
        return pulumi.get(self, "vpn_connection_id")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> pulumi.Output[_builtins.int]:
        """
        The weight value of the destination route. Valid values: `0`, `100`.
        """
        return pulumi.get(self, "weight")

