# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DomainListenArgs',
    'DomainListenArgsDict',
    'DomainRedirectArgs',
    'DomainRedirectArgsDict',
    'DomainRedirectRequestHeaderArgs',
    'DomainRedirectRequestHeaderArgsDict',
]

MYPY = False

if not MYPY:
    class DomainListenArgsDict(TypedDict):
        cert_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the certificate to be added. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        cipher_suite: NotRequired[pulumi.Input[_builtins.int]]
        """
        The type of encryption suite to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        - **1**: indicates that all encryption suites are added.
        - **2**: indicates that a strong encryption package is added. You can select this value only if the value of **tls_version** is `tlsv1.2`.
        - **99**: indicates that a custom encryption suite is added.
        """
        custom_ciphers: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The specific custom encryption suite to add.
        """
        enable_tlsv3: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether TSL1.3 version is supported. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        - **true**: indicates that TSL1.3 is supported.
        - **false**: indicates that TSL1.3 is not supported.
        """
        exclusive_ip: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable exclusive IP address. This parameter is used only when the value of **ipv6_enabled** is **false** (indicating that IPv6 is not enabled) and the value of **protection_resource** is **share** (indicating that a shared cluster is used). Value:
        - **true**: indicates that the exclusive IP address is enabled.
        - **false** (default): indicates that exclusive IP address is not enabled.
        """
        focus_https: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable the forced jump of HTTPS. This parameter is used only when the value of `https_ports` is not empty (indicating that the domain name uses HTTPS protocol) and the value of httports is empty (indicating that the domain name does not use HTTP protocol). Value:
        - **true**: indicates that HTTPS forced redirection is enabled.
        - **false**: indicates that HTTPS forced redirection is not enabled.
        """
        http2_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to turn on http2. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        - **true:** indicates that HTTP2 is enabled.
        - **false** (default): indicates that HTTP2 is not enabled.
        """
        http_ports: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]
        """
        The listening port of the HTTP protocol.
        """
        https_ports: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]
        """
        The listening port of the HTTPS protocol.
        """
        ipv6_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether IPv6 is turned on. Value:
        - **true**: indicates that IPv6 is enabled.
        - **false** (default): indicates that IPv6 is not enabled.
        """
        protection_resource: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of protection resource to use. Value:
        - **share** (default): indicates that a shared cluster is used.
        - **gslb**: indicates that the shared cluster intelligent load balancing is used.
        """
        tls_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        The version of TLS to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value: **tlsv1**, **tlsv1.1**, **tlsv1.2**.
        """
        xff_header_mode: NotRequired[pulumi.Input[_builtins.int]]
        """
        WAF obtains the real IP address of the client. Value:
        - **0** (default): indicates that the client has not forwarded the traffic to WAF through other layer -7 agents.
        - **1**: indicates that the first value of the X-Forwarded-For(XFF) field in the WAF read request header is used as the client IP address.
        - **2**: indicates that the custom field value set by you in the WAF read request header is used as the client IP address.
        """
        xff_headers: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Set the list of custom fields used to obtain the client IP address.
        """
elif False:
    DomainListenArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainListenArgs:
    def __init__(__self__, *,
                 cert_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cipher_suite: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_tlsv3: Optional[pulumi.Input[_builtins.bool]] = None,
                 exclusive_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 focus_https: Optional[pulumi.Input[_builtins.bool]] = None,
                 http2_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 http_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 https_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 ipv6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 protection_resource: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 xff_header_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 xff_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] cert_id: The ID of the certificate to be added. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param pulumi.Input[_builtins.int] cipher_suite: The type of encryption suite to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
               - **1**: indicates that all encryption suites are added.
               - **2**: indicates that a strong encryption package is added. You can select this value only if the value of **tls_version** is `tlsv1.2`.
               - **99**: indicates that a custom encryption suite is added.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_ciphers: The specific custom encryption suite to add.
        :param pulumi.Input[_builtins.bool] enable_tlsv3: Whether TSL1.3 version is supported. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
               - **true**: indicates that TSL1.3 is supported.
               - **false**: indicates that TSL1.3 is not supported.
        :param pulumi.Input[_builtins.bool] exclusive_ip: Whether to enable exclusive IP address. This parameter is used only when the value of **ipv6_enabled** is **false** (indicating that IPv6 is not enabled) and the value of **protection_resource** is **share** (indicating that a shared cluster is used). Value:
               - **true**: indicates that the exclusive IP address is enabled.
               - **false** (default): indicates that exclusive IP address is not enabled.
        :param pulumi.Input[_builtins.bool] focus_https: Whether to enable the forced jump of HTTPS. This parameter is used only when the value of `https_ports` is not empty (indicating that the domain name uses HTTPS protocol) and the value of httports is empty (indicating that the domain name does not use HTTP protocol). Value:
               - **true**: indicates that HTTPS forced redirection is enabled.
               - **false**: indicates that HTTPS forced redirection is not enabled.
        :param pulumi.Input[_builtins.bool] http2_enabled: Whether to turn on http2. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
               - **true:** indicates that HTTP2 is enabled.
               - **false** (default): indicates that HTTP2 is not enabled.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] http_ports: The listening port of the HTTP protocol.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] https_ports: The listening port of the HTTPS protocol.
        :param pulumi.Input[_builtins.bool] ipv6_enabled: Whether IPv6 is turned on. Value:
               - **true**: indicates that IPv6 is enabled.
               - **false** (default): indicates that IPv6 is not enabled.
        :param pulumi.Input[_builtins.str] protection_resource: The type of protection resource to use. Value:
               - **share** (default): indicates that a shared cluster is used.
               - **gslb**: indicates that the shared cluster intelligent load balancing is used.
        :param pulumi.Input[_builtins.str] tls_version: The version of TLS to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value: **tlsv1**, **tlsv1.1**, **tlsv1.2**.
        :param pulumi.Input[_builtins.int] xff_header_mode: WAF obtains the real IP address of the client. Value:
               - **0** (default): indicates that the client has not forwarded the traffic to WAF through other layer -7 agents.
               - **1**: indicates that the first value of the X-Forwarded-For(XFF) field in the WAF read request header is used as the client IP address.
               - **2**: indicates that the custom field value set by you in the WAF read request header is used as the client IP address.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] xff_headers: Set the list of custom fields used to obtain the client IP address.
        """
        if cert_id is not None:
            pulumi.set(__self__, "cert_id", cert_id)
        if cipher_suite is not None:
            pulumi.set(__self__, "cipher_suite", cipher_suite)
        if custom_ciphers is not None:
            pulumi.set(__self__, "custom_ciphers", custom_ciphers)
        if enable_tlsv3 is not None:
            pulumi.set(__self__, "enable_tlsv3", enable_tlsv3)
        if exclusive_ip is not None:
            pulumi.set(__self__, "exclusive_ip", exclusive_ip)
        if focus_https is not None:
            pulumi.set(__self__, "focus_https", focus_https)
        if http2_enabled is not None:
            pulumi.set(__self__, "http2_enabled", http2_enabled)
        if http_ports is not None:
            pulumi.set(__self__, "http_ports", http_ports)
        if https_ports is not None:
            pulumi.set(__self__, "https_ports", https_ports)
        if ipv6_enabled is not None:
            pulumi.set(__self__, "ipv6_enabled", ipv6_enabled)
        if protection_resource is not None:
            pulumi.set(__self__, "protection_resource", protection_resource)
        if tls_version is not None:
            pulumi.set(__self__, "tls_version", tls_version)
        if xff_header_mode is not None:
            pulumi.set(__self__, "xff_header_mode", xff_header_mode)
        if xff_headers is not None:
            pulumi.set(__self__, "xff_headers", xff_headers)

    @_builtins.property
    @pulumi.getter(name="certId")
    def cert_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the certificate to be added. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "cert_id")

    @cert_id.setter
    def cert_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_id", value)

    @_builtins.property
    @pulumi.getter(name="cipherSuite")
    def cipher_suite(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The type of encryption suite to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        - **1**: indicates that all encryption suites are added.
        - **2**: indicates that a strong encryption package is added. You can select this value only if the value of **tls_version** is `tlsv1.2`.
        - **99**: indicates that a custom encryption suite is added.
        """
        return pulumi.get(self, "cipher_suite")

    @cipher_suite.setter
    def cipher_suite(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cipher_suite", value)

    @_builtins.property
    @pulumi.getter(name="customCiphers")
    def custom_ciphers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The specific custom encryption suite to add.
        """
        return pulumi.get(self, "custom_ciphers")

    @custom_ciphers.setter
    def custom_ciphers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_ciphers", value)

    @_builtins.property
    @pulumi.getter(name="enableTlsv3")
    def enable_tlsv3(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether TSL1.3 version is supported. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        - **true**: indicates that TSL1.3 is supported.
        - **false**: indicates that TSL1.3 is not supported.
        """
        return pulumi.get(self, "enable_tlsv3")

    @enable_tlsv3.setter
    def enable_tlsv3(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_tlsv3", value)

    @_builtins.property
    @pulumi.getter(name="exclusiveIp")
    def exclusive_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable exclusive IP address. This parameter is used only when the value of **ipv6_enabled** is **false** (indicating that IPv6 is not enabled) and the value of **protection_resource** is **share** (indicating that a shared cluster is used). Value:
        - **true**: indicates that the exclusive IP address is enabled.
        - **false** (default): indicates that exclusive IP address is not enabled.
        """
        return pulumi.get(self, "exclusive_ip")

    @exclusive_ip.setter
    def exclusive_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclusive_ip", value)

    @_builtins.property
    @pulumi.getter(name="focusHttps")
    def focus_https(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the forced jump of HTTPS. This parameter is used only when the value of `https_ports` is not empty (indicating that the domain name uses HTTPS protocol) and the value of httports is empty (indicating that the domain name does not use HTTP protocol). Value:
        - **true**: indicates that HTTPS forced redirection is enabled.
        - **false**: indicates that HTTPS forced redirection is not enabled.
        """
        return pulumi.get(self, "focus_https")

    @focus_https.setter
    def focus_https(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "focus_https", value)

    @_builtins.property
    @pulumi.getter(name="http2Enabled")
    def http2_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to turn on http2. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        - **true:** indicates that HTTP2 is enabled.
        - **false** (default): indicates that HTTP2 is not enabled.
        """
        return pulumi.get(self, "http2_enabled")

    @http2_enabled.setter
    def http2_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "http2_enabled", value)

    @_builtins.property
    @pulumi.getter(name="httpPorts")
    def http_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        The listening port of the HTTP protocol.
        """
        return pulumi.get(self, "http_ports")

    @http_ports.setter
    def http_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "http_ports", value)

    @_builtins.property
    @pulumi.getter(name="httpsPorts")
    def https_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        The listening port of the HTTPS protocol.
        """
        return pulumi.get(self, "https_ports")

    @https_ports.setter
    def https_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "https_ports", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether IPv6 is turned on. Value:
        - **true**: indicates that IPv6 is enabled.
        - **false** (default): indicates that IPv6 is not enabled.
        """
        return pulumi.get(self, "ipv6_enabled")

    @ipv6_enabled.setter
    def ipv6_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_enabled", value)

    @_builtins.property
    @pulumi.getter(name="protectionResource")
    def protection_resource(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of protection resource to use. Value:
        - **share** (default): indicates that a shared cluster is used.
        - **gslb**: indicates that the shared cluster intelligent load balancing is used.
        """
        return pulumi.get(self, "protection_resource")

    @protection_resource.setter
    def protection_resource(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_resource", value)

    @_builtins.property
    @pulumi.getter(name="tlsVersion")
    def tls_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of TLS to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value: **tlsv1**, **tlsv1.1**, **tlsv1.2**.
        """
        return pulumi.get(self, "tls_version")

    @tls_version.setter
    def tls_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_version", value)

    @_builtins.property
    @pulumi.getter(name="xffHeaderMode")
    def xff_header_mode(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        WAF obtains the real IP address of the client. Value:
        - **0** (default): indicates that the client has not forwarded the traffic to WAF through other layer -7 agents.
        - **1**: indicates that the first value of the X-Forwarded-For(XFF) field in the WAF read request header is used as the client IP address.
        - **2**: indicates that the custom field value set by you in the WAF read request header is used as the client IP address.
        """
        return pulumi.get(self, "xff_header_mode")

    @xff_header_mode.setter
    def xff_header_mode(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "xff_header_mode", value)

    @_builtins.property
    @pulumi.getter(name="xffHeaders")
    def xff_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set the list of custom fields used to obtain the client IP address.
        """
        return pulumi.get(self, "xff_headers")

    @xff_headers.setter
    def xff_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "xff_headers", value)


if not MYPY:
    class DomainRedirectArgsDict(TypedDict):
        loadbalance: pulumi.Input[_builtins.str]
        """
        The load balancing algorithm used when returning to the source. Value:
        - **iphash**: indicates the IPHash algorithm.
        - **roundRobin**: indicates the polling algorithm.
        - **leastTime**: indicates the Least Time algorithm.
        - This value can be selected only if the value of **protection_resource** is **gslb** (indicating that the protected resource type uses shared cluster intelligent load balancing).
        """
        backends: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The IP address of the origin server corresponding to the domain name or the back-to-origin domain name of the server.
        """
        connect_timeout: NotRequired[pulumi.Input[_builtins.int]]
        """
        Connection timeout. Unit: seconds, value range: 5~120.
        """
        focus_http_backend: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable forced HTTP back-to-origin. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        - **true**: indicates that forced HTTP back-to-origin is enabled.
        - **false**: indicates that forced HTTP back-to-origin is not enabled.
        """
        keepalive: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Open long connection, default true.
        """
        keepalive_requests: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of long connections,  default: `60`. range :60-1000.
        """
        keepalive_timeout: NotRequired[pulumi.Input[_builtins.int]]
        """
        Long connection over time, default: `15`. Range: 1-60.
        """
        read_timeout: NotRequired[pulumi.Input[_builtins.int]]
        """
        Read timeout duration. **Unit**: seconds, **Value range**: 5~1800.
        """
        request_headers: NotRequired[pulumi.Input[Sequence[pulumi.Input['DomainRedirectRequestHeaderArgsDict']]]]
        """
        The traffic tag field and value of the domain name which used to mark the traffic processed by WAF. 
        It formats as `[{" k ":"_key_"," v ":"_value_"}]`. Where the `k` represents the specified custom request header field,
        and the `v` represents the value set for this field. By specifying the custom request header field and the corresponding value,
        when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value
        to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the
        custom header field already exists in the request, the system will overwrite the value of the custom field in the
        request with the set traffic tag value. See `request_headers` below.
        """
        retry: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Back to Source Retry. default: true, retry 3 times by default.
        """
        sni_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable back-to-source SNI. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        - **true**: indicates that the back-to-source SNI is enabled.
        - **false** (default) indicates that the back-to-source SNI is not enabled.
        """
        sni_host: NotRequired[pulumi.Input[_builtins.str]]
        """
        Sets the value of the custom SNI extension field. If this parameter is not set, the value of the **Host** field in the request header is used as the value of the SNI extension field by default.In general, you do not need to customize SNI unless your business has special configuration requirements. You want WAF to use SNI that is inconsistent with the actual request Host in the back-to-origin request (that is, the custom SNI set here).> This parameter is required only when **sni_enalbed** is set to **true** (indicating that back-to-source SNI is enabled).
        """
        write_timeout: NotRequired[pulumi.Input[_builtins.int]]
        """
        Write timeout duration> **Unit**: seconds, **Value range**: 5~1800.
        """
elif False:
    DomainRedirectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainRedirectArgs:
    def __init__(__self__, *,
                 loadbalance: pulumi.Input[_builtins.str],
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 connect_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 focus_http_backend: Optional[pulumi.Input[_builtins.bool]] = None,
                 keepalive: Optional[pulumi.Input[_builtins.bool]] = None,
                 keepalive_requests: Optional[pulumi.Input[_builtins.int]] = None,
                 keepalive_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 read_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 request_headers: Optional[pulumi.Input[Sequence[pulumi.Input['DomainRedirectRequestHeaderArgs']]]] = None,
                 retry: Optional[pulumi.Input[_builtins.bool]] = None,
                 sni_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sni_host: Optional[pulumi.Input[_builtins.str]] = None,
                 write_timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] loadbalance: The load balancing algorithm used when returning to the source. Value:
               - **iphash**: indicates the IPHash algorithm.
               - **roundRobin**: indicates the polling algorithm.
               - **leastTime**: indicates the Least Time algorithm.
               - This value can be selected only if the value of **protection_resource** is **gslb** (indicating that the protected resource type uses shared cluster intelligent load balancing).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] backends: The IP address of the origin server corresponding to the domain name or the back-to-origin domain name of the server.
        :param pulumi.Input[_builtins.int] connect_timeout: Connection timeout. Unit: seconds, value range: 5~120.
        :param pulumi.Input[_builtins.bool] focus_http_backend: Whether to enable forced HTTP back-to-origin. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
               - **true**: indicates that forced HTTP back-to-origin is enabled.
               - **false**: indicates that forced HTTP back-to-origin is not enabled.
        :param pulumi.Input[_builtins.bool] keepalive: Open long connection, default true.
        :param pulumi.Input[_builtins.int] keepalive_requests: Number of long connections,  default: `60`. range :60-1000.
        :param pulumi.Input[_builtins.int] keepalive_timeout: Long connection over time, default: `15`. Range: 1-60.
        :param pulumi.Input[_builtins.int] read_timeout: Read timeout duration. **Unit**: seconds, **Value range**: 5~1800.
        :param pulumi.Input[Sequence[pulumi.Input['DomainRedirectRequestHeaderArgs']]] request_headers: The traffic tag field and value of the domain name which used to mark the traffic processed by WAF. 
               It formats as `[{" k ":"_key_"," v ":"_value_"}]`. Where the `k` represents the specified custom request header field,
               and the `v` represents the value set for this field. By specifying the custom request header field and the corresponding value,
               when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value
               to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the
               custom header field already exists in the request, the system will overwrite the value of the custom field in the
               request with the set traffic tag value. See `request_headers` below.
        :param pulumi.Input[_builtins.bool] retry: Back to Source Retry. default: true, retry 3 times by default.
        :param pulumi.Input[_builtins.bool] sni_enabled: Whether to enable back-to-source SNI. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
               - **true**: indicates that the back-to-source SNI is enabled.
               - **false** (default) indicates that the back-to-source SNI is not enabled.
        :param pulumi.Input[_builtins.str] sni_host: Sets the value of the custom SNI extension field. If this parameter is not set, the value of the **Host** field in the request header is used as the value of the SNI extension field by default.In general, you do not need to customize SNI unless your business has special configuration requirements. You want WAF to use SNI that is inconsistent with the actual request Host in the back-to-origin request (that is, the custom SNI set here).> This parameter is required only when **sni_enalbed** is set to **true** (indicating that back-to-source SNI is enabled).
        :param pulumi.Input[_builtins.int] write_timeout: Write timeout duration> **Unit**: seconds, **Value range**: 5~1800.
        """
        pulumi.set(__self__, "loadbalance", loadbalance)
        if backends is not None:
            pulumi.set(__self__, "backends", backends)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if focus_http_backend is not None:
            pulumi.set(__self__, "focus_http_backend", focus_http_backend)
        if keepalive is not None:
            pulumi.set(__self__, "keepalive", keepalive)
        if keepalive_requests is not None:
            pulumi.set(__self__, "keepalive_requests", keepalive_requests)
        if keepalive_timeout is not None:
            pulumi.set(__self__, "keepalive_timeout", keepalive_timeout)
        if read_timeout is not None:
            pulumi.set(__self__, "read_timeout", read_timeout)
        if request_headers is not None:
            pulumi.set(__self__, "request_headers", request_headers)
        if retry is not None:
            pulumi.set(__self__, "retry", retry)
        if sni_enabled is not None:
            pulumi.set(__self__, "sni_enabled", sni_enabled)
        if sni_host is not None:
            pulumi.set(__self__, "sni_host", sni_host)
        if write_timeout is not None:
            pulumi.set(__self__, "write_timeout", write_timeout)

    @_builtins.property
    @pulumi.getter
    def loadbalance(self) -> pulumi.Input[_builtins.str]:
        """
        The load balancing algorithm used when returning to the source. Value:
        - **iphash**: indicates the IPHash algorithm.
        - **roundRobin**: indicates the polling algorithm.
        - **leastTime**: indicates the Least Time algorithm.
        - This value can be selected only if the value of **protection_resource** is **gslb** (indicating that the protected resource type uses shared cluster intelligent load balancing).
        """
        return pulumi.get(self, "loadbalance")

    @loadbalance.setter
    def loadbalance(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "loadbalance", value)

    @_builtins.property
    @pulumi.getter
    def backends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IP address of the origin server corresponding to the domain name or the back-to-origin domain name of the server.
        """
        return pulumi.get(self, "backends")

    @backends.setter
    def backends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "backends", value)

    @_builtins.property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Connection timeout. Unit: seconds, value range: 5~120.
        """
        return pulumi.get(self, "connect_timeout")

    @connect_timeout.setter
    def connect_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connect_timeout", value)

    @_builtins.property
    @pulumi.getter(name="focusHttpBackend")
    def focus_http_backend(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable forced HTTP back-to-origin. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        - **true**: indicates that forced HTTP back-to-origin is enabled.
        - **false**: indicates that forced HTTP back-to-origin is not enabled.
        """
        return pulumi.get(self, "focus_http_backend")

    @focus_http_backend.setter
    def focus_http_backend(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "focus_http_backend", value)

    @_builtins.property
    @pulumi.getter
    def keepalive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Open long connection, default true.
        """
        return pulumi.get(self, "keepalive")

    @keepalive.setter
    def keepalive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "keepalive", value)

    @_builtins.property
    @pulumi.getter(name="keepaliveRequests")
    def keepalive_requests(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of long connections,  default: `60`. range :60-1000.
        """
        return pulumi.get(self, "keepalive_requests")

    @keepalive_requests.setter
    def keepalive_requests(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "keepalive_requests", value)

    @_builtins.property
    @pulumi.getter(name="keepaliveTimeout")
    def keepalive_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Long connection over time, default: `15`. Range: 1-60.
        """
        return pulumi.get(self, "keepalive_timeout")

    @keepalive_timeout.setter
    def keepalive_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "keepalive_timeout", value)

    @_builtins.property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Read timeout duration. **Unit**: seconds, **Value range**: 5~1800.
        """
        return pulumi.get(self, "read_timeout")

    @read_timeout.setter
    def read_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_timeout", value)

    @_builtins.property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainRedirectRequestHeaderArgs']]]]:
        """
        The traffic tag field and value of the domain name which used to mark the traffic processed by WAF. 
        It formats as `[{" k ":"_key_"," v ":"_value_"}]`. Where the `k` represents the specified custom request header field,
        and the `v` represents the value set for this field. By specifying the custom request header field and the corresponding value,
        when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value
        to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the
        custom header field already exists in the request, the system will overwrite the value of the custom field in the
        request with the set traffic tag value. See `request_headers` below.
        """
        return pulumi.get(self, "request_headers")

    @request_headers.setter
    def request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainRedirectRequestHeaderArgs']]]]):
        pulumi.set(self, "request_headers", value)

    @_builtins.property
    @pulumi.getter
    def retry(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Back to Source Retry. default: true, retry 3 times by default.
        """
        return pulumi.get(self, "retry")

    @retry.setter
    def retry(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "retry", value)

    @_builtins.property
    @pulumi.getter(name="sniEnabled")
    def sni_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable back-to-source SNI. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        - **true**: indicates that the back-to-source SNI is enabled.
        - **false** (default) indicates that the back-to-source SNI is not enabled.
        """
        return pulumi.get(self, "sni_enabled")

    @sni_enabled.setter
    def sni_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sni_enabled", value)

    @_builtins.property
    @pulumi.getter(name="sniHost")
    def sni_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the value of the custom SNI extension field. If this parameter is not set, the value of the **Host** field in the request header is used as the value of the SNI extension field by default.In general, you do not need to customize SNI unless your business has special configuration requirements. You want WAF to use SNI that is inconsistent with the actual request Host in the back-to-origin request (that is, the custom SNI set here).> This parameter is required only when **sni_enalbed** is set to **true** (indicating that back-to-source SNI is enabled).
        """
        return pulumi.get(self, "sni_host")

    @sni_host.setter
    def sni_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sni_host", value)

    @_builtins.property
    @pulumi.getter(name="writeTimeout")
    def write_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Write timeout duration> **Unit**: seconds, **Value range**: 5~1800.
        """
        return pulumi.get(self, "write_timeout")

    @write_timeout.setter
    def write_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "write_timeout", value)


if not MYPY:
    class DomainRedirectRequestHeaderArgsDict(TypedDict):
        key: NotRequired[pulumi.Input[_builtins.str]]
        """
        The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
elif False:
    DomainRedirectRequestHeaderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainRedirectRequestHeaderArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] key: The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        :param pulumi.Input[_builtins.str] value: The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


