# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DomainListen',
    'DomainRedirect',
    'DomainRedirectRequestHeader',
    'GetDomainsDomainResult',
    'GetDomainsDomainListenResult',
    'GetDomainsDomainRedirectResult',
    'GetDomainsDomainRedirectRequestHeaderResult',
    'GetInstancesInstanceResult',
]

@pulumi.output_type
class DomainListen(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certId":
            suggest = "cert_id"
        elif key == "cipherSuite":
            suggest = "cipher_suite"
        elif key == "customCiphers":
            suggest = "custom_ciphers"
        elif key == "enableTlsv3":
            suggest = "enable_tlsv3"
        elif key == "exclusiveIp":
            suggest = "exclusive_ip"
        elif key == "focusHttps":
            suggest = "focus_https"
        elif key == "http2Enabled":
            suggest = "http2_enabled"
        elif key == "httpPorts":
            suggest = "http_ports"
        elif key == "httpsPorts":
            suggest = "https_ports"
        elif key == "ipv6Enabled":
            suggest = "ipv6_enabled"
        elif key == "protectionResource":
            suggest = "protection_resource"
        elif key == "tlsVersion":
            suggest = "tls_version"
        elif key == "xffHeaderMode":
            suggest = "xff_header_mode"
        elif key == "xffHeaders":
            suggest = "xff_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainListen. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainListen.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainListen.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_id: Optional[_builtins.str] = None,
                 cipher_suite: Optional[_builtins.int] = None,
                 custom_ciphers: Optional[Sequence[_builtins.str]] = None,
                 enable_tlsv3: Optional[_builtins.bool] = None,
                 exclusive_ip: Optional[_builtins.bool] = None,
                 focus_https: Optional[_builtins.bool] = None,
                 http2_enabled: Optional[_builtins.bool] = None,
                 http_ports: Optional[Sequence[_builtins.int]] = None,
                 https_ports: Optional[Sequence[_builtins.int]] = None,
                 ipv6_enabled: Optional[_builtins.bool] = None,
                 protection_resource: Optional[_builtins.str] = None,
                 tls_version: Optional[_builtins.str] = None,
                 xff_header_mode: Optional[_builtins.int] = None,
                 xff_headers: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str cert_id: The ID of the certificate to be added. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param _builtins.int cipher_suite: The type of encryption suite to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
               - **1**: indicates that all encryption suites are added.
               - **2**: indicates that a strong encryption package is added. You can select this value only if the value of **tls_version** is `tlsv1.2`.
               - **99**: indicates that a custom encryption suite is added.
        :param Sequence[_builtins.str] custom_ciphers: The specific custom encryption suite to add.
        :param _builtins.bool enable_tlsv3: Whether TSL1.3 version is supported. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
               - **true**: indicates that TSL1.3 is supported.
               - **false**: indicates that TSL1.3 is not supported.
        :param _builtins.bool exclusive_ip: Whether to enable exclusive IP address. This parameter is used only when the value of **ipv6_enabled** is **false** (indicating that IPv6 is not enabled) and the value of **protection_resource** is **share** (indicating that a shared cluster is used). Value:
               - **true**: indicates that the exclusive IP address is enabled.
               - **false** (default): indicates that exclusive IP address is not enabled.
        :param _builtins.bool focus_https: Whether to enable the forced jump of HTTPS. This parameter is used only when the value of `https_ports` is not empty (indicating that the domain name uses HTTPS protocol) and the value of httports is empty (indicating that the domain name does not use HTTP protocol). Value:
               - **true**: indicates that HTTPS forced redirection is enabled.
               - **false**: indicates that HTTPS forced redirection is not enabled.
        :param _builtins.bool http2_enabled: Whether to turn on http2. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
               - **true:** indicates that HTTP2 is enabled.
               - **false** (default): indicates that HTTP2 is not enabled.
        :param Sequence[_builtins.int] http_ports: The listening port of the HTTP protocol.
        :param Sequence[_builtins.int] https_ports: The listening port of the HTTPS protocol.
        :param _builtins.bool ipv6_enabled: Whether IPv6 is turned on. Value:
               - **true**: indicates that IPv6 is enabled.
               - **false** (default): indicates that IPv6 is not enabled.
        :param _builtins.str protection_resource: The type of protection resource to use. Value:
               - **share** (default): indicates that a shared cluster is used.
               - **gslb**: indicates that the shared cluster intelligent load balancing is used.
        :param _builtins.str tls_version: The version of TLS to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value: **tlsv1**, **tlsv1.1**, **tlsv1.2**.
        :param _builtins.int xff_header_mode: WAF obtains the real IP address of the client. Value:
               - **0** (default): indicates that the client has not forwarded the traffic to WAF through other layer -7 agents.
               - **1**: indicates that the first value of the X-Forwarded-For(XFF) field in the WAF read request header is used as the client IP address.
               - **2**: indicates that the custom field value set by you in the WAF read request header is used as the client IP address.
        :param Sequence[_builtins.str] xff_headers: Set the list of custom fields used to obtain the client IP address.
        """
        if cert_id is not None:
            pulumi.set(__self__, "cert_id", cert_id)
        if cipher_suite is not None:
            pulumi.set(__self__, "cipher_suite", cipher_suite)
        if custom_ciphers is not None:
            pulumi.set(__self__, "custom_ciphers", custom_ciphers)
        if enable_tlsv3 is not None:
            pulumi.set(__self__, "enable_tlsv3", enable_tlsv3)
        if exclusive_ip is not None:
            pulumi.set(__self__, "exclusive_ip", exclusive_ip)
        if focus_https is not None:
            pulumi.set(__self__, "focus_https", focus_https)
        if http2_enabled is not None:
            pulumi.set(__self__, "http2_enabled", http2_enabled)
        if http_ports is not None:
            pulumi.set(__self__, "http_ports", http_ports)
        if https_ports is not None:
            pulumi.set(__self__, "https_ports", https_ports)
        if ipv6_enabled is not None:
            pulumi.set(__self__, "ipv6_enabled", ipv6_enabled)
        if protection_resource is not None:
            pulumi.set(__self__, "protection_resource", protection_resource)
        if tls_version is not None:
            pulumi.set(__self__, "tls_version", tls_version)
        if xff_header_mode is not None:
            pulumi.set(__self__, "xff_header_mode", xff_header_mode)
        if xff_headers is not None:
            pulumi.set(__self__, "xff_headers", xff_headers)

    @_builtins.property
    @pulumi.getter(name="certId")
    def cert_id(self) -> Optional[_builtins.str]:
        """
        The ID of the certificate to be added. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "cert_id")

    @_builtins.property
    @pulumi.getter(name="cipherSuite")
    def cipher_suite(self) -> Optional[_builtins.int]:
        """
        The type of encryption suite to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        - **1**: indicates that all encryption suites are added.
        - **2**: indicates that a strong encryption package is added. You can select this value only if the value of **tls_version** is `tlsv1.2`.
        - **99**: indicates that a custom encryption suite is added.
        """
        return pulumi.get(self, "cipher_suite")

    @_builtins.property
    @pulumi.getter(name="customCiphers")
    def custom_ciphers(self) -> Optional[Sequence[_builtins.str]]:
        """
        The specific custom encryption suite to add.
        """
        return pulumi.get(self, "custom_ciphers")

    @_builtins.property
    @pulumi.getter(name="enableTlsv3")
    def enable_tlsv3(self) -> Optional[_builtins.bool]:
        """
        Whether TSL1.3 version is supported. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        - **true**: indicates that TSL1.3 is supported.
        - **false**: indicates that TSL1.3 is not supported.
        """
        return pulumi.get(self, "enable_tlsv3")

    @_builtins.property
    @pulumi.getter(name="exclusiveIp")
    def exclusive_ip(self) -> Optional[_builtins.bool]:
        """
        Whether to enable exclusive IP address. This parameter is used only when the value of **ipv6_enabled** is **false** (indicating that IPv6 is not enabled) and the value of **protection_resource** is **share** (indicating that a shared cluster is used). Value:
        - **true**: indicates that the exclusive IP address is enabled.
        - **false** (default): indicates that exclusive IP address is not enabled.
        """
        return pulumi.get(self, "exclusive_ip")

    @_builtins.property
    @pulumi.getter(name="focusHttps")
    def focus_https(self) -> Optional[_builtins.bool]:
        """
        Whether to enable the forced jump of HTTPS. This parameter is used only when the value of `https_ports` is not empty (indicating that the domain name uses HTTPS protocol) and the value of httports is empty (indicating that the domain name does not use HTTP protocol). Value:
        - **true**: indicates that HTTPS forced redirection is enabled.
        - **false**: indicates that HTTPS forced redirection is not enabled.
        """
        return pulumi.get(self, "focus_https")

    @_builtins.property
    @pulumi.getter(name="http2Enabled")
    def http2_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to turn on http2. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        - **true:** indicates that HTTP2 is enabled.
        - **false** (default): indicates that HTTP2 is not enabled.
        """
        return pulumi.get(self, "http2_enabled")

    @_builtins.property
    @pulumi.getter(name="httpPorts")
    def http_ports(self) -> Optional[Sequence[_builtins.int]]:
        """
        The listening port of the HTTP protocol.
        """
        return pulumi.get(self, "http_ports")

    @_builtins.property
    @pulumi.getter(name="httpsPorts")
    def https_ports(self) -> Optional[Sequence[_builtins.int]]:
        """
        The listening port of the HTTPS protocol.
        """
        return pulumi.get(self, "https_ports")

    @_builtins.property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether IPv6 is turned on. Value:
        - **true**: indicates that IPv6 is enabled.
        - **false** (default): indicates that IPv6 is not enabled.
        """
        return pulumi.get(self, "ipv6_enabled")

    @_builtins.property
    @pulumi.getter(name="protectionResource")
    def protection_resource(self) -> Optional[_builtins.str]:
        """
        The type of protection resource to use. Value:
        - **share** (default): indicates that a shared cluster is used.
        - **gslb**: indicates that the shared cluster intelligent load balancing is used.
        """
        return pulumi.get(self, "protection_resource")

    @_builtins.property
    @pulumi.getter(name="tlsVersion")
    def tls_version(self) -> Optional[_builtins.str]:
        """
        The version of TLS to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value: **tlsv1**, **tlsv1.1**, **tlsv1.2**.
        """
        return pulumi.get(self, "tls_version")

    @_builtins.property
    @pulumi.getter(name="xffHeaderMode")
    def xff_header_mode(self) -> Optional[_builtins.int]:
        """
        WAF obtains the real IP address of the client. Value:
        - **0** (default): indicates that the client has not forwarded the traffic to WAF through other layer -7 agents.
        - **1**: indicates that the first value of the X-Forwarded-For(XFF) field in the WAF read request header is used as the client IP address.
        - **2**: indicates that the custom field value set by you in the WAF read request header is used as the client IP address.
        """
        return pulumi.get(self, "xff_header_mode")

    @_builtins.property
    @pulumi.getter(name="xffHeaders")
    def xff_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Set the list of custom fields used to obtain the client IP address.
        """
        return pulumi.get(self, "xff_headers")


@pulumi.output_type
class DomainRedirect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "focusHttpBackend":
            suggest = "focus_http_backend"
        elif key == "keepaliveRequests":
            suggest = "keepalive_requests"
        elif key == "keepaliveTimeout":
            suggest = "keepalive_timeout"
        elif key == "readTimeout":
            suggest = "read_timeout"
        elif key == "requestHeaders":
            suggest = "request_headers"
        elif key == "sniEnabled":
            suggest = "sni_enabled"
        elif key == "sniHost":
            suggest = "sni_host"
        elif key == "writeTimeout":
            suggest = "write_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainRedirect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainRedirect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainRedirect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 loadbalance: _builtins.str,
                 backends: Optional[Sequence[_builtins.str]] = None,
                 connect_timeout: Optional[_builtins.int] = None,
                 focus_http_backend: Optional[_builtins.bool] = None,
                 keepalive: Optional[_builtins.bool] = None,
                 keepalive_requests: Optional[_builtins.int] = None,
                 keepalive_timeout: Optional[_builtins.int] = None,
                 read_timeout: Optional[_builtins.int] = None,
                 request_headers: Optional[Sequence['outputs.DomainRedirectRequestHeader']] = None,
                 retry: Optional[_builtins.bool] = None,
                 sni_enabled: Optional[_builtins.bool] = None,
                 sni_host: Optional[_builtins.str] = None,
                 write_timeout: Optional[_builtins.int] = None):
        """
        :param _builtins.str loadbalance: The load balancing algorithm used when returning to the source. Value:
               - **iphash**: indicates the IPHash algorithm.
               - **roundRobin**: indicates the polling algorithm.
               - **leastTime**: indicates the Least Time algorithm.
               - This value can be selected only if the value of **protection_resource** is **gslb** (indicating that the protected resource type uses shared cluster intelligent load balancing).
        :param Sequence[_builtins.str] backends: The IP address of the origin server corresponding to the domain name or the back-to-origin domain name of the server.
        :param _builtins.int connect_timeout: Connection timeout. Unit: seconds, value range: 5~120.
        :param _builtins.bool focus_http_backend: Whether to enable forced HTTP back-to-origin. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
               - **true**: indicates that forced HTTP back-to-origin is enabled.
               - **false**: indicates that forced HTTP back-to-origin is not enabled.
        :param _builtins.bool keepalive: Open long connection, default true.
        :param _builtins.int keepalive_requests: Number of long connections,  default: `60`. range :60-1000.
        :param _builtins.int keepalive_timeout: Long connection over time, default: `15`. Range: 1-60.
        :param _builtins.int read_timeout: Read timeout duration. **Unit**: seconds, **Value range**: 5~1800.
        :param Sequence['DomainRedirectRequestHeaderArgs'] request_headers: The traffic tag field and value of the domain name which used to mark the traffic processed by WAF. 
               It formats as `[{" k ":"_key_"," v ":"_value_"}]`. Where the `k` represents the specified custom request header field,
               and the `v` represents the value set for this field. By specifying the custom request header field and the corresponding value,
               when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value
               to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the
               custom header field already exists in the request, the system will overwrite the value of the custom field in the
               request with the set traffic tag value. See `request_headers` below.
        :param _builtins.bool retry: Back to Source Retry. default: true, retry 3 times by default.
        :param _builtins.bool sni_enabled: Whether to enable back-to-source SNI. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
               - **true**: indicates that the back-to-source SNI is enabled.
               - **false** (default) indicates that the back-to-source SNI is not enabled.
        :param _builtins.str sni_host: Sets the value of the custom SNI extension field. If this parameter is not set, the value of the **Host** field in the request header is used as the value of the SNI extension field by default.In general, you do not need to customize SNI unless your business has special configuration requirements. You want WAF to use SNI that is inconsistent with the actual request Host in the back-to-origin request (that is, the custom SNI set here).> This parameter is required only when **sni_enalbed** is set to **true** (indicating that back-to-source SNI is enabled).
        :param _builtins.int write_timeout: Write timeout duration> **Unit**: seconds, **Value range**: 5~1800.
        """
        pulumi.set(__self__, "loadbalance", loadbalance)
        if backends is not None:
            pulumi.set(__self__, "backends", backends)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if focus_http_backend is not None:
            pulumi.set(__self__, "focus_http_backend", focus_http_backend)
        if keepalive is not None:
            pulumi.set(__self__, "keepalive", keepalive)
        if keepalive_requests is not None:
            pulumi.set(__self__, "keepalive_requests", keepalive_requests)
        if keepalive_timeout is not None:
            pulumi.set(__self__, "keepalive_timeout", keepalive_timeout)
        if read_timeout is not None:
            pulumi.set(__self__, "read_timeout", read_timeout)
        if request_headers is not None:
            pulumi.set(__self__, "request_headers", request_headers)
        if retry is not None:
            pulumi.set(__self__, "retry", retry)
        if sni_enabled is not None:
            pulumi.set(__self__, "sni_enabled", sni_enabled)
        if sni_host is not None:
            pulumi.set(__self__, "sni_host", sni_host)
        if write_timeout is not None:
            pulumi.set(__self__, "write_timeout", write_timeout)

    @_builtins.property
    @pulumi.getter
    def loadbalance(self) -> _builtins.str:
        """
        The load balancing algorithm used when returning to the source. Value:
        - **iphash**: indicates the IPHash algorithm.
        - **roundRobin**: indicates the polling algorithm.
        - **leastTime**: indicates the Least Time algorithm.
        - This value can be selected only if the value of **protection_resource** is **gslb** (indicating that the protected resource type uses shared cluster intelligent load balancing).
        """
        return pulumi.get(self, "loadbalance")

    @_builtins.property
    @pulumi.getter
    def backends(self) -> Optional[Sequence[_builtins.str]]:
        """
        The IP address of the origin server corresponding to the domain name or the back-to-origin domain name of the server.
        """
        return pulumi.get(self, "backends")

    @_builtins.property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[_builtins.int]:
        """
        Connection timeout. Unit: seconds, value range: 5~120.
        """
        return pulumi.get(self, "connect_timeout")

    @_builtins.property
    @pulumi.getter(name="focusHttpBackend")
    def focus_http_backend(self) -> Optional[_builtins.bool]:
        """
        Whether to enable forced HTTP back-to-origin. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        - **true**: indicates that forced HTTP back-to-origin is enabled.
        - **false**: indicates that forced HTTP back-to-origin is not enabled.
        """
        return pulumi.get(self, "focus_http_backend")

    @_builtins.property
    @pulumi.getter
    def keepalive(self) -> Optional[_builtins.bool]:
        """
        Open long connection, default true.
        """
        return pulumi.get(self, "keepalive")

    @_builtins.property
    @pulumi.getter(name="keepaliveRequests")
    def keepalive_requests(self) -> Optional[_builtins.int]:
        """
        Number of long connections,  default: `60`. range :60-1000.
        """
        return pulumi.get(self, "keepalive_requests")

    @_builtins.property
    @pulumi.getter(name="keepaliveTimeout")
    def keepalive_timeout(self) -> Optional[_builtins.int]:
        """
        Long connection over time, default: `15`. Range: 1-60.
        """
        return pulumi.get(self, "keepalive_timeout")

    @_builtins.property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> Optional[_builtins.int]:
        """
        Read timeout duration. **Unit**: seconds, **Value range**: 5~1800.
        """
        return pulumi.get(self, "read_timeout")

    @_builtins.property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Optional[Sequence['outputs.DomainRedirectRequestHeader']]:
        """
        The traffic tag field and value of the domain name which used to mark the traffic processed by WAF. 
        It formats as `[{" k ":"_key_"," v ":"_value_"}]`. Where the `k` represents the specified custom request header field,
        and the `v` represents the value set for this field. By specifying the custom request header field and the corresponding value,
        when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value
        to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the
        custom header field already exists in the request, the system will overwrite the value of the custom field in the
        request with the set traffic tag value. See `request_headers` below.
        """
        return pulumi.get(self, "request_headers")

    @_builtins.property
    @pulumi.getter
    def retry(self) -> Optional[_builtins.bool]:
        """
        Back to Source Retry. default: true, retry 3 times by default.
        """
        return pulumi.get(self, "retry")

    @_builtins.property
    @pulumi.getter(name="sniEnabled")
    def sni_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable back-to-source SNI. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        - **true**: indicates that the back-to-source SNI is enabled.
        - **false** (default) indicates that the back-to-source SNI is not enabled.
        """
        return pulumi.get(self, "sni_enabled")

    @_builtins.property
    @pulumi.getter(name="sniHost")
    def sni_host(self) -> Optional[_builtins.str]:
        """
        Sets the value of the custom SNI extension field. If this parameter is not set, the value of the **Host** field in the request header is used as the value of the SNI extension field by default.In general, you do not need to customize SNI unless your business has special configuration requirements. You want WAF to use SNI that is inconsistent with the actual request Host in the back-to-origin request (that is, the custom SNI set here).> This parameter is required only when **sni_enalbed** is set to **true** (indicating that back-to-source SNI is enabled).
        """
        return pulumi.get(self, "sni_host")

    @_builtins.property
    @pulumi.getter(name="writeTimeout")
    def write_timeout(self) -> Optional[_builtins.int]:
        """
        Write timeout duration> **Unit**: seconds, **Value range**: 5~1800.
        """
        return pulumi.get(self, "write_timeout")


@pulumi.output_type
class DomainRedirectRequestHeader(dict):
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        :param _builtins.str value: The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDomainsDomainResult(dict):
    def __init__(__self__, *,
                 cname: _builtins.str,
                 domain: _builtins.str,
                 id: _builtins.str,
                 listens: Sequence['outputs.GetDomainsDomainListenResult'],
                 redirects: Sequence['outputs.GetDomainsDomainRedirectResult'],
                 resource_manager_resource_group_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str cname: The CNAME assigned by WAF to the domain name.
        :param _builtins.str domain: The name of the domain name to query.
        :param _builtins.str id: The ID of the domain. It formats as `<instance_id>:<domain>`.
        :param Sequence['GetDomainsDomainListenArgs'] listens: Configure listening information
        :param Sequence['GetDomainsDomainRedirectArgs'] redirects: Configure forwarding information.
        :param _builtins.str resource_manager_resource_group_id: The ID of the resource group.
        :param _builtins.str status: The status of the domain.
        """
        pulumi.set(__self__, "cname", cname)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "listens", listens)
        pulumi.set(__self__, "redirects", redirects)
        pulumi.set(__self__, "resource_manager_resource_group_id", resource_manager_resource_group_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def cname(self) -> _builtins.str:
        """
        The CNAME assigned by WAF to the domain name.
        """
        return pulumi.get(self, "cname")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        The name of the domain name to query.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the domain. It formats as `<instance_id>:<domain>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def listens(self) -> Sequence['outputs.GetDomainsDomainListenResult']:
        """
        Configure listening information
        """
        return pulumi.get(self, "listens")

    @_builtins.property
    @pulumi.getter
    def redirects(self) -> Sequence['outputs.GetDomainsDomainRedirectResult']:
        """
        Configure forwarding information.
        """
        return pulumi.get(self, "redirects")

    @_builtins.property
    @pulumi.getter(name="resourceManagerResourceGroupId")
    def resource_manager_resource_group_id(self) -> _builtins.str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_manager_resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the domain.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetDomainsDomainListenResult(dict):
    def __init__(__self__, *,
                 cert_id: _builtins.str,
                 cipher_suite: _builtins.int,
                 custom_ciphers: Sequence[_builtins.str],
                 enable_tlsv3: _builtins.bool,
                 exclusive_ip: _builtins.bool,
                 focus_https: _builtins.bool,
                 http2_enabled: _builtins.bool,
                 http_ports: Sequence[_builtins.int],
                 https_ports: Sequence[_builtins.int],
                 ipv6_enabled: _builtins.bool,
                 protection_resource: _builtins.str,
                 tls_version: _builtins.str,
                 xff_header_mode: _builtins.int,
                 xff_headers: Sequence[_builtins.str]):
        """
        :param _builtins.str cert_id: The ID of the certificate to be added. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param _builtins.int cipher_suite: The type of encryption suite to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param Sequence[_builtins.str] custom_ciphers: The specific custom encryption suite to add.
        :param _builtins.bool enable_tlsv3: Whether TSL1.3 version is supported. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param _builtins.bool exclusive_ip: Whether to enable exclusive IP address. This parameter is used only when the value of **ipv6_enabled** is **false** (indicating that IPv6 is not enabled) and the value of **protection_resource** is **share** (indicating that a shared cluster is used).
        :param _builtins.bool focus_https: Whether to enable the forced jump of HTTPS. This parameter is used only when the value of `https_ports` is not empty (indicating that the domain name uses HTTPS protocol) and the value of httports is empty (indicating that the domain name does not use HTTP protocol).
        :param _builtins.bool http2_enabled: Whether to turn on http2. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param Sequence[_builtins.int] http_ports: The listening port of the HTTP protocol.
        :param Sequence[_builtins.int] https_ports: The listening port of the HTTPS protocol.
        :param _builtins.bool ipv6_enabled: Whether IPv6 is turned on.
        :param _builtins.str protection_resource: The type of protection resource to use.
        :param _builtins.str tls_version: The version of TLS to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param _builtins.int xff_header_mode: WAF obtains the real IP address of the client.
        :param Sequence[_builtins.str] xff_headers: Set the list of custom fields used to obtain the client IP address.
        """
        pulumi.set(__self__, "cert_id", cert_id)
        pulumi.set(__self__, "cipher_suite", cipher_suite)
        pulumi.set(__self__, "custom_ciphers", custom_ciphers)
        pulumi.set(__self__, "enable_tlsv3", enable_tlsv3)
        pulumi.set(__self__, "exclusive_ip", exclusive_ip)
        pulumi.set(__self__, "focus_https", focus_https)
        pulumi.set(__self__, "http2_enabled", http2_enabled)
        pulumi.set(__self__, "http_ports", http_ports)
        pulumi.set(__self__, "https_ports", https_ports)
        pulumi.set(__self__, "ipv6_enabled", ipv6_enabled)
        pulumi.set(__self__, "protection_resource", protection_resource)
        pulumi.set(__self__, "tls_version", tls_version)
        pulumi.set(__self__, "xff_header_mode", xff_header_mode)
        pulumi.set(__self__, "xff_headers", xff_headers)

    @_builtins.property
    @pulumi.getter(name="certId")
    def cert_id(self) -> _builtins.str:
        """
        The ID of the certificate to be added. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "cert_id")

    @_builtins.property
    @pulumi.getter(name="cipherSuite")
    def cipher_suite(self) -> _builtins.int:
        """
        The type of encryption suite to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "cipher_suite")

    @_builtins.property
    @pulumi.getter(name="customCiphers")
    def custom_ciphers(self) -> Sequence[_builtins.str]:
        """
        The specific custom encryption suite to add.
        """
        return pulumi.get(self, "custom_ciphers")

    @_builtins.property
    @pulumi.getter(name="enableTlsv3")
    def enable_tlsv3(self) -> _builtins.bool:
        """
        Whether TSL1.3 version is supported. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "enable_tlsv3")

    @_builtins.property
    @pulumi.getter(name="exclusiveIp")
    def exclusive_ip(self) -> _builtins.bool:
        """
        Whether to enable exclusive IP address. This parameter is used only when the value of **ipv6_enabled** is **false** (indicating that IPv6 is not enabled) and the value of **protection_resource** is **share** (indicating that a shared cluster is used).
        """
        return pulumi.get(self, "exclusive_ip")

    @_builtins.property
    @pulumi.getter(name="focusHttps")
    def focus_https(self) -> _builtins.bool:
        """
        Whether to enable the forced jump of HTTPS. This parameter is used only when the value of `https_ports` is not empty (indicating that the domain name uses HTTPS protocol) and the value of httports is empty (indicating that the domain name does not use HTTP protocol).
        """
        return pulumi.get(self, "focus_https")

    @_builtins.property
    @pulumi.getter(name="http2Enabled")
    def http2_enabled(self) -> _builtins.bool:
        """
        Whether to turn on http2. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "http2_enabled")

    @_builtins.property
    @pulumi.getter(name="httpPorts")
    def http_ports(self) -> Sequence[_builtins.int]:
        """
        The listening port of the HTTP protocol.
        """
        return pulumi.get(self, "http_ports")

    @_builtins.property
    @pulumi.getter(name="httpsPorts")
    def https_ports(self) -> Sequence[_builtins.int]:
        """
        The listening port of the HTTPS protocol.
        """
        return pulumi.get(self, "https_ports")

    @_builtins.property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> _builtins.bool:
        """
        Whether IPv6 is turned on.
        """
        return pulumi.get(self, "ipv6_enabled")

    @_builtins.property
    @pulumi.getter(name="protectionResource")
    def protection_resource(self) -> _builtins.str:
        """
        The type of protection resource to use.
        """
        return pulumi.get(self, "protection_resource")

    @_builtins.property
    @pulumi.getter(name="tlsVersion")
    def tls_version(self) -> _builtins.str:
        """
        The version of TLS to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "tls_version")

    @_builtins.property
    @pulumi.getter(name="xffHeaderMode")
    def xff_header_mode(self) -> _builtins.int:
        """
        WAF obtains the real IP address of the client.
        """
        return pulumi.get(self, "xff_header_mode")

    @_builtins.property
    @pulumi.getter(name="xffHeaders")
    def xff_headers(self) -> Sequence[_builtins.str]:
        """
        Set the list of custom fields used to obtain the client IP address.
        """
        return pulumi.get(self, "xff_headers")


@pulumi.output_type
class GetDomainsDomainRedirectResult(dict):
    def __init__(__self__, *,
                 backends: Sequence[_builtins.str],
                 connect_timeout: _builtins.int,
                 focus_http_backend: _builtins.bool,
                 keepalive: _builtins.bool,
                 keepalive_requests: _builtins.int,
                 keepalive_timeout: _builtins.int,
                 loadbalance: _builtins.str,
                 read_timeout: _builtins.int,
                 request_headers: Sequence['outputs.GetDomainsDomainRedirectRequestHeaderResult'],
                 retry: _builtins.bool,
                 sni_enabled: _builtins.bool,
                 sni_host: _builtins.str,
                 write_timeout: _builtins.int):
        """
        :param Sequence[_builtins.str] backends: The IP address of the origin server corresponding to the domain name or the back-to-origin domain name of the server.
        :param _builtins.int connect_timeout: Connection timeout, Unit: seconds, value range: 5~120.
        :param _builtins.bool focus_http_backend: Whether to enable forced HTTP back-to-origin. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param _builtins.bool keepalive: Open long connection, default true.
        :param _builtins.int keepalive_requests: Number of long connections, default: `60`. range :60-1000.
        :param _builtins.int keepalive_timeout: Long connection over time, default: `15`. Range: 1-60.
        :param _builtins.str loadbalance: The load balancing algorithm used when returning to the source.
        :param _builtins.int read_timeout: Read timeout duration. Unit: seconds, Value range: 5~1800.
        :param Sequence['GetDomainsDomainRedirectRequestHeaderArgs'] request_headers: The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        :param _builtins.bool retry: Back to Source Retry. default `true`, retry 3 times by default.
        :param _builtins.bool sni_enabled: Whether to enable back-to-source SNI. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param _builtins.str sni_host: Sets the value of the custom SNI extension field. If this parameter is not set, the value of the **Host** field in the request header is used as the value of the SNI extension field by default.In general, you do not need to customize SNI unless your business has special configuration requirements. You want WAF to use SNI that is inconsistent with the actual request Host in the back-to-origin request (that is, the custom SNI set here).> This parameter is required only when **sni_enalbed** is set to **true** (indicating that back-to-source SNI is enabled).
        :param _builtins.int write_timeout: Write timeout duration. **Unit**: seconds, **Value range**:5~1800.
        """
        pulumi.set(__self__, "backends", backends)
        pulumi.set(__self__, "connect_timeout", connect_timeout)
        pulumi.set(__self__, "focus_http_backend", focus_http_backend)
        pulumi.set(__self__, "keepalive", keepalive)
        pulumi.set(__self__, "keepalive_requests", keepalive_requests)
        pulumi.set(__self__, "keepalive_timeout", keepalive_timeout)
        pulumi.set(__self__, "loadbalance", loadbalance)
        pulumi.set(__self__, "read_timeout", read_timeout)
        pulumi.set(__self__, "request_headers", request_headers)
        pulumi.set(__self__, "retry", retry)
        pulumi.set(__self__, "sni_enabled", sni_enabled)
        pulumi.set(__self__, "sni_host", sni_host)
        pulumi.set(__self__, "write_timeout", write_timeout)

    @_builtins.property
    @pulumi.getter
    def backends(self) -> Sequence[_builtins.str]:
        """
        The IP address of the origin server corresponding to the domain name or the back-to-origin domain name of the server.
        """
        return pulumi.get(self, "backends")

    @_builtins.property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> _builtins.int:
        """
        Connection timeout, Unit: seconds, value range: 5~120.
        """
        return pulumi.get(self, "connect_timeout")

    @_builtins.property
    @pulumi.getter(name="focusHttpBackend")
    def focus_http_backend(self) -> _builtins.bool:
        """
        Whether to enable forced HTTP back-to-origin. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "focus_http_backend")

    @_builtins.property
    @pulumi.getter
    def keepalive(self) -> _builtins.bool:
        """
        Open long connection, default true.
        """
        return pulumi.get(self, "keepalive")

    @_builtins.property
    @pulumi.getter(name="keepaliveRequests")
    def keepalive_requests(self) -> _builtins.int:
        """
        Number of long connections, default: `60`. range :60-1000.
        """
        return pulumi.get(self, "keepalive_requests")

    @_builtins.property
    @pulumi.getter(name="keepaliveTimeout")
    def keepalive_timeout(self) -> _builtins.int:
        """
        Long connection over time, default: `15`. Range: 1-60.
        """
        return pulumi.get(self, "keepalive_timeout")

    @_builtins.property
    @pulumi.getter
    def loadbalance(self) -> _builtins.str:
        """
        The load balancing algorithm used when returning to the source.
        """
        return pulumi.get(self, "loadbalance")

    @_builtins.property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> _builtins.int:
        """
        Read timeout duration. Unit: seconds, Value range: 5~1800.
        """
        return pulumi.get(self, "read_timeout")

    @_builtins.property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Sequence['outputs.GetDomainsDomainRedirectRequestHeaderResult']:
        """
        The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        return pulumi.get(self, "request_headers")

    @_builtins.property
    @pulumi.getter
    def retry(self) -> _builtins.bool:
        """
        Back to Source Retry. default `true`, retry 3 times by default.
        """
        return pulumi.get(self, "retry")

    @_builtins.property
    @pulumi.getter(name="sniEnabled")
    def sni_enabled(self) -> _builtins.bool:
        """
        Whether to enable back-to-source SNI. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "sni_enabled")

    @_builtins.property
    @pulumi.getter(name="sniHost")
    def sni_host(self) -> _builtins.str:
        """
        Sets the value of the custom SNI extension field. If this parameter is not set, the value of the **Host** field in the request header is used as the value of the SNI extension field by default.In general, you do not need to customize SNI unless your business has special configuration requirements. You want WAF to use SNI that is inconsistent with the actual request Host in the back-to-origin request (that is, the custom SNI set here).> This parameter is required only when **sni_enalbed** is set to **true** (indicating that back-to-source SNI is enabled).
        """
        return pulumi.get(self, "sni_host")

    @_builtins.property
    @pulumi.getter(name="writeTimeout")
    def write_timeout(self) -> _builtins.int:
        """
        Write timeout duration. **Unit**: seconds, **Value range**:5~1800.
        """
        return pulumi.get(self, "write_timeout")


@pulumi.output_type
class GetDomainsDomainRedirectRequestHeaderResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        :param _builtins.str value: The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str create_time: The creation time of the resource.
        :param _builtins.str id: The ID of the resource.
        :param _builtins.str instance_id: The first ID of the resource.
        :param _builtins.str status: The status of the resource.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")


