"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.App = exports.AppProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const mobi_generated_1 = require("./mobi.generated");
Object.defineProperty(exports, "AppProperty", { enumerable: true, get: function () { return mobi_generated_1.RosApp; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::MOBI::App`, which is used to create an application.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosApp`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-mobi-app
 */
class App extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosApp = new mobi_generated_1.RosApp(this, id, {
            appDescription: props.appDescription,
            appIcon: props.appIcon,
            appWorkspaceId: props.appWorkspaceId,
            appType: props.appType,
            appName: props.appName,
            template: props.template,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosApp;
        this.attrAppDescription = rosApp.attrAppDescription;
        this.attrAppIcon = rosApp.attrAppIcon;
        this.attrAppId = rosApp.attrAppId;
        this.attrAppName = rosApp.attrAppName;
        this.attrAppType = rosApp.attrAppType;
        this.attrAppWorkspaceId = rosApp.attrAppWorkspaceId;
        this.attrCreateTime = rosApp.attrCreateTime;
        this.attrModifiedTime = rosApp.attrModifiedTime;
    }
}
exports.App = App;
//# sourceMappingURL=data:application/json;base64,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