# Configuration file for the Sphinx documentation builder.
#
# For the full list of built-in configuration values, see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Project information -----------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#project-information

project = "chancy"
copyright = "2024, Tyler Kennedy"
author = "Tyler Kennedy"

# -- General configuration ---------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#general-configuration

extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.todo",
    "sphinx.ext.graphviz",
    "sphinx.ext.linkcode",
    "sphinx_inline_tabs",
]

templates_path = ["_templates"]
exclude_patterns = ["_build", "Thumbs.db", ".DS_Store"]

language = "en"

# -- Options for HTML output -------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#options-for-html-output

html_theme = "furo"
html_static_path = ["_static"]
html_logo = "../misc/logo.png"
html_title = "Chancy"

html_js_files = [
    (
        "https://plausible.io/js/script.js",
        {"data-domain": "tkte.ch", "defer": "defer"},
    ),
]

# -- Options for todo extension ----------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/extensions/todo.html#configuration

todo_include_todos = True


def linkcode_resolve(domain, info):
    if domain != "py":
        return None

    if not info["module"]:
        return None

    filename = info["module"].replace(".", "/")
    return f"https://github.com/tktech/chancy/blob/main/{filename}.py"
