# fmt: off
# Generated by the protocol buffer compiler.  DO NOT EDIT!
from __future__ import annotations
from datetime import datetime, timedelta
import enum
from typing import Any, Dict, List, Optional, TypeVar, Type
from google.protobuf import timestamp_pb2
from google.protobuf import duration_pb2
from google.protobuf.json_format import MessageToDict

from continual.rpc.management.v1 import management_types_pb2
from continual.rpc.management.v1 import management_pb2

from google import protobuf

T = TypeVar("T")

def _to_proto_dict(x: dict) -> dict:
    """Converts dict to proto friendly representation."""
    out = dict()
    for key, item in x.items():
        if isinstance(item, list):
            out_list = []
            for e in item:
                if isinstance(e, datetime):
                    dt = timestamp_pb2.Timestamp()
                    dt.FromDatetime(e)
                    out_list.append(dt)
                elif isinstance(e, timedelta):
                    td = duration_pb2.Duration()
                    td.FromTimedelta(e)
                    out_list.append(td)
                elif hasattr(e, "to_proto"):
                    out_list.append(e.to_proto())
                else:
                    out_list.append(e)
            out[key] = out_list
        elif isinstance(item, datetime):
            dt = timestamp_pb2.Timestamp()
            dt.FromDatetime(item)
            out[key] = dt
        elif isinstance(item, timedelta):
            td = duration_pb2.Duration()
            td.FromTimedelta(item)
            out[key] = td
        elif hasattr(item, "to_proto"):
            out[key] = item.to_proto()
        else:
            out[key] = item
    return out


def _set_attribute(
    attributes: dict, class_name: str, field: str, value: Any, fieldType: Any, oneOfField: str
):
    """Helper that sets attribute on the object.
    
    Accepts dicts for classes and normalizes enums.
    """
    if isinstance(value, dict) and getattr(fieldType, "__origin__", None) == dict:
        attributes[field] = value
    elif isinstance(value, dict):
        attributes[field] = fieldType(**value)
    elif isinstance(value, list):
        innerType = fieldType.__args__[0]
        if innerType in [str, float, bool]:
            attributes[field] = value
        elif innerType is int:
            attributes[field] = [int(x) for x in value]
        elif issubclass(innerType, Enum):
            if len(value) > 0:
                if isinstance(value[0], str):
                    attributes[field] = [innerType(x.upper()) for x in value]
                elif isinstance(value[0], int) and getattr(innerType, "from_proto", None) is not None:
                    attributes[field] = [innerType.from_proto(x) for x in value]
        else:
            attributes[field] = [innerType(**x) for x in value]
    elif isinstance(value, str) and issubclass(fieldType, Enum):
        attributes[field] = fieldType(value.upper())
    elif isinstance(value, int) and issubclass(fieldType, Enum) and getattr(fieldType, "from_proto", None) is not None:
        attributes[field] = fieldType.from_proto(value)
    elif isinstance(value, str) and fieldType == datetime:
        dt = timestamp_pb2.Timestamp()
        dt.FromJsonString(value)
        attributes[field] = dt.ToDatetime()
    elif isinstance(value, str) and fieldType == timedelta:
        td = timestamp_pb2.Duration()
        td.FromJsonString(value)
        attributes[field] = td.ToTimeDelta()
    elif isinstance(value, str) and fieldType == int:
        # Needed to handle int64 encoded as strings.
        attributes[field] = int(value)
    # Set zero values to be consistent with proto.
    elif value is None:
        if fieldType == str:
            attributes[field] = ""
        elif fieldType == int:
            attributes[field] = 0
        elif fieldType == float:
            attributes[field] = 0.0
        elif fieldType == bool:
            attributes[field] = False
        elif getattr(fieldType, "__origin__", None) == list:
            attributes[field] = []
        elif getattr(fieldType, "__origin__", None) == dict:
            attributes[field] = {}
        elif fieldType == datetime or fieldType == timedelta:
            attributes[field] = None
        else:
            if oneOfField == "":
                attributes[field] = fieldType()
            else:
                attributes[field] = None
    elif value is not None and not isinstance(value, fieldType):
        raise ValueError(
            f"'{class_name}.{field}' must have type {fieldType}, got {type(value)}"
        )
    else:
        attributes[field] = value


class Enum(enum.Enum):
    """Base enum class.
    
    Overrides equality to be case insentitive.
    """

    def __eq__(self, other) -> bool:
        """Object is equal with all types."""
        if isinstance(other, str):
            return self.name == other.upper()
        elif isinstance(other, int):
            return self.value == other
        else:
            return self.value == other.value
    
    def __str__(self) -> str:
        return self.value


class FieldType(Enum):
    """Featureset field types."""
    
    INVALID = "INVALID"
    NUMBER = "NUMBER"
    BOOLEAN = "BOOLEAN"
    CATEGORICAL = "CATEGORICAL"
    TEXT = "TEXT"
    TIMESTAMP = "TIMESTAMP"
    TIME = "TIME"
    DATE = "DATE"
    DATETIME = "DATETIME"
    NUMBER_LIST = "NUMBER_LIST"
    BOOLEAN_LIST = "BOOLEAN_LIST"
    TEXT_LIST = "TEXT_LIST"
    INDEX = "INDEX"
    TIME_INDEX = "TIME_INDEX"
    SPLIT = "SPLIT"

    @classmethod
    def from_proto(cls, value: int = 0) ->  FieldType:
        """Convert enum from proto representation."""
        return cls(management_types_pb2.FieldType.Name(value))

    def to_proto(self) -> int:
        """Convert enum to proto representation."""
        return management_types_pb2.FieldType.Value(self.value)

class BatchPredictionStoreType(Enum):
    """"""
    
    UNSPECIFIED = "UNSPECIFIED"
    CSV = "CSV"
    STORE = "STORE"

    @classmethod
    def from_proto(cls, value: int = 0) ->  BatchPredictionStoreType:
        """Convert enum from proto representation."""
        return cls(management_types_pb2.BatchPredictionStoreType.Name(value))

    def to_proto(self) -> int:
        """Convert enum to proto representation."""
        return management_types_pb2.BatchPredictionStoreType.Value(self.value)

class CheckOutcome(Enum):
    """"""
    
    PASSED = "PASSED"
    FAILED = "FAILED"
    SKIPPED = "SKIPPED"

    @classmethod
    def from_proto(cls, value: int = 0) ->  CheckOutcome:
        """Convert enum from proto representation."""
        return cls(management_types_pb2.CheckOutcome.Name(value))

    def to_proto(self) -> int:
        """Convert enum to proto representation."""
        return management_types_pb2.CheckOutcome.Value(self.value)

class PrincipalType(Enum):
    """"""
    
    UNSPECIFIED = "UNSPECIFIED"
    USER = "USER"
    API_KEY = "API_KEY"

    @classmethod
    def from_proto(cls, value: int = 0) ->  PrincipalType:
        """Convert enum from proto representation."""
        return cls(management_types_pb2.Principal.Type.Name(value))

    def to_proto(self) -> int:
        """Convert enum to proto representation."""
        return management_types_pb2.Principal.Type.Value(self.value)

class SessionState(Enum):
    """"""
    
    UNSPECIFIED = "UNSPECIFIED"
    ACTIVE = "ACTIVE"
    EXPIRED = "EXPIRED"

    @classmethod
    def from_proto(cls, value: int = 0) ->  SessionState:
        """Convert enum from proto representation."""
        return cls(management_types_pb2.Session.State.Name(value))

    def to_proto(self) -> int:
        """Convert enum to proto representation."""
        return management_types_pb2.Session.State.Value(self.value)

class OrganizationStatus(Enum):
    """"""
    
    EXPIRED = "EXPIRED"
    ACTIVE_TRIAL = "ACTIVE_TRIAL"
    ACTIVE = "ACTIVE"
    DISABLED = "DISABLED"

    @classmethod
    def from_proto(cls, value: int = 0) ->  OrganizationStatus:
        """Convert enum from proto representation."""
        return cls(management_types_pb2.Organization.Status.Name(value))

    def to_proto(self) -> int:
        """Convert enum to proto representation."""
        return management_types_pb2.Organization.Status.Value(self.value)

class ApiKeyState(Enum):
    """"""
    
    UNSPECIFIED = "UNSPECIFIED"
    ACTIVE = "ACTIVE"
    INACTIVE = "INACTIVE"

    @classmethod
    def from_proto(cls, value: int = 0) ->  ApiKeyState:
        """Convert enum from proto representation."""
        return cls(management_types_pb2.ApiKey.State.Name(value))

    def to_proto(self) -> int:
        """Convert enum to proto representation."""
        return management_types_pb2.ApiKey.State.Value(self.value)

class PromotionReason(Enum):
    """"""
    
    REASON_UNSPECIFIED = "REASON_UNSPECIFIED"
    UPLIFT = "UPLIFT"
    NO_PROMOTED_MODEL_VERSION_EXISTS = "NO_PROMOTED_MODEL_VERSION_EXISTS"
    LATEST_POLICY = "LATEST_POLICY"
    UNDERPERFORMED = "UNDERPERFORMED"
    MANUAL = "MANUAL"
    FORCED = "FORCED"
    INCOMPATIBLE_SCHEMA = "INCOMPATIBLE_SCHEMA"

    @classmethod
    def from_proto(cls, value: int = 0) ->  PromotionReason:
        """Convert enum from proto representation."""
        return cls(management_types_pb2.Promotion.Reason.Name(value))

    def to_proto(self) -> int:
        """Convert enum to proto representation."""
        return management_types_pb2.Promotion.Reason.Value(self.value)

class PromotionState(Enum):
    """"""
    
    STATE_UNSPECIFIED = "STATE_UNSPECIFIED"
    SUCCEEDED = "SUCCEEDED"
    FAILED = "FAILED"

    @classmethod
    def from_proto(cls, value: int = 0) ->  PromotionState:
        """Convert enum from proto representation."""
        return cls(management_types_pb2.Promotion.State.Name(value))

    def to_proto(self) -> int:
        """Convert enum to proto representation."""
        return management_types_pb2.Promotion.State.Value(self.value)

class ModelVersionState(Enum):
    """"""
    
    STATE_UNSPECIFIED = "STATE_UNSPECIFIED"
    CREATED = "CREATED"
    PENDING = "PENDING"
    PREPROCESSING = "PREPROCESSING"
    TRAINING = "TRAINING"
    POSTPROCESSING = "POSTPROCESSING"
    CANCELLING = "CANCELLING"
    SUCCEEDED = "SUCCEEDED"
    FAILED = "FAILED"
    CANCELLED = "CANCELLED"
    PROFILING = "PROFILING"

    @classmethod
    def from_proto(cls, value: int = 0) ->  ModelVersionState:
        """Convert enum from proto representation."""
        return cls(management_types_pb2.ModelVersion.State.Name(value))

    def to_proto(self) -> int:
        """Convert enum to proto representation."""
        return management_types_pb2.ModelVersion.State.Value(self.value)

class ExperimentState(Enum):
    """"""
    
    STATE_UNSPECIFIED = "STATE_UNSPECIFIED"
    PENDING = "PENDING"
    PREPROCESSING = "PREPROCESSING"
    TRAINING = "TRAINING"
    POSTPROCESSING = "POSTPROCESSING"
    CANCELLING = "CANCELLING"
    SUCCEEDED = "SUCCEEDED"
    FAILED = "FAILED"
    CANCELLED = "CANCELLED"

    @classmethod
    def from_proto(cls, value: int = 0) ->  ExperimentState:
        """Convert enum from proto representation."""
        return cls(management_types_pb2.Experiment.State.Name(value))

    def to_proto(self) -> int:
        """Convert enum to proto representation."""
        return management_types_pb2.Experiment.State.Value(self.value)

class BatchPredictionState(Enum):
    """"""
    
    STATE_UNSPECIFIED = "STATE_UNSPECIFIED"
    CREATED = "CREATED"
    PENDING = "PENDING"
    PREPROCESSING = "PREPROCESSING"
    PROCESSING = "PROCESSING"
    POSTPROCESSING = "POSTPROCESSING"
    CANCELLING = "CANCELLING"
    SUCCEEDED = "SUCCEEDED"
    FAILED = "FAILED"
    CANCELLED = "CANCELLED"

    @classmethod
    def from_proto(cls, value: int = 0) ->  BatchPredictionState:
        """Convert enum from proto representation."""
        return cls(management_types_pb2.BatchPrediction.State.Name(value))

    def to_proto(self) -> int:
        """Convert enum to proto representation."""
        return management_types_pb2.BatchPrediction.State.Value(self.value)

class MetricDirection(Enum):
    """"""
    
    HIGHER = "HIGHER"
    LOWER = "LOWER"

    @classmethod
    def from_proto(cls, value: int = 0) ->  MetricDirection:
        """Convert enum from proto representation."""
        return cls(management_types_pb2.Metric.Direction.Name(value))

    def to_proto(self) -> int:
        """Convert enum to proto representation."""
        return management_types_pb2.Metric.Direction.Value(self.value)

class MetadataType(Enum):
    """"""
    
    MAP = "MAP"
    CONFUSION_MATRIX = "CONFUSION_MATRIX"
    GIT_CONTEXT = "GIT_CONTEXT"
    RESOURCE_CHECK = "RESOURCE_CHECK"

    @classmethod
    def from_proto(cls, value: int = 0) ->  MetadataType:
        """Convert enum from proto representation."""
        return cls(management_types_pb2.Metadata.Type.Name(value))

    def to_proto(self) -> int:
        """Convert enum to proto representation."""
        return management_types_pb2.Metadata.Type.Value(self.value)

class RunState(Enum):
    """"""
    
    ACTIVE = "ACTIVE"
    INACTIVE = "INACTIVE"
    COMPLETED = "COMPLETED"
    STOPPED = "STOPPED"
    FAILED = "FAILED"

    @classmethod
    def from_proto(cls, value: int = 0) ->  RunState:
        """Convert enum from proto representation."""
        return cls(management_types_pb2.Run.State.Name(value))

    def to_proto(self) -> int:
        """Convert enum to proto representation."""
        return management_types_pb2.Run.State.Value(self.value)

class NotificationPolicyType(Enum):
    """"""
    
    EMAIL = "EMAIL"
    SLACK = "SLACK"

    @classmethod
    def from_proto(cls, value: int = 0) ->  NotificationPolicyType:
        """Convert enum from proto representation."""
        return cls(management_types_pb2.NotificationPolicy.Type.Name(value))

    def to_proto(self) -> int:
        """Convert enum to proto representation."""
        return management_types_pb2.NotificationPolicy.Type.Value(self.value)



class User:
    """User."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , email: str = ""
        , email_verified: bool = False
        , full_name: str = ""
        , bio: str = ""
        , location: str = ""
        , password: str = ""
        , service_account: bool = False
        , update_time: datetime = None
        , create_time: datetime = None
        , disabled: bool = False
        , trial_available: bool = False
        , first_name: str = ""
        , last_name: str = ""
    , **kwargs) -> User:
        self._attributes = dict()
        self.name = name
        self.email = email
        self.email_verified = email_verified
        self.full_name = full_name
        self.bio = bio
        self.location = location
        self.password = password
        self.service_account = service_account
        self.update_time = update_time
        self.create_time = create_time
        self.disabled = disabled
        self.trial_available = trial_available
        self.first_name = first_name
        self.last_name = last_name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "User", "name", value, str, "")


    @property
    def email(self) -> str:
        """Email."""
        return self._attributes["email"]


    @email.setter
    def email(self, value: str) -> None:
        _set_attribute(self._attributes, "User", "email", value, str, "")


    @property
    def email_verified(self) -> bool:
        """Email verified."""
        return self._attributes["email_verified"]


    @email_verified.setter
    def email_verified(self, value: bool) -> None:
        _set_attribute(self._attributes, "User", "email_verified", value, bool, "")


    @property
    def full_name(self) -> str:
        """Full name."""
        return self._attributes["full_name"]


    @full_name.setter
    def full_name(self, value: str) -> None:
        _set_attribute(self._attributes, "User", "full_name", value, str, "")


    @property
    def bio(self) -> str:
        """Bio."""
        return self._attributes["bio"]


    @bio.setter
    def bio(self, value: str) -> None:
        _set_attribute(self._attributes, "User", "bio", value, str, "")


    @property
    def location(self) -> str:
        """Location."""
        return self._attributes["location"]


    @location.setter
    def location(self, value: str) -> None:
        _set_attribute(self._attributes, "User", "location", value, str, "")


    @property
    def password(self) -> str:
        """Password."""
        return self._attributes["password"]


    @password.setter
    def password(self, value: str) -> None:
        _set_attribute(self._attributes, "User", "password", value, str, "")


    @property
    def service_account(self) -> bool:
        """Service account."""
        return self._attributes["service_account"]


    @service_account.setter
    def service_account(self, value: bool) -> None:
        _set_attribute(self._attributes, "User", "service_account", value, bool, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "User", "update_time", value, datetime, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "User", "create_time", value, datetime, "")


    @property
    def disabled(self) -> bool:
        """Disabled."""
        return self._attributes["disabled"]


    @disabled.setter
    def disabled(self, value: bool) -> None:
        _set_attribute(self._attributes, "User", "disabled", value, bool, "")


    @property
    def trial_available(self) -> bool:
        """Trial available."""
        return self._attributes["trial_available"]


    @trial_available.setter
    def trial_available(self, value: bool) -> None:
        _set_attribute(self._attributes, "User", "trial_available", value, bool, "")


    @property
    def first_name(self) -> str:
        """First name."""
        return self._attributes["first_name"]


    @first_name.setter
    def first_name(self, value: str) -> None:
        _set_attribute(self._attributes, "User", "first_name", value, str, "")


    @property
    def last_name(self) -> str:
        """Last name."""
        return self._attributes["last_name"]


    @last_name.setter
    def last_name(self, value: str) -> None:
        _set_attribute(self._attributes, "User", "last_name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.User, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.User:
        """Convert object to proto representation."""
        return management_types_pb2.User(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<User object " + repr(self.to_dict()) + ">"


class Principal:
    """Principal."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , type: PrincipalType = 0
        , display_name: str = ""
    , **kwargs) -> Principal:
        self._attributes = dict()
        self.name = name
        self.type = type
        self.display_name = display_name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Principal", "name", value, str, "")


    @property
    def type(self) -> PrincipalType:
        """Type."""
        return self._attributes["type"]


    @type.setter
    def type(self, value: PrincipalType) -> None:
        _set_attribute(self._attributes, "Principal", "type", value, PrincipalType, "")


    @property
    def display_name(self) -> str:
        """Display name."""
        return self._attributes["display_name"]


    @display_name.setter
    def display_name(self, value: str) -> None:
        _set_attribute(self._attributes, "Principal", "display_name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Principal, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Principal:
        """Convert object to proto representation."""
        return management_types_pb2.Principal(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Principal object " + repr(self.to_dict()) + ">"


class Session:
    """Session."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , subject: str = ""
        , last_access_ip: str = ""
        , last_access_time: datetime = None
        , login_ip: str = ""
        , login_time: datetime = None
        , login_user_agent: str = ""
        , state: SessionState = 0
    , **kwargs) -> Session:
        self._attributes = dict()
        self.name = name
        self.subject = subject
        self.last_access_ip = last_access_ip
        self.last_access_time = last_access_time
        self.login_ip = login_ip
        self.login_time = login_time
        self.login_user_agent = login_user_agent
        self.state = state

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Session", "name", value, str, "")


    @property
    def subject(self) -> str:
        """Subject."""
        return self._attributes["subject"]


    @subject.setter
    def subject(self, value: str) -> None:
        _set_attribute(self._attributes, "Session", "subject", value, str, "")


    @property
    def last_access_ip(self) -> str:
        """Last access ip."""
        return self._attributes["last_access_ip"]


    @last_access_ip.setter
    def last_access_ip(self, value: str) -> None:
        _set_attribute(self._attributes, "Session", "last_access_ip", value, str, "")


    @property
    def last_access_time(self) -> datetime:
        """Last access time."""
        return self._attributes["last_access_time"]


    @last_access_time.setter
    def last_access_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Session", "last_access_time", value, datetime, "")


    @property
    def login_ip(self) -> str:
        """Login ip."""
        return self._attributes["login_ip"]


    @login_ip.setter
    def login_ip(self, value: str) -> None:
        _set_attribute(self._attributes, "Session", "login_ip", value, str, "")


    @property
    def login_time(self) -> datetime:
        """Login time."""
        return self._attributes["login_time"]


    @login_time.setter
    def login_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Session", "login_time", value, datetime, "")


    @property
    def login_user_agent(self) -> str:
        """Login user agent."""
        return self._attributes["login_user_agent"]


    @login_user_agent.setter
    def login_user_agent(self, value: str) -> None:
        _set_attribute(self._attributes, "Session", "login_user_agent", value, str, "")


    @property
    def state(self) -> SessionState:
        """State."""
        return self._attributes["state"]


    @state.setter
    def state(self, value: SessionState) -> None:
        _set_attribute(self._attributes, "Session", "state", value, SessionState, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Session, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Session:
        """Convert object to proto representation."""
        return management_types_pb2.Session(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Session object " + repr(self.to_dict()) + ">"


class Role:
    """A access control role."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , title: str = ""
        , description: str = ""
        , resource_type: str = ""
        , permissions: List[str] = []
    , **kwargs) -> Role:
        self._attributes = dict()
        self.name = name
        self.title = title
        self.description = description
        self.resource_type = resource_type
        self.permissions = permissions

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """The name of the role."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Role", "name", value, str, "")


    @property
    def title(self) -> str:
        """A human-readable title for the role."""
        return self._attributes["title"]


    @title.setter
    def title(self, value: str) -> None:
        _set_attribute(self._attributes, "Role", "title", value, str, "")


    @property
    def description(self) -> str:
        """A human-readable description for the role."""
        return self._attributes["description"]


    @description.setter
    def description(self, value: str) -> None:
        _set_attribute(self._attributes, "Role", "description", value, str, "")


    @property
    def resource_type(self) -> str:
        """Resource type that role can be assigned."""
        return self._attributes["resource_type"]


    @resource_type.setter
    def resource_type(self, value: str) -> None:
        _set_attribute(self._attributes, "Role", "resource_type", value, str, "")


    @property
    def permissions(self) -> List[str]:
        """The names of the permissions this role grants."""
        return self._attributes["permissions"]


    @permissions.setter
    def permissions(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "Role", "permissions", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Role, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Role:
        """Convert object to proto representation."""
        return management_types_pb2.Role(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Role object " + repr(self.to_dict()) + ">"


class AccessPolicy:
    """AccessPolicy grants a role between a subject and a resource.
 Subjects can be users or service accounts and resources
 can currently be organizations or projects.  Subjects can have
 multiple roles assigned to them."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , subject: str = ""
        , resource: str = ""
        , role: str = ""
        , create_time: datetime = None
    , **kwargs) -> AccessPolicy:
        self._attributes = dict()
        self.name = name
        self.subject = subject
        self.resource = resource
        self.role = role
        self.create_time = create_time

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """The name of the role grant."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "AccessPolicy", "name", value, str, "")


    @property
    def subject(self) -> str:
        """The subject of the role grant, either a user, group, or service account."""
        return self._attributes["subject"]


    @subject.setter
    def subject(self, value: str) -> None:
        _set_attribute(self._attributes, "AccessPolicy", "subject", value, str, "")


    @property
    def resource(self) -> str:
        """The resource on which the role is granted."""
        return self._attributes["resource"]


    @resource.setter
    def resource(self, value: str) -> None:
        _set_attribute(self._attributes, "AccessPolicy", "resource", value, str, "")


    @property
    def role(self) -> str:
        """the role being granted, such as roles/project.viewer"""
        return self._attributes["role"]


    @role.setter
    def role(self, value: str) -> None:
        _set_attribute(self._attributes, "AccessPolicy", "role", value, str, "")


    @property
    def create_time(self) -> datetime:
        """The date the role was created."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "AccessPolicy", "create_time", value, datetime, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.AccessPolicy, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.AccessPolicy:
        """Convert object to proto representation."""
        return management_types_pb2.AccessPolicy(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<AccessPolicy object " + repr(self.to_dict()) + ">"


class Invite:
    """Project or organization invitation."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , sender: str = ""
        , email: str = ""
        , role: str = ""
        , create_time: datetime = None
        , expire_time: datetime = None
    , **kwargs) -> Invite:
        self._attributes = dict()
        self.name = name
        self.sender = sender
        self.email = email
        self.role = role
        self.create_time = create_time
        self.expire_time = expire_time

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Invite name"""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Invite", "name", value, str, "")


    @property
    def sender(self) -> str:
        """Sender"""
        return self._attributes["sender"]


    @sender.setter
    def sender(self, value: str) -> None:
        _set_attribute(self._attributes, "Invite", "sender", value, str, "")


    @property
    def email(self) -> str:
        """User email"""
        return self._attributes["email"]


    @email.setter
    def email(self, value: str) -> None:
        _set_attribute(self._attributes, "Invite", "email", value, str, "")


    @property
    def role(self) -> str:
        """Invite role."""
        return self._attributes["role"]


    @role.setter
    def role(self, value: str) -> None:
        _set_attribute(self._attributes, "Invite", "role", value, str, "")


    @property
    def create_time(self) -> datetime:
        """Invite create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Invite", "create_time", value, datetime, "")


    @property
    def expire_time(self) -> datetime:
        """Invite expire time."""
        return self._attributes["expire_time"]


    @expire_time.setter
    def expire_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Invite", "expire_time", value, datetime, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Invite, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Invite:
        """Convert object to proto representation."""
        return management_types_pb2.Invite(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Invite object " + repr(self.to_dict()) + ">"


class Organization:
    """Organization."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , display_name: str = ""
        , update_time: datetime = None
        , create_time: datetime = None
        , status: OrganizationStatus = 0
        , trial_end_date: datetime = None
        , trial_credits: int = 0
        , trial_credits_used: int = 0
        , show_plan: bool = False
        , sso_enabled: bool = False
        , requires_sso: bool = False
        , sso_domains: List[str] = []
        , allow_external_users: bool = False
        , sso_configured: bool = False
        , directory_sync_configured: bool = False
    , **kwargs) -> Organization:
        self._attributes = dict()
        self.name = name
        self.display_name = display_name
        self.update_time = update_time
        self.create_time = create_time
        self.status = status
        self.trial_end_date = trial_end_date
        self.trial_credits = trial_credits
        self.trial_credits_used = trial_credits_used
        self.show_plan = show_plan
        self.sso_enabled = sso_enabled
        self.requires_sso = requires_sso
        self.sso_domains = sso_domains
        self.allow_external_users = allow_external_users
        self.sso_configured = sso_configured
        self.directory_sync_configured = directory_sync_configured

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Organization", "name", value, str, "")


    @property
    def display_name(self) -> str:
        """Display name."""
        return self._attributes["display_name"]


    @display_name.setter
    def display_name(self, value: str) -> None:
        _set_attribute(self._attributes, "Organization", "display_name", value, str, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Organization", "update_time", value, datetime, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Organization", "create_time", value, datetime, "")


    @property
    def status(self) -> OrganizationStatus:
        """Status."""
        return self._attributes["status"]


    @status.setter
    def status(self, value: OrganizationStatus) -> None:
        _set_attribute(self._attributes, "Organization", "status", value, OrganizationStatus, "")


    @property
    def trial_end_date(self) -> datetime:
        """Trial end date."""
        return self._attributes["trial_end_date"]


    @trial_end_date.setter
    def trial_end_date(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Organization", "trial_end_date", value, datetime, "")


    @property
    def trial_credits(self) -> int:
        """Trial credits."""
        return self._attributes["trial_credits"]


    @trial_credits.setter
    def trial_credits(self, value: int) -> None:
        _set_attribute(self._attributes, "Organization", "trial_credits", value, int, "")


    @property
    def trial_credits_used(self) -> int:
        """Trial credits used."""
        return self._attributes["trial_credits_used"]


    @trial_credits_used.setter
    def trial_credits_used(self, value: int) -> None:
        _set_attribute(self._attributes, "Organization", "trial_credits_used", value, int, "")


    @property
    def show_plan(self) -> bool:
        """Show plan."""
        return self._attributes["show_plan"]


    @show_plan.setter
    def show_plan(self, value: bool) -> None:
        _set_attribute(self._attributes, "Organization", "show_plan", value, bool, "")


    @property
    def sso_enabled(self) -> bool:
        """Sso enabled."""
        return self._attributes["sso_enabled"]


    @sso_enabled.setter
    def sso_enabled(self, value: bool) -> None:
        _set_attribute(self._attributes, "Organization", "sso_enabled", value, bool, "")


    @property
    def requires_sso(self) -> bool:
        """Requires sso."""
        return self._attributes["requires_sso"]


    @requires_sso.setter
    def requires_sso(self, value: bool) -> None:
        _set_attribute(self._attributes, "Organization", "requires_sso", value, bool, "")


    @property
    def sso_domains(self) -> List[str]:
        """Sso domains."""
        return self._attributes["sso_domains"]


    @sso_domains.setter
    def sso_domains(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "Organization", "sso_domains", value, List[str], "")


    @property
    def allow_external_users(self) -> bool:
        """Allow external users."""
        return self._attributes["allow_external_users"]


    @allow_external_users.setter
    def allow_external_users(self, value: bool) -> None:
        _set_attribute(self._attributes, "Organization", "allow_external_users", value, bool, "")


    @property
    def sso_configured(self) -> bool:
        """Sso configured."""
        return self._attributes["sso_configured"]


    @sso_configured.setter
    def sso_configured(self, value: bool) -> None:
        _set_attribute(self._attributes, "Organization", "sso_configured", value, bool, "")


    @property
    def directory_sync_configured(self) -> bool:
        """Directory sync configured."""
        return self._attributes["directory_sync_configured"]


    @directory_sync_configured.setter
    def directory_sync_configured(self, value: bool) -> None:
        _set_attribute(self._attributes, "Organization", "directory_sync_configured", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Organization, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Organization:
        """Convert object to proto representation."""
        return management_types_pb2.Organization(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Organization object " + repr(self.to_dict()) + ">"


class Onboarding:
    """Onboarding."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , create_time: datetime = None
        , update_time: datetime = None
        , project_created: bool = False
        , model_created: bool = False
        , feature_set_created: bool = False
        , billing_setup: bool = False
        , dismissed: bool = False
    , **kwargs) -> Onboarding:
        self._attributes = dict()
        self.name = name
        self.create_time = create_time
        self.update_time = update_time
        self.project_created = project_created
        self.model_created = model_created
        self.feature_set_created = feature_set_created
        self.billing_setup = billing_setup
        self.dismissed = dismissed

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Onboarding", "name", value, str, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Onboarding", "create_time", value, datetime, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Onboarding", "update_time", value, datetime, "")


    @property
    def project_created(self) -> bool:
        """Project created."""
        return self._attributes["project_created"]


    @project_created.setter
    def project_created(self, value: bool) -> None:
        _set_attribute(self._attributes, "Onboarding", "project_created", value, bool, "")


    @property
    def model_created(self) -> bool:
        """Model created."""
        return self._attributes["model_created"]


    @model_created.setter
    def model_created(self, value: bool) -> None:
        _set_attribute(self._attributes, "Onboarding", "model_created", value, bool, "")


    @property
    def feature_set_created(self) -> bool:
        """Feature set created."""
        return self._attributes["feature_set_created"]


    @feature_set_created.setter
    def feature_set_created(self, value: bool) -> None:
        _set_attribute(self._attributes, "Onboarding", "feature_set_created", value, bool, "")


    @property
    def billing_setup(self) -> bool:
        """Billing setup."""
        return self._attributes["billing_setup"]


    @billing_setup.setter
    def billing_setup(self, value: bool) -> None:
        _set_attribute(self._attributes, "Onboarding", "billing_setup", value, bool, "")


    @property
    def dismissed(self) -> bool:
        """Dismissed."""
        return self._attributes["dismissed"]


    @dismissed.setter
    def dismissed(self, value: bool) -> None:
        _set_attribute(self._attributes, "Onboarding", "dismissed", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Onboarding, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Onboarding:
        """Convert object to proto representation."""
        return management_types_pb2.Onboarding(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Onboarding object " + repr(self.to_dict()) + ">"


class Project:
    """Project."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , display_name: str = ""
        , organization: str = ""
        , summary: ProjectSummary = None
        , update_time: datetime = None
        , create_time: datetime = None
        , default_environment: str = ""
    , **kwargs) -> Project:
        self._attributes = dict()
        self.name = name
        self.display_name = display_name
        self.organization = organization
        self.summary = summary
        self.update_time = update_time
        self.create_time = create_time
        self.default_environment = default_environment

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """/ Project resource name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Project", "name", value, str, "")


    @property
    def display_name(self) -> str:
        """/ Display name."""
        return self._attributes["display_name"]


    @display_name.setter
    def display_name(self, value: str) -> None:
        _set_attribute(self._attributes, "Project", "display_name", value, str, "")


    @property
    def organization(self) -> str:
        """Organization."""
        return self._attributes["organization"]


    @organization.setter
    def organization(self, value: str) -> None:
        _set_attribute(self._attributes, "Project", "organization", value, str, "")


    @property
    def summary(self) -> ProjectSummary:
        """Summary."""
        return self._attributes["summary"]


    @summary.setter
    def summary(self, value: ProjectSummary) -> None:
        _set_attribute(self._attributes, "Project", "summary", value, ProjectSummary, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Project", "update_time", value, datetime, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Project", "create_time", value, datetime, "")


    @property
    def default_environment(self) -> str:
        """Default environment."""
        return self._attributes["default_environment"]


    @default_environment.setter
    def default_environment(self, value: str) -> None:
        _set_attribute(self._attributes, "Project", "default_environment", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Project, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Project:
        """Convert object to proto representation."""
        return management_types_pb2.Project(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Project object " + repr(self.to_dict()) + ">"


class ProjectSummary:
    """Project summary statistics."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , feature_set_count: int = 0
        , feature_set_row_count: int = 0
        , feature_set_bytes: int = 0
        , feature_count: int = 0
        , connection_count: int = 0
        , model_count: int = 0
        , model_version_count: int = 0
        , experiment_count: int = 0
        , prediction_count: int = 0
        , feature_set_health: HealthCounts = None
        , model_health: HealthCounts = None
        , last_deployment_time: datetime = None
        , last_training_time: datetime = None
    , **kwargs) -> ProjectSummary:
        self._attributes = dict()
        self.feature_set_count = feature_set_count
        self.feature_set_row_count = feature_set_row_count
        self.feature_set_bytes = feature_set_bytes
        self.feature_count = feature_count
        self.connection_count = connection_count
        self.model_count = model_count
        self.model_version_count = model_version_count
        self.experiment_count = experiment_count
        self.prediction_count = prediction_count
        self.feature_set_health = feature_set_health
        self.model_health = model_health
        self.last_deployment_time = last_deployment_time
        self.last_training_time = last_training_time

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def feature_set_count(self) -> int:
        """Total number of feature sets."""
        return self._attributes["feature_set_count"]


    @feature_set_count.setter
    def feature_set_count(self, value: int) -> None:
        _set_attribute(self._attributes, "ProjectSummary", "feature_set_count", value, int, "")


    @property
    def feature_set_row_count(self) -> int:
        """Total number of feature rows."""
        return self._attributes["feature_set_row_count"]


    @feature_set_row_count.setter
    def feature_set_row_count(self, value: int) -> None:
        _set_attribute(self._attributes, "ProjectSummary", "feature_set_row_count", value, int, "")


    @property
    def feature_set_bytes(self) -> int:
        """Featureset total number of bytes."""
        return self._attributes["feature_set_bytes"]


    @feature_set_bytes.setter
    def feature_set_bytes(self, value: int) -> None:
        _set_attribute(self._attributes, "ProjectSummary", "feature_set_bytes", value, int, "")


    @property
    def feature_count(self) -> int:
        """Total number of unique features."""
        return self._attributes["feature_count"]


    @feature_count.setter
    def feature_count(self, value: int) -> None:
        _set_attribute(self._attributes, "ProjectSummary", "feature_count", value, int, "")


    @property
    def connection_count(self) -> int:
        """Total number of connections."""
        return self._attributes["connection_count"]


    @connection_count.setter
    def connection_count(self, value: int) -> None:
        _set_attribute(self._attributes, "ProjectSummary", "connection_count", value, int, "")


    @property
    def model_count(self) -> int:
        """Total number of models."""
        return self._attributes["model_count"]


    @model_count.setter
    def model_count(self, value: int) -> None:
        _set_attribute(self._attributes, "ProjectSummary", "model_count", value, int, "")


    @property
    def model_version_count(self) -> int:
        """Total number modelVersions."""
        return self._attributes["model_version_count"]


    @model_version_count.setter
    def model_version_count(self, value: int) -> None:
        _set_attribute(self._attributes, "ProjectSummary", "model_version_count", value, int, "")


    @property
    def experiment_count(self) -> int:
        """Total number experiments."""
        return self._attributes["experiment_count"]


    @experiment_count.setter
    def experiment_count(self, value: int) -> None:
        _set_attribute(self._attributes, "ProjectSummary", "experiment_count", value, int, "")


    @property
    def prediction_count(self) -> int:
        """Total number of predictions."""
        return self._attributes["prediction_count"]


    @prediction_count.setter
    def prediction_count(self, value: int) -> None:
        _set_attribute(self._attributes, "ProjectSummary", "prediction_count", value, int, "")


    @property
    def feature_set_health(self) -> HealthCounts:
        """Feature set health."""
        return self._attributes["feature_set_health"]


    @feature_set_health.setter
    def feature_set_health(self, value: HealthCounts) -> None:
        _set_attribute(self._attributes, "ProjectSummary", "feature_set_health", value, HealthCounts, "")


    @property
    def model_health(self) -> HealthCounts:
        """Model health."""
        return self._attributes["model_health"]


    @model_health.setter
    def model_health(self, value: HealthCounts) -> None:
        _set_attribute(self._attributes, "ProjectSummary", "model_health", value, HealthCounts, "")


    @property
    def last_deployment_time(self) -> datetime:
        """Last deployment"""
        return self._attributes["last_deployment_time"]


    @last_deployment_time.setter
    def last_deployment_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ProjectSummary", "last_deployment_time", value, datetime, "")


    @property
    def last_training_time(self) -> datetime:
        """Last training"""
        return self._attributes["last_training_time"]


    @last_training_time.setter
    def last_training_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ProjectSummary", "last_training_time", value, datetime, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.ProjectSummary, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.ProjectSummary:
        """Convert object to proto representation."""
        return management_types_pb2.ProjectSummary(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ProjectSummary object " + repr(self.to_dict()) + ">"


class DataStore:
    """Datastore for feature store."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , type: str = ""
        , big_query: DataStoreBigQuery = None
        , snowflake: DataStoreSnowflake = None
        , postgres: DataStorePostgres = None
        , redshift: DataStoreRedshift = None
        , databricks: DataStoreDatabricks = None
        , is_demo_data_store: bool = False
    , **kwargs) -> DataStore:
        self._attributes = dict()
        self.type = type
        self.big_query = big_query
        self.snowflake = snowflake
        self.postgres = postgres
        self.redshift = redshift
        self.databricks = databricks
        self.is_demo_data_store = is_demo_data_store

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def type(self) -> str:
        """Type of connection. Eg. snowflake, continual"""
        return self._attributes["type"]


    @type.setter
    def type(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStore", "type", value, str, "")


    @property
    def big_query(self) -> DataStoreBigQuery:
        """Big query."""
        return self._attributes["big_query"]


    @big_query.setter
    def big_query(self, value: DataStoreBigQuery) -> None:
        _set_attribute(self._attributes, "DataStore", "big_query", value, DataStoreBigQuery, "config")


    @property
    def snowflake(self) -> DataStoreSnowflake:
        """Snowflake."""
        return self._attributes["snowflake"]


    @snowflake.setter
    def snowflake(self, value: DataStoreSnowflake) -> None:
        _set_attribute(self._attributes, "DataStore", "snowflake", value, DataStoreSnowflake, "config")


    @property
    def postgres(self) -> DataStorePostgres:
        """Postgres."""
        return self._attributes["postgres"]


    @postgres.setter
    def postgres(self, value: DataStorePostgres) -> None:
        _set_attribute(self._attributes, "DataStore", "postgres", value, DataStorePostgres, "config")


    @property
    def redshift(self) -> DataStoreRedshift:
        """Redshift."""
        return self._attributes["redshift"]


    @redshift.setter
    def redshift(self, value: DataStoreRedshift) -> None:
        _set_attribute(self._attributes, "DataStore", "redshift", value, DataStoreRedshift, "config")


    @property
    def databricks(self) -> DataStoreDatabricks:
        """Databricks."""
        return self._attributes["databricks"]


    @databricks.setter
    def databricks(self, value: DataStoreDatabricks) -> None:
        _set_attribute(self._attributes, "DataStore", "databricks", value, DataStoreDatabricks, "config")


    @property
    def is_demo_data_store(self) -> bool:
        """Is demo data store."""
        return self._attributes["is_demo_data_store"]


    @is_demo_data_store.setter
    def is_demo_data_store(self, value: bool) -> None:
        _set_attribute(self._attributes, "DataStore", "is_demo_data_store", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.DataStore, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.DataStore:
        """Convert object to proto representation."""
        return management_types_pb2.DataStore(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DataStore object " + repr(self.to_dict()) + ">"


class DataStoreBigQuery:
    """Data store big query."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , auth_file: str = ""
        , auth_file_name: str = ""
        , dataset: str = ""
        , location: str = ""
    , **kwargs) -> DataStoreBigQuery:
        self._attributes = dict()
        self.auth_file = auth_file
        self.auth_file_name = auth_file_name
        self.dataset = dataset
        self.location = location

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def auth_file(self) -> str:
        """Auth file."""
        return self._attributes["auth_file"]


    @auth_file.setter
    def auth_file(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreBigQuery", "auth_file", value, str, "")


    @property
    def auth_file_name(self) -> str:
        """Auth file name."""
        return self._attributes["auth_file_name"]


    @auth_file_name.setter
    def auth_file_name(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreBigQuery", "auth_file_name", value, str, "")


    @property
    def dataset(self) -> str:
        """Dataset."""
        return self._attributes["dataset"]


    @dataset.setter
    def dataset(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreBigQuery", "dataset", value, str, "")


    @property
    def location(self) -> str:
        """Location."""
        return self._attributes["location"]


    @location.setter
    def location(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreBigQuery", "location", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.DataStore.BigQuery, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.DataStore.BigQuery:
        """Convert object to proto representation."""
        return management_types_pb2.DataStore.BigQuery(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DataStoreBigQuery object " + repr(self.to_dict()) + ">"


class DataStoreSnowflake:
    """Data store snowflake."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , host: str = ""
        , port: int = 0
        , username: str = ""
        , password: str = ""
        , database: str = ""
        , warehouse: str = ""
        , role: str = ""
        , params: Dict[str, str] = None
        , db_schema: str = ""
    , **kwargs) -> DataStoreSnowflake:
        self._attributes = dict()
        self.host = host
        self.port = port
        self.username = username
        self.password = password
        self.database = database
        self.warehouse = warehouse
        self.role = role
        self.params = params
        self.db_schema = db_schema

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def host(self) -> str:
        """Host."""
        return self._attributes["host"]


    @host.setter
    def host(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreSnowflake", "host", value, str, "")


    @property
    def port(self) -> int:
        """Port."""
        return self._attributes["port"]


    @port.setter
    def port(self, value: int) -> None:
        _set_attribute(self._attributes, "DataStoreSnowflake", "port", value, int, "")


    @property
    def username(self) -> str:
        """Username."""
        return self._attributes["username"]


    @username.setter
    def username(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreSnowflake", "username", value, str, "")


    @property
    def password(self) -> str:
        """Password."""
        return self._attributes["password"]


    @password.setter
    def password(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreSnowflake", "password", value, str, "")


    @property
    def database(self) -> str:
        """Database."""
        return self._attributes["database"]


    @database.setter
    def database(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreSnowflake", "database", value, str, "")


    @property
    def warehouse(self) -> str:
        """Warehouse."""
        return self._attributes["warehouse"]


    @warehouse.setter
    def warehouse(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreSnowflake", "warehouse", value, str, "")


    @property
    def role(self) -> str:
        """Role."""
        return self._attributes["role"]


    @role.setter
    def role(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreSnowflake", "role", value, str, "")


    @property
    def params(self) -> Dict[str, str]:
        """Params."""
        return self._attributes["params"]


    @params.setter
    def params(self, value: Dict[str, str]) -> None:
        _set_attribute(self._attributes, "DataStoreSnowflake", "params", value, Dict[str, str], "")


    @property
    def db_schema(self) -> str:
        """Db schema."""
        return self._attributes["db_schema"]


    @db_schema.setter
    def db_schema(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreSnowflake", "db_schema", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.DataStore.Snowflake, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.DataStore.Snowflake:
        """Convert object to proto representation."""
        return management_types_pb2.DataStore.Snowflake(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DataStoreSnowflake object " + repr(self.to_dict()) + ">"


class DataStorePostgres:
    """Data store postgres."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , host: str = ""
        , port: int = 0
        , username: str = ""
        , password: str = ""
        , database: str = ""
        , params: Dict[str, str] = None
        , db_schema: str = ""
    , **kwargs) -> DataStorePostgres:
        self._attributes = dict()
        self.host = host
        self.port = port
        self.username = username
        self.password = password
        self.database = database
        self.params = params
        self.db_schema = db_schema

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def host(self) -> str:
        """Host."""
        return self._attributes["host"]


    @host.setter
    def host(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStorePostgres", "host", value, str, "")


    @property
    def port(self) -> int:
        """Port."""
        return self._attributes["port"]


    @port.setter
    def port(self, value: int) -> None:
        _set_attribute(self._attributes, "DataStorePostgres", "port", value, int, "")


    @property
    def username(self) -> str:
        """Username."""
        return self._attributes["username"]


    @username.setter
    def username(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStorePostgres", "username", value, str, "")


    @property
    def password(self) -> str:
        """Password."""
        return self._attributes["password"]


    @password.setter
    def password(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStorePostgres", "password", value, str, "")


    @property
    def database(self) -> str:
        """Database."""
        return self._attributes["database"]


    @database.setter
    def database(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStorePostgres", "database", value, str, "")


    @property
    def params(self) -> Dict[str, str]:
        """Params."""
        return self._attributes["params"]


    @params.setter
    def params(self, value: Dict[str, str]) -> None:
        _set_attribute(self._attributes, "DataStorePostgres", "params", value, Dict[str, str], "")


    @property
    def db_schema(self) -> str:
        """Db schema."""
        return self._attributes["db_schema"]


    @db_schema.setter
    def db_schema(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStorePostgres", "db_schema", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.DataStore.Postgres, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.DataStore.Postgres:
        """Convert object to proto representation."""
        return management_types_pb2.DataStore.Postgres(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DataStorePostgres object " + repr(self.to_dict()) + ">"


class DataStoreRedshift:
    """Data store redshift."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , host: str = ""
        , port: int = 0
        , username: str = ""
        , password: str = ""
        , database: str = ""
        , params: Dict[str, str] = None
        , db_schema: str = ""
    , **kwargs) -> DataStoreRedshift:
        self._attributes = dict()
        self.host = host
        self.port = port
        self.username = username
        self.password = password
        self.database = database
        self.params = params
        self.db_schema = db_schema

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def host(self) -> str:
        """Host."""
        return self._attributes["host"]


    @host.setter
    def host(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreRedshift", "host", value, str, "")


    @property
    def port(self) -> int:
        """Port."""
        return self._attributes["port"]


    @port.setter
    def port(self, value: int) -> None:
        _set_attribute(self._attributes, "DataStoreRedshift", "port", value, int, "")


    @property
    def username(self) -> str:
        """Username."""
        return self._attributes["username"]


    @username.setter
    def username(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreRedshift", "username", value, str, "")


    @property
    def password(self) -> str:
        """Password."""
        return self._attributes["password"]


    @password.setter
    def password(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreRedshift", "password", value, str, "")


    @property
    def database(self) -> str:
        """Database."""
        return self._attributes["database"]


    @database.setter
    def database(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreRedshift", "database", value, str, "")


    @property
    def params(self) -> Dict[str, str]:
        """Params."""
        return self._attributes["params"]


    @params.setter
    def params(self, value: Dict[str, str]) -> None:
        _set_attribute(self._attributes, "DataStoreRedshift", "params", value, Dict[str, str], "")


    @property
    def db_schema(self) -> str:
        """Db schema."""
        return self._attributes["db_schema"]


    @db_schema.setter
    def db_schema(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreRedshift", "db_schema", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.DataStore.Redshift, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.DataStore.Redshift:
        """Convert object to proto representation."""
        return management_types_pb2.DataStore.Redshift(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DataStoreRedshift object " + repr(self.to_dict()) + ">"


class DataStoreDatabricks:
    """Data store databricks."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , host: str = ""
        , port: int = 0
        , token: str = ""
        , http_path: str = ""
        , database: str = ""
        , params: Dict[str, str] = None
        , db_schema: str = ""
    , **kwargs) -> DataStoreDatabricks:
        self._attributes = dict()
        self.host = host
        self.port = port
        self.token = token
        self.http_path = http_path
        self.database = database
        self.params = params
        self.db_schema = db_schema

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def host(self) -> str:
        """Host."""
        return self._attributes["host"]


    @host.setter
    def host(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreDatabricks", "host", value, str, "")


    @property
    def port(self) -> int:
        """Port."""
        return self._attributes["port"]


    @port.setter
    def port(self, value: int) -> None:
        _set_attribute(self._attributes, "DataStoreDatabricks", "port", value, int, "")


    @property
    def token(self) -> str:
        """Token."""
        return self._attributes["token"]


    @token.setter
    def token(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreDatabricks", "token", value, str, "")


    @property
    def http_path(self) -> str:
        """Http path."""
        return self._attributes["http_path"]


    @http_path.setter
    def http_path(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreDatabricks", "http_path", value, str, "")


    @property
    def database(self) -> str:
        """Database."""
        return self._attributes["database"]


    @database.setter
    def database(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreDatabricks", "database", value, str, "")


    @property
    def params(self) -> Dict[str, str]:
        """Params."""
        return self._attributes["params"]


    @params.setter
    def params(self, value: Dict[str, str]) -> None:
        _set_attribute(self._attributes, "DataStoreDatabricks", "params", value, Dict[str, str], "")


    @property
    def db_schema(self) -> str:
        """Db schema."""
        return self._attributes["db_schema"]


    @db_schema.setter
    def db_schema(self, value: str) -> None:
        _set_attribute(self._attributes, "DataStoreDatabricks", "db_schema", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.DataStore.Databricks, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.DataStore.Databricks:
        """Convert object to proto representation."""
        return management_types_pb2.DataStore.Databricks(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DataStoreDatabricks object " + repr(self.to_dict()) + ">"


class HealthCounts:
    """Health counts (healthy, unhealthy, critical)."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , healthy_count: int = 0
        , unhealthy_count: int = 0
        , critical_count: int = 0
    , **kwargs) -> HealthCounts:
        self._attributes = dict()
        self.healthy_count = healthy_count
        self.unhealthy_count = unhealthy_count
        self.critical_count = critical_count

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def healthy_count(self) -> int:
        """Total number in healthy state."""
        return self._attributes["healthy_count"]


    @healthy_count.setter
    def healthy_count(self, value: int) -> None:
        _set_attribute(self._attributes, "HealthCounts", "healthy_count", value, int, "")


    @property
    def unhealthy_count(self) -> int:
        """Total number in unhealthy state."""
        return self._attributes["unhealthy_count"]


    @unhealthy_count.setter
    def unhealthy_count(self, value: int) -> None:
        _set_attribute(self._attributes, "HealthCounts", "unhealthy_count", value, int, "")


    @property
    def critical_count(self) -> int:
        """Total number in critical state."""
        return self._attributes["critical_count"]


    @critical_count.setter
    def critical_count(self, value: int) -> None:
        _set_attribute(self._attributes, "HealthCounts", "critical_count", value, int, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.HealthCounts, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.HealthCounts:
        """Convert object to proto representation."""
        return management_types_pb2.HealthCounts(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<HealthCounts object " + repr(self.to_dict()) + ">"


class Environment:
    """Environment."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , summary: ProjectSummary = None
        , data_store: DataStore = None
        , update_time: datetime = None
        , create_time: datetime = None
        , scheduling_enabled: bool = False
        , source: str = ""
        , env_type: str = ""
        , is_protected: bool = False
        , is_ephemeral: bool = False
    , **kwargs) -> Environment:
        self._attributes = dict()
        self.name = name
        self.summary = summary
        self.data_store = data_store
        self.update_time = update_time
        self.create_time = create_time
        self.scheduling_enabled = scheduling_enabled
        self.source = source
        self.env_type = env_type
        self.is_protected = is_protected
        self.is_ephemeral = is_ephemeral

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """/ Environment resource name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Environment", "name", value, str, "")


    @property
    def summary(self) -> ProjectSummary:
        """Summary."""
        return self._attributes["summary"]


    @summary.setter
    def summary(self, value: ProjectSummary) -> None:
        _set_attribute(self._attributes, "Environment", "summary", value, ProjectSummary, "")


    @property
    def data_store(self) -> DataStore:
        """Data store."""
        return self._attributes["data_store"]


    @data_store.setter
    def data_store(self, value: DataStore) -> None:
        _set_attribute(self._attributes, "Environment", "data_store", value, DataStore, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Environment", "update_time", value, datetime, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Environment", "create_time", value, datetime, "")


    @property
    def scheduling_enabled(self) -> bool:
        """if scheduled tasts are enabled in this environment."""
        return self._attributes["scheduling_enabled"]


    @scheduling_enabled.setter
    def scheduling_enabled(self, value: bool) -> None:
        _set_attribute(self._attributes, "Environment", "scheduling_enabled", value, bool, "")


    @property
    def source(self) -> str:
        """An environment or project that this environment was created from."""
        return self._attributes["source"]


    @source.setter
    def source(self, value: str) -> None:
        _set_attribute(self._attributes, "Environment", "source", value, str, "")


    @property
    def env_type(self) -> str:
        """The "role" of this environment in the workflow: unspecified, main, trunk, dev, code_review, etc."""
        return self._attributes["env_type"]


    @env_type.setter
    def env_type(self, value: str) -> None:
        _set_attribute(self._attributes, "Environment", "env_type", value, str, "")


    @property
    def is_protected(self) -> bool:
        """Whether this environment is protected. A protected environment can only be pushed to by CI/CD when connected."""
        return self._attributes["is_protected"]


    @is_protected.setter
    def is_protected(self, value: bool) -> None:
        _set_attribute(self._attributes, "Environment", "is_protected", value, bool, "")


    @property
    def is_ephemeral(self) -> bool:
        """Whether this environment is ephemeral. Ephemeral environments are automated, isolated, protected, and short-lived."""
        return self._attributes["is_ephemeral"]


    @is_ephemeral.setter
    def is_ephemeral(self, value: bool) -> None:
        _set_attribute(self._attributes, "Environment", "is_ephemeral", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Environment, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Environment:
        """Convert object to proto representation."""
        return management_types_pb2.Environment(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Environment object " + repr(self.to_dict()) + ">"


class FeatureSet:
    """FeatureSet object."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , schema_text: str = ""
        , create_time: datetime = None
        , update_time: datetime = None
        , table: str = ""
    , **kwargs) -> FeatureSet:
        self._attributes = dict()
        self.name = name
        self.schema_text = schema_text
        self.create_time = create_time
        self.update_time = update_time
        self.table = table

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Fully qualified and versioned FeatureSet name including version.
 Example: projects/:project/featureset/:featureset@:version"""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "FeatureSet", "name", value, str, "")


    @property
    def schema_text(self) -> str:
        """Feature set schema YAML representation."""
        return self._attributes["schema_text"]


    @schema_text.setter
    def schema_text(self, value: str) -> None:
        _set_attribute(self._attributes, "FeatureSet", "schema_text", value, str, "")


    @property
    def create_time(self) -> datetime:
        """Time feature set version created."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "FeatureSet", "create_time", value, datetime, "")


    @property
    def update_time(self) -> datetime:
        """Time feature set was updated."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "FeatureSet", "update_time", value, datetime, "")


    @property
    def table(self) -> str:
        """Table."""
        return self._attributes["table"]


    @table.setter
    def table(self, value: str) -> None:
        _set_attribute(self._attributes, "FeatureSet", "table", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.FeatureSet, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.FeatureSet:
        """Convert object to proto representation."""
        return management_types_pb2.FeatureSet(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<FeatureSet object " + repr(self.to_dict()) + ">"


class Event:
    """Event captures and activity event."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , subject: str = ""
        , event: str = ""
        , resource: str = ""
        , severity: str = ""
        , message: str = ""
        , data: Dict[str, str] = None
        , create_time: datetime = None
        , notify: bool = False
    , **kwargs) -> Event:
        self._attributes = dict()
        self.name = name
        self.subject = subject
        self.event = event
        self.resource = resource
        self.severity = severity
        self.message = message
        self.data = data
        self.create_time = create_time
        self.notify = notify

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Unique name for event."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Event", "name", value, str, "")


    @property
    def subject(self) -> str:
        """User or account that took action."""
        return self._attributes["subject"]


    @subject.setter
    def subject(self, value: str) -> None:
        _set_attribute(self._attributes, "Event", "subject", value, str, "")


    @property
    def event(self) -> str:
        """Event type."""
        return self._attributes["event"]


    @event.setter
    def event(self, value: str) -> None:
        _set_attribute(self._attributes, "Event", "event", value, str, "")


    @property
    def resource(self) -> str:
        """Resource on which the action was taken."""
        return self._attributes["resource"]


    @resource.setter
    def resource(self, value: str) -> None:
        _set_attribute(self._attributes, "Event", "resource", value, str, "")


    @property
    def severity(self) -> str:
        """Severity level."""
        return self._attributes["severity"]


    @severity.setter
    def severity(self, value: str) -> None:
        _set_attribute(self._attributes, "Event", "severity", value, str, "")


    @property
    def message(self) -> str:
        """Human readable message."""
        return self._attributes["message"]


    @message.setter
    def message(self, value: str) -> None:
        _set_attribute(self._attributes, "Event", "message", value, str, "")


    @property
    def data(self) -> Dict[str, str]:
        """Extra data."""
        return self._attributes["data"]


    @data.setter
    def data(self, value: Dict[str, str]) -> None:
        _set_attribute(self._attributes, "Event", "data", value, Dict[str, str], "")


    @property
    def create_time(self) -> datetime:
        """Event time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Event", "create_time", value, datetime, "")


    @property
    def notify(self) -> bool:
        """if true send notification"""
        return self._attributes["notify"]


    @notify.setter
    def notify(self, value: bool) -> None:
        _set_attribute(self._attributes, "Event", "notify", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Event, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Event:
        """Convert object to proto representation."""
        return management_types_pb2.Event(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Event object " + repr(self.to_dict()) + ">"


class ServingMetric:
    """Serving metric."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , model: str = ""
        , parent: str = ""
        , tag: str = ""
        , request_start_time: datetime = None
        , model_start_time: datetime = None
        , request_duration: timedelta = None
        , route_duration: timedelta = None
        , feature_duration: timedelta = None
        , predict_duration: timedelta = None
        , model_duration: timedelta = None
        , model_version: str = ""
        , result_code: str = ""
        , result_data: str = ""
    , **kwargs) -> ServingMetric:
        self._attributes = dict()
        self.model = model
        self.parent = parent
        self.tag = tag
        self.request_start_time = request_start_time
        self.model_start_time = model_start_time
        self.request_duration = request_duration
        self.route_duration = route_duration
        self.feature_duration = feature_duration
        self.predict_duration = predict_duration
        self.model_duration = model_duration
        self.model_version = model_version
        self.result_code = result_code
        self.result_data = result_data

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def model(self) -> str:
        """Model."""
        return self._attributes["model"]


    @model.setter
    def model(self, value: str) -> None:
        _set_attribute(self._attributes, "ServingMetric", "model", value, str, "")


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ServingMetric", "parent", value, str, "")


    @property
    def tag(self) -> str:
        """Tag."""
        return self._attributes["tag"]


    @tag.setter
    def tag(self, value: str) -> None:
        _set_attribute(self._attributes, "ServingMetric", "tag", value, str, "")


    @property
    def request_start_time(self) -> datetime:
        """Request start time."""
        return self._attributes["request_start_time"]


    @request_start_time.setter
    def request_start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ServingMetric", "request_start_time", value, datetime, "")


    @property
    def model_start_time(self) -> datetime:
        """Model start time."""
        return self._attributes["model_start_time"]


    @model_start_time.setter
    def model_start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ServingMetric", "model_start_time", value, datetime, "")


    @property
    def request_duration(self) -> timedelta:
        """Request duration."""
        return self._attributes["request_duration"]


    @request_duration.setter
    def request_duration(self, value: timedelta) -> None:
        _set_attribute(self._attributes, "ServingMetric", "request_duration", value, timedelta, "")


    @property
    def route_duration(self) -> timedelta:
        """Route duration."""
        return self._attributes["route_duration"]


    @route_duration.setter
    def route_duration(self, value: timedelta) -> None:
        _set_attribute(self._attributes, "ServingMetric", "route_duration", value, timedelta, "")


    @property
    def feature_duration(self) -> timedelta:
        """Feature duration."""
        return self._attributes["feature_duration"]


    @feature_duration.setter
    def feature_duration(self, value: timedelta) -> None:
        _set_attribute(self._attributes, "ServingMetric", "feature_duration", value, timedelta, "")


    @property
    def predict_duration(self) -> timedelta:
        """Predict duration."""
        return self._attributes["predict_duration"]


    @predict_duration.setter
    def predict_duration(self, value: timedelta) -> None:
        _set_attribute(self._attributes, "ServingMetric", "predict_duration", value, timedelta, "")


    @property
    def model_duration(self) -> timedelta:
        """Model duration."""
        return self._attributes["model_duration"]


    @model_duration.setter
    def model_duration(self, value: timedelta) -> None:
        _set_attribute(self._attributes, "ServingMetric", "model_duration", value, timedelta, "")


    @property
    def model_version(self) -> str:
        """Model version."""
        return self._attributes["model_version"]


    @model_version.setter
    def model_version(self, value: str) -> None:
        _set_attribute(self._attributes, "ServingMetric", "model_version", value, str, "")


    @property
    def result_code(self) -> str:
        """Result code."""
        return self._attributes["result_code"]


    @result_code.setter
    def result_code(self, value: str) -> None:
        _set_attribute(self._attributes, "ServingMetric", "result_code", value, str, "")


    @property
    def result_data(self) -> str:
        """Result data."""
        return self._attributes["result_data"]


    @result_data.setter
    def result_data(self, value: str) -> None:
        _set_attribute(self._attributes, "ServingMetric", "result_data", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.ServingMetric, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.ServingMetric:
        """Convert object to proto representation."""
        return management_types_pb2.ServingMetric(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ServingMetric object " + repr(self.to_dict()) + ">"


class ApiKey:
    """Api key."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , key: str = ""
        , description: str = ""
        , created_by: str = ""
        , create_time: datetime = None
        , last_access_ip: str = ""
        , last_access_time: datetime = None
        , state: ApiKeyState = 0
        , revoked_time: datetime = None
        , revoked_by: str = ""
    , **kwargs) -> ApiKey:
        self._attributes = dict()
        self.name = name
        self.key = key
        self.description = description
        self.created_by = created_by
        self.create_time = create_time
        self.last_access_ip = last_access_ip
        self.last_access_time = last_access_time
        self.state = state
        self.revoked_time = revoked_time
        self.revoked_by = revoked_by

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Api Key resource name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "ApiKey", "name", value, str, "")


    @property
    def key(self) -> str:
        """The Api Key"""
        return self._attributes["key"]


    @key.setter
    def key(self, value: str) -> None:
        _set_attribute(self._attributes, "ApiKey", "key", value, str, "")


    @property
    def description(self) -> str:
        """Description"""
        return self._attributes["description"]


    @description.setter
    def description(self, value: str) -> None:
        _set_attribute(self._attributes, "ApiKey", "description", value, str, "")


    @property
    def created_by(self) -> str:
        """Author"""
        return self._attributes["created_by"]


    @created_by.setter
    def created_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ApiKey", "created_by", value, str, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ApiKey", "create_time", value, datetime, "")


    @property
    def last_access_ip(self) -> str:
        """Last access ip."""
        return self._attributes["last_access_ip"]


    @last_access_ip.setter
    def last_access_ip(self, value: str) -> None:
        _set_attribute(self._attributes, "ApiKey", "last_access_ip", value, str, "")


    @property
    def last_access_time(self) -> datetime:
        """Last access time."""
        return self._attributes["last_access_time"]


    @last_access_time.setter
    def last_access_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ApiKey", "last_access_time", value, datetime, "")


    @property
    def state(self) -> ApiKeyState:
        """Model state."""
        return self._attributes["state"]


    @state.setter
    def state(self, value: ApiKeyState) -> None:
        _set_attribute(self._attributes, "ApiKey", "state", value, ApiKeyState, "")


    @property
    def revoked_time(self) -> datetime:
        """Revoked time."""
        return self._attributes["revoked_time"]


    @revoked_time.setter
    def revoked_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ApiKey", "revoked_time", value, datetime, "")


    @property
    def revoked_by(self) -> str:
        """Revoked by."""
        return self._attributes["revoked_by"]


    @revoked_by.setter
    def revoked_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ApiKey", "revoked_by", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.ApiKey, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.ApiKey:
        """Convert object to proto representation."""
        return management_types_pb2.ApiKey(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ApiKey object " + repr(self.to_dict()) + ">"


class Model:
    """A model represents a machine learning task."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , description: str = ""
        , state: str = ""
        , author: str = ""
        , display_name: str = ""
        , current_version: str = ""
        , create_time: datetime = None
        , update_time: datetime = None
        , latest_model_version: str = ""
        , latest_batch_prediction: str = ""
    , **kwargs) -> Model:
        self._attributes = dict()
        self.name = name
        self.description = description
        self.state = state
        self.author = author
        self.display_name = display_name
        self.current_version = current_version
        self.create_time = create_time
        self.update_time = update_time
        self.latest_model_version = latest_model_version
        self.latest_batch_prediction = latest_batch_prediction

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Model resource name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Model", "name", value, str, "")


    @property
    def description(self) -> str:
        """Description"""
        return self._attributes["description"]


    @description.setter
    def description(self, value: str) -> None:
        _set_attribute(self._attributes, "Model", "description", value, str, "")


    @property
    def state(self) -> str:
        """Model state."""
        return self._attributes["state"]


    @state.setter
    def state(self, value: str) -> None:
        _set_attribute(self._attributes, "Model", "state", value, str, "")


    @property
    def author(self) -> str:
        """Author"""
        return self._attributes["author"]


    @author.setter
    def author(self, value: str) -> None:
        _set_attribute(self._attributes, "Model", "author", value, str, "")


    @property
    def display_name(self) -> str:
        """Name that shows up on UI"""
        return self._attributes["display_name"]


    @display_name.setter
    def display_name(self, value: str) -> None:
        _set_attribute(self._attributes, "Model", "display_name", value, str, "")


    @property
    def current_version(self) -> str:
        """Current version."""
        return self._attributes["current_version"]


    @current_version.setter
    def current_version(self, value: str) -> None:
        _set_attribute(self._attributes, "Model", "current_version", value, str, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Model", "create_time", value, datetime, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Model", "update_time", value, datetime, "")


    @property
    def latest_model_version(self) -> str:
        """Latest model version."""
        return self._attributes["latest_model_version"]


    @latest_model_version.setter
    def latest_model_version(self, value: str) -> None:
        _set_attribute(self._attributes, "Model", "latest_model_version", value, str, "")


    @property
    def latest_batch_prediction(self) -> str:
        """Latest batch prediction."""
        return self._attributes["latest_batch_prediction"]


    @latest_batch_prediction.setter
    def latest_batch_prediction(self, value: str) -> None:
        _set_attribute(self._attributes, "Model", "latest_batch_prediction", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Model, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Model:
        """Convert object to proto representation."""
        return management_types_pb2.Model(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Model object " + repr(self.to_dict()) + ">"


class Promotion:
    """Model Promotion of a particular model version."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , create_time: datetime = None
        , promoted_time: datetime = None
        , demoted_time: datetime = None
        , model_version: str = ""
        , base_model_version: str = ""
        , state: PromotionState = 0
        , improvement_metric: str = ""
        , improvement_metric_value: float = 0.0
        , base_improvement_metric_value: float = 0.0
        , improvement_metric_diff: float = 0.0
        , reason: str = ""
        , message: str = ""
        , account: str = ""
        , run_name: str = ""
    , **kwargs) -> Promotion:
        self._attributes = dict()
        self.name = name
        self.create_time = create_time
        self.promoted_time = promoted_time
        self.demoted_time = demoted_time
        self.model_version = model_version
        self.base_model_version = base_model_version
        self.state = state
        self.improvement_metric = improvement_metric
        self.improvement_metric_value = improvement_metric_value
        self.base_improvement_metric_value = base_improvement_metric_value
        self.improvement_metric_diff = improvement_metric_diff
        self.reason = reason
        self.message = message
        self.account = account
        self.run_name = run_name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Fully qualified name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Promotion", "name", value, str, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Promotion", "create_time", value, datetime, "")


    @property
    def promoted_time(self) -> datetime:
        """When the model was promoted."""
        return self._attributes["promoted_time"]


    @promoted_time.setter
    def promoted_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Promotion", "promoted_time", value, datetime, "")


    @property
    def demoted_time(self) -> datetime:
        """When the model was demoted."""
        return self._attributes["demoted_time"]


    @demoted_time.setter
    def demoted_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Promotion", "demoted_time", value, datetime, "")


    @property
    def model_version(self) -> str:
        """Fully qualified model version name."""
        return self._attributes["model_version"]


    @model_version.setter
    def model_version(self, value: str) -> None:
        _set_attribute(self._attributes, "Promotion", "model_version", value, str, "")


    @property
    def base_model_version(self) -> str:
        """Base model version."""
        return self._attributes["base_model_version"]


    @base_model_version.setter
    def base_model_version(self, value: str) -> None:
        _set_attribute(self._attributes, "Promotion", "base_model_version", value, str, "")


    @property
    def state(self) -> PromotionState:
        """Current state"""
        return self._attributes["state"]


    @state.setter
    def state(self, value: PromotionState) -> None:
        _set_attribute(self._attributes, "Promotion", "state", value, PromotionState, "")


    @property
    def improvement_metric(self) -> str:
        """Improvement of metric (e.g. RMSE, accuracy, precision)"""
        return self._attributes["improvement_metric"]


    @improvement_metric.setter
    def improvement_metric(self, value: str) -> None:
        _set_attribute(self._attributes, "Promotion", "improvement_metric", value, str, "")


    @property
    def improvement_metric_value(self) -> float:
        """Improvement of metric value (model_version - current promoted model if any, otherwise 0)"""
        return self._attributes["improvement_metric_value"]


    @improvement_metric_value.setter
    def improvement_metric_value(self, value: float) -> None:
        _set_attribute(self._attributes, "Promotion", "improvement_metric_value", value, float, "")


    @property
    def base_improvement_metric_value(self) -> float:
        """Base improvement metric value."""
        return self._attributes["base_improvement_metric_value"]


    @base_improvement_metric_value.setter
    def base_improvement_metric_value(self, value: float) -> None:
        _set_attribute(self._attributes, "Promotion", "base_improvement_metric_value", value, float, "")


    @property
    def improvement_metric_diff(self) -> float:
        """Improvement metric diff."""
        return self._attributes["improvement_metric_diff"]


    @improvement_metric_diff.setter
    def improvement_metric_diff(self, value: float) -> None:
        _set_attribute(self._attributes, "Promotion", "improvement_metric_diff", value, float, "")


    @property
    def reason(self) -> str:
        """Reason."""
        return self._attributes["reason"]


    @reason.setter
    def reason(self, value: str) -> None:
        _set_attribute(self._attributes, "Promotion", "reason", value, str, "")


    @property
    def message(self) -> str:
        """Message."""
        return self._attributes["message"]


    @message.setter
    def message(self, value: str) -> None:
        _set_attribute(self._attributes, "Promotion", "message", value, str, "")


    @property
    def account(self) -> str:
        """user or system account initiating promotion"""
        return self._attributes["account"]


    @account.setter
    def account(self, value: str) -> None:
        _set_attribute(self._attributes, "Promotion", "account", value, str, "")


    @property
    def run_name(self) -> str:
        """Run name."""
        return self._attributes["run_name"]


    @run_name.setter
    def run_name(self, value: str) -> None:
        _set_attribute(self._attributes, "Promotion", "run_name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Promotion, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Promotion:
        """Convert object to proto representation."""
        return management_types_pb2.Promotion(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Promotion object " + repr(self.to_dict()) + ">"


class ModelVersion:
    """A model version represents a particular trained model version."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , run_name: str = ""
        , experiment_name: str = ""
        , state: ModelVersionState = 0
        , error_message: str = ""
        , stack_trace: str = ""
        , create_time: datetime = None
        , update_time: datetime = None
        , start_time: datetime = None
        , end_time: datetime = None
        , training_row_count: int = 0
        , validation_row_count: int = 0
        , test_row_count: int = 0
        , performance_metric: str = ""
        , performance_metric_val: float = 0.0
        , promotion: str = ""
        , promoted: bool = False
    , **kwargs) -> ModelVersion:
        self._attributes = dict()
        self.name = name
        self.run_name = run_name
        self.experiment_name = experiment_name
        self.state = state
        self.error_message = error_message
        self.stack_trace = stack_trace
        self.create_time = create_time
        self.update_time = update_time
        self.start_time = start_time
        self.end_time = end_time
        self.training_row_count = training_row_count
        self.validation_row_count = validation_row_count
        self.test_row_count = test_row_count
        self.performance_metric = performance_metric
        self.performance_metric_val = performance_metric_val
        self.promotion = promotion
        self.promoted = promoted

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "ModelVersion", "name", value, str, "")


    @property
    def run_name(self) -> str:
        """Run name."""
        return self._attributes["run_name"]


    @run_name.setter
    def run_name(self, value: str) -> None:
        _set_attribute(self._attributes, "ModelVersion", "run_name", value, str, "")


    @property
    def experiment_name(self) -> str:
        """Experiment name."""
        return self._attributes["experiment_name"]


    @experiment_name.setter
    def experiment_name(self, value: str) -> None:
        _set_attribute(self._attributes, "ModelVersion", "experiment_name", value, str, "")


    @property
    def state(self) -> ModelVersionState:
        """State."""
        return self._attributes["state"]


    @state.setter
    def state(self, value: ModelVersionState) -> None:
        _set_attribute(self._attributes, "ModelVersion", "state", value, ModelVersionState, "")


    @property
    def error_message(self) -> str:
        """Error message."""
        return self._attributes["error_message"]


    @error_message.setter
    def error_message(self, value: str) -> None:
        _set_attribute(self._attributes, "ModelVersion", "error_message", value, str, "")


    @property
    def stack_trace(self) -> str:
        """Stack trace."""
        return self._attributes["stack_trace"]


    @stack_trace.setter
    def stack_trace(self, value: str) -> None:
        _set_attribute(self._attributes, "ModelVersion", "stack_trace", value, str, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ModelVersion", "create_time", value, datetime, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ModelVersion", "update_time", value, datetime, "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ModelVersion", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ModelVersion", "end_time", value, datetime, "")


    @property
    def training_row_count(self) -> int:
        """Training row count."""
        return self._attributes["training_row_count"]


    @training_row_count.setter
    def training_row_count(self, value: int) -> None:
        _set_attribute(self._attributes, "ModelVersion", "training_row_count", value, int, "")


    @property
    def validation_row_count(self) -> int:
        """Validation row count."""
        return self._attributes["validation_row_count"]


    @validation_row_count.setter
    def validation_row_count(self, value: int) -> None:
        _set_attribute(self._attributes, "ModelVersion", "validation_row_count", value, int, "")


    @property
    def test_row_count(self) -> int:
        """Test row count."""
        return self._attributes["test_row_count"]


    @test_row_count.setter
    def test_row_count(self, value: int) -> None:
        _set_attribute(self._attributes, "ModelVersion", "test_row_count", value, int, "")


    @property
    def performance_metric(self) -> str:
        """Performance metric."""
        return self._attributes["performance_metric"]


    @performance_metric.setter
    def performance_metric(self, value: str) -> None:
        _set_attribute(self._attributes, "ModelVersion", "performance_metric", value, str, "")


    @property
    def performance_metric_val(self) -> float:
        """Performance metric val."""
        return self._attributes["performance_metric_val"]


    @performance_metric_val.setter
    def performance_metric_val(self, value: float) -> None:
        _set_attribute(self._attributes, "ModelVersion", "performance_metric_val", value, float, "")


    @property
    def promotion(self) -> str:
        """Promotion."""
        return self._attributes["promotion"]


    @promotion.setter
    def promotion(self, value: str) -> None:
        _set_attribute(self._attributes, "ModelVersion", "promotion", value, str, "")


    @property
    def promoted(self) -> bool:
        """Promoted."""
        return self._attributes["promoted"]


    @promoted.setter
    def promoted(self, value: bool) -> None:
        _set_attribute(self._attributes, "ModelVersion", "promoted", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.ModelVersion, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.ModelVersion:
        """Convert object to proto representation."""
        return management_types_pb2.ModelVersion(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ModelVersion object " + repr(self.to_dict()) + ">"


class ConfusionMatrix:
    """Confusion matrix."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , display_name: List[str] = []
        , row: List[ConfusionMatrixRow] = []
    , **kwargs) -> ConfusionMatrix:
        self._attributes = dict()
        self.display_name = display_name
        self.row = row

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def display_name(self) -> List[str]:
        """Display name."""
        return self._attributes["display_name"]


    @display_name.setter
    def display_name(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ConfusionMatrix", "display_name", value, List[str], "")


    @property
    def row(self) -> List[ConfusionMatrixRow]:
        """Row."""
        return self._attributes["row"]


    @row.setter
    def row(self, value: List[ConfusionMatrixRow]) -> None:
        _set_attribute(self._attributes, "ConfusionMatrix", "row", value, List[ConfusionMatrixRow], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.ConfusionMatrix, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.ConfusionMatrix:
        """Convert object to proto representation."""
        return management_types_pb2.ConfusionMatrix(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ConfusionMatrix object " + repr(self.to_dict()) + ">"


class ConfusionMatrixRow:
    """Confusion matrix row."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , example_count: List[int] = []
    , **kwargs) -> ConfusionMatrixRow:
        self._attributes = dict()
        self.example_count = example_count

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def example_count(self) -> List[int]:
        """Example count."""
        return self._attributes["example_count"]


    @example_count.setter
    def example_count(self, value: List[int]) -> None:
        _set_attribute(self._attributes, "ConfusionMatrixRow", "example_count", value, List[int], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.ConfusionMatrix.Row, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.ConfusionMatrix.Row:
        """Convert object to proto representation."""
        return management_types_pb2.ConfusionMatrix.Row(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ConfusionMatrixRow object " + repr(self.to_dict()) + ">"


class BooleanEvaluationMetrics:
    """Boolean evaluation metrics."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , log_loss: float = 0.0
        , accuracy: float = 0.0
        , roc_auc: float = 0.0
        , error: float = 0.0
        , confusion_matrix: ConfusionMatrix = None
        , precision: float = 0.0
        , recall: float = 0.0
        , f1: float = 0.0
    , **kwargs) -> BooleanEvaluationMetrics:
        self._attributes = dict()
        self.log_loss = log_loss
        self.accuracy = accuracy
        self.roc_auc = roc_auc
        self.error = error
        self.confusion_matrix = confusion_matrix
        self.precision = precision
        self.recall = recall
        self.f1 = f1

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def log_loss(self) -> float:
        """Log loss."""
        return self._attributes["log_loss"]


    @log_loss.setter
    def log_loss(self, value: float) -> None:
        _set_attribute(self._attributes, "BooleanEvaluationMetrics", "log_loss", value, float, "")


    @property
    def accuracy(self) -> float:
        """Accuracy."""
        return self._attributes["accuracy"]


    @accuracy.setter
    def accuracy(self, value: float) -> None:
        _set_attribute(self._attributes, "BooleanEvaluationMetrics", "accuracy", value, float, "")


    @property
    def roc_auc(self) -> float:
        """Roc auc."""
        return self._attributes["roc_auc"]


    @roc_auc.setter
    def roc_auc(self, value: float) -> None:
        _set_attribute(self._attributes, "BooleanEvaluationMetrics", "roc_auc", value, float, "")


    @property
    def error(self) -> float:
        """Error."""
        return self._attributes["error"]


    @error.setter
    def error(self, value: float) -> None:
        _set_attribute(self._attributes, "BooleanEvaluationMetrics", "error", value, float, "")


    @property
    def confusion_matrix(self) -> ConfusionMatrix:
        """Confusion matrix."""
        return self._attributes["confusion_matrix"]


    @confusion_matrix.setter
    def confusion_matrix(self, value: ConfusionMatrix) -> None:
        _set_attribute(self._attributes, "BooleanEvaluationMetrics", "confusion_matrix", value, ConfusionMatrix, "")


    @property
    def precision(self) -> float:
        """Precision."""
        return self._attributes["precision"]


    @precision.setter
    def precision(self, value: float) -> None:
        _set_attribute(self._attributes, "BooleanEvaluationMetrics", "precision", value, float, "")


    @property
    def recall(self) -> float:
        """Recall."""
        return self._attributes["recall"]


    @recall.setter
    def recall(self, value: float) -> None:
        _set_attribute(self._attributes, "BooleanEvaluationMetrics", "recall", value, float, "")


    @property
    def f1(self) -> float:
        """F1."""
        return self._attributes["f1"]


    @f1.setter
    def f1(self, value: float) -> None:
        _set_attribute(self._attributes, "BooleanEvaluationMetrics", "f1", value, float, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.BooleanEvaluationMetrics, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.BooleanEvaluationMetrics:
        """Convert object to proto representation."""
        return management_types_pb2.BooleanEvaluationMetrics(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BooleanEvaluationMetrics object " + repr(self.to_dict()) + ">"


class TextEvaluationMetrics:
    """Text evaluation metrics."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , log_loss: float = 0.0
        , f1: float = 0.0
        , perplexity: float = 0.0
        , edit_distance: float = 0.0
        , token_accuracy: float = 0.0
        , bleu: float = 0.0
    , **kwargs) -> TextEvaluationMetrics:
        self._attributes = dict()
        self.log_loss = log_loss
        self.f1 = f1
        self.perplexity = perplexity
        self.edit_distance = edit_distance
        self.token_accuracy = token_accuracy
        self.bleu = bleu

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def log_loss(self) -> float:
        """Log loss."""
        return self._attributes["log_loss"]


    @log_loss.setter
    def log_loss(self, value: float) -> None:
        _set_attribute(self._attributes, "TextEvaluationMetrics", "log_loss", value, float, "")


    @property
    def f1(self) -> float:
        """F1."""
        return self._attributes["f1"]


    @f1.setter
    def f1(self, value: float) -> None:
        _set_attribute(self._attributes, "TextEvaluationMetrics", "f1", value, float, "")


    @property
    def perplexity(self) -> float:
        """Perplexity."""
        return self._attributes["perplexity"]


    @perplexity.setter
    def perplexity(self, value: float) -> None:
        _set_attribute(self._attributes, "TextEvaluationMetrics", "perplexity", value, float, "")


    @property
    def edit_distance(self) -> float:
        """Edit distance."""
        return self._attributes["edit_distance"]


    @edit_distance.setter
    def edit_distance(self, value: float) -> None:
        _set_attribute(self._attributes, "TextEvaluationMetrics", "edit_distance", value, float, "")


    @property
    def token_accuracy(self) -> float:
        """Token accuracy."""
        return self._attributes["token_accuracy"]


    @token_accuracy.setter
    def token_accuracy(self, value: float) -> None:
        _set_attribute(self._attributes, "TextEvaluationMetrics", "token_accuracy", value, float, "")


    @property
    def bleu(self) -> float:
        """Bleu."""
        return self._attributes["bleu"]


    @bleu.setter
    def bleu(self, value: float) -> None:
        _set_attribute(self._attributes, "TextEvaluationMetrics", "bleu", value, float, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.TextEvaluationMetrics, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.TextEvaluationMetrics:
        """Convert object to proto representation."""
        return management_types_pb2.TextEvaluationMetrics(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<TextEvaluationMetrics object " + repr(self.to_dict()) + ">"


class CategoricalEvaluationMetrics:
    """Categorical evaluation metrics."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , log_loss: float = 0.0
        , accuracy: float = 0.0
        , roc_auc: float = 0.0
        , multiclass_error: float = 0.0
        , confusion_matrix: ConfusionMatrix = None
        , precision: float = 0.0
        , precision_micro: float = 0.0
        , precision_macro: float = 0.0
        , precision_weighted: float = 0.0
        , recall: float = 0.0
        , recall_micro: float = 0.0
        , recall_macro: float = 0.0
        , recall_weighted: float = 0.0
        , f1: float = 0.0
        , f1_micro: float = 0.0
        , f1_macro: float = 0.0
        , f1_weighted: float = 0.0
        , balanced_accuracy: float = 0.0
        , average_precision: float = 0.0
    , **kwargs) -> CategoricalEvaluationMetrics:
        self._attributes = dict()
        self.log_loss = log_loss
        self.accuracy = accuracy
        self.roc_auc = roc_auc
        self.multiclass_error = multiclass_error
        self.confusion_matrix = confusion_matrix
        self.precision = precision
        self.precision_micro = precision_micro
        self.precision_macro = precision_macro
        self.precision_weighted = precision_weighted
        self.recall = recall
        self.recall_micro = recall_micro
        self.recall_macro = recall_macro
        self.recall_weighted = recall_weighted
        self.f1 = f1
        self.f1_micro = f1_micro
        self.f1_macro = f1_macro
        self.f1_weighted = f1_weighted
        self.balanced_accuracy = balanced_accuracy
        self.average_precision = average_precision

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def log_loss(self) -> float:
        """Log loss."""
        return self._attributes["log_loss"]


    @log_loss.setter
    def log_loss(self, value: float) -> None:
        _set_attribute(self._attributes, "CategoricalEvaluationMetrics", "log_loss", value, float, "")


    @property
    def accuracy(self) -> float:
        """Accuracy."""
        return self._attributes["accuracy"]


    @accuracy.setter
    def accuracy(self, value: float) -> None:
        _set_attribute(self._attributes, "CategoricalEvaluationMetrics", "accuracy", value, float, "")


    @property
    def roc_auc(self) -> float:
        """Roc auc."""
        return self._attributes["roc_auc"]


    @roc_auc.setter
    def roc_auc(self, value: float) -> None:
        _set_attribute(self._attributes, "CategoricalEvaluationMetrics", "roc_auc", value, float, "")


    @property
    def multiclass_error(self) -> float:
        """Multiclass error."""
        return self._attributes["multiclass_error"]


    @multiclass_error.setter
    def multiclass_error(self, value: float) -> None:
        _set_attribute(self._attributes, "CategoricalEvaluationMetrics", "multiclass_error", value, float, "")


    @property
    def confusion_matrix(self) -> ConfusionMatrix:
        """Confusion matrix."""
        return self._attributes["confusion_matrix"]


    @confusion_matrix.setter
    def confusion_matrix(self, value: ConfusionMatrix) -> None:
        _set_attribute(self._attributes, "CategoricalEvaluationMetrics", "confusion_matrix", value, ConfusionMatrix, "")


    @property
    def precision(self) -> float:
        """Precision."""
        return self._attributes["precision"]


    @precision.setter
    def precision(self, value: float) -> None:
        _set_attribute(self._attributes, "CategoricalEvaluationMetrics", "precision", value, float, "")


    @property
    def precision_micro(self) -> float:
        """Precision micro."""
        return self._attributes["precision_micro"]


    @precision_micro.setter
    def precision_micro(self, value: float) -> None:
        _set_attribute(self._attributes, "CategoricalEvaluationMetrics", "precision_micro", value, float, "")


    @property
    def precision_macro(self) -> float:
        """Precision macro."""
        return self._attributes["precision_macro"]


    @precision_macro.setter
    def precision_macro(self, value: float) -> None:
        _set_attribute(self._attributes, "CategoricalEvaluationMetrics", "precision_macro", value, float, "")


    @property
    def precision_weighted(self) -> float:
        """Precision weighted."""
        return self._attributes["precision_weighted"]


    @precision_weighted.setter
    def precision_weighted(self, value: float) -> None:
        _set_attribute(self._attributes, "CategoricalEvaluationMetrics", "precision_weighted", value, float, "")


    @property
    def recall(self) -> float:
        """Recall."""
        return self._attributes["recall"]


    @recall.setter
    def recall(self, value: float) -> None:
        _set_attribute(self._attributes, "CategoricalEvaluationMetrics", "recall", value, float, "")


    @property
    def recall_micro(self) -> float:
        """Recall micro."""
        return self._attributes["recall_micro"]


    @recall_micro.setter
    def recall_micro(self, value: float) -> None:
        _set_attribute(self._attributes, "CategoricalEvaluationMetrics", "recall_micro", value, float, "")


    @property
    def recall_macro(self) -> float:
        """Recall macro."""
        return self._attributes["recall_macro"]


    @recall_macro.setter
    def recall_macro(self, value: float) -> None:
        _set_attribute(self._attributes, "CategoricalEvaluationMetrics", "recall_macro", value, float, "")


    @property
    def recall_weighted(self) -> float:
        """Recall weighted."""
        return self._attributes["recall_weighted"]


    @recall_weighted.setter
    def recall_weighted(self, value: float) -> None:
        _set_attribute(self._attributes, "CategoricalEvaluationMetrics", "recall_weighted", value, float, "")


    @property
    def f1(self) -> float:
        """F1."""
        return self._attributes["f1"]


    @f1.setter
    def f1(self, value: float) -> None:
        _set_attribute(self._attributes, "CategoricalEvaluationMetrics", "f1", value, float, "")


    @property
    def f1_micro(self) -> float:
        """F1 micro."""
        return self._attributes["f1_micro"]


    @f1_micro.setter
    def f1_micro(self, value: float) -> None:
        _set_attribute(self._attributes, "CategoricalEvaluationMetrics", "f1_micro", value, float, "")


    @property
    def f1_macro(self) -> float:
        """F1 macro."""
        return self._attributes["f1_macro"]


    @f1_macro.setter
    def f1_macro(self, value: float) -> None:
        _set_attribute(self._attributes, "CategoricalEvaluationMetrics", "f1_macro", value, float, "")


    @property
    def f1_weighted(self) -> float:
        """F1 weighted."""
        return self._attributes["f1_weighted"]


    @f1_weighted.setter
    def f1_weighted(self, value: float) -> None:
        _set_attribute(self._attributes, "CategoricalEvaluationMetrics", "f1_weighted", value, float, "")


    @property
    def balanced_accuracy(self) -> float:
        """Balanced accuracy."""
        return self._attributes["balanced_accuracy"]


    @balanced_accuracy.setter
    def balanced_accuracy(self, value: float) -> None:
        _set_attribute(self._attributes, "CategoricalEvaluationMetrics", "balanced_accuracy", value, float, "")


    @property
    def average_precision(self) -> float:
        """Average precision."""
        return self._attributes["average_precision"]


    @average_precision.setter
    def average_precision(self, value: float) -> None:
        _set_attribute(self._attributes, "CategoricalEvaluationMetrics", "average_precision", value, float, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.CategoricalEvaluationMetrics, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.CategoricalEvaluationMetrics:
        """Convert object to proto representation."""
        return management_types_pb2.CategoricalEvaluationMetrics(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CategoricalEvaluationMetrics object " + repr(self.to_dict()) + ">"


class NumberEvaluationMetrics:
    """Number evaluation metrics."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , rmse: float = 0.0
        , mae: float = 0.0
        , r2: float = 0.0
        , precision: float = 0.0
        , recall: float = 0.0
        , mape: float = 0.0
        , smape: float = 0.0
        , mean_squared_error: float = 0.0
        , median_absolute_error: float = 0.0
    , **kwargs) -> NumberEvaluationMetrics:
        self._attributes = dict()
        self.rmse = rmse
        self.mae = mae
        self.r2 = r2
        self.precision = precision
        self.recall = recall
        self.mape = mape
        self.smape = smape
        self.mean_squared_error = mean_squared_error
        self.median_absolute_error = median_absolute_error

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def rmse(self) -> float:
        """Rmse."""
        return self._attributes["rmse"]


    @rmse.setter
    def rmse(self, value: float) -> None:
        _set_attribute(self._attributes, "NumberEvaluationMetrics", "rmse", value, float, "")


    @property
    def mae(self) -> float:
        """Mae."""
        return self._attributes["mae"]


    @mae.setter
    def mae(self, value: float) -> None:
        _set_attribute(self._attributes, "NumberEvaluationMetrics", "mae", value, float, "")


    @property
    def r2(self) -> float:
        """R2."""
        return self._attributes["r2"]


    @r2.setter
    def r2(self, value: float) -> None:
        _set_attribute(self._attributes, "NumberEvaluationMetrics", "r2", value, float, "")


    @property
    def precision(self) -> float:
        """Precision."""
        return self._attributes["precision"]


    @precision.setter
    def precision(self, value: float) -> None:
        _set_attribute(self._attributes, "NumberEvaluationMetrics", "precision", value, float, "")


    @property
    def recall(self) -> float:
        """Recall."""
        return self._attributes["recall"]


    @recall.setter
    def recall(self, value: float) -> None:
        _set_attribute(self._attributes, "NumberEvaluationMetrics", "recall", value, float, "")


    @property
    def mape(self) -> float:
        """Mape."""
        return self._attributes["mape"]


    @mape.setter
    def mape(self, value: float) -> None:
        _set_attribute(self._attributes, "NumberEvaluationMetrics", "mape", value, float, "")


    @property
    def smape(self) -> float:
        """Smape."""
        return self._attributes["smape"]


    @smape.setter
    def smape(self, value: float) -> None:
        _set_attribute(self._attributes, "NumberEvaluationMetrics", "smape", value, float, "")


    @property
    def mean_squared_error(self) -> float:
        """Mean squared error."""
        return self._attributes["mean_squared_error"]


    @mean_squared_error.setter
    def mean_squared_error(self, value: float) -> None:
        _set_attribute(self._attributes, "NumberEvaluationMetrics", "mean_squared_error", value, float, "")


    @property
    def median_absolute_error(self) -> float:
        """Median absolute error."""
        return self._attributes["median_absolute_error"]


    @median_absolute_error.setter
    def median_absolute_error(self, value: float) -> None:
        _set_attribute(self._attributes, "NumberEvaluationMetrics", "median_absolute_error", value, float, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.NumberEvaluationMetrics, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.NumberEvaluationMetrics:
        """Convert object to proto representation."""
        return management_types_pb2.NumberEvaluationMetrics(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<NumberEvaluationMetrics object " + repr(self.to_dict()) + ">"


class EvaluationMetrics:
    """Evaluation metrics."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , boolean: BooleanEvaluationMetrics = None
        , number: NumberEvaluationMetrics = None
        , text: TextEvaluationMetrics = None
        , categorical: CategoricalEvaluationMetrics = None
    , **kwargs) -> EvaluationMetrics:
        self._attributes = dict()
        self.boolean = boolean
        self.number = number
        self.text = text
        self.categorical = categorical

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def boolean(self) -> BooleanEvaluationMetrics:
        """Boolean."""
        return self._attributes["boolean"]


    @boolean.setter
    def boolean(self, value: BooleanEvaluationMetrics) -> None:
        _set_attribute(self._attributes, "EvaluationMetrics", "boolean", value, BooleanEvaluationMetrics, "metrics")


    @property
    def number(self) -> NumberEvaluationMetrics:
        """Number."""
        return self._attributes["number"]


    @number.setter
    def number(self, value: NumberEvaluationMetrics) -> None:
        _set_attribute(self._attributes, "EvaluationMetrics", "number", value, NumberEvaluationMetrics, "metrics")


    @property
    def text(self) -> TextEvaluationMetrics:
        """Text."""
        return self._attributes["text"]


    @text.setter
    def text(self, value: TextEvaluationMetrics) -> None:
        _set_attribute(self._attributes, "EvaluationMetrics", "text", value, TextEvaluationMetrics, "metrics")


    @property
    def categorical(self) -> CategoricalEvaluationMetrics:
        """Categorical."""
        return self._attributes["categorical"]


    @categorical.setter
    def categorical(self, value: CategoricalEvaluationMetrics) -> None:
        _set_attribute(self._attributes, "EvaluationMetrics", "categorical", value, CategoricalEvaluationMetrics, "metrics")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.EvaluationMetrics, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.EvaluationMetrics:
        """Convert object to proto representation."""
        return management_types_pb2.EvaluationMetrics(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<EvaluationMetrics object " + repr(self.to_dict()) + ">"


class Experiment:
    """Experiment."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , run_name: str = ""
        , state: ExperimentState = 0
        , create_time: datetime = None
        , update_time: datetime = None
        , start_time: datetime = None
        , end_time: datetime = None
        , performance_metric_name: str = ""
        , performance_metric_val: float = 0.0
        , training_config: str = ""
        , error_message: str = ""
        , stack_trace: str = ""
    , **kwargs) -> Experiment:
        self._attributes = dict()
        self.name = name
        self.run_name = run_name
        self.state = state
        self.create_time = create_time
        self.update_time = update_time
        self.start_time = start_time
        self.end_time = end_time
        self.performance_metric_name = performance_metric_name
        self.performance_metric_val = performance_metric_val
        self.training_config = training_config
        self.error_message = error_message
        self.stack_trace = stack_trace

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Experiment", "name", value, str, "")


    @property
    def run_name(self) -> str:
        """Run name."""
        return self._attributes["run_name"]


    @run_name.setter
    def run_name(self, value: str) -> None:
        _set_attribute(self._attributes, "Experiment", "run_name", value, str, "")


    @property
    def state(self) -> ExperimentState:
        """State."""
        return self._attributes["state"]


    @state.setter
    def state(self, value: ExperimentState) -> None:
        _set_attribute(self._attributes, "Experiment", "state", value, ExperimentState, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Experiment", "create_time", value, datetime, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Experiment", "update_time", value, datetime, "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Experiment", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Experiment", "end_time", value, datetime, "")


    @property
    def performance_metric_name(self) -> str:
        """Performance metric name."""
        return self._attributes["performance_metric_name"]


    @performance_metric_name.setter
    def performance_metric_name(self, value: str) -> None:
        _set_attribute(self._attributes, "Experiment", "performance_metric_name", value, str, "")


    @property
    def performance_metric_val(self) -> float:
        """Performance metric val."""
        return self._attributes["performance_metric_val"]


    @performance_metric_val.setter
    def performance_metric_val(self, value: float) -> None:
        _set_attribute(self._attributes, "Experiment", "performance_metric_val", value, float, "")


    @property
    def training_config(self) -> str:
        """Training config."""
        return self._attributes["training_config"]


    @training_config.setter
    def training_config(self, value: str) -> None:
        _set_attribute(self._attributes, "Experiment", "training_config", value, str, "")


    @property
    def error_message(self) -> str:
        """Error message."""
        return self._attributes["error_message"]


    @error_message.setter
    def error_message(self, value: str) -> None:
        _set_attribute(self._attributes, "Experiment", "error_message", value, str, "")


    @property
    def stack_trace(self) -> str:
        """Stack trace."""
        return self._attributes["stack_trace"]


    @stack_trace.setter
    def stack_trace(self, value: str) -> None:
        _set_attribute(self._attributes, "Experiment", "stack_trace", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Experiment, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Experiment:
        """Convert object to proto representation."""
        return management_types_pb2.Experiment(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Experiment object " + repr(self.to_dict()) + ">"


class TextSequence:
    """Text sequence."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , value: List[str] = []
    , **kwargs) -> TextSequence:
        self._attributes = dict()
        self.value = value

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def value(self) -> List[str]:
        """Value."""
        return self._attributes["value"]


    @value.setter
    def value(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "TextSequence", "value", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.TextSequence, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.TextSequence:
        """Convert object to proto representation."""
        return management_types_pb2.TextSequence(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<TextSequence object " + repr(self.to_dict()) + ">"


class NumberSequence:
    """Number sequence."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , value: List[float] = []
    , **kwargs) -> NumberSequence:
        self._attributes = dict()
        self.value = value

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def value(self) -> List[float]:
        """Value."""
        return self._attributes["value"]


    @value.setter
    def value(self, value: List[float]) -> None:
        _set_attribute(self._attributes, "NumberSequence", "value", value, List[float], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.NumberSequence, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.NumberSequence:
        """Convert object to proto representation."""
        return management_types_pb2.NumberSequence(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<NumberSequence object " + repr(self.to_dict()) + ">"


class SignatureFeature:
    """Signature feature."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , qualified_name: str = ""
        , type: FieldType = 0
    , **kwargs) -> SignatureFeature:
        self._attributes = dict()
        self.qualified_name = qualified_name
        self.type = type

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def qualified_name(self) -> str:
        """Qualified name."""
        return self._attributes["qualified_name"]


    @qualified_name.setter
    def qualified_name(self, value: str) -> None:
        _set_attribute(self._attributes, "SignatureFeature", "qualified_name", value, str, "")


    @property
    def type(self) -> FieldType:
        """Type."""
        return self._attributes["type"]


    @type.setter
    def type(self, value: FieldType) -> None:
        _set_attribute(self._attributes, "SignatureFeature", "type", value, FieldType, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.SignatureFeature, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.SignatureFeature:
        """Convert object to proto representation."""
        return management_types_pb2.SignatureFeature(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<SignatureFeature object " + repr(self.to_dict()) + ">"


class QueryFeature:
    """Query feature."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , qualified_name: str = ""
        , relation: Query = None
        , value: str = ""
        , type: FieldType = 0
        , dtype: str = ""
        , model: bool = False
        , index: bool = False
        , time_index: bool = False
        , exclude: bool = False
        , split: bool = False
    , **kwargs) -> QueryFeature:
        self._attributes = dict()
        self.name = name
        self.qualified_name = qualified_name
        self.relation = relation
        self.value = value
        self.type = type
        self.dtype = dtype
        self.model = model
        self.index = index
        self.time_index = time_index
        self.exclude = exclude
        self.split = split

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name of the field to query"""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "QueryFeature", "name", value, str, "")


    @property
    def qualified_name(self) -> str:
        """Fully qualified name of the field"""
        return self._attributes["qualified_name"]


    @qualified_name.setter
    def qualified_name(self, value: str) -> None:
        _set_attribute(self._attributes, "QueryFeature", "qualified_name", value, str, "")


    @property
    def relation(self) -> Query:
        """fields from linked featureset if this field represents a relation."""
        return self._attributes["relation"]


    @relation.setter
    def relation(self, value: Query) -> None:
        _set_attribute(self._attributes, "QueryFeature", "relation", value, Query, "")


    @property
    def value(self) -> str:
        """Value of the field to be returned as an override."""
        return self._attributes["value"]


    @value.setter
    def value(self, value: str) -> None:
        _set_attribute(self._attributes, "QueryFeature", "value", value, str, "")


    @property
    def type(self) -> FieldType:
        """Type."""
        return self._attributes["type"]


    @type.setter
    def type(self, value: FieldType) -> None:
        _set_attribute(self._attributes, "QueryFeature", "type", value, FieldType, "")


    @property
    def dtype(self) -> str:
        """Dtype."""
        return self._attributes["dtype"]


    @dtype.setter
    def dtype(self, value: str) -> None:
        _set_attribute(self._attributes, "QueryFeature", "dtype", value, str, "")


    @property
    def model(self) -> bool:
        """Is this field a model"""
        return self._attributes["model"]


    @model.setter
    def model(self, value: bool) -> None:
        _set_attribute(self._attributes, "QueryFeature", "model", value, bool, "")


    @property
    def index(self) -> bool:
        """Index."""
        return self._attributes["index"]


    @index.setter
    def index(self, value: bool) -> None:
        _set_attribute(self._attributes, "QueryFeature", "index", value, bool, "")


    @property
    def time_index(self) -> bool:
        """Time index."""
        return self._attributes["time_index"]


    @time_index.setter
    def time_index(self, value: bool) -> None:
        _set_attribute(self._attributes, "QueryFeature", "time_index", value, bool, "")


    @property
    def exclude(self) -> bool:
        """Exclude this column from training."""
        return self._attributes["exclude"]


    @exclude.setter
    def exclude(self, value: bool) -> None:
        _set_attribute(self._attributes, "QueryFeature", "exclude", value, bool, "")


    @property
    def split(self) -> bool:
        """If this a split feature."""
        return self._attributes["split"]


    @split.setter
    def split(self, value: bool) -> None:
        _set_attribute(self._attributes, "QueryFeature", "split", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.QueryFeature, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.QueryFeature:
        """Convert object to proto representation."""
        return management_types_pb2.QueryFeature(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<QueryFeature object " + repr(self.to_dict()) + ">"


class Query:
    """Query format for requesting data using get_training_data and get_serving_data"""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , entity_id: str = ""
        , table_name: str = ""
        , fields: List[QueryFeature] = []
        , related: List[Query] = []
    , **kwargs) -> Query:
        self._attributes = dict()
        self.name = name
        self.entity_id = entity_id
        self.table_name = table_name
        self.fields = fields
        self.related = related

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """object name to query"""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Query", "name", value, str, "")


    @property
    def entity_id(self) -> str:
        """Entity this featureset is part of"""
        return self._attributes["entity_id"]


    @entity_id.setter
    def entity_id(self, value: str) -> None:
        _set_attribute(self._attributes, "Query", "entity_id", value, str, "")


    @property
    def table_name(self) -> str:
        """Table name config for the object"""
        return self._attributes["table_name"]


    @table_name.setter
    def table_name(self, value: str) -> None:
        _set_attribute(self._attributes, "Query", "table_name", value, str, "")


    @property
    def fields(self) -> List[QueryFeature]:
        """Fields to query"""
        return self._attributes["fields"]


    @fields.setter
    def fields(self, value: List[QueryFeature]) -> None:
        _set_attribute(self._attributes, "Query", "fields", value, List[QueryFeature], "")


    @property
    def related(self) -> List[Query]:
        """Related featuresets to include in the request"""
        return self._attributes["related"]


    @related.setter
    def related(self, value: List[Query]) -> None:
        _set_attribute(self._attributes, "Query", "related", value, List[Query], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Query, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Query:
        """Convert object to proto representation."""
        return management_types_pb2.Query(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Query object " + repr(self.to_dict()) + ">"


class BatchPrediction:
    """Batch prediction."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , state: BatchPredictionState = 0
        , model_version: str = ""
        , create_time: datetime = None
        , start_time: datetime = None
        , end_time: datetime = None
        , prediction_count: int = 0
        , error_message: str = ""
        , stack_trace: str = ""
        , run_name: str = ""
    , **kwargs) -> BatchPrediction:
        self._attributes = dict()
        self.name = name
        self.state = state
        self.model_version = model_version
        self.create_time = create_time
        self.start_time = start_time
        self.end_time = end_time
        self.prediction_count = prediction_count
        self.error_message = error_message
        self.stack_trace = stack_trace
        self.run_name = run_name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchPrediction", "name", value, str, "")


    @property
    def state(self) -> BatchPredictionState:
        """State."""
        return self._attributes["state"]


    @state.setter
    def state(self, value: BatchPredictionState) -> None:
        _set_attribute(self._attributes, "BatchPrediction", "state", value, BatchPredictionState, "")


    @property
    def model_version(self) -> str:
        """Model version."""
        return self._attributes["model_version"]


    @model_version.setter
    def model_version(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchPrediction", "model_version", value, str, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "BatchPrediction", "create_time", value, datetime, "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "BatchPrediction", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "BatchPrediction", "end_time", value, datetime, "")


    @property
    def prediction_count(self) -> int:
        """Prediction count."""
        return self._attributes["prediction_count"]


    @prediction_count.setter
    def prediction_count(self, value: int) -> None:
        _set_attribute(self._attributes, "BatchPrediction", "prediction_count", value, int, "")


    @property
    def error_message(self) -> str:
        """Error message."""
        return self._attributes["error_message"]


    @error_message.setter
    def error_message(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchPrediction", "error_message", value, str, "")


    @property
    def stack_trace(self) -> str:
        """Stack trace."""
        return self._attributes["stack_trace"]


    @stack_trace.setter
    def stack_trace(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchPrediction", "stack_trace", value, str, "")


    @property
    def run_name(self) -> str:
        """Run name."""
        return self._attributes["run_name"]


    @run_name.setter
    def run_name(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchPrediction", "run_name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.BatchPrediction, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.BatchPrediction:
        """Convert object to proto representation."""
        return management_types_pb2.BatchPrediction(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchPrediction object " + repr(self.to_dict()) + ">"


class SignedURL:
    """Signed u r l."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , signed_url: str = ""
    , **kwargs) -> SignedURL:
        self._attributes = dict()
        self.signed_url = signed_url

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def signed_url(self) -> str:
        """Signed url."""
        return self._attributes["signed_url"]


    @signed_url.setter
    def signed_url(self, value: str) -> None:
        _set_attribute(self._attributes, "SignedURL", "signed_url", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.SignedURL, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.SignedURL:
        """Convert object to proto representation."""
        return management_types_pb2.SignedURL(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<SignedURL object " + repr(self.to_dict()) + ">"


class Entity:
    """Entity."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , models: List[str] = []
        , feature_sets: List[str] = []
    , **kwargs) -> Entity:
        self._attributes = dict()
        self.name = name
        self.models = models
        self.feature_sets = feature_sets

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Entity", "name", value, str, "")


    @property
    def models(self) -> List[str]:
        """Models."""
        return self._attributes["models"]


    @models.setter
    def models(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "Entity", "models", value, List[str], "")


    @property
    def feature_sets(self) -> List[str]:
        """Feature sets."""
        return self._attributes["feature_sets"]


    @feature_sets.setter
    def feature_sets(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "Entity", "feature_sets", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Entity, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Entity:
        """Convert object to proto representation."""
        return management_types_pb2.Entity(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Entity object " + repr(self.to_dict()) + ">"


class Dataset:
    """Dataset."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , description: str = ""
        , state: str = ""
        , author: str = ""
        , display_name: str = ""
        , current_version: str = ""
        , create_time: datetime = None
        , update_time: datetime = None
    , **kwargs) -> Dataset:
        self._attributes = dict()
        self.name = name
        self.description = description
        self.state = state
        self.author = author
        self.display_name = display_name
        self.current_version = current_version
        self.create_time = create_time
        self.update_time = update_time

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Dataset", "name", value, str, "")


    @property
    def description(self) -> str:
        """Description."""
        return self._attributes["description"]


    @description.setter
    def description(self, value: str) -> None:
        _set_attribute(self._attributes, "Dataset", "description", value, str, "")


    @property
    def state(self) -> str:
        """State."""
        return self._attributes["state"]


    @state.setter
    def state(self, value: str) -> None:
        _set_attribute(self._attributes, "Dataset", "state", value, str, "")


    @property
    def author(self) -> str:
        """Author."""
        return self._attributes["author"]


    @author.setter
    def author(self, value: str) -> None:
        _set_attribute(self._attributes, "Dataset", "author", value, str, "")


    @property
    def display_name(self) -> str:
        """Display name."""
        return self._attributes["display_name"]


    @display_name.setter
    def display_name(self, value: str) -> None:
        _set_attribute(self._attributes, "Dataset", "display_name", value, str, "")


    @property
    def current_version(self) -> str:
        """Current version."""
        return self._attributes["current_version"]


    @current_version.setter
    def current_version(self, value: str) -> None:
        _set_attribute(self._attributes, "Dataset", "current_version", value, str, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Dataset", "create_time", value, datetime, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Dataset", "update_time", value, datetime, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Dataset, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Dataset:
        """Convert object to proto representation."""
        return management_types_pb2.Dataset(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Dataset object " + repr(self.to_dict()) + ">"


class DatasetVersion:
    """Dataset version."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , run_name: str = ""
        , create_time: datetime = None
        , update_time: datetime = None
    , **kwargs) -> DatasetVersion:
        self._attributes = dict()
        self.name = name
        self.run_name = run_name
        self.create_time = create_time
        self.update_time = update_time

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "DatasetVersion", "name", value, str, "")


    @property
    def run_name(self) -> str:
        """Run name."""
        return self._attributes["run_name"]


    @run_name.setter
    def run_name(self, value: str) -> None:
        _set_attribute(self._attributes, "DatasetVersion", "run_name", value, str, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "DatasetVersion", "create_time", value, datetime, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "DatasetVersion", "update_time", value, datetime, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.DatasetVersion, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.DatasetVersion:
        """Convert object to proto representation."""
        return management_types_pb2.DatasetVersion(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DatasetVersion object " + repr(self.to_dict()) + ">"


class DatasetVersionAssignment:
    """Dataset version assignment."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , resource_name: str = ""
        , create_time: datetime = None
    , **kwargs) -> DatasetVersionAssignment:
        self._attributes = dict()
        self.name = name
        self.resource_name = resource_name
        self.create_time = create_time

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "DatasetVersionAssignment", "name", value, str, "")


    @property
    def resource_name(self) -> str:
        """Resource name."""
        return self._attributes["resource_name"]


    @resource_name.setter
    def resource_name(self, value: str) -> None:
        _set_attribute(self._attributes, "DatasetVersionAssignment", "resource_name", value, str, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "DatasetVersionAssignment", "create_time", value, datetime, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.DatasetVersionAssignment, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.DatasetVersionAssignment:
        """Convert object to proto representation."""
        return management_types_pb2.DatasetVersionAssignment(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DatasetVersionAssignment object " + repr(self.to_dict()) + ">"


class DataProfile:
    """Data profile."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , dataset_stats: List[DatasetStatsEntry] = []
        , create_time: datetime = None
    , **kwargs) -> DataProfile:
        self._attributes = dict()
        self.name = name
        self.dataset_stats = dataset_stats
        self.create_time = create_time

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """this could have a single value if you are profiling a single data set
 if you have a bundle, say training/test/validation then you'd have 
 a entry for each in this list"""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "DataProfile", "name", value, str, "")


    @property
    def dataset_stats(self) -> List[DatasetStatsEntry]:
        """Dataset stats."""
        return self._attributes["dataset_stats"]


    @dataset_stats.setter
    def dataset_stats(self, value: List[DatasetStatsEntry]) -> None:
        _set_attribute(self._attributes, "DataProfile", "dataset_stats", value, List[DatasetStatsEntry], "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "DataProfile", "create_time", value, datetime, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.DataProfile, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.DataProfile:
        """Convert object to proto representation."""
        return management_types_pb2.DataProfile(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DataProfile object " + repr(self.to_dict()) + ">"


class DatasetStatsEntry:
    """Dataset stats entry."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , entry_name: str = ""
        , num_examples: int = 0
        , correlation_matrix: CorrelationMatrix = None
        , string_stats: List[StringStats] = []
        , numeric_stats: List[NumericStats] = []
        , timestamp_stats: List[TimestampStats] = []
        , categorical_stats: List[CategoricalStats] = []
        , duplicate_rows: int = 0
        , duplicate_indexes: int = 0
        , dataset_ranges: List[DatasetRange] = []
    , **kwargs) -> DatasetStatsEntry:
        self._attributes = dict()
        self.entry_name = entry_name
        self.num_examples = num_examples
        self.correlation_matrix = correlation_matrix
        self.string_stats = string_stats
        self.numeric_stats = numeric_stats
        self.timestamp_stats = timestamp_stats
        self.categorical_stats = categorical_stats
        self.duplicate_rows = duplicate_rows
        self.duplicate_indexes = duplicate_indexes
        self.dataset_ranges = dataset_ranges

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def entry_name(self) -> str:
        """- Correlation Matrix
 - Feature Distributions
 - Quantiles
 - Duplicate stats
 - Non-unique indexes
 - Skewness - TODO"""
        return self._attributes["entry_name"]


    @entry_name.setter
    def entry_name(self, value: str) -> None:
        _set_attribute(self._attributes, "DatasetStatsEntry", "entry_name", value, str, "")


    @property
    def num_examples(self) -> int:
        """Num examples."""
        return self._attributes["num_examples"]


    @num_examples.setter
    def num_examples(self, value: int) -> None:
        _set_attribute(self._attributes, "DatasetStatsEntry", "num_examples", value, int, "")


    @property
    def correlation_matrix(self) -> CorrelationMatrix:
        """Correlation matrix."""
        return self._attributes["correlation_matrix"]


    @correlation_matrix.setter
    def correlation_matrix(self, value: CorrelationMatrix) -> None:
        _set_attribute(self._attributes, "DatasetStatsEntry", "correlation_matrix", value, CorrelationMatrix, "")


    @property
    def string_stats(self) -> List[StringStats]:
        """String stats."""
        return self._attributes["string_stats"]


    @string_stats.setter
    def string_stats(self, value: List[StringStats]) -> None:
        _set_attribute(self._attributes, "DatasetStatsEntry", "string_stats", value, List[StringStats], "")


    @property
    def numeric_stats(self) -> List[NumericStats]:
        """Numeric stats."""
        return self._attributes["numeric_stats"]


    @numeric_stats.setter
    def numeric_stats(self, value: List[NumericStats]) -> None:
        _set_attribute(self._attributes, "DatasetStatsEntry", "numeric_stats", value, List[NumericStats], "")


    @property
    def timestamp_stats(self) -> List[TimestampStats]:
        """Timestamp stats."""
        return self._attributes["timestamp_stats"]


    @timestamp_stats.setter
    def timestamp_stats(self, value: List[TimestampStats]) -> None:
        _set_attribute(self._attributes, "DatasetStatsEntry", "timestamp_stats", value, List[TimestampStats], "")


    @property
    def categorical_stats(self) -> List[CategoricalStats]:
        """Categorical stats."""
        return self._attributes["categorical_stats"]


    @categorical_stats.setter
    def categorical_stats(self, value: List[CategoricalStats]) -> None:
        _set_attribute(self._attributes, "DatasetStatsEntry", "categorical_stats", value, List[CategoricalStats], "")


    @property
    def duplicate_rows(self) -> int:
        """Duplicate rows."""
        return self._attributes["duplicate_rows"]


    @duplicate_rows.setter
    def duplicate_rows(self, value: int) -> None:
        _set_attribute(self._attributes, "DatasetStatsEntry", "duplicate_rows", value, int, "")


    @property
    def duplicate_indexes(self) -> int:
        """Duplicate indexes."""
        return self._attributes["duplicate_indexes"]


    @duplicate_indexes.setter
    def duplicate_indexes(self, value: int) -> None:
        _set_attribute(self._attributes, "DatasetStatsEntry", "duplicate_indexes", value, int, "")


    @property
    def dataset_ranges(self) -> List[DatasetRange]:
        """Dataset ranges."""
        return self._attributes["dataset_ranges"]


    @dataset_ranges.setter
    def dataset_ranges(self, value: List[DatasetRange]) -> None:
        _set_attribute(self._attributes, "DatasetStatsEntry", "dataset_ranges", value, List[DatasetRange], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.DatasetStatsEntry, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.DatasetStatsEntry:
        """Convert object to proto representation."""
        return management_types_pb2.DatasetStatsEntry(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DatasetStatsEntry object " + repr(self.to_dict()) + ">"


class DatasetRange:
    """Dataset range."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , start_time: datetime = None
        , end_time: datetime = None
    , **kwargs) -> DatasetRange:
        self._attributes = dict()
        self.name = name
        self.start_time = start_time
        self.end_time = end_time

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "DatasetRange", "name", value, str, "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "DatasetRange", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "DatasetRange", "end_time", value, datetime, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.DatasetRange, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.DatasetRange:
        """Convert object to proto representation."""
        return management_types_pb2.DatasetRange(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DatasetRange object " + repr(self.to_dict()) + ">"


class CorrelationMatrix:
    """Correlation matrix."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , display_names: List[str] = []
        , rows: List[CorrelationMatrixRow] = []
    , **kwargs) -> CorrelationMatrix:
        self._attributes = dict()
        self.display_names = display_names
        self.rows = rows

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def display_names(self) -> List[str]:
        """Display names."""
        return self._attributes["display_names"]


    @display_names.setter
    def display_names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "CorrelationMatrix", "display_names", value, List[str], "")


    @property
    def rows(self) -> List[CorrelationMatrixRow]:
        """Rows."""
        return self._attributes["rows"]


    @rows.setter
    def rows(self, value: List[CorrelationMatrixRow]) -> None:
        _set_attribute(self._attributes, "CorrelationMatrix", "rows", value, List[CorrelationMatrixRow], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.CorrelationMatrix, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.CorrelationMatrix:
        """Convert object to proto representation."""
        return management_types_pb2.CorrelationMatrix(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CorrelationMatrix object " + repr(self.to_dict()) + ">"


class CorrelationMatrixRow:
    """Correlation matrix row."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , correlations: List[float] = []
    , **kwargs) -> CorrelationMatrixRow:
        self._attributes = dict()
        self.correlations = correlations

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def correlations(self) -> List[float]:
        """Correlations."""
        return self._attributes["correlations"]


    @correlations.setter
    def correlations(self, value: List[float]) -> None:
        _set_attribute(self._attributes, "CorrelationMatrixRow", "correlations", value, List[float], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.CorrelationMatrix.Row, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.CorrelationMatrix.Row:
        """Convert object to proto representation."""
        return management_types_pb2.CorrelationMatrix.Row(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CorrelationMatrixRow object " + repr(self.to_dict()) + ">"


class Histogram:
    """Histogram."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , num_nan: int = 0
        , num_undefined: int = 0
        , buckets: List[HistogramBucket] = []
    , **kwargs) -> Histogram:
        self._attributes = dict()
        self.num_nan = num_nan
        self.num_undefined = num_undefined
        self.buckets = buckets

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def num_nan(self) -> int:
        """Num nan."""
        return self._attributes["num_nan"]


    @num_nan.setter
    def num_nan(self, value: int) -> None:
        _set_attribute(self._attributes, "Histogram", "num_nan", value, int, "")


    @property
    def num_undefined(self) -> int:
        """Num undefined."""
        return self._attributes["num_undefined"]


    @num_undefined.setter
    def num_undefined(self, value: int) -> None:
        _set_attribute(self._attributes, "Histogram", "num_undefined", value, int, "")


    @property
    def buckets(self) -> List[HistogramBucket]:
        """Buckets."""
        return self._attributes["buckets"]


    @buckets.setter
    def buckets(self, value: List[HistogramBucket]) -> None:
        _set_attribute(self._attributes, "Histogram", "buckets", value, List[HistogramBucket], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Histogram, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Histogram:
        """Convert object to proto representation."""
        return management_types_pb2.Histogram(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Histogram object " + repr(self.to_dict()) + ">"


class HistogramBucket:
    """Histogram bucket."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , low_value: float = 0.0
        , high_value: float = 0.0
        , sample_count: int = 0
    , **kwargs) -> HistogramBucket:
        self._attributes = dict()
        self.low_value = low_value
        self.high_value = high_value
        self.sample_count = sample_count

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def low_value(self) -> float:
        """Low value."""
        return self._attributes["low_value"]


    @low_value.setter
    def low_value(self, value: float) -> None:
        _set_attribute(self._attributes, "HistogramBucket", "low_value", value, float, "")


    @property
    def high_value(self) -> float:
        """High value."""
        return self._attributes["high_value"]


    @high_value.setter
    def high_value(self, value: float) -> None:
        _set_attribute(self._attributes, "HistogramBucket", "high_value", value, float, "")


    @property
    def sample_count(self) -> int:
        """Sample count."""
        return self._attributes["sample_count"]


    @sample_count.setter
    def sample_count(self, value: int) -> None:
        _set_attribute(self._attributes, "HistogramBucket", "sample_count", value, int, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Histogram.Bucket, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Histogram.Bucket:
        """Convert object to proto representation."""
        return management_types_pb2.Histogram.Bucket(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<HistogramBucket object " + repr(self.to_dict()) + ">"


class TimestampHistogram:
    """Timestamp histogram."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , num_nan: int = 0
        , num_undefined: int = 0
        , buckets: List[TimestampHistogramBucket] = []
    , **kwargs) -> TimestampHistogram:
        self._attributes = dict()
        self.num_nan = num_nan
        self.num_undefined = num_undefined
        self.buckets = buckets

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def num_nan(self) -> int:
        """Num nan."""
        return self._attributes["num_nan"]


    @num_nan.setter
    def num_nan(self, value: int) -> None:
        _set_attribute(self._attributes, "TimestampHistogram", "num_nan", value, int, "")


    @property
    def num_undefined(self) -> int:
        """Num undefined."""
        return self._attributes["num_undefined"]


    @num_undefined.setter
    def num_undefined(self, value: int) -> None:
        _set_attribute(self._attributes, "TimestampHistogram", "num_undefined", value, int, "")


    @property
    def buckets(self) -> List[TimestampHistogramBucket]:
        """Buckets."""
        return self._attributes["buckets"]


    @buckets.setter
    def buckets(self, value: List[TimestampHistogramBucket]) -> None:
        _set_attribute(self._attributes, "TimestampHistogram", "buckets", value, List[TimestampHistogramBucket], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.TimestampHistogram, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.TimestampHistogram:
        """Convert object to proto representation."""
        return management_types_pb2.TimestampHistogram(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<TimestampHistogram object " + repr(self.to_dict()) + ">"


class TimestampHistogramBucket:
    """Timestamp histogram bucket."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , low_value: datetime = None
        , high_value: datetime = None
        , sample_count: int = 0
    , **kwargs) -> TimestampHistogramBucket:
        self._attributes = dict()
        self.low_value = low_value
        self.high_value = high_value
        self.sample_count = sample_count

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def low_value(self) -> datetime:
        """Low value."""
        return self._attributes["low_value"]


    @low_value.setter
    def low_value(self, value: datetime) -> None:
        _set_attribute(self._attributes, "TimestampHistogramBucket", "low_value", value, datetime, "")


    @property
    def high_value(self) -> datetime:
        """High value."""
        return self._attributes["high_value"]


    @high_value.setter
    def high_value(self, value: datetime) -> None:
        _set_attribute(self._attributes, "TimestampHistogramBucket", "high_value", value, datetime, "")


    @property
    def sample_count(self) -> int:
        """Sample count."""
        return self._attributes["sample_count"]


    @sample_count.setter
    def sample_count(self, value: int) -> None:
        _set_attribute(self._attributes, "TimestampHistogramBucket", "sample_count", value, int, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.TimestampHistogram.Bucket, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.TimestampHistogram.Bucket:
        """Convert object to proto representation."""
        return management_types_pb2.TimestampHistogram.Bucket(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<TimestampHistogramBucket object " + repr(self.to_dict()) + ">"


class CategoricalDistribution:
    """store first 20 or so"""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , categories: List[CategoricalDistributionCategory] = []
    , **kwargs) -> CategoricalDistribution:
        self._attributes = dict()
        self.categories = categories

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def categories(self) -> List[CategoricalDistributionCategory]:
        """Categories."""
        return self._attributes["categories"]


    @categories.setter
    def categories(self, value: List[CategoricalDistributionCategory]) -> None:
        _set_attribute(self._attributes, "CategoricalDistribution", "categories", value, List[CategoricalDistributionCategory], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.CategoricalDistribution, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.CategoricalDistribution:
        """Convert object to proto representation."""
        return management_types_pb2.CategoricalDistribution(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CategoricalDistribution object " + repr(self.to_dict()) + ">"


class CategoricalDistributionCategory:
    """Categorical distribution category."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , label: str = ""
        , sample_count: int = 0
    , **kwargs) -> CategoricalDistributionCategory:
        self._attributes = dict()
        self.label = label
        self.sample_count = sample_count

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def label(self) -> str:
        """Label."""
        return self._attributes["label"]


    @label.setter
    def label(self, value: str) -> None:
        _set_attribute(self._attributes, "CategoricalDistributionCategory", "label", value, str, "")


    @property
    def sample_count(self) -> int:
        """Sample count."""
        return self._attributes["sample_count"]


    @sample_count.setter
    def sample_count(self, value: int) -> None:
        _set_attribute(self._attributes, "CategoricalDistributionCategory", "sample_count", value, int, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.CategoricalDistribution.Category, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.CategoricalDistribution.Category:
        """Convert object to proto representation."""
        return management_types_pb2.CategoricalDistribution.Category(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CategoricalDistributionCategory object " + repr(self.to_dict()) + ">"


class StringStats:
    """String stats."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , column_name: str = ""
        , distinct_values: int = 0
        , null_count: int = 0
        , min_length: int = 0
        , max_length: int = 0
    , **kwargs) -> StringStats:
        self._attributes = dict()
        self.column_name = column_name
        self.distinct_values = distinct_values
        self.null_count = null_count
        self.min_length = min_length
        self.max_length = max_length

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def column_name(self) -> str:
        """Column name."""
        return self._attributes["column_name"]


    @column_name.setter
    def column_name(self, value: str) -> None:
        _set_attribute(self._attributes, "StringStats", "column_name", value, str, "")


    @property
    def distinct_values(self) -> int:
        """Distinct values."""
        return self._attributes["distinct_values"]


    @distinct_values.setter
    def distinct_values(self, value: int) -> None:
        _set_attribute(self._attributes, "StringStats", "distinct_values", value, int, "")


    @property
    def null_count(self) -> int:
        """Null count."""
        return self._attributes["null_count"]


    @null_count.setter
    def null_count(self, value: int) -> None:
        _set_attribute(self._attributes, "StringStats", "null_count", value, int, "")


    @property
    def min_length(self) -> int:
        """Min length."""
        return self._attributes["min_length"]


    @min_length.setter
    def min_length(self, value: int) -> None:
        _set_attribute(self._attributes, "StringStats", "min_length", value, int, "")


    @property
    def max_length(self) -> int:
        """Max length."""
        return self._attributes["max_length"]


    @max_length.setter
    def max_length(self, value: int) -> None:
        _set_attribute(self._attributes, "StringStats", "max_length", value, int, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.StringStats, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.StringStats:
        """Convert object to proto representation."""
        return management_types_pb2.StringStats(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<StringStats object " + repr(self.to_dict()) + ">"


class CategoricalStats:
    """Categorical stats."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , column_name: str = ""
        , distinct_values: int = 0
        , null_count: int = 0
        , categorical_distribution: CategoricalDistribution = None
    , **kwargs) -> CategoricalStats:
        self._attributes = dict()
        self.column_name = column_name
        self.distinct_values = distinct_values
        self.null_count = null_count
        self.categorical_distribution = categorical_distribution

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def column_name(self) -> str:
        """Column name."""
        return self._attributes["column_name"]


    @column_name.setter
    def column_name(self, value: str) -> None:
        _set_attribute(self._attributes, "CategoricalStats", "column_name", value, str, "")


    @property
    def distinct_values(self) -> int:
        """Distinct values."""
        return self._attributes["distinct_values"]


    @distinct_values.setter
    def distinct_values(self, value: int) -> None:
        _set_attribute(self._attributes, "CategoricalStats", "distinct_values", value, int, "")


    @property
    def null_count(self) -> int:
        """Null count."""
        return self._attributes["null_count"]


    @null_count.setter
    def null_count(self, value: int) -> None:
        _set_attribute(self._attributes, "CategoricalStats", "null_count", value, int, "")


    @property
    def categorical_distribution(self) -> CategoricalDistribution:
        """Categorical distribution."""
        return self._attributes["categorical_distribution"]


    @categorical_distribution.setter
    def categorical_distribution(self, value: CategoricalDistribution) -> None:
        _set_attribute(self._attributes, "CategoricalStats", "categorical_distribution", value, CategoricalDistribution, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.CategoricalStats, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.CategoricalStats:
        """Convert object to proto representation."""
        return management_types_pb2.CategoricalStats(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CategoricalStats object " + repr(self.to_dict()) + ">"


class TimestampStats:
    """Timestamp stats."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , column_name: str = ""
        , distinct_values: int = 0
        , null_count: int = 0
        , min: datetime = None
        , max: datetime = None
        , timestamp_histogram: TimestampHistogram = None
    , **kwargs) -> TimestampStats:
        self._attributes = dict()
        self.column_name = column_name
        self.distinct_values = distinct_values
        self.null_count = null_count
        self.min = min
        self.max = max
        self.timestamp_histogram = timestamp_histogram

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def column_name(self) -> str:
        """Column name."""
        return self._attributes["column_name"]


    @column_name.setter
    def column_name(self, value: str) -> None:
        _set_attribute(self._attributes, "TimestampStats", "column_name", value, str, "")


    @property
    def distinct_values(self) -> int:
        """Distinct values."""
        return self._attributes["distinct_values"]


    @distinct_values.setter
    def distinct_values(self, value: int) -> None:
        _set_attribute(self._attributes, "TimestampStats", "distinct_values", value, int, "")


    @property
    def null_count(self) -> int:
        """Null count."""
        return self._attributes["null_count"]


    @null_count.setter
    def null_count(self, value: int) -> None:
        _set_attribute(self._attributes, "TimestampStats", "null_count", value, int, "")


    @property
    def min(self) -> datetime:
        """Min."""
        return self._attributes["min"]


    @min.setter
    def min(self, value: datetime) -> None:
        _set_attribute(self._attributes, "TimestampStats", "min", value, datetime, "")


    @property
    def max(self) -> datetime:
        """Max."""
        return self._attributes["max"]


    @max.setter
    def max(self, value: datetime) -> None:
        _set_attribute(self._attributes, "TimestampStats", "max", value, datetime, "")


    @property
    def timestamp_histogram(self) -> TimestampHistogram:
        """Timestamp histogram."""
        return self._attributes["timestamp_histogram"]


    @timestamp_histogram.setter
    def timestamp_histogram(self, value: TimestampHistogram) -> None:
        _set_attribute(self._attributes, "TimestampStats", "timestamp_histogram", value, TimestampHistogram, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.TimestampStats, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.TimestampStats:
        """Convert object to proto representation."""
        return management_types_pb2.TimestampStats(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<TimestampStats object " + repr(self.to_dict()) + ">"


class NumericStats:
    """Numeric stats."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , column_name: str = ""
        , distinct_values: int = 0
        , min: float = 0.0
        , max: float = 0.0
        , sd: float = 0.0
        , mean: float = 0.0
        , count: int = 0
        , percentile25: float = 0.0
        , percentile50: float = 0.0
        , percentile75: float = 0.0
        , null_count: int = 0
        , num_nan: int = 0
        , num_values_histogram: Histogram = None
    , **kwargs) -> NumericStats:
        self._attributes = dict()
        self.column_name = column_name
        self.distinct_values = distinct_values
        self.min = min
        self.max = max
        self.sd = sd
        self.mean = mean
        self.count = count
        self.percentile25 = percentile25
        self.percentile50 = percentile50
        self.percentile75 = percentile75
        self.null_count = null_count
        self.num_nan = num_nan
        self.num_values_histogram = num_values_histogram

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def column_name(self) -> str:
        """Column name."""
        return self._attributes["column_name"]


    @column_name.setter
    def column_name(self, value: str) -> None:
        _set_attribute(self._attributes, "NumericStats", "column_name", value, str, "")


    @property
    def distinct_values(self) -> int:
        """Distinct values."""
        return self._attributes["distinct_values"]


    @distinct_values.setter
    def distinct_values(self, value: int) -> None:
        _set_attribute(self._attributes, "NumericStats", "distinct_values", value, int, "")


    @property
    def min(self) -> float:
        """Min."""
        return self._attributes["min"]


    @min.setter
    def min(self, value: float) -> None:
        _set_attribute(self._attributes, "NumericStats", "min", value, float, "")


    @property
    def max(self) -> float:
        """Max."""
        return self._attributes["max"]


    @max.setter
    def max(self, value: float) -> None:
        _set_attribute(self._attributes, "NumericStats", "max", value, float, "")


    @property
    def sd(self) -> float:
        """Sd."""
        return self._attributes["sd"]


    @sd.setter
    def sd(self, value: float) -> None:
        _set_attribute(self._attributes, "NumericStats", "sd", value, float, "")


    @property
    def mean(self) -> float:
        """Mean."""
        return self._attributes["mean"]


    @mean.setter
    def mean(self, value: float) -> None:
        _set_attribute(self._attributes, "NumericStats", "mean", value, float, "")


    @property
    def count(self) -> int:
        """Count."""
        return self._attributes["count"]


    @count.setter
    def count(self, value: int) -> None:
        _set_attribute(self._attributes, "NumericStats", "count", value, int, "")


    @property
    def percentile25(self) -> float:
        """Percentile25."""
        return self._attributes["percentile25"]


    @percentile25.setter
    def percentile25(self, value: float) -> None:
        _set_attribute(self._attributes, "NumericStats", "percentile25", value, float, "")


    @property
    def percentile50(self) -> float:
        """Percentile50."""
        return self._attributes["percentile50"]


    @percentile50.setter
    def percentile50(self, value: float) -> None:
        _set_attribute(self._attributes, "NumericStats", "percentile50", value, float, "")


    @property
    def percentile75(self) -> float:
        """Percentile75."""
        return self._attributes["percentile75"]


    @percentile75.setter
    def percentile75(self, value: float) -> None:
        _set_attribute(self._attributes, "NumericStats", "percentile75", value, float, "")


    @property
    def null_count(self) -> int:
        """Null count."""
        return self._attributes["null_count"]


    @null_count.setter
    def null_count(self, value: int) -> None:
        _set_attribute(self._attributes, "NumericStats", "null_count", value, int, "")


    @property
    def num_nan(self) -> int:
        """Num nan."""
        return self._attributes["num_nan"]


    @num_nan.setter
    def num_nan(self, value: int) -> None:
        _set_attribute(self._attributes, "NumericStats", "num_nan", value, int, "")


    @property
    def num_values_histogram(self) -> Histogram:
        """Num values histogram."""
        return self._attributes["num_values_histogram"]


    @num_values_histogram.setter
    def num_values_histogram(self, value: Histogram) -> None:
        _set_attribute(self._attributes, "NumericStats", "num_values_histogram", value, Histogram, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.NumericStats, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.NumericStats:
        """Convert object to proto representation."""
        return management_types_pb2.NumericStats(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<NumericStats object " + repr(self.to_dict()) + ">"


class BillingAccount:
    """Billing account."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , email: str = ""
        , memo: str = ""
        , update_time: datetime = None
        , create_time: datetime = None
    , **kwargs) -> BillingAccount:
        self._attributes = dict()
        self.name = name
        self.email = email
        self.memo = memo
        self.update_time = update_time
        self.create_time = create_time

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "BillingAccount", "name", value, str, "")


    @property
    def email(self) -> str:
        """Email."""
        return self._attributes["email"]


    @email.setter
    def email(self, value: str) -> None:
        _set_attribute(self._attributes, "BillingAccount", "email", value, str, "")


    @property
    def memo(self) -> str:
        """Memo."""
        return self._attributes["memo"]


    @memo.setter
    def memo(self, value: str) -> None:
        _set_attribute(self._attributes, "BillingAccount", "memo", value, str, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "BillingAccount", "update_time", value, datetime, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "BillingAccount", "create_time", value, datetime, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.BillingAccount, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.BillingAccount:
        """Convert object to proto representation."""
        return management_types_pb2.BillingAccount(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BillingAccount object " + repr(self.to_dict()) + ">"


class Subscription:
    """Subscription."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , price: str = ""
        , payment_method: str = ""
        , update_time: datetime = None
        , create_time: datetime = None
        , active: bool = False
    , **kwargs) -> Subscription:
        self._attributes = dict()
        self.name = name
        self.price = price
        self.payment_method = payment_method
        self.update_time = update_time
        self.create_time = create_time
        self.active = active

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Subscription", "name", value, str, "")


    @property
    def price(self) -> str:
        """Price."""
        return self._attributes["price"]


    @price.setter
    def price(self, value: str) -> None:
        _set_attribute(self._attributes, "Subscription", "price", value, str, "")


    @property
    def payment_method(self) -> str:
        """Payment method."""
        return self._attributes["payment_method"]


    @payment_method.setter
    def payment_method(self, value: str) -> None:
        _set_attribute(self._attributes, "Subscription", "payment_method", value, str, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Subscription", "update_time", value, datetime, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Subscription", "create_time", value, datetime, "")


    @property
    def active(self) -> bool:
        """Active."""
        return self._attributes["active"]


    @active.setter
    def active(self, value: bool) -> None:
        _set_attribute(self._attributes, "Subscription", "active", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Subscription, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Subscription:
        """Convert object to proto representation."""
        return management_types_pb2.Subscription(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Subscription object " + repr(self.to_dict()) + ">"


class ProjectUsageRecord:
    """Project usage record."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , credits: int = 0
        , type_count: Dict[str, int] = None
    , **kwargs) -> ProjectUsageRecord:
        self._attributes = dict()
        self.name = name
        self.credits = credits
        self.type_count = type_count

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "ProjectUsageRecord", "name", value, str, "")


    @property
    def credits(self) -> int:
        """Credits."""
        return self._attributes["credits"]


    @credits.setter
    def credits(self, value: int) -> None:
        _set_attribute(self._attributes, "ProjectUsageRecord", "credits", value, int, "")


    @property
    def type_count(self) -> Dict[str, int]:
        """Type count."""
        return self._attributes["type_count"]


    @type_count.setter
    def type_count(self, value: Dict[str, int]) -> None:
        _set_attribute(self._attributes, "ProjectUsageRecord", "type_count", value, Dict[str, int], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.ProjectUsageRecord, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.ProjectUsageRecord:
        """Convert object to proto representation."""
        return management_types_pb2.ProjectUsageRecord(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ProjectUsageRecord object " + repr(self.to_dict()) + ">"


class CreditUsageRecord:
    """Credit usage record."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , period: datetime = None
        , credits: int = 0
        , project_usages: List[ProjectUsageRecord] = []
    , **kwargs) -> CreditUsageRecord:
        self._attributes = dict()
        self.period = period
        self.credits = credits
        self.project_usages = project_usages

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def period(self) -> datetime:
        """Period."""
        return self._attributes["period"]


    @period.setter
    def period(self, value: datetime) -> None:
        _set_attribute(self._attributes, "CreditUsageRecord", "period", value, datetime, "")


    @property
    def credits(self) -> int:
        """Credits."""
        return self._attributes["credits"]


    @credits.setter
    def credits(self, value: int) -> None:
        _set_attribute(self._attributes, "CreditUsageRecord", "credits", value, int, "")


    @property
    def project_usages(self) -> List[ProjectUsageRecord]:
        """Project usages."""
        return self._attributes["project_usages"]


    @project_usages.setter
    def project_usages(self, value: List[ProjectUsageRecord]) -> None:
        _set_attribute(self._attributes, "CreditUsageRecord", "project_usages", value, List[ProjectUsageRecord], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.CreditUsageRecord, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.CreditUsageRecord:
        """Convert object to proto representation."""
        return management_types_pb2.CreditUsageRecord(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreditUsageRecord object " + repr(self.to_dict()) + ">"


class InvoiceLineItem:
    """Invoice line item."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , id: str = ""
        , amount: int = 0
        , quantity: int = 0
        , currency: str = ""
        , description: str = ""
        , period_start: datetime = None
        , period_end: datetime = None
    , **kwargs) -> InvoiceLineItem:
        self._attributes = dict()
        self.id = id
        self.amount = amount
        self.quantity = quantity
        self.currency = currency
        self.description = description
        self.period_start = period_start
        self.period_end = period_end

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def id(self) -> str:
        """Id."""
        return self._attributes["id"]


    @id.setter
    def id(self, value: str) -> None:
        _set_attribute(self._attributes, "InvoiceLineItem", "id", value, str, "")


    @property
    def amount(self) -> int:
        """Amount."""
        return self._attributes["amount"]


    @amount.setter
    def amount(self, value: int) -> None:
        _set_attribute(self._attributes, "InvoiceLineItem", "amount", value, int, "")


    @property
    def quantity(self) -> int:
        """Quantity."""
        return self._attributes["quantity"]


    @quantity.setter
    def quantity(self, value: int) -> None:
        _set_attribute(self._attributes, "InvoiceLineItem", "quantity", value, int, "")


    @property
    def currency(self) -> str:
        """Currency."""
        return self._attributes["currency"]


    @currency.setter
    def currency(self, value: str) -> None:
        _set_attribute(self._attributes, "InvoiceLineItem", "currency", value, str, "")


    @property
    def description(self) -> str:
        """Description."""
        return self._attributes["description"]


    @description.setter
    def description(self, value: str) -> None:
        _set_attribute(self._attributes, "InvoiceLineItem", "description", value, str, "")


    @property
    def period_start(self) -> datetime:
        """Period start."""
        return self._attributes["period_start"]


    @period_start.setter
    def period_start(self, value: datetime) -> None:
        _set_attribute(self._attributes, "InvoiceLineItem", "period_start", value, datetime, "")


    @property
    def period_end(self) -> datetime:
        """Period end."""
        return self._attributes["period_end"]


    @period_end.setter
    def period_end(self, value: datetime) -> None:
        _set_attribute(self._attributes, "InvoiceLineItem", "period_end", value, datetime, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.InvoiceLineItem, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.InvoiceLineItem:
        """Convert object to proto representation."""
        return management_types_pb2.InvoiceLineItem(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<InvoiceLineItem object " + repr(self.to_dict()) + ">"


class Invoice:
    """Invoice."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , date: datetime = None
        , amount: int = 0
        , period_start: datetime = None
        , period_end: datetime = None
        , status: str = ""
        , invoice_url: str = ""
        , line_items: List[InvoiceLineItem] = []
    , **kwargs) -> Invoice:
        self._attributes = dict()
        self.name = name
        self.date = date
        self.amount = amount
        self.period_start = period_start
        self.period_end = period_end
        self.status = status
        self.invoice_url = invoice_url
        self.line_items = line_items

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Invoice", "name", value, str, "")


    @property
    def date(self) -> datetime:
        """Date."""
        return self._attributes["date"]


    @date.setter
    def date(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Invoice", "date", value, datetime, "")


    @property
    def amount(self) -> int:
        """Amount."""
        return self._attributes["amount"]


    @amount.setter
    def amount(self, value: int) -> None:
        _set_attribute(self._attributes, "Invoice", "amount", value, int, "")


    @property
    def period_start(self) -> datetime:
        """Period start."""
        return self._attributes["period_start"]


    @period_start.setter
    def period_start(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Invoice", "period_start", value, datetime, "")


    @property
    def period_end(self) -> datetime:
        """Period end."""
        return self._attributes["period_end"]


    @period_end.setter
    def period_end(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Invoice", "period_end", value, datetime, "")


    @property
    def status(self) -> str:
        """Status."""
        return self._attributes["status"]


    @status.setter
    def status(self, value: str) -> None:
        _set_attribute(self._attributes, "Invoice", "status", value, str, "")


    @property
    def invoice_url(self) -> str:
        """Invoice url."""
        return self._attributes["invoice_url"]


    @invoice_url.setter
    def invoice_url(self, value: str) -> None:
        _set_attribute(self._attributes, "Invoice", "invoice_url", value, str, "")


    @property
    def line_items(self) -> List[InvoiceLineItem]:
        """Line items."""
        return self._attributes["line_items"]


    @line_items.setter
    def line_items(self, value: List[InvoiceLineItem]) -> None:
        _set_attribute(self._attributes, "Invoice", "line_items", value, List[InvoiceLineItem], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Invoice, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Invoice:
        """Convert object to proto representation."""
        return management_types_pb2.Invoice(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Invoice object " + repr(self.to_dict()) + ">"


class Price:
    """Price."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , title: str = ""
        , description: str = ""
        , direct_invoice: bool = False
    , **kwargs) -> Price:
        self._attributes = dict()
        self.name = name
        self.title = title
        self.description = description
        self.direct_invoice = direct_invoice

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Price", "name", value, str, "")


    @property
    def title(self) -> str:
        """Title."""
        return self._attributes["title"]


    @title.setter
    def title(self, value: str) -> None:
        _set_attribute(self._attributes, "Price", "title", value, str, "")


    @property
    def description(self) -> str:
        """Description."""
        return self._attributes["description"]


    @description.setter
    def description(self, value: str) -> None:
        _set_attribute(self._attributes, "Price", "description", value, str, "")


    @property
    def direct_invoice(self) -> bool:
        """Direct invoice."""
        return self._attributes["direct_invoice"]


    @direct_invoice.setter
    def direct_invoice(self, value: bool) -> None:
        _set_attribute(self._attributes, "Price", "direct_invoice", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Price, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Price:
        """Convert object to proto representation."""
        return management_types_pb2.Price(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Price object " + repr(self.to_dict()) + ">"


class PaymentMethod:
    """Payment method."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , billing_details: PaymentMethodBillingDetails = None
        , card: PaymentMethodCard = None
    , **kwargs) -> PaymentMethod:
        self._attributes = dict()
        self.name = name
        self.billing_details = billing_details
        self.card = card

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "PaymentMethod", "name", value, str, "")


    @property
    def billing_details(self) -> PaymentMethodBillingDetails:
        """Billing details."""
        return self._attributes["billing_details"]


    @billing_details.setter
    def billing_details(self, value: PaymentMethodBillingDetails) -> None:
        _set_attribute(self._attributes, "PaymentMethod", "billing_details", value, PaymentMethodBillingDetails, "")


    @property
    def card(self) -> PaymentMethodCard:
        """Card."""
        return self._attributes["card"]


    @card.setter
    def card(self, value: PaymentMethodCard) -> None:
        _set_attribute(self._attributes, "PaymentMethod", "card", value, PaymentMethodCard, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.PaymentMethod, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.PaymentMethod:
        """Convert object to proto representation."""
        return management_types_pb2.PaymentMethod(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<PaymentMethod object " + repr(self.to_dict()) + ">"


class PaymentMethodBillingDetails:
    """Payment method billing details."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , postal_code: str = ""
    , **kwargs) -> PaymentMethodBillingDetails:
        self._attributes = dict()
        self.postal_code = postal_code

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def postal_code(self) -> str:
        """Postal code."""
        return self._attributes["postal_code"]


    @postal_code.setter
    def postal_code(self, value: str) -> None:
        _set_attribute(self._attributes, "PaymentMethodBillingDetails", "postal_code", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.PaymentMethod.BillingDetails, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.PaymentMethod.BillingDetails:
        """Convert object to proto representation."""
        return management_types_pb2.PaymentMethod.BillingDetails(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<PaymentMethodBillingDetails object " + repr(self.to_dict()) + ">"


class PaymentMethodCard:
    """Payment method card."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , brand: str = ""
        , last4: str = ""
        , exp_year: int = 0
        , exp_month: int = 0
    , **kwargs) -> PaymentMethodCard:
        self._attributes = dict()
        self.brand = brand
        self.last4 = last4
        self.exp_year = exp_year
        self.exp_month = exp_month

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def brand(self) -> str:
        """Brand."""
        return self._attributes["brand"]


    @brand.setter
    def brand(self, value: str) -> None:
        _set_attribute(self._attributes, "PaymentMethodCard", "brand", value, str, "")


    @property
    def last4(self) -> str:
        """Last4."""
        return self._attributes["last4"]


    @last4.setter
    def last4(self, value: str) -> None:
        _set_attribute(self._attributes, "PaymentMethodCard", "last4", value, str, "")


    @property
    def exp_year(self) -> int:
        """Exp year."""
        return self._attributes["exp_year"]


    @exp_year.setter
    def exp_year(self, value: int) -> None:
        _set_attribute(self._attributes, "PaymentMethodCard", "exp_year", value, int, "")


    @property
    def exp_month(self) -> int:
        """Exp month."""
        return self._attributes["exp_month"]


    @exp_month.setter
    def exp_month(self, value: int) -> None:
        _set_attribute(self._attributes, "PaymentMethodCard", "exp_month", value, int, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.PaymentMethod.Card, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.PaymentMethod.Card:
        """Convert object to proto representation."""
        return management_types_pb2.PaymentMethod.Card(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<PaymentMethodCard object " + repr(self.to_dict()) + ">"


class TrainingJobConfig:
    """Training job config."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , model_version: ModelVersion = None
        , model: Model = None
        , feature_sets: List[FeatureSet] = []
        , data_store: DataStore = None
        , tag: str = ""
        , evaluation_model_version: str = ""
        , evaluation_model_version_bucket: str = ""
        , evaluation_model_signature: str = ""
    , **kwargs) -> TrainingJobConfig:
        self._attributes = dict()
        self.model_version = model_version
        self.model = model
        self.feature_sets = feature_sets
        self.data_store = data_store
        self.tag = tag
        self.evaluation_model_version = evaluation_model_version
        self.evaluation_model_version_bucket = evaluation_model_version_bucket
        self.evaluation_model_signature = evaluation_model_signature

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def model_version(self) -> ModelVersion:
        """Model version."""
        return self._attributes["model_version"]


    @model_version.setter
    def model_version(self, value: ModelVersion) -> None:
        _set_attribute(self._attributes, "TrainingJobConfig", "model_version", value, ModelVersion, "")


    @property
    def model(self) -> Model:
        """Model."""
        return self._attributes["model"]


    @model.setter
    def model(self, value: Model) -> None:
        _set_attribute(self._attributes, "TrainingJobConfig", "model", value, Model, "")


    @property
    def feature_sets(self) -> List[FeatureSet]:
        """Feature sets."""
        return self._attributes["feature_sets"]


    @feature_sets.setter
    def feature_sets(self, value: List[FeatureSet]) -> None:
        _set_attribute(self._attributes, "TrainingJobConfig", "feature_sets", value, List[FeatureSet], "")


    @property
    def data_store(self) -> DataStore:
        """Data store."""
        return self._attributes["data_store"]


    @data_store.setter
    def data_store(self, value: DataStore) -> None:
        _set_attribute(self._attributes, "TrainingJobConfig", "data_store", value, DataStore, "")


    @property
    def tag(self) -> str:
        """Tag."""
        return self._attributes["tag"]


    @tag.setter
    def tag(self, value: str) -> None:
        _set_attribute(self._attributes, "TrainingJobConfig", "tag", value, str, "")


    @property
    def evaluation_model_version(self) -> str:
        """Evaluation model version."""
        return self._attributes["evaluation_model_version"]


    @evaluation_model_version.setter
    def evaluation_model_version(self, value: str) -> None:
        _set_attribute(self._attributes, "TrainingJobConfig", "evaluation_model_version", value, str, "")


    @property
    def evaluation_model_version_bucket(self) -> str:
        """Evaluation model version bucket."""
        return self._attributes["evaluation_model_version_bucket"]


    @evaluation_model_version_bucket.setter
    def evaluation_model_version_bucket(self, value: str) -> None:
        _set_attribute(self._attributes, "TrainingJobConfig", "evaluation_model_version_bucket", value, str, "")


    @property
    def evaluation_model_signature(self) -> str:
        """Evaluation model signature."""
        return self._attributes["evaluation_model_signature"]


    @evaluation_model_signature.setter
    def evaluation_model_signature(self, value: str) -> None:
        _set_attribute(self._attributes, "TrainingJobConfig", "evaluation_model_signature", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.TrainingJobConfig, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.TrainingJobConfig:
        """Convert object to proto representation."""
        return management_types_pb2.TrainingJobConfig(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<TrainingJobConfig object " + repr(self.to_dict()) + ">"


class BatchPredictionJobConfig:
    """Batch prediction job config."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , model: Model = None
        , model_version: str = ""
        , model_version_format: str = ""
        , data_store: DataStore = None
        , incremental: bool = False
        , feature_sets: List[FeatureSet] = []
        , prediction_model: str = ""
        , model_version_signature: str = ""
    , **kwargs) -> BatchPredictionJobConfig:
        self._attributes = dict()
        self.model = model
        self.model_version = model_version
        self.model_version_format = model_version_format
        self.data_store = data_store
        self.incremental = incremental
        self.feature_sets = feature_sets
        self.prediction_model = prediction_model
        self.model_version_signature = model_version_signature

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def model(self) -> Model:
        """Model."""
        return self._attributes["model"]


    @model.setter
    def model(self, value: Model) -> None:
        _set_attribute(self._attributes, "BatchPredictionJobConfig", "model", value, Model, "")


    @property
    def model_version(self) -> str:
        """Model version."""
        return self._attributes["model_version"]


    @model_version.setter
    def model_version(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchPredictionJobConfig", "model_version", value, str, "")


    @property
    def model_version_format(self) -> str:
        """Model version format."""
        return self._attributes["model_version_format"]


    @model_version_format.setter
    def model_version_format(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchPredictionJobConfig", "model_version_format", value, str, "")


    @property
    def data_store(self) -> DataStore:
        """Data store."""
        return self._attributes["data_store"]


    @data_store.setter
    def data_store(self, value: DataStore) -> None:
        _set_attribute(self._attributes, "BatchPredictionJobConfig", "data_store", value, DataStore, "")


    @property
    def incremental(self) -> bool:
        """Incremental."""
        return self._attributes["incremental"]


    @incremental.setter
    def incremental(self, value: bool) -> None:
        _set_attribute(self._attributes, "BatchPredictionJobConfig", "incremental", value, bool, "")


    @property
    def feature_sets(self) -> List[FeatureSet]:
        """Feature sets."""
        return self._attributes["feature_sets"]


    @feature_sets.setter
    def feature_sets(self, value: List[FeatureSet]) -> None:
        _set_attribute(self._attributes, "BatchPredictionJobConfig", "feature_sets", value, List[FeatureSet], "")


    @property
    def prediction_model(self) -> str:
        """Prediction model."""
        return self._attributes["prediction_model"]


    @prediction_model.setter
    def prediction_model(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchPredictionJobConfig", "prediction_model", value, str, "")


    @property
    def model_version_signature(self) -> str:
        """Model version signature."""
        return self._attributes["model_version_signature"]


    @model_version_signature.setter
    def model_version_signature(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchPredictionJobConfig", "model_version_signature", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.BatchPredictionJobConfig, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.BatchPredictionJobConfig:
        """Convert object to proto representation."""
        return management_types_pb2.BatchPredictionJobConfig(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchPredictionJobConfig object " + repr(self.to_dict()) + ">"


class Artifact:
    """Artifact."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , run_name: str = ""
        , external: bool = False
        , path: str = ""
        , url: str = ""
        , type: str = ""
        , mime_type: str = ""
        , metadata: str = ""
        , create_time: datetime = None
        , update_time: datetime = None
        , size: int = 0
        , key: str = ""
    , **kwargs) -> Artifact:
        self._attributes = dict()
        self.name = name
        self.run_name = run_name
        self.external = external
        self.path = path
        self.url = url
        self.type = type
        self.mime_type = mime_type
        self.metadata = metadata
        self.create_time = create_time
        self.update_time = update_time
        self.size = size
        self.key = key

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Artifact", "name", value, str, "")


    @property
    def run_name(self) -> str:
        """Run name."""
        return self._attributes["run_name"]


    @run_name.setter
    def run_name(self, value: str) -> None:
        _set_attribute(self._attributes, "Artifact", "run_name", value, str, "")


    @property
    def external(self) -> bool:
        """External."""
        return self._attributes["external"]


    @external.setter
    def external(self, value: bool) -> None:
        _set_attribute(self._attributes, "Artifact", "external", value, bool, "")


    @property
    def path(self) -> str:
        """Path."""
        return self._attributes["path"]


    @path.setter
    def path(self, value: str) -> None:
        _set_attribute(self._attributes, "Artifact", "path", value, str, "")


    @property
    def url(self) -> str:
        """Url."""
        return self._attributes["url"]


    @url.setter
    def url(self, value: str) -> None:
        _set_attribute(self._attributes, "Artifact", "url", value, str, "")


    @property
    def type(self) -> str:
        """Type."""
        return self._attributes["type"]


    @type.setter
    def type(self, value: str) -> None:
        _set_attribute(self._attributes, "Artifact", "type", value, str, "")


    @property
    def mime_type(self) -> str:
        """Mime type."""
        return self._attributes["mime_type"]


    @mime_type.setter
    def mime_type(self, value: str) -> None:
        _set_attribute(self._attributes, "Artifact", "mime_type", value, str, "")


    @property
    def metadata(self) -> str:
        """Metadata."""
        return self._attributes["metadata"]


    @metadata.setter
    def metadata(self, value: str) -> None:
        _set_attribute(self._attributes, "Artifact", "metadata", value, str, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Artifact", "create_time", value, datetime, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Artifact", "update_time", value, datetime, "")


    @property
    def size(self) -> int:
        """Size."""
        return self._attributes["size"]


    @size.setter
    def size(self, value: int) -> None:
        _set_attribute(self._attributes, "Artifact", "size", value, int, "")


    @property
    def key(self) -> str:
        """Key."""
        return self._attributes["key"]


    @key.setter
    def key(self, value: str) -> None:
        _set_attribute(self._attributes, "Artifact", "key", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Artifact, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Artifact:
        """Convert object to proto representation."""
        return management_types_pb2.Artifact(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Artifact object " + repr(self.to_dict()) + ">"


class CronJob:
    """Cron job."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , organization: str = ""
        , model: str = ""
        , job_type: str = ""
        , schedule: str = ""
        , organization_status: str = ""
        , status: str = ""
        , workflow_id: str = ""
        , run_id: str = ""
    , **kwargs) -> CronJob:
        self._attributes = dict()
        self.organization = organization
        self.model = model
        self.job_type = job_type
        self.schedule = schedule
        self.organization_status = organization_status
        self.status = status
        self.workflow_id = workflow_id
        self.run_id = run_id

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def organization(self) -> str:
        """Organization."""
        return self._attributes["organization"]


    @organization.setter
    def organization(self, value: str) -> None:
        _set_attribute(self._attributes, "CronJob", "organization", value, str, "")


    @property
    def model(self) -> str:
        """Model."""
        return self._attributes["model"]


    @model.setter
    def model(self, value: str) -> None:
        _set_attribute(self._attributes, "CronJob", "model", value, str, "")


    @property
    def job_type(self) -> str:
        """Job type."""
        return self._attributes["job_type"]


    @job_type.setter
    def job_type(self, value: str) -> None:
        _set_attribute(self._attributes, "CronJob", "job_type", value, str, "")


    @property
    def schedule(self) -> str:
        """Schedule."""
        return self._attributes["schedule"]


    @schedule.setter
    def schedule(self, value: str) -> None:
        _set_attribute(self._attributes, "CronJob", "schedule", value, str, "")


    @property
    def organization_status(self) -> str:
        """Organization status."""
        return self._attributes["organization_status"]


    @organization_status.setter
    def organization_status(self, value: str) -> None:
        _set_attribute(self._attributes, "CronJob", "organization_status", value, str, "")


    @property
    def status(self) -> str:
        """Status."""
        return self._attributes["status"]


    @status.setter
    def status(self, value: str) -> None:
        _set_attribute(self._attributes, "CronJob", "status", value, str, "")


    @property
    def workflow_id(self) -> str:
        """Workflow id."""
        return self._attributes["workflow_id"]


    @workflow_id.setter
    def workflow_id(self, value: str) -> None:
        _set_attribute(self._attributes, "CronJob", "workflow_id", value, str, "")


    @property
    def run_id(self) -> str:
        """Run id."""
        return self._attributes["run_id"]


    @run_id.setter
    def run_id(self, value: str) -> None:
        _set_attribute(self._attributes, "CronJob", "run_id", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.CronJob, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.CronJob:
        """Convert object to proto representation."""
        return management_types_pb2.CronJob(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CronJob object " + repr(self.to_dict()) + ">"


class UserIntegrationProvider:
    """User integration provider."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , provider: str = ""
        , name: str = ""
        , title: str = ""
        , integration_install_url: str = ""
    , **kwargs) -> UserIntegrationProvider:
        self._attributes = dict()
        self.provider = provider
        self.name = name
        self.title = title
        self.integration_install_url = integration_install_url

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def provider(self) -> str:
        """Provider."""
        return self._attributes["provider"]


    @provider.setter
    def provider(self, value: str) -> None:
        _set_attribute(self._attributes, "UserIntegrationProvider", "provider", value, str, "")


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "UserIntegrationProvider", "name", value, str, "")


    @property
    def title(self) -> str:
        """Title."""
        return self._attributes["title"]


    @title.setter
    def title(self, value: str) -> None:
        _set_attribute(self._attributes, "UserIntegrationProvider", "title", value, str, "")


    @property
    def integration_install_url(self) -> str:
        """Integration install url."""
        return self._attributes["integration_install_url"]


    @integration_install_url.setter
    def integration_install_url(self, value: str) -> None:
        _set_attribute(self._attributes, "UserIntegrationProvider", "integration_install_url", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.UserIntegrationProvider, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.UserIntegrationProvider:
        """Convert object to proto representation."""
        return management_types_pb2.UserIntegrationProvider(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<UserIntegrationProvider object " + repr(self.to_dict()) + ">"


class UserIntegration:
    """User integration."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , create_time: datetime = None
        , update_time: datetime = None
        , provider: str = ""
        , provider_name: str = ""
        , config: str = ""
        , data: str = ""
        , data_update_time: datetime = None
        , account_name: str = ""
        , account_full_name: str = ""
        , account_primary_email: str = ""
        , account_avatar_url: str = ""
        , account_url: str = ""
        , account_config_url: str = ""
        , disconnect_time: datetime = None
        , disconnect_reason: str = ""
        , disconnect_data: str = ""
    , **kwargs) -> UserIntegration:
        self._attributes = dict()
        self.name = name
        self.create_time = create_time
        self.update_time = update_time
        self.provider = provider
        self.provider_name = provider_name
        self.config = config
        self.data = data
        self.data_update_time = data_update_time
        self.account_name = account_name
        self.account_full_name = account_full_name
        self.account_primary_email = account_primary_email
        self.account_avatar_url = account_avatar_url
        self.account_url = account_url
        self.account_config_url = account_config_url
        self.disconnect_time = disconnect_time
        self.disconnect_reason = disconnect_reason
        self.disconnect_data = disconnect_data

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "UserIntegration", "name", value, str, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "UserIntegration", "create_time", value, datetime, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "UserIntegration", "update_time", value, datetime, "")


    @property
    def provider(self) -> str:
        """TODO: Make this an enum?"""
        return self._attributes["provider"]


    @provider.setter
    def provider(self, value: str) -> None:
        _set_attribute(self._attributes, "UserIntegration", "provider", value, str, "")


    @property
    def provider_name(self) -> str:
        """Provider name."""
        return self._attributes["provider_name"]


    @provider_name.setter
    def provider_name(self, value: str) -> None:
        _set_attribute(self._attributes, "UserIntegration", "provider_name", value, str, "")


    @property
    def config(self) -> str:
        """Config."""
        return self._attributes["config"]


    @config.setter
    def config(self, value: str) -> None:
        _set_attribute(self._attributes, "UserIntegration", "config", value, str, "")


    @property
    def data(self) -> str:
        """Data."""
        return self._attributes["data"]


    @data.setter
    def data(self, value: str) -> None:
        _set_attribute(self._attributes, "UserIntegration", "data", value, str, "")


    @property
    def data_update_time(self) -> datetime:
        """Data update time."""
        return self._attributes["data_update_time"]


    @data_update_time.setter
    def data_update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "UserIntegration", "data_update_time", value, datetime, "")


    @property
    def account_name(self) -> str:
        """Account name."""
        return self._attributes["account_name"]


    @account_name.setter
    def account_name(self, value: str) -> None:
        _set_attribute(self._attributes, "UserIntegration", "account_name", value, str, "")


    @property
    def account_full_name(self) -> str:
        """Account full name."""
        return self._attributes["account_full_name"]


    @account_full_name.setter
    def account_full_name(self, value: str) -> None:
        _set_attribute(self._attributes, "UserIntegration", "account_full_name", value, str, "")


    @property
    def account_primary_email(self) -> str:
        """Account primary email."""
        return self._attributes["account_primary_email"]


    @account_primary_email.setter
    def account_primary_email(self, value: str) -> None:
        _set_attribute(self._attributes, "UserIntegration", "account_primary_email", value, str, "")


    @property
    def account_avatar_url(self) -> str:
        """Account avatar url."""
        return self._attributes["account_avatar_url"]


    @account_avatar_url.setter
    def account_avatar_url(self, value: str) -> None:
        _set_attribute(self._attributes, "UserIntegration", "account_avatar_url", value, str, "")


    @property
    def account_url(self) -> str:
        """Account url."""
        return self._attributes["account_url"]


    @account_url.setter
    def account_url(self, value: str) -> None:
        _set_attribute(self._attributes, "UserIntegration", "account_url", value, str, "")


    @property
    def account_config_url(self) -> str:
        """Account config url."""
        return self._attributes["account_config_url"]


    @account_config_url.setter
    def account_config_url(self, value: str) -> None:
        _set_attribute(self._attributes, "UserIntegration", "account_config_url", value, str, "")


    @property
    def disconnect_time(self) -> datetime:
        """Disconnect time."""
        return self._attributes["disconnect_time"]


    @disconnect_time.setter
    def disconnect_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "UserIntegration", "disconnect_time", value, datetime, "")


    @property
    def disconnect_reason(self) -> str:
        """Disconnect reason."""
        return self._attributes["disconnect_reason"]


    @disconnect_reason.setter
    def disconnect_reason(self, value: str) -> None:
        _set_attribute(self._attributes, "UserIntegration", "disconnect_reason", value, str, "")


    @property
    def disconnect_data(self) -> str:
        """Disconnect data."""
        return self._attributes["disconnect_data"]


    @disconnect_data.setter
    def disconnect_data(self, value: str) -> None:
        _set_attribute(self._attributes, "UserIntegration", "disconnect_data", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.UserIntegration, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.UserIntegration:
        """Convert object to proto representation."""
        return management_types_pb2.UserIntegration(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<UserIntegration object " + repr(self.to_dict()) + ">"


class GitProvider:
    """Git provider."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , type: str = ""
        , app_name: str = ""
        , app_external_id: str = ""
        , installation_name: str = ""
        , installation_external_id: str = ""
    , **kwargs) -> GitProvider:
        self._attributes = dict()
        self.name = name
        self.type = type
        self.app_name = app_name
        self.app_external_id = app_external_id
        self.installation_name = installation_name
        self.installation_external_id = installation_external_id

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProvider", "name", value, str, "")


    @property
    def type(self) -> str:
        """Type."""
        return self._attributes["type"]


    @type.setter
    def type(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProvider", "type", value, str, "")


    @property
    def app_name(self) -> str:
        """App name."""
        return self._attributes["app_name"]


    @app_name.setter
    def app_name(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProvider", "app_name", value, str, "")


    @property
    def app_external_id(self) -> str:
        """App external id."""
        return self._attributes["app_external_id"]


    @app_external_id.setter
    def app_external_id(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProvider", "app_external_id", value, str, "")


    @property
    def installation_name(self) -> str:
        """Installation name."""
        return self._attributes["installation_name"]


    @installation_name.setter
    def installation_name(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProvider", "installation_name", value, str, "")


    @property
    def installation_external_id(self) -> str:
        """Installation external id."""
        return self._attributes["installation_external_id"]


    @installation_external_id.setter
    def installation_external_id(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProvider", "installation_external_id", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.GitProvider, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.GitProvider:
        """Convert object to proto representation."""
        return management_types_pb2.GitProvider(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GitProvider object " + repr(self.to_dict()) + ">"


class GitProviderNamespace:
    """Git provider namespace."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , provider: GitProvider = None
        , external_id: str = ""
        , type: str = ""
        , slug: str = ""
        , title: str = ""
        , avatar_url: str = ""
        , config_url: str = ""
        , access_type: str = ""
    , **kwargs) -> GitProviderNamespace:
        self._attributes = dict()
        self.name = name
        self.provider = provider
        self.external_id = external_id
        self.type = type
        self.slug = slug
        self.title = title
        self.avatar_url = avatar_url
        self.config_url = config_url
        self.access_type = access_type

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProviderNamespace", "name", value, str, "")


    @property
    def provider(self) -> GitProvider:
        """Provider."""
        return self._attributes["provider"]


    @provider.setter
    def provider(self, value: GitProvider) -> None:
        _set_attribute(self._attributes, "GitProviderNamespace", "provider", value, GitProvider, "")


    @property
    def external_id(self) -> str:
        """External id."""
        return self._attributes["external_id"]


    @external_id.setter
    def external_id(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProviderNamespace", "external_id", value, str, "")


    @property
    def type(self) -> str:
        """Type."""
        return self._attributes["type"]


    @type.setter
    def type(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProviderNamespace", "type", value, str, "")


    @property
    def slug(self) -> str:
        """Slug."""
        return self._attributes["slug"]


    @slug.setter
    def slug(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProviderNamespace", "slug", value, str, "")


    @property
    def title(self) -> str:
        """Title."""
        return self._attributes["title"]


    @title.setter
    def title(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProviderNamespace", "title", value, str, "")


    @property
    def avatar_url(self) -> str:
        """Avatar url."""
        return self._attributes["avatar_url"]


    @avatar_url.setter
    def avatar_url(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProviderNamespace", "avatar_url", value, str, "")


    @property
    def config_url(self) -> str:
        """Config url."""
        return self._attributes["config_url"]


    @config_url.setter
    def config_url(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProviderNamespace", "config_url", value, str, "")


    @property
    def access_type(self) -> str:
        """Access type."""
        return self._attributes["access_type"]


    @access_type.setter
    def access_type(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProviderNamespace", "access_type", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.GitProviderNamespace, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.GitProviderNamespace:
        """Convert object to proto representation."""
        return management_types_pb2.GitProviderNamespace(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GitProviderNamespace object " + repr(self.to_dict()) + ">"


class GitProviderRepository:
    """Git provider repository."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , provider_namespace: GitProviderNamespace = None
        , external_id: str = ""
        , slug: str = ""
        , title: str = ""
        , default_branch_name: str = ""
        , access_type: str = ""
        , url: str = ""
        , data: str = ""
        , data_update_time: datetime = None
    , **kwargs) -> GitProviderRepository:
        self._attributes = dict()
        self.name = name
        self.provider_namespace = provider_namespace
        self.external_id = external_id
        self.slug = slug
        self.title = title
        self.default_branch_name = default_branch_name
        self.access_type = access_type
        self.url = url
        self.data = data
        self.data_update_time = data_update_time

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProviderRepository", "name", value, str, "")


    @property
    def provider_namespace(self) -> GitProviderNamespace:
        """Provider namespace."""
        return self._attributes["provider_namespace"]


    @provider_namespace.setter
    def provider_namespace(self, value: GitProviderNamespace) -> None:
        _set_attribute(self._attributes, "GitProviderRepository", "provider_namespace", value, GitProviderNamespace, "")


    @property
    def external_id(self) -> str:
        """External id."""
        return self._attributes["external_id"]


    @external_id.setter
    def external_id(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProviderRepository", "external_id", value, str, "")


    @property
    def slug(self) -> str:
        """Slug."""
        return self._attributes["slug"]


    @slug.setter
    def slug(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProviderRepository", "slug", value, str, "")


    @property
    def title(self) -> str:
        """Title."""
        return self._attributes["title"]


    @title.setter
    def title(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProviderRepository", "title", value, str, "")


    @property
    def default_branch_name(self) -> str:
        """Default branch name."""
        return self._attributes["default_branch_name"]


    @default_branch_name.setter
    def default_branch_name(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProviderRepository", "default_branch_name", value, str, "")


    @property
    def access_type(self) -> str:
        """Access type."""
        return self._attributes["access_type"]


    @access_type.setter
    def access_type(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProviderRepository", "access_type", value, str, "")


    @property
    def url(self) -> str:
        """Url."""
        return self._attributes["url"]


    @url.setter
    def url(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProviderRepository", "url", value, str, "")


    @property
    def data(self) -> str:
        """Data."""
        return self._attributes["data"]


    @data.setter
    def data(self, value: str) -> None:
        _set_attribute(self._attributes, "GitProviderRepository", "data", value, str, "")


    @property
    def data_update_time(self) -> datetime:
        """Data update time."""
        return self._attributes["data_update_time"]


    @data_update_time.setter
    def data_update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "GitProviderRepository", "data_update_time", value, datetime, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.GitProviderRepository, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.GitProviderRepository:
        """Convert object to proto representation."""
        return management_types_pb2.GitProviderRepository(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GitProviderRepository object " + repr(self.to_dict()) + ">"


class CiCdConfig:
    """Ci cd config."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , runner_type: str = ""
        , runner_provider: str = ""
        , runner_provider_source: str = ""
        , main_env_run_on_git_push: bool = False
        , code_review_env_auto_create: bool = False
        , code_review_env_run_on_git_push: bool = False
    , **kwargs) -> CiCdConfig:
        self._attributes = dict()
        self.runner_type = runner_type
        self.runner_provider = runner_provider
        self.runner_provider_source = runner_provider_source
        self.main_env_run_on_git_push = main_env_run_on_git_push
        self.code_review_env_auto_create = code_review_env_auto_create
        self.code_review_env_run_on_git_push = code_review_env_run_on_git_push

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def runner_type(self) -> str:
        """"" when Unconfigured. Managed when Continual Cloud or Github Actions initialized by Continual. Custom otherwise"""
        return self._attributes["runner_type"]


    @runner_type.setter
    def runner_type(self, value: str) -> None:
        _set_attribute(self._attributes, "CiCdConfig", "runner_type", value, str, "")


    @property
    def runner_provider(self) -> str:
        """The runner provider name: Continual, Github Actions, BuildKite, ..."""
        return self._attributes["runner_provider"]


    @runner_provider.setter
    def runner_provider(self, value: str) -> None:
        _set_attribute(self._attributes, "CiCdConfig", "runner_provider", value, str, "")


    @property
    def runner_provider_source(self) -> str:
        """Where the runner metadata came from"""
        return self._attributes["runner_provider_source"]


    @runner_provider_source.setter
    def runner_provider_source(self, value: str) -> None:
        _set_attribute(self._attributes, "CiCdConfig", "runner_provider_source", value, str, "")


    @property
    def main_env_run_on_git_push(self) -> bool:
        """Main env run on git push."""
        return self._attributes["main_env_run_on_git_push"]


    @main_env_run_on_git_push.setter
    def main_env_run_on_git_push(self, value: bool) -> None:
        _set_attribute(self._attributes, "CiCdConfig", "main_env_run_on_git_push", value, bool, "")


    @property
    def code_review_env_auto_create(self) -> bool:
        """Code review env auto create."""
        return self._attributes["code_review_env_auto_create"]


    @code_review_env_auto_create.setter
    def code_review_env_auto_create(self, value: bool) -> None:
        _set_attribute(self._attributes, "CiCdConfig", "code_review_env_auto_create", value, bool, "")


    @property
    def code_review_env_run_on_git_push(self) -> bool:
        """Code review env run on git push."""
        return self._attributes["code_review_env_run_on_git_push"]


    @code_review_env_run_on_git_push.setter
    def code_review_env_run_on_git_push(self, value: bool) -> None:
        _set_attribute(self._attributes, "CiCdConfig", "code_review_env_run_on_git_push", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.CiCdConfig, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.CiCdConfig:
        """Convert object to proto representation."""
        return management_types_pb2.CiCdConfig(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CiCdConfig object " + repr(self.to_dict()) + ">"


class ProjectGitIntegration:
    """Project git integration."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , create_time: datetime = None
        , update_time: datetime = None
        , project: str = ""
        , git_provider: GitProvider = None
        , git_provider_namespace: GitProviderNamespace = None
        , git_provider_repository: GitProviderRepository = None
        , created_by_user: str = ""
        , created_by_user_integration: str = ""
        , disconnect_time: datetime = None
        , disconnect_reason: str = ""
        , disconnect_data: str = ""
        , cicd_config: CiCdConfig = None
    , **kwargs) -> ProjectGitIntegration:
        self._attributes = dict()
        self.name = name
        self.create_time = create_time
        self.update_time = update_time
        self.project = project
        self.git_provider = git_provider
        self.git_provider_namespace = git_provider_namespace
        self.git_provider_repository = git_provider_repository
        self.created_by_user = created_by_user
        self.created_by_user_integration = created_by_user_integration
        self.disconnect_time = disconnect_time
        self.disconnect_reason = disconnect_reason
        self.disconnect_data = disconnect_data
        self.cicd_config = cicd_config

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "ProjectGitIntegration", "name", value, str, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ProjectGitIntegration", "create_time", value, datetime, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ProjectGitIntegration", "update_time", value, datetime, "")


    @property
    def project(self) -> str:
        """Project."""
        return self._attributes["project"]


    @project.setter
    def project(self, value: str) -> None:
        _set_attribute(self._attributes, "ProjectGitIntegration", "project", value, str, "")


    @property
    def git_provider(self) -> GitProvider:
        """Git provider."""
        return self._attributes["git_provider"]


    @git_provider.setter
    def git_provider(self, value: GitProvider) -> None:
        _set_attribute(self._attributes, "ProjectGitIntegration", "git_provider", value, GitProvider, "")


    @property
    def git_provider_namespace(self) -> GitProviderNamespace:
        """Git provider namespace."""
        return self._attributes["git_provider_namespace"]


    @git_provider_namespace.setter
    def git_provider_namespace(self, value: GitProviderNamespace) -> None:
        _set_attribute(self._attributes, "ProjectGitIntegration", "git_provider_namespace", value, GitProviderNamespace, "")


    @property
    def git_provider_repository(self) -> GitProviderRepository:
        """Git provider repository."""
        return self._attributes["git_provider_repository"]


    @git_provider_repository.setter
    def git_provider_repository(self, value: GitProviderRepository) -> None:
        _set_attribute(self._attributes, "ProjectGitIntegration", "git_provider_repository", value, GitProviderRepository, "")


    @property
    def created_by_user(self) -> str:
        """Created by user."""
        return self._attributes["created_by_user"]


    @created_by_user.setter
    def created_by_user(self, value: str) -> None:
        _set_attribute(self._attributes, "ProjectGitIntegration", "created_by_user", value, str, "")


    @property
    def created_by_user_integration(self) -> str:
        """Created by user integration."""
        return self._attributes["created_by_user_integration"]


    @created_by_user_integration.setter
    def created_by_user_integration(self, value: str) -> None:
        _set_attribute(self._attributes, "ProjectGitIntegration", "created_by_user_integration", value, str, "")


    @property
    def disconnect_time(self) -> datetime:
        """Disconnect time."""
        return self._attributes["disconnect_time"]


    @disconnect_time.setter
    def disconnect_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ProjectGitIntegration", "disconnect_time", value, datetime, "")


    @property
    def disconnect_reason(self) -> str:
        """Disconnect reason."""
        return self._attributes["disconnect_reason"]


    @disconnect_reason.setter
    def disconnect_reason(self, value: str) -> None:
        _set_attribute(self._attributes, "ProjectGitIntegration", "disconnect_reason", value, str, "")


    @property
    def disconnect_data(self) -> str:
        """Disconnect data."""
        return self._attributes["disconnect_data"]


    @disconnect_data.setter
    def disconnect_data(self, value: str) -> None:
        _set_attribute(self._attributes, "ProjectGitIntegration", "disconnect_data", value, str, "")


    @property
    def cicd_config(self) -> CiCdConfig:
        """Cicd config."""
        return self._attributes["cicd_config"]


    @cicd_config.setter
    def cicd_config(self, value: CiCdConfig) -> None:
        _set_attribute(self._attributes, "ProjectGitIntegration", "cicd_config", value, CiCdConfig, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.ProjectGitIntegration, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.ProjectGitIntegration:
        """Convert object to proto representation."""
        return management_types_pb2.ProjectGitIntegration(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ProjectGitIntegration object " + repr(self.to_dict()) + ">"


class EnvironmentGitIntegration:
    """Environment git integration."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , create_time: datetime = None
        , update_time: datetime = None
        , environment: str = ""
        , created_by_user: str = ""
        , created_for_project_git_integration: str = ""
        , branch_name: str = ""
        , base_directory_path: str = ""
        , disconnect_time: datetime = None
        , disconnect_reason: str = ""
        , disconnect_data: str = ""
        , cicd_run_on_git_push: bool = False
    , **kwargs) -> EnvironmentGitIntegration:
        self._attributes = dict()
        self.name = name
        self.create_time = create_time
        self.update_time = update_time
        self.environment = environment
        self.created_by_user = created_by_user
        self.created_for_project_git_integration = created_for_project_git_integration
        self.branch_name = branch_name
        self.base_directory_path = base_directory_path
        self.disconnect_time = disconnect_time
        self.disconnect_reason = disconnect_reason
        self.disconnect_data = disconnect_data
        self.cicd_run_on_git_push = cicd_run_on_git_push

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "EnvironmentGitIntegration", "name", value, str, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "EnvironmentGitIntegration", "create_time", value, datetime, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "EnvironmentGitIntegration", "update_time", value, datetime, "")


    @property
    def environment(self) -> str:
        """Environment."""
        return self._attributes["environment"]


    @environment.setter
    def environment(self, value: str) -> None:
        _set_attribute(self._attributes, "EnvironmentGitIntegration", "environment", value, str, "")


    @property
    def created_by_user(self) -> str:
        """Created by user."""
        return self._attributes["created_by_user"]


    @created_by_user.setter
    def created_by_user(self, value: str) -> None:
        _set_attribute(self._attributes, "EnvironmentGitIntegration", "created_by_user", value, str, "")


    @property
    def created_for_project_git_integration(self) -> str:
        """Created for project git integration."""
        return self._attributes["created_for_project_git_integration"]


    @created_for_project_git_integration.setter
    def created_for_project_git_integration(self, value: str) -> None:
        _set_attribute(self._attributes, "EnvironmentGitIntegration", "created_for_project_git_integration", value, str, "")


    @property
    def branch_name(self) -> str:
        """Branch name."""
        return self._attributes["branch_name"]


    @branch_name.setter
    def branch_name(self, value: str) -> None:
        _set_attribute(self._attributes, "EnvironmentGitIntegration", "branch_name", value, str, "")


    @property
    def base_directory_path(self) -> str:
        """Base directory path."""
        return self._attributes["base_directory_path"]


    @base_directory_path.setter
    def base_directory_path(self, value: str) -> None:
        _set_attribute(self._attributes, "EnvironmentGitIntegration", "base_directory_path", value, str, "")


    @property
    def disconnect_time(self) -> datetime:
        """Disconnect time."""
        return self._attributes["disconnect_time"]


    @disconnect_time.setter
    def disconnect_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "EnvironmentGitIntegration", "disconnect_time", value, datetime, "")


    @property
    def disconnect_reason(self) -> str:
        """Disconnect reason."""
        return self._attributes["disconnect_reason"]


    @disconnect_reason.setter
    def disconnect_reason(self, value: str) -> None:
        _set_attribute(self._attributes, "EnvironmentGitIntegration", "disconnect_reason", value, str, "")


    @property
    def disconnect_data(self) -> str:
        """Disconnect data."""
        return self._attributes["disconnect_data"]


    @disconnect_data.setter
    def disconnect_data(self, value: str) -> None:
        _set_attribute(self._attributes, "EnvironmentGitIntegration", "disconnect_data", value, str, "")


    @property
    def cicd_run_on_git_push(self) -> bool:
        """Cicd run on git push."""
        return self._attributes["cicd_run_on_git_push"]


    @cicd_run_on_git_push.setter
    def cicd_run_on_git_push(self, value: bool) -> None:
        _set_attribute(self._attributes, "EnvironmentGitIntegration", "cicd_run_on_git_push", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.EnvironmentGitIntegration, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.EnvironmentGitIntegration:
        """Convert object to proto representation."""
        return management_types_pb2.EnvironmentGitIntegration(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<EnvironmentGitIntegration object " + repr(self.to_dict()) + ">"


class Metric:
    """Metric."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , description: str = ""
        , key: str = ""
        , run_name: str = ""
        , value: float = 0.0
        , create_time: datetime = None
        , update_time: datetime = None
        , direction: MetricDirection = 0
        , group_name: str = ""
        , step: int = 0
    , **kwargs) -> Metric:
        self._attributes = dict()
        self.name = name
        self.description = description
        self.key = key
        self.run_name = run_name
        self.value = value
        self.create_time = create_time
        self.update_time = update_time
        self.direction = direction
        self.group_name = group_name
        self.step = step

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Metric", "name", value, str, "")


    @property
    def description(self) -> str:
        """Description."""
        return self._attributes["description"]


    @description.setter
    def description(self, value: str) -> None:
        _set_attribute(self._attributes, "Metric", "description", value, str, "")


    @property
    def key(self) -> str:
        """Key."""
        return self._attributes["key"]


    @key.setter
    def key(self, value: str) -> None:
        _set_attribute(self._attributes, "Metric", "key", value, str, "")


    @property
    def run_name(self) -> str:
        """Run name."""
        return self._attributes["run_name"]


    @run_name.setter
    def run_name(self, value: str) -> None:
        _set_attribute(self._attributes, "Metric", "run_name", value, str, "")


    @property
    def value(self) -> float:
        """Value."""
        return self._attributes["value"]


    @value.setter
    def value(self, value: float) -> None:
        _set_attribute(self._attributes, "Metric", "value", value, float, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Metric", "create_time", value, datetime, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Metric", "update_time", value, datetime, "")


    @property
    def direction(self) -> MetricDirection:
        """Direction."""
        return self._attributes["direction"]


    @direction.setter
    def direction(self, value: MetricDirection) -> None:
        _set_attribute(self._attributes, "Metric", "direction", value, MetricDirection, "")


    @property
    def group_name(self) -> str:
        """Group name."""
        return self._attributes["group_name"]


    @group_name.setter
    def group_name(self, value: str) -> None:
        _set_attribute(self._attributes, "Metric", "group_name", value, str, "")


    @property
    def step(self) -> int:
        """Step."""
        return self._attributes["step"]


    @step.setter
    def step(self, value: int) -> None:
        _set_attribute(self._attributes, "Metric", "step", value, int, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Metric, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Metric:
        """Convert object to proto representation."""
        return management_types_pb2.Metric(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Metric object " + repr(self.to_dict()) + ">"


class Metadata:
    """Metadata."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , key: str = ""
        , create_time: datetime = None
        , update_time: datetime = None
        , data: str = ""
        , type: MetadataType = 0
        , group_name: str = ""
    , **kwargs) -> Metadata:
        self._attributes = dict()
        self.name = name
        self.key = key
        self.create_time = create_time
        self.update_time = update_time
        self.data = data
        self.type = type
        self.group_name = group_name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Metadata", "name", value, str, "")


    @property
    def key(self) -> str:
        """Key."""
        return self._attributes["key"]


    @key.setter
    def key(self, value: str) -> None:
        _set_attribute(self._attributes, "Metadata", "key", value, str, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Metadata", "create_time", value, datetime, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Metadata", "update_time", value, datetime, "")


    @property
    def data(self) -> str:
        """Data."""
        return self._attributes["data"]


    @data.setter
    def data(self, value: str) -> None:
        _set_attribute(self._attributes, "Metadata", "data", value, str, "")


    @property
    def type(self) -> MetadataType:
        """Type."""
        return self._attributes["type"]


    @type.setter
    def type(self, value: MetadataType) -> None:
        _set_attribute(self._attributes, "Metadata", "type", value, MetadataType, "")


    @property
    def group_name(self) -> str:
        """Group name."""
        return self._attributes["group_name"]


    @group_name.setter
    def group_name(self, value: str) -> None:
        _set_attribute(self._attributes, "Metadata", "group_name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Metadata, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Metadata:
        """Convert object to proto representation."""
        return management_types_pb2.Metadata(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Metadata object " + repr(self.to_dict()) + ">"


class GitContextMetadata:
    """Git context metadata."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , repository: GitContextMetadataRepository = None
        , branch: GitContextMetadataBranch = None
        , tags: GitContextMetadataGitTags = None
        , ref: GitContextMetadataRef = None
        , commit: GitContextMetadataCommit = None
        , head: GitContextMetadataHead = None
        , is_dirty: bool = False
    , **kwargs) -> GitContextMetadata:
        self._attributes = dict()
        self.repository = repository
        self.branch = branch
        self.tags = tags
        self.ref = ref
        self.commit = commit
        self.head = head
        self.is_dirty = is_dirty

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def repository(self) -> GitContextMetadataRepository:
        """Repository."""
        return self._attributes["repository"]


    @repository.setter
    def repository(self, value: GitContextMetadataRepository) -> None:
        _set_attribute(self._attributes, "GitContextMetadata", "repository", value, GitContextMetadataRepository, "")


    @property
    def branch(self) -> GitContextMetadataBranch:
        """Branch."""
        return self._attributes["branch"]


    @branch.setter
    def branch(self, value: GitContextMetadataBranch) -> None:
        _set_attribute(self._attributes, "GitContextMetadata", "branch", value, GitContextMetadataBranch, "")


    @property
    def tags(self) -> GitContextMetadataGitTags:
        """Tags."""
        return self._attributes["tags"]


    @tags.setter
    def tags(self, value: GitContextMetadataGitTags) -> None:
        _set_attribute(self._attributes, "GitContextMetadata", "tags", value, GitContextMetadataGitTags, "")


    @property
    def ref(self) -> GitContextMetadataRef:
        """Ref."""
        return self._attributes["ref"]


    @ref.setter
    def ref(self, value: GitContextMetadataRef) -> None:
        _set_attribute(self._attributes, "GitContextMetadata", "ref", value, GitContextMetadataRef, "")


    @property
    def commit(self) -> GitContextMetadataCommit:
        """Commit."""
        return self._attributes["commit"]


    @commit.setter
    def commit(self, value: GitContextMetadataCommit) -> None:
        _set_attribute(self._attributes, "GitContextMetadata", "commit", value, GitContextMetadataCommit, "")


    @property
    def head(self) -> GitContextMetadataHead:
        """Head."""
        return self._attributes["head"]


    @head.setter
    def head(self, value: GitContextMetadataHead) -> None:
        _set_attribute(self._attributes, "GitContextMetadata", "head", value, GitContextMetadataHead, "")


    @property
    def is_dirty(self) -> bool:
        """Is dirty."""
        return self._attributes["is_dirty"]


    @is_dirty.setter
    def is_dirty(self, value: bool) -> None:
        _set_attribute(self._attributes, "GitContextMetadata", "is_dirty", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.GitContextMetadata, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.GitContextMetadata:
        """Convert object to proto representation."""
        return management_types_pb2.GitContextMetadata(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GitContextMetadata object " + repr(self.to_dict()) + ">"


class GitContextMetadataRepository:
    """Git context metadata repository."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , name_local: str = ""
        , name_remote_origin: str = ""
        , remote_origin_url: str = ""
        , is_bare: bool = False
    , **kwargs) -> GitContextMetadataRepository:
        self._attributes = dict()
        self.name = name
        self.name_local = name_local
        self.name_remote_origin = name_remote_origin
        self.remote_origin_url = remote_origin_url
        self.is_bare = is_bare

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GitContextMetadataRepository", "name", value, str, "")


    @property
    def name_local(self) -> str:
        """Name local."""
        return self._attributes["name_local"]


    @name_local.setter
    def name_local(self, value: str) -> None:
        _set_attribute(self._attributes, "GitContextMetadataRepository", "name_local", value, str, "")


    @property
    def name_remote_origin(self) -> str:
        """Name remote origin."""
        return self._attributes["name_remote_origin"]


    @name_remote_origin.setter
    def name_remote_origin(self, value: str) -> None:
        _set_attribute(self._attributes, "GitContextMetadataRepository", "name_remote_origin", value, str, "")


    @property
    def remote_origin_url(self) -> str:
        """Remote origin url."""
        return self._attributes["remote_origin_url"]


    @remote_origin_url.setter
    def remote_origin_url(self, value: str) -> None:
        _set_attribute(self._attributes, "GitContextMetadataRepository", "remote_origin_url", value, str, "")


    @property
    def is_bare(self) -> bool:
        """Is bare."""
        return self._attributes["is_bare"]


    @is_bare.setter
    def is_bare(self, value: bool) -> None:
        _set_attribute(self._attributes, "GitContextMetadataRepository", "is_bare", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.GitContextMetadata.Repository, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.GitContextMetadata.Repository:
        """Convert object to proto representation."""
        return management_types_pb2.GitContextMetadata.Repository(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GitContextMetadataRepository object " + repr(self.to_dict()) + ">"


class GitContextMetadataCommit:
    """Git context metadata commit."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , sha: str = ""
        , message: str = ""
        , authored_datetime: datetime = None
        , author: GitContextMetadataAuthor = None
        , committed_datetime: datetime = None
        , committer: GitContextMetadataCommitter = None
    , **kwargs) -> GitContextMetadataCommit:
        self._attributes = dict()
        self.sha = sha
        self.message = message
        self.authored_datetime = authored_datetime
        self.author = author
        self.committed_datetime = committed_datetime
        self.committer = committer

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def sha(self) -> str:
        """Sha."""
        return self._attributes["sha"]


    @sha.setter
    def sha(self, value: str) -> None:
        _set_attribute(self._attributes, "GitContextMetadataCommit", "sha", value, str, "")


    @property
    def message(self) -> str:
        """Message."""
        return self._attributes["message"]


    @message.setter
    def message(self, value: str) -> None:
        _set_attribute(self._attributes, "GitContextMetadataCommit", "message", value, str, "")


    @property
    def authored_datetime(self) -> datetime:
        """Authored datetime."""
        return self._attributes["authored_datetime"]


    @authored_datetime.setter
    def authored_datetime(self, value: datetime) -> None:
        _set_attribute(self._attributes, "GitContextMetadataCommit", "authored_datetime", value, datetime, "")


    @property
    def author(self) -> GitContextMetadataAuthor:
        """Author."""
        return self._attributes["author"]


    @author.setter
    def author(self, value: GitContextMetadataAuthor) -> None:
        _set_attribute(self._attributes, "GitContextMetadataCommit", "author", value, GitContextMetadataAuthor, "")


    @property
    def committed_datetime(self) -> datetime:
        """Committed datetime."""
        return self._attributes["committed_datetime"]


    @committed_datetime.setter
    def committed_datetime(self, value: datetime) -> None:
        _set_attribute(self._attributes, "GitContextMetadataCommit", "committed_datetime", value, datetime, "")


    @property
    def committer(self) -> GitContextMetadataCommitter:
        """Committer."""
        return self._attributes["committer"]


    @committer.setter
    def committer(self, value: GitContextMetadataCommitter) -> None:
        _set_attribute(self._attributes, "GitContextMetadataCommit", "committer", value, GitContextMetadataCommitter, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.GitContextMetadata.Commit, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.GitContextMetadata.Commit:
        """Convert object to proto representation."""
        return management_types_pb2.GitContextMetadata.Commit(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GitContextMetadataCommit object " + repr(self.to_dict()) + ">"


class GitContextMetadataBranch:
    """Git context metadata branch."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GitContextMetadataBranch:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GitContextMetadataBranch", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.GitContextMetadata.Branch, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.GitContextMetadata.Branch:
        """Convert object to proto representation."""
        return management_types_pb2.GitContextMetadata.Branch(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GitContextMetadataBranch object " + repr(self.to_dict()) + ">"


class GitContextMetadataGitTag:
    """Git context metadata git tag."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , name_describe: str = ""
    , **kwargs) -> GitContextMetadataGitTag:
        self._attributes = dict()
        self.name = name
        self.name_describe = name_describe

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GitContextMetadataGitTag", "name", value, str, "")


    @property
    def name_describe(self) -> str:
        """Name describe."""
        return self._attributes["name_describe"]


    @name_describe.setter
    def name_describe(self, value: str) -> None:
        _set_attribute(self._attributes, "GitContextMetadataGitTag", "name_describe", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.GitContextMetadata.GitTag, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.GitContextMetadata.GitTag:
        """Convert object to proto representation."""
        return management_types_pb2.GitContextMetadata.GitTag(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GitContextMetadataGitTag object " + repr(self.to_dict()) + ">"


class GitContextMetadataGitTags:
    """Git context metadata git tags."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , current: GitContextMetadataGitTag = None
        , reachable: GitContextMetadataGitTag = None
    , **kwargs) -> GitContextMetadataGitTags:
        self._attributes = dict()
        self.current = current
        self.reachable = reachable

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def current(self) -> GitContextMetadataGitTag:
        """Current."""
        return self._attributes["current"]


    @current.setter
    def current(self, value: GitContextMetadataGitTag) -> None:
        _set_attribute(self._attributes, "GitContextMetadataGitTags", "current", value, GitContextMetadataGitTag, "")


    @property
    def reachable(self) -> GitContextMetadataGitTag:
        """Reachable."""
        return self._attributes["reachable"]


    @reachable.setter
    def reachable(self, value: GitContextMetadataGitTag) -> None:
        _set_attribute(self._attributes, "GitContextMetadataGitTags", "reachable", value, GitContextMetadataGitTag, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.GitContextMetadata.GitTags, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.GitContextMetadata.GitTags:
        """Convert object to proto representation."""
        return management_types_pb2.GitContextMetadata.GitTags(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GitContextMetadataGitTags object " + repr(self.to_dict()) + ">"


class GitContextMetadataRef:
    """Git context metadata ref."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , path: str = ""
    , **kwargs) -> GitContextMetadataRef:
        self._attributes = dict()
        self.path = path

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def path(self) -> str:
        """Path."""
        return self._attributes["path"]


    @path.setter
    def path(self, value: str) -> None:
        _set_attribute(self._attributes, "GitContextMetadataRef", "path", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.GitContextMetadata.Ref, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.GitContextMetadata.Ref:
        """Convert object to proto representation."""
        return management_types_pb2.GitContextMetadata.Ref(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GitContextMetadataRef object " + repr(self.to_dict()) + ">"


class GitContextMetadataAuthor:
    """Git context metadata author."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , email: str = ""
    , **kwargs) -> GitContextMetadataAuthor:
        self._attributes = dict()
        self.name = name
        self.email = email

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GitContextMetadataAuthor", "name", value, str, "")


    @property
    def email(self) -> str:
        """Email."""
        return self._attributes["email"]


    @email.setter
    def email(self, value: str) -> None:
        _set_attribute(self._attributes, "GitContextMetadataAuthor", "email", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.GitContextMetadata.Author, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.GitContextMetadata.Author:
        """Convert object to proto representation."""
        return management_types_pb2.GitContextMetadata.Author(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GitContextMetadataAuthor object " + repr(self.to_dict()) + ">"


class GitContextMetadataCommitter:
    """Git context metadata committer."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , email: str = ""
    , **kwargs) -> GitContextMetadataCommitter:
        self._attributes = dict()
        self.name = name
        self.email = email

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GitContextMetadataCommitter", "name", value, str, "")


    @property
    def email(self) -> str:
        """Email."""
        return self._attributes["email"]


    @email.setter
    def email(self, value: str) -> None:
        _set_attribute(self._attributes, "GitContextMetadataCommitter", "email", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.GitContextMetadata.Committer, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.GitContextMetadata.Committer:
        """Convert object to proto representation."""
        return management_types_pb2.GitContextMetadata.Committer(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GitContextMetadataCommitter object " + repr(self.to_dict()) + ">"


class GitContextMetadataHead:
    """Git context metadata head."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , is_detached: bool = False
    , **kwargs) -> GitContextMetadataHead:
        self._attributes = dict()
        self.is_detached = is_detached

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def is_detached(self) -> bool:
        """Is detached."""
        return self._attributes["is_detached"]


    @is_detached.setter
    def is_detached(self, value: bool) -> None:
        _set_attribute(self._attributes, "GitContextMetadataHead", "is_detached", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.GitContextMetadata.Head, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.GitContextMetadata.Head:
        """Convert object to proto representation."""
        return management_types_pb2.GitContextMetadata.Head(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GitContextMetadataHead object " + repr(self.to_dict()) + ">"


class RunSummary:
    """Run summary."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , model_versions: List[ModelVersion] = []
        , batch_predictions: List[RunSummaryResource] = []
        , promotions: List[RunSummaryResource] = []
        , deployments: List[RunSummaryResource] = []
        , git_context_metadata: GitContextMetadata = None
        , principal: Principal = None
        , create_time: datetime = None
        , associated_models: List[Model] = []
        , associated_datasets: List[Dataset] = []
        , dataset_versions: List[DatasetVersion] = []
    , **kwargs) -> RunSummary:
        self._attributes = dict()
        self.model_versions = model_versions
        self.batch_predictions = batch_predictions
        self.promotions = promotions
        self.deployments = deployments
        self.git_context_metadata = git_context_metadata
        self.principal = principal
        self.create_time = create_time
        self.associated_models = associated_models
        self.associated_datasets = associated_datasets
        self.dataset_versions = dataset_versions

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def model_versions(self) -> List[ModelVersion]:
        """Model versions."""
        return self._attributes["model_versions"]


    @model_versions.setter
    def model_versions(self, value: List[ModelVersion]) -> None:
        _set_attribute(self._attributes, "RunSummary", "model_versions", value, List[ModelVersion], "")


    @property
    def batch_predictions(self) -> List[RunSummaryResource]:
        """Batch predictions."""
        return self._attributes["batch_predictions"]


    @batch_predictions.setter
    def batch_predictions(self, value: List[RunSummaryResource]) -> None:
        _set_attribute(self._attributes, "RunSummary", "batch_predictions", value, List[RunSummaryResource], "")


    @property
    def promotions(self) -> List[RunSummaryResource]:
        """Promotions."""
        return self._attributes["promotions"]


    @promotions.setter
    def promotions(self, value: List[RunSummaryResource]) -> None:
        _set_attribute(self._attributes, "RunSummary", "promotions", value, List[RunSummaryResource], "")


    @property
    def deployments(self) -> List[RunSummaryResource]:
        """Deployments."""
        return self._attributes["deployments"]


    @deployments.setter
    def deployments(self, value: List[RunSummaryResource]) -> None:
        _set_attribute(self._attributes, "RunSummary", "deployments", value, List[RunSummaryResource], "")


    @property
    def git_context_metadata(self) -> GitContextMetadata:
        """Git context metadata."""
        return self._attributes["git_context_metadata"]


    @git_context_metadata.setter
    def git_context_metadata(self, value: GitContextMetadata) -> None:
        _set_attribute(self._attributes, "RunSummary", "git_context_metadata", value, GitContextMetadata, "")


    @property
    def principal(self) -> Principal:
        """Principal."""
        return self._attributes["principal"]


    @principal.setter
    def principal(self, value: Principal) -> None:
        _set_attribute(self._attributes, "RunSummary", "principal", value, Principal, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "RunSummary", "create_time", value, datetime, "")


    @property
    def associated_models(self) -> List[Model]:
        """Associated models."""
        return self._attributes["associated_models"]


    @associated_models.setter
    def associated_models(self, value: List[Model]) -> None:
        _set_attribute(self._attributes, "RunSummary", "associated_models", value, List[Model], "")


    @property
    def associated_datasets(self) -> List[Dataset]:
        """Associated datasets."""
        return self._attributes["associated_datasets"]


    @associated_datasets.setter
    def associated_datasets(self, value: List[Dataset]) -> None:
        _set_attribute(self._attributes, "RunSummary", "associated_datasets", value, List[Dataset], "")


    @property
    def dataset_versions(self) -> List[DatasetVersion]:
        """Dataset versions."""
        return self._attributes["dataset_versions"]


    @dataset_versions.setter
    def dataset_versions(self, value: List[DatasetVersion]) -> None:
        _set_attribute(self._attributes, "RunSummary", "dataset_versions", value, List[DatasetVersion], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.RunSummary, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.RunSummary:
        """Convert object to proto representation."""
        return management_types_pb2.RunSummary(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<RunSummary object " + repr(self.to_dict()) + ">"


class RunSummaryResource:
    """Run summary resource."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , state: str = ""
    , **kwargs) -> RunSummaryResource:
        self._attributes = dict()
        self.name = name
        self.state = state

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "RunSummaryResource", "name", value, str, "")


    @property
    def state(self) -> str:
        """State."""
        return self._attributes["state"]


    @state.setter
    def state(self, value: str) -> None:
        _set_attribute(self._attributes, "RunSummaryResource", "state", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.RunSummary.Resource, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.RunSummary.Resource:
        """Convert object to proto representation."""
        return management_types_pb2.RunSummary.Resource(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<RunSummaryResource object " + repr(self.to_dict()) + ">"


class Run:
    """Run."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , description: str = ""
        , author: str = ""
        , create_time: datetime = None
        , update_time: datetime = None
        , last_heartbeat: datetime = None
        , heartbeat_interval: int = 0
        , state: RunState = 0
        , error_message: str = ""
    , **kwargs) -> Run:
        self._attributes = dict()
        self.name = name
        self.description = description
        self.author = author
        self.create_time = create_time
        self.update_time = update_time
        self.last_heartbeat = last_heartbeat
        self.heartbeat_interval = heartbeat_interval
        self.state = state
        self.error_message = error_message

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Run", "name", value, str, "")


    @property
    def description(self) -> str:
        """Description."""
        return self._attributes["description"]


    @description.setter
    def description(self, value: str) -> None:
        _set_attribute(self._attributes, "Run", "description", value, str, "")


    @property
    def author(self) -> str:
        """Author."""
        return self._attributes["author"]


    @author.setter
    def author(self, value: str) -> None:
        _set_attribute(self._attributes, "Run", "author", value, str, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Run", "create_time", value, datetime, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Run", "update_time", value, datetime, "")


    @property
    def last_heartbeat(self) -> datetime:
        """Last heartbeat."""
        return self._attributes["last_heartbeat"]


    @last_heartbeat.setter
    def last_heartbeat(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Run", "last_heartbeat", value, datetime, "")


    @property
    def heartbeat_interval(self) -> int:
        """Heartbeat interval."""
        return self._attributes["heartbeat_interval"]


    @heartbeat_interval.setter
    def heartbeat_interval(self, value: int) -> None:
        _set_attribute(self._attributes, "Run", "heartbeat_interval", value, int, "")


    @property
    def state(self) -> RunState:
        """State."""
        return self._attributes["state"]


    @state.setter
    def state(self, value: RunState) -> None:
        _set_attribute(self._attributes, "Run", "state", value, RunState, "")


    @property
    def error_message(self) -> str:
        """Error message."""
        return self._attributes["error_message"]


    @error_message.setter
    def error_message(self, value: str) -> None:
        _set_attribute(self._attributes, "Run", "error_message", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Run, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Run:
        """Convert object to proto representation."""
        return management_types_pb2.Run(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Run object " + repr(self.to_dict()) + ">"


class Tag:
    """Tag."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , key: str = ""
        , value: str = ""
        , create_time: datetime = None
        , update_time: datetime = None
    , **kwargs) -> Tag:
        self._attributes = dict()
        self.name = name
        self.key = key
        self.value = value
        self.create_time = create_time
        self.update_time = update_time

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Tag", "name", value, str, "")


    @property
    def key(self) -> str:
        """Key."""
        return self._attributes["key"]


    @key.setter
    def key(self, value: str) -> None:
        _set_attribute(self._attributes, "Tag", "key", value, str, "")


    @property
    def value(self) -> str:
        """Value."""
        return self._attributes["value"]


    @value.setter
    def value(self, value: str) -> None:
        _set_attribute(self._attributes, "Tag", "value", value, str, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Tag", "create_time", value, datetime, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Tag", "update_time", value, datetime, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Tag, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Tag:
        """Convert object to proto representation."""
        return management_types_pb2.Tag(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Tag object " + repr(self.to_dict()) + ">"


class NotificationPolicyConfig:
    """Notification policy config."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , email: NotificationPolicyConfigEmail = None
        , slack: NotificationPolicyConfigSlack = None
    , **kwargs) -> NotificationPolicyConfig:
        self._attributes = dict()
        self.email = email
        self.slack = slack

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def email(self) -> NotificationPolicyConfigEmail:
        """Email."""
        return self._attributes["email"]


    @email.setter
    def email(self, value: NotificationPolicyConfigEmail) -> None:
        _set_attribute(self._attributes, "NotificationPolicyConfig", "email", value, NotificationPolicyConfigEmail, "")


    @property
    def slack(self) -> NotificationPolicyConfigSlack:
        """Slack."""
        return self._attributes["slack"]


    @slack.setter
    def slack(self, value: NotificationPolicyConfigSlack) -> None:
        _set_attribute(self._attributes, "NotificationPolicyConfig", "slack", value, NotificationPolicyConfigSlack, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.NotificationPolicyConfig, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.NotificationPolicyConfig:
        """Convert object to proto representation."""
        return management_types_pb2.NotificationPolicyConfig(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<NotificationPolicyConfig object " + repr(self.to_dict()) + ">"


class NotificationPolicyConfigEmail:
    """Notification policy config email."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , email_address: str = ""
    , **kwargs) -> NotificationPolicyConfigEmail:
        self._attributes = dict()
        self.email_address = email_address

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def email_address(self) -> str:
        """Email address."""
        return self._attributes["email_address"]


    @email_address.setter
    def email_address(self, value: str) -> None:
        _set_attribute(self._attributes, "NotificationPolicyConfigEmail", "email_address", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.NotificationPolicyConfig.Email, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.NotificationPolicyConfig.Email:
        """Convert object to proto representation."""
        return management_types_pb2.NotificationPolicyConfig.Email(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<NotificationPolicyConfigEmail object " + repr(self.to_dict()) + ">"


class NotificationPolicyConfigSlack:
    """Notification policy config slack."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , channel: str = ""
    , **kwargs) -> NotificationPolicyConfigSlack:
        self._attributes = dict()
        self.channel = channel

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def channel(self) -> str:
        """Channel."""
        return self._attributes["channel"]


    @channel.setter
    def channel(self, value: str) -> None:
        _set_attribute(self._attributes, "NotificationPolicyConfigSlack", "channel", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.NotificationPolicyConfig.Slack, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.NotificationPolicyConfig.Slack:
        """Convert object to proto representation."""
        return management_types_pb2.NotificationPolicyConfig.Slack(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<NotificationPolicyConfigSlack object " + repr(self.to_dict()) + ">"


class NotificationPolicy:
    """Notification policy."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , description: str = ""
        , config: NotificationPolicyConfig = None
        , type: NotificationPolicyType = 0
        , severity: str = ""
        , resource: str = ""
        , resource_type: str = ""
        , event_type: str = ""
        , require_notify: bool = False
        , create_time: datetime = None
        , update_time: datetime = None
    , **kwargs) -> NotificationPolicy:
        self._attributes = dict()
        self.name = name
        self.description = description
        self.config = config
        self.type = type
        self.severity = severity
        self.resource = resource
        self.resource_type = resource_type
        self.event_type = event_type
        self.require_notify = require_notify
        self.create_time = create_time
        self.update_time = update_time

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "NotificationPolicy", "name", value, str, "")


    @property
    def description(self) -> str:
        """Description."""
        return self._attributes["description"]


    @description.setter
    def description(self, value: str) -> None:
        _set_attribute(self._attributes, "NotificationPolicy", "description", value, str, "")


    @property
    def config(self) -> NotificationPolicyConfig:
        """Config."""
        return self._attributes["config"]


    @config.setter
    def config(self, value: NotificationPolicyConfig) -> None:
        _set_attribute(self._attributes, "NotificationPolicy", "config", value, NotificationPolicyConfig, "")


    @property
    def type(self) -> NotificationPolicyType:
        """Type."""
        return self._attributes["type"]


    @type.setter
    def type(self, value: NotificationPolicyType) -> None:
        _set_attribute(self._attributes, "NotificationPolicy", "type", value, NotificationPolicyType, "")


    @property
    def severity(self) -> str:
        """Severity."""
        return self._attributes["severity"]


    @severity.setter
    def severity(self, value: str) -> None:
        _set_attribute(self._attributes, "NotificationPolicy", "severity", value, str, "")


    @property
    def resource(self) -> str:
        """Resource."""
        return self._attributes["resource"]


    @resource.setter
    def resource(self, value: str) -> None:
        _set_attribute(self._attributes, "NotificationPolicy", "resource", value, str, "")


    @property
    def resource_type(self) -> str:
        """Resource type."""
        return self._attributes["resource_type"]


    @resource_type.setter
    def resource_type(self, value: str) -> None:
        _set_attribute(self._attributes, "NotificationPolicy", "resource_type", value, str, "")


    @property
    def event_type(self) -> str:
        """Event type."""
        return self._attributes["event_type"]


    @event_type.setter
    def event_type(self, value: str) -> None:
        _set_attribute(self._attributes, "NotificationPolicy", "event_type", value, str, "")


    @property
    def require_notify(self) -> bool:
        """Require notify."""
        return self._attributes["require_notify"]


    @require_notify.setter
    def require_notify(self, value: bool) -> None:
        _set_attribute(self._attributes, "NotificationPolicy", "require_notify", value, bool, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "NotificationPolicy", "create_time", value, datetime, "")


    @property
    def update_time(self) -> datetime:
        """Update time."""
        return self._attributes["update_time"]


    @update_time.setter
    def update_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "NotificationPolicy", "update_time", value, datetime, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.NotificationPolicy, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.NotificationPolicy:
        """Convert object to proto representation."""
        return management_types_pb2.NotificationPolicy(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<NotificationPolicy object " + repr(self.to_dict()) + ">"


class Notification:
    """Notification."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , type: NotificationPolicyType = 0
        , event: str = ""
        , target: str = ""
        , result: str = ""
        , create_time: datetime = None
    , **kwargs) -> Notification:
        self._attributes = dict()
        self.name = name
        self.type = type
        self.event = event
        self.target = target
        self.result = result
        self.create_time = create_time

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "Notification", "name", value, str, "")


    @property
    def type(self) -> NotificationPolicyType:
        """Type."""
        return self._attributes["type"]


    @type.setter
    def type(self, value: NotificationPolicyType) -> None:
        _set_attribute(self._attributes, "Notification", "type", value, NotificationPolicyType, "")


    @property
    def event(self) -> str:
        """Event."""
        return self._attributes["event"]


    @event.setter
    def event(self, value: str) -> None:
        _set_attribute(self._attributes, "Notification", "event", value, str, "")


    @property
    def target(self) -> str:
        """Target."""
        return self._attributes["target"]


    @target.setter
    def target(self, value: str) -> None:
        _set_attribute(self._attributes, "Notification", "target", value, str, "")


    @property
    def result(self) -> str:
        """Result."""
        return self._attributes["result"]


    @result.setter
    def result(self, value: str) -> None:
        _set_attribute(self._attributes, "Notification", "result", value, str, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "Notification", "create_time", value, datetime, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.Notification, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.Notification:
        """Convert object to proto representation."""
        return management_types_pb2.Notification(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<Notification object " + repr(self.to_dict()) + ">"


class RunCheckSummary:
    """Run check summary."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , run_name: str = ""
        , outcome: CheckOutcome = 0
        , resource_checks: List[ResourceCheck] = []
    , **kwargs) -> RunCheckSummary:
        self._attributes = dict()
        self.run_name = run_name
        self.outcome = outcome
        self.resource_checks = resource_checks

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def run_name(self) -> str:
        """Run name."""
        return self._attributes["run_name"]


    @run_name.setter
    def run_name(self, value: str) -> None:
        _set_attribute(self._attributes, "RunCheckSummary", "run_name", value, str, "")


    @property
    def outcome(self) -> CheckOutcome:
        """Outcome."""
        return self._attributes["outcome"]


    @outcome.setter
    def outcome(self, value: CheckOutcome) -> None:
        _set_attribute(self._attributes, "RunCheckSummary", "outcome", value, CheckOutcome, "")


    @property
    def resource_checks(self) -> List[ResourceCheck]:
        """Resource checks."""
        return self._attributes["resource_checks"]


    @resource_checks.setter
    def resource_checks(self, value: List[ResourceCheck]) -> None:
        _set_attribute(self._attributes, "RunCheckSummary", "resource_checks", value, List[ResourceCheck], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.RunCheckSummary, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.RunCheckSummary:
        """Convert object to proto representation."""
        return management_types_pb2.RunCheckSummary(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<RunCheckSummary object " + repr(self.to_dict()) + ">"


class ResourceCheck:
    """Resource check."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , run_name: str = ""
        , group_name: str = ""
        , outcome: CheckOutcome = 0
        , duration: float = 0.0
        , data: str = ""
        , errors: List[str] = []
        , warnings: List[str] = []
        , infos: List[str] = []
        , summary: str = ""
        , artifact_name: str = ""
        , create_time: datetime = None
        , display_name: str = ""
    , **kwargs) -> ResourceCheck:
        self._attributes = dict()
        self.name = name
        self.run_name = run_name
        self.group_name = group_name
        self.outcome = outcome
        self.duration = duration
        self.data = data
        self.errors = errors
        self.warnings = warnings
        self.infos = infos
        self.summary = summary
        self.artifact_name = artifact_name
        self.create_time = create_time
        self.display_name = display_name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """check name"""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "ResourceCheck", "name", value, str, "")


    @property
    def run_name(self) -> str:
        """Name of run that check was performed in"""
        return self._attributes["run_name"]


    @run_name.setter
    def run_name(self, value: str) -> None:
        _set_attribute(self._attributes, "ResourceCheck", "run_name", value, str, "")


    @property
    def group_name(self) -> str:
        """Data group or tag under which check was performed e.g. train"""
        return self._attributes["group_name"]


    @group_name.setter
    def group_name(self, value: str) -> None:
        _set_attribute(self._attributes, "ResourceCheck", "group_name", value, str, "")


    @property
    def outcome(self) -> CheckOutcome:
        """state of check PASS/FAIL"""
        return self._attributes["outcome"]


    @outcome.setter
    def outcome(self, value: CheckOutcome) -> None:
        _set_attribute(self._attributes, "ResourceCheck", "outcome", value, CheckOutcome, "")


    @property
    def duration(self) -> float:
        """Time taken to complete check in seconds"""
        return self._attributes["duration"]


    @duration.setter
    def duration(self, value: float) -> None:
        _set_attribute(self._attributes, "ResourceCheck", "duration", value, float, "")


    @property
    def data(self) -> str:
        """a json object for a dict"""
        return self._attributes["data"]


    @data.setter
    def data(self, value: str) -> None:
        _set_attribute(self._attributes, "ResourceCheck", "data", value, str, "")


    @property
    def errors(self) -> List[str]:
        """list of strings containing error 
 messages or warnings if any"""
        return self._attributes["errors"]


    @errors.setter
    def errors(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ResourceCheck", "errors", value, List[str], "")


    @property
    def warnings(self) -> List[str]:
        """Warnings."""
        return self._attributes["warnings"]


    @warnings.setter
    def warnings(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ResourceCheck", "warnings", value, List[str], "")


    @property
    def infos(self) -> List[str]:
        """Infos."""
        return self._attributes["infos"]


    @infos.setter
    def infos(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ResourceCheck", "infos", value, List[str], "")


    @property
    def summary(self) -> str:
        """Summary."""
        return self._attributes["summary"]


    @summary.setter
    def summary(self, value: str) -> None:
        _set_attribute(self._attributes, "ResourceCheck", "summary", value, str, "")


    @property
    def artifact_name(self) -> str:
        """Artifact name."""
        return self._attributes["artifact_name"]


    @artifact_name.setter
    def artifact_name(self, value: str) -> None:
        _set_attribute(self._attributes, "ResourceCheck", "artifact_name", value, str, "")


    @property
    def create_time(self) -> datetime:
        """Create time."""
        return self._attributes["create_time"]


    @create_time.setter
    def create_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ResourceCheck", "create_time", value, datetime, "")


    @property
    def display_name(self) -> str:
        """Display name."""
        return self._attributes["display_name"]


    @display_name.setter
    def display_name(self, value: str) -> None:
        _set_attribute(self._attributes, "ResourceCheck", "display_name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_types_pb2.ResourceCheck, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_types_pb2.ResourceCheck:
        """Convert object to proto representation."""
        return management_types_pb2.ResourceCheck(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ResourceCheck object " + repr(self.to_dict()) + ">"


class UpdateUserRequest:
    """Update user request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , user: User = None
        , update_mask: protobuf.FieldMask = None
    , **kwargs) -> UpdateUserRequest:
        self._attributes = dict()
        self.user = user
        self.update_mask = update_mask

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def user(self) -> User:
        """User."""
        return self._attributes["user"]


    @user.setter
    def user(self, value: User) -> None:
        _set_attribute(self._attributes, "UpdateUserRequest", "user", value, User, "")


    @property
    def update_mask(self) -> protobuf.FieldMask:
        """Update mask."""
        return self._attributes["update_mask"]


    @update_mask.setter
    def update_mask(self, value: protobuf.FieldMask) -> None:
        _set_attribute(self._attributes, "UpdateUserRequest", "update_mask", value, protobuf.FieldMask, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.UpdateUserRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.UpdateUserRequest:
        """Convert object to proto representation."""
        return management_pb2.UpdateUserRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<UpdateUserRequest object " + repr(self.to_dict()) + ">"


class GetUserRequest:
    """Get user request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetUserRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetUserRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetUserRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetUserRequest:
        """Convert object to proto representation."""
        return management_pb2.GetUserRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetUserRequest object " + repr(self.to_dict()) + ">"


class BatchGetUsersRequest:
    """Batch get users request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , names: List[str] = []
    , **kwargs) -> BatchGetUsersRequest:
        self._attributes = dict()
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BatchGetUsersRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetUsersRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetUsersRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchGetUsersRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetUsersRequest object " + repr(self.to_dict()) + ">"


class BatchGetUsersResponse:
    """Batch get users response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , users: List[User] = []
    , **kwargs) -> BatchGetUsersResponse:
        self._attributes = dict()
        self.users = users

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def users(self) -> List[User]:
        """Users."""
        return self._attributes["users"]


    @users.setter
    def users(self, value: List[User]) -> None:
        _set_attribute(self._attributes, "BatchGetUsersResponse", "users", value, List[User], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetUsersResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetUsersResponse:
        """Convert object to proto representation."""
        return management_pb2.BatchGetUsersResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetUsersResponse object " + repr(self.to_dict()) + ">"


class DeleteUserRequest:
    """Delete user request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> DeleteUserRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "DeleteUserRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.DeleteUserRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.DeleteUserRequest:
        """Convert object to proto representation."""
        return management_pb2.DeleteUserRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DeleteUserRequest object " + repr(self.to_dict()) + ">"


class ListUsersRequest:
    """List users request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , page_size: int = 0
        , page_token: str = ""
        , order_by: str = ""
        , search: str = ""
        , latest: bool = False
    , **kwargs) -> ListUsersRequest:
        self._attributes = dict()
        self.page_size = page_size
        self.page_token = page_token
        self.order_by = order_by
        self.search = search
        self.latest = latest

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListUsersRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListUsersRequest", "page_token", value, str, "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListUsersRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListUsersRequest", "search", value, str, "")


    @property
    def latest(self) -> bool:
        """Latest."""
        return self._attributes["latest"]


    @latest.setter
    def latest(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListUsersRequest", "latest", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListUsersRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListUsersRequest:
        """Convert object to proto representation."""
        return management_pb2.ListUsersRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListUsersRequest object " + repr(self.to_dict()) + ">"


class ListUsersResponse:
    """List users response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , users: List[User] = []
        , next_page_token: str = ""
    , **kwargs) -> ListUsersResponse:
        self._attributes = dict()
        self.users = users
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def users(self) -> List[User]:
        """Users."""
        return self._attributes["users"]


    @users.setter
    def users(self, value: List[User]) -> None:
        _set_attribute(self._attributes, "ListUsersResponse", "users", value, List[User], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListUsersResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListUsersResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListUsersResponse:
        """Convert object to proto representation."""
        return management_pb2.ListUsersResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListUsersResponse object " + repr(self.to_dict()) + ">"


class RegisterRequest:
    """Register request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , full_name: str = ""
        , email: str = ""
        , password: str = ""
        , first_name: str = ""
        , last_name: str = ""
    , **kwargs) -> RegisterRequest:
        self._attributes = dict()
        self.full_name = full_name
        self.email = email
        self.password = password
        self.first_name = first_name
        self.last_name = last_name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def full_name(self) -> str:
        """Full name."""
        return self._attributes["full_name"]


    @full_name.setter
    def full_name(self, value: str) -> None:
        _set_attribute(self._attributes, "RegisterRequest", "full_name", value, str, "")


    @property
    def email(self) -> str:
        """Email."""
        return self._attributes["email"]


    @email.setter
    def email(self, value: str) -> None:
        _set_attribute(self._attributes, "RegisterRequest", "email", value, str, "")


    @property
    def password(self) -> str:
        """Password."""
        return self._attributes["password"]


    @password.setter
    def password(self, value: str) -> None:
        _set_attribute(self._attributes, "RegisterRequest", "password", value, str, "")


    @property
    def first_name(self) -> str:
        """First name."""
        return self._attributes["first_name"]


    @first_name.setter
    def first_name(self, value: str) -> None:
        _set_attribute(self._attributes, "RegisterRequest", "first_name", value, str, "")


    @property
    def last_name(self) -> str:
        """Last name."""
        return self._attributes["last_name"]


    @last_name.setter
    def last_name(self, value: str) -> None:
        _set_attribute(self._attributes, "RegisterRequest", "last_name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.RegisterRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.RegisterRequest:
        """Convert object to proto representation."""
        return management_pb2.RegisterRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<RegisterRequest object " + repr(self.to_dict()) + ">"


class RegisterResponse:
    """Register response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , user: User = None
        , auth_token: str = ""
    , **kwargs) -> RegisterResponse:
        self._attributes = dict()
        self.user = user
        self.auth_token = auth_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def user(self) -> User:
        """User."""
        return self._attributes["user"]


    @user.setter
    def user(self, value: User) -> None:
        _set_attribute(self._attributes, "RegisterResponse", "user", value, User, "")


    @property
    def auth_token(self) -> str:
        """Auth token."""
        return self._attributes["auth_token"]


    @auth_token.setter
    def auth_token(self, value: str) -> None:
        _set_attribute(self._attributes, "RegisterResponse", "auth_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.RegisterResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.RegisterResponse:
        """Convert object to proto representation."""
        return management_pb2.RegisterResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<RegisterResponse object " + repr(self.to_dict()) + ">"


class LoginRequest:
    """Login request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , email: str = ""
        , password: str = ""
    , **kwargs) -> LoginRequest:
        self._attributes = dict()
        self.email = email
        self.password = password

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def email(self) -> str:
        """Email."""
        return self._attributes["email"]


    @email.setter
    def email(self, value: str) -> None:
        _set_attribute(self._attributes, "LoginRequest", "email", value, str, "")


    @property
    def password(self) -> str:
        """Password."""
        return self._attributes["password"]


    @password.setter
    def password(self, value: str) -> None:
        _set_attribute(self._attributes, "LoginRequest", "password", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.LoginRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.LoginRequest:
        """Convert object to proto representation."""
        return management_pb2.LoginRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<LoginRequest object " + repr(self.to_dict()) + ">"


class LoginResponse:
    """Login response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , user: User = None
        , auth_token: str = ""
    , **kwargs) -> LoginResponse:
        self._attributes = dict()
        self.user = user
        self.auth_token = auth_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def user(self) -> User:
        """User."""
        return self._attributes["user"]


    @user.setter
    def user(self, value: User) -> None:
        _set_attribute(self._attributes, "LoginResponse", "user", value, User, "")


    @property
    def auth_token(self) -> str:
        """Auth token."""
        return self._attributes["auth_token"]


    @auth_token.setter
    def auth_token(self, value: str) -> None:
        _set_attribute(self._attributes, "LoginResponse", "auth_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.LoginResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.LoginResponse:
        """Convert object to proto representation."""
        return management_pb2.LoginResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<LoginResponse object " + repr(self.to_dict()) + ">"


class CheckOrganizationAccessRequest:
    """Check organization access request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , organization: str = ""
    , **kwargs) -> CheckOrganizationAccessRequest:
        self._attributes = dict()
        self.organization = organization

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def organization(self) -> str:
        """Organization."""
        return self._attributes["organization"]


    @organization.setter
    def organization(self, value: str) -> None:
        _set_attribute(self._attributes, "CheckOrganizationAccessRequest", "organization", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CheckOrganizationAccessRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CheckOrganizationAccessRequest:
        """Convert object to proto representation."""
        return management_pb2.CheckOrganizationAccessRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CheckOrganizationAccessRequest object " + repr(self.to_dict()) + ">"


class CheckOrganizationAccessResponse:
    """Check organization access response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , requires_auth: bool = False
        , organization: str = ""
        , display_name: str = ""
    , **kwargs) -> CheckOrganizationAccessResponse:
        self._attributes = dict()
        self.requires_auth = requires_auth
        self.organization = organization
        self.display_name = display_name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def requires_auth(self) -> bool:
        """Requires auth."""
        return self._attributes["requires_auth"]


    @requires_auth.setter
    def requires_auth(self, value: bool) -> None:
        _set_attribute(self._attributes, "CheckOrganizationAccessResponse", "requires_auth", value, bool, "")


    @property
    def organization(self) -> str:
        """Organization."""
        return self._attributes["organization"]


    @organization.setter
    def organization(self, value: str) -> None:
        _set_attribute(self._attributes, "CheckOrganizationAccessResponse", "organization", value, str, "")


    @property
    def display_name(self) -> str:
        """Display name."""
        return self._attributes["display_name"]


    @display_name.setter
    def display_name(self, value: str) -> None:
        _set_attribute(self._attributes, "CheckOrganizationAccessResponse", "display_name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CheckOrganizationAccessResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CheckOrganizationAccessResponse:
        """Convert object to proto representation."""
        return management_pb2.CheckOrganizationAccessResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CheckOrganizationAccessResponse object " + repr(self.to_dict()) + ">"


class SendEmailVerificationRequest:
    """Send email verification request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , user: str = ""
    , **kwargs) -> SendEmailVerificationRequest:
        self._attributes = dict()
        self.user = user

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def user(self) -> str:
        """User."""
        return self._attributes["user"]


    @user.setter
    def user(self, value: str) -> None:
        _set_attribute(self._attributes, "SendEmailVerificationRequest", "user", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.SendEmailVerificationRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.SendEmailVerificationRequest:
        """Convert object to proto representation."""
        return management_pb2.SendEmailVerificationRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<SendEmailVerificationRequest object " + repr(self.to_dict()) + ">"


class VerifyEmailRequest:
    """Verify email request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , user: str = ""
        , code: str = ""
    , **kwargs) -> VerifyEmailRequest:
        self._attributes = dict()
        self.user = user
        self.code = code

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def user(self) -> str:
        """User."""
        return self._attributes["user"]


    @user.setter
    def user(self, value: str) -> None:
        _set_attribute(self._attributes, "VerifyEmailRequest", "user", value, str, "")


    @property
    def code(self) -> str:
        """Code."""
        return self._attributes["code"]


    @code.setter
    def code(self, value: str) -> None:
        _set_attribute(self._attributes, "VerifyEmailRequest", "code", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.VerifyEmailRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.VerifyEmailRequest:
        """Convert object to proto representation."""
        return management_pb2.VerifyEmailRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<VerifyEmailRequest object " + repr(self.to_dict()) + ">"


class VerifyEmailResponse:
    """Verify email response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , success: bool = False
    , **kwargs) -> VerifyEmailResponse:
        self._attributes = dict()
        self.success = success

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def success(self) -> bool:
        """Success."""
        return self._attributes["success"]


    @success.setter
    def success(self, value: bool) -> None:
        _set_attribute(self._attributes, "VerifyEmailResponse", "success", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.VerifyEmailResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.VerifyEmailResponse:
        """Convert object to proto representation."""
        return management_pb2.VerifyEmailResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<VerifyEmailResponse object " + repr(self.to_dict()) + ">"


class SendPasswordResetRequest:
    """Send password reset request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , email: str = ""
    , **kwargs) -> SendPasswordResetRequest:
        self._attributes = dict()
        self.email = email

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def email(self) -> str:
        """Email."""
        return self._attributes["email"]


    @email.setter
    def email(self, value: str) -> None:
        _set_attribute(self._attributes, "SendPasswordResetRequest", "email", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.SendPasswordResetRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.SendPasswordResetRequest:
        """Convert object to proto representation."""
        return management_pb2.SendPasswordResetRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<SendPasswordResetRequest object " + repr(self.to_dict()) + ">"


class GetPasswordResetRequest:
    """Get password reset request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , code: str = ""
    , **kwargs) -> GetPasswordResetRequest:
        self._attributes = dict()
        self.code = code

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def code(self) -> str:
        """Code."""
        return self._attributes["code"]


    @code.setter
    def code(self, value: str) -> None:
        _set_attribute(self._attributes, "GetPasswordResetRequest", "code", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetPasswordResetRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetPasswordResetRequest:
        """Convert object to proto representation."""
        return management_pb2.GetPasswordResetRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetPasswordResetRequest object " + repr(self.to_dict()) + ">"


class ResetPasswordRequest:
    """Reset password request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , password: str = ""
        , code: str = ""
        , old_password: str = ""
    , **kwargs) -> ResetPasswordRequest:
        self._attributes = dict()
        self.password = password
        self.code = code
        self.old_password = old_password

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def password(self) -> str:
        """Password."""
        return self._attributes["password"]


    @password.setter
    def password(self, value: str) -> None:
        _set_attribute(self._attributes, "ResetPasswordRequest", "password", value, str, "")


    @property
    def code(self) -> str:
        """Code."""
        return self._attributes["code"]


    @code.setter
    def code(self, value: str) -> None:
        _set_attribute(self._attributes, "ResetPasswordRequest", "code", value, str, "")


    @property
    def old_password(self) -> str:
        """Old password."""
        return self._attributes["old_password"]


    @old_password.setter
    def old_password(self, value: str) -> None:
        _set_attribute(self._attributes, "ResetPasswordRequest", "old_password", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ResetPasswordRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ResetPasswordRequest:
        """Convert object to proto representation."""
        return management_pb2.ResetPasswordRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ResetPasswordRequest object " + repr(self.to_dict()) + ">"


class ResetPasswordResponse:
    """Reset password response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , success: bool = False
    , **kwargs) -> ResetPasswordResponse:
        self._attributes = dict()
        self.success = success

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def success(self) -> bool:
        """Success."""
        return self._attributes["success"]


    @success.setter
    def success(self, value: bool) -> None:
        _set_attribute(self._attributes, "ResetPasswordResponse", "success", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ResetPasswordResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ResetPasswordResponse:
        """Convert object to proto representation."""
        return management_pb2.ResetPasswordResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ResetPasswordResponse object " + repr(self.to_dict()) + ">"


class ChangePasswordRequest:
    """Change password request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , password: str = ""
        , old_password: str = ""
    , **kwargs) -> ChangePasswordRequest:
        self._attributes = dict()
        self.password = password
        self.old_password = old_password

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def password(self) -> str:
        """Password."""
        return self._attributes["password"]


    @password.setter
    def password(self, value: str) -> None:
        _set_attribute(self._attributes, "ChangePasswordRequest", "password", value, str, "")


    @property
    def old_password(self) -> str:
        """Old password."""
        return self._attributes["old_password"]


    @old_password.setter
    def old_password(self, value: str) -> None:
        _set_attribute(self._attributes, "ChangePasswordRequest", "old_password", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ChangePasswordRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ChangePasswordRequest:
        """Convert object to proto representation."""
        return management_pb2.ChangePasswordRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ChangePasswordRequest object " + repr(self.to_dict()) + ">"


class ChangePasswordResponse:
    """Change password response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , success: bool = False
        , auth_token: str = ""
    , **kwargs) -> ChangePasswordResponse:
        self._attributes = dict()
        self.success = success
        self.auth_token = auth_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def success(self) -> bool:
        """Success."""
        return self._attributes["success"]


    @success.setter
    def success(self, value: bool) -> None:
        _set_attribute(self._attributes, "ChangePasswordResponse", "success", value, bool, "")


    @property
    def auth_token(self) -> str:
        """Auth token."""
        return self._attributes["auth_token"]


    @auth_token.setter
    def auth_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ChangePasswordResponse", "auth_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ChangePasswordResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ChangePasswordResponse:
        """Convert object to proto representation."""
        return management_pb2.ChangePasswordResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ChangePasswordResponse object " + repr(self.to_dict()) + ">"


class GetSessionRequest:
    """Get session request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetSessionRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetSessionRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetSessionRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetSessionRequest:
        """Convert object to proto representation."""
        return management_pb2.GetSessionRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetSessionRequest object " + repr(self.to_dict()) + ">"


class ListSessionsRequest:
    """List sessions request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
    , **kwargs) -> ListSessionsRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListSessionsRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListSessionsRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListSessionsRequest", "page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListSessionsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListSessionsRequest:
        """Convert object to proto representation."""
        return management_pb2.ListSessionsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListSessionsRequest object " + repr(self.to_dict()) + ">"


class ListSessionsResponse:
    """List sessions response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , sessions: List[Session] = []
        , next_page_token: str = ""
    , **kwargs) -> ListSessionsResponse:
        self._attributes = dict()
        self.sessions = sessions
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def sessions(self) -> List[Session]:
        """Sessions."""
        return self._attributes["sessions"]


    @sessions.setter
    def sessions(self, value: List[Session]) -> None:
        _set_attribute(self._attributes, "ListSessionsResponse", "sessions", value, List[Session], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListSessionsResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListSessionsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListSessionsResponse:
        """Convert object to proto representation."""
        return management_pb2.ListSessionsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListSessionsResponse object " + repr(self.to_dict()) + ">"


class DeleteSessionRequest:
    """Delete session request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> DeleteSessionRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "DeleteSessionRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.DeleteSessionRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.DeleteSessionRequest:
        """Convert object to proto representation."""
        return management_pb2.DeleteSessionRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DeleteSessionRequest object " + repr(self.to_dict()) + ">"


class DeleteAllSessionsRequest:
    """Delete all sessions request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
    , **kwargs) -> DeleteAllSessionsRequest:
        self._attributes = dict()
        self.parent = parent

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "DeleteAllSessionsRequest", "parent", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.DeleteAllSessionsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.DeleteAllSessionsRequest:
        """Convert object to proto representation."""
        return management_pb2.DeleteAllSessionsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DeleteAllSessionsRequest object " + repr(self.to_dict()) + ">"


class ListRolesRequest:
    """The request to get all roles defined for a resource."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , page_size: int = 0
        , page_token: str = ""
    , **kwargs) -> ListRolesRequest:
        self._attributes = dict()
        self.page_size = page_size
        self.page_token = page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def page_size(self) -> int:
        """Optional limit on the number of roles to include in the response."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListRolesRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """Optional pagination token returned in an earlier ListRolesResponse."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListRolesRequest", "page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListRolesRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListRolesRequest:
        """Convert object to proto representation."""
        return management_pb2.ListRolesRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListRolesRequest object " + repr(self.to_dict()) + ">"


class ListRolesResponse:
    """The response containing the roles defined under a resource."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , roles: List[Role] = []
        , next_page_token: str = ""
    , **kwargs) -> ListRolesResponse:
        self._attributes = dict()
        self.roles = roles
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def roles(self) -> List[Role]:
        """The Roles defined on this resource."""
        return self._attributes["roles"]


    @roles.setter
    def roles(self, value: List[Role]) -> None:
        _set_attribute(self._attributes, "ListRolesResponse", "roles", value, List[Role], "")


    @property
    def next_page_token(self) -> str:
        """To retrieve the next page of results, set
 `ListRolesRequest.page_token` to this value."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListRolesResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListRolesResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListRolesResponse:
        """Convert object to proto representation."""
        return management_pb2.ListRolesResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListRolesResponse object " + repr(self.to_dict()) + ">"


class GetRoleRequest:
    """The request to get the definition of an existing role."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetRoleRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """The resource name of the role in one of the following formats:
 `roles/{ROLE_NAME}`"""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetRoleRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetRoleRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetRoleRequest:
        """Convert object to proto representation."""
        return management_pb2.GetRoleRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetRoleRequest object " + repr(self.to_dict()) + ">"


class BatchGetRolesRequest:
    """Batch get roles request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , names: List[str] = []
    , **kwargs) -> BatchGetRolesRequest:
        self._attributes = dict()
        self.parent = parent
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchGetRolesRequest", "parent", value, str, "")


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BatchGetRolesRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetRolesRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetRolesRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchGetRolesRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetRolesRequest object " + repr(self.to_dict()) + ">"


class BatchGetRolesResponse:
    """Batch get roles response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , roles: List[Role] = []
    , **kwargs) -> BatchGetRolesResponse:
        self._attributes = dict()
        self.roles = roles

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def roles(self) -> List[Role]:
        """Roles."""
        return self._attributes["roles"]


    @roles.setter
    def roles(self, value: List[Role]) -> None:
        _set_attribute(self._attributes, "BatchGetRolesResponse", "roles", value, List[Role], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetRolesResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetRolesResponse:
        """Convert object to proto representation."""
        return management_pb2.BatchGetRolesResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetRolesResponse object " + repr(self.to_dict()) + ">"


class ListAccessPoliciesRequest:
    """List access policies request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
        , include_api_keys: bool = False
    , **kwargs) -> ListAccessPoliciesRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token
        self.include_api_keys = include_api_keys

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent resource for access policies."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListAccessPoliciesRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """Optional limit on the number of items to include in the response."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListAccessPoliciesRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """Optional pagination token returned in an earlier ListAccessPolicies."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListAccessPoliciesRequest", "page_token", value, str, "")


    @property
    def include_api_keys(self) -> bool:
        """Optional flag to include api key access policies"""
        return self._attributes["include_api_keys"]


    @include_api_keys.setter
    def include_api_keys(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListAccessPoliciesRequest", "include_api_keys", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListAccessPoliciesRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListAccessPoliciesRequest:
        """Convert object to proto representation."""
        return management_pb2.ListAccessPoliciesRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListAccessPoliciesRequest object " + repr(self.to_dict()) + ">"


class ListAccessPoliciesResponse:
    """List access policies response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , access_policies: List[AccessPolicy] = []
        , next_page_token: str = ""
    , **kwargs) -> ListAccessPoliciesResponse:
        self._attributes = dict()
        self.access_policies = access_policies
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def access_policies(self) -> List[AccessPolicy]:
        """List of access policies attached to resource."""
        return self._attributes["access_policies"]


    @access_policies.setter
    def access_policies(self, value: List[AccessPolicy]) -> None:
        _set_attribute(self._attributes, "ListAccessPoliciesResponse", "access_policies", value, List[AccessPolicy], "")


    @property
    def next_page_token(self) -> str:
        """To retrieve the next page of results, set
 `ListAccessPoliciesRequest.page_token` to this value."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListAccessPoliciesResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListAccessPoliciesResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListAccessPoliciesResponse:
        """Convert object to proto representation."""
        return management_pb2.ListAccessPoliciesResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListAccessPoliciesResponse object " + repr(self.to_dict()) + ">"


class CreateAccessPolicyRequest:
    """Create access policy request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , access_policy: AccessPolicy = None
    , **kwargs) -> CreateAccessPolicyRequest:
        self._attributes = dict()
        self.parent = parent
        self.access_policy = access_policy

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent resource on which to create access policy."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateAccessPolicyRequest", "parent", value, str, "")


    @property
    def access_policy(self) -> AccessPolicy:
        """Access policy to create."""
        return self._attributes["access_policy"]


    @access_policy.setter
    def access_policy(self, value: AccessPolicy) -> None:
        _set_attribute(self._attributes, "CreateAccessPolicyRequest", "access_policy", value, AccessPolicy, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateAccessPolicyRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateAccessPolicyRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateAccessPolicyRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateAccessPolicyRequest object " + repr(self.to_dict()) + ">"


class GetAccessPolicyRequest:
    """Get access policy request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetAccessPolicyRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name of access policy."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetAccessPolicyRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetAccessPolicyRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetAccessPolicyRequest:
        """Convert object to proto representation."""
        return management_pb2.GetAccessPolicyRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetAccessPolicyRequest object " + repr(self.to_dict()) + ">"


class UpdateAccessPolicyRequest:
    """Update access policy request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , access_policy: AccessPolicy = None
        , update_mask: protobuf.FieldMask = None
    , **kwargs) -> UpdateAccessPolicyRequest:
        self._attributes = dict()
        self.access_policy = access_policy
        self.update_mask = update_mask

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def access_policy(self) -> AccessPolicy:
        """Access policy."""
        return self._attributes["access_policy"]


    @access_policy.setter
    def access_policy(self, value: AccessPolicy) -> None:
        _set_attribute(self._attributes, "UpdateAccessPolicyRequest", "access_policy", value, AccessPolicy, "")


    @property
    def update_mask(self) -> protobuf.FieldMask:
        """Update mask."""
        return self._attributes["update_mask"]


    @update_mask.setter
    def update_mask(self, value: protobuf.FieldMask) -> None:
        _set_attribute(self._attributes, "UpdateAccessPolicyRequest", "update_mask", value, protobuf.FieldMask, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.UpdateAccessPolicyRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.UpdateAccessPolicyRequest:
        """Convert object to proto representation."""
        return management_pb2.UpdateAccessPolicyRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<UpdateAccessPolicyRequest object " + repr(self.to_dict()) + ">"


class DeleteAccessPolicyRequest:
    """Delete access policy request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> DeleteAccessPolicyRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name of access policy."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "DeleteAccessPolicyRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.DeleteAccessPolicyRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.DeleteAccessPolicyRequest:
        """Convert object to proto representation."""
        return management_pb2.DeleteAccessPolicyRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DeleteAccessPolicyRequest object " + repr(self.to_dict()) + ">"


class BulkDeleteAccessPoliciesRequest:
    """Bulk delete access policies request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , names: List[str] = []
    , **kwargs) -> BulkDeleteAccessPoliciesRequest:
        self._attributes = dict()
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BulkDeleteAccessPoliciesRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BulkDeleteAccessPoliciesRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BulkDeleteAccessPoliciesRequest:
        """Convert object to proto representation."""
        return management_pb2.BulkDeleteAccessPoliciesRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BulkDeleteAccessPoliciesRequest object " + repr(self.to_dict()) + ">"


class CreateInviteRequest:
    """Create invite request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , invite: Invite = None
    , **kwargs) -> CreateInviteRequest:
        self._attributes = dict()
        self.parent = parent
        self.invite = invite

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateInviteRequest", "parent", value, str, "")


    @property
    def invite(self) -> Invite:
        """Invite."""
        return self._attributes["invite"]


    @invite.setter
    def invite(self, value: Invite) -> None:
        _set_attribute(self._attributes, "CreateInviteRequest", "invite", value, Invite, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateInviteRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateInviteRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateInviteRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateInviteRequest object " + repr(self.to_dict()) + ">"


class GetInviteRequest:
    """Get invite request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetInviteRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetInviteRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetInviteRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetInviteRequest:
        """Convert object to proto representation."""
        return management_pb2.GetInviteRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetInviteRequest object " + repr(self.to_dict()) + ">"


class ListInvitesRequest:
    """List invites request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_token: str = ""
        , page_size: int = 0
    , **kwargs) -> ListInvitesRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_token = page_token
        self.page_size = page_size

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListInvitesRequest", "parent", value, str, "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListInvitesRequest", "page_token", value, str, "")


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListInvitesRequest", "page_size", value, int, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListInvitesRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListInvitesRequest:
        """Convert object to proto representation."""
        return management_pb2.ListInvitesRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListInvitesRequest object " + repr(self.to_dict()) + ">"


class ListInvitesResponse:
    """List invites response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , invites: List[Invite] = []
        , next_page_token: str = ""
    , **kwargs) -> ListInvitesResponse:
        self._attributes = dict()
        self.invites = invites
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def invites(self) -> List[Invite]:
        """Invites."""
        return self._attributes["invites"]


    @invites.setter
    def invites(self, value: List[Invite]) -> None:
        _set_attribute(self._attributes, "ListInvitesResponse", "invites", value, List[Invite], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListInvitesResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListInvitesResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListInvitesResponse:
        """Convert object to proto representation."""
        return management_pb2.ListInvitesResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListInvitesResponse object " + repr(self.to_dict()) + ">"


class UpdateInviteRequest:
    """Update invite request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , invite: Invite = None
        , update_mask: protobuf.FieldMask = None
    , **kwargs) -> UpdateInviteRequest:
        self._attributes = dict()
        self.invite = invite
        self.update_mask = update_mask

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def invite(self) -> Invite:
        """Invite."""
        return self._attributes["invite"]


    @invite.setter
    def invite(self, value: Invite) -> None:
        _set_attribute(self._attributes, "UpdateInviteRequest", "invite", value, Invite, "")


    @property
    def update_mask(self) -> protobuf.FieldMask:
        """Update mask."""
        return self._attributes["update_mask"]


    @update_mask.setter
    def update_mask(self, value: protobuf.FieldMask) -> None:
        _set_attribute(self._attributes, "UpdateInviteRequest", "update_mask", value, protobuf.FieldMask, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.UpdateInviteRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.UpdateInviteRequest:
        """Convert object to proto representation."""
        return management_pb2.UpdateInviteRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<UpdateInviteRequest object " + repr(self.to_dict()) + ">"


class DeleteInviteRequest:
    """Delete invite request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> DeleteInviteRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "DeleteInviteRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.DeleteInviteRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.DeleteInviteRequest:
        """Convert object to proto representation."""
        return management_pb2.DeleteInviteRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DeleteInviteRequest object " + repr(self.to_dict()) + ">"


class AcceptInviteRequest:
    """Accept invite request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , code: str = ""
    , **kwargs) -> AcceptInviteRequest:
        self._attributes = dict()
        self.code = code

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def code(self) -> str:
        """Code."""
        return self._attributes["code"]


    @code.setter
    def code(self, value: str) -> None:
        _set_attribute(self._attributes, "AcceptInviteRequest", "code", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.AcceptInviteRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.AcceptInviteRequest:
        """Convert object to proto representation."""
        return management_pb2.AcceptInviteRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<AcceptInviteRequest object " + repr(self.to_dict()) + ">"


class ResendInviteRequest:
    """Resend invite request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> ResendInviteRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "ResendInviteRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ResendInviteRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ResendInviteRequest:
        """Convert object to proto representation."""
        return management_pb2.ResendInviteRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ResendInviteRequest object " + repr(self.to_dict()) + ">"


class TestPermissionsRequest:
    """Test permissions request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , resource: str = ""
        , permissions: List[str] = []
    , **kwargs) -> TestPermissionsRequest:
        self._attributes = dict()
        self.resource = resource
        self.permissions = permissions

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def resource(self) -> str:
        """Resource on which to test permissions."""
        return self._attributes["resource"]


    @resource.setter
    def resource(self, value: str) -> None:
        _set_attribute(self._attributes, "TestPermissionsRequest", "resource", value, str, "")


    @property
    def permissions(self) -> List[str]:
        """Set of permissions to check for `resource`."""
        return self._attributes["permissions"]


    @permissions.setter
    def permissions(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "TestPermissionsRequest", "permissions", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.TestPermissionsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.TestPermissionsRequest:
        """Convert object to proto representation."""
        return management_pb2.TestPermissionsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<TestPermissionsRequest object " + repr(self.to_dict()) + ">"


class TestPermissionsResponse:
    """Test permissions response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , permissions: List[str] = []
    , **kwargs) -> TestPermissionsResponse:
        self._attributes = dict()
        self.permissions = permissions

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def permissions(self) -> List[str]:
        """A subset of `TestPermissionsRequest.permissions` that the caller is
 allowed."""
        return self._attributes["permissions"]


    @permissions.setter
    def permissions(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "TestPermissionsResponse", "permissions", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.TestPermissionsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.TestPermissionsResponse:
        """Convert object to proto representation."""
        return management_pb2.TestPermissionsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<TestPermissionsResponse object " + repr(self.to_dict()) + ">"


class CreateOrganizationRequest:
    """Create organization request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , organization: Organization = None
    , **kwargs) -> CreateOrganizationRequest:
        self._attributes = dict()
        self.organization = organization

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def organization(self) -> Organization:
        """Organization."""
        return self._attributes["organization"]


    @organization.setter
    def organization(self, value: Organization) -> None:
        _set_attribute(self._attributes, "CreateOrganizationRequest", "organization", value, Organization, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateOrganizationRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateOrganizationRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateOrganizationRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateOrganizationRequest object " + repr(self.to_dict()) + ">"


class UpdateOrganizationRequest:
    """Update organization request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , organization: Organization = None
        , update_mask: protobuf.FieldMask = None
    , **kwargs) -> UpdateOrganizationRequest:
        self._attributes = dict()
        self.organization = organization
        self.update_mask = update_mask

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def organization(self) -> Organization:
        """Organization."""
        return self._attributes["organization"]


    @organization.setter
    def organization(self, value: Organization) -> None:
        _set_attribute(self._attributes, "UpdateOrganizationRequest", "organization", value, Organization, "")


    @property
    def update_mask(self) -> protobuf.FieldMask:
        """Update mask."""
        return self._attributes["update_mask"]


    @update_mask.setter
    def update_mask(self, value: protobuf.FieldMask) -> None:
        _set_attribute(self._attributes, "UpdateOrganizationRequest", "update_mask", value, protobuf.FieldMask, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.UpdateOrganizationRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.UpdateOrganizationRequest:
        """Convert object to proto representation."""
        return management_pb2.UpdateOrganizationRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<UpdateOrganizationRequest object " + repr(self.to_dict()) + ">"


class GetOrganizationRequest:
    """Get organization request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetOrganizationRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetOrganizationRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetOrganizationRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetOrganizationRequest:
        """Convert object to proto representation."""
        return management_pb2.GetOrganizationRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetOrganizationRequest object " + repr(self.to_dict()) + ">"


class BatchGetOrganizationsRequest:
    """Batch get organizations request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , names: List[str] = []
    , **kwargs) -> BatchGetOrganizationsRequest:
        self._attributes = dict()
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BatchGetOrganizationsRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetOrganizationsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetOrganizationsRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchGetOrganizationsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetOrganizationsRequest object " + repr(self.to_dict()) + ">"


class BatchGetOrganizationsResponse:
    """Batch get organizations response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , organizations: List[Organization] = []
    , **kwargs) -> BatchGetOrganizationsResponse:
        self._attributes = dict()
        self.organizations = organizations

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def organizations(self) -> List[Organization]:
        """Organizations."""
        return self._attributes["organizations"]


    @organizations.setter
    def organizations(self, value: List[Organization]) -> None:
        _set_attribute(self._attributes, "BatchGetOrganizationsResponse", "organizations", value, List[Organization], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetOrganizationsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetOrganizationsResponse:
        """Convert object to proto representation."""
        return management_pb2.BatchGetOrganizationsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetOrganizationsResponse object " + repr(self.to_dict()) + ">"


class DeleteOrganizationRequest:
    """Delete organization request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> DeleteOrganizationRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "DeleteOrganizationRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.DeleteOrganizationRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.DeleteOrganizationRequest:
        """Convert object to proto representation."""
        return management_pb2.DeleteOrganizationRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DeleteOrganizationRequest object " + repr(self.to_dict()) + ">"


class ListOrganizationsRequest:
    """List organizations request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , page_size: int = 0
        , page_token: str = ""
        , order_by: str = ""
        , search: str = ""
        , latest: bool = False
        , include_sso: bool = False
    , **kwargs) -> ListOrganizationsRequest:
        self._attributes = dict()
        self.page_size = page_size
        self.page_token = page_token
        self.order_by = order_by
        self.search = search
        self.latest = latest
        self.include_sso = include_sso

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListOrganizationsRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListOrganizationsRequest", "page_token", value, str, "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListOrganizationsRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListOrganizationsRequest", "search", value, str, "")


    @property
    def latest(self) -> bool:
        """Latest."""
        return self._attributes["latest"]


    @latest.setter
    def latest(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListOrganizationsRequest", "latest", value, bool, "")


    @property
    def include_sso(self) -> bool:
        """Include sso."""
        return self._attributes["include_sso"]


    @include_sso.setter
    def include_sso(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListOrganizationsRequest", "include_sso", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListOrganizationsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListOrganizationsRequest:
        """Convert object to proto representation."""
        return management_pb2.ListOrganizationsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListOrganizationsRequest object " + repr(self.to_dict()) + ">"


class ListOrganizationsResponse:
    """List organizations response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , organizations: List[Organization] = []
        , next_page_token: str = ""
    , **kwargs) -> ListOrganizationsResponse:
        self._attributes = dict()
        self.organizations = organizations
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def organizations(self) -> List[Organization]:
        """Organizations."""
        return self._attributes["organizations"]


    @organizations.setter
    def organizations(self, value: List[Organization]) -> None:
        _set_attribute(self._attributes, "ListOrganizationsResponse", "organizations", value, List[Organization], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListOrganizationsResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListOrganizationsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListOrganizationsResponse:
        """Convert object to proto representation."""
        return management_pb2.ListOrganizationsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListOrganizationsResponse object " + repr(self.to_dict()) + ">"


class GetOnboardingRequest:
    """Get onboarding request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetOnboardingRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetOnboardingRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetOnboardingRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetOnboardingRequest:
        """Convert object to proto representation."""
        return management_pb2.GetOnboardingRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetOnboardingRequest object " + repr(self.to_dict()) + ">"


class UpdateOnboardingRequest:
    """Update onboarding request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , onboarding: Onboarding = None
        , update_mask: protobuf.FieldMask = None
    , **kwargs) -> UpdateOnboardingRequest:
        self._attributes = dict()
        self.onboarding = onboarding
        self.update_mask = update_mask

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def onboarding(self) -> Onboarding:
        """Onboarding."""
        return self._attributes["onboarding"]


    @onboarding.setter
    def onboarding(self, value: Onboarding) -> None:
        _set_attribute(self._attributes, "UpdateOnboardingRequest", "onboarding", value, Onboarding, "")


    @property
    def update_mask(self) -> protobuf.FieldMask:
        """Update mask."""
        return self._attributes["update_mask"]


    @update_mask.setter
    def update_mask(self, value: protobuf.FieldMask) -> None:
        _set_attribute(self._attributes, "UpdateOnboardingRequest", "update_mask", value, protobuf.FieldMask, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.UpdateOnboardingRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.UpdateOnboardingRequest:
        """Convert object to proto representation."""
        return management_pb2.UpdateOnboardingRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<UpdateOnboardingRequest object " + repr(self.to_dict()) + ">"


class CreateProjectRequest:
    """Create project request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , project: Project = None
        , project_id: str = ""
    , **kwargs) -> CreateProjectRequest:
        self._attributes = dict()
        self.project = project
        self.project_id = project_id

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def project(self) -> Project:
        """Project."""
        return self._attributes["project"]


    @project.setter
    def project(self, value: Project) -> None:
        _set_attribute(self._attributes, "CreateProjectRequest", "project", value, Project, "")


    @property
    def project_id(self) -> str:
        """Optional user-readable ID to project, which will
 become the last element of the resource name.
 https://aip.dev/133#user-specified-ids"""
        return self._attributes["project_id"]


    @project_id.setter
    def project_id(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateProjectRequest", "project_id", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateProjectRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateProjectRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateProjectRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateProjectRequest object " + repr(self.to_dict()) + ">"


class UpdateProjectRequest:
    """Update project request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , project: Project = None
        , update_mask: protobuf.FieldMask = None
    , **kwargs) -> UpdateProjectRequest:
        self._attributes = dict()
        self.project = project
        self.update_mask = update_mask

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def project(self) -> Project:
        """Project."""
        return self._attributes["project"]


    @project.setter
    def project(self, value: Project) -> None:
        _set_attribute(self._attributes, "UpdateProjectRequest", "project", value, Project, "")


    @property
    def update_mask(self) -> protobuf.FieldMask:
        """Update mask."""
        return self._attributes["update_mask"]


    @update_mask.setter
    def update_mask(self, value: protobuf.FieldMask) -> None:
        _set_attribute(self._attributes, "UpdateProjectRequest", "update_mask", value, protobuf.FieldMask, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.UpdateProjectRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.UpdateProjectRequest:
        """Convert object to proto representation."""
        return management_pb2.UpdateProjectRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<UpdateProjectRequest object " + repr(self.to_dict()) + ">"


class GetProjectRequest:
    """Get project request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetProjectRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetProjectRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetProjectRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetProjectRequest:
        """Convert object to proto representation."""
        return management_pb2.GetProjectRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetProjectRequest object " + repr(self.to_dict()) + ">"


class BatchGetProjectsRequest:
    """Batch get projects request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , names: List[str] = []
    , **kwargs) -> BatchGetProjectsRequest:
        self._attributes = dict()
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BatchGetProjectsRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetProjectsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetProjectsRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchGetProjectsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetProjectsRequest object " + repr(self.to_dict()) + ">"


class BatchGetProjectsResponse:
    """Batch get projects response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , projects: List[Project] = []
    , **kwargs) -> BatchGetProjectsResponse:
        self._attributes = dict()
        self.projects = projects

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def projects(self) -> List[Project]:
        """Projects."""
        return self._attributes["projects"]


    @projects.setter
    def projects(self, value: List[Project]) -> None:
        _set_attribute(self._attributes, "BatchGetProjectsResponse", "projects", value, List[Project], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetProjectsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetProjectsResponse:
        """Convert object to proto representation."""
        return management_pb2.BatchGetProjectsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetProjectsResponse object " + repr(self.to_dict()) + ">"


class DeleteProjectRequest:
    """Delete project request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> DeleteProjectRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "DeleteProjectRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.DeleteProjectRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.DeleteProjectRequest:
        """Convert object to proto representation."""
        return management_pb2.DeleteProjectRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DeleteProjectRequest object " + repr(self.to_dict()) + ">"


class ListProjectsRequest:
    """List projects request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , start_time: datetime = None
        , end_time: datetime = None
        , order_by: str = ""
        , search: str = ""
        , latest: bool = False
    , **kwargs) -> ListProjectsRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.start_time = start_time
        self.end_time = end_time
        self.order_by = order_by
        self.search = search
        self.latest = latest

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListProjectsRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListProjectsRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListProjectsRequest", "page_token", value, str, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListProjectsRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListProjectsRequest", "ignore_filters", value, List[str], "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListProjectsRequest", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListProjectsRequest", "end_time", value, datetime, "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListProjectsRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListProjectsRequest", "search", value, str, "")


    @property
    def latest(self) -> bool:
        """Latest."""
        return self._attributes["latest"]


    @latest.setter
    def latest(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListProjectsRequest", "latest", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListProjectsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListProjectsRequest:
        """Convert object to proto representation."""
        return management_pb2.ListProjectsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListProjectsRequest object " + repr(self.to_dict()) + ">"


class ListProjectsResponse:
    """List projects response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , projects: List[Project] = []
        , next_page_token: str = ""
    , **kwargs) -> ListProjectsResponse:
        self._attributes = dict()
        self.projects = projects
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def projects(self) -> List[Project]:
        """Projects."""
        return self._attributes["projects"]


    @projects.setter
    def projects(self, value: List[Project]) -> None:
        _set_attribute(self._attributes, "ListProjectsResponse", "projects", value, List[Project], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListProjectsResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListProjectsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListProjectsResponse:
        """Convert object to proto representation."""
        return management_pb2.ListProjectsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListProjectsResponse object " + repr(self.to_dict()) + ">"


class ReRunRequest:
    """Re run request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , message: str = ""
        , trigger: str = ""
    , **kwargs) -> ReRunRequest:
        self._attributes = dict()
        self.name = name
        self.message = message
        self.trigger = trigger

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "ReRunRequest", "name", value, str, "")


    @property
    def message(self) -> str:
        """Message."""
        return self._attributes["message"]


    @message.setter
    def message(self, value: str) -> None:
        _set_attribute(self._attributes, "ReRunRequest", "message", value, str, "")


    @property
    def trigger(self) -> str:
        """Trigger."""
        return self._attributes["trigger"]


    @trigger.setter
    def trigger(self, value: str) -> None:
        _set_attribute(self._attributes, "ReRunRequest", "trigger", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ReRunRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ReRunRequest:
        """Convert object to proto representation."""
        return management_pb2.ReRunRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ReRunRequest object " + repr(self.to_dict()) + ">"


class GetModelStatsRequest:
    """Get model stats request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetModelStatsRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetModelStatsRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetModelStatsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetModelStatsRequest:
        """Convert object to proto representation."""
        return management_pb2.GetModelStatsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetModelStatsRequest object " + repr(self.to_dict()) + ">"


class GetUsageRequest:
    """Get usage request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , start_time: datetime = None
        , end_time: datetime = None
    , **kwargs) -> GetUsageRequest:
        self._attributes = dict()
        self.parent = parent
        self.start_time = start_time
        self.end_time = end_time

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "GetUsageRequest", "parent", value, str, "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "GetUsageRequest", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "GetUsageRequest", "end_time", value, datetime, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetUsageRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetUsageRequest:
        """Convert object to proto representation."""
        return management_pb2.GetUsageRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetUsageRequest object " + repr(self.to_dict()) + ">"


class GetUsageResponse:
    """Get usage response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , credits_per_day: List[CreditUsageRecord] = []
    , **kwargs) -> GetUsageResponse:
        self._attributes = dict()
        self.credits_per_day = credits_per_day

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def credits_per_day(self) -> List[CreditUsageRecord]:
        """Credits per day."""
        return self._attributes["credits_per_day"]


    @credits_per_day.setter
    def credits_per_day(self, value: List[CreditUsageRecord]) -> None:
        _set_attribute(self._attributes, "GetUsageResponse", "credits_per_day", value, List[CreditUsageRecord], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetUsageResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetUsageResponse:
        """Convert object to proto representation."""
        return management_pb2.GetUsageResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetUsageResponse object " + repr(self.to_dict()) + ">"


class ListPricesRequest:
    """List prices request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
    , **kwargs) -> ListPricesRequest:
        self._attributes = dict()
        self.parent = parent

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListPricesRequest", "parent", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListPricesRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListPricesRequest:
        """Convert object to proto representation."""
        return management_pb2.ListPricesRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListPricesRequest object " + repr(self.to_dict()) + ">"


class ListPricesResponse:
    """List prices response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , prices: List[Price] = []
    , **kwargs) -> ListPricesResponse:
        self._attributes = dict()
        self.prices = prices

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def prices(self) -> List[Price]:
        """Prices."""
        return self._attributes["prices"]


    @prices.setter
    def prices(self, value: List[Price]) -> None:
        _set_attribute(self._attributes, "ListPricesResponse", "prices", value, List[Price], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListPricesResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListPricesResponse:
        """Convert object to proto representation."""
        return management_pb2.ListPricesResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListPricesResponse object " + repr(self.to_dict()) + ">"


class ListInvoicesRequest:
    """List invoices request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
    , **kwargs) -> ListInvoicesRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListInvoicesRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListInvoicesRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListInvoicesRequest", "page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListInvoicesRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListInvoicesRequest:
        """Convert object to proto representation."""
        return management_pb2.ListInvoicesRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListInvoicesRequest object " + repr(self.to_dict()) + ">"


class ListInvoicesResponse:
    """List invoices response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , invoices: List[Invoice] = []
        , next_page_token: str = ""
    , **kwargs) -> ListInvoicesResponse:
        self._attributes = dict()
        self.invoices = invoices
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def invoices(self) -> List[Invoice]:
        """Invoices."""
        return self._attributes["invoices"]


    @invoices.setter
    def invoices(self, value: List[Invoice]) -> None:
        _set_attribute(self._attributes, "ListInvoicesResponse", "invoices", value, List[Invoice], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListInvoicesResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListInvoicesResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListInvoicesResponse:
        """Convert object to proto representation."""
        return management_pb2.ListInvoicesResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListInvoicesResponse object " + repr(self.to_dict()) + ">"


class GetPriceRequest:
    """Get price request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetPriceRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetPriceRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetPriceRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetPriceRequest:
        """Convert object to proto representation."""
        return management_pb2.GetPriceRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetPriceRequest object " + repr(self.to_dict()) + ">"


class GetPaymentMethodRequest:
    """Get payment method request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetPaymentMethodRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetPaymentMethodRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetPaymentMethodRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetPaymentMethodRequest:
        """Convert object to proto representation."""
        return management_pb2.GetPaymentMethodRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetPaymentMethodRequest object " + repr(self.to_dict()) + ">"


class GetUpcomingInvoiceRequest:
    """Get upcoming invoice request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetUpcomingInvoiceRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetUpcomingInvoiceRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetUpcomingInvoiceRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetUpcomingInvoiceRequest:
        """Convert object to proto representation."""
        return management_pb2.GetUpcomingInvoiceRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetUpcomingInvoiceRequest object " + repr(self.to_dict()) + ">"


class GetSubscriptionRequest:
    """Get subscription request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetSubscriptionRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetSubscriptionRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetSubscriptionRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetSubscriptionRequest:
        """Convert object to proto representation."""
        return management_pb2.GetSubscriptionRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetSubscriptionRequest object " + repr(self.to_dict()) + ">"


class GetBillingAccountRequest:
    """Get billing account request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetBillingAccountRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetBillingAccountRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetBillingAccountRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetBillingAccountRequest:
        """Convert object to proto representation."""
        return management_pb2.GetBillingAccountRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetBillingAccountRequest object " + repr(self.to_dict()) + ">"


class UpdateBillingAccountRequest:
    """Update billing account request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , billing_account: BillingAccount = None
        , update_mask: protobuf.FieldMask = None
    , **kwargs) -> UpdateBillingAccountRequest:
        self._attributes = dict()
        self.billing_account = billing_account
        self.update_mask = update_mask

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def billing_account(self) -> BillingAccount:
        """Billing account."""
        return self._attributes["billing_account"]


    @billing_account.setter
    def billing_account(self, value: BillingAccount) -> None:
        _set_attribute(self._attributes, "UpdateBillingAccountRequest", "billing_account", value, BillingAccount, "")


    @property
    def update_mask(self) -> protobuf.FieldMask:
        """Update mask."""
        return self._attributes["update_mask"]


    @update_mask.setter
    def update_mask(self, value: protobuf.FieldMask) -> None:
        _set_attribute(self._attributes, "UpdateBillingAccountRequest", "update_mask", value, protobuf.FieldMask, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.UpdateBillingAccountRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.UpdateBillingAccountRequest:
        """Convert object to proto representation."""
        return management_pb2.UpdateBillingAccountRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<UpdateBillingAccountRequest object " + repr(self.to_dict()) + ">"


class UpdateSubscriptionRequest:
    """Update subscription request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , subscription: Subscription = None
        , update_mask: protobuf.FieldMask = None
    , **kwargs) -> UpdateSubscriptionRequest:
        self._attributes = dict()
        self.subscription = subscription
        self.update_mask = update_mask

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def subscription(self) -> Subscription:
        """Subscription."""
        return self._attributes["subscription"]


    @subscription.setter
    def subscription(self, value: Subscription) -> None:
        _set_attribute(self._attributes, "UpdateSubscriptionRequest", "subscription", value, Subscription, "")


    @property
    def update_mask(self) -> protobuf.FieldMask:
        """Update mask."""
        return self._attributes["update_mask"]


    @update_mask.setter
    def update_mask(self, value: protobuf.FieldMask) -> None:
        _set_attribute(self._attributes, "UpdateSubscriptionRequest", "update_mask", value, protobuf.FieldMask, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.UpdateSubscriptionRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.UpdateSubscriptionRequest:
        """Convert object to proto representation."""
        return management_pb2.UpdateSubscriptionRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<UpdateSubscriptionRequest object " + repr(self.to_dict()) + ">"


class CreatePromotionRequest:
    """Create promotion request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , model_version_name: str = ""
        , run_name: str = ""
        , reason: str = ""
    , **kwargs) -> CreatePromotionRequest:
        self._attributes = dict()
        self.model_version_name = model_version_name
        self.run_name = run_name
        self.reason = reason

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def model_version_name(self) -> str:
        """Model version name."""
        return self._attributes["model_version_name"]


    @model_version_name.setter
    def model_version_name(self, value: str) -> None:
        _set_attribute(self._attributes, "CreatePromotionRequest", "model_version_name", value, str, "")


    @property
    def run_name(self) -> str:
        """Run name."""
        return self._attributes["run_name"]


    @run_name.setter
    def run_name(self, value: str) -> None:
        _set_attribute(self._attributes, "CreatePromotionRequest", "run_name", value, str, "")


    @property
    def reason(self) -> str:
        """Reason."""
        return self._attributes["reason"]


    @reason.setter
    def reason(self, value: str) -> None:
        _set_attribute(self._attributes, "CreatePromotionRequest", "reason", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreatePromotionRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreatePromotionRequest:
        """Convert object to proto representation."""
        return management_pb2.CreatePromotionRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreatePromotionRequest object " + repr(self.to_dict()) + ">"


class ListPromotionsRequest:
    """List promotions request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_token: str = ""
        , page_size: int = 0
        , active: bool = False
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , start_time: datetime = None
        , end_time: datetime = None
        , all_projects: bool = False
        , order_by: str = ""
        , latest: bool = False
        , search: str = ""
    , **kwargs) -> ListPromotionsRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_token = page_token
        self.page_size = page_size
        self.active = active
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.start_time = start_time
        self.end_time = end_time
        self.all_projects = all_projects
        self.order_by = order_by
        self.latest = latest
        self.search = search

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListPromotionsRequest", "parent", value, str, "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListPromotionsRequest", "page_token", value, str, "")


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListPromotionsRequest", "page_size", value, int, "")


    @property
    def active(self) -> bool:
        """Active."""
        return self._attributes["active"]


    @active.setter
    def active(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListPromotionsRequest", "active", value, bool, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListPromotionsRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListPromotionsRequest", "ignore_filters", value, List[str], "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListPromotionsRequest", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListPromotionsRequest", "end_time", value, datetime, "")


    @property
    def all_projects(self) -> bool:
        """All projects."""
        return self._attributes["all_projects"]


    @all_projects.setter
    def all_projects(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListPromotionsRequest", "all_projects", value, bool, "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListPromotionsRequest", "order_by", value, str, "")


    @property
    def latest(self) -> bool:
        """Latest."""
        return self._attributes["latest"]


    @latest.setter
    def latest(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListPromotionsRequest", "latest", value, bool, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListPromotionsRequest", "search", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListPromotionsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListPromotionsRequest:
        """Convert object to proto representation."""
        return management_pb2.ListPromotionsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListPromotionsRequest object " + repr(self.to_dict()) + ">"


class ListPromotionsResponse:
    """List promotions response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , promotions: List[Promotion] = []
        , next_page_token: str = ""
    , **kwargs) -> ListPromotionsResponse:
        self._attributes = dict()
        self.promotions = promotions
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def promotions(self) -> List[Promotion]:
        """Promotions."""
        return self._attributes["promotions"]


    @promotions.setter
    def promotions(self, value: List[Promotion]) -> None:
        _set_attribute(self._attributes, "ListPromotionsResponse", "promotions", value, List[Promotion], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListPromotionsResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListPromotionsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListPromotionsResponse:
        """Convert object to proto representation."""
        return management_pb2.ListPromotionsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListPromotionsResponse object " + repr(self.to_dict()) + ">"


class GetPromotionRequest:
    """Get promotion request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetPromotionRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetPromotionRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetPromotionRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetPromotionRequest:
        """Convert object to proto representation."""
        return management_pb2.GetPromotionRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetPromotionRequest object " + repr(self.to_dict()) + ">"


class BatchGetPromotionsRequest:
    """Batch get promotions request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , names: List[str] = []
    , **kwargs) -> BatchGetPromotionsRequest:
        self._attributes = dict()
        self.parent = parent
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchGetPromotionsRequest", "parent", value, str, "")


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BatchGetPromotionsRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetPromotionsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetPromotionsRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchGetPromotionsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetPromotionsRequest object " + repr(self.to_dict()) + ">"


class BatchGetPromotionsResponse:
    """Batch get promotions response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , promotions: List[Promotion] = []
    , **kwargs) -> BatchGetPromotionsResponse:
        self._attributes = dict()
        self.promotions = promotions

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def promotions(self) -> List[Promotion]:
        """Promotions."""
        return self._attributes["promotions"]


    @promotions.setter
    def promotions(self, value: List[Promotion]) -> None:
        _set_attribute(self._attributes, "BatchGetPromotionsResponse", "promotions", value, List[Promotion], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetPromotionsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetPromotionsResponse:
        """Convert object to proto representation."""
        return management_pb2.BatchGetPromotionsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetPromotionsResponse object " + repr(self.to_dict()) + ">"


class CreateEventRequest:
    """Create event request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , event: Event = None
    , **kwargs) -> CreateEventRequest:
        self._attributes = dict()
        self.parent = parent
        self.event = event

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateEventRequest", "parent", value, str, "")


    @property
    def event(self) -> Event:
        """Event."""
        return self._attributes["event"]


    @event.setter
    def event(self, value: Event) -> None:
        _set_attribute(self._attributes, "CreateEventRequest", "event", value, Event, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateEventRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateEventRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateEventRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateEventRequest object " + repr(self.to_dict()) + ">"


class ListEventsRequest:
    """currently support filters are:
  - subject (e.g. subject:users/system)
  - event (e.g. featureSet:CREATED)
  - severity (e.g. severity:INFO, severity:CRITICAL)
 NOTE: google endpoints do not support maps, so using a list of string
 delimited with a colon"""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , start_time: datetime = None
        , end_time: datetime = None
        , page_token: str = ""
        , page_size: int = 0
        , all_projects: bool = False
    , **kwargs) -> ListEventsRequest:
        self._attributes = dict()
        self.parent = parent
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.start_time = start_time
        self.end_time = end_time
        self.page_token = page_token
        self.page_size = page_size
        self.all_projects = all_projects

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListEventsRequest", "parent", value, str, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListEventsRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListEventsRequest", "ignore_filters", value, List[str], "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListEventsRequest", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListEventsRequest", "end_time", value, datetime, "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListEventsRequest", "page_token", value, str, "")


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListEventsRequest", "page_size", value, int, "")


    @property
    def all_projects(self) -> bool:
        """All projects."""
        return self._attributes["all_projects"]


    @all_projects.setter
    def all_projects(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListEventsRequest", "all_projects", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListEventsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListEventsRequest:
        """Convert object to proto representation."""
        return management_pb2.ListEventsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListEventsRequest object " + repr(self.to_dict()) + ">"


class ListEventsResponse:
    """List events response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , events: List[Event] = []
        , next_page_token: str = ""
    , **kwargs) -> ListEventsResponse:
        self._attributes = dict()
        self.events = events
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def events(self) -> List[Event]:
        """Events."""
        return self._attributes["events"]


    @events.setter
    def events(self, value: List[Event]) -> None:
        _set_attribute(self._attributes, "ListEventsResponse", "events", value, List[Event], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListEventsResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListEventsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListEventsResponse:
        """Convert object to proto representation."""
        return management_pb2.ListEventsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListEventsResponse object " + repr(self.to_dict()) + ">"


class GetEventRequest:
    """Get event request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetEventRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetEventRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetEventRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetEventRequest:
        """Convert object to proto representation."""
        return management_pb2.GetEventRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetEventRequest object " + repr(self.to_dict()) + ">"


class BatchGetEventsRequest:
    """Batch get events request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , names: List[str] = []
    , **kwargs) -> BatchGetEventsRequest:
        self._attributes = dict()
        self.parent = parent
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchGetEventsRequest", "parent", value, str, "")


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BatchGetEventsRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetEventsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetEventsRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchGetEventsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetEventsRequest object " + repr(self.to_dict()) + ">"


class BatchGetEventsResponse:
    """Batch get events response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , events: List[Event] = []
    , **kwargs) -> BatchGetEventsResponse:
        self._attributes = dict()
        self.events = events

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def events(self) -> List[Event]:
        """Events."""
        return self._attributes["events"]


    @events.setter
    def events(self, value: List[Event]) -> None:
        _set_attribute(self._attributes, "BatchGetEventsResponse", "events", value, List[Event], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetEventsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetEventsResponse:
        """Convert object to proto representation."""
        return management_pb2.BatchGetEventsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetEventsResponse object " + repr(self.to_dict()) + ">"


class CreateModelRequest:
    """MODELS"""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , description: str = ""
        , get_if_exists: bool = False
    , **kwargs) -> CreateModelRequest:
        self._attributes = dict()
        self.name = name
        self.description = description
        self.get_if_exists = get_if_exists

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateModelRequest", "name", value, str, "")


    @property
    def description(self) -> str:
        """Description."""
        return self._attributes["description"]


    @description.setter
    def description(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateModelRequest", "description", value, str, "")


    @property
    def get_if_exists(self) -> bool:
        """Get if exists."""
        return self._attributes["get_if_exists"]


    @get_if_exists.setter
    def get_if_exists(self, value: bool) -> None:
        _set_attribute(self._attributes, "CreateModelRequest", "get_if_exists", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateModelRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateModelRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateModelRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateModelRequest object " + repr(self.to_dict()) + ">"


class GetModelRequest:
    """Get model request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetModelRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetModelRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetModelRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetModelRequest:
        """Convert object to proto representation."""
        return management_pb2.GetModelRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetModelRequest object " + repr(self.to_dict()) + ">"


class BatchGetModelsRequest:
    """Batch get models request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , names: List[str] = []
    , **kwargs) -> BatchGetModelsRequest:
        self._attributes = dict()
        self.parent = parent
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchGetModelsRequest", "parent", value, str, "")


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BatchGetModelsRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetModelsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetModelsRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchGetModelsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetModelsRequest object " + repr(self.to_dict()) + ">"


class BatchGetModelsResponse:
    """Batch get models response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , models: List[Model] = []
    , **kwargs) -> BatchGetModelsResponse:
        self._attributes = dict()
        self.models = models

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def models(self) -> List[Model]:
        """Models."""
        return self._attributes["models"]


    @models.setter
    def models(self, value: List[Model]) -> None:
        _set_attribute(self._attributes, "BatchGetModelsResponse", "models", value, List[Model], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetModelsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetModelsResponse:
        """Convert object to proto representation."""
        return management_pb2.BatchGetModelsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetModelsResponse object " + repr(self.to_dict()) + ">"


class ListModelsRequest:
    """List models request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
        , latest: bool = False
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , start_time: datetime = None
        , end_time: datetime = None
        , all_projects: bool = False
        , order_by: str = ""
        , search: str = ""
    , **kwargs) -> ListModelsRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token
        self.latest = latest
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.start_time = start_time
        self.end_time = end_time
        self.all_projects = all_projects
        self.order_by = order_by
        self.search = search

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListModelsRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListModelsRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListModelsRequest", "page_token", value, str, "")


    @property
    def latest(self) -> bool:
        """Latest."""
        return self._attributes["latest"]


    @latest.setter
    def latest(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListModelsRequest", "latest", value, bool, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListModelsRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListModelsRequest", "ignore_filters", value, List[str], "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListModelsRequest", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListModelsRequest", "end_time", value, datetime, "")


    @property
    def all_projects(self) -> bool:
        """All projects."""
        return self._attributes["all_projects"]


    @all_projects.setter
    def all_projects(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListModelsRequest", "all_projects", value, bool, "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListModelsRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListModelsRequest", "search", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListModelsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListModelsRequest:
        """Convert object to proto representation."""
        return management_pb2.ListModelsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListModelsRequest object " + repr(self.to_dict()) + ">"


class ListModelsResponse:
    """List models response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , models: List[Model] = []
        , next_page_token: str = ""
    , **kwargs) -> ListModelsResponse:
        self._attributes = dict()
        self.models = models
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def models(self) -> List[Model]:
        """Models."""
        return self._attributes["models"]


    @models.setter
    def models(self, value: List[Model]) -> None:
        _set_attribute(self._attributes, "ListModelsResponse", "models", value, List[Model], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListModelsResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListModelsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListModelsResponse:
        """Convert object to proto representation."""
        return management_pb2.ListModelsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListModelsResponse object " + repr(self.to_dict()) + ">"


class DeleteModelRequest:
    """Delete model request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> DeleteModelRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "DeleteModelRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.DeleteModelRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.DeleteModelRequest:
        """Convert object to proto representation."""
        return management_pb2.DeleteModelRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DeleteModelRequest object " + repr(self.to_dict()) + ">"


class ValidateModelRequest:
    """Validate model request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , environment: str = ""
        , schema: str = ""
    , **kwargs) -> ValidateModelRequest:
        self._attributes = dict()
        self.environment = environment
        self.schema = schema

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def environment(self) -> str:
        """Environment."""
        return self._attributes["environment"]


    @environment.setter
    def environment(self, value: str) -> None:
        _set_attribute(self._attributes, "ValidateModelRequest", "environment", value, str, "")


    @property
    def schema(self) -> str:
        """Schema."""
        return self._attributes["schema"]


    @schema.setter
    def schema(self, value: str) -> None:
        _set_attribute(self._attributes, "ValidateModelRequest", "schema", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ValidateModelRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ValidateModelRequest:
        """Convert object to proto representation."""
        return management_pb2.ValidateModelRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ValidateModelRequest object " + repr(self.to_dict()) + ">"


class CreateModelVersionRequest:
    """MODEL VERSIONS"""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , run_name: str = ""
        , datasets: List[str] = []
    , **kwargs) -> CreateModelVersionRequest:
        self._attributes = dict()
        self.parent = parent
        self.run_name = run_name
        self.datasets = datasets

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateModelVersionRequest", "parent", value, str, "")


    @property
    def run_name(self) -> str:
        """Run name."""
        return self._attributes["run_name"]


    @run_name.setter
    def run_name(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateModelVersionRequest", "run_name", value, str, "")


    @property
    def datasets(self) -> List[str]:
        """Datasets."""
        return self._attributes["datasets"]


    @datasets.setter
    def datasets(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "CreateModelVersionRequest", "datasets", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateModelVersionRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateModelVersionRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateModelVersionRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateModelVersionRequest object " + repr(self.to_dict()) + ">"


class GetModelVersionRequest:
    """Get model version request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetModelVersionRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetModelVersionRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetModelVersionRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetModelVersionRequest:
        """Convert object to proto representation."""
        return management_pb2.GetModelVersionRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetModelVersionRequest object " + repr(self.to_dict()) + ">"


class BatchGetModelVersionsRequest:
    """Batch get model versions request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , names: List[str] = []
    , **kwargs) -> BatchGetModelVersionsRequest:
        self._attributes = dict()
        self.parent = parent
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchGetModelVersionsRequest", "parent", value, str, "")


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BatchGetModelVersionsRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetModelVersionsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetModelVersionsRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchGetModelVersionsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetModelVersionsRequest object " + repr(self.to_dict()) + ">"


class BatchGetModelVersionsResponse:
    """Batch get model versions response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , model_versions: List[ModelVersion] = []
    , **kwargs) -> BatchGetModelVersionsResponse:
        self._attributes = dict()
        self.model_versions = model_versions

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def model_versions(self) -> List[ModelVersion]:
        """Model versions."""
        return self._attributes["model_versions"]


    @model_versions.setter
    def model_versions(self, value: List[ModelVersion]) -> None:
        _set_attribute(self._attributes, "BatchGetModelVersionsResponse", "model_versions", value, List[ModelVersion], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetModelVersionsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetModelVersionsResponse:
        """Convert object to proto representation."""
        return management_pb2.BatchGetModelVersionsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetModelVersionsResponse object " + repr(self.to_dict()) + ">"


class ListModelVersionsRequest:
    """List model versions request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
        , latest: bool = False
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , start_time: datetime = None
        , end_time: datetime = None
        , all_projects: bool = False
        , order_by: str = ""
        , search: str = ""
    , **kwargs) -> ListModelVersionsRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token
        self.latest = latest
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.start_time = start_time
        self.end_time = end_time
        self.all_projects = all_projects
        self.order_by = order_by
        self.search = search

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListModelVersionsRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """The maximum number of items to return."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListModelVersionsRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """The next_page_token value returned from a previous List request, if any."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListModelVersionsRequest", "page_token", value, str, "")


    @property
    def latest(self) -> bool:
        """Get the latest model versions first."""
        return self._attributes["latest"]


    @latest.setter
    def latest(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListModelVersionsRequest", "latest", value, bool, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListModelVersionsRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListModelVersionsRequest", "ignore_filters", value, List[str], "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListModelVersionsRequest", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListModelVersionsRequest", "end_time", value, datetime, "")


    @property
    def all_projects(self) -> bool:
        """All projects."""
        return self._attributes["all_projects"]


    @all_projects.setter
    def all_projects(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListModelVersionsRequest", "all_projects", value, bool, "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListModelVersionsRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListModelVersionsRequest", "search", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListModelVersionsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListModelVersionsRequest:
        """Convert object to proto representation."""
        return management_pb2.ListModelVersionsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListModelVersionsRequest object " + repr(self.to_dict()) + ">"


class ListModelVersionsResponse:
    """List model versions response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , model_versions: List[ModelVersion] = []
        , next_page_token: str = ""
    , **kwargs) -> ListModelVersionsResponse:
        self._attributes = dict()
        self.model_versions = model_versions
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def model_versions(self) -> List[ModelVersion]:
        """Model versions."""
        return self._attributes["model_versions"]


    @model_versions.setter
    def model_versions(self, value: List[ModelVersion]) -> None:
        _set_attribute(self._attributes, "ListModelVersionsResponse", "model_versions", value, List[ModelVersion], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListModelVersionsResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListModelVersionsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListModelVersionsResponse:
        """Convert object to proto representation."""
        return management_pb2.ListModelVersionsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListModelVersionsResponse object " + repr(self.to_dict()) + ">"


class CreateExperimentRequest:
    """Create experiment request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , run_name: str = ""
    , **kwargs) -> CreateExperimentRequest:
        self._attributes = dict()
        self.parent = parent
        self.run_name = run_name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateExperimentRequest", "parent", value, str, "")


    @property
    def run_name(self) -> str:
        """Run name."""
        return self._attributes["run_name"]


    @run_name.setter
    def run_name(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateExperimentRequest", "run_name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateExperimentRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateExperimentRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateExperimentRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateExperimentRequest object " + repr(self.to_dict()) + ">"


class GetExperimentRequest:
    """Get experiment request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetExperimentRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetExperimentRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetExperimentRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetExperimentRequest:
        """Convert object to proto representation."""
        return management_pb2.GetExperimentRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetExperimentRequest object " + repr(self.to_dict()) + ">"


class BatchGetExperimentsRequest:
    """Batch get experiments request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , names: List[str] = []
    , **kwargs) -> BatchGetExperimentsRequest:
        self._attributes = dict()
        self.parent = parent
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchGetExperimentsRequest", "parent", value, str, "")


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BatchGetExperimentsRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetExperimentsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetExperimentsRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchGetExperimentsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetExperimentsRequest object " + repr(self.to_dict()) + ">"


class BatchGetExperimentsResponse:
    """Batch get experiments response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , experiments: List[Experiment] = []
    , **kwargs) -> BatchGetExperimentsResponse:
        self._attributes = dict()
        self.experiments = experiments

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def experiments(self) -> List[Experiment]:
        """Experiments."""
        return self._attributes["experiments"]


    @experiments.setter
    def experiments(self, value: List[Experiment]) -> None:
        _set_attribute(self._attributes, "BatchGetExperimentsResponse", "experiments", value, List[Experiment], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetExperimentsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetExperimentsResponse:
        """Convert object to proto representation."""
        return management_pb2.BatchGetExperimentsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetExperimentsResponse object " + repr(self.to_dict()) + ">"


class ListExperimentsRequest:
    """List experiments request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , start_time: datetime = None
        , end_time: datetime = None
        , all_projects: bool = False
        , latest: bool = False
        , order_by: str = ""
        , search: str = ""
    , **kwargs) -> ListExperimentsRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.start_time = start_time
        self.end_time = end_time
        self.all_projects = all_projects
        self.latest = latest
        self.order_by = order_by
        self.search = search

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListExperimentsRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """The maximum number of items to return."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListExperimentsRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """The next_page_token value returned from a previous List request, if any."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListExperimentsRequest", "page_token", value, str, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListExperimentsRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListExperimentsRequest", "ignore_filters", value, List[str], "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListExperimentsRequest", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListExperimentsRequest", "end_time", value, datetime, "")


    @property
    def all_projects(self) -> bool:
        """All projects."""
        return self._attributes["all_projects"]


    @all_projects.setter
    def all_projects(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListExperimentsRequest", "all_projects", value, bool, "")


    @property
    def latest(self) -> bool:
        """Latest."""
        return self._attributes["latest"]


    @latest.setter
    def latest(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListExperimentsRequest", "latest", value, bool, "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListExperimentsRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListExperimentsRequest", "search", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListExperimentsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListExperimentsRequest:
        """Convert object to proto representation."""
        return management_pb2.ListExperimentsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListExperimentsRequest object " + repr(self.to_dict()) + ">"


class ListExperimentsResponse:
    """List experiments response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , experiments: List[Experiment] = []
        , next_page_token: str = ""
    , **kwargs) -> ListExperimentsResponse:
        self._attributes = dict()
        self.experiments = experiments
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def experiments(self) -> List[Experiment]:
        """Experiments."""
        return self._attributes["experiments"]


    @experiments.setter
    def experiments(self, value: List[Experiment]) -> None:
        _set_attribute(self._attributes, "ListExperimentsResponse", "experiments", value, List[Experiment], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListExperimentsResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListExperimentsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListExperimentsResponse:
        """Convert object to proto representation."""
        return management_pb2.ListExperimentsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListExperimentsResponse object " + repr(self.to_dict()) + ">"


class CreateBatchPredictionRequest:
    """Create batch prediction request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , run_name: str = ""
        , trained_model_version_name: str = ""
    , **kwargs) -> CreateBatchPredictionRequest:
        self._attributes = dict()
        self.parent = parent
        self.run_name = run_name
        self.trained_model_version_name = trained_model_version_name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateBatchPredictionRequest", "parent", value, str, "")


    @property
    def run_name(self) -> str:
        """Run name."""
        return self._attributes["run_name"]


    @run_name.setter
    def run_name(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateBatchPredictionRequest", "run_name", value, str, "")


    @property
    def trained_model_version_name(self) -> str:
        """Trained model version name."""
        return self._attributes["trained_model_version_name"]


    @trained_model_version_name.setter
    def trained_model_version_name(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateBatchPredictionRequest", "trained_model_version_name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateBatchPredictionRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateBatchPredictionRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateBatchPredictionRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateBatchPredictionRequest object " + repr(self.to_dict()) + ">"


class ListBatchPredictionsRequest:
    """List batch predictions request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
        , latest: bool = False
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , start_time: datetime = None
        , end_time: datetime = None
        , all_projects: bool = False
        , order_by: str = ""
        , search: str = ""
    , **kwargs) -> ListBatchPredictionsRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token
        self.latest = latest
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.start_time = start_time
        self.end_time = end_time
        self.all_projects = all_projects
        self.order_by = order_by
        self.search = search

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListBatchPredictionsRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """The maximum number of items to return."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListBatchPredictionsRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """The next_page_token value returned from a previous List request, if any."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListBatchPredictionsRequest", "page_token", value, str, "")


    @property
    def latest(self) -> bool:
        """Get the latest batch predictions first."""
        return self._attributes["latest"]


    @latest.setter
    def latest(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListBatchPredictionsRequest", "latest", value, bool, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListBatchPredictionsRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListBatchPredictionsRequest", "ignore_filters", value, List[str], "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListBatchPredictionsRequest", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListBatchPredictionsRequest", "end_time", value, datetime, "")


    @property
    def all_projects(self) -> bool:
        """All projects."""
        return self._attributes["all_projects"]


    @all_projects.setter
    def all_projects(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListBatchPredictionsRequest", "all_projects", value, bool, "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListBatchPredictionsRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListBatchPredictionsRequest", "search", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListBatchPredictionsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListBatchPredictionsRequest:
        """Convert object to proto representation."""
        return management_pb2.ListBatchPredictionsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListBatchPredictionsRequest object " + repr(self.to_dict()) + ">"


class ListBatchPredictionsResponse:
    """List batch predictions response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , batch_predictions: List[BatchPrediction] = []
        , next_page_token: str = ""
    , **kwargs) -> ListBatchPredictionsResponse:
        self._attributes = dict()
        self.batch_predictions = batch_predictions
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def batch_predictions(self) -> List[BatchPrediction]:
        """Batch predictions."""
        return self._attributes["batch_predictions"]


    @batch_predictions.setter
    def batch_predictions(self, value: List[BatchPrediction]) -> None:
        _set_attribute(self._attributes, "ListBatchPredictionsResponse", "batch_predictions", value, List[BatchPrediction], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListBatchPredictionsResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListBatchPredictionsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListBatchPredictionsResponse:
        """Convert object to proto representation."""
        return management_pb2.ListBatchPredictionsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListBatchPredictionsResponse object " + repr(self.to_dict()) + ">"


class BatchPredictionRequest:
    """Batch prediction request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> BatchPredictionRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchPredictionRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchPredictionRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchPredictionRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchPredictionRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchPredictionRequest object " + repr(self.to_dict()) + ">"


class BatchGetBatchPredictionsRequest:
    """Batch get batch predictions request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , names: List[str] = []
    , **kwargs) -> BatchGetBatchPredictionsRequest:
        self._attributes = dict()
        self.parent = parent
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchGetBatchPredictionsRequest", "parent", value, str, "")


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BatchGetBatchPredictionsRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetBatchPredictionsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetBatchPredictionsRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchGetBatchPredictionsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetBatchPredictionsRequest object " + repr(self.to_dict()) + ">"


class BatchGetBatchPredictionsResponse:
    """Batch get batch predictions response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , batch_predictions: List[BatchPrediction] = []
    , **kwargs) -> BatchGetBatchPredictionsResponse:
        self._attributes = dict()
        self.batch_predictions = batch_predictions

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def batch_predictions(self) -> List[BatchPrediction]:
        """Batch predictions."""
        return self._attributes["batch_predictions"]


    @batch_predictions.setter
    def batch_predictions(self, value: List[BatchPrediction]) -> None:
        _set_attribute(self._attributes, "BatchGetBatchPredictionsResponse", "batch_predictions", value, List[BatchPrediction], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetBatchPredictionsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetBatchPredictionsResponse:
        """Convert object to proto representation."""
        return management_pb2.BatchGetBatchPredictionsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetBatchPredictionsResponse object " + repr(self.to_dict()) + ">"


class YamlDiffRequest:
    """Yaml diff request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , right: str = ""
        , right_text: str = ""
        , left: str = ""
        , left_text: str = ""
        , parent: str = ""
    , **kwargs) -> YamlDiffRequest:
        self._attributes = dict()
        self.right = right
        self.right_text = right_text
        self.left = left
        self.left_text = left_text
        self.parent = parent

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def right(self) -> str:
        """Right."""
        return self._attributes["right"]


    @right.setter
    def right(self, value: str) -> None:
        _set_attribute(self._attributes, "YamlDiffRequest", "right", value, str, "")


    @property
    def right_text(self) -> str:
        """Right text."""
        return self._attributes["right_text"]


    @right_text.setter
    def right_text(self, value: str) -> None:
        _set_attribute(self._attributes, "YamlDiffRequest", "right_text", value, str, "")


    @property
    def left(self) -> str:
        """Left."""
        return self._attributes["left"]


    @left.setter
    def left(self, value: str) -> None:
        _set_attribute(self._attributes, "YamlDiffRequest", "left", value, str, "")


    @property
    def left_text(self) -> str:
        """Left text."""
        return self._attributes["left_text"]


    @left_text.setter
    def left_text(self, value: str) -> None:
        _set_attribute(self._attributes, "YamlDiffRequest", "left_text", value, str, "")


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "YamlDiffRequest", "parent", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.YamlDiffRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.YamlDiffRequest:
        """Convert object to proto representation."""
        return management_pb2.YamlDiffRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<YamlDiffRequest object " + repr(self.to_dict()) + ">"


class YamlDiffResponse:
    """Yaml diff response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , text: str = ""
    , **kwargs) -> YamlDiffResponse:
        self._attributes = dict()
        self.text = text

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def text(self) -> str:
        """Text."""
        return self._attributes["text"]


    @text.setter
    def text(self, value: str) -> None:
        _set_attribute(self._attributes, "YamlDiffResponse", "text", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.YamlDiffResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.YamlDiffResponse:
        """Convert object to proto representation."""
        return management_pb2.YamlDiffResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<YamlDiffResponse object " + repr(self.to_dict()) + ">"


class CreateEnvironmentRequest:
    """Create environment request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , environment_id: str = ""
        , source: str = ""
        , git_integration: EnvironmentGitIntegration = None
        , get_if_exists: bool = False
    , **kwargs) -> CreateEnvironmentRequest:
        self._attributes = dict()
        self.parent = parent
        self.environment_id = environment_id
        self.source = source
        self.git_integration = git_integration
        self.get_if_exists = get_if_exists

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateEnvironmentRequest", "parent", value, str, "")


    @property
    def environment_id(self) -> str:
        """Optional user-readable ID to project, which will
 become the last element of the resource name.
 https://aip.dev/133#user-specified-ids"""
        return self._attributes["environment_id"]


    @environment_id.setter
    def environment_id(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateEnvironmentRequest", "environment_id", value, str, "")


    @property
    def source(self) -> str:
        """Source."""
        return self._attributes["source"]


    @source.setter
    def source(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateEnvironmentRequest", "source", value, str, "")


    @property
    def git_integration(self) -> EnvironmentGitIntegration:
        """Git integration."""
        return self._attributes["git_integration"]


    @git_integration.setter
    def git_integration(self, value: EnvironmentGitIntegration) -> None:
        _set_attribute(self._attributes, "CreateEnvironmentRequest", "git_integration", value, EnvironmentGitIntegration, "")


    @property
    def get_if_exists(self) -> bool:
        """Get if exists."""
        return self._attributes["get_if_exists"]


    @get_if_exists.setter
    def get_if_exists(self, value: bool) -> None:
        _set_attribute(self._attributes, "CreateEnvironmentRequest", "get_if_exists", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateEnvironmentRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateEnvironmentRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateEnvironmentRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateEnvironmentRequest object " + repr(self.to_dict()) + ">"


class UpdateEnvironmentRequest:
    """Update environment request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , environment: Environment = None
        , update_mask: protobuf.FieldMask = None
    , **kwargs) -> UpdateEnvironmentRequest:
        self._attributes = dict()
        self.environment = environment
        self.update_mask = update_mask

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def environment(self) -> Environment:
        """Environment."""
        return self._attributes["environment"]


    @environment.setter
    def environment(self, value: Environment) -> None:
        _set_attribute(self._attributes, "UpdateEnvironmentRequest", "environment", value, Environment, "")


    @property
    def update_mask(self) -> protobuf.FieldMask:
        """Update mask."""
        return self._attributes["update_mask"]


    @update_mask.setter
    def update_mask(self, value: protobuf.FieldMask) -> None:
        _set_attribute(self._attributes, "UpdateEnvironmentRequest", "update_mask", value, protobuf.FieldMask, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.UpdateEnvironmentRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.UpdateEnvironmentRequest:
        """Convert object to proto representation."""
        return management_pb2.UpdateEnvironmentRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<UpdateEnvironmentRequest object " + repr(self.to_dict()) + ">"


class GetEnvironmentRequest:
    """Get environment request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetEnvironmentRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetEnvironmentRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetEnvironmentRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetEnvironmentRequest:
        """Convert object to proto representation."""
        return management_pb2.GetEnvironmentRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetEnvironmentRequest object " + repr(self.to_dict()) + ">"


class BatchGetEnvironmentsRequest:
    """Batch get environments request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , names: List[str] = []
    , **kwargs) -> BatchGetEnvironmentsRequest:
        self._attributes = dict()
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BatchGetEnvironmentsRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetEnvironmentsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetEnvironmentsRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchGetEnvironmentsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetEnvironmentsRequest object " + repr(self.to_dict()) + ">"


class BatchGetEnvironmentsResponse:
    """Batch get environments response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , environments: List[Environment] = []
    , **kwargs) -> BatchGetEnvironmentsResponse:
        self._attributes = dict()
        self.environments = environments

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def environments(self) -> List[Environment]:
        """Environments."""
        return self._attributes["environments"]


    @environments.setter
    def environments(self, value: List[Environment]) -> None:
        _set_attribute(self._attributes, "BatchGetEnvironmentsResponse", "environments", value, List[Environment], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetEnvironmentsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetEnvironmentsResponse:
        """Convert object to proto representation."""
        return management_pb2.BatchGetEnvironmentsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetEnvironmentsResponse object " + repr(self.to_dict()) + ">"


class DeleteEnvironmentRequest:
    """Delete environment request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> DeleteEnvironmentRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "DeleteEnvironmentRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.DeleteEnvironmentRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.DeleteEnvironmentRequest:
        """Convert object to proto representation."""
        return management_pb2.DeleteEnvironmentRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DeleteEnvironmentRequest object " + repr(self.to_dict()) + ">"


class ListEnvironmentsRequest:
    """List environments request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , start_time: datetime = None
        , end_time: datetime = None
        , order_by: str = ""
        , search: str = ""
        , latest: bool = False
    , **kwargs) -> ListEnvironmentsRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.start_time = start_time
        self.end_time = end_time
        self.order_by = order_by
        self.search = search
        self.latest = latest

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListEnvironmentsRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListEnvironmentsRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListEnvironmentsRequest", "page_token", value, str, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListEnvironmentsRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListEnvironmentsRequest", "ignore_filters", value, List[str], "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListEnvironmentsRequest", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListEnvironmentsRequest", "end_time", value, datetime, "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListEnvironmentsRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListEnvironmentsRequest", "search", value, str, "")


    @property
    def latest(self) -> bool:
        """Latest."""
        return self._attributes["latest"]


    @latest.setter
    def latest(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListEnvironmentsRequest", "latest", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListEnvironmentsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListEnvironmentsRequest:
        """Convert object to proto representation."""
        return management_pb2.ListEnvironmentsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListEnvironmentsRequest object " + repr(self.to_dict()) + ">"


class ListEnvironmentsResponse:
    """List environments response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , environments: List[Environment] = []
        , next_page_token: str = ""
    , **kwargs) -> ListEnvironmentsResponse:
        self._attributes = dict()
        self.environments = environments
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def environments(self) -> List[Environment]:
        """Environments."""
        return self._attributes["environments"]


    @environments.setter
    def environments(self, value: List[Environment]) -> None:
        _set_attribute(self._attributes, "ListEnvironmentsResponse", "environments", value, List[Environment], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListEnvironmentsResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListEnvironmentsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListEnvironmentsResponse:
        """Convert object to proto representation."""
        return management_pb2.ListEnvironmentsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListEnvironmentsResponse object " + repr(self.to_dict()) + ">"


class GetSystemMessageRequest:
    """Get system message request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
    , **kwargs) -> GetSystemMessageRequest:
        self._attributes = dict()

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetSystemMessageRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetSystemMessageRequest:
        """Convert object to proto representation."""
        return management_pb2.GetSystemMessageRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetSystemMessageRequest object " + repr(self.to_dict()) + ">"


class GetSystemMessageResponse:
    """Get system message response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , message: str = ""
    , **kwargs) -> GetSystemMessageResponse:
        self._attributes = dict()
        self.message = message

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def message(self) -> str:
        """Message."""
        return self._attributes["message"]


    @message.setter
    def message(self, value: str) -> None:
        _set_attribute(self._attributes, "GetSystemMessageResponse", "message", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetSystemMessageResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetSystemMessageResponse:
        """Convert object to proto representation."""
        return management_pb2.GetSystemMessageResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetSystemMessageResponse object " + repr(self.to_dict()) + ">"


class GetFeatureFlagRequest:
    """FeatureFlags"""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , resource: str = ""
        , feature: str = ""
    , **kwargs) -> GetFeatureFlagRequest:
        self._attributes = dict()
        self.resource = resource
        self.feature = feature

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def resource(self) -> str:
        """Resource."""
        return self._attributes["resource"]


    @resource.setter
    def resource(self, value: str) -> None:
        _set_attribute(self._attributes, "GetFeatureFlagRequest", "resource", value, str, "")


    @property
    def feature(self) -> str:
        """Feature."""
        return self._attributes["feature"]


    @feature.setter
    def feature(self, value: str) -> None:
        _set_attribute(self._attributes, "GetFeatureFlagRequest", "feature", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetFeatureFlagRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetFeatureFlagRequest:
        """Convert object to proto representation."""
        return management_pb2.GetFeatureFlagRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetFeatureFlagRequest object " + repr(self.to_dict()) + ">"


class GetFeatureFlagResponse:
    """Get feature flag response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , resource: str = ""
        , feature: str = ""
        , enabled: bool = False
    , **kwargs) -> GetFeatureFlagResponse:
        self._attributes = dict()
        self.resource = resource
        self.feature = feature
        self.enabled = enabled

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def resource(self) -> str:
        """Resource."""
        return self._attributes["resource"]


    @resource.setter
    def resource(self, value: str) -> None:
        _set_attribute(self._attributes, "GetFeatureFlagResponse", "resource", value, str, "")


    @property
    def feature(self) -> str:
        """Feature."""
        return self._attributes["feature"]


    @feature.setter
    def feature(self, value: str) -> None:
        _set_attribute(self._attributes, "GetFeatureFlagResponse", "feature", value, str, "")


    @property
    def enabled(self) -> bool:
        """Enabled."""
        return self._attributes["enabled"]


    @enabled.setter
    def enabled(self, value: bool) -> None:
        _set_attribute(self._attributes, "GetFeatureFlagResponse", "enabled", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetFeatureFlagResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetFeatureFlagResponse:
        """Convert object to proto representation."""
        return management_pb2.GetFeatureFlagResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetFeatureFlagResponse object " + repr(self.to_dict()) + ">"


class GetOrganizationFeatureFlagsRequest:
    """Get organization feature flags request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , resource: str = ""
    , **kwargs) -> GetOrganizationFeatureFlagsRequest:
        self._attributes = dict()
        self.resource = resource

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def resource(self) -> str:
        """Resource."""
        return self._attributes["resource"]


    @resource.setter
    def resource(self, value: str) -> None:
        _set_attribute(self._attributes, "GetOrganizationFeatureFlagsRequest", "resource", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetOrganizationFeatureFlagsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetOrganizationFeatureFlagsRequest:
        """Convert object to proto representation."""
        return management_pb2.GetOrganizationFeatureFlagsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetOrganizationFeatureFlagsRequest object " + repr(self.to_dict()) + ">"


class GetOrganizationFeatureFlagsResponse:
    """Get organization feature flags response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , feature_flags: Dict[str, bool] = None
    , **kwargs) -> GetOrganizationFeatureFlagsResponse:
        self._attributes = dict()
        self.feature_flags = feature_flags

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def feature_flags(self) -> Dict[str, bool]:
        """Feature flags."""
        return self._attributes["feature_flags"]


    @feature_flags.setter
    def feature_flags(self, value: Dict[str, bool]) -> None:
        _set_attribute(self._attributes, "GetOrganizationFeatureFlagsResponse", "feature_flags", value, Dict[str, bool], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetOrganizationFeatureFlagsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetOrganizationFeatureFlagsResponse:
        """Convert object to proto representation."""
        return management_pb2.GetOrganizationFeatureFlagsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetOrganizationFeatureFlagsResponse object " + repr(self.to_dict()) + ">"


class CreateArtifactRequest:
    """Artifacts"""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , artifact: Artifact = None
    , **kwargs) -> CreateArtifactRequest:
        self._attributes = dict()
        self.parent = parent
        self.artifact = artifact

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateArtifactRequest", "parent", value, str, "")


    @property
    def artifact(self) -> Artifact:
        """Artifact."""
        return self._attributes["artifact"]


    @artifact.setter
    def artifact(self, value: Artifact) -> None:
        _set_attribute(self._attributes, "CreateArtifactRequest", "artifact", value, Artifact, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateArtifactRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateArtifactRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateArtifactRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateArtifactRequest object " + repr(self.to_dict()) + ">"


class GetArtifactRequest:
    """Get artifact request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , name: str = ""
        , key: str = ""
    , **kwargs) -> GetArtifactRequest:
        self._attributes = dict()
        self.parent = parent
        self.name = name
        self.key = key

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "GetArtifactRequest", "parent", value, str, "")


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetArtifactRequest", "name", value, str, "")


    @property
    def key(self) -> str:
        """Key."""
        return self._attributes["key"]


    @key.setter
    def key(self, value: str) -> None:
        _set_attribute(self._attributes, "GetArtifactRequest", "key", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetArtifactRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetArtifactRequest:
        """Convert object to proto representation."""
        return management_pb2.GetArtifactRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetArtifactRequest object " + repr(self.to_dict()) + ">"


class BatchGetArtifactsRequest:
    """Batch get artifacts request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , names: List[str] = []
    , **kwargs) -> BatchGetArtifactsRequest:
        self._attributes = dict()
        self.parent = parent
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchGetArtifactsRequest", "parent", value, str, "")


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BatchGetArtifactsRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetArtifactsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetArtifactsRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchGetArtifactsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetArtifactsRequest object " + repr(self.to_dict()) + ">"


class BatchGetArtifactsResponse:
    """Batch get artifacts response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , artifacts: List[Artifact] = []
    , **kwargs) -> BatchGetArtifactsResponse:
        self._attributes = dict()
        self.artifacts = artifacts

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def artifacts(self) -> List[Artifact]:
        """Artifacts."""
        return self._attributes["artifacts"]


    @artifacts.setter
    def artifacts(self, value: List[Artifact]) -> None:
        _set_attribute(self._attributes, "BatchGetArtifactsResponse", "artifacts", value, List[Artifact], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetArtifactsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetArtifactsResponse:
        """Convert object to proto representation."""
        return management_pb2.BatchGetArtifactsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetArtifactsResponse object " + repr(self.to_dict()) + ">"


class DeleteArtifactRequest:
    """Delete artifact request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> DeleteArtifactRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "DeleteArtifactRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.DeleteArtifactRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.DeleteArtifactRequest:
        """Convert object to proto representation."""
        return management_pb2.DeleteArtifactRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DeleteArtifactRequest object " + repr(self.to_dict()) + ">"


class ListArtifactsRequest:
    """List artifacts request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , order_by: str = ""
        , search: str = ""
        , latest: bool = False
    , **kwargs) -> ListArtifactsRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.order_by = order_by
        self.search = search
        self.latest = latest

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListArtifactsRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListArtifactsRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListArtifactsRequest", "page_token", value, str, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListArtifactsRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListArtifactsRequest", "ignore_filters", value, List[str], "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListArtifactsRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListArtifactsRequest", "search", value, str, "")


    @property
    def latest(self) -> bool:
        """Latest."""
        return self._attributes["latest"]


    @latest.setter
    def latest(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListArtifactsRequest", "latest", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListArtifactsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListArtifactsRequest:
        """Convert object to proto representation."""
        return management_pb2.ListArtifactsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListArtifactsRequest object " + repr(self.to_dict()) + ">"


class ListArtifactsResponse:
    """List artifacts response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , artifacts: List[Artifact] = []
        , next_page_token: str = ""
    , **kwargs) -> ListArtifactsResponse:
        self._attributes = dict()
        self.artifacts = artifacts
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def artifacts(self) -> List[Artifact]:
        """Artifacts."""
        return self._attributes["artifacts"]


    @artifacts.setter
    def artifacts(self, value: List[Artifact]) -> None:
        _set_attribute(self._attributes, "ListArtifactsResponse", "artifacts", value, List[Artifact], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListArtifactsResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListArtifactsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListArtifactsResponse:
        """Convert object to proto representation."""
        return management_pb2.ListArtifactsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListArtifactsResponse object " + repr(self.to_dict()) + ">"


class GenerateArtifactUploadURLRequest:
    """Generate artifact upload u r l request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , resource: str = ""
        , path: str = ""
        , type: str = ""
        , mime_type: str = ""
        , metadata: str = ""
        , resumable: bool = False
        , run_name: str = ""
        , key: str = ""
    , **kwargs) -> GenerateArtifactUploadURLRequest:
        self._attributes = dict()
        self.resource = resource
        self.path = path
        self.type = type
        self.mime_type = mime_type
        self.metadata = metadata
        self.resumable = resumable
        self.run_name = run_name
        self.key = key

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def resource(self) -> str:
        """Resource."""
        return self._attributes["resource"]


    @resource.setter
    def resource(self, value: str) -> None:
        _set_attribute(self._attributes, "GenerateArtifactUploadURLRequest", "resource", value, str, "")


    @property
    def path(self) -> str:
        """Path."""
        return self._attributes["path"]


    @path.setter
    def path(self, value: str) -> None:
        _set_attribute(self._attributes, "GenerateArtifactUploadURLRequest", "path", value, str, "")


    @property
    def type(self) -> str:
        """Type."""
        return self._attributes["type"]


    @type.setter
    def type(self, value: str) -> None:
        _set_attribute(self._attributes, "GenerateArtifactUploadURLRequest", "type", value, str, "")


    @property
    def mime_type(self) -> str:
        """Mime type."""
        return self._attributes["mime_type"]


    @mime_type.setter
    def mime_type(self, value: str) -> None:
        _set_attribute(self._attributes, "GenerateArtifactUploadURLRequest", "mime_type", value, str, "")


    @property
    def metadata(self) -> str:
        """Metadata."""
        return self._attributes["metadata"]


    @metadata.setter
    def metadata(self, value: str) -> None:
        _set_attribute(self._attributes, "GenerateArtifactUploadURLRequest", "metadata", value, str, "")


    @property
    def resumable(self) -> bool:
        """Resumable."""
        return self._attributes["resumable"]


    @resumable.setter
    def resumable(self, value: bool) -> None:
        _set_attribute(self._attributes, "GenerateArtifactUploadURLRequest", "resumable", value, bool, "")


    @property
    def run_name(self) -> str:
        """Run name."""
        return self._attributes["run_name"]


    @run_name.setter
    def run_name(self, value: str) -> None:
        _set_attribute(self._attributes, "GenerateArtifactUploadURLRequest", "run_name", value, str, "")


    @property
    def key(self) -> str:
        """Key."""
        return self._attributes["key"]


    @key.setter
    def key(self, value: str) -> None:
        _set_attribute(self._attributes, "GenerateArtifactUploadURLRequest", "key", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GenerateArtifactUploadURLRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GenerateArtifactUploadURLRequest:
        """Convert object to proto representation."""
        return management_pb2.GenerateArtifactUploadURLRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GenerateArtifactUploadURLRequest object " + repr(self.to_dict()) + ">"


class GenerateArtifactUploadURLResponse:
    """Generate artifact upload u r l response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , url: str = ""
        , artifact: Artifact = None
    , **kwargs) -> GenerateArtifactUploadURLResponse:
        self._attributes = dict()
        self.url = url
        self.artifact = artifact

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def url(self) -> str:
        """Url."""
        return self._attributes["url"]


    @url.setter
    def url(self, value: str) -> None:
        _set_attribute(self._attributes, "GenerateArtifactUploadURLResponse", "url", value, str, "")


    @property
    def artifact(self) -> Artifact:
        """Artifact."""
        return self._attributes["artifact"]


    @artifact.setter
    def artifact(self, value: Artifact) -> None:
        _set_attribute(self._attributes, "GenerateArtifactUploadURLResponse", "artifact", value, Artifact, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GenerateArtifactUploadURLResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GenerateArtifactUploadURLResponse:
        """Convert object to proto representation."""
        return management_pb2.GenerateArtifactUploadURLResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GenerateArtifactUploadURLResponse object " + repr(self.to_dict()) + ">"


class ListUserIntegrationProvidersRequest:
    """List user integration providers request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
    , **kwargs) -> ListUserIntegrationProvidersRequest:
        self._attributes = dict()

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListUserIntegrationProvidersRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListUserIntegrationProvidersRequest:
        """Convert object to proto representation."""
        return management_pb2.ListUserIntegrationProvidersRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListUserIntegrationProvidersRequest object " + repr(self.to_dict()) + ">"


class ListUserIntegrationProvidersResponse:
    """List user integration providers response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , providers: List[UserIntegrationProvider] = []
    , **kwargs) -> ListUserIntegrationProvidersResponse:
        self._attributes = dict()
        self.providers = providers

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def providers(self) -> List[UserIntegrationProvider]:
        """Providers."""
        return self._attributes["providers"]


    @providers.setter
    def providers(self, value: List[UserIntegrationProvider]) -> None:
        _set_attribute(self._attributes, "ListUserIntegrationProvidersResponse", "providers", value, List[UserIntegrationProvider], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListUserIntegrationProvidersResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListUserIntegrationProvidersResponse:
        """Convert object to proto representation."""
        return management_pb2.ListUserIntegrationProvidersResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListUserIntegrationProvidersResponse object " + repr(self.to_dict()) + ">"


class ListUserIntegrationsRequest:
    """List user integrations request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , user_name: str = ""
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , page_token: str = ""
        , page_size: int = 0
        , order_by: str = ""
        , search: str = ""
        , show_disconnected: bool = False
    , **kwargs) -> ListUserIntegrationsRequest:
        self._attributes = dict()
        self.user_name = user_name
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.page_token = page_token
        self.page_size = page_size
        self.order_by = order_by
        self.search = search
        self.show_disconnected = show_disconnected

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def user_name(self) -> str:
        """User name."""
        return self._attributes["user_name"]


    @user_name.setter
    def user_name(self, value: str) -> None:
        _set_attribute(self._attributes, "ListUserIntegrationsRequest", "user_name", value, str, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListUserIntegrationsRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListUserIntegrationsRequest", "ignore_filters", value, List[str], "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListUserIntegrationsRequest", "page_token", value, str, "")


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListUserIntegrationsRequest", "page_size", value, int, "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListUserIntegrationsRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListUserIntegrationsRequest", "search", value, str, "")


    @property
    def show_disconnected(self) -> bool:
        """Show disconnected."""
        return self._attributes["show_disconnected"]


    @show_disconnected.setter
    def show_disconnected(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListUserIntegrationsRequest", "show_disconnected", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListUserIntegrationsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListUserIntegrationsRequest:
        """Convert object to proto representation."""
        return management_pb2.ListUserIntegrationsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListUserIntegrationsRequest object " + repr(self.to_dict()) + ">"


class ListUserIntegrationsResponse:
    """List user integrations response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , integrations: List[UserIntegration] = []
        , next_page_token: str = ""
    , **kwargs) -> ListUserIntegrationsResponse:
        self._attributes = dict()
        self.integrations = integrations
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def integrations(self) -> List[UserIntegration]:
        """Integrations."""
        return self._attributes["integrations"]


    @integrations.setter
    def integrations(self, value: List[UserIntegration]) -> None:
        _set_attribute(self._attributes, "ListUserIntegrationsResponse", "integrations", value, List[UserIntegration], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListUserIntegrationsResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListUserIntegrationsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListUserIntegrationsResponse:
        """Convert object to proto representation."""
        return management_pb2.ListUserIntegrationsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListUserIntegrationsResponse object " + repr(self.to_dict()) + ">"


class DisconnectUserIntegrationRequest:
    """Disconnect user integration request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , reason: str = ""
        , data: str = ""
    , **kwargs) -> DisconnectUserIntegrationRequest:
        self._attributes = dict()
        self.name = name
        self.reason = reason
        self.data = data

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "DisconnectUserIntegrationRequest", "name", value, str, "")


    @property
    def reason(self) -> str:
        """Reason."""
        return self._attributes["reason"]


    @reason.setter
    def reason(self, value: str) -> None:
        _set_attribute(self._attributes, "DisconnectUserIntegrationRequest", "reason", value, str, "")


    @property
    def data(self) -> str:
        """Data."""
        return self._attributes["data"]


    @data.setter
    def data(self, value: str) -> None:
        _set_attribute(self._attributes, "DisconnectUserIntegrationRequest", "data", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.DisconnectUserIntegrationRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.DisconnectUserIntegrationRequest:
        """Convert object to proto representation."""
        return management_pb2.DisconnectUserIntegrationRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DisconnectUserIntegrationRequest object " + repr(self.to_dict()) + ">"


class ListGitProviderNamespacesRequest:
    """List git provider namespaces request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , user_integration_name: str = ""
    , **kwargs) -> ListGitProviderNamespacesRequest:
        self._attributes = dict()
        self.user_integration_name = user_integration_name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def user_integration_name(self) -> str:
        """User integration name."""
        return self._attributes["user_integration_name"]


    @user_integration_name.setter
    def user_integration_name(self, value: str) -> None:
        _set_attribute(self._attributes, "ListGitProviderNamespacesRequest", "user_integration_name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListGitProviderNamespacesRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListGitProviderNamespacesRequest:
        """Convert object to proto representation."""
        return management_pb2.ListGitProviderNamespacesRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListGitProviderNamespacesRequest object " + repr(self.to_dict()) + ">"


class ListGitProviderNamespacesResponse:
    """List git provider namespaces response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , user_integration_name: str = ""
        , namespaces: List[GitProviderNamespace] = []
    , **kwargs) -> ListGitProviderNamespacesResponse:
        self._attributes = dict()
        self.user_integration_name = user_integration_name
        self.namespaces = namespaces

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def user_integration_name(self) -> str:
        """User integration name."""
        return self._attributes["user_integration_name"]


    @user_integration_name.setter
    def user_integration_name(self, value: str) -> None:
        _set_attribute(self._attributes, "ListGitProviderNamespacesResponse", "user_integration_name", value, str, "")


    @property
    def namespaces(self) -> List[GitProviderNamespace]:
        """Namespaces."""
        return self._attributes["namespaces"]


    @namespaces.setter
    def namespaces(self, value: List[GitProviderNamespace]) -> None:
        _set_attribute(self._attributes, "ListGitProviderNamespacesResponse", "namespaces", value, List[GitProviderNamespace], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListGitProviderNamespacesResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListGitProviderNamespacesResponse:
        """Convert object to proto representation."""
        return management_pb2.ListGitProviderNamespacesResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListGitProviderNamespacesResponse object " + repr(self.to_dict()) + ">"


class ListGitProviderRepositoriesRequest:
    """List git provider repositories request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , user_integration_name: str = ""
        , git_provider_namespace_name: str = ""
    , **kwargs) -> ListGitProviderRepositoriesRequest:
        self._attributes = dict()
        self.user_integration_name = user_integration_name
        self.git_provider_namespace_name = git_provider_namespace_name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def user_integration_name(self) -> str:
        """User integration name."""
        return self._attributes["user_integration_name"]


    @user_integration_name.setter
    def user_integration_name(self, value: str) -> None:
        _set_attribute(self._attributes, "ListGitProviderRepositoriesRequest", "user_integration_name", value, str, "")


    @property
    def git_provider_namespace_name(self) -> str:
        """Git provider namespace name."""
        return self._attributes["git_provider_namespace_name"]


    @git_provider_namespace_name.setter
    def git_provider_namespace_name(self, value: str) -> None:
        _set_attribute(self._attributes, "ListGitProviderRepositoriesRequest", "git_provider_namespace_name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListGitProviderRepositoriesRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListGitProviderRepositoriesRequest:
        """Convert object to proto representation."""
        return management_pb2.ListGitProviderRepositoriesRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListGitProviderRepositoriesRequest object " + repr(self.to_dict()) + ">"


class ListGitProviderRepositoriesResponse:
    """List git provider repositories response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , user_integration_name: str = ""
        , git_provider_namespace_name: str = ""
        , repositories: List[GitProviderRepository] = []
    , **kwargs) -> ListGitProviderRepositoriesResponse:
        self._attributes = dict()
        self.user_integration_name = user_integration_name
        self.git_provider_namespace_name = git_provider_namespace_name
        self.repositories = repositories

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def user_integration_name(self) -> str:
        """User integration name."""
        return self._attributes["user_integration_name"]


    @user_integration_name.setter
    def user_integration_name(self, value: str) -> None:
        _set_attribute(self._attributes, "ListGitProviderRepositoriesResponse", "user_integration_name", value, str, "")


    @property
    def git_provider_namespace_name(self) -> str:
        """Git provider namespace name."""
        return self._attributes["git_provider_namespace_name"]


    @git_provider_namespace_name.setter
    def git_provider_namespace_name(self, value: str) -> None:
        _set_attribute(self._attributes, "ListGitProviderRepositoriesResponse", "git_provider_namespace_name", value, str, "")


    @property
    def repositories(self) -> List[GitProviderRepository]:
        """Repositories."""
        return self._attributes["repositories"]


    @repositories.setter
    def repositories(self, value: List[GitProviderRepository]) -> None:
        _set_attribute(self._attributes, "ListGitProviderRepositoriesResponse", "repositories", value, List[GitProviderRepository], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListGitProviderRepositoriesResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListGitProviderRepositoriesResponse:
        """Convert object to proto representation."""
        return management_pb2.ListGitProviderRepositoriesResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListGitProviderRepositoriesResponse object " + repr(self.to_dict()) + ">"


class ConnectProjectToGitRepositoryRequest:
    """Connect project to git repository request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , project_name: str = ""
        , user_integration_name: str = ""
        , git_provider_repository_name: str = ""
        , base_directory: str = ""
        , default_env_is_protected: bool = False
        , default_env_branch_name: str = ""
        , default_env_run_on_git_push: bool = False
        , cicd_runner: str = ""
        , cicd_runner_initialize: bool = False
        , code_review_env_auto_create: bool = False
        , code_review_env_run_on_git_push: bool = False
    , **kwargs) -> ConnectProjectToGitRepositoryRequest:
        self._attributes = dict()
        self.project_name = project_name
        self.user_integration_name = user_integration_name
        self.git_provider_repository_name = git_provider_repository_name
        self.base_directory = base_directory
        self.default_env_is_protected = default_env_is_protected
        self.default_env_branch_name = default_env_branch_name
        self.default_env_run_on_git_push = default_env_run_on_git_push
        self.cicd_runner = cicd_runner
        self.cicd_runner_initialize = cicd_runner_initialize
        self.code_review_env_auto_create = code_review_env_auto_create
        self.code_review_env_run_on_git_push = code_review_env_run_on_git_push

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def project_name(self) -> str:
        """Project name."""
        return self._attributes["project_name"]


    @project_name.setter
    def project_name(self, value: str) -> None:
        _set_attribute(self._attributes, "ConnectProjectToGitRepositoryRequest", "project_name", value, str, "")


    @property
    def user_integration_name(self) -> str:
        """User integration name."""
        return self._attributes["user_integration_name"]


    @user_integration_name.setter
    def user_integration_name(self, value: str) -> None:
        _set_attribute(self._attributes, "ConnectProjectToGitRepositoryRequest", "user_integration_name", value, str, "")


    @property
    def git_provider_repository_name(self) -> str:
        """Git provider repository name."""
        return self._attributes["git_provider_repository_name"]


    @git_provider_repository_name.setter
    def git_provider_repository_name(self, value: str) -> None:
        _set_attribute(self._attributes, "ConnectProjectToGitRepositoryRequest", "git_provider_repository_name", value, str, "")


    @property
    def base_directory(self) -> str:
        """Base directory."""
        return self._attributes["base_directory"]


    @base_directory.setter
    def base_directory(self, value: str) -> None:
        _set_attribute(self._attributes, "ConnectProjectToGitRepositoryRequest", "base_directory", value, str, "")


    @property
    def default_env_is_protected(self) -> bool:
        """Default env is protected."""
        return self._attributes["default_env_is_protected"]


    @default_env_is_protected.setter
    def default_env_is_protected(self, value: bool) -> None:
        _set_attribute(self._attributes, "ConnectProjectToGitRepositoryRequest", "default_env_is_protected", value, bool, "")


    @property
    def default_env_branch_name(self) -> str:
        """Default env branch name."""
        return self._attributes["default_env_branch_name"]


    @default_env_branch_name.setter
    def default_env_branch_name(self, value: str) -> None:
        _set_attribute(self._attributes, "ConnectProjectToGitRepositoryRequest", "default_env_branch_name", value, str, "")


    @property
    def default_env_run_on_git_push(self) -> bool:
        """Default env run on git push."""
        return self._attributes["default_env_run_on_git_push"]


    @default_env_run_on_git_push.setter
    def default_env_run_on_git_push(self, value: bool) -> None:
        _set_attribute(self._attributes, "ConnectProjectToGitRepositoryRequest", "default_env_run_on_git_push", value, bool, "")


    @property
    def cicd_runner(self) -> str:
        """Cicd runner."""
        return self._attributes["cicd_runner"]


    @cicd_runner.setter
    def cicd_runner(self, value: str) -> None:
        _set_attribute(self._attributes, "ConnectProjectToGitRepositoryRequest", "cicd_runner", value, str, "")


    @property
    def cicd_runner_initialize(self) -> bool:
        """Cicd runner initialize."""
        return self._attributes["cicd_runner_initialize"]


    @cicd_runner_initialize.setter
    def cicd_runner_initialize(self, value: bool) -> None:
        _set_attribute(self._attributes, "ConnectProjectToGitRepositoryRequest", "cicd_runner_initialize", value, bool, "")


    @property
    def code_review_env_auto_create(self) -> bool:
        """Code review env auto create."""
        return self._attributes["code_review_env_auto_create"]


    @code_review_env_auto_create.setter
    def code_review_env_auto_create(self, value: bool) -> None:
        _set_attribute(self._attributes, "ConnectProjectToGitRepositoryRequest", "code_review_env_auto_create", value, bool, "")


    @property
    def code_review_env_run_on_git_push(self) -> bool:
        """Code review env run on git push."""
        return self._attributes["code_review_env_run_on_git_push"]


    @code_review_env_run_on_git_push.setter
    def code_review_env_run_on_git_push(self, value: bool) -> None:
        _set_attribute(self._attributes, "ConnectProjectToGitRepositoryRequest", "code_review_env_run_on_git_push", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ConnectProjectToGitRepositoryRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ConnectProjectToGitRepositoryRequest:
        """Convert object to proto representation."""
        return management_pb2.ConnectProjectToGitRepositoryRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ConnectProjectToGitRepositoryRequest object " + repr(self.to_dict()) + ">"


class ConnectProjectToGitRepositoryResponse:
    """Connect project to git repository response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , project_git_integration: ProjectGitIntegration = None
    , **kwargs) -> ConnectProjectToGitRepositoryResponse:
        self._attributes = dict()
        self.project_git_integration = project_git_integration

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def project_git_integration(self) -> ProjectGitIntegration:
        """Project git integration."""
        return self._attributes["project_git_integration"]


    @project_git_integration.setter
    def project_git_integration(self, value: ProjectGitIntegration) -> None:
        _set_attribute(self._attributes, "ConnectProjectToGitRepositoryResponse", "project_git_integration", value, ProjectGitIntegration, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ConnectProjectToGitRepositoryResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ConnectProjectToGitRepositoryResponse:
        """Convert object to proto representation."""
        return management_pb2.ConnectProjectToGitRepositoryResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ConnectProjectToGitRepositoryResponse object " + repr(self.to_dict()) + ">"


class GetProjectGitIntegrationForProjectRequest:
    """Get project git integration for project request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , project: str = ""
    , **kwargs) -> GetProjectGitIntegrationForProjectRequest:
        self._attributes = dict()
        self.project = project

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def project(self) -> str:
        """Project."""
        return self._attributes["project"]


    @project.setter
    def project(self, value: str) -> None:
        _set_attribute(self._attributes, "GetProjectGitIntegrationForProjectRequest", "project", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetProjectGitIntegrationForProjectRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetProjectGitIntegrationForProjectRequest:
        """Convert object to proto representation."""
        return management_pb2.GetProjectGitIntegrationForProjectRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetProjectGitIntegrationForProjectRequest object " + repr(self.to_dict()) + ">"


class GetEnvironmentGitIntegrationForEnvironmentRequest:
    """Get environment git integration for environment request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , environment: str = ""
    , **kwargs) -> GetEnvironmentGitIntegrationForEnvironmentRequest:
        self._attributes = dict()
        self.environment = environment

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def environment(self) -> str:
        """Environment."""
        return self._attributes["environment"]


    @environment.setter
    def environment(self, value: str) -> None:
        _set_attribute(self._attributes, "GetEnvironmentGitIntegrationForEnvironmentRequest", "environment", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetEnvironmentGitIntegrationForEnvironmentRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetEnvironmentGitIntegrationForEnvironmentRequest:
        """Convert object to proto representation."""
        return management_pb2.GetEnvironmentGitIntegrationForEnvironmentRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetEnvironmentGitIntegrationForEnvironmentRequest object " + repr(self.to_dict()) + ">"


class GetEnvironmentGitIntegrationForEnvironmentResponse:
    """Get environment git integration for environment response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , environment: str = ""
        , environment_git_integration: EnvironmentGitIntegration = None
        , project_git_integration: ProjectGitIntegration = None
    , **kwargs) -> GetEnvironmentGitIntegrationForEnvironmentResponse:
        self._attributes = dict()
        self.environment = environment
        self.environment_git_integration = environment_git_integration
        self.project_git_integration = project_git_integration

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def environment(self) -> str:
        """Environment."""
        return self._attributes["environment"]


    @environment.setter
    def environment(self, value: str) -> None:
        _set_attribute(self._attributes, "GetEnvironmentGitIntegrationForEnvironmentResponse", "environment", value, str, "")


    @property
    def environment_git_integration(self) -> EnvironmentGitIntegration:
        """Environment git integration."""
        return self._attributes["environment_git_integration"]


    @environment_git_integration.setter
    def environment_git_integration(self, value: EnvironmentGitIntegration) -> None:
        _set_attribute(self._attributes, "GetEnvironmentGitIntegrationForEnvironmentResponse", "environment_git_integration", value, EnvironmentGitIntegration, "")


    @property
    def project_git_integration(self) -> ProjectGitIntegration:
        """Project git integration."""
        return self._attributes["project_git_integration"]


    @project_git_integration.setter
    def project_git_integration(self, value: ProjectGitIntegration) -> None:
        _set_attribute(self._attributes, "GetEnvironmentGitIntegrationForEnvironmentResponse", "project_git_integration", value, ProjectGitIntegration, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetEnvironmentGitIntegrationForEnvironmentResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetEnvironmentGitIntegrationForEnvironmentResponse:
        """Convert object to proto representation."""
        return management_pb2.GetEnvironmentGitIntegrationForEnvironmentResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetEnvironmentGitIntegrationForEnvironmentResponse object " + repr(self.to_dict()) + ">"


class GenerateSsoAdminPortalURLRequest:
    """Generate sso admin portal u r l request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , organization: str = ""
    , **kwargs) -> GenerateSsoAdminPortalURLRequest:
        self._attributes = dict()
        self.organization = organization

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def organization(self) -> str:
        """Organization."""
        return self._attributes["organization"]


    @organization.setter
    def organization(self, value: str) -> None:
        _set_attribute(self._attributes, "GenerateSsoAdminPortalURLRequest", "organization", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GenerateSsoAdminPortalURLRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GenerateSsoAdminPortalURLRequest:
        """Convert object to proto representation."""
        return management_pb2.GenerateSsoAdminPortalURLRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GenerateSsoAdminPortalURLRequest object " + repr(self.to_dict()) + ">"


class GenerateSsoAdminPortalURLResponse:
    """Generate sso admin portal u r l response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , url: str = ""
    , **kwargs) -> GenerateSsoAdminPortalURLResponse:
        self._attributes = dict()
        self.url = url

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def url(self) -> str:
        """Url."""
        return self._attributes["url"]


    @url.setter
    def url(self, value: str) -> None:
        _set_attribute(self._attributes, "GenerateSsoAdminPortalURLResponse", "url", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GenerateSsoAdminPortalURLResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GenerateSsoAdminPortalURLResponse:
        """Convert object to proto representation."""
        return management_pb2.GenerateSsoAdminPortalURLResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GenerateSsoAdminPortalURLResponse object " + repr(self.to_dict()) + ">"


class GenerateDSyncAdminPortalURLRequest:
    """Generate d sync admin portal u r l request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , organization: str = ""
    , **kwargs) -> GenerateDSyncAdminPortalURLRequest:
        self._attributes = dict()
        self.organization = organization

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def organization(self) -> str:
        """Organization."""
        return self._attributes["organization"]


    @organization.setter
    def organization(self, value: str) -> None:
        _set_attribute(self._attributes, "GenerateDSyncAdminPortalURLRequest", "organization", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GenerateDSyncAdminPortalURLRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GenerateDSyncAdminPortalURLRequest:
        """Convert object to proto representation."""
        return management_pb2.GenerateDSyncAdminPortalURLRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GenerateDSyncAdminPortalURLRequest object " + repr(self.to_dict()) + ">"


class GenerateDSyncAdminPortalURLResponse:
    """Generate d sync admin portal u r l response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , url: str = ""
    , **kwargs) -> GenerateDSyncAdminPortalURLResponse:
        self._attributes = dict()
        self.url = url

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def url(self) -> str:
        """Url."""
        return self._attributes["url"]


    @url.setter
    def url(self, value: str) -> None:
        _set_attribute(self._attributes, "GenerateDSyncAdminPortalURLResponse", "url", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GenerateDSyncAdminPortalURLResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GenerateDSyncAdminPortalURLResponse:
        """Convert object to proto representation."""
        return management_pb2.GenerateDSyncAdminPortalURLResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GenerateDSyncAdminPortalURLResponse object " + repr(self.to_dict()) + ">"


class ExchangeTokenRequest:
    """Exchange token request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , token: str = ""
    , **kwargs) -> ExchangeTokenRequest:
        self._attributes = dict()
        self.token = token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def token(self) -> str:
        """Token."""
        return self._attributes["token"]


    @token.setter
    def token(self, value: str) -> None:
        _set_attribute(self._attributes, "ExchangeTokenRequest", "token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ExchangeTokenRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ExchangeTokenRequest:
        """Convert object to proto representation."""
        return management_pb2.ExchangeTokenRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ExchangeTokenRequest object " + repr(self.to_dict()) + ">"


class ExchangeTokenResponse:
    """Exchange token response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , token: str = ""
    , **kwargs) -> ExchangeTokenResponse:
        self._attributes = dict()
        self.token = token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def token(self) -> str:
        """Token."""
        return self._attributes["token"]


    @token.setter
    def token(self, value: str) -> None:
        _set_attribute(self._attributes, "ExchangeTokenResponse", "token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ExchangeTokenResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ExchangeTokenResponse:
        """Convert object to proto representation."""
        return management_pb2.ExchangeTokenResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ExchangeTokenResponse object " + repr(self.to_dict()) + ">"


class GetPrincipalRequest:
    """Get principal request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetPrincipalRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetPrincipalRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetPrincipalRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetPrincipalRequest:
        """Convert object to proto representation."""
        return management_pb2.GetPrincipalRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetPrincipalRequest object " + repr(self.to_dict()) + ">"


class GetApiKeyRequest:
    """API KEYS"""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetApiKeyRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetApiKeyRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetApiKeyRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetApiKeyRequest:
        """Convert object to proto representation."""
        return management_pb2.GetApiKeyRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetApiKeyRequest object " + repr(self.to_dict()) + ">"


class BatchGetApiKeysRequest:
    """Batch get api keys request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , names: List[str] = []
    , **kwargs) -> BatchGetApiKeysRequest:
        self._attributes = dict()
        self.parent = parent
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchGetApiKeysRequest", "parent", value, str, "")


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BatchGetApiKeysRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetApiKeysRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetApiKeysRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchGetApiKeysRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetApiKeysRequest object " + repr(self.to_dict()) + ">"


class BatchGetApiKeysResponse:
    """Batch get api keys response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , api_keys: List[ApiKey] = []
    , **kwargs) -> BatchGetApiKeysResponse:
        self._attributes = dict()
        self.api_keys = api_keys

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def api_keys(self) -> List[ApiKey]:
        """Api keys."""
        return self._attributes["api_keys"]


    @api_keys.setter
    def api_keys(self, value: List[ApiKey]) -> None:
        _set_attribute(self._attributes, "BatchGetApiKeysResponse", "api_keys", value, List[ApiKey], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetApiKeysResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetApiKeysResponse:
        """Convert object to proto representation."""
        return management_pb2.BatchGetApiKeysResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetApiKeysResponse object " + repr(self.to_dict()) + ">"


class ListApiKeysRequest:
    """List api keys request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , order_by: str = ""
        , search: str = ""
    , **kwargs) -> ListApiKeysRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.order_by = order_by
        self.search = search

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListApiKeysRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListApiKeysRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListApiKeysRequest", "page_token", value, str, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListApiKeysRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListApiKeysRequest", "ignore_filters", value, List[str], "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListApiKeysRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListApiKeysRequest", "search", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListApiKeysRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListApiKeysRequest:
        """Convert object to proto representation."""
        return management_pb2.ListApiKeysRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListApiKeysRequest object " + repr(self.to_dict()) + ">"


class ListApiKeysResponse:
    """List api keys response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , api_keys: List[ApiKey] = []
        , next_page_token: str = ""
    , **kwargs) -> ListApiKeysResponse:
        self._attributes = dict()
        self.api_keys = api_keys
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def api_keys(self) -> List[ApiKey]:
        """Api keys."""
        return self._attributes["api_keys"]


    @api_keys.setter
    def api_keys(self, value: List[ApiKey]) -> None:
        _set_attribute(self._attributes, "ListApiKeysResponse", "api_keys", value, List[ApiKey], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListApiKeysResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListApiKeysResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListApiKeysResponse:
        """Convert object to proto representation."""
        return management_pb2.ListApiKeysResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListApiKeysResponse object " + repr(self.to_dict()) + ">"


class CreateApiKeyRequest:
    """Create api key request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , api_key: ApiKey = None
    , **kwargs) -> CreateApiKeyRequest:
        self._attributes = dict()
        self.parent = parent
        self.api_key = api_key

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateApiKeyRequest", "parent", value, str, "")


    @property
    def api_key(self) -> ApiKey:
        """Api key."""
        return self._attributes["api_key"]


    @api_key.setter
    def api_key(self, value: ApiKey) -> None:
        _set_attribute(self._attributes, "CreateApiKeyRequest", "api_key", value, ApiKey, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateApiKeyRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateApiKeyRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateApiKeyRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateApiKeyRequest object " + repr(self.to_dict()) + ">"


class UpdateApiKeyRequest:
    """Update api key request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , api_key: ApiKey = None
        , update_mask: protobuf.FieldMask = None
    , **kwargs) -> UpdateApiKeyRequest:
        self._attributes = dict()
        self.api_key = api_key
        self.update_mask = update_mask

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def api_key(self) -> ApiKey:
        """Api key."""
        return self._attributes["api_key"]


    @api_key.setter
    def api_key(self, value: ApiKey) -> None:
        _set_attribute(self._attributes, "UpdateApiKeyRequest", "api_key", value, ApiKey, "")


    @property
    def update_mask(self) -> protobuf.FieldMask:
        """Update mask."""
        return self._attributes["update_mask"]


    @update_mask.setter
    def update_mask(self, value: protobuf.FieldMask) -> None:
        _set_attribute(self._attributes, "UpdateApiKeyRequest", "update_mask", value, protobuf.FieldMask, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.UpdateApiKeyRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.UpdateApiKeyRequest:
        """Convert object to proto representation."""
        return management_pb2.UpdateApiKeyRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<UpdateApiKeyRequest object " + repr(self.to_dict()) + ">"


class RevokeApiKeyRequest:
    """Revoke api key request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> RevokeApiKeyRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "RevokeApiKeyRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.RevokeApiKeyRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.RevokeApiKeyRequest:
        """Convert object to proto representation."""
        return management_pb2.RevokeApiKeyRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<RevokeApiKeyRequest object " + repr(self.to_dict()) + ">"


class GetApiKeyProjectRequest:
    """Get api key project request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetApiKeyProjectRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetApiKeyProjectRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetApiKeyProjectRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetApiKeyProjectRequest:
        """Convert object to proto representation."""
        return management_pb2.GetApiKeyProjectRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetApiKeyProjectRequest object " + repr(self.to_dict()) + ">"


class GetRunRequest:
    """Runs"""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetRunRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetRunRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetRunRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetRunRequest:
        """Convert object to proto representation."""
        return management_pb2.GetRunRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetRunRequest object " + repr(self.to_dict()) + ">"


class BatchGetRunsRequest:
    """Batch get runs request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , names: List[str] = []
    , **kwargs) -> BatchGetRunsRequest:
        self._attributes = dict()
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BatchGetRunsRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetRunsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetRunsRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchGetRunsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetRunsRequest object " + repr(self.to_dict()) + ">"


class BatchGetRunsResponse:
    """Batch get runs response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , runs: List[Run] = []
    , **kwargs) -> BatchGetRunsResponse:
        self._attributes = dict()
        self.runs = runs

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def runs(self) -> List[Run]:
        """Runs."""
        return self._attributes["runs"]


    @runs.setter
    def runs(self, value: List[Run]) -> None:
        _set_attribute(self._attributes, "BatchGetRunsResponse", "runs", value, List[Run], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetRunsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetRunsResponse:
        """Convert object to proto representation."""
        return management_pb2.BatchGetRunsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetRunsResponse object " + repr(self.to_dict()) + ">"


class ListRunsRequest:
    """List runs request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , start_time: datetime = None
        , end_time: datetime = None
        , order_by: str = ""
        , search: str = ""
        , latest: bool = False
    , **kwargs) -> ListRunsRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.start_time = start_time
        self.end_time = end_time
        self.order_by = order_by
        self.search = search
        self.latest = latest

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListRunsRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListRunsRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListRunsRequest", "page_token", value, str, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListRunsRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListRunsRequest", "ignore_filters", value, List[str], "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListRunsRequest", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListRunsRequest", "end_time", value, datetime, "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListRunsRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListRunsRequest", "search", value, str, "")


    @property
    def latest(self) -> bool:
        """Latest."""
        return self._attributes["latest"]


    @latest.setter
    def latest(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListRunsRequest", "latest", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListRunsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListRunsRequest:
        """Convert object to proto representation."""
        return management_pb2.ListRunsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListRunsRequest object " + repr(self.to_dict()) + ">"


class ListRunsResponse:
    """List runs response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , runs: List[Run] = []
        , next_page_token: str = ""
    , **kwargs) -> ListRunsResponse:
        self._attributes = dict()
        self.runs = runs
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def runs(self) -> List[Run]:
        """Runs."""
        return self._attributes["runs"]


    @runs.setter
    def runs(self, value: List[Run]) -> None:
        _set_attribute(self._attributes, "ListRunsResponse", "runs", value, List[Run], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListRunsResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListRunsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListRunsResponse:
        """Convert object to proto representation."""
        return management_pb2.ListRunsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListRunsResponse object " + repr(self.to_dict()) + ">"


class CreateRunRequest:
    """Create run request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , run_id: str = ""
        , description: str = ""
        , heartbeat_interval: int = 0
        , get_if_exists: bool = False
    , **kwargs) -> CreateRunRequest:
        self._attributes = dict()
        self.parent = parent
        self.run_id = run_id
        self.description = description
        self.heartbeat_interval = heartbeat_interval
        self.get_if_exists = get_if_exists

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateRunRequest", "parent", value, str, "")


    @property
    def run_id(self) -> str:
        """Run id."""
        return self._attributes["run_id"]


    @run_id.setter
    def run_id(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateRunRequest", "run_id", value, str, "")


    @property
    def description(self) -> str:
        """Description."""
        return self._attributes["description"]


    @description.setter
    def description(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateRunRequest", "description", value, str, "")


    @property
    def heartbeat_interval(self) -> int:
        """Heartbeat interval."""
        return self._attributes["heartbeat_interval"]


    @heartbeat_interval.setter
    def heartbeat_interval(self, value: int) -> None:
        _set_attribute(self._attributes, "CreateRunRequest", "heartbeat_interval", value, int, "")


    @property
    def get_if_exists(self) -> bool:
        """Get if exists."""
        return self._attributes["get_if_exists"]


    @get_if_exists.setter
    def get_if_exists(self, value: bool) -> None:
        _set_attribute(self._attributes, "CreateRunRequest", "get_if_exists", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateRunRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateRunRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateRunRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateRunRequest object " + repr(self.to_dict()) + ">"


class UpdateRunRequest:
    """Update run request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , run: Run = None
        , update_paths: List[str] = []
    , **kwargs) -> UpdateRunRequest:
        self._attributes = dict()
        self.run = run
        self.update_paths = update_paths

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def run(self) -> Run:
        """Run."""
        return self._attributes["run"]


    @run.setter
    def run(self, value: Run) -> None:
        _set_attribute(self._attributes, "UpdateRunRequest", "run", value, Run, "")


    @property
    def update_paths(self) -> List[str]:
        """Update paths."""
        return self._attributes["update_paths"]


    @update_paths.setter
    def update_paths(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "UpdateRunRequest", "update_paths", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.UpdateRunRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.UpdateRunRequest:
        """Convert object to proto representation."""
        return management_pb2.UpdateRunRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<UpdateRunRequest object " + repr(self.to_dict()) + ">"


class DeleteRunRequest:
    """Delete run request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> DeleteRunRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "DeleteRunRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.DeleteRunRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.DeleteRunRequest:
        """Convert object to proto representation."""
        return management_pb2.DeleteRunRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DeleteRunRequest object " + repr(self.to_dict()) + ">"


class GetRunSummaryRequest:
    """Get run summary request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetRunSummaryRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetRunSummaryRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetRunSummaryRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetRunSummaryRequest:
        """Convert object to proto representation."""
        return management_pb2.GetRunSummaryRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetRunSummaryRequest object " + repr(self.to_dict()) + ">"


class GetRunCheckSummaryRequest:
    """Get run check summary request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetRunCheckSummaryRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetRunCheckSummaryRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetRunCheckSummaryRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetRunCheckSummaryRequest:
        """Convert object to proto representation."""
        return management_pb2.GetRunCheckSummaryRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetRunCheckSummaryRequest object " + repr(self.to_dict()) + ">"


class LogRunHeartbeatRequest:
    """Log run heartbeat request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> LogRunHeartbeatRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "LogRunHeartbeatRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.LogRunHeartbeatRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.LogRunHeartbeatRequest:
        """Convert object to proto representation."""
        return management_pb2.LogRunHeartbeatRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<LogRunHeartbeatRequest object " + repr(self.to_dict()) + ">"


class GetMetricRequest:
    """Metrics"""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , name: str = ""
        , key: str = ""
        , group_name: str = ""
        , step: int = 0
    , **kwargs) -> GetMetricRequest:
        self._attributes = dict()
        self.parent = parent
        self.name = name
        self.key = key
        self.group_name = group_name
        self.step = step

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "GetMetricRequest", "parent", value, str, "")


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetMetricRequest", "name", value, str, "")


    @property
    def key(self) -> str:
        """Key."""
        return self._attributes["key"]


    @key.setter
    def key(self, value: str) -> None:
        _set_attribute(self._attributes, "GetMetricRequest", "key", value, str, "")


    @property
    def group_name(self) -> str:
        """Group name."""
        return self._attributes["group_name"]


    @group_name.setter
    def group_name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetMetricRequest", "group_name", value, str, "")


    @property
    def step(self) -> int:
        """Step."""
        return self._attributes["step"]


    @step.setter
    def step(self, value: int) -> None:
        _set_attribute(self._attributes, "GetMetricRequest", "step", value, int, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetMetricRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetMetricRequest:
        """Convert object to proto representation."""
        return management_pb2.GetMetricRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetMetricRequest object " + repr(self.to_dict()) + ">"


class BatchGetMetricsRequest:
    """Batch get metrics request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , names: List[str] = []
    , **kwargs) -> BatchGetMetricsRequest:
        self._attributes = dict()
        self.parent = parent
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchGetMetricsRequest", "parent", value, str, "")


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BatchGetMetricsRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetMetricsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetMetricsRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchGetMetricsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetMetricsRequest object " + repr(self.to_dict()) + ">"


class BatchGetMetricsResponse:
    """Batch get metrics response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , metrics: List[Metric] = []
    , **kwargs) -> BatchGetMetricsResponse:
        self._attributes = dict()
        self.metrics = metrics

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def metrics(self) -> List[Metric]:
        """Metrics."""
        return self._attributes["metrics"]


    @metrics.setter
    def metrics(self, value: List[Metric]) -> None:
        _set_attribute(self._attributes, "BatchGetMetricsResponse", "metrics", value, List[Metric], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetMetricsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetMetricsResponse:
        """Convert object to proto representation."""
        return management_pb2.BatchGetMetricsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetMetricsResponse object " + repr(self.to_dict()) + ">"


class ListMetricsRequest:
    """List metrics request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , start_time: datetime = None
        , end_time: datetime = None
        , order_by: str = ""
        , search: str = ""
        , latest: bool = False
    , **kwargs) -> ListMetricsRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.start_time = start_time
        self.end_time = end_time
        self.order_by = order_by
        self.search = search
        self.latest = latest

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListMetricsRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListMetricsRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListMetricsRequest", "page_token", value, str, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListMetricsRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListMetricsRequest", "ignore_filters", value, List[str], "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListMetricsRequest", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListMetricsRequest", "end_time", value, datetime, "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListMetricsRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListMetricsRequest", "search", value, str, "")


    @property
    def latest(self) -> bool:
        """Latest."""
        return self._attributes["latest"]


    @latest.setter
    def latest(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListMetricsRequest", "latest", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListMetricsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListMetricsRequest:
        """Convert object to proto representation."""
        return management_pb2.ListMetricsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListMetricsRequest object " + repr(self.to_dict()) + ">"


class ListMetricsResponse:
    """List metrics response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , metrics: List[Metric] = []
        , next_page_token: str = ""
    , **kwargs) -> ListMetricsResponse:
        self._attributes = dict()
        self.metrics = metrics
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def metrics(self) -> List[Metric]:
        """Metrics."""
        return self._attributes["metrics"]


    @metrics.setter
    def metrics(self, value: List[Metric]) -> None:
        _set_attribute(self._attributes, "ListMetricsResponse", "metrics", value, List[Metric], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListMetricsResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListMetricsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListMetricsResponse:
        """Convert object to proto representation."""
        return management_pb2.ListMetricsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListMetricsResponse object " + repr(self.to_dict()) + ">"


class CreateMetricRequest:
    """Create metric request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , metric: Metric = None
    , **kwargs) -> CreateMetricRequest:
        self._attributes = dict()
        self.parent = parent
        self.metric = metric

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateMetricRequest", "parent", value, str, "")


    @property
    def metric(self) -> Metric:
        """Metric."""
        return self._attributes["metric"]


    @metric.setter
    def metric(self, value: Metric) -> None:
        _set_attribute(self._attributes, "CreateMetricRequest", "metric", value, Metric, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateMetricRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateMetricRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateMetricRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateMetricRequest object " + repr(self.to_dict()) + ">"


class UpdateMetricRequest:
    """Update metric request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , metric: Metric = None
        , update_mask: protobuf.FieldMask = None
    , **kwargs) -> UpdateMetricRequest:
        self._attributes = dict()
        self.metric = metric
        self.update_mask = update_mask

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def metric(self) -> Metric:
        """Metric."""
        return self._attributes["metric"]


    @metric.setter
    def metric(self, value: Metric) -> None:
        _set_attribute(self._attributes, "UpdateMetricRequest", "metric", value, Metric, "")


    @property
    def update_mask(self) -> protobuf.FieldMask:
        """Update mask."""
        return self._attributes["update_mask"]


    @update_mask.setter
    def update_mask(self, value: protobuf.FieldMask) -> None:
        _set_attribute(self._attributes, "UpdateMetricRequest", "update_mask", value, protobuf.FieldMask, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.UpdateMetricRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.UpdateMetricRequest:
        """Convert object to proto representation."""
        return management_pb2.UpdateMetricRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<UpdateMetricRequest object " + repr(self.to_dict()) + ">"


class GetMetadataRequest:
    """Metadata"""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , name: str = ""
        , key: str = ""
        , group_name: str = ""
    , **kwargs) -> GetMetadataRequest:
        self._attributes = dict()
        self.parent = parent
        self.name = name
        self.key = key
        self.group_name = group_name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "GetMetadataRequest", "parent", value, str, "")


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetMetadataRequest", "name", value, str, "")


    @property
    def key(self) -> str:
        """Key."""
        return self._attributes["key"]


    @key.setter
    def key(self, value: str) -> None:
        _set_attribute(self._attributes, "GetMetadataRequest", "key", value, str, "")


    @property
    def group_name(self) -> str:
        """Group name."""
        return self._attributes["group_name"]


    @group_name.setter
    def group_name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetMetadataRequest", "group_name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetMetadataRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetMetadataRequest:
        """Convert object to proto representation."""
        return management_pb2.GetMetadataRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetMetadataRequest object " + repr(self.to_dict()) + ">"


class BatchGetMetadataRequest:
    """Batch get metadata request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , names: List[str] = []
    , **kwargs) -> BatchGetMetadataRequest:
        self._attributes = dict()
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BatchGetMetadataRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetMetadataRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetMetadataRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchGetMetadataRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetMetadataRequest object " + repr(self.to_dict()) + ">"


class BatchGetMetadataResponse:
    """Batch get metadata response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , metadata: List[Metadata] = []
    , **kwargs) -> BatchGetMetadataResponse:
        self._attributes = dict()
        self.metadata = metadata

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def metadata(self) -> List[Metadata]:
        """Metadata."""
        return self._attributes["metadata"]


    @metadata.setter
    def metadata(self, value: List[Metadata]) -> None:
        _set_attribute(self._attributes, "BatchGetMetadataResponse", "metadata", value, List[Metadata], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetMetadataResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetMetadataResponse:
        """Convert object to proto representation."""
        return management_pb2.BatchGetMetadataResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetMetadataResponse object " + repr(self.to_dict()) + ">"


class ListMetadataRequest:
    """List metadata request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , start_time: datetime = None
        , end_time: datetime = None
        , order_by: str = ""
        , search: str = ""
        , latest: bool = False
    , **kwargs) -> ListMetadataRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.start_time = start_time
        self.end_time = end_time
        self.order_by = order_by
        self.search = search
        self.latest = latest

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListMetadataRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListMetadataRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListMetadataRequest", "page_token", value, str, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListMetadataRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListMetadataRequest", "ignore_filters", value, List[str], "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListMetadataRequest", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListMetadataRequest", "end_time", value, datetime, "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListMetadataRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListMetadataRequest", "search", value, str, "")


    @property
    def latest(self) -> bool:
        """Latest."""
        return self._attributes["latest"]


    @latest.setter
    def latest(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListMetadataRequest", "latest", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListMetadataRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListMetadataRequest:
        """Convert object to proto representation."""
        return management_pb2.ListMetadataRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListMetadataRequest object " + repr(self.to_dict()) + ">"


class ListMetadataResponse:
    """List metadata response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , metadata: List[Metadata] = []
        , next_page_token: str = ""
    , **kwargs) -> ListMetadataResponse:
        self._attributes = dict()
        self.metadata = metadata
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def metadata(self) -> List[Metadata]:
        """Metadata."""
        return self._attributes["metadata"]


    @metadata.setter
    def metadata(self, value: List[Metadata]) -> None:
        _set_attribute(self._attributes, "ListMetadataResponse", "metadata", value, List[Metadata], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListMetadataResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListMetadataResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListMetadataResponse:
        """Convert object to proto representation."""
        return management_pb2.ListMetadataResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListMetadataResponse object " + repr(self.to_dict()) + ">"


class CreateMetadataRequest:
    """Create metadata request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , metadata: Metadata = None
    , **kwargs) -> CreateMetadataRequest:
        self._attributes = dict()
        self.parent = parent
        self.metadata = metadata

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateMetadataRequest", "parent", value, str, "")


    @property
    def metadata(self) -> Metadata:
        """Metadata."""
        return self._attributes["metadata"]


    @metadata.setter
    def metadata(self, value: Metadata) -> None:
        _set_attribute(self._attributes, "CreateMetadataRequest", "metadata", value, Metadata, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateMetadataRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateMetadataRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateMetadataRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateMetadataRequest object " + repr(self.to_dict()) + ">"


class UpdateMetadataRequest:
    """Update metadata request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , metadata: Metadata = None
        , update_mask: protobuf.FieldMask = None
    , **kwargs) -> UpdateMetadataRequest:
        self._attributes = dict()
        self.metadata = metadata
        self.update_mask = update_mask

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def metadata(self) -> Metadata:
        """Metadata."""
        return self._attributes["metadata"]


    @metadata.setter
    def metadata(self, value: Metadata) -> None:
        _set_attribute(self._attributes, "UpdateMetadataRequest", "metadata", value, Metadata, "")


    @property
    def update_mask(self) -> protobuf.FieldMask:
        """Update mask."""
        return self._attributes["update_mask"]


    @update_mask.setter
    def update_mask(self, value: protobuf.FieldMask) -> None:
        _set_attribute(self._attributes, "UpdateMetadataRequest", "update_mask", value, protobuf.FieldMask, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.UpdateMetadataRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.UpdateMetadataRequest:
        """Convert object to proto representation."""
        return management_pb2.UpdateMetadataRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<UpdateMetadataRequest object " + repr(self.to_dict()) + ">"


class DeleteMetadataRequest:
    """Delete metadata request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> DeleteMetadataRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "DeleteMetadataRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.DeleteMetadataRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.DeleteMetadataRequest:
        """Convert object to proto representation."""
        return management_pb2.DeleteMetadataRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DeleteMetadataRequest object " + repr(self.to_dict()) + ">"


class GetNotificationPolicyRequest:
    """NOTIFICATION POLICY"""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetNotificationPolicyRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetNotificationPolicyRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetNotificationPolicyRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetNotificationPolicyRequest:
        """Convert object to proto representation."""
        return management_pb2.GetNotificationPolicyRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetNotificationPolicyRequest object " + repr(self.to_dict()) + ">"


class BatchGetNotificationPoliciesRequest:
    """Batch get notification policies request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , names: List[str] = []
    , **kwargs) -> BatchGetNotificationPoliciesRequest:
        self._attributes = dict()
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BatchGetNotificationPoliciesRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetNotificationPoliciesRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetNotificationPoliciesRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchGetNotificationPoliciesRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetNotificationPoliciesRequest object " + repr(self.to_dict()) + ">"


class BatchGetNotificationPoliciesResponse:
    """Batch get notification policies response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , notification_policies: List[NotificationPolicy] = []
    , **kwargs) -> BatchGetNotificationPoliciesResponse:
        self._attributes = dict()
        self.notification_policies = notification_policies

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def notification_policies(self) -> List[NotificationPolicy]:
        """Notification policies."""
        return self._attributes["notification_policies"]


    @notification_policies.setter
    def notification_policies(self, value: List[NotificationPolicy]) -> None:
        _set_attribute(self._attributes, "BatchGetNotificationPoliciesResponse", "notification_policies", value, List[NotificationPolicy], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetNotificationPoliciesResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetNotificationPoliciesResponse:
        """Convert object to proto representation."""
        return management_pb2.BatchGetNotificationPoliciesResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetNotificationPoliciesResponse object " + repr(self.to_dict()) + ">"


class ListNotificationPoliciesRequest:
    """List notification policies request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , start_time: datetime = None
        , end_time: datetime = None
        , order_by: str = ""
        , search: str = ""
    , **kwargs) -> ListNotificationPoliciesRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.start_time = start_time
        self.end_time = end_time
        self.order_by = order_by
        self.search = search

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListNotificationPoliciesRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListNotificationPoliciesRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListNotificationPoliciesRequest", "page_token", value, str, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListNotificationPoliciesRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListNotificationPoliciesRequest", "ignore_filters", value, List[str], "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListNotificationPoliciesRequest", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListNotificationPoliciesRequest", "end_time", value, datetime, "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListNotificationPoliciesRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListNotificationPoliciesRequest", "search", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListNotificationPoliciesRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListNotificationPoliciesRequest:
        """Convert object to proto representation."""
        return management_pb2.ListNotificationPoliciesRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListNotificationPoliciesRequest object " + repr(self.to_dict()) + ">"


class ListNotificationPoliciesResponse:
    """List notification policies response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , notification_policies: List[NotificationPolicy] = []
        , next_page_token: str = ""
    , **kwargs) -> ListNotificationPoliciesResponse:
        self._attributes = dict()
        self.notification_policies = notification_policies
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def notification_policies(self) -> List[NotificationPolicy]:
        """Notification policies."""
        return self._attributes["notification_policies"]


    @notification_policies.setter
    def notification_policies(self, value: List[NotificationPolicy]) -> None:
        _set_attribute(self._attributes, "ListNotificationPoliciesResponse", "notification_policies", value, List[NotificationPolicy], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListNotificationPoliciesResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListNotificationPoliciesResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListNotificationPoliciesResponse:
        """Convert object to proto representation."""
        return management_pb2.ListNotificationPoliciesResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListNotificationPoliciesResponse object " + repr(self.to_dict()) + ">"


class CreateNotificationPolicyRequest:
    """Create notification policy request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , notification_policy: NotificationPolicy = None
    , **kwargs) -> CreateNotificationPolicyRequest:
        self._attributes = dict()
        self.parent = parent
        self.notification_policy = notification_policy

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateNotificationPolicyRequest", "parent", value, str, "")


    @property
    def notification_policy(self) -> NotificationPolicy:
        """Notification policy."""
        return self._attributes["notification_policy"]


    @notification_policy.setter
    def notification_policy(self, value: NotificationPolicy) -> None:
        _set_attribute(self._attributes, "CreateNotificationPolicyRequest", "notification_policy", value, NotificationPolicy, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateNotificationPolicyRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateNotificationPolicyRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateNotificationPolicyRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateNotificationPolicyRequest object " + repr(self.to_dict()) + ">"


class UpdateNotificationPolicyRequest:
    """Update notification policy request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , notification_policy: NotificationPolicy = None
        , update_mask: protobuf.FieldMask = None
    , **kwargs) -> UpdateNotificationPolicyRequest:
        self._attributes = dict()
        self.notification_policy = notification_policy
        self.update_mask = update_mask

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def notification_policy(self) -> NotificationPolicy:
        """Notification policy."""
        return self._attributes["notification_policy"]


    @notification_policy.setter
    def notification_policy(self, value: NotificationPolicy) -> None:
        _set_attribute(self._attributes, "UpdateNotificationPolicyRequest", "notification_policy", value, NotificationPolicy, "")


    @property
    def update_mask(self) -> protobuf.FieldMask:
        """Update mask."""
        return self._attributes["update_mask"]


    @update_mask.setter
    def update_mask(self, value: protobuf.FieldMask) -> None:
        _set_attribute(self._attributes, "UpdateNotificationPolicyRequest", "update_mask", value, protobuf.FieldMask, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.UpdateNotificationPolicyRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.UpdateNotificationPolicyRequest:
        """Convert object to proto representation."""
        return management_pb2.UpdateNotificationPolicyRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<UpdateNotificationPolicyRequest object " + repr(self.to_dict()) + ">"


class DeleteNotificationPolicyRequest:
    """Delete notification policy request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> DeleteNotificationPolicyRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "DeleteNotificationPolicyRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.DeleteNotificationPolicyRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.DeleteNotificationPolicyRequest:
        """Convert object to proto representation."""
        return management_pb2.DeleteNotificationPolicyRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DeleteNotificationPolicyRequest object " + repr(self.to_dict()) + ">"


class GetTagRequest:
    """Tags"""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , key: str = ""
    , **kwargs) -> GetTagRequest:
        self._attributes = dict()
        self.parent = parent
        self.key = key

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "GetTagRequest", "parent", value, str, "")


    @property
    def key(self) -> str:
        """Key."""
        return self._attributes["key"]


    @key.setter
    def key(self, value: str) -> None:
        _set_attribute(self._attributes, "GetTagRequest", "key", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetTagRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetTagRequest:
        """Convert object to proto representation."""
        return management_pb2.GetTagRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetTagRequest object " + repr(self.to_dict()) + ">"


class BatchGetTagsRequest:
    """Batch get tags request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , names: List[str] = []
    , **kwargs) -> BatchGetTagsRequest:
        self._attributes = dict()
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BatchGetTagsRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetTagsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetTagsRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchGetTagsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetTagsRequest object " + repr(self.to_dict()) + ">"


class BatchGetTagsResponse:
    """Batch get tags response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , tags: List[Tag] = []
    , **kwargs) -> BatchGetTagsResponse:
        self._attributes = dict()
        self.tags = tags

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def tags(self) -> List[Tag]:
        """Tags."""
        return self._attributes["tags"]


    @tags.setter
    def tags(self, value: List[Tag]) -> None:
        _set_attribute(self._attributes, "BatchGetTagsResponse", "tags", value, List[Tag], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetTagsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetTagsResponse:
        """Convert object to proto representation."""
        return management_pb2.BatchGetTagsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetTagsResponse object " + repr(self.to_dict()) + ">"


class ListTagsRequest:
    """List tags request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , start_time: datetime = None
        , end_time: datetime = None
        , order_by: str = ""
        , search: str = ""
        , latest: bool = False
    , **kwargs) -> ListTagsRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.start_time = start_time
        self.end_time = end_time
        self.order_by = order_by
        self.search = search
        self.latest = latest

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListTagsRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListTagsRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListTagsRequest", "page_token", value, str, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListTagsRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListTagsRequest", "ignore_filters", value, List[str], "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListTagsRequest", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListTagsRequest", "end_time", value, datetime, "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListTagsRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListTagsRequest", "search", value, str, "")


    @property
    def latest(self) -> bool:
        """Latest."""
        return self._attributes["latest"]


    @latest.setter
    def latest(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListTagsRequest", "latest", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListTagsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListTagsRequest:
        """Convert object to proto representation."""
        return management_pb2.ListTagsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListTagsRequest object " + repr(self.to_dict()) + ">"


class ListTagsResponse:
    """List tags response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , tags: List[Tag] = []
        , next_page_token: str = ""
    , **kwargs) -> ListTagsResponse:
        self._attributes = dict()
        self.tags = tags
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def tags(self) -> List[Tag]:
        """Tags."""
        return self._attributes["tags"]


    @tags.setter
    def tags(self, value: List[Tag]) -> None:
        _set_attribute(self._attributes, "ListTagsResponse", "tags", value, List[Tag], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListTagsResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListTagsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListTagsResponse:
        """Convert object to proto representation."""
        return management_pb2.ListTagsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListTagsResponse object " + repr(self.to_dict()) + ">"


class CreateTagRequest:
    """Create tag request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , key: str = ""
        , value: str = ""
    , **kwargs) -> CreateTagRequest:
        self._attributes = dict()
        self.parent = parent
        self.key = key
        self.value = value

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateTagRequest", "parent", value, str, "")


    @property
    def key(self) -> str:
        """Key."""
        return self._attributes["key"]


    @key.setter
    def key(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateTagRequest", "key", value, str, "")


    @property
    def value(self) -> str:
        """Value."""
        return self._attributes["value"]


    @value.setter
    def value(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateTagRequest", "value", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateTagRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateTagRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateTagRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateTagRequest object " + repr(self.to_dict()) + ">"


class UpdateTagRequest:
    """Update tag request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , tag: Tag = None
        , update_mask: protobuf.FieldMask = None
    , **kwargs) -> UpdateTagRequest:
        self._attributes = dict()
        self.tag = tag
        self.update_mask = update_mask

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def tag(self) -> Tag:
        """Tag."""
        return self._attributes["tag"]


    @tag.setter
    def tag(self, value: Tag) -> None:
        _set_attribute(self._attributes, "UpdateTagRequest", "tag", value, Tag, "")


    @property
    def update_mask(self) -> protobuf.FieldMask:
        """Update mask."""
        return self._attributes["update_mask"]


    @update_mask.setter
    def update_mask(self, value: protobuf.FieldMask) -> None:
        _set_attribute(self._attributes, "UpdateTagRequest", "update_mask", value, protobuf.FieldMask, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.UpdateTagRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.UpdateTagRequest:
        """Convert object to proto representation."""
        return management_pb2.UpdateTagRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<UpdateTagRequest object " + repr(self.to_dict()) + ">"


class DeleteTagRequest:
    """Delete tag request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> DeleteTagRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "DeleteTagRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.DeleteTagRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.DeleteTagRequest:
        """Convert object to proto representation."""
        return management_pb2.DeleteTagRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DeleteTagRequest object " + repr(self.to_dict()) + ">"


class GetDataProfileRequest:
    """DataProfiles"""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetDataProfileRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetDataProfileRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetDataProfileRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetDataProfileRequest:
        """Convert object to proto representation."""
        return management_pb2.GetDataProfileRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetDataProfileRequest object " + repr(self.to_dict()) + ">"


class CreateDataProfileRequest:
    """Create data profile request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , data_profile: DataProfile = None
    , **kwargs) -> CreateDataProfileRequest:
        self._attributes = dict()
        self.parent = parent
        self.data_profile = data_profile

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateDataProfileRequest", "parent", value, str, "")


    @property
    def data_profile(self) -> DataProfile:
        """Data profile."""
        return self._attributes["data_profile"]


    @data_profile.setter
    def data_profile(self, value: DataProfile) -> None:
        _set_attribute(self._attributes, "CreateDataProfileRequest", "data_profile", value, DataProfile, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateDataProfileRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateDataProfileRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateDataProfileRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateDataProfileRequest object " + repr(self.to_dict()) + ">"


class ListDataProfilesRequest:
    """List data profiles request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , order_by: str = ""
        , search: str = ""
        , latest: bool = False
    , **kwargs) -> ListDataProfilesRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.order_by = order_by
        self.search = search
        self.latest = latest

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListDataProfilesRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListDataProfilesRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListDataProfilesRequest", "page_token", value, str, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListDataProfilesRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListDataProfilesRequest", "ignore_filters", value, List[str], "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListDataProfilesRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListDataProfilesRequest", "search", value, str, "")


    @property
    def latest(self) -> bool:
        """Latest."""
        return self._attributes["latest"]


    @latest.setter
    def latest(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListDataProfilesRequest", "latest", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListDataProfilesRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListDataProfilesRequest:
        """Convert object to proto representation."""
        return management_pb2.ListDataProfilesRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListDataProfilesRequest object " + repr(self.to_dict()) + ">"


class ListDataProfilesResponse:
    """List data profiles response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , data_profiles: List[DataProfile] = []
        , next_page_token: str = ""
    , **kwargs) -> ListDataProfilesResponse:
        self._attributes = dict()
        self.data_profiles = data_profiles
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def data_profiles(self) -> List[DataProfile]:
        """Data profiles."""
        return self._attributes["data_profiles"]


    @data_profiles.setter
    def data_profiles(self, value: List[DataProfile]) -> None:
        _set_attribute(self._attributes, "ListDataProfilesResponse", "data_profiles", value, List[DataProfile], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListDataProfilesResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListDataProfilesResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListDataProfilesResponse:
        """Convert object to proto representation."""
        return management_pb2.ListDataProfilesResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListDataProfilesResponse object " + repr(self.to_dict()) + ">"


class UpdateDataProfileRequest:
    """Update data profile request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , data_profile: DataProfile = None
        , update_paths: List[str] = []
    , **kwargs) -> UpdateDataProfileRequest:
        self._attributes = dict()
        self.data_profile = data_profile
        self.update_paths = update_paths

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def data_profile(self) -> DataProfile:
        """Data profile."""
        return self._attributes["data_profile"]


    @data_profile.setter
    def data_profile(self, value: DataProfile) -> None:
        _set_attribute(self._attributes, "UpdateDataProfileRequest", "data_profile", value, DataProfile, "")


    @property
    def update_paths(self) -> List[str]:
        """Update paths."""
        return self._attributes["update_paths"]


    @update_paths.setter
    def update_paths(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "UpdateDataProfileRequest", "update_paths", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.UpdateDataProfileRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.UpdateDataProfileRequest:
        """Convert object to proto representation."""
        return management_pb2.UpdateDataProfileRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<UpdateDataProfileRequest object " + repr(self.to_dict()) + ">"


class GetResourceCheckRequest:
    """Get resource check request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetResourceCheckRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetResourceCheckRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetResourceCheckRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetResourceCheckRequest:
        """Convert object to proto representation."""
        return management_pb2.GetResourceCheckRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetResourceCheckRequest object " + repr(self.to_dict()) + ">"


class ListResourceChecksRequest:
    """List resource checks request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , order_by: str = ""
        , search: str = ""
        , latest: bool = False
    , **kwargs) -> ListResourceChecksRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.order_by = order_by
        self.search = search
        self.latest = latest

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListResourceChecksRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListResourceChecksRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListResourceChecksRequest", "page_token", value, str, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListResourceChecksRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListResourceChecksRequest", "ignore_filters", value, List[str], "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListResourceChecksRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListResourceChecksRequest", "search", value, str, "")


    @property
    def latest(self) -> bool:
        """Latest."""
        return self._attributes["latest"]


    @latest.setter
    def latest(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListResourceChecksRequest", "latest", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListResourceChecksRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListResourceChecksRequest:
        """Convert object to proto representation."""
        return management_pb2.ListResourceChecksRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListResourceChecksRequest object " + repr(self.to_dict()) + ">"


class ListResourceChecksResponse:
    """List resource checks response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , resource_checks: List[ResourceCheck] = []
        , next_page_token: str = ""
    , **kwargs) -> ListResourceChecksResponse:
        self._attributes = dict()
        self.resource_checks = resource_checks
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def resource_checks(self) -> List[ResourceCheck]:
        """Resource checks."""
        return self._attributes["resource_checks"]


    @resource_checks.setter
    def resource_checks(self, value: List[ResourceCheck]) -> None:
        _set_attribute(self._attributes, "ListResourceChecksResponse", "resource_checks", value, List[ResourceCheck], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListResourceChecksResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListResourceChecksResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListResourceChecksResponse:
        """Convert object to proto representation."""
        return management_pb2.ListResourceChecksResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListResourceChecksResponse object " + repr(self.to_dict()) + ">"


class CreateResourceCheckRequest:
    """Create resource check request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , resource_check: ResourceCheck = None
    , **kwargs) -> CreateResourceCheckRequest:
        self._attributes = dict()
        self.parent = parent
        self.resource_check = resource_check

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateResourceCheckRequest", "parent", value, str, "")


    @property
    def resource_check(self) -> ResourceCheck:
        """Resource check."""
        return self._attributes["resource_check"]


    @resource_check.setter
    def resource_check(self, value: ResourceCheck) -> None:
        _set_attribute(self._attributes, "CreateResourceCheckRequest", "resource_check", value, ResourceCheck, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateResourceCheckRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateResourceCheckRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateResourceCheckRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateResourceCheckRequest object " + repr(self.to_dict()) + ">"


class CreateDatasetRequest:
    """Datasets"""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
        , description: str = ""
        , get_if_exists: bool = False
    , **kwargs) -> CreateDatasetRequest:
        self._attributes = dict()
        self.name = name
        self.description = description
        self.get_if_exists = get_if_exists

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateDatasetRequest", "name", value, str, "")


    @property
    def description(self) -> str:
        """Description."""
        return self._attributes["description"]


    @description.setter
    def description(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateDatasetRequest", "description", value, str, "")


    @property
    def get_if_exists(self) -> bool:
        """Get if exists."""
        return self._attributes["get_if_exists"]


    @get_if_exists.setter
    def get_if_exists(self, value: bool) -> None:
        _set_attribute(self._attributes, "CreateDatasetRequest", "get_if_exists", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateDatasetRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateDatasetRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateDatasetRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateDatasetRequest object " + repr(self.to_dict()) + ">"


class GetDatasetRequest:
    """Get dataset request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetDatasetRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetDatasetRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetDatasetRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetDatasetRequest:
        """Convert object to proto representation."""
        return management_pb2.GetDatasetRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetDatasetRequest object " + repr(self.to_dict()) + ">"


class BatchGetDatasetsRequest:
    """Batch get datasets request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , names: List[str] = []
    , **kwargs) -> BatchGetDatasetsRequest:
        self._attributes = dict()
        self.parent = parent
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchGetDatasetsRequest", "parent", value, str, "")


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BatchGetDatasetsRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetDatasetsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetDatasetsRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchGetDatasetsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetDatasetsRequest object " + repr(self.to_dict()) + ">"


class BatchGetDatasetsResponse:
    """Batch get datasets response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , datasets: List[Dataset] = []
    , **kwargs) -> BatchGetDatasetsResponse:
        self._attributes = dict()
        self.datasets = datasets

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def datasets(self) -> List[Dataset]:
        """Datasets."""
        return self._attributes["datasets"]


    @datasets.setter
    def datasets(self, value: List[Dataset]) -> None:
        _set_attribute(self._attributes, "BatchGetDatasetsResponse", "datasets", value, List[Dataset], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetDatasetsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetDatasetsResponse:
        """Convert object to proto representation."""
        return management_pb2.BatchGetDatasetsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetDatasetsResponse object " + repr(self.to_dict()) + ">"


class ListDatasetsRequest:
    """List datasets request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
        , latest: bool = False
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , start_time: datetime = None
        , end_time: datetime = None
        , all_projects: bool = False
        , order_by: str = ""
        , search: str = ""
    , **kwargs) -> ListDatasetsRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token
        self.latest = latest
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.start_time = start_time
        self.end_time = end_time
        self.all_projects = all_projects
        self.order_by = order_by
        self.search = search

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListDatasetsRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """Page size."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListDatasetsRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """Page token."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListDatasetsRequest", "page_token", value, str, "")


    @property
    def latest(self) -> bool:
        """Latest."""
        return self._attributes["latest"]


    @latest.setter
    def latest(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListDatasetsRequest", "latest", value, bool, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListDatasetsRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListDatasetsRequest", "ignore_filters", value, List[str], "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListDatasetsRequest", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListDatasetsRequest", "end_time", value, datetime, "")


    @property
    def all_projects(self) -> bool:
        """All projects."""
        return self._attributes["all_projects"]


    @all_projects.setter
    def all_projects(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListDatasetsRequest", "all_projects", value, bool, "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListDatasetsRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListDatasetsRequest", "search", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListDatasetsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListDatasetsRequest:
        """Convert object to proto representation."""
        return management_pb2.ListDatasetsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListDatasetsRequest object " + repr(self.to_dict()) + ">"


class ListDatasetsResponse:
    """List datasets response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , datasets: List[Dataset] = []
        , next_page_token: str = ""
    , **kwargs) -> ListDatasetsResponse:
        self._attributes = dict()
        self.datasets = datasets
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def datasets(self) -> List[Dataset]:
        """Datasets."""
        return self._attributes["datasets"]


    @datasets.setter
    def datasets(self, value: List[Dataset]) -> None:
        _set_attribute(self._attributes, "ListDatasetsResponse", "datasets", value, List[Dataset], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListDatasetsResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListDatasetsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListDatasetsResponse:
        """Convert object to proto representation."""
        return management_pb2.ListDatasetsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListDatasetsResponse object " + repr(self.to_dict()) + ">"


class DeleteDatasetRequest:
    """Delete dataset request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> DeleteDatasetRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "DeleteDatasetRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.DeleteDatasetRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.DeleteDatasetRequest:
        """Convert object to proto representation."""
        return management_pb2.DeleteDatasetRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DeleteDatasetRequest object " + repr(self.to_dict()) + ">"


class CreateDatasetVersionRequest:
    """DatasetVersions"""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , run_name: str = ""
    , **kwargs) -> CreateDatasetVersionRequest:
        self._attributes = dict()
        self.parent = parent
        self.run_name = run_name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateDatasetVersionRequest", "parent", value, str, "")


    @property
    def run_name(self) -> str:
        """Run name."""
        return self._attributes["run_name"]


    @run_name.setter
    def run_name(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateDatasetVersionRequest", "run_name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateDatasetVersionRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateDatasetVersionRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateDatasetVersionRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateDatasetVersionRequest object " + repr(self.to_dict()) + ">"


class GetDatasetVersionRequest:
    """Get dataset version request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetDatasetVersionRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetDatasetVersionRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetDatasetVersionRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetDatasetVersionRequest:
        """Convert object to proto representation."""
        return management_pb2.GetDatasetVersionRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetDatasetVersionRequest object " + repr(self.to_dict()) + ">"


class BatchGetDatasetVersionsRequest:
    """Batch get dataset versions request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , names: List[str] = []
    , **kwargs) -> BatchGetDatasetVersionsRequest:
        self._attributes = dict()
        self.parent = parent
        self.names = names

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "BatchGetDatasetVersionsRequest", "parent", value, str, "")


    @property
    def names(self) -> List[str]:
        """Names."""
        return self._attributes["names"]


    @names.setter
    def names(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "BatchGetDatasetVersionsRequest", "names", value, List[str], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetDatasetVersionsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetDatasetVersionsRequest:
        """Convert object to proto representation."""
        return management_pb2.BatchGetDatasetVersionsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetDatasetVersionsRequest object " + repr(self.to_dict()) + ">"


class BatchGetDatasetVersionsResponse:
    """Batch get dataset versions response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , dataset_versions: List[DatasetVersion] = []
    , **kwargs) -> BatchGetDatasetVersionsResponse:
        self._attributes = dict()
        self.dataset_versions = dataset_versions

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def dataset_versions(self) -> List[DatasetVersion]:
        """Dataset versions."""
        return self._attributes["dataset_versions"]


    @dataset_versions.setter
    def dataset_versions(self, value: List[DatasetVersion]) -> None:
        _set_attribute(self._attributes, "BatchGetDatasetVersionsResponse", "dataset_versions", value, List[DatasetVersion], "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.BatchGetDatasetVersionsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.BatchGetDatasetVersionsResponse:
        """Convert object to proto representation."""
        return management_pb2.BatchGetDatasetVersionsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<BatchGetDatasetVersionsResponse object " + repr(self.to_dict()) + ">"


class ListDatasetVersionsRequest:
    """List dataset versions request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
        , latest: bool = False
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , start_time: datetime = None
        , end_time: datetime = None
        , all_projects: bool = False
        , order_by: str = ""
        , search: str = ""
    , **kwargs) -> ListDatasetVersionsRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token
        self.latest = latest
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.start_time = start_time
        self.end_time = end_time
        self.all_projects = all_projects
        self.order_by = order_by
        self.search = search

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionsRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """The maximum number of items to return."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionsRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """The next_page_token value returned from a previous List request, if any."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionsRequest", "page_token", value, str, "")


    @property
    def latest(self) -> bool:
        """Get the latest dataset versions first."""
        return self._attributes["latest"]


    @latest.setter
    def latest(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionsRequest", "latest", value, bool, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionsRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionsRequest", "ignore_filters", value, List[str], "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionsRequest", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionsRequest", "end_time", value, datetime, "")


    @property
    def all_projects(self) -> bool:
        """All projects."""
        return self._attributes["all_projects"]


    @all_projects.setter
    def all_projects(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionsRequest", "all_projects", value, bool, "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionsRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionsRequest", "search", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListDatasetVersionsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListDatasetVersionsRequest:
        """Convert object to proto representation."""
        return management_pb2.ListDatasetVersionsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListDatasetVersionsRequest object " + repr(self.to_dict()) + ">"


class ListDatasetVersionsResponse:
    """List dataset versions response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , dataset_versions: List[DatasetVersion] = []
        , next_page_token: str = ""
    , **kwargs) -> ListDatasetVersionsResponse:
        self._attributes = dict()
        self.dataset_versions = dataset_versions
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def dataset_versions(self) -> List[DatasetVersion]:
        """Dataset versions."""
        return self._attributes["dataset_versions"]


    @dataset_versions.setter
    def dataset_versions(self, value: List[DatasetVersion]) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionsResponse", "dataset_versions", value, List[DatasetVersion], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionsResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListDatasetVersionsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListDatasetVersionsResponse:
        """Convert object to proto representation."""
        return management_pb2.ListDatasetVersionsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListDatasetVersionsResponse object " + repr(self.to_dict()) + ">"


class CreateDatasetVersionAssignmentRequest:
    """Create dataset version assignment request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , dataset_version_name: str = ""
        , resource_name: str = ""
    , **kwargs) -> CreateDatasetVersionAssignmentRequest:
        self._attributes = dict()
        self.dataset_version_name = dataset_version_name
        self.resource_name = resource_name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def dataset_version_name(self) -> str:
        """Dataset version name."""
        return self._attributes["dataset_version_name"]


    @dataset_version_name.setter
    def dataset_version_name(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateDatasetVersionAssignmentRequest", "dataset_version_name", value, str, "")


    @property
    def resource_name(self) -> str:
        """Resource name."""
        return self._attributes["resource_name"]


    @resource_name.setter
    def resource_name(self, value: str) -> None:
        _set_attribute(self._attributes, "CreateDatasetVersionAssignmentRequest", "resource_name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.CreateDatasetVersionAssignmentRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.CreateDatasetVersionAssignmentRequest:
        """Convert object to proto representation."""
        return management_pb2.CreateDatasetVersionAssignmentRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<CreateDatasetVersionAssignmentRequest object " + repr(self.to_dict()) + ">"


class GetDatasetVersionAssignmentRequest:
    """Get dataset version assignment request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> GetDatasetVersionAssignmentRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "GetDatasetVersionAssignmentRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetDatasetVersionAssignmentRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetDatasetVersionAssignmentRequest:
        """Convert object to proto representation."""
        return management_pb2.GetDatasetVersionAssignmentRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetDatasetVersionAssignmentRequest object " + repr(self.to_dict()) + ">"


class DeleteDatasetVersionAssignmentRequest:
    """Delete dataset version assignment request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , name: str = ""
    , **kwargs) -> DeleteDatasetVersionAssignmentRequest:
        self._attributes = dict()
        self.name = name

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def name(self) -> str:
        """Name."""
        return self._attributes["name"]


    @name.setter
    def name(self, value: str) -> None:
        _set_attribute(self._attributes, "DeleteDatasetVersionAssignmentRequest", "name", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.DeleteDatasetVersionAssignmentRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.DeleteDatasetVersionAssignmentRequest:
        """Convert object to proto representation."""
        return management_pb2.DeleteDatasetVersionAssignmentRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<DeleteDatasetVersionAssignmentRequest object " + repr(self.to_dict()) + ">"


class ListDatasetVersionAssignmentsRequest:
    """List dataset version assignments request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , parent: str = ""
        , page_size: int = 0
        , page_token: str = ""
        , latest: bool = False
        , filters: List[str] = []
        , ignore_filters: List[str] = []
        , start_time: datetime = None
        , end_time: datetime = None
        , all_projects: bool = False
        , order_by: str = ""
        , search: str = ""
    , **kwargs) -> ListDatasetVersionAssignmentsRequest:
        self._attributes = dict()
        self.parent = parent
        self.page_size = page_size
        self.page_token = page_token
        self.latest = latest
        self.filters = filters
        self.ignore_filters = ignore_filters
        self.start_time = start_time
        self.end_time = end_time
        self.all_projects = all_projects
        self.order_by = order_by
        self.search = search

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def parent(self) -> str:
        """Parent."""
        return self._attributes["parent"]


    @parent.setter
    def parent(self, value: str) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionAssignmentsRequest", "parent", value, str, "")


    @property
    def page_size(self) -> int:
        """The maximum number of items to return."""
        return self._attributes["page_size"]


    @page_size.setter
    def page_size(self, value: int) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionAssignmentsRequest", "page_size", value, int, "")


    @property
    def page_token(self) -> str:
        """The next_page_token value returned from a previous List request, if any."""
        return self._attributes["page_token"]


    @page_token.setter
    def page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionAssignmentsRequest", "page_token", value, str, "")


    @property
    def latest(self) -> bool:
        """Get the latest dataset versions first."""
        return self._attributes["latest"]


    @latest.setter
    def latest(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionAssignmentsRequest", "latest", value, bool, "")


    @property
    def filters(self) -> List[str]:
        """Filters."""
        return self._attributes["filters"]


    @filters.setter
    def filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionAssignmentsRequest", "filters", value, List[str], "")


    @property
    def ignore_filters(self) -> List[str]:
        """Ignore filters."""
        return self._attributes["ignore_filters"]


    @ignore_filters.setter
    def ignore_filters(self, value: List[str]) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionAssignmentsRequest", "ignore_filters", value, List[str], "")


    @property
    def start_time(self) -> datetime:
        """Start time."""
        return self._attributes["start_time"]


    @start_time.setter
    def start_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionAssignmentsRequest", "start_time", value, datetime, "")


    @property
    def end_time(self) -> datetime:
        """End time."""
        return self._attributes["end_time"]


    @end_time.setter
    def end_time(self, value: datetime) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionAssignmentsRequest", "end_time", value, datetime, "")


    @property
    def all_projects(self) -> bool:
        """All projects."""
        return self._attributes["all_projects"]


    @all_projects.setter
    def all_projects(self, value: bool) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionAssignmentsRequest", "all_projects", value, bool, "")


    @property
    def order_by(self) -> str:
        """Order by."""
        return self._attributes["order_by"]


    @order_by.setter
    def order_by(self, value: str) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionAssignmentsRequest", "order_by", value, str, "")


    @property
    def search(self) -> str:
        """Search."""
        return self._attributes["search"]


    @search.setter
    def search(self, value: str) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionAssignmentsRequest", "search", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListDatasetVersionAssignmentsRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListDatasetVersionAssignmentsRequest:
        """Convert object to proto representation."""
        return management_pb2.ListDatasetVersionAssignmentsRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListDatasetVersionAssignmentsRequest object " + repr(self.to_dict()) + ">"


class ListDatasetVersionAssignmentsResponse:
    """List dataset version assignments response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , assignments: List[DatasetVersionAssignment] = []
        , next_page_token: str = ""
    , **kwargs) -> ListDatasetVersionAssignmentsResponse:
        self._attributes = dict()
        self.assignments = assignments
        self.next_page_token = next_page_token

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def assignments(self) -> List[DatasetVersionAssignment]:
        """Assignments."""
        return self._attributes["assignments"]


    @assignments.setter
    def assignments(self, value: List[DatasetVersionAssignment]) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionAssignmentsResponse", "assignments", value, List[DatasetVersionAssignment], "")


    @property
    def next_page_token(self) -> str:
        """Next page token."""
        return self._attributes["next_page_token"]


    @next_page_token.setter
    def next_page_token(self, value: str) -> None:
        _set_attribute(self._attributes, "ListDatasetVersionAssignmentsResponse", "next_page_token", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.ListDatasetVersionAssignmentsResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.ListDatasetVersionAssignmentsResponse:
        """Convert object to proto representation."""
        return management_pb2.ListDatasetVersionAssignmentsResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<ListDatasetVersionAssignmentsResponse object " + repr(self.to_dict()) + ">"


class GetServerVersionRequest:
    """Get server version request."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , client_version: str = ""
    , **kwargs) -> GetServerVersionRequest:
        self._attributes = dict()
        self.client_version = client_version

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def client_version(self) -> str:
        """Client version."""
        return self._attributes["client_version"]


    @client_version.setter
    def client_version(self, value: str) -> None:
        _set_attribute(self._attributes, "GetServerVersionRequest", "client_version", value, str, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetServerVersionRequest, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetServerVersionRequest:
        """Convert object to proto representation."""
        return management_pb2.GetServerVersionRequest(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetServerVersionRequest object " + repr(self.to_dict()) + ">"


class GetServerVersionResponse:
    """Get server version response."""

    _attributes: dict
    _client: Any = None
    
    def __init__(self
        , server_version: str = ""
        , upgrade_required: bool = False
    , **kwargs) -> GetServerVersionResponse:
        self._attributes = dict()
        self.server_version = server_version
        self.upgrade_required = upgrade_required

        if "client" in kwargs:
            self._client = kwargs["client"]
        if "parent_run" in kwargs:
            self._parent_run = kwargs["parent_run"]
        if hasattr(self, "_init"):
            self._init()


    @property
    def server_version(self) -> str:
        """Server version."""
        return self._attributes["server_version"]


    @server_version.setter
    def server_version(self, value: str) -> None:
        _set_attribute(self._attributes, "GetServerVersionResponse", "server_version", value, str, "")


    @property
    def upgrade_required(self) -> bool:
        """Upgrade required."""
        return self._attributes["upgrade_required"]


    @upgrade_required.setter
    def upgrade_required(self, value: bool) -> None:
        _set_attribute(self._attributes, "GetServerVersionResponse", "upgrade_required", value, bool, "")


    @classmethod
    def from_proto(cls: Type[T], proto: management_pb2.GetServerVersionResponse, **kwargs) -> T:
        """Convert object from proto representation."""
        return cls(**MessageToDict(proto, preserving_proto_field_name=True), **kwargs)

    def to_proto(self) -> management_pb2.GetServerVersionResponse:
        """Convert object to proto representation."""
        return management_pb2.GetServerVersionResponse(**_to_proto_dict(self._attributes))

    def to_dict(self) -> dict:
        """Convert object to plain python dictionary representation."""
        return MessageToDict(
            self.to_proto(), 
            including_default_value_fields=True, 
            preserving_proto_field_name=True,
        )
    
    def __repr__(self) -> str:
        return "<GetServerVersionResponse object " + repr(self.to_dict()) + ">"
