"""
Definition for all enneoxOS senosrs
"""

from .const import Identifier, SMATagList
from .sensor import Sensor

DEFAULT_TIMEOUT = 8

""" The profiles are necessary because the devices generally
    return a significantly lower number of measured values without sunlight. """
ennexosSensorProfiles: list[tuple[list[int], list[str]]] = [
    (
        [9492, 9491, 9489, 9488],  # Tripower X
        [
            "Coolsys.Inverter.TmpVal.1",
            "Coolsys.Inverter.TmpVal.2",
            "Coolsys.Inverter.TmpVal.3",
            "DcMs.Amp.1",
            "DcMs.Amp.2",
            "DcMs.Amp.3",
            "DcMs.TotDcEnCntWh.1",
            "DcMs.TotDcEnCntWh.2",
            "DcMs.TotDcEnCntWh.3",
            "DcMs.Vol.1",
            "DcMs.Vol.2",
            "DcMs.Vol.3",
            "DcMs.Watt.1",
            "DcMs.Watt.2",
            "DcMs.Watt.3",
            "GridGuard.Cntry",
            "GridMs.A.phsA",
            "GridMs.A.phsB",
            "GridMs.A.phsC",
            "GridMs.GriTyp",
            "GridMs.Hz",
            "GridMs.PhV.phsA",
            "GridMs.PhV.phsA2B",
            "GridMs.PhV.phsB",
            "GridMs.PhV.phsB2C",
            "GridMs.PhV.phsC",
            "GridMs.PhV.phsC2A",
            "GridMs.TotA",
            "GridMs.TotPFEEI",
            "GridMs.TotPFExt",
            "GridMs.TotPFPrc",
            "GridMs.TotVA",
            "GridMs.TotVAr",
            "GridMs.TotW",
            "GridMs.TotW.Pv",
            "GridMs.VA.phsA",
            "GridMs.VA.phsB",
            "GridMs.VA.phsC",
            "GridMs.VAr.phsA",
            "GridMs.VAr.phsB",
            "GridMs.VAr.phsC",
            "GridMs.W.phsA",
            "GridMs.W.phsB",
            "GridMs.W.phsC",
            "InOut.GI1",  # codespell:ignore
            "Inverter.VArModCfg.PFCtlVolCfg.Stt",
            "Isolation.FltA",
            "Isolation.LeakRis",
            "Metering.TotFeedTms",
            "Metering.TotOpTms",
            "Metering.TotWhOut",
            "Metering.TotWhOut.Pv",
            "Operation.BckStt",
            "Operation.DrtStt",
            "Operation.Evt.Dsc",
            "Operation.Evt.EvtNo",
            "Operation.Evt.Msg",
            "Operation.EvtCntIstl",
            "Operation.EvtCntUsr",
            "Operation.GriSwCnt",
            "Operation.GriSwStt",
            "Operation.Health",
            "Operation.HealthStt.Alm",
            "Operation.HealthStt.Ok",
            "Operation.HealthStt.Wrn",
            "Operation.OpStt",
            "Operation.PvGriConn",
            "Operation.RstrLokStt",
            "Operation.RunStt",
            "Operation.StandbyStt",
            "Operation.VArCtl.VArModAct",
            "Operation.VArCtl.VArModStt",
            "Operation.WMaxLimSrc",
            "Operation.WMinLimSrc",
            "PvGen.PvW",
            "PvGen.PvWh",
            "Spdwr.ComSocA.Stt",
            "SunSpecSig.SunSpecTx.1",
            "Upd.Stt",
            "WebConn.Stt",
            "Wl.AcqStt",
            "Wl.AntMod",
            "Wl.ConnStt",
            "Wl.SigPwr",
            "Wl.SoftAcsConnStt",
            "Setpoint.PlantControl.InOut.GO1",  # codespell:ignore
            "Inverter.WMax",
        ],
    ),
    (
        [9483, 9484],  # Charger
        [
            "ChaSess.WhIn",
            "Chrg.ModSw",
            "GridMs.A.phsA",
            "GridMs.A.phsB",
            "GridMs.A.phsC",
            "GridMs.Hz",
            "GridMs.PhV.phsA",
            "GridMs.PhV.phsB",
            "GridMs.PhV.phsC",
            "GridMs.TotPF",
            "GridMs.TotVA",
            "GridMs.TotVAr",
            "InOut.GI1",  # codespell:ignore
            "Metering.GridMs.TotWIn",
            "Metering.GridMs.TotWIn.ChaSta",
            "Metering.GridMs.TotWhIn",
            "Metering.GridMs.TotWhIn.ChaSta",
            "Operation.EVeh.ChaStt",
            "Operation.EVeh.Health",
            "Operation.Evt.Msg",
            "Operation.Health",
            "Operation.WMaxLimNom",
            "Operation.WMaxLimSrc",
            "Wl.AcqStt",
            "Wl.ConnStt",
            "Wl.SigPwr",
            "Wl.SoftAcsConnStt",
        ],
    ),
    (
        [19085, 19128, 19129, 19130],  # Sunny Boy Smart Energy 3.6, 4.0, 5.0, 6.0
        [
            "Operation.Bat.Health.1",
            "Coolsys.Inverter.TmpVal.1",
            "DcMs.Amp.1",
            "DcMs.Amp.2",
            "DcMs.Amp.3",
            "DcMs.TotDcEnCntWh.1",
            "DcMs.TotDcEnCntWh.2",
            "DcMs.TotDcEnCntWh.3",
            "DcMs.Vol.1",
            "DcMs.Vol.2",
            "DcMs.Vol.3",
            "DcMs.Watt.1",
            "DcMs.Watt.2",
            "DcMs.Watt.3",
            "GridGuard.Cntry",
            "GridMs.A.phsA",
            "GridMs.A.phsA",
            "GridMs.GriTyp",
            "GridMs.Hz",
            "GridMs.PhV.phsA2B",
            "GridMs.PhV.phsA",
            "GridMs.TotA",
            "GridMs.TotPFEEI",
            "GridMs.TotPFExt",
            "GridMs.TotPFPrc",
            "GridMs.TotVA",
            "GridMs.TotVAr",
            "GridMs.TotW",
            "GridMs.TotW.Pv",
            "GridMs.VA.phsA",
            "GridMs.VAr.phsA",
            "GridMs.W.phsA",
            "InOut.GI1",  # codespell:ignore
            "Inverter.VArModCfg.PFCtlVolCfg.Stt",
            "Isolation.FltA",
            "Isolation.LeakRis",
            "Metering.GridMs.TotWhIn.ChaSta",
            "Metering.GridMs.TotWhIn",
            "Metering.GridMs.TotWIn.ChaSta",
            "Metering.GridMs.TotWIn",
            "Metering.TotFeedTms",
            "Metering.TotOpTms",
            "Metering.TotWhOut",
            "Metering.TotWhOut.Pv",
            "Operation.BckStt",
            "Operation.DrtStt",
            "Operation.EvtCntIstl",
            "Operation.EvtCntUsr",
            "Operation.Evt.Dsc",
            "Operation.Evt.Msg",
            "Operation.GriSwCnt",
            "Operation.GriSwStt",
            "Operation.Health",
            "Operation.HealthStt.Alm",
            "Operation.HealthStt.Ok",
            "Operation.HealthStt.Wrn",
            "Operation.OpStt",
            "Operation.PvGriConn",
            "Operation.RstrLokStt",
            "Operation.RunStt",
            "Operation.StandbyStt",
            "Operation.VArCtl.VArModAct",
            "Operation.WMaxLimSrc",
            "PvGen.PvWh",
            "PvGen.PvW",
            "Setpoint.PlantControl.InOut.GO1",  # codespell:ignore
            "Spdwr.ComSocA.Stt",
            "SunSpecSig.SunSpecTx.1",
            "Upd.Stt",
            "WebConn.Stt",
            "Wl.AcqStt",
            "Wl.AntMod",
            "Wl.ConnStt",
            "Wl.SigPwr",
            "Wl.SoftAcsConnStt",
            "Bat.Amp.1",
            "Bat.ChaStt",
            "Bat.ChaSttArr.1",
            "Bat.Diag.VolMax.1",
            "Bat.OpTms.1",
            "Bat.Vol.1",
            "BatChrg.BatChrg",
            "BatChrg.BatChrgArr.1",
            "BatChrg.CurBatCha",
            "BatChrg.CurBatChaArr.1",
            "BatDsch.BatDsch",
            "BatDsch.BatDschArr.1",
            "BatDsch.CurBatDsch",
            "BatDsch.CurBatDschArr.1",
            "DcMs.TotDcEnCntWh.1",
            "DcMs.TotDcEnCntWh.2",
            "DcMs.TotDcEnCntWh.3",
            "EpsMs.Amp",
            "EpsMs.Vol",
            "EpsMs.Watt",
            "GridGuard.Cntry",
            "GridMs.GriTyp",
            "GridMs.TotPFEEI",
            "GridMs.TotPFExt",
            "GridMs.TotPFPrc",
            "InOut.GI1",  # codespell:ignore
            "InOut.GO1",  # codespell:ignore
            "Inverter.VArModCfg.PFCtlVolCfg.Stt",
            "Isolation.LeakRis",
            "Metering.GridMs.TotWhIn.Bat",
            "Metering.GridMs.TotWhOut.Bat",
            "Metering.TotFeedTms",
            "Metering.TotOpTms",
            "Metering.TotWhIn",
            "Operation.Bat.Health",
            "Operation.BckStt",
            "Operation.DrtStt",
            "Operation.Evt.Dsc",
            "Operation.Evt.Msg",
            "Operation.EvtCntIstl",
            "Operation.EvtCntUsr",
            "Operation.GriSwCnt",
            "Operation.HealthStt.Alm",
            "Operation.HealthStt.Ok",
            "Operation.HealthStt.Wrn",
            "Operation.PvGriConn",
            "Operation.RstrLokStt",
            "Operation.RunStt",
            "Operation.StandbyStt",
            "Operation.VArCtl.VArModAct",
            "Operation.VArCtl.VArModStt",
            "Operation.WMaxLimSrc",
            "Operation.WMinLimSrc",
            "Portal.EnnexOS.ConnStt",
            "PvGen.PvW",
            "PvGen.PvWh",
            "Spdwr.ComSocA.Stt",
            "SunSpecSig.SunSpecTx.1",
            "Upd.Stt",
            "WebConn.Stt",
            "Wl.AcqStt",
            "Wl.AntMod",
            "Wl.ConnStt",
            "Wl.SigPwr",
            "Wl.SoftAcsConnStt",
            "Setpoint.PlantControl.CmpBMS.OpMod.1",
            "Metering.GridMs.TotWhIn.Bat",
            "Metering.GridMs.TotWhOut.Bat",
            "Inverter.WMax",
            "Bat.TmpVal.1",
        ],
    ),
    (
        [9397],  # Data Manager EDMM-10
        [
            "Operation.Health",
            "DevUpd.IsOn",
            "FTPPush.IsOn",
            "FTPPush.Login",
            "FTPPush.Port",
            "FTPPush.Pwd",
            "FTPPush.RemStoLcn",
            "FTPPush.Srv",
            "FTPPush.UpldCyc",
            "InOut.GI1",  # codespell:ignore
            "Nameplate.CmpMain.HwRev",
            "Nameplate.CmpMain.Rev",
            "Nameplate.CmpOS.SwRev",
            "Nameplate.Location",
            "Nameplate.MainModel",
            "Nameplate.Model",
            "Nameplate.ModelStr",
            "Nameplate.PkgRev",
            "Nameplate.SerNum",
            "Nameplate.Vendor",
            "Portal.EnnexOS.ConnStt",
            "Spdwr.ActlDnsSrvIp",
            "Spdwr.ActlGwIp",
            "Spdwr.ActlIp",
            "Spdwr.ActlSnetMsk",
            "Spdwr.AutoCfgIsOn",
            "Spdwr.IgmpQryTms",
            "Spdwr.IgmpQryTx",
            "SwCmp.CmpEnnexOS.Frwk.SwRev",
            "Sys.DevRstr",
            "Upd.AutoUpdIsOn",
            "WebConn.IsOn",
            "WebConn.Stt",
            "WebConn.SwRev",
        ],
    ),
    (
        [9307],  # Energy Meter
        [
            "Metering.GridMs.TotWIn",
            "Metering.GridMs.TotWhIn",
            "Metering.GridMs.TotWOut",
            "Metering.GridMs.TotWhOut",
            "Metering.GridMs.A.phsA",
            "Metering.GridMs.A.phsB",
            "Metering.GridMs.A.phsC",
            "Metering.GridMs.Hz",
            "Metering.GridMs.PhV.phsA",
            "Metering.GridMs.PhV.phsB",
            "Metering.GridMs.PhV.phsC",
            "Metering.GridMs.TotPF",
            "Metering.GridMs.W.phsA",
            "Metering.GridMs.W.phsB",
            "Metering.GridMs.W.phsC",
            "Operation.Health",
            "Metering.GridMs.VA.phsA",
            "Metering.GridMs.VA.phsB",
            "Metering.GridMs.VA.phsC",
            "Metering.GridMs.VAr.phsA",
            "Metering.GridMs.VAr.phsB",
            "Metering.GridMs.VAr.phsC",
        ],
    ),
    (
        [9054],  # SMC 7000TL via DataManager
        [
            "Coolsys.Inverter.TmpVal",
            "DcMs.Amp.1",
            "DcMs.Vol.1",
            "DcMs.Watt.1",
            "GridMs.A.phsA",
            "GridMs.A.phsB",
            "GridMs.A.phsC",
            "GridMs.Hz",
            "GridMs.PhV.phsA",
            "GridMs.PhV.phsB",
            "GridMs.PhV.phsC",
            "GridMs.TotW",
            "GridMs.TotW.Pv",
            "Isolation.FltA",
            "Isolation.LeakRis",
            "Metering.TotFeedTms",
            "Metering.TotOpTms",
            "Metering.TotWhOut.Pv",
            "Operation.GriSwCnt",
            "Operation.Health",
            "Setpoint.PlantControl.Inverter.FstStop",
            "Setpoint.PlantControl.Inverter.WModCfg.WCtlComCfg.WNom",
            "GridGuard.Cntry.FrqCtl.hLim",
            "Metering.TotkWhOutSet",
            "GridGuard.Cntry.FrqCtl.Max",
            "Nameplate.CmpMain.SwRev",
            "Metering.TotFeedTmhSet",
            "GridGuard.Cntry.VolCtl.Rpro",
            "Nameplate.CmpCom.SwRev",
            "GridGuard.Cntry.Aid.PerAid.Ampl",
            "GridGuard.Cntry.VRefOfs",
            "Inverter.OffGri.HzdLim",
            "Inverter.StopTms",
            "DcCfg.StrTms",
            "GridGuard.Cntry.FrqCtl.hLimTmms",
            "Inverter.OffGri.HzdStr",
            "GridGuard.Cntry.Aid.PerAid.Hz",
            "GridGuard.Cntry.VolCtl.lLim",
            "Nameplate.Model",
            "GridGuard.CntrySet",
            "Inverter.WLim",
            "Coolsys.FanTst",
            "Operation.OpMod",
            "GridGuard.Cntry.VolCtl.llLimTmms",
            "GridGuard.Cntry.VolCtl.hhLim",
            "GridGuard.Cntry.VolCtl.llLim",
            "Nameplate.Location",
            "GridGuard.Cntry.VolCtl.hhLimTmms",
            "GridGuard.Cntry.FrqCtl.MaxTmms",
            "GridGuard.Cntry.VolCtl.hLimTmms",
            "GridGuard.Cntry.VolCtl.lLimTmms",
            "Inverter.OutPhs",
            "Inverter.WMax",
            "GridGuard.Cntry.FrqCtl.Min",
            "Nameplate.MainModel",
            "DcCfg.StrVol",
            "GridGuard.Cntry.FrqCtl.lLim",
            "GridGuard.Cntry.FrqCtl.lLimTmms",
            "Nameplate.Vendor",
            "DcCfg.ConstVolCtl.Vset",
            "GridGuard.Cntry.FrqCtl.ChgMax",
            "GridGuard.Cntry.VolCtl.hLim",
            "GridGuard.Cntry.Aid.AngFact",
            "GridGuard.Cntry.GridGuardRev",
            "GridGuard.Cntry.FrqCtl.MinTmms",
            "Operation.PwrBal.OpMod",
            "Operation.ValRsIstl",
            "Nameplate.SerNum",
            "GridGuard.Cntry.AMaxOfs",
            "GridGuard.Cntry.LeakRisMin",
        ],
    ),
    (
        [8001],  # SMC 9000TL-10 via DataManager
        [
            "Coolsys.Inverter.TmpVal",
            "DcMs.Amp.1",
            "DcMs.Vol.1",
            "DcMs.Watt.1",
            "DcMs.Amp.2",
            "DcMs.Vol.2",
            "DcMs.Watt.2",
            "GridGuard.Cntry",
            "GridMs.A.phsA",
            "GridMs.A.phsB",
            "GridMs.A.phsC",
            "GridMs.Hz",
            "GridMs.PhV.phsA",
            "GridMs.PhV.phsB",
            "GridMs.PhV.phsC",
            "GridMs.TotVA",
            "GridMs.TotVAr",
            "GridMs.TotVAr.Pv",
            "GridMs.TotW",
            "GridMs.TotW.Pv",
            "GridMs.W.phsA",
            "GridMs.W.phsB",
            "GridMs.W.phsC",
            "Isolation.FltA",
            "Isolation.LeakRis",
            "Metering.TotFeedTms",
            "Metering.TotOpTms",
            "Metering.TotWhOut.Pv",
            "Operation.DrtStt",
            "Operation.Evt.EvtNo",
            "Operation.Evt.EvtNoShrt",
            "Operation.Evt.Prio",
            "Operation.EvtCntIstl",
            "Operation.EvtCntUsr",
            "Operation.GriSwCnt",
            "Operation.GriSwStt",
            "Operation.Health",
            "Operation.RmgTms",
            "Setpoint.PlantControl.Inverter.FstStop",
            "Setpoint.PlantControl.Inverter.WModCfg.WCtlComCfg.WNom",
            "Nameplate.CmpMdul.Rev",
            "Metering.TotkWhOutSet",
            "DcCfg.VolLim[]",
            "Metering.TotFeedTmhSet",
            "Nameplate.CmpMain.SwRev",
            "GridGuard.Cntry.VolCtl.Max",
            "Nameplate.CmpMain.HwRev",
            "GridGuard.Cntry.VolCtl.Rpro",
            "Nameplate.CmpRS485.HwRev",
            "Nameplate.CmpCom.Rev",
            "DcCfg.MPPShdw.IsOn",
            "Inverter.OffGri.HzdLim",
            "GridGuard.Cntry.FrqCtl.hLimTmms",
            "DcCfg.StrTms[]",
            "Bt.BtPwr",
            "Nameplate.Model",
            "GridGuard.CntrySet",
            "Inverter.WLim",
            "Coolsys.FanTst",
            "Operation.OpMod",
            "GridGuard.Cntry.PEOpnMon",
            "Nameplate.CmpRS485.SwRev",
            "GridGuard.Cntry.AMaxOfsTmms",
            "GridGuard.Cntry.VolCtl.hhLim",
            "Nameplate.CmpFltASw.Rev",
            "Inverter.WMaxTm",
            "GridGuard.Cntry.VolCtl.llLim",
            "Nameplate.Location",
            "GridGuard.Cntry.VolCtl.hLimTmms",
            "Nameplate.CmpSigProc.Rev",
            "GridGuard.Cntry.VolCtl.lLimTmms",
            "Inverter.OutPhs",
            "Nameplate.MainModel",
            "Nameplate.PkgRev",
            "GridGuard.Cntry.FrqCtl.lLimTmms",
            "Nameplate.CmpMdul.SwRev",
            "Nameplate.CmpFltASw.HwRev",
            "GridGuard.Cntry.Aid.AngFact",
            "DcCfg.MPPShdw.CycTms",
            "Nameplate.CmpRS485.Rev",
            "GridGuard.Cntry",
            "Operation.ValRsIstl",
            "Nameplate.SerNum",
            "GridGuard.Cntry.AMaxOfs",
            "GridGuard.Cntry.LeakRisMin",
            "Nameplate.CmpBt.SwRev",
            "GridGuard.Cntry.GriFltTms",
            "Metering.TotOpTmhSet",
            "GridGuard.Cntry.FrqCtl.hLim",
            "GridGuard.Cntry.FrqCtl.Max",
            "GridGuard.Cntry.GriStrTms",
            "Nameplate.CmpCom.SwRev",
            "GridGuard.Cntry.VolCtl.MaxTmms",
            "Inverter.StopTms",
            "Nameplate.CmpCom.HwRev",
            "Inverter.OffGri.HzdStr",
            "Nameplate.CmpMain.Rev",
            "GridGuard.Cntry.VolCtl.lLim",
            "Nameplate.CmpBt.Rev",
            "GridGuard.Cntry.GriFltReConTms",
            "GridGuard.Cntry.VolCtl.llLimTmms",
            "GridGuard.Cntry.VolCtl.hhLimTmms",
            "GridGuard.Cntry.FrqCtl.MaxTmms",
            "Nameplate.CmpDisp.Rev",
            "Nameplate.CmpDisp.SwRev",
            "Nameplate.CmpMdul.HwRev",
            "Nameplate.CmpSigProc.SwRev",
            "Inverter.WMax",
            "GridGuard.Cntry.FrqCtl.Min",
            "DcCfg.StrVol[]",
            "GridGuard.Cntry.FrqCtl.lLim",
            "Nameplate.ComRev",
            "Nameplate.CmpDisp.SerNum",
            "Nameplate.Vendor",
            "DcCfg.ConstVolCtl.Vset[]",
            "GridGuard.Cntry.VolCtl.hLim",
            "Nameplate.CmpFltASw.SwRev",
            "GridGuard.Cntry.GriFltMonTms",
            "GridGuard.Cntry.FrqCtl.MinTmms",
            "Operation.LodFnc",
        ],
    ),
    (
        [9056],  # "SMC 9000TL-10
        [
            "Coolsys.Cab.TmpValIstl",
            "Coolsys.Cab.TmpValMaxIstl",
            "Coolsys.Inverter.TmpVal",
            "DcMs.Amp.1",
            "DcMs.Vol.1",
            "DcMs.Watt.1",
            "DcMs.Amp.2",
            "DcMs.Vol.2",
            "DcMs.Watt.2",
            "GridMs.A.phsA",
            "GridMs.A.phsB",
            "GridMs.A.phsC",
            "GridMs.Hz",
            "GridMs.PhV.phsA",
            "GridMs.PhV.phsB",
            "GridMs.PhV.phsC",
            "GridMs.TotW",
            "GridMs.TotW.Pv",
            "Isolation.FltA",
            "Isolation.LeakRis",
            "Metering.TotFeedTms",
            "Metering.TotOpTms",
            "Metering.TotWhOut.Pv",
            "Operation.GriSwCnt",
            "Operation.Health",
            "Setpoint.PlantControl.Inverter.FstStop",
            "Setpoint.PlantControl.Inverter.WModCfg.WCtlComCfg.WNom",
            "GridGuard.Cntry.FrqCtl.hLim",
            "GridGuard.Cntry.Aid.HzMon.HzLim",
            "Metering.TotkWhOutSet",
            "Nameplate.CmpMain.SwRev",
            "Metering.TotFeedTmhSet",
            "GridGuard.Cntry.VolCtl.Rpro",
            "Nameplate.CmpCom.SwRev",
            "GridGuard.Cntry.Aid.PerAid.Ampl",
            "GridGuard.Cntry.VRefOfs",
            "Inverter.OffGri.HzdLim",
            "Inverter.StopTms",
            "DcCfg.StrTms",
            "Inverter.OffGri.HzdStr",
            "GridGuard.Cntry.Aid.PerAid.Hz",
            "GridGuard.Cntry.VolCtl.lLim",
            "Nameplate.Model",
            "GridGuard.CntrySet",
            "Inverter.WLim",
            "Coolsys.FanTst",
            "Operation.OpMod",
            "GridGuard.Cntry.VolCtl.hhLim",
            "GridGuard.Cntry.VolCtl.llLim",
            "Nameplate.Location",
            "Inverter.OutPhs",
            "Inverter.WMax",
            "Nameplate.MainModel",
            "DcCfg.StrVol",
            "GridGuard.Cntry.FrqCtl.lLim",
            "Nameplate.Vendor",
            "DcCfg.ConstVolCtl.Vset",
            "GridGuard.Cntry.FrqCtl.ChgMax",
            "GridGuard.Cntry.VolCtl.hLim",
            "GridGuard.Cntry.Aid.AngFact",
            "GridGuard.Cntry.GridGuardRev",
            "Operation.PwrBal.OpMod",
            "Operation.ValRsIstl",
            "Nameplate.SerNum",
            "GridGuard.Cntry.AMaxOfs",
            "GridGuard.Cntry.LeakRisMin",
        ],
    ),
    (
        [19047],  # STP 110-60
        [
            "DcMs.Amp.1",
            "DcMs.Vol.1",
            "DcMs.Watt.1",
            "DcMs.Amp.2",
            "DcMs.Vol.2",
            "DcMs.Watt.2",
            "GridMs.A.phsA",
            "GridMs.A.phsB",
            "GridMs.A.phsC",
            "GridMs.Hz",
            "GridMs.PhV.phsA",
            "GridMs.PhV.phsA2B",
            "GridMs.PhV.phsB",
            "GridMs.PhV.phsB2C",
            "GridMs.PhV.phsC",
            "GridMs.PhV.phsC2A",
            "GridMs.TotA",
            "GridMs.TotPFEEI",
            "GridMs.TotVA",
            "GridMs.TotVAr",
            "GridMs.TotVAr.Pv",
            "GridMs.TotW",
            "GridMs.TotW.Pv",
            "Metering.TotWhOut",
            "Metering.TotWhOut.Pv",
            "Operation.Evt.EvtNo",
            "Operation.Evt.Msg",
            "Operation.FailCode",
            "Operation.GriSwStt",
            "Operation.Health",
            "Operation.OpStt",
            "Operation.PvGriConn",
            "Nameplate.Model",
            "Inverter.WLim",
            "Nameplate.Location",
            "Inverter.VArMaxQ1Rtg",
            "Nameplate.MainModel",
            "Nameplate.PkgRev",
            "Bat.CapacRtgWh",
            "Nameplate.SerNum",
            "Nameplate.ModelStr",
            "Spdwr.ActlIp",
            "Nameplate.ARtg",
            "Inverter.VArMaxQ4Rtg",
            "Bat.CapacRtg",
            "Nameplate.VendorStr",
        ],
    ),
    (
        [358],  # SB 4000TL-20
        [
            "DcMs.Amp.1",
            "DcMs.Vol.1",
            "DcMs.Watt.1",
            "DcMs.Amp.2",
            "DcMs.Vol.2",
            "DcMs.Watt.2",
            "Coolsys.Inverter.TmpVal",
            "GridGuard.Cntry",
            "GridMs.A.phsA",
            "GridMs.A.phsB",
            "GridMs.A.phsC",
            "GridMs.Hz",
            "GridMs.PhV.phsA",
            "GridMs.PhV.phsB",
            "GridMs.PhV.phsC",
            "GridMs.TotVA",
            "GridMs.TotVAr",
            "GridMs.TotVAr.Pv",
            "GridMs.TotW",
            "GridMs.TotW.Pv",
            "GridMs.W.phsA",
            "GridMs.W.phsB",
            "GridMs.W.phsC",
            "Isolation.FltA",
            "Isolation.LeakRis",
            "Metering.TotFeedTms",
            "Metering.TotOpTms",
            "Metering.TotWhOut.Pv",
            "Operation.DrtStt",
            "Operation.Evt.EvtNo",
            "Operation.Evt.EvtNoShrt",
            "Operation.Evt.Prio",
            "Operation.EvtCntIstl",
            "Operation.EvtCntUsr",
            "Operation.GriSwCnt",
            "Operation.GriSwStt",
            "Operation.Health",
            "Operation.RmgTms",
            "Setpoint.PlantControl.Inverter.FstStop",
            "Setpoint.PlantControl.Inverter.WModCfg.WCtlComCfg.WNom",
            "Nameplate.CmpMdul.Rev",
            "Metering.TotkWhOutSet",
            "DcCfg.VolLim[]",
            "Metering.TotFeedTmhSet",
            "Nameplate.CmpMain.SwRev",
            "GridGuard.Cntry.VolCtl.Max",
            "Nameplate.CmpMain.HwRev",
            "GridGuard.Cntry.VolCtl.Rpro",
            "Nameplate.CmpRS485.HwRev",
            "Nameplate.CmpCom.Rev",
            "DcCfg.MPPShdw.IsOn",
            "Inverter.OffGri.HzdLim",
            "GridGuard.Cntry.FrqCtl.hLimTmms",
            "DcCfg.StrTms[]",
            "Bt.BtPwr",
            "Nameplate.Model",
            "GridGuard.CntrySet",
            "Inverter.WLim",
            "Coolsys.FanTst",
            "Operation.OpMod",
            "GridGuard.Cntry.PEOpnMon",
            "Nameplate.CmpRS485.SwRev",
            "GridGuard.Cntry.AMaxOfsTmms",
            "GridGuard.Cntry.VolCtl.hhLim",
            "Nameplate.CmpFltASw.Rev",
            "Inverter.WMaxTm",
            "GridGuard.Cntry.VolCtl.llLim",
            "Nameplate.Location",
            "GridGuard.Cntry.VolCtl.hLimTmms",
            "Nameplate.CmpSigProc.Rev",
            "GridGuard.Cntry.VolCtl.lLimTmms",
            "Inverter.OutPhs",
            "Nameplate.MainModel",
            "Nameplate.PkgRev",
            "GridGuard.Cntry.FrqCtl.lLimTmms",
            "Nameplate.CmpMdul.SwRev",
            "Nameplate.CmpFltASw.HwRev",
            "GridGuard.Cntry.Aid.AngFact",
            "DcCfg.MPPShdw.CycTms",
            "Nameplate.CmpRS485.Rev",
            "GridGuard.Cntry",
            "Operation.ValRsIstl",
            "Nameplate.SerNum",
            "GridGuard.Cntry.AMaxOfs",
            "GridGuard.Cntry.LeakRisMin",
            "Nameplate.CmpBt.SwRev",
            "GridGuard.Cntry.GriFltTms",
            "Metering.TotOpTmhSet",
            "GridGuard.Cntry.FrqCtl.hLim",
            "GridGuard.Cntry.FrqCtl.Max",
            "GridGuard.Cntry.GriStrTms",
            "Nameplate.CmpCom.SwRev",
            "GridGuard.Cntry.VolCtl.MaxTmms",
            "Inverter.StopTms",
            "Nameplate.CmpCom.HwRev",
            "Inverter.OffGri.HzdStr",
            "Nameplate.CmpMain.Rev",
            "GridGuard.Cntry.VolCtl.lLim",
            "Nameplate.CmpBt.Rev",
            "GridGuard.Cntry.GriFltReConTms",
            "GridGuard.Cntry.VolCtl.llLimTmms",
            "GridGuard.Cntry.VolCtl.hhLimTmms",
            "GridGuard.Cntry.FrqCtl.MaxTmms",
            "Nameplate.CmpDisp.Rev",
            "Nameplate.CmpDisp.SwRev",
            "Nameplate.CmpMdul.HwRev",
            "Nameplate.CmpSigProc.SwRev",
            "Inverter.WMax",
            "GridGuard.Cntry.FrqCtl.Min",
            "DcCfg.StrVol[]",
            "GridGuard.Cntry.FrqCtl.lLim",
            "Nameplate.ComRev",
            "Nameplate.CmpDisp.SerNum",
            "Nameplate.Vendor",
            "DcCfg.ConstVolCtl.Vset[]",
            "GridGuard.Cntry.VolCtl.hLim",
            "Nameplate.CmpFltASw.SwRev",
            "GridGuard.Cntry.GriFltMonTms",
            "GridGuard.Cntry.FrqCtl.MinTmms",
            "Operation.LodFnc",
        ],
    ),
    (
        [19143],  # EC22-3AC-20
        [
            "Acs.AuthRegistStt",
            "ChaSess.WhIn",
            "Chrg.ModSw",
            "GridMs.A.phsA",
            "GridMs.A.phsB",
            "GridMs.A.phsC",
            "GridMs.PhV.phsA",
            "GridMs.PhV.phsB",
            "GridMs.PhV.phsC",
            "GridMs.TotVA",
            "GridMs.TotVAr",
            "GridMs.VA.phsA",
            "GridMs.VA.phsB",
            "GridMs.VA.phsC",
            "GridMs.VAr.phsA",
            "GridMs.VAr.phsB",
            "GridMs.VAr.phsC",
            "GridMs.W.phsA",
            "GridMs.W.phsB",
            "GridMs.W.phsC",
            "InOut.GI1",  # codespell:ignore
            "InOut.GO1",  # codespell:ignore
            "Metering.GridMs.TotWIn.ChaSta",
            "Metering.GridMs.TotWhIn.ChaSta",
            "Operation.EVeh.ChaStt",
            "Operation.EVeh.Health",
            "Operation.Evt.Dsc",
            "Operation.Evt.EvtNo",
            "Operation.Evt.Msg",
            "Operation.EvtCntIstl",
            "Operation.EvtCntUsr",
            "Operation.Health",
            "Operation.WMaxLimSrc",
            "Spdwr.ComSocA.Stt",
            "Upd.Stt",
            "WebConn.Stt",
            "Wl.AcqStt",
            "Wl.AntMod",
            "Wl.ConnStt",
            "Wl.SigPwr",
            "Wl.SoftAcsConnStt",
            "Setpoint.PlantControl.PCC.ChrgActCnt",
            "Nameplate.Model",
            "Nameplate.CmpMain.SusyId",
            "Wl.DoWPS",
            "Chrg.Plan.En",
            "WebConn.SwRev",
            "Nameplate.MainModel",
            "PCC.ARtg",
            "Wl.Sec.Psk",
            "Spdwr.AutoCfgIsOn",
            "Acs.PwdIstl",
            "SwCmp.CmpComBlt.SwRev",
            "Sys.AmbLghtBri",
            "Nameplate.SerNum",
            "Spdwr.ActlSnetMsk",
            "Upd.AutoUpdIsOn",
            "Nameplate.ChrgCtrl.SusyId",
            "Inverter.AcALim",
            "Wl.ActlIp",
            "Nameplate.CmpCom.HwVer",
            "Wl.ActlSnetMsk",
            "Chrg.ActChaMod",
            "Sys.UseAmbLght",
            "Acs.PwdUsr",
            "Spdwr.ActlIp",
            "Chrg.Plan.StopTm",
            "Nameplate.CmpOS.SwRev",
            "Inverter.WMaxIn",
            "WebConn.IsOn",
            "PCC.WMaxAsym",
            "Nameplate.ARtg",
            "DtTm.NtpSrv",
            "Inverter.WMax",
            "Nameplate.ChrgCtrl.SerNumTxt",
            "Chrg.Plan.DurTmm",
            "Chrg.ChrgLok",
            "Nameplate.CmpCom.SerNum",
            "Wl.ActlDnsSrvIp",
            "Nameplate.MacId",
            "Nameplate.ChrgCtrl.SwRevTxt",
            "Wl.Sec.Cry",
            "Spdwr.IgmpQryTms",
            "Nameplate.CmpCom.Rev",
            "DevUpd.IsOn",
            "Nameplate.Location",
            "Spdwr.ActlDnsSrvIp",
            "Chrg.AMinCha",
            "Inverter.OutPhs",
            "Nameplate.PkgRev",
            "Wl.ActlGwIp",
            "PCC.FlbInv.WMax",
            "IecCfg.GoCfg.GoAppId",
            "Inverter.WMaxInRtg",
            "Mb.TcpSrv.IsOn",
            "Sys.DevSigBri",
            "SwCmp.CmpEnnexOS.Frwk.SwRev",
            "Nameplate.ChrgCtrl.ChrgTypTxt",
            "Chrg.CblLok",
            "Mb.ScdInEna",
            "Nameplate.ModelStr",
            "Spdwr.IgmpQryTx",
            "Spdwr.ActlGwIp",
            "Chrg.UseEnergyMeter",
            "Sys.DevRstr",
            "GridGuard.Cntry.VRtg",
            "Operation.ComTmOut",
            "Wl.Sec.Ssid",
            "Chrg.ChrgApv",
            "IecCfg.GoCfg.GoMacId",
            "Nameplate.WlMacId",
            "Upd.AvalChkIstl",
            "Nameplate.Vendor",
            "Wl.IsOn",
            "Nameplate.VendorStr",
            "Chrg.StpWhenFl",
            "Wl.AutoCfgIsOn",
            "Wl.SoftAcsIsOn",
            "Chrg.StpWhenFlTm",
            "Wl.DoAcq",
            "Sys.DevSig",
            "Mb.TcpSrv.Port",
        ],
    ),
    (
        [-47114711],  # Fake Number for Plants
        [
            "GridGuard.Cntry.FrqCtl.ReconMax",
            "GridGuard.Cntry.FrqCtl.ReconMin",
            "GridGuard.Cntry.GriFltMonTms",
            "GridGuard.Cntry.GriFltReConTms",
            "GridGuard.Cntry.GriFltTms",
            "GridGuard.Cntry.GriStrTms",
            "GridGuard.Cntry.VolCtl.ReconMaxPu",
            "GridGuard.Cntry.VolCtl.ReconMinPu",
            "GridMs.TotVAr",
            "GridMs.TotW",
            "GridMs.TotW.Pv",
            "Inverter.CtlComCfg.PFCtlCom.CtlComMssMod",
            "Inverter.CtlComCfg.PFCtlCom.FlbPFExtIn",
            "Inverter.CtlComCfg.PFCtlCom.FlbPFExtOut",
            "Inverter.CtlComCfg.PFCtlCom.FlbPFIn",
            "Inverter.CtlComCfg.PFCtlCom.FlbPFOut",
            "Inverter.CtlComCfg.PFCtlCom.TmsOut",
            "Inverter.CtlComCfg.PFCtlEvu.AnInEna",
            "Inverter.CtlComCfg.PFCtlEvu.MbEna",
            "Inverter.CtlComCfg.VArCtlCom.CtlComMssMod",
            "Inverter.CtlComCfg.VArCtlCom.FlbVArNom",
            "Inverter.CtlComCfg.VArCtlCom.TmsOut",
            "Inverter.CtlComCfg.VArCtlEvu.AnInEna",
            "Inverter.CtlComCfg.VArCtlEvu.DigInEna",
            "Inverter.CtlComCfg.VArCtlEvu.MbEna",
            "Inverter.CtlComCfg.VArCtlVolCom.CtlComMssMod",
            "Inverter.CtlComCfg.VArCtlVolCom.FlbVolRefPu",
            "Inverter.CtlComCfg.VArCtlVolCom.TmsOut",
            "Inverter.CtlComCfg.WCtlCom2.CtlComMssMod",
            "Inverter.CtlComCfg.WCtlCom2.FlbWMaxNom",
            "Inverter.CtlComCfg.WCtlCom2.FlbWMinNom",
            "Inverter.CtlComCfg.WCtlCom2.TmsOut",
            "Inverter.CtlComCfg.WCtlCom.CtlComMssMod",
            "Inverter.CtlComCfg.WCtlCom.FlbWMaxNom",
            "Inverter.CtlComCfg.WCtlCom.FlbWMinNom",
            "Inverter.CtlComCfg.WCtlCom.TmsOut",
            "Inverter.CtlComCfg.WCtlDctMrk.MbEna",
            "Inverter.CtlComCfg.WCtlDctMrk.SmaSpotEna",
            "Inverter.CtlComCfg.WCtlEvu.AnInEna",
            "Inverter.CtlComCfg.WCtlEvu.DigInEna",
            "Inverter.CtlComCfg.WCtlEvu.MbEna",
            "Inverter.CurWCtlDrkNom",
            "Inverter.CurWCtlNom",
            "Inverter.DGSModCfg.AvLtTms",
            "Inverter.DGSModCfg.AvStTms",
            "Inverter.DGSModCfg.DGSFlCfg.DbVMaxPu",
            "Inverter.DGSModCfg.DGSFlCfg.DbVMinPu",
            "Inverter.DGSModCfg.DGSFlCfg.FltEnd.ArMaxTms",
            "Inverter.DGSModCfg.DGSFlCfg.StepVolPu",
            "Inverter.DGSModCfg.DGSMod",
            "Inverter.DGSModCfg.HystVolPu",
            "Inverter.DGSModCfg.VRefThMod",
            "Inverter.PFMinQ1",
            "Inverter.PFMinQ1Rtg",
            "Inverter.PFMinQ2",
            "Inverter.PFMinQ2Rtg",
            "Inverter.PFMinQ3",
            "Inverter.PFMinQ3Rtg",
            "Inverter.PFMinQ4",
            "Inverter.PFMinQ4Rtg",
            "Inverter.PlntCtl.VRef",
            "Inverter.PlntCtl.VRefMod",
            "Inverter.VALimEna",
            "Inverter.VAMaxIn",
            "Inverter.VAMaxInRtg",
            "Inverter.VAMaxOut",
            "Inverter.VAMaxOutRtg",
            "Inverter.VArGraConn",
            "Inverter.VArGraConnEna",
            "Inverter.VArMaxQ1",
            "Inverter.VArMaxQ1Rtg",
            "Inverter.VArMaxQ2",
            "Inverter.VArMaxQ2Rtg",
            "Inverter.VArMaxQ3",
            "Inverter.VArMaxQ3Rtg",
            "Inverter.VArMaxQ4",
            "Inverter.VArMaxQ4Rtg",
            "Inverter.VArMaxZerWQ1",
            "Inverter.VArMaxZerWQ2",
            "Inverter.VArMaxZerWQ3",
            "Inverter.VArMaxZerWQ4",
            "Inverter.VArModCfg.HystTms",
            "Inverter.VArModCfg.InWNomLimAct",
            "Inverter.VArModCfg.InWNomLimDeAct",
            "Inverter.VArModCfg.OutWNomLimAct",
            "Inverter.VArModCfg.OutWNomLimDeAct",
            "Inverter.VArModCfg.PFCfg.Dyn.VArGraEna",
            "Inverter.VArModCfg.PFCfg.Dyn.VArGraNeg",
            "Inverter.VArModCfg.PFCfg.Dyn.VArGraPos",
            "Inverter.VArModCfg.PFCfg.Dyn.VArTmEna",
            "Inverter.VArModCfg.PFCfg.Dyn.VArTms",
            "Inverter.VArModCfg.PFCfg.Dyn.WFilTmEna",
            "Inverter.VArModCfg.PFCfg.Dyn.WFilTms",
            "Inverter.VArModCfg.PFCnstCfg.PFExtIn",
            "Inverter.VArModCfg.PFCnstCfg.PFExtOut",
            "Inverter.VArModCfg.PFCnstCfg.PFIn",
            "Inverter.VArModCfg.PFCnstCfg.PFOut",
            "Inverter.VArModCfg.PFCtlVolCfg.Crv.NumPt",
            "Inverter.VArModCfg.PFCtlVolCfg.Crv.PF.1",
            "Inverter.VArModCfg.PFCtlVolCfg.Crv.PF.2",
            "Inverter.VArModCfg.PFCtlVolCfg.Crv.PF.3",
            "Inverter.VArModCfg.PFCtlVolCfg.Crv.PF.4",
            "Inverter.VArModCfg.PFCtlVolCfg.Crv.PFExt.1",
            "Inverter.VArModCfg.PFCtlVolCfg.Crv.PFExt.2",
            "Inverter.VArModCfg.PFCtlVolCfg.Crv.PFExt.3",
            "Inverter.VArModCfg.PFCtlVolCfg.Crv.PFExt.4",
            "Inverter.VArModCfg.PFCtlVolCfg.Crv.VolPu.1",
            "Inverter.VArModCfg.PFCtlVolCfg.Crv.VolPu.2",
            "Inverter.VArModCfg.PFCtlVolCfg.Crv.VolPu.3",
            "Inverter.VArModCfg.PFCtlVolCfg.Crv.VolPu.4",
            "Inverter.VArModCfg.PFCtlVolCfg.Dyn.ActTms",
            "Inverter.VArModCfg.PFCtlVolCfg.Dyn.VArGraEna",
            "Inverter.VArModCfg.PFCtlVolCfg.Dyn.VArGraNeg",
            "Inverter.VArModCfg.PFCtlVolCfg.Dyn.VArGraPos",
            "Inverter.VArModCfg.PFCtlVolCfg.Dyn.VArTmEna",
            "Inverter.VArModCfg.PFCtlVolCfg.Dyn.VArTms",
            "Inverter.VArModCfg.PFCtlVolCfg.Dyn.WFilTmEna",
            "Inverter.VArModCfg.PFCtlVolCfg.Dyn.WFilTms",
            "Inverter.VArModCfg.PFCtlWCfg.Crv.NumPt",
            "Inverter.VArModCfg.PFCtlWCfg.Crv.PF.1",
            "Inverter.VArModCfg.PFCtlWCfg.Crv.PF.2",
            "Inverter.VArModCfg.PFCtlWCfg.Crv.PF.3",
            "Inverter.VArModCfg.PFCtlWCfg.Crv.PF.4",
            "Inverter.VArModCfg.PFCtlWCfg.Crv.PFExt.1",
            "Inverter.VArModCfg.PFCtlWCfg.Crv.PFExt.2",
            "Inverter.VArModCfg.PFCtlWCfg.Crv.PFExt.3",
            "Inverter.VArModCfg.PFCtlWCfg.Crv.PFExt.4",
            "Inverter.VArModCfg.PFCtlWCfg.Crv.WNom.1",
            "Inverter.VArModCfg.PFCtlWCfg.Crv.WNom.2",
            "Inverter.VArModCfg.PFCtlWCfg.Crv.WNom.3",
            "Inverter.VArModCfg.PFCtlWCfg.Crv.WNom.4",
            "Inverter.VArModCfg.PFCtlWCfg.Dyn.ActTms",
            "Inverter.VArModCfg.PFCtlWCfg.Dyn.VArGraEna",
            "Inverter.VArModCfg.PFCtlWCfg.Dyn.VArGraNeg",
            "Inverter.VArModCfg.PFCtlWCfg.Dyn.VArGraPos",
            "Inverter.VArModCfg.PFCtlWCfg.Dyn.VArTmEna",
            "Inverter.VArModCfg.PFCtlWCfg.Dyn.VArTms",
            "Inverter.VArModCfg.PFCtlWCfg.Dyn.WFilTmEna",
            "Inverter.VArModCfg.PFCtlWCfg.Dyn.WFilTms",
            "Inverter.VArModCfg.PFCtlWCfg.Trg.DsaUnVolPu",
            "Inverter.VArModCfg.PFCtlWCfg.Trg.DsaVolPu",
            "Inverter.VArModCfg.PFCtlWCfg.Trg.EnaUnVolPu",
            "Inverter.VArModCfg.PFCtlWCfg.Trg.EnaVolPu",
            "Inverter.VArModCfg.PFMinEna",
            "Inverter.VArModCfg.VArCfg.Crv.CrvEna",
            "Inverter.VArModCfg.VArCfg.Crv.XVal.1",
            "Inverter.VArModCfg.VArCfg.Crv.XVal.2",
            "Inverter.VArModCfg.VArCfg.Crv.XVal.3",
            "Inverter.VArModCfg.VArCfg.Crv.XVal.4",
            "Inverter.VArModCfg.VArCfg.Crv.YVal.1",
            "Inverter.VArModCfg.VArCfg.Crv.YVal.2",
            "Inverter.VArModCfg.VArCfg.Crv.YVal.3",
            "Inverter.VArModCfg.VArCfg.Crv.YVal.4",
            "Inverter.VArModCfg.VArCfg.Dyn.VArGraEna",
            "Inverter.VArModCfg.VArCfg.Dyn.VArGraFlb",
            "Inverter.VArModCfg.VArCfg.Dyn.VArGraFlbEna",
            "Inverter.VArModCfg.VArCfg.Dyn.VArGraNeg",
            "Inverter.VArModCfg.VArCfg.Dyn.VArGraPos",
            "Inverter.VArModCfg.VArCfg.Dyn.VArTmEna",
            "Inverter.VArModCfg.VArCfg.Dyn.VArTms",
            "Inverter.VArModCfg.VArCnstCfgDmd.VAr",
            "Inverter.VArModCfg.VArCnstCfgDmd.VArNom",
            "Inverter.VArModCfg.VArCnstCfgIn.VAr",
            "Inverter.VArModCfg.VArCnstCfgIn.VArNom",
            "Inverter.VArModCfg.VArCnstCfg.VAr",
            "Inverter.VArModCfg.VArCnstCfg.VArNom",
            "Inverter.VArModCfg.VArCtlVolCfg.Crv.PreSet",
            "Inverter.VArModCfg.VArCtlVolCfg.Crv.XVal.1",
            "Inverter.VArModCfg.VArCtlVolCfg.Crv.XVal.2",
            "Inverter.VArModCfg.VArCtlVolCfg.Crv.XVal.3",
            "Inverter.VArModCfg.VArCtlVolCfg.Crv.XVal.4",
            "Inverter.VArModCfg.VArCtlVolCfg.Crv.XVal.5",
            "Inverter.VArModCfg.VArCtlVolCfg.Crv.XVal.6",
            "Inverter.VArModCfg.VArCtlVolCfg.Crv.XVal.7",
            "Inverter.VArModCfg.VArCtlVolCfg.Crv.XVal.8",
            "Inverter.VArModCfg.VArCtlVolCfg.Crv.YVal.1",
            "Inverter.VArModCfg.VArCtlVolCfg.Crv.YVal.2",
            "Inverter.VArModCfg.VArCtlVolCfg.Crv.YVal.3",
            "Inverter.VArModCfg.VArCtlVolCfg.Crv.YVal.4",
            "Inverter.VArModCfg.VArCtlVolCfg.Crv.YVal.5",
            "Inverter.VArModCfg.VArCtlVolCfg.Crv.YVal.6",
            "Inverter.VArModCfg.VArCtlVolCfg.Crv.YVal.7",
            "Inverter.VArModCfg.VArCtlVolCfg.Crv.YVal.8",
            "Inverter.VArModCfg.VArCtlVolCfg.Dyn.ActTms",
            "Inverter.VArModCfg.VArCtlVolCfg.Dyn.VArGraEna",
            "Inverter.VArModCfg.VArCtlVolCfg.Dyn.VArGraNeg",
            "Inverter.VArModCfg.VArCtlVolCfg.Dyn.VArGraPos",
            "Inverter.VArModCfg.VArCtlVolCfg.Dyn.VArTmEna",
            "Inverter.VArModCfg.VArCtlVolCfg.Dyn.VArTms",
            "Inverter.VArModCfg.VArCtlVolCfg.VolRef.AutnAdjMod",
            "Inverter.VArModCfg.VArCtlVolCfg.VolRef.AutnAdjTms",
            "Inverter.VArModCfg.VArCtlVolCfg.VolRef.ClsCtl.DsaHiLimVArPu",
            "Inverter.VArModCfg.VArCtlVolCfg.VolRef.ClsCtl.DsaLoLimVArPu",
            "Inverter.VArModCfg.VArCtlVolCfg.VolRef.ClsCtl.EnaHiLimVArPu",
            "Inverter.VArModCfg.VArCtlVolCfg.VolRef.ClsCtl.EnaLoLimVArPu",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.NumPt",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.XVal.1",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.XVal.10",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.XVal.2",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.XVal.3",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.XVal.4",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.XVal.5",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.XVal.6",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.XVal.7",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.XVal.8",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.XVal.9",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.YVal.1",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.YVal.10",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.YVal.2",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.YVal.3",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.YVal.4",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.YVal.5",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.YVal.6",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.YVal.7",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.YVal.8",
            "Inverter.VArModCfg.VArCtlWCfg.Crv.YVal.9",
            "Inverter.VArModCfg.VArCtlWCfg.Dyn.ActTms",
            "Inverter.VArModCfg.VArCtlWCfg.Dyn.VArGraEna",
            "Inverter.VArModCfg.VArCtlWCfg.Dyn.VArGraNeg",
            "Inverter.VArModCfg.VArCtlWCfg.Dyn.VArGraPos",
            "Inverter.VArModCfg.VArCtlWCfg.Dyn.VArTmEna",
            "Inverter.VArModCfg.VArCtlWCfg.Dyn.VArTms",
            "Inverter.VArModCfg.VArCtlWCfg.Trg.DsaUnVolPu",
            "Inverter.VArModCfg.VArCtlWCfg.Trg.DsaVolPu",
            "Inverter.VArModCfg.VArCtlWCfg.Trg.EnaUnVolPu",
            "Inverter.VArModCfg.VArCtlWCfg.Trg.EnaVolPu",
            "Inverter.VArModCfg.VArModIn",
            "Inverter.VArModCfg.VArModInFlb",
            "Inverter.VArModCfg.VArModOut",
            "Inverter.VArModCfg.VArModOutFlb",
            "Inverter.VArModCfg.VArModZerW",
            "Inverter.VArModCfg.VArModZerWFlb",
            "Inverter.VArModCfg.VArNomRefMod",
            "Inverter.VArModCfg.VRefMod",
            "Inverter.WAval",
            "Inverter.WCtlHzModCfg.Ena",
            "Inverter.WCtlHzModCfg.HzFilTmEna",
            "Inverter.WCtlHzModCfg.HzFilTms",
            "Inverter.WCtlHzModCfg.RefModOv",
            "Inverter.WCtlHzModCfg.RefModUn",
            "Inverter.WCtlHzModCfg.WCtlHzCfg.HystEnaOv",
            "Inverter.WCtlHzModCfg.WCtlHzCfg.HystEnaUn",
            "Inverter.WCtlHzModCfg.WCtlHzCfg.HzOv.1",
            "Inverter.WCtlHzModCfg.WCtlHzCfg.HzOv.2",
            "Inverter.WCtlHzModCfg.WCtlHzCfg.HzOv.3",
            "Inverter.WCtlHzModCfg.WCtlHzCfg.HzOvGra.1",
            "Inverter.WCtlHzModCfg.WCtlHzCfg.HzOvGra.2",
            "Inverter.WCtlHzModCfg.WCtlHzCfg.HzOvGra.3",
            "Inverter.WCtlHzModCfg.WCtlHzCfg.HzOvStop",
            "Inverter.WCtlHzModCfg.WCtlHzCfg.HzStopWGra",
            "Inverter.WCtlHzModCfg.WCtlHzCfg.HzStopWGraTms",
            "Inverter.WCtlHzModCfg.WCtlHzCfg.HzUn.1",
            "Inverter.WCtlHzModCfg.WCtlHzCfg.HzUn.2",
            "Inverter.WCtlHzModCfg.WCtlHzCfg.HzUn.3",
            "Inverter.WCtlHzModCfg.WCtlHzCfg.HzUnGra.1",
            "Inverter.WCtlHzModCfg.WCtlHzCfg.HzUnGra.2",
            "Inverter.WCtlHzModCfg.WCtlHzCfg.HzUnGra.3",
            "Inverter.WCtlHzModCfg.WCtlHzCfg.HzUnStop",
            "Inverter.WCtlHzModCfg.WCtlHzCfg.WCtlChgOvUnTmms",
            "Inverter.WCtlHzModCfg.WCtlHzCfg.WCtlTmms",
            "Inverter.WCtlHzModCfg.WGraEna",
            "Inverter.WCtlHzModCfg.WGraNeg",
            "Inverter.WCtlHzModCfg.WGraPos",
            "Inverter.WCtlHzModCfg.WTmEna",
            "Inverter.WCtlHzModCfg.WTms",
            "Inverter.WGraConn",
            "Inverter.WGraConnEna",
            "Inverter.WGraMpp",
            "Inverter.WGraRecon",
            "Inverter.WGraReconEna",
            "Inverter.WMax",
            "Inverter.WMaxIn",
            "Inverter.WMaxInRtg",
            "Inverter.WMaxOut",
            "Inverter.WMaxOutRtg",
            "Inverter.WModCfg.WCnstCfg.WNomEna",
            "Inverter.WModCfg.WCnstCfg.WNomPrc",
            "Inverter.WModCfg.WCtlComCfg2.Dyn.WGraEna",
            "Inverter.WModCfg.WCtlComCfg2.Dyn.WGraNeg",
            "Inverter.WModCfg.WCtlComCfg2.Dyn.WGraPos",
            "Inverter.WModCfg.WCtlComCfg2.Dyn.WTmEna",
            "Inverter.WModCfg.WCtlComCfg2.Dyn.WTms",
            "Inverter.WModCfg.WCtlComCfg2.Ena",
            "Inverter.WModCfg.WCtlComCfg2.LoPrioEna",
            "Inverter.WModCfg.WCtlComCfg.Dyn.WGraEna",
            "Inverter.WModCfg.WCtlComCfg.Dyn.WGraFlb",
            "Inverter.WModCfg.WCtlComCfg.Dyn.WGraFlbEna",
            "Inverter.WModCfg.WCtlComCfg.Dyn.WGraNeg",
            "Inverter.WModCfg.WCtlComCfg.Dyn.WGraPos",
            "Inverter.WModCfg.WCtlComCfg.Dyn.WTmEna",
            "Inverter.WModCfg.WCtlComCfg.Dyn.WTms",
            "Inverter.WModCfg.WCtlComCfg.Ena",
            "Inverter.WModCfg.WCtlHzFsmCfg.Crv.DbHzOv",
            "Inverter.WModCfg.WCtlHzFsmCfg.Crv.DbHzUn",
            "Inverter.WModCfg.WCtlHzFsmCfg.Crv.HzOv.1",
            "Inverter.WModCfg.WCtlHzFsmCfg.Crv.HzOv.2",
            "Inverter.WModCfg.WCtlHzFsmCfg.Crv.HzOv.3",
            "Inverter.WModCfg.WCtlHzFsmCfg.Crv.HzOvGra.1",
            "Inverter.WModCfg.WCtlHzFsmCfg.Crv.HzOvGra.2",
            "Inverter.WModCfg.WCtlHzFsmCfg.Crv.HzOvGra.3",
            "Inverter.WModCfg.WCtlHzFsmCfg.Crv.HzUn.1",
            "Inverter.WModCfg.WCtlHzFsmCfg.Crv.HzUn.2",
            "Inverter.WModCfg.WCtlHzFsmCfg.Crv.HzUn.3",
            "Inverter.WModCfg.WCtlHzFsmCfg.Crv.HzUnGra.1",
            "Inverter.WModCfg.WCtlHzFsmCfg.Crv.HzUnGra.2",
            "Inverter.WModCfg.WCtlHzFsmCfg.Crv.HzUnGra.3",
            "Inverter.WModCfg.WCtlHzFsmCfg.Dyn.HzFilTmEna",
            "Inverter.WModCfg.WCtlHzFsmCfg.Dyn.HzFilTms",
            "Inverter.WModCfg.WCtlHzFsmCfg.Dyn.WAvalFilTmEna",
            "Inverter.WModCfg.WCtlHzFsmCfg.Dyn.WAvalGraEna",
            "Inverter.WModCfg.WCtlHzFsmCfg.Dyn.WAvalGraNeg",
            "Inverter.WModCfg.WCtlHzFsmCfg.Dyn.WAvalGraPos",
            "Inverter.WModCfg.WCtlHzFsmCfg.Dyn.WAvalTms",
            "Inverter.WModCfg.WCtlHzFsmCfg.Dyn.WDifFilTmEna",
            "Inverter.WModCfg.WCtlHzFsmCfg.Dyn.WDifFilTms",
            "Inverter.WModCfg.WCtlHzFsmCfg.Dyn.WDifGraEna",
            "Inverter.WModCfg.WCtlHzFsmCfg.Dyn.WDifGraNeg",
            "Inverter.WModCfg.WCtlHzFsmCfg.Dyn.WDifGraPos",
            "Inverter.WModCfg.WCtlHzFsmCfg.Ena",
            "Inverter.WModCfg.WCtlHzFsmCfg.WBaseMod",
            "Inverter.WModCfg.WCtlHzFsmCfg.WDifRefMod",
            "Inverter.WModCfg.WCtlHzFsmCfg.WResNom",
            "Inverter.WModCfg.WCtlHzILFCfg.DsaWaitTms",
            "Inverter.WModCfg.WCtlHzILFCfg.Ena",
            "Inverter.WModCfg.WCtlHzILFCfg.HzFilTmEna",
            "Inverter.WModCfg.WCtlHzILFCfg.HzFilTms",
            "Inverter.WModCfg.WCtlHzILFCfg.HzOvDsa",
            "Inverter.WModCfg.WCtlHzILFCfg.HzOvEna",
            "Inverter.WModCfg.WCtlHzILFCfg.HzStopMax",
            "Inverter.WModCfg.WCtlHzILFCfg.HzStopMin",
            "Inverter.WModCfg.WCtlHzILFCfg.HzStopWGra",
            "Inverter.WModCfg.WCtlHzILFCfg.HzUnDsa",
            "Inverter.WModCfg.WCtlHzILFCfg.HzUnEna",
            "Inverter.WModCfg.WCtlHzILFCfg.MbEna",
            "Inverter.WModCfg.WCtlHzILFCfg.WGra",
            "Inverter.WModCfg.WCtlVolCfg.ActTms",
            "Inverter.WModCfg.WCtlVolCfg.Crv.NumPt",
            "Inverter.WModCfg.WCtlVolCfg.Crv.XVal.1",
            "Inverter.WModCfg.WCtlVolCfg.Crv.XVal.2",
            "Inverter.WModCfg.WCtlVolCfg.Crv.XVal.3",
            "Inverter.WModCfg.WCtlVolCfg.Crv.XVal.4",
            "Inverter.WModCfg.WCtlVolCfg.Crv.XVal.5",
            "Inverter.WModCfg.WCtlVolCfg.Crv.XVal.6",
            "Inverter.WModCfg.WCtlVolCfg.Crv.XVal.7",
            "Inverter.WModCfg.WCtlVolCfg.Crv.XVal.8",
            "Inverter.WModCfg.WCtlVolCfg.Crv.YVal.1",
            "Inverter.WModCfg.WCtlVolCfg.Crv.YVal.2",
            "Inverter.WModCfg.WCtlVolCfg.Crv.YVal.3",
            "Inverter.WModCfg.WCtlVolCfg.Crv.YVal.4",
            "Inverter.WModCfg.WCtlVolCfg.Crv.YVal.5",
            "Inverter.WModCfg.WCtlVolCfg.Crv.YVal.6",
            "Inverter.WModCfg.WCtlVolCfg.Crv.YVal.7",
            "Inverter.WModCfg.WCtlVolCfg.Crv.YVal.8",
            "Inverter.WModCfg.WCtlVolCfg.Ena",
            "Inverter.WModCfg.WCtlVolCfg.VRefMod",
            "Inverter.WModCfg.WCtlVolCfg.WGraEna",
            "Inverter.WModCfg.WCtlVolCfg.WGraNeg",
            "Inverter.WModCfg.WCtlVolCfg.WGraPos",
            "Inverter.WModCfg.WCtlVolCfg.WRefMod",
            "Inverter.WModCfg.WCtlVolCfg.WTmEna",
            "Inverter.WModCfg.WCtlVolCfg.WTms",
            "Metering.DyWhOut",
            "Metering.GridMs.TotWhIn.Bat",
            "Metering.GridMs.TotWhOut.Bat",
            "Metering.PCCMs.PlntA.phsA",
            "Metering.PCCMs.PlntA.phsB",
            "Metering.PCCMs.PlntA.phsC",
            "Metering.PCCMs.PlntCsmpW",
            "Metering.PCCMs.PlntCsmpWh",
            "Metering.PCCMs.PlntHz",
            "Metering.PCCMs.PlntPF",
            "Metering.PCCMs.PlntPhV.phsA",
            "Metering.PCCMs.PlntPhV.phsB",
            "Metering.PCCMs.PlntPhV.phsC",
            "Metering.PCCMs.PlntVAr",
            "Metering.PCCMs.PlntVAr.phsA",
            "Metering.PCCMs.PlntVAr.phsB",
            "Metering.PCCMs.PlntVAr.phsC",
            "Metering.PCCMs.PlntW",
            "Metering.PCCMs.PlntWh",
            "Metering.PCCMs.PlntW.phsA",
            "Metering.PCCMs.PlntW.phsB",
            "Metering.PCCMs.PlntW.phsC",
            "Metering.TotWhOut.Pv",
            "Operation.CurAvailPlnt",
            "Operation.CurAvailVArOvExt",
            "Operation.CurAvailVArOvExtNom",
            "Operation.CurAvailVArUnExt",
            "Operation.CurAvailVArUnExtNom",
            "Operation.Dmd.WCtl",
            "Operation.Health",
            "Operation.NbrQodStt",
            "Operation.NbrRunStt",
            "Operation.NbrStopStt",
            "Operation.NbrWaitStt",
            "Operation.OpStt",
            "Operation.PlntCtl.VArCtlMod",
            "Operation.PlntCtl.WCtlMod",
            "Operation.VArCtl.VArModAct",
            "Operation.VArCtl.VArModStt",
            "Operation.VArMaxLimNom",
            "Operation.VArMinLimNom",
            "Operation.WMaxInLimNom",
            "Operation.WMaxLimNom",
            "Operation.WMaxLimSrc",
            "Operation.WMinInLimNom",
            "Operation.WMinLimNom",
            "Operation.WMinLimSrc",
            "PCC.WMaxAsym",
            "PCC.WMaxAsymMod",
            "PCC.WMaxAsymRefMod",
            "Plnt.CapacRtgWh",
            "PlntCtl.Frs.BatChaSttMax",
            "PlntCtl.Frs.BatChaSttMin",
            "PlntCtl.Frs.BatWhFilTms",
            "PlntCtl.Frs.CrvActHystTms",
            "PlntCtl.Frs.CrvActTms",
            "PlntCtl.Frs.CrvRmpZerWTms",
            "PlntCtl.Frs.DbHzOv",
            "PlntCtl.Frs.DbHzUn",
            "PlntCtl.Frs.Ena",
            "PlntCtl.Frs.HystWhRsvNom",
            "PlntCtl.Frs.RsvRmpZerWTms",
            "PlntCtl.Frs.RsvTms",
            "PlntCtl.Frs.RvyWhRsv.Ena",
            "PlntCtl.Frs.RvyWhRsv.WaitTms",
            "PlntCtl.Frs.RvyWhRsv.WGra",
            "PlntCtl.Frs.RvyWhRsv.WGraEna",
            "PlntCtl.Frs.RvyWhRsv.WMaxNom",
            "PlntCtl.Frs.WMaxNom",
            "PlntCtl.MaxPhsWCtlEna",
            "PlntCtl.MsFil.HzFilTmEna",
            "PlntCtl.MsFil.HzFilTms",
            "PlntCtl.MsFil.VArFilTmEna",
            "PlntCtl.MsFil.VArFilTms",
            "PlntCtl.MsFil.VolFilTmEna",
            "PlntCtl.MsFil.VolFilTms",
            "PlntCtl.MsFil.WFilTmEna",
            "PlntCtl.MsFil.WFilTms",
            "PlntCtl.SingleDevSptEna",
            "PlntCtl.SmpTm",
            "PlntCtl.VArCtl.DeActWaitTms",
            "PlntCtl.VArCtl.WPuLimAct",
            "PlntCtl.VArCtl.WPuLimDeAct",
            "PlntCtl.WCtlEvuRefMod",
            "PlntCtl.WNomInvStop",
            "Plnt.DcWRtg",
            "Plnt.Frs.Aval",
            "Plnt.TotAvalCha",
            "Plnt.TotAvalDsch",
            "Plnt.WRtg",
            "PortalUsrSettings.PlntNam",
            "InOut.DigIn.CurWCtlNom",  # codespell:ignore
        ],
    ),
]

# fmt: off
# black -C -l 200 pysma/definitions_ennexos.py
enneoxSensors = [
        Sensor("Bat.Amp.1", Identifier.battery_current_a, factor=1, unit='A'),
        Sensor("Bat.ChaStt", Identifier.battery_soc_total, factor=1, unit='%'),
        Sensor("Bat.ChaSttArr.1", Identifier.battery_soc_a, factor=1, unit='%'),
        Sensor("Bat.TmpVal.1", Identifier.battery_temp_a, factor=1, unit="°C"),
        Sensor("BatChrg.BatChrgArr.1", None, factor=1, unit=None),
        Sensor("BatChrg.BatChrg", None, factor=1, unit=None),
        Sensor("BatChrg.CurBatCha", Identifier.battery_power_charge_total, factor=1, unit="W"),
        Sensor("BatChrg.CurBatChaArr.1", Identifier.battery_power_charge_a, factor=1, unit="W"),
        Sensor("Bat.Diag.VolMax.1", None, factor=1, unit=None),
        Sensor("BatDsch.BatDschArr.1", None, factor=1, unit=None),
        Sensor("BatDsch.BatDsch", None, factor=1, unit=None),
        Sensor("BatDsch.CurBatDsch", Identifier.battery_power_discharge_total, factor=1, unit="W"),
        Sensor("BatDsch.CurBatDschArr.1", Identifier.battery_power_discharge_a, factor=1, unit="W"),
        Sensor("Bat.OpTms.1", None, factor=1, unit=None),
        Sensor("Bat.Vol.1", Identifier.battery_voltage_a, factor=1, unit="V"),
        Sensor("ChaSess.WhIn", None, factor=1, unit=None),
        Sensor("Chrg.ModSw", None, factor=1, unit=None, mapper=SMATagList),
        Sensor("Coolsys.Inverter.TmpVal.1", Identifier.temp_a, factor=1, unit="°C"),
        Sensor("Coolsys.Inverter.TmpVal.2", Identifier.temp_b, factor=1, unit="°C"),
        Sensor("Coolsys.Inverter.TmpVal.3", Identifier.temp_c, factor=1, unit="°C"),
        Sensor("DcMs.Amp.1", Identifier.pv_current_a, factor=1, unit="A"),
        Sensor("DcMs.Amp.2", Identifier.pv_current_b, factor=1, unit="A"),
        Sensor("DcMs.Amp.3", Identifier.pv_current_c, factor=1, unit="A"),
        Sensor("DcMs.TotDcEnCntWh.1", Identifier.pv_total_power_a, factor=1000, unit="kWh"),
        Sensor("DcMs.TotDcEnCntWh.2", Identifier.pv_total_power_b, factor=1000, unit="kWh"),
        Sensor("DcMs.TotDcEnCntWh.3", Identifier.pv_total_power_c, factor=1000, unit="kWh"),
        Sensor("DcMs.Vol.1", Identifier.pv_voltage_a, factor=1, unit="V"),
        Sensor("DcMs.Vol.2", Identifier.pv_voltage_b, factor=1, unit="V"),
        Sensor("DcMs.Vol.3", Identifier.pv_voltage_c, factor=1, unit="V"),
        Sensor("DcMs.Watt.1", Identifier.pv_power_a, factor=1, unit="W"),
        Sensor("DcMs.Watt.2", Identifier.pv_power_b, factor=1, unit="W"),
        Sensor("DcMs.Watt.3", Identifier.pv_power_c, factor=1, unit="W"),
        Sensor("DevUpd.IsOn", None, factor=1, unit=None),
        Sensor("EpsMs.Amp", None, factor=1, unit=None),
        Sensor("EpsMs.Vol", None, factor=1, unit=None),
        Sensor("EpsMs.Watt", None, factor=1, unit=None),
        Sensor("FTPPush.IsOn", None, factor=1, unit=None),
        Sensor("FTPPush.Login", None, factor=1, unit=None),
        Sensor("FTPPush.Port", None, factor=1, unit=None),
        Sensor("FTPPush.Pwd", None, factor=1, unit=None),
        Sensor("FTPPush.RemStoLcn", None, factor=1, unit=None),
        Sensor("FTPPush.Srv", None, factor=1, unit=None),
        Sensor("FTPPush.UpldCyc", None, factor=1, unit=None),
        Sensor("GridGuard.Cntry", None, factor=1, unit=None),
        Sensor("GridMs.A.phsA", Identifier.current_l1, factor=1, unit="A"),
        Sensor("GridMs.A.phsB", Identifier.current_l2, factor=1, unit="A"),
        Sensor("GridMs.A.phsC", Identifier.current_l3, factor=1, unit="A"),
        Sensor("GridMs.GriTyp", None, factor=1, unit=None),
        Sensor("GridMs.Hz", Identifier.frequency, factor=1, unit="Hz"),
        Sensor("GridMs.PhV.phsA2B", None, factor=1, unit=None),
        Sensor("GridMs.PhV.phsA", Identifier.voltage_l1, factor=1, unit="V"),
        Sensor("GridMs.PhV.phsB2C", None, factor=1, unit=None),
        Sensor("GridMs.PhV.phsB", Identifier.voltage_l2, factor=1, unit="V"),
        Sensor("GridMs.PhV.phsC2A", None, factor=1, unit=None),
        Sensor("GridMs.PhV.phsC", Identifier.voltage_l3, factor=1, unit="V"),
        Sensor("GridMs.TotA", Identifier.current_total, factor=1, unit="A"),
        Sensor("GridMs.TotPFEEI", None, factor=1, unit=None),
        Sensor("GridMs.TotPFExt", None, factor=1, unit=None),
        Sensor("GridMs.TotPF", None, factor=1, unit=None),
        Sensor("GridMs.TotPFPrc", None, factor=1, unit=None),
        Sensor("GridMs.TotVA", Identifier.grid_apparent_power, factor=1, unit="VA"),
        Sensor("GridMs.TotVAr", Identifier.grid_reactive_power, factor=1, unit="var"),
        Sensor("GridMs.TotW", Identifier.grid_power, factor=1, unit="W"),
        Sensor("GridMs.TotW.Pv", Identifier.pv_power, factor=1, unit="W"),
        Sensor("GridMs.VA.phsA", Identifier.grid_apparent_power_l1, factor=1, unit="VA"),
        Sensor("GridMs.VA.phsB", Identifier.grid_apparent_power_l2, factor=1, unit="VA"),
        Sensor("GridMs.VA.phsC", Identifier.grid_apparent_power_l3, factor=1, unit="VA"),
        Sensor("GridMs.VAr.phsA", Identifier.grid_reactive_power_l1, factor=1, unit="var"),
        Sensor("GridMs.VAr.phsB", Identifier.grid_reactive_power_l2, factor=1, unit="var"),
        Sensor("GridMs.VAr.phsC", Identifier.grid_reactive_power_l3, factor=1, unit="var"),
        Sensor("GridMs.W.phsA", Identifier.power_l1, factor=1, unit="W"),
        Sensor("GridMs.W.phsB", Identifier.power_l2, factor=1, unit="W"),
        Sensor("GridMs.W.phsC", Identifier.power_l3, factor=1, unit="W"),
        Sensor("InOut.GI1", None, factor=1, unit=None),  # codespell:ignore
        Sensor("InOut.GO1", None, factor=1, unit=None),  # codespell:ignore
        Sensor("Inverter.VArModCfg.PFCtlVolCfg.Stt", None, factor=1, unit=None),
        Sensor("Inverter.WMax", Identifier.inverter_power_limit, factor=1, unit="W"),
        Sensor("Isolation.FltA", Identifier.insulation_residual_current, factor=1000, unit="mA"),
        Sensor("Isolation.LeakRis", None, factor=1, unit="kOhm"),
        Sensor("Isolation.LeakRis", None, factor=1, unit=None),
        Sensor("Metering.GridMs.A.phsA", Identifier.current_l1, factor=1, unit="A"),
        Sensor("Metering.GridMs.A.phsB", Identifier.current_l2, factor=1, unit="A"),
        Sensor("Metering.GridMs.A.phsC", Identifier.current_l3, factor=1, unit="A"),
        Sensor("Metering.GridMs.Hz", Identifier.frequency, factor=1, unit="Hz"),
        Sensor("Metering.GridMs.PhV.phsA", Identifier.voltage_l1, factor=1, unit="V"),
        Sensor("Metering.GridMs.PhV.phsB", Identifier.voltage_l2, factor=1, unit="V"),
        Sensor("Metering.GridMs.PhV.phsC", Identifier.voltage_l3, factor=1, unit="V"),
        Sensor("Metering.GridMs.TotPF", None, factor=1, unit=None),
        Sensor("Metering.GridMs.TotWhIn.Bat", Identifier.battery_charge_total, factor=1000, unit="kWh"),
        Sensor("Metering.GridMs.TotWhIn.ChaSta", Identifier.charging_station_total_absorbed, factor=1000, unit="kWh"),
        Sensor("Metering.GridMs.TotWhIn", Identifier.metering_total_absorbed, factor=1000, unit="kWh"),
        # Sensor("Metering.GridMs.TotWhIn", Identifier.metering_total_yield, factor=1000, unit="kWh"),
        Sensor("Metering.GridMs.TotWhOut.Bat", Identifier.battery_discharge_total, factor=1000, unit="kWh"),
        Sensor("Metering.GridMs.TotWhOut", Identifier.metering_total_consumption, factor=1000, unit="kWh"),
        Sensor("Metering.GridMs.TotWIn.ChaSta", Identifier.charging_station_power_absorbed, factor=1, unit="W"),
        Sensor("Metering.GridMs.TotWIn", Identifier.metering_power_absorbed, factor=1, unit="W"),
        Sensor("Metering.GridMs.TotWOut", Identifier.metering_power_supplied, factor=1, unit="W"),
        Sensor("Metering.GridMs.VA.phsA", Identifier.grid_apparent_power_l1, factor=1, unit="VA"),
        Sensor("Metering.GridMs.VA.phsB", Identifier.grid_apparent_power_l2, factor=1, unit="VA"),
        Sensor("Metering.GridMs.VA.phsC", Identifier.grid_apparent_power_l3, factor=1, unit="VA"),
        Sensor("Metering.GridMs.VAr.phsA", Identifier.grid_reactive_power_l1, factor=1, unit="var"),
        Sensor("Metering.GridMs.VAr.phsB", Identifier.grid_reactive_power_l2, factor=1, unit="var"),
        Sensor("Metering.GridMs.VAr.phsC", Identifier.grid_reactive_power_l3, factor=1, unit="var"),
        Sensor("Metering.GridMs.W.phsA", Identifier.power_l1, factor=1, unit="W"),
        Sensor("Metering.GridMs.W.phsB", Identifier.power_l2, factor=1, unit="W"),
        Sensor("Metering.GridMs.W.phsC", Identifier.power_l3, factor=1, unit="W"),
        Sensor("Metering.TotFeedTms", None),
        Sensor("Metering.TotFeedTms", None, factor=1, unit=None),
        Sensor("Metering.TotOpTms", None),
        Sensor("Metering.TotOpTms", None, factor=1, unit=None),
        Sensor("Metering.TotWhIn", None, factor=1, unit=None),
        Sensor("Metering.TotWhOut", Identifier.total_yield, factor=1000, unit="kWh"),
        Sensor("Metering.TotWhOut.Pv", Identifier.pv_gen_meter, factor=1000, unit="kWh"),
        Sensor("Nameplate.CmpMain.HwRev", None, factor=1, unit=None),
        Sensor("Nameplate.CmpMain.Rev", None, factor=1, unit=None),
        Sensor("Nameplate.CmpOS.SwRev", None, factor=1, unit=None),
        Sensor("Nameplate.Location", None, factor=1, unit=None),
        Sensor("Nameplate.MainModel", None, factor=1, unit=None),
        Sensor("Nameplate.Model", None, factor=1, unit=None),
        Sensor("Nameplate.ModelStr", None, factor=1, unit=None),
        Sensor("Nameplate.PkgRev", None, factor=1, unit=None),
        Sensor("Nameplate.SerNum", None, factor=1, unit=None),
        Sensor("Nameplate.Vendor", None, factor=1, unit=None),
        Sensor("Operation.Bat.Health", None, factor=1, unit=None),
        Sensor("Operation.BckStt", None, factor=1, unit=None),
        Sensor("Operation.DrtStt", None, factor=1, unit=None),
        Sensor("Operation.EVeh.ChaStt", Identifier.operating_status, factor=1, unit=None, mapper=SMATagList),
        Sensor("Operation.EVeh.Health", Identifier.status, factor=1, unit=None, mapper=SMATagList),
        Sensor("Operation.EvtCntIstl", None, factor=1, unit=None),
        Sensor("Operation.EvtCntUsr", None, factor=1, unit=None),
        Sensor("Operation.Evt.Dsc", None, factor=1, unit=None),
        Sensor("Operation.Evt.EvtNo", None, factor=1, unit=None),
        Sensor("Operation.Evt.Msg", None, factor=1, unit=None),
        Sensor("Operation.GriSwCnt", None, factor=1, unit=None),
        Sensor("Operation.GriSwStt", Identifier.grid_relay_status, unit=None, mapper=SMATagList),
        Sensor("Operation.Health", Identifier.status, factor=1, unit=None, mapper=SMATagList),
        Sensor("Operation.HealthStt.Alm", None, factor=1, unit=None),
        Sensor("Operation.HealthStt.Ok", None, factor=1, unit=None),
        Sensor("Operation.HealthStt.Wrn", None, factor=1, unit=None),
        Sensor("Operation.OpStt", Identifier.operating_status_genereal, unit=None, mapper=SMATagList),
        Sensor("Operation.PvGriConn", None, factor=1, unit=None),
        Sensor("Operation.RstrLokStt", None, factor=1, unit=None),
        Sensor("Operation.RunStt", None, factor=1, unit=None),
        Sensor("Operation.StandbyStt", None, factor=1, unit=None),
        Sensor("Operation.VArCtl.VArModAct", None, factor=1, unit=None),
        Sensor("Operation.VArCtl.VArModStt", None, factor=1, unit=None),
        Sensor("Operation.WMaxLimNom", None, factor=1, unit=None),
        Sensor("Operation.WMaxLimSrc", None, factor=1, unit=None),
        Sensor("Operation.WMinLimSrc", None, factor=1, unit=None),
        Sensor("Portal.EnnexOS.ConnStt", None, factor=1, unit=None),
        Sensor("PvGen.PvWh", None, factor=1, unit=None),
        Sensor("PvGen.PvW", None, factor=1, unit=None),
        Sensor("Setpoint.PlantControl.CmpBMS.OpMod.1", None, factor=1, unit=None),
        Sensor("Setpoint.PlantControl.InOut.GO1", None, factor=1, unit=None),  # codespell:ignore
        Sensor("Spdwr.ActlDnsSrvIp", None, factor=1, unit=None),
        Sensor("Spdwr.ActlGwIp", None, factor=1, unit=None),
        Sensor("Spdwr.ActlIp", None, factor=1, unit=None),
        Sensor("Spdwr.ActlSnetMsk", None, factor=1, unit=None),
        Sensor("Spdwr.AutoCfgIsOn", None, factor=1, unit=None),
        Sensor("Spdwr.ComSocA.Stt", None, factor=1, unit=None),
        Sensor("Spdwr.IgmpQryTms", None, factor=1, unit=None),
        Sensor("Spdwr.IgmpQryTx", None, factor=1, unit=None),
        Sensor("SunSpecSig.SunSpecTx.1", None, factor=1, unit=None),
        Sensor("SwCmp.CmpEnnexOS.Frwk.SwRev", None, factor=1, unit=None),
        Sensor("Sys.DevRstr", None, factor=1, unit=None),
        Sensor("Upd.AutoUpdIsOn", None, factor=1, unit=None),
        Sensor("Upd.Stt", None, factor=1, unit=None),
        Sensor("WebConn.IsOn", None, factor=1, unit=None),
        Sensor("WebConn.Stt", None, factor=1, unit=None),
        Sensor("WebConn.SwRev", None, factor=1, unit=None),
        Sensor("Wl.AcqStt", None, factor=1, unit=None),
        Sensor("Wl.AntMod", None, factor=1, unit=None),
        Sensor("Wl.ConnStt", None, factor=1, unit=None),
        Sensor("Wl.SigPwr", None, factor=1, unit=None),
        Sensor("Wl.SoftAcsConnStt", None, factor=1, unit=None),
        Sensor("Operation.Bat.Health.1", Identifier.battery_status_operating_mode, factor=1, mapper=SMATagList),

        Sensor("Operation.Dmd.WCtl", Identifier.active_power_limitation, factor=1, unit="W"),
        Sensor("InOut.DigIn.CurWCtlNom", Identifier.power_limit_via_io, factor=1, unit="%"),  # codespell:ignore
        Sensor("Inverter.WMaxIn", Identifier.power_limit_in, factor=1, unit="W"),
        Sensor("Metering.DyWhOut", Identifier.daily_yield, factor=1, unit="Wh")
]
# fmt: on
name2sensor = {i.key: i for i in enneoxSensors}


def getSensorForDevice(productTagId: int) -> tuple[list[Sensor], list[str]] | None:
    """Return the profile for a device"""
    for profil in ennexosSensorProfiles:
        if productTagId in profil[0]:
            unknown: list[str] = []
            expected_sensors: list[Sensor] = []
            for sName in profil[1]:
                sensor = name2sensor.get(sName, None)
                if sensor:
                    expected_sensors.append(sensor)
                else:
                    # Sensors that have not yet been integrated into pysma
                    unknown.append(sName)
            return (expected_sensors, unknown)
    return None
