# This file was auto-generated by Fern from our API Definition.

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .jobs.client import AsyncJobsClient, JobsClient
from .raw_client import AsyncRawAccountUpdaterClient, RawAccountUpdaterClient
from .real_time.client import AsyncRealTimeClient, RealTimeClient


class AccountUpdaterClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAccountUpdaterClient(client_wrapper=client_wrapper)
        self.jobs = JobsClient(client_wrapper=client_wrapper)

        self.real_time = RealTimeClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAccountUpdaterClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAccountUpdaterClient
        """
        return self._raw_client


class AsyncAccountUpdaterClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAccountUpdaterClient(client_wrapper=client_wrapper)
        self.jobs = AsyncJobsClient(client_wrapper=client_wrapper)

        self.real_time = AsyncRealTimeClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAccountUpdaterClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAccountUpdaterClient
        """
        return self._raw_client
