# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.account_updater_job import AccountUpdaterJob
from ...types.account_updater_job_list import AccountUpdaterJobList
from .raw_client import AsyncRawJobsClient, RawJobsClient


class JobsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawJobsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawJobsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawJobsClient
        """
        return self._raw_client

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> AccountUpdaterJob:
        """
        Returns the account updater batch job

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountUpdaterJob
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.account_updater.jobs.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def list(
        self,
        *,
        size: typing.Optional[int] = None,
        start: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AccountUpdaterJobList:
        """
        Returns a list of account updater batch jobs

        Parameters
        ----------
        size : typing.Optional[int]
            The maximum number of jobs to return

        start : typing.Optional[str]
            Cursor for pagination

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountUpdaterJobList
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.account_updater.jobs.list()
        """
        _response = self._raw_client.list(size=size, start=start, request_options=request_options)
        return _response.data

    def create(self, *, request_options: typing.Optional[RequestOptions] = None) -> AccountUpdaterJob:
        """
        Returns the created account updater batch job

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountUpdaterJob
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.account_updater.jobs.create()
        """
        _response = self._raw_client.create(request_options=request_options)
        return _response.data


class AsyncJobsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawJobsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawJobsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawJobsClient
        """
        return self._raw_client

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> AccountUpdaterJob:
        """
        Returns the account updater batch job

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountUpdaterJob
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.account_updater.jobs.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def list(
        self,
        *,
        size: typing.Optional[int] = None,
        start: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AccountUpdaterJobList:
        """
        Returns a list of account updater batch jobs

        Parameters
        ----------
        size : typing.Optional[int]
            The maximum number of jobs to return

        start : typing.Optional[str]
            Cursor for pagination

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountUpdaterJobList
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.account_updater.jobs.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(size=size, start=start, request_options=request_options)
        return _response.data

    async def create(self, *, request_options: typing.Optional[RequestOptions] = None) -> AccountUpdaterJob:
        """
        Returns the created account updater batch job

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountUpdaterJob
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.account_updater.jobs.create()


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request_options=request_options)
        return _response.data
