# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.account_updater_real_time_response import AccountUpdaterRealTimeResponse
from .raw_client import AsyncRawRealTimeClient, RawRealTimeClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RealTimeClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawRealTimeClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawRealTimeClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawRealTimeClient
        """
        return self._raw_client

    def invoke(
        self,
        *,
        token_id: str,
        expiration_year: typing.Optional[int] = OMIT,
        expiration_month: typing.Optional[int] = OMIT,
        deduplicate_token: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AccountUpdaterRealTimeResponse:
        """
        Returns the update result

        Parameters
        ----------
        token_id : str
            Card Token identifier

        expiration_year : typing.Optional[int]
            The 4-digit expiration year of the account number. Not required if the card token already stores this value.

        expiration_month : typing.Optional[int]
            The 2-digit expiration month of the account number. Not required if the card token already stores this value.

        deduplicate_token : typing.Optional[bool]
            Whether deduplication should be enabled when creating the new token. Uses the value of the Deduplicate Tokens setting on the tenant if not set.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountUpdaterRealTimeResponse
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.account_updater.real_time.invoke(
            token_id="9a420b15-ddfe-4793-9466-48f53520e47c",
        )
        """
        _response = self._raw_client.invoke(
            token_id=token_id,
            expiration_year=expiration_year,
            expiration_month=expiration_month,
            deduplicate_token=deduplicate_token,
            request_options=request_options,
        )
        return _response.data


class AsyncRealTimeClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawRealTimeClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawRealTimeClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawRealTimeClient
        """
        return self._raw_client

    async def invoke(
        self,
        *,
        token_id: str,
        expiration_year: typing.Optional[int] = OMIT,
        expiration_month: typing.Optional[int] = OMIT,
        deduplicate_token: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AccountUpdaterRealTimeResponse:
        """
        Returns the update result

        Parameters
        ----------
        token_id : str
            Card Token identifier

        expiration_year : typing.Optional[int]
            The 4-digit expiration year of the account number. Not required if the card token already stores this value.

        expiration_month : typing.Optional[int]
            The 2-digit expiration month of the account number. Not required if the card token already stores this value.

        deduplicate_token : typing.Optional[bool]
            Whether deduplication should be enabled when creating the new token. Uses the value of the Deduplicate Tokens setting on the tenant if not set.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountUpdaterRealTimeResponse
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.account_updater.real_time.invoke(
                token_id="9a420b15-ddfe-4793-9466-48f53520e47c",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.invoke(
            token_id=token_id,
            expiration_year=expiration_year,
            expiration_month=expiration_month,
            deduplicate_token=deduplicate_token,
            request_options=request_options,
        )
        return _response.data
