# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.apple_pay_create_response import ApplePayCreateResponse
from ..types.apple_pay_method_token import ApplePayMethodToken
from ..types.apple_pay_token import ApplePayToken
from .domain.client import AsyncDomainClient, DomainClient
from .raw_client import AsyncRawApplePayClient, RawApplePayClient
from .session.client import AsyncSessionClient, SessionClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ApplePayClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawApplePayClient(client_wrapper=client_wrapper)
        self.domain = DomainClient(client_wrapper=client_wrapper)

        self.session = SessionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawApplePayClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawApplePayClient
        """
        return self._raw_client

    def create(
        self,
        *,
        expires_at: typing.Optional[str] = OMIT,
        apple_payment_data: typing.Optional[ApplePayMethodToken] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApplePayCreateResponse:
        """
        Parameters
        ----------
        expires_at : typing.Optional[str]

        apple_payment_data : typing.Optional[ApplePayMethodToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApplePayCreateResponse
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.apple_pay.create()
        """
        _response = self._raw_client.create(
            expires_at=expires_at, apple_payment_data=apple_payment_data, request_options=request_options
        )
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ApplePayToken:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApplePayToken
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.apple_pay.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def unlink(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> str:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        str
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.apple_pay.unlink(
            id="id",
        )
        """
        _response = self._raw_client.unlink(id, request_options=request_options)
        return _response.data


class AsyncApplePayClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawApplePayClient(client_wrapper=client_wrapper)
        self.domain = AsyncDomainClient(client_wrapper=client_wrapper)

        self.session = AsyncSessionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawApplePayClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawApplePayClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        expires_at: typing.Optional[str] = OMIT,
        apple_payment_data: typing.Optional[ApplePayMethodToken] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApplePayCreateResponse:
        """
        Parameters
        ----------
        expires_at : typing.Optional[str]

        apple_payment_data : typing.Optional[ApplePayMethodToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApplePayCreateResponse
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.apple_pay.create()


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            expires_at=expires_at, apple_payment_data=apple_payment_data, request_options=request_options
        )
        return _response.data

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ApplePayToken:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApplePayToken
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.apple_pay.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def unlink(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> str:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        str
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.apple_pay.unlink(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.unlink(id, request_options=request_options)
        return _response.data
