# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.apple_pay_domain_registration_response import ApplePayDomainRegistrationResponse
from .raw_client import AsyncRawDomainClient, RawDomainClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DomainClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDomainClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDomainClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDomainClient
        """
        return self._raw_client

    def deregister(self, *, domain: str, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        domain : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.apple_pay.domain.deregister(
            domain="domain",
        )
        """
        _response = self._raw_client.deregister(domain=domain, request_options=request_options)
        return _response.data

    def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> ApplePayDomainRegistrationResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApplePayDomainRegistrationResponse
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.apple_pay.domain.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def register(
        self, *, domain: str, request_options: typing.Optional[RequestOptions] = None
    ) -> ApplePayDomainRegistrationResponse:
        """
        Parameters
        ----------
        domain : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApplePayDomainRegistrationResponse
            Accepted

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.apple_pay.domain.register(
            domain="domain",
        )
        """
        _response = self._raw_client.register(domain=domain, request_options=request_options)
        return _response.data

    def register_all(
        self,
        *,
        domains: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApplePayDomainRegistrationResponse:
        """
        Parameters
        ----------
        domains : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApplePayDomainRegistrationResponse
            Accepted

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.apple_pay.domain.register_all()
        """
        _response = self._raw_client.register_all(domains=domains, request_options=request_options)
        return _response.data


class AsyncDomainClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDomainClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDomainClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDomainClient
        """
        return self._raw_client

    async def deregister(self, *, domain: str, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        domain : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.apple_pay.domain.deregister(
                domain="domain",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.deregister(domain=domain, request_options=request_options)
        return _response.data

    async def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ApplePayDomainRegistrationResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApplePayDomainRegistrationResponse
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.apple_pay.domain.get()


        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def register(
        self, *, domain: str, request_options: typing.Optional[RequestOptions] = None
    ) -> ApplePayDomainRegistrationResponse:
        """
        Parameters
        ----------
        domain : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApplePayDomainRegistrationResponse
            Accepted

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.apple_pay.domain.register(
                domain="domain",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.register(domain=domain, request_options=request_options)
        return _response.data

    async def register_all(
        self,
        *,
        domains: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApplePayDomainRegistrationResponse:
        """
        Parameters
        ----------
        domains : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApplePayDomainRegistrationResponse
            Accepted

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.apple_pay.domain.register_all()


        asyncio.run(main())
        """
        _response = await self._raw_client.register_all(domains=domains, request_options=request_options)
        return _response.data
