# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.application_key import ApplicationKey
from .raw_client import AsyncRawApplicationKeysClient, RawApplicationKeysClient


class ApplicationKeysClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawApplicationKeysClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawApplicationKeysClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawApplicationKeysClient
        """
        return self._raw_client

    def list(
        self,
        id_: str,
        *,
        id: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        type: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ApplicationKey]:
        """
        Parameters
        ----------
        id_ : str

        id : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        type : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ApplicationKey]
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.application_keys.list(
            id_="id",
        )
        """
        _response = self._raw_client.list(id_, id=id, type=type, request_options=request_options)
        return _response.data

    def create(
        self,
        id: str,
        *,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApplicationKey:
        """
        Parameters
        ----------
        id : str

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApplicationKey
            Created

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.application_keys.create(
            id="id",
        )
        """
        _response = self._raw_client.create(id, idempotency_key=idempotency_key, request_options=request_options)
        return _response.data

    def get(self, id: str, key_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ApplicationKey:
        """
        Parameters
        ----------
        id : str

        key_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApplicationKey
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.application_keys.get(
            id="id",
            key_id="keyId",
        )
        """
        _response = self._raw_client.get(id, key_id, request_options=request_options)
        return _response.data

    def delete(self, id: str, key_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str

        key_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.application_keys.delete(
            id="id",
            key_id="keyId",
        )
        """
        _response = self._raw_client.delete(id, key_id, request_options=request_options)
        return _response.data


class AsyncApplicationKeysClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawApplicationKeysClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawApplicationKeysClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawApplicationKeysClient
        """
        return self._raw_client

    async def list(
        self,
        id_: str,
        *,
        id: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        type: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ApplicationKey]:
        """
        Parameters
        ----------
        id_ : str

        id : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        type : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ApplicationKey]
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.application_keys.list(
                id_="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(id_, id=id, type=type, request_options=request_options)
        return _response.data

    async def create(
        self,
        id: str,
        *,
        idempotency_key: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApplicationKey:
        """
        Parameters
        ----------
        id : str

        idempotency_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApplicationKey
            Created

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.application_keys.create(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(id, idempotency_key=idempotency_key, request_options=request_options)
        return _response.data

    async def get(
        self, id: str, key_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ApplicationKey:
        """
        Parameters
        ----------
        id : str

        key_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApplicationKey
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.application_keys.get(
                id="id",
                key_id="keyId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, key_id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, key_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str

        key_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.application_keys.delete(
                id="id",
                key_id="keyId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, key_id, request_options=request_options)
        return _response.data
