# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.apple_pay_method_token import ApplePayMethodToken
from ...types.apple_pay_tokenize_response import ApplePayTokenizeResponse
from .domain.client import AsyncDomainClient, DomainClient
from .raw_client import AsyncRawApplePayClient, RawApplePayClient
from .session.client import AsyncSessionClient, SessionClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ApplePayClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawApplePayClient(client_wrapper=client_wrapper)
        self.domain = DomainClient(client_wrapper=client_wrapper)

        self.session = SessionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawApplePayClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawApplePayClient
        """
        return self._raw_client

    def tokenize(
        self,
        *,
        apple_payment_method_token: typing.Optional[ApplePayMethodToken] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApplePayTokenizeResponse:
        """
        Parameters
        ----------
        apple_payment_method_token : typing.Optional[ApplePayMethodToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApplePayTokenizeResponse
            Created

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.connection.apple_pay.tokenize()
        """
        _response = self._raw_client.tokenize(
            apple_payment_method_token=apple_payment_method_token, request_options=request_options
        )
        return _response.data


class AsyncApplePayClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawApplePayClient(client_wrapper=client_wrapper)
        self.domain = AsyncDomainClient(client_wrapper=client_wrapper)

        self.session = AsyncSessionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawApplePayClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawApplePayClient
        """
        return self._raw_client

    async def tokenize(
        self,
        *,
        apple_payment_method_token: typing.Optional[ApplePayMethodToken] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApplePayTokenizeResponse:
        """
        Parameters
        ----------
        apple_payment_method_token : typing.Optional[ApplePayMethodToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApplePayTokenizeResponse
            Created

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.connection.apple_pay.tokenize()


        asyncio.run(main())
        """
        _response = await self._raw_client.tokenize(
            apple_payment_method_token=apple_payment_method_token, request_options=request_options
        )
        return _response.data
