# This file was auto-generated by Fern from our API Definition.

import typing

from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ....core.request_options import RequestOptions
from .raw_client import AsyncRawSessionClient, RawSessionClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SessionClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSessionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSessionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSessionClient
        """
        return self._raw_client

    def create(
        self,
        *,
        validation_url: typing.Optional[str] = OMIT,
        display_name: typing.Optional[str] = OMIT,
        domain: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> str:
        """
        Parameters
        ----------
        validation_url : typing.Optional[str]

        display_name : typing.Optional[str]

        domain : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        str
            Success

        Examples
        --------
        from basis_theory import BasisTheory

        client = BasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )
        client.connection.apple_pay.session.create()
        """
        _response = self._raw_client.create(
            validation_url=validation_url, display_name=display_name, domain=domain, request_options=request_options
        )
        return _response.data


class AsyncSessionClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSessionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSessionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSessionClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        validation_url: typing.Optional[str] = OMIT,
        display_name: typing.Optional[str] = OMIT,
        domain: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> str:
        """
        Parameters
        ----------
        validation_url : typing.Optional[str]

        display_name : typing.Optional[str]

        domain : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        str
            Success

        Examples
        --------
        import asyncio

        from basis_theory import AsyncBasisTheory

        client = AsyncBasisTheory(
            correlation_id="YOUR_CORRELATION_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.connection.apple_pay.session.create()


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            validation_url=validation_url, display_name=display_name, domain=domain, request_options=request_options
        )
        return _response.data
