# This file was auto-generated by Fern from our API Definition.

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .apple_pay.client import ApplePayClient, AsyncApplePayClient
from .raw_client import AsyncRawConnectionClient, RawConnectionClient


class ConnectionClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawConnectionClient(client_wrapper=client_wrapper)
        self.apple_pay = ApplePayClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawConnectionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawConnectionClient
        """
        return self._raw_client


class AsyncConnectionClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawConnectionClient(client_wrapper=client_wrapper)
        self.apple_pay = AsyncApplePayClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawConnectionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawConnectionClient
        """
        return self._raw_client
